%%
%% This is file `rub-kunstgeschichte.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% rub-kunstgeschichte.dtx  (with options: `class')
%% 
%% This is a generated file.
%% 
%% Copyright (C) 2024 by Joran Schneyer <joran.schneyer@ruhr-uni-bochum.de>
%% 
%% This work may be distributed and/or modified under the
%% conditions of the LaTeX Project Public License, either version 1.3c
%% of this license or (at your option) any later version.
%% The latest version of this license is in
%%   https://www.latex-project.org/lppl.txt
%% and version 1.3c or later is part of all distributions of LaTeX
%% version 2008 or later.
%% 
%% This work has the LPPL maintenance status `maintained'.
%% 
%% The Current Maintainer of this work is Joran Schneyer <joran.schneyer@ruhr-uni-bochum.de>.
%% 
%% This work consists of the files rub-kunstgeschichte.dtx
%%                                 rub-kunstgeschichte.ins
%%           and the derived files rub-kunstgeschichte.cls
%%                                 rub-kunstgeschichte-example.tex
%% 

\NeedsTeXFormat{LaTeX2e}[2022-06-01]
\ProvidesClass{rub-kunstgeschichte}
    [2024-09-06 v0.2.0 RUB Kunstgeschichte class]
%% Class options
\DeclareKeys[rubkgi]{
    biblatex.store = \@rubkgi@biblatexOptions,
    biblatex.usage = load
}
\DeclareKeys[rubkgi]{
    hyperref.code  = \PassOptionsToPackage{#1}{hyperref},
    hyperref.usage = load
}
%% TeX switch to decide wether to load the parskip package
\newif\if@rubkgi@parskip
\@rubkgi@parskiptrue
\DeclareKeys[rubkgi]{
    parskip.if      = @rubkgi@parskip,
    parskip.usage   = load,
    noparskip.ifnot = @rubkgi@parskip,
    noparskip.usage = load
}
\ProcessKeyOptions[rubkgi]
%% Load base class with 12pt base font size
\LoadClass[12pt]{article}
%% biblatex options
\PassOptionsToPackage{
    backend=biber,
    singletitle=true,
    autocite=footnote,
    autopunct=false
}{biblatex}
%% biblatex-dw package
\PassOptionsToPackage{
    style=authortitle-dw,
    firstfull=true,
    addyear=true
}{biblatex}
%% pass biblatex class options along
\PassOptionsToPackage{\@rubkgi@biblatexOptions}{biblatex}
%% load biblatex
\RequirePackage{biblatex}
%% Set 1.5 times line spacing
\RequirePackage[onehalfspacing]{setspace}
%% Set a4 paper size and margins
\RequirePackage[
    a4paper,
    top=2cm,left=2cm,bottom=2cm,right=4cm
]{geometry}
%% Avoid paragraph indentation
\if@rubkgi@parskip
    \RequirePackage{parskip}
\fi
%% Hyperref
\RequirePackage{hyperref}
\hypersetup{hidelinks=true}

\endinput
%%
%% End of file `rub-kunstgeschichte.cls'.
