/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.internal.ColorSpaceUtilsKt;
import com.github.ajalt.colormath.model.Ansi256;
import com.github.ajalt.colormath.model.CMYK;
import com.github.ajalt.colormath.model.HPLuv;
import com.github.ajalt.colormath.model.HSL;
import com.github.ajalt.colormath.model.HSLuv;
import com.github.ajalt.colormath.model.HSV;
import com.github.ajalt.colormath.model.HWB;
import com.github.ajalt.colormath.model.ICtCp;
import com.github.ajalt.colormath.model.JzAzBz;
import com.github.ajalt.colormath.model.JzCzHz;
import com.github.ajalt.colormath.model.LAB;
import com.github.ajalt.colormath.model.LCHab;
import com.github.ajalt.colormath.model.LCHuv;
import com.github.ajalt.colormath.model.LUV;
import com.github.ajalt.colormath.model.Oklab;
import com.github.ajalt.colormath.model.Oklch;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.RGBColorSpace;
import com.github.ajalt.colormath.model.XYZ;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0001H\u0016J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0017\u001a\u00020\u0000H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00000\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/github/ajalt/colormath/model/Ansi16;", "Lcom/github/ajalt/colormath/Color;", "code", "", "(I)V", "alpha", "", "getAlpha", "()F", "getCode", "()I", "space", "Lcom/github/ajalt/colormath/ColorSpace;", "getSpace", "()Lcom/github/ajalt/colormath/ColorSpace;", "clamp", "component1", "copy", "equals", "", "other", "", "hashCode", "toAnsi16", "toAnsi256", "Lcom/github/ajalt/colormath/model/Ansi256;", "toArray", "", "toSRGB", "Lcom/github/ajalt/colormath/model/RGB;", "toString", "", "Companion", "colormath"})
public final class Ansi16
implements Color {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int code;
    @NotNull
    private static final List<ColorComponentInfo> components;

    public Ansi16(int code) {
        this.code = code;
    }

    public final int getCode() {
        return this.code;
    }

    @Override
    public float getAlpha() {
        return 1.0f;
    }

    @NotNull
    public ColorSpace<Ansi16> getSpace() {
        return Companion;
    }

    @Override
    @NotNull
    public RGB toSRGB() {
        switch (this.code) {
            case 30: 
            case 40: {
                return RGBColorSpace.DefaultImpls.invoke$default((RGBColorSpace)RGB.Companion, 0.0f, 0.0f, 0.0f, 0.0f, 8, null);
            }
            case 90: 
            case 100: {
                return RGBColorSpace.DefaultImpls.from255$default(RGB.Companion, 128, 128, 128, 0, 8, null);
            }
            case 37: 
            case 47: {
                return RGBColorSpace.DefaultImpls.from255$default(RGB.Companion, 192, 192, 192, 0, 8, null);
            }
            case 97: 
            case 107: {
                return RGBColorSpace.DefaultImpls.invoke$default((RGBColorSpace)RGB.Companion, 1.0f, 1.0f, 1.0f, 0.0f, 8, null);
            }
        }
        int color = this.code % 10;
        float mul = this.code > 50 ? 1.0f : 0.5f;
        float r = (float)(color % 2) * mul;
        float g = (float)(color / 2 % 2) * mul;
        float b = (float)(color / 4 % 2) * mul;
        return RGBColorSpace.DefaultImpls.invoke$default((RGBColorSpace)RGB.Companion, r, g, b, 0.0f, 8, null);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return this.code >= 90 ? new Ansi256(this.code - 90 + 8) : new Ansi256(this.code - 30);
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return this;
    }

    @Override
    @NotNull
    public float[] toArray() {
        float[] fArray = new float[]{this.code, this.getAlpha()};
        return fArray;
    }

    @Override
    @NotNull
    public Color clamp() {
        Color color;
        block1: {
            int n;
            block2: {
                block0: {
                    if (this.code >= 30) break block0;
                    color = new Ansi16(30);
                    break block1;
                }
                n = this.code;
                boolean bl = 38 <= n ? n < 40 : false;
                if (!bl) break block2;
                color = new Ansi16(40);
                break block1;
            }
            n = this.code;
            color = (48 <= n ? n < 90 : false) ? (Color)new Ansi16(40) : ((98 <= (n = this.code) ? n < 100 : false) ? (Color)new Ansi16(100) : (this.code > 107 ? (Color)new Ansi16(107) : (Color)this));
        }
        return color;
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return Color.DefaultImpls.toHSL(this);
    }

    @Override
    @NotNull
    public HSV toHSV() {
        return Color.DefaultImpls.toHSV(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return Color.DefaultImpls.toCMYK(this);
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        return Color.DefaultImpls.toXYZ(this);
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return Color.DefaultImpls.toLAB(this);
    }

    @Override
    @NotNull
    public LCHab toLCHab() {
        return Color.DefaultImpls.toLCHab(this);
    }

    @Override
    @NotNull
    public LUV toLUV() {
        return Color.DefaultImpls.toLUV(this);
    }

    @Override
    @NotNull
    public LCHuv toLCHuv() {
        return Color.DefaultImpls.toLCHuv(this);
    }

    @Override
    @NotNull
    public HWB toHWB() {
        return Color.DefaultImpls.toHWB(this);
    }

    @Override
    @NotNull
    public Oklab toOklab() {
        return Color.DefaultImpls.toOklab(this);
    }

    @Override
    @NotNull
    public Oklch toOklch() {
        return Color.DefaultImpls.toOklch(this);
    }

    @Override
    @NotNull
    public JzAzBz toJzAzBz() {
        return Color.DefaultImpls.toJzAzBz(this);
    }

    @Override
    @NotNull
    public JzCzHz toJzCzHz() {
        return Color.DefaultImpls.toJzCzHz(this);
    }

    @Override
    @NotNull
    public ICtCp toICtCp() {
        return Color.DefaultImpls.toICtCp(this);
    }

    @Override
    @NotNull
    public HSLuv toHSLuv() {
        return Color.DefaultImpls.toHSLuv(this);
    }

    @Override
    @NotNull
    public HPLuv toHPLuv() {
        return Color.DefaultImpls.toHPLuv(this);
    }

    public final int component1() {
        return this.code;
    }

    @NotNull
    public final Ansi16 copy(int code) {
        return new Ansi16(code);
    }

    public static /* synthetic */ Ansi16 copy$default(Ansi16 ansi16, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = ansi16.code;
        }
        return ansi16.copy(n);
    }

    @NotNull
    public String toString() {
        return "Ansi16(code=" + this.code + ')';
    }

    public int hashCode() {
        return Integer.hashCode(this.code);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Ansi16)) {
            return false;
        }
        Ansi16 ansi16 = (Ansi16)other;
        return this.code == ansi16.code;
    }

    static {
        ColorComponentInfo[] colorComponentInfoArray = new ColorComponentInfo[]{new ColorComponentInfo("code", false, 30.0f, 107.0f)};
        components = ColorSpaceUtilsKt.componentInfoList(colorComponentInfoArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/github/ajalt/colormath/model/Ansi16$Companion;", "Lcom/github/ajalt/colormath/ColorSpace;", "Lcom/github/ajalt/colormath/model/Ansi16;", "()V", "components", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "getComponents", "()Ljava/util/List;", "name", "", "getName", "()Ljava/lang/String;", "convert", "color", "Lcom/github/ajalt/colormath/Color;", "create", "", "colormath"})
    @SourceDebugExtension(value={"SMAP\nAnsi16.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Ansi16.kt\ncom/github/ajalt/colormath/model/Ansi16$Companion\n+ 2 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n*L\n1#1,82:1\n15#2,5:83\n*S KotlinDebug\n*F\n+ 1 Ansi16.kt\ncom/github/ajalt/colormath/model/Ansi16$Companion\n*L\n37#1:83,5\n*E\n"})
    public static final class Companion
    implements ColorSpace<Ansi16> {
        private Companion() {
        }

        @Override
        @NotNull
        public String getName() {
            return "Ansi16";
        }

        @Override
        @NotNull
        public List<ColorComponentInfo> getComponents() {
            return components;
        }

        @Override
        @NotNull
        public Ansi16 convert(@NotNull Color color) {
            Intrinsics.checkNotNullParameter(color, "color");
            return color.toAnsi16();
        }

        @Override
        @NotNull
        public Ansi16 create(@NotNull float[] components) {
            Intrinsics.checkNotNullParameter(components, "components");
            ColorSpace $this$withValidComps$iv = this;
            boolean $i$f$withValidComps = false;
            int size$iv = $this$withValidComps$iv.getComponents().size();
            int n = size$iv - 1;
            int n2 = components.length;
            if (!(n <= n2 ? n2 <= size$iv : false)) {
                boolean bl = false;
                String string = "Invalid component array length: " + components.length + ", expected " + (size$iv - 1) + " or " + size$iv;
                throw new IllegalArgumentException(string.toString());
            }
            float[] it = components;
            boolean bl = false;
            return (Ansi16)((Color)new Ansi16((int)it[0]));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

