/* kpse-api.h: for Win32 DLL
    Micorsoft Visual C++ Version 4.0
*/

#ifndef KPSE_API_H
#define KPSE_API_H

#define DllImport __declspec(dllimport)

#include <windows.h>
#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct
{
  UINT length;
  LPTSTR *list;
} str_list_type;

struct str_llist_elt
{
  LPTSTR str;
  BOOL moved;
  struct str_llist_elt *next;
};
typedef struct str_llist_elt str_llist_elt_type;
typedef struct str_llist_elt *str_llist_type;

extern DllImport char *kpathsea_version_string;
extern DllImport char *kpse_bug_address;

extern BOOL WINAPI kpse_absolute_p (LPCTSTR filename, BOOL relative_ok);
extern LPTSTR WINAPI kpse_cnf_get (LPCTSTR var);
extern VOID WINAPI kpse_init_db (VOID);
extern str_list_type * WINAPI kpse_db_search (LPCTSTR name, 
                                      LPCTSTR path_elt, BOOL all);
extern VOID WINAPI kpse_db_insert(LPCTSTR fname);
extern LPTSTR WINAPI kpse_expand_default (LPCTSTR path, LPCTSTR dflt);
extern LPTSTR WINAPI kpse_expand (LPCTSTR s);
extern LPTSTR WINAPI kpse_path_expand (LPCTSTR path);
extern LPTSTR * WINAPI kpse_fontmap_lookup (LPCTSTR key);
extern LPTSTR WINAPI read_line (FILE *f);
extern UINT WINAPI kpse_magstep_fix (UINT dpi, UINT bdpi, LPINT m_ret);
extern LPTSTR WINAPI kpse_path_element (LPCTSTR path);
extern LPTSTR WINAPI kpse_filename_component (LPCTSTR path);
extern str_llist_type * WINAPI kpse_element_dirs (LPCTSTR elt);
extern LPTSTR WINAPI kpse_path_search (LPCTSTR path, LPCTSTR name,
                                       BOOL must_exist);
extern LPTSTR * WINAPI kpse_all_path_search (LPCTSTR path, LPCTSTR name);
extern VOID WINAPI kpse_init_prog (LPCTSTR prefix, UINT dpi, LPCTSTR mode,
                                   LPCTSTR fallback);
extern VOID WINAPI kpse_set_progname (LPCTSTR argv0);
extern LPSTR WINAPI kpse_readable_file (LPCTSTR name);
extern VOID WINAPI kpse_init_fallback_resolutions (LPTSTR envvar);

typedef enum
{
  kpse_gf_format,
  kpse_pk_format,
  kpse_any_glyph_format,	/* ``any'' meaning anything above */
  kpse_afm_format, 
  kpse_base_format, 
  kpse_bib_format, 
  kpse_bst_format, 
  kpse_cnf_format,
  kpse_db_format,
  kpse_fmt_format,
  kpse_fontmap_format,
  kpse_mem_format,
  kpse_mf_format, 
  kpse_mfpool_format, 
  kpse_mft_format, 
  kpse_mp_format, 
  kpse_mppool_format, 
  kpse_mpsupport_format,
  kpse_ocp_format,
  kpse_ofm_format, 
  kpse_opl_format,
  kpse_otp_format,
  kpse_ovf_format,
  kpse_ovp_format,
  kpse_pict_format,
  kpse_tex_format,
  kpse_texdoc_format,
  kpse_texpool_format,
  kpse_texsource_format,
  kpse_tex_ps_header_format,
  kpse_troff_font_format,
  kpse_tfm_format, 
  kpse_type1_format, 
  kpse_vf_format,
  kpse_dvips_config_format,
  kpse_ist_format,
  kpse_last_format /* one past last index */
} kpse_file_format_type;

typedef enum
{
  kpse_src_implicit,   /* C initialization to zero */
  kpse_src_compile,    /* configure/compile-time default */
  kpse_src_texmf_cnf,  /* texmf.cnf, the kpathsea config file */
  kpse_src_client_cnf, /* application config file, e.g., config.ps */
  kpse_src_env,        /* environment variable */
  kpse_src_x,          /* X Window System resource */
  kpse_src_cmdline,    /* command-line option */
} kpse_src_type;

typedef struct
{
  LPCTSTR type;		/* Human-readable description.  */
  LPCTSTR path;		/* The search path to use.  */
  LPCTSTR raw_path;	/* Pre-$~ (but post-default) expansion.  */
  LPCTSTR path_source;	/* Where the path started from.  */
  LPCTSTR override_path;	/* From client environment variable.  */
  LPCTSTR client_path;	/* E.g., from dvips's config.ps.  */
  LPCTSTR cnf_path;	/* From texmf.cnf.  */
  LPCTSTR default_path;	/* If all else fails.  */
  LPCTSTR suffix;		/* For kpse_find_file to check for/append.  */
  LPCTSTR *alt_suffix;	/* More suffixes to check for.  */
  BOOL suffix_search_only;	/* Only search with a suffix?  */
  LPCTSTR program;		/* ``MakeTeXPK'', etc.  */
  LPCTSTR program_args;	/* Args to `program'.  */
  BOOL program_enabled_p;	/* Invoke `program'?  */
  kpse_src_type program_enable_level; /* Who said to invoke `program'.  */
} kpse_format_info_type;

extern VOID WINAPI kpse_set_program_enabled (kpse_file_format_type fmt,
                                             BOOL value, kpse_src_type level);
extern VOID WINAPI kpse_maketex_option (LPCTSTR fmtname,  BOOL value);
extern LPCTSTR WINAPI kpse_init_format (kpse_file_format_type);
extern LPTSTR WINAPI kpse_find_file (LPCTSTR name,  kpse_file_format_type format,
                                     BOOL must_exist);

#define kpse_find_mf(name)   kpse_find_file (name, kpse_mf_format, TRUE)
#define kpse_find_mft(name)  kpse_find_file (name, kpse_mft_format, TRUE)
#define kpse_find_pict(name) kpse_find_file (name, kpse_pict_format, TRUE)
#define kpse_find_tex(name)  kpse_find_file (name, kpse_tex_format, TRUE)
#define kpse_find_tfm(name)  kpse_find_file (name, kpse_tfm_format, TRUE)

#define kpse_find_vf(name) kpse_find_file (name, kpse_vf_format, FALSE)

extern FILE * WINAPI kpse_open_file (LPCTSTR, kpse_file_format_type);

typedef enum
{
  kpse_glyph_source_normal,  /* the searched-for font: already existed */
  kpse_glyph_source_alias,   /* : was an alias for an existing file */
  kpse_glyph_source_maketex, /* : was created on the fly */
  kpse_glyph_source_fallback /* : wasn't found, but the fallback font was */
} kpse_glyph_source_type;

typedef struct
{
  LPTSTR name;			/* font name found */
  UINT dpi;			/* size found, for glyphs */
  kpse_file_format_type format;	/* glyph format found */
  kpse_glyph_source_type source;	/* where we found it */
} kpse_glyph_file_type;		

#define KPSE_GLYPH_FILE_NAME(f) ((f).name)
#define KPSE_GLYPH_FILE_DPI(f) ((f).dpi)
#define KPSE_GLYPH_FILE_FORMAT(f) ((f).format)
#define KPSE_GLYPH_FILE_SOURCE(f) ((f).source)

extern LPTSTR WINAPI kpse_find_glyph (LPCTSTR font_name, UINT dpi, 
                                      kpse_file_format_type format,
                                      kpse_glyph_file_type *glyph_file);

#define kpse_find_pk(font_name, dpi, glyph_file) \
  kpse_find_glyph (font_name, dpi, kpse_pk_format, glyph_file)
#define kpse_find_gf(font_name, dpi, glyph_file) \
  kpse_find_glyph (font_name, dpi, kpse_gf_format, glyph_file)

#define KPSE_BITMAP_TOLERANCE(r) ((r) / 500.0 + 1)

extern BOOL WINAPI kpse_bitmap_tolerance (double dpi1, double dpi2);
extern BOOL WINAPI kpse_tex_hush (LPCTSTR what);
extern LPTSTR WINAPI kpse_make_tex (kpse_file_format_type format,
                                    LPCTSTR base_file);
extern LPTSTR WINAPI kpse_tilde_expand (LPCTSTR filename);
extern LPTSTR WINAPI kpse_truncate_filename (LPCTSTR name);
extern LPTSTR WINAPI kpse_var_value (LPCTSTR var);
extern LPTSTR WINAPI kpse_var_expand (LPCTSTR src);

extern DllImport UINT kpathsea_debug;
extern LPTSTR WINAPI concatn(LPCTSTR str1);
extern DllImport LPTSTR WINAPI concat (LPCTSTR s1, LPCTSTR s2);
extern DllImport LPTSTR WINAPI concat3 (LPCTSTR, LPCTSTR, LPCTSTR);
extern DllImport LPTSTR WINAPI xstrdup (LPCTSTR s);
extern DllImport LPTSTR WINAPI uppercasify (LPCTSTR s);
extern DllImport UINT WINAPI atou (LPCTSTR);
extern DllImport BOOL WINAPI same_file_p (LPCTSTR filename1,
                                          LPCTSTR filename2);

extern DllImport LPCTSTR WINAPI basename (LPCTSTR name);
extern DllImport LPTSTR WINAPI find_suffix (LPCTSTR name);
extern DllImport LPTSTR WINAPI remove_suffix (LPCTSTR name);
extern DllImport LPTSTR WINAPI make_suffix (LPCTSTR s,  LPCTSTR suffix);
extern DllImport LPTSTR WINAPI make_prefix (LPTSTR stem_prefix, LPTSTR name);
extern DllImport LPTSTR WINAPI extend_filename (LPCTSTR name, LPCTSTR suffix);
extern DllImport VOID WINAPI xputenv (LPCTSTR var, LPCTSTR value);
extern DllImport VOID WINAPI xputenv_int (LPCTSTR var, INT value);
extern DllImport LPTSTR WINAPI xgetcwd (VOID);
extern DllImport BOOL WINAPI dir_p (LPCTSTR fn);
extern DllImport INT WINAPI dir_links (LPCTSTR fn);
extern DllImport FILE * WINAPI xfopen (LPCTSTR filename, LPCTSTR mode);
extern DllImport VOID WINAPI xfclose (FILE *, LPCTSTR filename);
extern DllImport VOID WINAPI xfseek (FILE *, LONG, INT, LPTSTR filename);
extern DllImport ULONG WINAPI xftell (FILE *, LPTSTR filename);

extern DllImport LPVOID WINAPI xmalloc (UINT size);
extern DllImport LPVOID WINAPI xrealloc (LPVOID old_address, UINT new_size);
extern DllImport LPVOID WINAPI xcalloc (UINT nelem, UINT elsize);

#define program_invocation_name \
							(*(program_invocation_name_get()))
#define program_invocation_short_name \
							(*(program_invocation_short_name_get()))
#define kpse_fallback_resolutions_string \
							(*(kpse_fallback_resolutions_string_get()))
#define kpse_make_tex_discard_errors \
							(*(kpse_make_tex_discard_errors_get()))
#define kpse_format_info	(kpse_format_info_get())
#define optarg				(*(optarg_get()))
#define optind				(*(optind_get()))

extern LPTSTR * WINAPI program_invocation_name_get(VOID);
extern LPTSTR * WINAPI program_invocation_short_name_get(VOID);
extern LPTSTR * WINAPI kpse_fallback_resolutions_string_get(VOID);
extern kpse_format_info_type * WINAPI kpse_format_info_get(VOID);
extern BOOL * WINAPI kpse_make_tex_discard_errors_get(VOID);
extern LPTSTR * WINAPI optarg_get(void);
extern INT * WINAPI optind_get(void);

typedef long __stdcall KpseCallBack(UINT uMsg, DWORD param1,
                                    DWORD param2, DWORD usr_param);
typedef enum {
  KPSE_CONSOLE_WRITE = 1,
  KPSE_CONSOLE_FLUSH,
  KPSE_TERMINATE = 16,
  KPSE_MAKETEX = 32,
} KpseMessage;

typedef struct {
  kpse_file_format_type format;
  LPCTSTR lpszCmdLine;
  LPCTSTR lpszProgram;
  LPCTSTR lpszFontName;
  DWORD dwDpi;
  DWORD dwModeDpi;
  LPCTSTR lpszMag;
  LPCTSTR lpszMode;
  DWORD dwLen;
  LPTSTR lpszPathName;
} kpse_maketex_type;

extern LPVOID WINAPI kpse_set_context(LPVOID context);
extern LPVOID WINAPI kpse_get_context(VOID);
extern BOOL WINAPI kpse_free_context(LPVOID context);
extern VOID WINAPI kpse_clear_context(VOID);
extern BOOL kpse_set_environment(LPVOID context);
extern VOID WINAPI kpse_set_callback(KpseCallBack *func, DWORD usr_param);
extern LPTSTR WINAPI kpse_dot_expand(LPCTSTR filename);
extern BOOL kpse_change_dir(LPCTSTR dir);

#define KPSE_EXCEPTION(status) ((3<<30)|(1<<29)|('K'<<16)|(status))
#define KPSE_EXCEPTION_EXIT    KPSE_EXCEPTION(1)
#define KPSE_EXCEPTION_ABORT   KPSE_EXCEPTION(3)
#define KPSE_EXCEPTION_MALLOC  KPSE_EXCEPTION(75)
#define KPSE_EXCEPTION_REALLOC KPSE_EXCEPTION(66)

#ifdef __cplusplus
}
#endif

#endif /* not KPSE_API_H */
