/* kpse-dll.h: for Win32 DLL
    Micorsoft Visual C++ Version 4.0
*/

#ifndef KPSE_DLL_H
#define KPSE_DLL_H

#include <kpathsea/kpathsea.h>

#define REG_KEY "Software\\momo\\Kpathsea"
#define CNF_KEY REG_KEY"\\Config"
#define SET_KEY REG_KEY"\\Setting"
#define ENV_KEY REG_KEY"\\Environ"

extern HINSTANCE g_hinstDll;
extern DWORD g_dwTlsIndex;
extern BOOL fRegistry;

extern BOOL read_registry(LPCTSTR subkey,  LPCTSTR var);
#define read_setting(var)  read_registry(SET_KEY, var)

typedef struct
{
  const_string key;
  str_llist_type *value;
} cache_entry;

typedef struct {
  const_string var;
  boolean expanding;
} expansion_type;

typedef long __stdcall KpseCallBack(UINT uMsg, DWORD param1, DWORD param2,
                                    DWORD usr_param);
typedef enum {
  KPSE_CONSOLE_WRITE = 1,
  KPSE_CONSOLE_FLUSH,
  KPSE_TERMINATE = 16,
  KPSE_MAKETEX = 32,
} KpseMessage;

typedef struct {
  kpse_file_format_type format;
  LPCTSTR lpszCmdLine;
  LPCTSTR lpszProgram;
  LPCTSTR lpszFontName;
  DWORD dwDpi;
  DWORD dwModeDpi;
  LPCTSTR lpszMag;
  LPCTSTR lpszMode;
  DWORD dwLen;
  LPTSTR lpszPathName;
} kpse_maketex_type;

typedef struct{
  hash_table_type cnf_hash;									/* cnf.c */
  boolean doing_cnf_init;
  string current_dir;										/* current.c */
  hash_table_type db;										/* db.c	 */
  hash_table_type alias_db;
  str_list_type db_dir_list;
  hash_table_type link_table;								/* dir.c */
  cache_entry *the_cache;									/* elt-dirs.c */
  unsigned cache_length;
  char dirname[MAX_PATH];
  hash_table_type map;										/* fontmap.c */
  const_string map_path;
  char *optarg;												/* getopt.c */
  int optind;
  int __getopt_initialized;
  char *nextchar;
  int opterr;
  int optopt;
  enum {REQUIRE_ORDER, PERMUTE, RETURN_IN_ORDER} ordering;
  char *posixly_correct;
  int first_nonopt;
  int last_nonopt;
  boolean kpse_debug_hash_lookup_int;						/* hash.c */
  string elt;												/* path-elt.c */
  unsigned elt_alloc;
  const_string path;
  boolean first_search;										/* pathsearch.c */
  string program_invocation_name;							/* progname.c */
  string program_invocation_short_name;
  expansion_type *expansions;								/* variable.c */
  unsigned expansion_len;
  const_string kpse_fallback_font;							/* tex-file.c */
  string kpse_fallback_resolutions_string;
  unsigned *kpse_fallback_resolutions;
  kpse_format_info_type kpse_format_info[kpse_last_format];	
  const_string *bitmap_specs;								/* tex-glyph.c */
  boolean kpse_make_tex_discard_errors;						/* tex-make.c */
  const_string *saved_env_items;							/* xputenv.c */
  unsigned saved_env_len;
  HANDLE kpse_heap_handle;									/* kpse-dll.c */
  long ref_count;
  KpseCallBack *callback;									/* callback.c */
  string msgbuf;
  unsigned msglen;
  DWORD usr_param;
} kpse_context_type;

extern void kpse_clear_context(void);
extern LPVOID kpse_set_context(LPVOID context);
extern LPVOID kpse_get_context(VOID);
extern boolean kpse_free_context(LPVOID context);

extern boolean kpse_set_environment(LPVOID context);
extern void kpse_set_callback(KpseCallBack *func, DWORD usr_param);

extern string kpse_dot_expand(const_string filename);
extern boolean kpse_change_dir(const_string dir);

#ifndef _IMPORT
#define kpse_debug_hash_lookup_int \
							kpse_context->kpse_debug_hash_lookup_int
#define program_invocation_name \
							kpse_context->program_invocation_name
#define program_invocation_short_name \
							kpse_context->program_invocation_short_name
#define kpse_fallback_font	kpse_context->kpse_fallback_font
#define kpse_fallback_resolutions_string \
							kpse_context->kpse_fallback_resolutions_string
#define kpse_fallback_resolutions \
							kpse_context->kpse_fallback_resolutions
#define kpse_format_info	kpse_context->kpse_format_info
#define kpse_make_tex_discard_errors \
							kpse_context->kpse_make_tex_discard_errors
#define kpse_heap_handle	kpse_context->kpse_heap_handle
#define optarg				kpse_context->optarg
#define optind				kpse_context->optind
#define opterr				kpse_context->opterr
#define optopt				kpse_context->optopt
#define __getopt_initialized \
							kpse_context->__getopt_initialized
#define msgbuf				kpse_context->msgbuf
#define msglen				kpse_context->msglen
#define callback			kpse_context->callback
#define usr_param			kpse_context->usr_param
#define current_dir			kpse_context->current_dir

#undef free
#define free  xfree
#undef getenv
#define getenv  xgetenv
#undef abort
#define abort  kpse_abort
#undef exit
#define exit  kpse_exit
#undef fprintf
#define fprintf  kpse_fprintf
#undef fputs
#define fputs  kpse_fputs
#undef putc
#define putc  kpse_fputc
#undef fflush
#define fflush  kpse_fflush
#undef perror
#define perror  kpse_perror

extern void xfree(void *);
extern string xgetenv(const_string);

extern int fprintf(FILE *stream, const char *format, ...);
extern int fputs(const char *str, FILE *stream);
extern int putc(int c, FILE *stream);
extern int fflush(FILE *stream);
extern void perror(const char *str);
extern void exit(int status);
extern void abort(void);

#else
#define program_invocation_name \
							(*(program_invocation_name_get()))
#define program_invocation_short_name \
							(*(program_invocation_short_name_get()))
#define kpse_fallback_resolutions_string \
							(*(kpse_fallback_resolutions_string_get()))
#define kpse_make_tex_discard_errors \
							(*(kpse_make_tex_discard_errors_get()))
#define kpse_format_info	(kpse_format_info_get())
#define optarg				(*(optarg_get()))
#define optind				(*(optind_get()))

extern LPTSTR *program_invocation_name_get(void);
extern LPTSTR *program_invocation_short_name_get(void);
extern LPTSTR *kpse_fallback_resolutions_string_get(void);
extern BOOL *kpse_make_tex_discard_errors_get(void);
extern kpse_format_info_type *kpse_format_info_get(void);
extern LPTSTR *optarg_get(void);
extern INT *optind_get(void);
#endif

#endif /* not KPSE_DLL_H */
