maketex_progs = MakeTeXls-R.exe MakeTeXnames.exe MakeTeXupdate.exe \
	MakeTeXpk.exe MakeTeXmkdir.exe

!include "win32/common.make"
!include "win32/programs.make"

DEFS = $(XDEFS) -D_IMPORT
prog_cflags = -I.. -I../kpathsea


do-maketex: $(kpathsea) MakeTeXprogs makempx.exe

MakeTeXprogs: $(maketex_progs)

maketex.exe: maketex.obj stackenv.obj $(kpathsea)
	$(kpathsea_link) maketex.obj stackenv.obj $(LOADLIBES)

remove.exe: remove.obj
	$(kpathsea_link) remove.obj $(LOADLIBES)

remove.obj:	remove.c

MakeTeXls-R.exe: maketex.exe
	$(CP) $** $@

MakeTeXnames.exe: maketex.exe
	$(CP) $** $@

MakeTeXpk.exe: maketex.exe
	$(CP) $** $@

MakeTeXtfm.exe: maketex.exe
	$(CP) $** $@

MakeTeXmkdir.exe: maketex.exe
	$(CP) $** $@

MakeTeXrmdir.exe: maketex.exe
	$(CP) $** $@

MakeTeXupdate.exe: maketex.exe
	$(CP) $** $@

makempx.exe: makempx.obj stackenv.obj $(kpathsea)
	$(link_command) makempx.obj stackenv.obj $(LOADLIBES)

maketex.obj:	maketex.c

makempx.obj:	makempx.c
	sed -e "s%@BINDIR@%\"$(bindir:\=\\)\"%g" < makempx.c \
	| sed -e "/$(bindir:\=\\)/s@\\@\\\\@g" \
	> $*-tmp.c
	$(MV) $*-tmp.c $*.c && $(RM) $*-tmp.c
	$(compile) $*.c

#makempx-tmp.obj:	makempx-tmp.c

#makempx.obj:	makempx-tmp.obj
#	$(CP) makempx-tmp.obj makempx.obj
#	-$(RM) /f makempx-tmp.*

stackenv.obj:	stackenv.c

!include "win32/tkpathsea.make"

install-win32: MakeTeXprogs makempx.exe
	$(CP) makempx.exe $(bindir)\makempx.exe
	for %%i in ($(maketex_progs)) do $(CP) %%i $(bindir)\%%i

clean::
	-$(RM) *.obj *.exe

#Local Variables:
#mode: Makefile
#End: