#include <win32dll/win32lib.h>
#include <win32dll/maketexlib.h>
#include <stdio.h>
#include <malloc.h>

struct MakeTeXCallbackInfo_s {
  BOOL Verbose_f;
};

MakeTeXCallbackInfo* MakeTeXInitCallback(BOOL verbose_f)
{
  MakeTeXCallbackInfo* pinfo = malloc(sizeof(MakeTeXCallbackInfo));
  if (pinfo)
    pinfo->Verbose_f = win32_get_registry_int(TeXDLL_REGISTRY_KEY "\\MakeTeX",
					      "debugPrint", verbose_f);
  win32_init_cui_callback();
  return pinfo;
}

VOID MakeTeXUninitCallback(MakeTeXCallbackInfo* pinfo)
{
  free(pinfo);
}

LONG WINAPI MakeTeXCallback(TeXDLLMessage msg,
			    DWORD param1, DWORD param2,
			    LPVOID callback_data)
{
  LONG code = 0;
  MakeTeXCallbackInfo* pinfo = (MakeTeXCallbackInfo*)callback_data;
  
  switch (msg) {
  case TeXDLL_STDOUT_WRITE:
  case TeXDLL_CONSOLE_WRITE:
    if (pinfo->Verbose_f)
      return win32_standard_cui_callback(msg, param1, param2, callback_data);
    break;
  case TeXDLL_CONSOLE_GET:
    code = -1;
    break;
  }
  return code;
}
