#include <kpathsea/kpathsea.h>
#include <win32dll/win32lib.h>
#include <mbstring.h>

CRITICAL_SECTION critical_section;
HANDLE hMakeTeXModule = 0;

#define MakeTeXDLL_REGISTRY_KEY TeXDLL_REGISTRY_KEY "\\MakeTeX"
#define REG_MF_DEFAULT_MODE_KEY MakeTeXDLL_REGISTRY_KEY "\\Default Mode"
#define REG_MF_KEEP_DIR_STRUCT "keepDirectoryStructure"
#define REG_MF_AUTO_UPDATE_LSR "updateLSRAutomatically"

BOOL APIENTRY DllMain(HANDLE hModule, 
		      DWORD ul_reason_for_call, 
		      LPVOID lpReserved)
{
  switch(ul_reason_for_call) {
  case DLL_PROCESS_ATTACH:
    hMakeTeXModule = hModule;
    InitializeCriticalSection(&critical_section);
    win32_init_module(hModule);
    break;
  case DLL_PROCESS_DETACH:
    DeleteCriticalSection(&critical_section);
    break;
  }
  return TRUE;
}

LPSTR GetMode(UINT dpi)
{
  char buf[50];
  sprintf(buf, "%u", dpi);
  return win32_get_registry_string(REG_MF_DEFAULT_MODE_KEY,
				   buf, "cx");
}

static BOOL is_kept_directory_structure(VOID)
{
  return win32_get_registry_int(MakeTeXDLL_REGISTRY_KEY,
				REG_MF_KEEP_DIR_STRUCT,
				1);
}

static LPSTR get_standard_tex_directory(LPCSTR name,
					LPCSTR topdir,
					LPCSTR dir,
					LPCSTR srcprefix,
					LPCSTR srcext,
					kpse_file_format_type type)
{
  LPSTR base = win32_concat(name, srcext);
  LPSTR file = win32_find_file(name, type, false);
  LPSTR result = NULL;
  
  win32_free(base);
  
  if (file) {
    LPSTR texmf = win32_var_expand("${TEXMF}\\fonts");
    LPSTR vartexmf = win32_var_expand("${VARTEXFONTS}");
    LPCSTR xtexmf = NULL;
    win32_unix2dos(texmf);
    win32_unix2dos(vartexmf);
    win32_unix2dos(file);
    if (strlen(vartexmf) && strnicmp(vartexmf, file, strlen(vartexmf)) == 0)
      xtexmf = vartexmf;
    else if (strlen(texmf) && strnicmp(texmf, file, strlen(texmf)) == 0)
      xtexmf = texmf;
    if (xtexmf) {
      LPSTR p = file + strlen(xtexmf);
      while (p = _mbschr(p, '\\')) {
	p++;
	if (strnicmp(p, srcprefix, strlen(srcprefix)) == 0 &&
	    p[strlen(srcprefix)] == '\\')
	  break;
      }
      if (p) {
	LPCSTR q;
	LPSTR r;
	LPSTR s =
	  win32_malloc(strlen(topdir) + strlen(dir) + strlen(file) + 5);
	strcpy(s, topdir);
	r = s + strlen(s);
	for (q = file + strlen(xtexmf);q < p; q++, r++)
	  *r = *q;
	strcpy(r, dir);
	strcat(r, p + strlen(srcprefix));
	p = _mbsrchr(s, '\\');
	*p = 0;
	result = s;
      }
    }
    win32_free(file);
    win32_free(texmf);
    win32_free(vartexmf);
  }
  
  if (result == NULL) {
    result = win32_concat_filename(topdir, dir);
  }
  
  return result;
}

LPSTR GetPKDirectory(LPCSTR name, LPCSTR mode)
{
  LPSTR workdir = win32_var_expand("${VARTEXFONTS}");
  LPSTR pkmode = win32_concat_filename("pk", mode);
  LPSTR p;
  
  if (is_kept_directory_structure()) {
    p = get_standard_tex_directory(name, workdir, pkmode,
				   "source", ".mf", kpse_mf_format);
    win32_free(workdir);
    workdir = p;
  }
  else {
    p = win32_concat_filename(workdir, pkmode);
    win32_free(workdir);
    workdir = p;
  }
  win32_free(pkmode);
  while ((p = _mbsrchr(workdir, '\\')) && strlen(workdir) == p - workdir + 1)
    *p = 0;
  
  return workdir;
}

LPSTR GetTFMDirectory(LPCSTR name)
{
  LPSTR workdir = win32_var_expand("${VARTEXFONTS}");
  LPSTR p;
  
  if (is_kept_directory_structure()) {
    p = get_standard_tex_directory(name, workdir, "tfm",
				   "source", ".mf", kpse_mf_format);
    win32_free(workdir);
    workdir = p;
  }
  
  while ((p = _mbsrchr(workdir, '\\')) && strlen(workdir) == p - workdir + 1)
    *p = 0;

  return workdir;
}

BOOL UpdateLSR()
{
  if (win32_get_registry_int(MakeTeXDLL_REGISTRY_KEY,
			     REG_MF_AUTO_UPDATE_LSR,
			     0)) {
    return MakeTeXlsRMain(NULL, NULL);
  }
  return TRUE;
}
