#include <win32dll/win32lib.h>
#include <assert.h>

/* Memory Allocation */

static HANDLE hHeap = NULL;

LPVOID win32_malloc(size_t s)
{
  if (hHeap) {
    LPVOID p;
    s++;
    p = HeapAlloc(hHeap, 0, s);
    return p;
  }
  else {
    return malloc(s);
  }
}

LPVOID win32_realloc(LPVOID p, size_t s)
{
  if (hHeap) return HeapReAlloc(hHeap, 0, p, s);
  else return realloc(p, s);
}

void win32_free(LPVOID p)
{
  if (hHeap) HeapFree(hHeap, 0, p);
  else free(p);
}

BOOL win32_init_malloc(void)
{
  SYSTEM_INFO sys;
  assert(hHeap == NULL);
  hHeap = HeapCreate(0, 0, 0);
  GetSystemInfo(&sys);
  return (hHeap != NULL);
}

BOOL win32_uninit_malloc(void)
{
  if (hHeap) {
    HeapDestroy(hHeap);
    hHeap = NULL;
  }
  return TRUE;
}
