#include <win32dll/win32lib.h>
#include <win32dll/texdll.h>
#include <win32dll/maketexlib.h>

/* sorry. not implemented yet. */

typedef struct {
  char* basename;
  char* rootname;
  char* realsize;
  char* filename;
  char* fontdir;
  char *config;
} FontInfo;

typedef struct {
  int pointsize;
  const char* realsize;
} SizeInfo;

static SizeInfo size_table[] =
{
  { 11, "10.95444", },
  { 14, "14.4", },
  { 17, "17.28", },
  { 20, "20.74", },
  { 25, "24.88", },
  { 0, 0, },
};

static BOOL parse_font(const char* lpszFontName, FontInfo* lpInfo)
{
  const char* p = lpszFontName;
  const char* pt;
  char *pointsize;
  int len;
  while (*p && !isdigit(*p) && *p != '.') {
    p = (const char*)_mbsinc((const unsigned char*)p);
  }
  len = p - lpszFontName;
  
  lpInfo->rootname = malloc(len + 1);
  strncpy(lpInfo->rootname, lpszFontName, len);
  lpInfo->rootname[len] = 0;

  pt = p;
  while (*p && isdigit(*p)) {
    p = (const char*)_mbsinc((const unsigned char*)p);
  }
  if (p - pt == 2) {
    ;
  }
  else if (p - pt == 4) {
    lpInfo->realsize = malloc(6);
    strncpy(lpInfo->realsize, pt, 2);
    lpInfo->realsize[2] = '.';
    strncpy(lpInfo->realsize + 3, pt + 2, 2);
    lpInfo->realsize[5] = 0;
  }
  else return FALSE;

  len = p - pt;
  pointsize = malloc(len + 1);
  strncpy(pointsize, pt, len);
  pointsize[len] = 0;
  
  if (lpInfo->realsize == 0) {
    int i;
    int n = atoi(pointsize);
    for (i=0;i<sizeof(size_table)/sizeof(SizeInfo);i++) {
      if (n == size_table[i].pointsize)
	break;
    }
    if (size_table[i].pointsize) {
      lpInfo->realsize = strdup(size_table[i].realsize);
    }
    else {
      lpInfo->realsize = strdup(pointsize);
    }
  }
  
  free(pointsize);
  
  while (*p && *p != '.') {
    p = (const char*)_mbsinc((const unsigned char*)p);
  }
  len = p - lpszFontName;
  lpInfo->basename = malloc(len + 1);
  strncpy(lpInfo->basename, lpszFontName, len);
  lpInfo->basename[len] = 0;
  
  return TRUE;
}

static BOOL match(const char* pattern, const char* name)
{
  if (strlen(pattern) > strlen(name))
    return FALSE;
  return (strnicmp(pattern, name, strlen(pattern)) == 0);
}

static void do_line(FontInfo* lpInfo, FILE* fpo, const char* buf)
{
  const char* p = buf;
  while (*p) {
    if (*p == '$') {
      if (*(p+1) == 0) break;
      switch (*(p+1)) {
      case '$':
	putc('$', fpo);
	break;
      case 'b':
	fputs(lpInfo->basename, fpo);
	break;
      case 'r':
	fputs(lpInfo->rootname, fpo);
	break;
      case 'p':
	fputs(lpInfo->realsize, fpo);
	break;
      }
      p++;
    }
    else putc(*p, fpo);
    p++;
  }
  fputs("\n", fpo);
}

static BOOL do_output(FontInfo* lpInfo, const char* subdir, FILE* fpi)
{
  FILE* fpo;
  BOOL code = FALSE;
  char* dir = win32_concat_filename(lpInfo->fontdir, subdir);
  char* out;

  {
    char *tmp  = win32_concat_filename(dir, lpInfo->basename);
    out = win32_concat(tmp, ".mf");
    win32_free(tmp);
    win32_unix2dos(out);
  }

  win32_unix2dos(dir);
  win32_mkdir_recursively(dir);
  fpo = fopen(out, "w");
  fputs("% This file is generated by MakeTeXMF automatically.\n", fpo);
  if (fpo) {
    int c;
    while (c != EOF && c != '{')
      c = getc(fpi);
    while (c != EOF && c != '\n')
      c = getc(fpi);
    for ( ; ; ) {
      char buf[256];
      int i;
      while (c != EOF && isspace(c) && c != '}')
	c = getc(fpi);
      if (c == '}') break;
      i = 0;
      while (c != EOF && c != '\n' && c != '}') {
	buf[i++] = c;
	c = getc(fpi);
      }
      buf[i] = 0;
      do_line(lpInfo, fpo, buf);
      if (c == EOF || c == '}') break;
      c = getc(fpi);
    }
    fclose(fpo);
    code = TRUE;
  }
  win32_free(dir);
  if (code) {
    lpInfo->filename = strdup(out);
  }
  win32_free(out);
  
  return code;
}

static BOOL do_font(FontInfo* lpInfo)
{
  BOOL code = FALSE;
  FILE* fp = fopen(lpInfo->config, "r");
  if (!fp) return FALSE;
  
  for ( ; ; ) {
    char token[256];
    int i;
    int c = getc(fp);
    if (c == '#') { /* comment */
      while (c != '\n' && c != EOF)
	c = getc(fp);
      continue;
    }
    while (c != EOF && isspace(c))
      c = getc(fp);
    if (c == EOF) break;
    i = 0;
    while (c != EOF && !isspace(c)) {
      token[i++] = c;
      c = getc(fp);
    }
    token[i] = 0;
    if (stricmp(token, "font") == 0) {
      while (c != EOF && isspace(c))
	c = getc(fp);
      i = 0;
      while (c != EOF && !isspace(c)) {
	token[i++] = c;
	c = getc(fp);
      }
      token[i] = 0;
      if (match(token, lpInfo->basename)) {
	while (c != EOF && isspace(c))
	  c = getc(fp);
	i = 0;
	while (c != EOF && !isspace(c)) {
	  token[i++] = c;
	  c = getc(fp);
	}
	token[i] = 0;
	code = do_output(lpInfo, token, fp);
	break;
      }
      else {
	while (c != EOF && c != '}')
	  c = getc(fp);
      }
    }
    else {
      while (c != EOF && c != '\n')
	c = getc(fp);
    }
  }
  
  fclose(fp);
  return code;
}

static LONG WINAPI dummy_callback(TeXDLLMessage msg,
				  DWORD param1, DWORD param2,
				  LPVOID callback_data)
{
  return 0;
}

UINT thread_func(LPVOID lpData)
{
  BOOL code = FALSE;
  FontInfo* lpInfo = (FontInfo*)lpData;
  char* texmf;
  
  LPVOID (WINAPI *init)(VOID);
  BOOL (WINAPI *set_progname)(LPVOID, LPCSTR );
  LPSTR (WINAPI *var_expand)(LPVOID, LPCSTR);
  BOOL (WINAPI *uninit)(LPVOID);
  LPVOID *lpSearchData;
  
  HANDLE hDLL = win32_load_tex_library("texdllse.dll");
  if (!hDLL) return 0;
  (FARPROC)init = GetProcAddress(hDLL, "KpseInitialize");
  (FARPROC)set_progname = GetProcAddress(hDLL, "KpseSetProgName");
  (FARPROC)var_expand = GetProcAddress(hDLL, "KpseVarExpand");
  (FARPROC)uninit = GetProcAddress(hDLL, "KpseUninitialize");
  
  if (!init || !set_progname || !var_expand || !uninit) {
  init_error:
    FreeLibrary(hDLL);
    return 0;
  }
  
  lpSearchData = (*init)();
  if (!lpSearchData) goto init_error;
  
  (*set_progname)(lpSearchData, "MakeTeXMF");
  
  texmf = (*var_expand)(lpSearchData, "${VARTEXMF}");
  
  if (texmf) {
    lpInfo->fontdir = malloc(strlen(texmf) + 100);
    strcpy(lpInfo->fontdir, texmf);
    strcat(lpInfo->fontdir, "\\fonts\\source");
    code = TRUE;
  }

  (*uninit)(lpSearchData);
  FreeLibrary(hDLL);
  
  if (lpInfo->config == 0) {
    char *p;
    char buf[_MAX_PATH + 1];
    GetModuleFileName(hMakeTeXModule, buf, _MAX_PATH);
    p = (char*)_mbsrchr(buf, '\\');
    strcpy(p + 1, "MakeTeXMF.cnf");
    lpInfo->config = strdup(buf);
  }
  
  return code;
}

BOOL WINAPI MakeTeXMFMain(LPSTR lpszFileName, DWORD dwLen,
			  LPFTeXCallbackProc callback,
			  LPVOID callback_data,
			  LPCSTR lpszFontName)
{
  FontInfo* lpInfo;
  BOOL code = FALSE;

  lpInfo = malloc(sizeof(FontInfo));
  memset(lpInfo, 0, sizeof(FontInfo));

  {
    UINT idThread;
    HANDLE hThread =
      (HANDLE)_beginthreadex(NULL, 0, thread_func, lpInfo, 0, &idThread);
    if (hThread) {
      DWORD dwCode;
      WaitForSingleObject(hThread, INFINITE);
      GetExitCodeThread(hThread, &dwCode);
      CloseHandle(hThread);
      if (dwCode &&
	  parse_font(lpszFontName, lpInfo) &&
	  do_font(lpInfo)) {
	strcpy(lpszFileName, lpInfo->filename);
	UpdateLSR();
	code = TRUE;
      }
    }
  }
  
  if (lpInfo->rootname) free(lpInfo->rootname);
  if (lpInfo->basename) free(lpInfo->basename);
  if (lpInfo->realsize) free(lpInfo->realsize);
  if (lpInfo->fontdir) free(lpInfo->fontdir);
  if (lpInfo->filename) free(lpInfo->filename);
  if (lpInfo->config) free(lpInfo->config);
  free(lpInfo);
  
  return code;
}
