#include <mbstring.h>
#include <win32dll/win32lib.h>

LPSTR win32_strdup(LPCSTR s)
{
  LPSTR b = win32_malloc(strlen(s) + 1);
  if (b) strcpy(b, s);
  return b;
}

LPSTR win32_concat(LPCSTR s1, LPCSTR s2)
{
  LPSTR s = win32_malloc(strlen(s1) + strlen(s2) + 1);
  strcpy(s, s1);
  strcat(s, s2);
  return s;
}

LPSTR win32_concat3(LPCSTR s1, LPCSTR s2, LPCSTR s3)
{
  LPSTR s = win32_malloc(strlen(s1) + strlen(s2) + strlen(s3) + 1);
  strcpy(s, s1);
  strcat(s, s2);
  strcat(s, s3);
  return s;
}

LPSTR win32_concatn(LPCSTR s1, ...)
{
  LPSTR s;
  LPCSTR n;
  va_list va;
  
  if (!s1) return NULL;
  
  va_start(va, s1);
  s = win32_strdup(s1);
  while (n = va_arg(va, LPCSTR)) {
    LPSTR t = win32_concat(s, n);
    win32_free(s);
    s = t;
  }
  va_end(va);

  return s;
}

const char*
win32_basename(const char* name)
{
  const char *p, *q;
  
  p = _mbsrchr(name, '\\');
  q = _mbsrchr(name, '/');
  if (p < q) p = q;
  if (p) p++;
  else {
    p = _mbsrchr(name, ':');
    if (!p) p = name;
  }
  
  return p;
}

char*
win32_find_suffix(const char* name)
{
  const char* base;
  char* dot_pos = _mbsrchr (name, '.');
  
  if (!dot_pos)
    return dot_pos;

  base = win32_basename(name);
  return (dot_pos >= base) ? dot_pos + 1 : (char*)0;
}

char*
win32_extend_filename(const char* name, const char* default_suffix)
{
  char* new_s;
  const char* suffix = win32_find_suffix (name);
  
  new_s = !suffix ? win32_concat3 (name, ".", default_suffix)
    : (char*) name;
  return new_s;
}

#define IS_DIR_SEP(c) ( (c) == '\\' || (c) == '/' )

char*
win32_make_suffix(const char* s, const char* suffix)
{
  char* new_s;
  const char* dot_pos = win32_find_suffix(s);
  
  if (dot_pos == NULL)
    new_s = win32_concat3 (s, ".", suffix);
  else
    {
      unsigned past_dot_index = dot_pos - s;
      
      new_s = win32_malloc (past_dot_index + strlen (suffix) + 1);
      strncpy (new_s, s, past_dot_index);
      strcpy (new_s + past_dot_index, suffix);
    }

  return new_s;
}
