################################################################################
# Calls the SLOCCounter method with argument
# specified and returns count.
# Change Log:
#-------------------------------------------------------------------------------
# JRF JAN 27 2005 EST Created
# JRF JAN 28 2005 EST Updated for comparing 2 files
#-------------------------------------------------------------------------------
# See POD for more details
################################################################################

use strict;
use warnings;

use Utility::SLOCCounter;

if ($ARGV[0] eq '-b'){
	my $sloc = new Utility::SLOCCounter($ARGV[1]);
	print "Base is " . $sloc->count();
}
elsif($ARGV[0] eq '-c'){
	my $new = new Utility::SLOCCounter($ARGV[1]);
	my $old = new Utility::SLOCCounter($ARGV[2]);
	my ($deleted, $added, $reused) = $new->compare($old);
	my $base = $new->count();
	print "SLOC Compared:\n";
	print "\tBase:\t$base\n";
	print "\tAdded:\t$added\n";
	print "\tDeleted:\t$deleted\n";
	print "\tReused:\t$reused\n";
}
else{
	print "Help:\nslocrunner.pl - this is a simple script to perform base counts on one file,\n";
	print "\tcompares one and new files for differences\n\n";
	print "Usage: perl slocrunner.pl -(bc) <newfile> [oldfile]\n";
	print "Examples:\n";
	print "\tCalculate base only: slocrunner.pl -b somefile.pl\n";
	print "\tCalculate difference: slocrunner.pl -c newfile.pl oldfile.pl\n";
}

__END__

=pod

=head1 NAME

slocrunner.pl

=head1 SYNOPSIS

Base only:

slocrunner.pl -b someperlfile.pm

Compare:

slocrunner.pl -c newfile.pm oldfile.pm

=head1 SUMMARY

slocrunner is a dirver program for the SLOCCounter program.
It supports both calculating base for one Perl source file
or calculating added, deleted, reused, and base for two perl
source files.

This of course assumes that you have access to both files, and you haven't overwritten the old with the new.
If you haven't done so, please put some type of CM process in place.
CVS will work, or use local directories if you happen to be at home and alone.

=head1 AUTHOR

johnfraser <johnfraser@somewhere.com<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (c) 2005, John Fraser C<< <raptnor@yahoo.com> >>. All rights reserved.

This module is free software; you can redistribute it and/or
modify it under the same terms as Perl itself. See L<perlartistic>.


=head1 DISCLAIMER OF WARRANTY

BECAUSE THIS SOFTWARE IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE SOFTWARE, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE SOFTWARE "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE SOFTWARE IS WITH
YOU. SHOULD THE SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL
NECESSARY SERVICING, REPAIR, OR CORRECTION.

IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE SOFTWARE AS PERMITTED BY THE ABOVE LICENCE, BE
LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE
THE SOFTWARE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING
RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A
FAILURE OF THE SOFTWARE TO OPERATE WITH ANY OTHER SOFTWARE), EVEN IF
SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGES.
=cut