class Log::JSON
---------------

A simple implementation of Log.

### has Positional @!outputs

An array of hashes. Each has must have a handle key, with an IO::Handle to print messages to. A level key with an integer to signify a Log::Level is also required.

### has Supplier $!messages

A supplier to emit messages to.

### has Bool:D $.pretty

Set to true to pretty-print the JSON.

### multi method emergency

```perl6
multi method emergency(
    Str:D $message,
    *%meta
) returns Mu
```

Send an emergency message.

class Str:D $message
--------------------

The message to print.

class *%meta
------------

Any additional fields of metadata to include.

### multi method emergency

```perl6
multi method emergency(
    Str:D $format,
    *@args,
    *%meta
) returns Mu
```

Send a formatted emergency message.

class Str:D $format
-------------------

A printf-style format string.

class *@args
------------

Arguments to substitute into the format string placeholders.

class *%meta
------------

Any additional fields of metadata to include.

### multi method alert

```perl6
multi method alert(
    Str:D $message,
    *%meta
) returns Mu
```

Send an alert message.

class Str:D $message
--------------------

The message to print.

class *%meta
------------

Any additional fields of metadata to include.

### multi method alert

```perl6
multi method alert(
    Str:D $format,
    *@args,
    *%meta
) returns Mu
```

Send a formatted alert message.

class Str:D $format
-------------------

A printf-style format string.

class *@args
------------

Arguments to substitute into the format string placeholders.

class *%meta
------------

Any additional fields of metadata to include.

### multi method critical

```perl6
multi method critical(
    Str:D $message,
    *%meta
) returns Mu
```

Send a critical message.

class Str:D $message
--------------------

The message to print.

class *%meta
------------

Any additional fields of metadata to include.

### multi method critical

```perl6
multi method critical(
    Str:D $format,
    *@args,
    *%meta
) returns Mu
```

Send a formatted critical message.

class Str:D $format
-------------------

A printf-style format string.

class *@args
------------

Arguments to substitute into the format string placeholders.

class *%meta
------------

Any additional fields of metadata to include.

### multi method error

```perl6
multi method error(
    Str:D $message,
    *%meta
) returns Mu
```

Send an error message.

class Str:D $message
--------------------

The message to print.

class *%meta
------------

Any additional fields of metadata to include.

### multi method error

```perl6
multi method error(
    Str:D $format,
    *@args,
    *%meta
) returns Mu
```

Send a formatted error message.

class Str:D $format
-------------------

A printf-style format string.

class *@args
------------

Arguments to substitute into the format string placeholders.

class *%meta
------------

Any additional fields of metadata to include.

### multi method warning

```perl6
multi method warning(
    Str:D $message,
    *%meta
) returns Mu
```

Send a warning message.

class Str:D $message
--------------------

The message to print.

class *%meta
------------

Any additional fields of metadata to include.

### multi method warning

```perl6
multi method warning(
    Str:D $format,
    *@args,
    *%meta
) returns Mu
```

Send a formatted warning message.

class Str:D $format
-------------------

A printf-style format string.

class *@args
------------

Arguments to substitute into the format string placeholders.

class *%meta
------------

Any additional fields of metadata to include.

### multi method notice

```perl6
multi method notice(
    Str:D $message,
    *%meta
) returns Mu
```

Send a notice message. This is the "normal" level to publish log entries on.

class Str:D $message
--------------------

The message to print.

class *%meta
------------

Any additional fields of metadata to include.

### multi method notice

```perl6
multi method notice(
    Str:D $format,
    *@args,
    *%meta
) returns Mu
```

Send a formatted notice message. This is the "normal" level to publish log entries on.

class Str:D $format
-------------------

A printf-style format string.

class *@args
------------

Arguments to substitute into the format string placeholders.

class *%meta
------------

Any additional fields of metadata to include.

### multi method info

```perl6
multi method info(
    Str:D $message,
    *%meta
) returns Mu
```

Send an informational message.

class Str:D $message
--------------------

The message to print.

class *%meta
------------

Any additional fields of metadata to include.

### multi method info

```perl6
multi method info(
    Str:D $format,
    *@args,
    *%meta
) returns Mu
```

Send a formatted informational message.

class Str:D $format
-------------------

The printf-style format string.

class *@args
------------

Arguments to substitute into the format string placeholders.

class *%meta
------------

Any additional fields of metadata to include.

### multi method debug

```perl6
multi method debug(
    Str:D $message,
    *%meta
) returns Mu
```

Send a debug message.

class Str:D $message
--------------------

The message to print.

class *%meta
------------

Any additional fields of metadata to include.

### multi method debug

```perl6
multi method debug(
    Str:D $format,
    *@args,
    *%meta
) returns Mu
```

Send a formatted debug message.

class Str:D $format
-------------------

A printf-style format string.

class *@args
------------

Arguments to substitute into the format string placeholders.

class *%meta
------------

Any additional fields of metadata to include.

### multi method add-output

```perl6
multi method add-output(
    IO::Handle:D $handle,
    $level where { ... },
    Callable :$filter
) returns Mu
```

Add an output to the logger.

class IO::Handle:D $handle
--------------------------

The IO::Handle to write log messages to.

class $level where { ... }
--------------------------

The log level for this particular stream.

class Callable :$filter
-----------------------

A filter function to apply to any messages sent to the output.

### method callee

```perl6
method callee(
    Int:D $depth = 3
) returns Str
```

Convenience method to get the callee name. This is the package name if one exists, or the source file name.

class Int:D $depth = 3
----------------------

The depth of which to get the callframe.

### method message

```perl6
method message(
    Str:D $level,
    Str:D $message,
    *%meta
) returns Str
```

Convenience method for formatting the message as desired.

class Str:D $level
------------------

A human readable identifier for the level.

class Str:D $message
--------------------

The original message to be logged.

class *%meta
------------

Any additional fields for metadata on the log message.

NAME
====

Log::JSON

VERSION
=======

0.1.0

AUTHOR
======

Patrick Spek <p.spek@tyil.nl>

LICENSE
=======

Copyright © 2020

This program is free software: you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation, version 3.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License along with this program. If not, see http://www.gnu.org/licenses/.

