# NAME

Mojolicious::Plugin::ORM::DBix - Easily load and access DBIx::Class functionality in Mojolicious apps

# SYNOPSIS

    # Register plugin
    $self->plugin('ORM::DBIx' => {
      dsn                  => $conf->{dsn},
      username             => $conf->{user},
      password             => $conf->{pass},
    });

    ...

    # access in controller
    sub get_user($self) {
      my $user = $self->model("User")->find($self->req->param('id'));
      $self->render(json => {user => $user->username});
    }

    ..

    # use from command-line during development, following schema migration
    
    tyrrminal@devserver:/app$ script/myapp schema-load --noquiet
    Dumping manual schema for Myapp::Model to directory /app/lib ...
    Schema dump completed.

# DESCRIPTION

Mojolicious::Plugin::ORM::DBIx streamlines the process of getting DBIC classes
generated and accessible from within a Mojolicious application.

# METHODS

[Mojolicious::Plugin::ORM::DBIx](https://metacpan.org/pod/Mojolicious%3A%3APlugin%3A%3AORM%3A%3ADBIx) inherits all methods from [Mojolicious::Plugin](https://metacpan.org/pod/Mojolicious%3A%3APlugin)
and implements the following new ones

## register( $args )

Register plugin in [Mojolicious](https://metacpan.org/pod/Mojolicious) application. The following keys are supported
in `$args`

#### dsn

The [data source name](https://en.wikipedia.org/wiki/Data_source_name) for connecting
to the database. Defaults to `dbi:SQLite:dbname=:memory:` if omitted.

#### namespace

The perl class name of the root schema object for the application. Defaults to
`$Moniker::Model` if omitted, where `$Moniker` is the mojolicious moniker with the 
first letter capitalized. This class does not need to be manually created, as 
["run\_schema\_load"](#run_schema_load) can create it along with the rest of the schema.

#### username

The database connection username

#### password

The database connection password

#### connect\_params

An optional HashRef of additional connection parameters to be passed to DBI at
connection time.

_The following parameters pertain to DBIx schema loader code generation_

#### lib

The directory where the schema loader files will be written to. 
Default `$MOJO_HOME/lib`

#### codegen\_filters

An optional ordered ArrayRef of functions for filtering/modifying the code 
generated by the schema loader. See 
["filter\_generated\_code" in DBIx::Class::Schema::Loader::Base](https://metacpan.org/pod/DBIx%3A%3AClass%3A%3ASchema%3A%3ALoader%3A%3ABase#filter_generated_code) for details.

#### overwrite

A proxy value for ["overwrite\_modifications" in DBIx::Class::Schema::Loader::Base](https://metacpan.org/pod/DBIx%3A%3AClass%3A%3ASchema%3A%3ALoader%3A%3ABase#overwrite_modifications).
**N.B.** defaults to true

#### feature\_bundle

When generating code, add a `use vX.XX;` line near the end of the file, such 
that it applies to manual additions to the Result class files (but not to the
generated code itself). Defaults to the perl version being used to generate the
code. Any value that is not a valid perl 
[version](https://perldoc.perl.org/version) will cause this option to be disabled
with a warning written to the mojolicious log. Pass undef to disable this option
without a warning.

See [FEATURE-BUNDLES](https://perldoc.perl.org/feature#FEATURE-BUNDLES) for 
more information on valid values.

If enabled, this line is added to the code before running any custom 
["codegen\_filters"](#codegen_filters)

#### tidy\_format\_skipping

When using [Perl::Tidy](https://metacpan.org/pod/Perl%3A%3ATidy) you may wind up with formatting disagreements between
the generated code and perltidy's ruleset. This option allows you to add lines
around the generated code to disable perltidy formatting, while leaving it 
enabled for any custom code added to the end of the Result class files.

Takes an ArrayRef containing two strings: `[$disable_formatting, $enable_formatting]`.
Default is `['#<<<','#>>>']`

See [https://perltidy.sourceforge.net/perltidy.html#Skipping-Selected-Sections-of-Code](https://perltidy.sourceforge.net/perltidy.html#Skipping-Selected-Sections-of-Code).

Pass undef to disable this behavior.

If enabled, these lines are added after running any custom ["codegen\_filters"](#codegen_filters)

#### dbix\_components

An optional ArrayRef of DBIx components to load into generated classes. Defaults 
to `[`[InflateColumn::DateTime](https://metacpan.org/pod/DBIx%3A%3AClass%3A%3AInflateColumn%3A%3ADateTime)`,`[Relationship::Predicate](https://metacpan.org/pod/DBIx%3A%3AClass%3A%3ARelationship%3A%3APredicate)`]`

The defaults will be prepended to the contents of the passed ArrayRef; to 
circumvent this behavior, pass `undef` as the first element of the array.

#### loader\_options

An optional HashRef of additional parameters to pass to 
["make\_schema\_at" in DBIx::Class::Schema::Loader](https://metacpan.org/pod/DBIx%3A%3AClass%3A%3ASchema%3A%3ALoader#make_schema_at). See 
[DBIx::Class::Schema::Loader::Base](https://metacpan.org/pod/DBIx%3A%3AClass%3A%3ASchema%3A%3ALoader%3A%3ABase) for possible values and their meanings.

## db

Returns the root schema object for the application, a subclass of [DBIx::Class::Schema](https://metacpan.org/pod/DBIx%3A%3AClass%3A%3ASchema)

## model( $model\_name )

Returns the resultset object for the specified model name. Identical to `app->db->resultset($model_name)`

## run\_schema\_load( $debug, $quiet )

Generate (or regenerate) model classes from database schema. More or less, this
just runs ["make\_schema\_at" in DBIx::Class::Schema::Loader](https://metacpan.org/pod/DBIx%3A%3AClass%3A%3ASchema%3A%3ALoader#make_schema_at) with options set at the
time of plugin registration.

Parameters:

#### $debug

Write generated classes to `STDERR`. Default: false

See ["debug" in DBIx::Class::Schema::Loader::Base](https://metacpan.org/pod/DBIx%3A%3AClass%3A%3ASchema%3A%3ALoader%3A%3ABase#debug)

#### $quiet

Don't print the `Dumping manual schema...`, `Schema dump completed` messages. 
Default: true

See ["quiet" in DBIx::Class::Schema::Loader::Base](https://metacpan.org/pod/DBIx%3A%3AClass%3A%3ASchema%3A%3ALoader%3A%3ABase#quiet)

# COMMANDS

## schema-load \[--debug\] \[--\[no\]quiet\]

Mojolicious command to execute ["run\_schema\_load"](#run_schema_load)

# AUTHOR

Mark Tyrrell `<mark@tyrrminal.dev>`

# LICENSE

Copyright (c) 2024 Mark Tyrrell

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
