#!/usr/bin/perl -w
# $File: //member/autrijus/PAR/myldr/Makefile.PL $ $Author: autrijus $
# $Revision: #54 $ $Change: 9486 $ $DateTime: 2003/12/29 16:59:56 $
#
# Copyright 2002, 2003 by Autrijus Tang.
# Copyright (c) 2002 Mattia Barbon.
# This package is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.

use strict;
use Config;
use File::Spec;
use ExtUtils::Embed;

xsinit(undef);

my $debug = 0;
my $chunk_size = 30000;
my $perl = $^X;
my $exe = $Config{_exe};
my $link_exe = (($^O eq 'os2' and $Config{ldflags} =~ /-Zexe/) ? '' : $exe);
my $o = $Config{obj_ext};
my $gccversion = $Config{gccversion};
my $pccflags = ccopts;
my $pldflags = ldopts;
my $ld = $Config{ld} || (($^O eq 'MSWin32') ? 'link.exe' : $Config{cc});
my $cc = $Config{cc};
my $dynperl = $Config{useshrplib} && ($Config{useshrplib} ne 'false');

my $f2c = File::Spec->catfile(".", "file2c.pl");
my $par_pl = File::Spec->catfile('..', 'script', "par.pl");
my $par_exe = File::Spec->catfile('.', "par$exe");
my $par_exe_link = File::Spec->catfile('.', "par$link_exe");
my $static_exe = File::Spec->catfile('.', "static$exe");
my $static_exe_link = File::Spec->catfile('.', "static$link_exe");
my $parl_exe = File::Spec->catfile('..', 'script', "parl$exe");
my $parldyn_exe = File::Spec->catfile('..', 'script', "parldyn$exe");
my $lib_path = join(' ', map qq(-I"$_"), @INC);

my $libperl;

if ($dynperl) {
    my $file = $Config{libperl};
    my $so = $Config{so} || 'so';
    $file = "libperl.$so" if $file eq 'libper'; # workaround Red Hat bug

    $file =~ s/\.(?!\d)[^.]*$/.$Config{so}/;

    my @paths = (
	$Config{bin},
	File::Spec->catdir($Config{'archlibexp'}, 'CORE'),
	split(/\Q$Config{path_sep}\E/, $ENV{$Config{ldlibpthname}} || ''),
	split(/ /, $Config{libpth}),
    );

    foreach my $path (@paths) {
	$libperl = File::Spec->catfile($path, $file);
	last if -e $libperl;
	$libperl = File::Spec->catfile($path, $file . $Config{_a}); # for cygwin
	last if -e $libperl;
    }

    die "Can't find $file in (@paths) -- please contact the author!" unless -e $libperl or $^O eq 'os2';
    $libperl = OS2::DLLname() if $^O eq 'os2';
}

my $par = (($dynperl && $^O ne 'os2') ? $static_exe : $par_exe);
my $all = ($dynperl ? "$parl_exe $parldyn_exe" : $parl_exe);

$perl = Win32::GetShortPathName($perl)
    if $perl =~ / / and defined &Win32::GetShortPathName;

print "Writing Makefile for the par$exe program\n";

open OUT, "> Makefile" or die "open 'Makefile': $!";

my( $out, $ccdebug, $lddebug, $warn, $rm, $mv, $res, $long_literal );

if( $cc =~ m/^cl\b/ ) {
    $out = '-out:';
    $ccdebug = $debug ? '-Zi -Zm1000 ' : '-Zm1000 ';
    $lddebug = $debug ? '-debug ' : '-release ';
    $warn = $debug ? '-W3' : '';
    $res = 'win32.res';
    $long_literal = 0;
} elsif ($cc =~ m/^gcc\b/ or ($cc =~ m/^cc\b/ and $gccversion)) {
    $out = '--output ';
    $ccdebug = $debug ? '-g ' : '';
    $lddebug = ($debug or $^O eq 'darwin') ? '' : '-s ';
    $warn = $debug ? '-Wall -Wno-comments ' : '';
    $res = '';
    $long_literal = 1;
} else {
    $out = '-o ';
    $ccdebug = '';
    $lddebug = '';
    $warn = '';
    $res = '';
    $long_literal = 0; # better safe than sorry
}

$rm = $^O eq 'MSWin32' ? '$(PERL) -MExtUtils::Command -e rm_f' : 'rm -f';
$mv = $^O eq 'MSWin32' ? '$(PERL) -MExtUtils::Command -e mv' : 'mv';

my  $cflags = "$ccdebug$warn$pccflags";
my $ldflags = "$lddebug$pldflags";

if (-e $par_exe and not -s $par_exe) {
    print OUT "all ::\n\t$^X -e1\n";
}
else {
    print OUT << "EOT";
# AUTOGENERATED, DO NOT EDIT, RERUN Makefile.PL

RM=$rm
MV=$mv
PERL=$perl
LD=$ld
CC=$cc
CFLAGS=$cflags
LDFLAGS=$Config{ldflags}
PERL_LDFLAGS=$ldflags
NOOP=\$(PERL) -e1

OBJECTS=main$o my_par_pl$o $res

.c$o:
	\$(CC) -c \$(CFLAGS) \$<

all: $all

clean:
	-\$(RM) my_*.c
	-\$(RM) *$o
	-\$(RM) *.opt *.pdb perlxsi.c
	\$(MV) Makefile Makefile.old

realclean: clean
	-\$(RM) $par_exe
	-\$(RM) $parl_exe
	-\$(RM) $static_exe
	-\$(RM) Makefile Makefile.old

distclean: clean
	-\$(RM) $par_exe
	-\$(RM) $parl_exe
	-\$(RM) $static_exe
	-\$(RM) Makefile Makefile.old

$par_exe: \$(OBJECTS) my_par_pl$o
	\$(LD) \$(OBJECTS) \$(PERL_LDFLAGS) $out$par_exe_link

my_par_pl.c:
	\$(PERL) $f2c $par_pl \$@ load_me_2 $long_literal

$parl_exe: $par
	$par $lib_path -I../myldr/.. -I../blib/lib -q -B -O\$@

disttest:
	-\$(NOOP)

test:
	-\$(NOOP)

.DEFAULT:
	-\$(NOOP)

.SUFFIXES: $o

EOT

    print OUT << "EOT" if $dynperl;

$parldyn_exe: $par_exe
	$par_exe -I../myldr/.. -I../blib/lib $lib_path -q -B -O\$@

$static_exe: my_perl.c my_par.c static$o
	\$(LD) static$o \$(PERL_LDFLAGS) $res $out$static_exe_link
	\$(PERL) parlsig.pl $static_exe $par_exe $dynperl $chunk_size

my_perl.c:
	\$(PERL) $f2c $libperl \$@ load_me_0 $long_literal $chunk_size

my_par.c: $par_exe
	\$(PERL) $f2c $par_exe \$@ load_me_1 $long_literal $chunk_size

EOT
}

# local variables:
# mode: cperl
# end:
