# -*- mode: perl; -*-

use strict;
use warnings;

use Test::More tests => 2 * 222;

use Math::BigInt;

while (<DATA>) {
    s/#.*$//;                   # remove comments
    s/\s+$//;                   # remove trailing whitespace
    next unless length;         # skip empty lines

    my ($x_str, $expected) = split /:/;
    my ($x, $str);

    for my $accu ("undef", "20") {
        my $test = qq|Math::BigInt -> accuracy($accu);|
                 . qq| \$x = Math::BigInt -> new("$x_str");|
                 . qq| \$str = \$x -> bsstr();|;

        note "\n$test\n\n";
        eval $test;
        die $@ if $@;           # should never happen

        is($str, $expected, qq|output is "$expected"|);
        if ($x_str eq 'NaN') {
            ok($x -> is_nan(), "input object is unmodified");
        } else {
            cmp_ok($x, "==", $x_str, "input object is unmodified");
        }
    }
}

__DATA__

NaN:NaN

inf:inf
-inf:-inf

0:0e+0
-0:0e+0

# positive numbers

1:1e+0
10:1e+1
100:1e+2
1000:1e+3
10000:1e+4
100000:1e+5
1000000:1e+6
10000000:1e+7
100000000:1e+8
1000000000:1e+9
10000000000:1e+10
100000000000:1e+11
1000000000000:1e+12

12:12e+0
120:12e+1
1200:12e+2
12000:12e+3
120000:12e+4
1200000:12e+5
12000000:12e+6
120000000:12e+7
1200000000:12e+8
12000000000:12e+9
120000000000:12e+10
1200000000000:12e+11

123:123e+0
1230:123e+1
12300:123e+2
123000:123e+3
1230000:123e+4
12300000:123e+5
123000000:123e+6
1230000000:123e+7
12300000000:123e+8
123000000000:123e+9
1230000000000:123e+10

1234:1234e+0
12340:1234e+1
123400:1234e+2
1234000:1234e+3
12340000:1234e+4
123400000:1234e+5
1234000000:1234e+6
12340000000:1234e+7
123400000000:1234e+8
1234000000000:1234e+9

3:3e+0
31:31e+0
314:314e+0
3141:3141e+0
31415:31415e+0
314159:314159e+0
3141592:3141592e+0

# negative numbers

-1:-1e+0
-10:-1e+1
-100:-1e+2
-1000:-1e+3
-10000:-1e+4
-100000:-1e+5
-1000000:-1e+6
-10000000:-1e+7
-100000000:-1e+8
-1000000000:-1e+9
-10000000000:-1e+10
-100000000000:-1e+11
-1000000000000:-1e+12

-12:-12e+0
-120:-12e+1
-1200:-12e+2
-12000:-12e+3
-120000:-12e+4
-1200000:-12e+5
-12000000:-12e+6
-120000000:-12e+7
-1200000000:-12e+8
-12000000000:-12e+9
-120000000000:-12e+10
-1200000000000:-12e+11

-123:-123e+0
-1230:-123e+1
-12300:-123e+2
-123000:-123e+3
-1230000:-123e+4
-12300000:-123e+5
-123000000:-123e+6
-1230000000:-123e+7
-12300000000:-123e+8
-123000000000:-123e+9
-1230000000000:-123e+10

-1234:-1234e+0
-12340:-1234e+1
-123400:-1234e+2
-1234000:-1234e+3
-12340000:-1234e+4
-123400000:-1234e+5
-1234000000:-1234e+6
-12340000000:-1234e+7
-123400000000:-1234e+8
-1234000000000:-1234e+9

-3:-3e+0
-31:-31e+0
-314:-314e+0
-3141:-3141e+0
-31415:-31415e+0
-314159:-314159e+0
-3141592:-3141592e+0
