/*
This file is part of Ext JS 3.4

Copyright (c) 2011-2013 Sencha Inc

Contact:  http://www.sencha.com/contact

GNU General Public License Usage
This file may be used under the terms of the GNU General Public License version 3.0 as
published by the Free Software Foundation and appearing in the file LICENSE included in the
packaging of this file.

Please review the following information to ensure the GNU General Public License version 3.0
requirements will be met: http://www.gnu.org/copyleft/gpl.html.

If you are unsure which license is appropriate for your use, please contact the sales department
at http://www.sencha.com/contact.

Build date: 2013-04-03 15:07:25
*/
Ext.data.JsonP.Ext_form_BasicForm({"alternateClassNames":[],"aliases":{},"enum":null,"parentMixins":[],"tagname":"class","subclasses":[],"extends":"Ext.util.Observable","uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='docClass'>Ext.util.Observable</a><div class='subclass '><strong>Ext.form.BasicForm</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/BasicForm.html#Ext-form-BasicForm' target='_blank'>BasicForm.js</a></div></pre><div class='doc-contents'><p>Encapsulates the DOM &lt;form> element at the heart of the <a href=\"#!/api/Ext.form.FormPanel\" rel=\"Ext.form.FormPanel\" class=\"docClass\">FormPanel</a> class, and provides\ninput field management, validation, submission, and form loading services.</p>\n\n\n<p>By default, Ext Forms are submitted through Ajax, using an instance of <a href=\"#!/api/Ext.form.Action.Submit\" rel=\"Ext.form.Action.Submit\" class=\"docClass\">Ext.form.Action.Submit</a>.\nTo enable normal browser submission of an Ext Form, use the <a href=\"#!/api/Ext.form.BasicForm-cfg-standardSubmit\" rel=\"Ext.form.BasicForm-cfg-standardSubmit\" class=\"docClass\">standardSubmit</a> config option.</p>\n\n\n<p><b><u>File Uploads</u></b></p>\n\n\n<p><a href=\"#!/api/Ext.form.BasicForm-cfg-fileUpload\" rel=\"Ext.form.BasicForm-cfg-fileUpload\" class=\"docClass\">File uploads</a> are not performed using Ajax submission, that\nis they are <b>not</b> performed using XMLHttpRequests. Instead the form is submitted in the standard\nmanner with the DOM <tt>&lt;form></tt> element temporarily modified to have its\n<a href=\"http://www.w3.org/TR/REC-html40/present/frames.html#adef-target\">target</a> set to refer\nto a dynamically generated, hidden <tt>&lt;iframe></tt> which is inserted into the document\nbut removed after the return data has been gathered.</p>\n\n\n<p>The server response is parsed by the browser to create the document for the IFRAME. If the\nserver is using JSON to send the return object, then the\n<a href=\"http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17\">Content-Type</a> header\nmust be set to \"text/html\" in order to tell the browser to insert the text unchanged into the document body.</p>\n\n\n<p>Characters which are significant to an HTML parser must be sent as HTML entities, so encode\n\"&lt;\" as \"&amp;lt;\", \"&amp;\" as \"&amp;amp;\" etc.</p>\n\n\n<p>The response text is retrieved from the document, and a fake XMLHttpRequest object\nis created containing a <tt>responseText</tt> property in order to conform to the\nrequirements of event handlers and callbacks.</p>\n\n\n<p>Be aware that file upload packets are sent with the content type <a href=\"http://www.faqs.org/rfcs/rfc2388.html\">multipart/form</a>\nand some server technologies (notably JEE) may require some custom processing in order to\nretrieve parameter names and parameter values from the packet content.</p>\n\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-api' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-cfg-api' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-cfg-api' class='name expandable'>api</a><span> : Object</span></div><div class='description'><div class='short'>(Optional) If specified load and submit actions will be handled\nwith Ext.form.Action.DirectLoad and Ext.form.Action.D...</div><div class='long'><p>(Optional) If specified load and submit actions will be handled\nwith <a href=\"#!/api/Ext.form.Action.DirectLoad\" rel=\"Ext.form.Action.DirectLoad\" class=\"docClass\">Ext.form.Action.DirectLoad</a> and <a href=\"#!/api/Ext.form.Action.DirectSubmit\" rel=\"Ext.form.Action.DirectSubmit\" class=\"docClass\">Ext.form.Action.DirectSubmit</a>.\nMethods which have been imported by <a href=\"#!/api/Ext.Direct\" rel=\"Ext.Direct\" class=\"docClass\">Ext.Direct</a> can be specified here to load and submit\nforms.\nSuch as the following:</p>\n\n<pre><code>api: {\n    load: App.ss.MyProfile.load,\n    submit: App.ss.MyProfile.submit\n}\n</code></pre>\n\n\n<p>Load actions can use <code><a href=\"#!/api/Ext.form.BasicForm-cfg-paramOrder\" rel=\"Ext.form.BasicForm-cfg-paramOrder\" class=\"docClass\">paramOrder</a></code> or <code><a href=\"#!/api/Ext.form.BasicForm-cfg-paramsAsHash\" rel=\"Ext.form.BasicForm-cfg-paramsAsHash\" class=\"docClass\">paramsAsHash</a></code>\nto customize how the load method is invoked.\nSubmit actions will always use a standard form submit. The formHandler configuration must\nbe set on the associated server-side method which has been imported by <a href=\"#!/api/Ext.Direct\" rel=\"Ext.Direct\" class=\"docClass\">Ext.Direct</a></p>\n\n</div></div></div><div id='cfg-baseParams' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-cfg-baseParams' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-cfg-baseParams' class='name expandable'>baseParams</a><span> : Object</span></div><div class='description'><div class='short'>Parameters to pass with all requests. ...</div><div class='long'><p>Parameters to pass with all requests. e.g. baseParams: {id: '123', foo: 'bar'}.</p>\n\n\n<p>Parameters are encoded as standard HTTP parameters using <a href=\"#!/api/Ext-method-urlEncode\" rel=\"Ext-method-urlEncode\" class=\"docClass\">Ext.urlEncode</a>.</p>\n\n</div></div></div><div id='cfg-errorReader' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-cfg-errorReader' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-cfg-errorReader' class='name expandable'>errorReader</a><span> : DataReader</span></div><div class='description'><div class='short'>An Ext.data.DataReader (e.g. ...</div><div class='long'><p>An <a href=\"#!/api/Ext.data.DataReader\" rel=\"Ext.data.DataReader\" class=\"docClass\">Ext.data.DataReader</a> (e.g. <a href=\"#!/api/Ext.data.XmlReader\" rel=\"Ext.data.XmlReader\" class=\"docClass\">Ext.data.XmlReader</a>) to be used to\nread field error messages returned from 'submit' actions. This is optional\nas there is built-in support for processing JSON.</p>\n\n\n<p>The Records which provide messages for the invalid Fields must use the\nField name (or id) as the Record ID, and must contain a field called 'msg'\nwhich contains the error message.</p>\n\n\n<p>The errorReader does not have to be a full-blown implementation of a\nDataReader. It simply needs to implement a <tt>read(xhr)</tt> function\nwhich returns an Array of Records in an object with the following\nstructure:</p>\n\n\n<pre><code>{\n    records: recordArray\n}\n</code></pre>\n\n</div></div></div><div id='cfg-fileUpload' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-cfg-fileUpload' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-cfg-fileUpload' class='name expandable'>fileUpload</a><span> : Boolean</span></div><div class='description'><div class='short'>Set to true if this form is a file upload. ...</div><div class='long'><p>Set to true if this form is a file upload.</p>\n\n<p>File uploads are not performed using normal 'Ajax' techniques, that is they are <b>not</b>\nperformed using XMLHttpRequests. Instead the form is submitted in the standard manner with the\nDOM <tt>&lt;form></tt> element temporarily modified to have its\n<a href=\"http://www.w3.org/TR/REC-html40/present/frames.html#adef-target\">target</a> set to refer\nto a dynamically generated, hidden <tt>&lt;iframe></tt> which is inserted into the document\nbut removed after the return data has been gathered.</p>\n\n\n<p>The server response is parsed by the browser to create the document for the IFRAME. If the\nserver is using JSON to send the return object, then the\n<a href=\"http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17\">Content-Type</a> header\nmust be set to \"text/html\" in order to tell the browser to insert the text unchanged into the document body.</p>\n\n\n<p>Characters which are significant to an HTML parser must be sent as HTML entities, so encode\n\"&lt;\" as \"&amp;lt;\", \"&amp;\" as \"&amp;amp;\" etc.</p>\n\n\n<p>The response text is retrieved from the document, and a fake XMLHttpRequest object\nis created containing a <tt>responseText</tt> property in order to conform to the\nrequirements of event handlers and callbacks.</p>\n\n\n<p>Be aware that file upload packets are sent with the content type <a href=\"http://www.faqs.org/rfcs/rfc2388.html\">multipart/form</a>\nand some server technologies (notably JEE) may require some custom processing in order to\nretrieve parameter names and parameter values from the packet content.</p>\n\n</div></div></div><div id='cfg-listeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-cfg-listeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-cfg-listeners' class='name expandable'>listeners</a><span> : Object</span></div><div class='description'><div class='short'>(optional) A config object containing one or more event handlers to be added to this\nobject during initialization. ...</div><div class='long'><p>(optional) <p>A config object containing one or more event handlers to be added to this\nobject during initialization.  This should be a valid listeners config object as specified in the\n<a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> example for attaching multiple handlers at once.</p></p>\n\n<br><p><b><u>DOM events from ExtJs <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a></u></b></p>\n\n\n<br><p>While <i>some</i> ExtJs Component classes export selected DOM events (e.g. \"click\", \"mouseover\" etc), this\n\n\n<p>is usually only done when extra value can be added. For example the <a href=\"#!/api/Ext.DataView\" rel=\"Ext.DataView\" class=\"docClass\">DataView</a>'s\n<b><code><a href=\"#!/api/Ext.DataView-event-click\" rel=\"Ext.DataView-event-click\" class=\"docClass\">click</a></code></b> event passing the node clicked on. To access DOM\nevents directly from a Component's HTMLElement, listeners must be added to the <i><a href=\"#!/api/Ext.Component-method-getEl\" rel=\"Ext.Component-method-getEl\" class=\"docClass\">Element</a></i> after the Component\nhas been rendered. A plugin can simplify this step:</p>\n\n<pre><code>// Plugin is configured with a listeners config object.\n// The Component is appended to the argument list of all handler functions.\nExt.DomObserver = <a href=\"#!/api/Ext-method-extend\" rel=\"Ext-method-extend\" class=\"docClass\">Ext.extend</a>(Object, {\n    constructor: function(config) {\n        this.listeners = config.listeners ? config.listeners : config;\n    },\n\n    // Component passes itself into plugin&#39;s init method\n    init: function(c) {\n        var p, l = this.listeners;\n        for (p in l) {\n            if (<a href=\"#!/api/Ext-method-isFunction\" rel=\"Ext-method-isFunction\" class=\"docClass\">Ext.isFunction</a>(l[p])) {\n                l[p] = this.createHandler(l[p], c);\n            } else {\n                l[p].fn = this.createHandler(l[p].fn, c);\n            }\n        }\n\n        // Add the listeners to the Element immediately following the render call\n        c.render = c.render.<a href=\"#!/api/Function-method-createSequence\" rel=\"Function-method-createSequence\" class=\"docClass\">createSequence</a>(function() {\n            var e = c.getEl();\n            if (e) {\n                e.on(l);\n            }\n        });\n    },\n\n    createHandler: function(fn, c) {\n        return function(e) {\n            fn.call(this, e, c);\n        };\n    }\n});\n\nvar combo = new <a href=\"#!/api/Ext.form.ComboBox\" rel=\"Ext.form.ComboBox\" class=\"docClass\">Ext.form.ComboBox</a>({\n\n    // Collapse combo when its element is clicked on\n    plugins: [ new Ext.DomObserver({\n        click: function(evt, comp) {\n            comp.collapse();\n        }\n    })],\n    store: myStore,\n    typeAhead: true,\n    mode: 'local',\n    triggerAction: 'all'\n});\n</code></pre>\n\n\n<p></p></p>\n</div></div></div><div id='cfg-method' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-cfg-method' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-cfg-method' class='name not-expandable'>method</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'><p>The request method to use (GET or POST) for form actions if one isn't supplied in the action options.</p>\n</div><div class='long'><p>The request method to use (GET or POST) for form actions if one isn't supplied in the action options.</p>\n</div></div></div><div id='cfg-paramOrder' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-cfg-paramOrder' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-cfg-paramOrder' class='name expandable'>paramOrder</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>A list of params to be executed server side. ...</div><div class='long'><p>A list of params to be executed server side.\nDefaults to <tt>undefined</tt>. Only used for the <code><a href=\"#!/api/Ext.form.BasicForm-cfg-api\" rel=\"Ext.form.BasicForm-cfg-api\" class=\"docClass\">api</a></code>\n<code>load</code> configuration.</p>\n\n\n<br><p>Specify the params in the order in which they must be executed on the\n\n\n<p>server-side as either (1) an Array of String values, or (2) a String of params\ndelimited by either whitespace, comma, or pipe. For example,\nany of the following would be acceptable:</p></p>\n\n<pre><code>paramOrder: ['param1','param2','param3']\nparamOrder: 'param1 param2 param3'\nparamOrder: 'param1,param2,param3'\nparamOrder: 'param1|param2|param'\n     </code></pre>\n\n</div></div></div><div id='cfg-paramsAsHash' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-cfg-paramsAsHash' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-cfg-paramsAsHash' class='name expandable'>paramsAsHash</a><span> : Boolean</span></div><div class='description'><div class='short'>Only used for the api\nload configuration. ...</div><div class='long'><p>Only used for the <code><a href=\"#!/api/Ext.form.BasicForm-cfg-api\" rel=\"Ext.form.BasicForm-cfg-api\" class=\"docClass\">api</a></code>\n<code>load</code> configuration. Send parameters as a collection of named\narguments (defaults to <tt>false</tt>). Providing a\n<tt><a href=\"#!/api/Ext.form.BasicForm-cfg-paramOrder\" rel=\"Ext.form.BasicForm-cfg-paramOrder\" class=\"docClass\">paramOrder</a></tt> nullifies this configuration.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-reader' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-cfg-reader' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-cfg-reader' class='name expandable'>reader</a><span> : DataReader</span></div><div class='description'><div class='short'>An Ext.data.DataReader (e.g. ...</div><div class='long'><p>An <a href=\"#!/api/Ext.data.DataReader\" rel=\"Ext.data.DataReader\" class=\"docClass\">Ext.data.DataReader</a> (e.g. <a href=\"#!/api/Ext.data.XmlReader\" rel=\"Ext.data.XmlReader\" class=\"docClass\">Ext.data.XmlReader</a>) to be used to read\ndata when executing 'load' actions. This is optional as there is built-in\nsupport for processing JSON.  For additional information on using an XMLReader\nsee the example provided in examples/form/xml-form.html.</p>\n</div></div></div><div id='cfg-standardSubmit' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-cfg-standardSubmit' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-cfg-standardSubmit' class='name expandable'>standardSubmit</a><span> : Boolean</span></div><div class='description'><div class='short'>If set to true, standard HTML form submits are used instead\nof XHR (Ajax) style form submissions. ...</div><div class='long'><p>If set to <tt>true</tt>, standard HTML form submits are used instead\nof XHR (Ajax) style form submissions. Defaults to <tt>false</tt>.</p>\n\n\n<br><p><b>Note:</b> When using <code>standardSubmit</code>, the\n\n\n<p><code>options</code> to <code><a href=\"#!/api/Ext.form.BasicForm-method-submit\" rel=\"Ext.form.BasicForm-method-submit\" class=\"docClass\">submit</a></code> are ignored because\nExt's Ajax infrastracture is bypassed. To pass extra parameters (e.g.\n<code>baseParams</code> and <code>params</code>), utilize hidden fields\nto submit extra data, for example:</p></p>\n\n<pre><code>new Ext.FormPanel({\n    standardSubmit: true,\n    baseParams: {\n        foo: 'bar'\n    },\n    url: 'myProcess.php',\n    items: [{\n        xtype: 'textfield',\n        name: 'userName'\n    }],\n    buttons: [{\n        text: 'Save',\n        handler: function(){\n            var fp = this.ownerCt.ownerCt,\n                form = fp.getForm();\n            if (form.isValid()) {\n                // check if there are baseParams and if\n                // hiddent items have been added already\n                if (fp.baseParams && !fp.paramsAdded) {\n                    // add hidden items for all baseParams\n                    for (i in fp.baseParams) {\n                        fp.add({\n                            xtype: 'hidden',\n                            name: i,\n                            value: fp.baseParams[i]\n                        });\n                    }\n                    fp.doLayout();\n                    // set a custom flag to prevent re-adding\n                    fp.paramsAdded = true;\n                }\n                form.<a href=\"#!/api/Ext.form.BasicForm-method-submit\" rel=\"Ext.form.BasicForm-method-submit\" class=\"docClass\">submit</a>();\n            }\n        }\n    }]\n});\n</code></pre>\n\n</div></div></div><div id='cfg-timeout' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-cfg-timeout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-cfg-timeout' class='name expandable'>timeout</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>Timeout for form actions in seconds (default is 30 seconds). ...</div><div class='long'><p>Timeout for form actions in seconds (default is 30 seconds).</p>\n<p>Defaults to: <code>30</code></p></div></div></div><div id='cfg-trackResetOnLoad' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-cfg-trackResetOnLoad' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-cfg-trackResetOnLoad' class='name expandable'>trackResetOnLoad</a><span> : Boolean</span></div><div class='description'><div class='short'>If set to true, reset() resets to the last loaded\nor setValues() data instead of when the form was first created. ...</div><div class='long'><p>If set to <tt>true</tt>, <a href=\"#!/api/Ext.form.BasicForm-method-reset\" rel=\"Ext.form.BasicForm-method-reset\" class=\"docClass\">reset</a>() resets to the last loaded\nor <a href=\"#!/api/Ext.form.BasicForm-method-setValues\" rel=\"Ext.form.BasicForm-method-setValues\" class=\"docClass\">setValues</a>() data instead of when the form was first created.  Defaults to <tt>false</tt>.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-url' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-cfg-url' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-cfg-url' class='name not-expandable'>url</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'><p>The URL to use for form actions if one isn't supplied in the\n<code><a href=\"#!/api/Ext.form.BasicForm-method-doAction\" rel=\"Ext.form.BasicForm-method-doAction\" class=\"docClass\">doAction</a> options</code>.</p>\n</div><div class='long'><p>The URL to use for form actions if one isn't supplied in the\n<code><a href=\"#!/api/Ext.form.BasicForm-method-doAction\" rel=\"Ext.form.BasicForm-method-doAction\" class=\"docClass\">doAction</a> options</code>.</p>\n</div></div></div><div id='cfg-waitTitle' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-cfg-waitTitle' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-cfg-waitTitle' class='name expandable'>waitTitle</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The default title to show for the waiting message box (defaults to 'Please Wait...') ...</div><div class='long'><p>The default title to show for the waiting message box (defaults to <tt>'Please Wait...'</tt>)</p>\n<p>Defaults to: <code>'Please Wait...'</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-activeAction' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-property-activeAction' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-property-activeAction' class='name not-expandable'>activeAction</a><span> : Object</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'><p>private</p>\n</div><div class='long'><p>private</p>\n</div></div></div><div id='property-items' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-property-items' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-property-items' class='name not-expandable'>items</a><span> : MixedCollection</span></div><div class='description'><div class='short'><p>A <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">MixedCollection</a> containing all the Ext.form.Fields in this form.</p>\n</div><div class='long'><p>A <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">MixedCollection</a> containing all the Ext.form.Fields in this form.</p>\n</div></div></div><div id='property-waitMsgTarget' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-property-waitMsgTarget' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-property-waitMsgTarget' class='name expandable'>waitMsgTarget</a><span> : Mixed</span></div><div class='description'><div class='short'>By default wait messages are displayed with Ext.MessageBox.wait. ...</div><div class='long'><p>By default wait messages are displayed with <a href=\"#!/api/Ext.MessageBox-method-wait\" rel=\"Ext.MessageBox-method-wait\" class=\"docClass\">Ext.MessageBox.wait</a>. You can target a specific\nelement by passing it or its id or mask the form itself by passing in true.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Ext.form.BasicForm-method-constructor' class='name expandable'>Ext.form.BasicForm</a>( <span class='pre'>el, config</span> ) : <a href=\"#!/api/Ext.form.BasicForm\" rel=\"Ext.form.BasicForm\" class=\"docClass\">Ext.form.BasicForm</a></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : Mixed<div class='sub-desc'><p>The form element or its id</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration options</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.form.BasicForm\" rel=\"Ext.form.BasicForm\" class=\"docClass\">Ext.form.BasicForm</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-add' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-add' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-method-add' class='name expandable'>add</a>( <span class='pre'>field1, [field2], [etc]</span> ) : BasicForm<strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Add Ext.form Components to this form's Collection. ...</div><div class='long'><p>Add Ext.form Components to this form's Collection. This does not result in rendering of\nthe passed Component, it just enables the form to validate Fields, and distribute values to\nFields.</p>\n\n<p><b>You will not usually call this function. In order to be rendered, a Field must be added\nto a <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Container</a>, usually an <a href=\"#!/api/Ext.form.FormPanel\" rel=\"Ext.form.FormPanel\" class=\"docClass\">FormPanel</a>.\nThe FormPanel to which the field is added takes care of adding the Field to the BasicForm's\ncollection.</b></p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>field1</span> : Field<div class='sub-desc'>\n</div></li><li><span class='pre'>field2</span> : Field (optional)<div class='sub-desc'>\n</div></li><li><span class='pre'>etc</span> : Field (optional)<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>BasicForm</span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-addEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addEvents' class='name expandable'>addEvents</a>( <span class='pre'>o, Optional</span> )</div><div class='description'><div class='short'>Adds the specified events to the list of events which this Observable may fire. ...</div><div class='long'><p>Adds the specified events to the list of events which this Observable may fire.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object|<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Either an object with event names as properties with a value of <code>true</code>\nor the first event name string if multiple event names are being passed as separate parameters.</p>\n</div></li><li><span class='pre'>Optional</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>. Event name if multiple event names are being passed as separate parameters.\nUsage:</p>\n\n<pre><code>this.addEvents('storeloaded', 'storecleared');\n</code></pre>\n\n</div></li></ul></div></div></div><div id='method-addListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addListener' class='name expandable'>addListener</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object. ...</div><div class='long'><p>Appends an event handler to this object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to listen for.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes.</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.\nproperties. This may contain any of the following properties:<ul>\n<li><b>scope</b> : Object<div class=\"sub-desc\">The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></div></li>\n<li><b>delay</b> : Number<div class=\"sub-desc\">The number of milliseconds to delay the invocation of the handler after the event fires.</div></li>\n<li><b>single</b> : Boolean<div class=\"sub-desc\">True to add a handler to handle just the next firing of the event, and then remove itself.</div></li>\n<li><b>buffer</b> : Number<div class=\"sub-desc\">Causes the handler to be scheduled to run in an <a href=\"#!/api/Ext.util.DelayedTask\" rel=\"Ext.util.DelayedTask\" class=\"docClass\">Ext.util.DelayedTask</a> delayed\nby the specified number of milliseconds. If the event fires again within that time, the original\nhandler is <em>not</em> invoked, but the new handler is scheduled in its place.</div></li>\n<li><b>target</b> : Observable<div class=\"sub-desc\">Only call the handler if the event was fired on the target Observable, <i>not</i>\nif the event was bubbled up from a child Observable.</div></li>\n</ul><br></p>\n\n<p>\n<b>Combining Options</b><br>\nUsing the options argument, it is possible to combine different types of listeners:<br>\n<br>\nA delayed, one-time listener.\n<pre><code>myDataView.on('click', this.onClick, this, {\nsingle: true,\ndelay: 100\n});</code></pre>\n<p>\n<b>Attaching multiple handlers in 1 call</b><br>\nThe method also allows for a single argument to be passed which is a config object containing properties\nwhich specify multiple handlers.\n<p>\n<pre><code>myGridPanel.on({\n'click' : {\n    fn: this.onClick,\n    scope: this,\n    delay: 100\n},\n'mouseover' : {\n    fn: this.onMouseOver,\n    scope: this\n},\n'mouseout' : {\n    fn: this.onMouseOut,\n    scope: this\n}\n});</code></pre>\n<p>\nOr a shorthand syntax:<br>\n<pre><code>myGridPanel.on({\n'click' : this.onClick,\n'mouseover' : this.onMouseOver,\n'mouseout' : this.onMouseOut,\n scope: this\n});</code></pre>\n\n</p></p></p></p></div></li></ul></div></div></div><div id='method-afterAction' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-afterAction' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-method-afterAction' class='name expandable'>afterAction</a>( <span class='pre'>action, success</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>action</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>success</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-applyIfToFields' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-applyIfToFields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-method-applyIfToFields' class='name expandable'>applyIfToFields</a>( <span class='pre'>values</span> ) : BasicForm<strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Calls Ext.applyIf for all field in this form with the passed object. ...</div><div class='long'><p>Calls <a href=\"#!/api/Ext-method-applyIf\" rel=\"Ext-method-applyIf\" class=\"docClass\">Ext.applyIf</a> for all field in this form with the passed object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>values</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>BasicForm</span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-applyToFields' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-applyToFields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-method-applyToFields' class='name expandable'>applyToFields</a>( <span class='pre'>values</span> ) : BasicForm<strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Calls Ext.apply for all fields in this form with the passed object. ...</div><div class='long'><p>Calls <a href=\"#!/api/Ext-method-apply\" rel=\"Ext-method-apply\" class=\"docClass\">Ext.apply</a> for all fields in this form with the passed object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>values</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>BasicForm</span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-beforeAction' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-beforeAction' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-method-beforeAction' class='name expandable'>beforeAction</a>( <span class='pre'>action</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>action</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-callFieldMethod' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-callFieldMethod' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-method-callFieldMethod' class='name expandable'>callFieldMethod</a>( <span class='pre'>fnName, args</span> ) : <a href=\"#!/api/Ext.form.BasicForm\" rel=\"Ext.form.BasicForm\" class=\"docClass\">Ext.form.BasicForm</a><strong class='chainable signature' >chainable</strong><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fnName</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.form.BasicForm\" rel=\"Ext.form.BasicForm\" class=\"docClass\">Ext.form.BasicForm</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-cleanDestroyed' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-cleanDestroyed' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-method-cleanDestroyed' class='name expandable'>cleanDestroyed</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes all fields from the collection that have been destroyed. ...</div><div class='long'><p>Removes all fields from the collection that have been destroyed.</p>\n</div></div></div><div id='method-clearInvalid' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-clearInvalid' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-method-clearInvalid' class='name expandable'>clearInvalid</a>( <span class='pre'></span> ) : BasicForm<strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Clears all invalid messages in this form. ...</div><div class='long'><p>Clears all invalid messages in this form.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>BasicForm</span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-destroy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-destroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-method-destroy' class='name expandable'>destroy</a>( <span class='pre'>bound</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Destroys this object. ...</div><div class='long'><p>Destroys this object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>bound</span> : Boolean<div class='sub-desc'><p>true if the object is bound to a form panel. If this is the case\nthe FormPanel will take care of destroying certain things, so we're just doubling up.</p>\n</div></li></ul></div></div></div><div id='method-doAction' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-doAction' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-method-doAction' class='name expandable'>doAction</a>( <span class='pre'>actionName, [options]</span> ) : BasicForm<strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Performs a predefined action (Ext.form.Action.Submit or\nExt.form.Action.Load) or a custom extension of Ext.form.Actio...</div><div class='long'><p>Performs a predefined action (<a href=\"#!/api/Ext.form.Action.Submit\" rel=\"Ext.form.Action.Submit\" class=\"docClass\">Ext.form.Action.Submit</a> or\n<a href=\"#!/api/Ext.form.Action.Load\" rel=\"Ext.form.Action.Load\" class=\"docClass\">Ext.form.Action.Load</a>) or a custom extension of <a href=\"#!/api/Ext.form.Action\" rel=\"Ext.form.Action\" class=\"docClass\">Ext.form.Action</a>\nto perform application-specific processing.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>actionName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/Object<div class='sub-desc'><p>The name of the predefined action type,\nor instance of <a href=\"#!/api/Ext.form.Action\" rel=\"Ext.form.Action\" class=\"docClass\">Ext.form.Action</a> to perform.</p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>The options to pass to the <a href=\"#!/api/Ext.form.Action\" rel=\"Ext.form.Action\" class=\"docClass\">Ext.form.Action</a>.\nAll of the config options listed below are supported by both the\n<a href=\"#!/api/Ext.form.Action.Submit\" rel=\"Ext.form.Action.Submit\" class=\"docClass\">submit</a> and <a href=\"#!/api/Ext.form.Action.Load\" rel=\"Ext.form.Action.Load\" class=\"docClass\">load</a>\nactions unless otherwise noted (custom actions could also accept\nother config options):<ul></p>\n\n<p><li><b>url</b> : String<div class=\"sub-desc\">The url for the action (defaults\nto the form's <a href=\"#!/api/Ext.form.BasicForm-cfg-url\" rel=\"Ext.form.BasicForm-cfg-url\" class=\"docClass\">url</a>.)</div></li></p>\n\n<p><li><b>method</b> : String<div class=\"sub-desc\">The form method to use (defaults\nto the form's method, or POST if not defined)</div></li></p>\n\n<p><li><b>params</b> : String/Object<div class=\"sub-desc\"><p>The params to pass\n(defaults to the form's baseParams, or none if not defined)</p></p>\n\n<p>Parameters are encoded as standard HTTP parameters using <a href=\"#!/api/Ext-method-urlEncode\" rel=\"Ext-method-urlEncode\" class=\"docClass\">Ext.urlEncode</a>.</p>\n\n\n<p></div></li></p>\n\n<p><li><b>headers</b> : Object<div class=\"sub-desc\">Request headers to set for the action\n(defaults to the form's default headers)</div></li></p>\n\n<p><li><b>success</b> : Function<div class=\"sub-desc\">The callback that will\nbe invoked after a successful response (see top of\n<a href=\"#!/api/Ext.form.Action.Submit\" rel=\"Ext.form.Action.Submit\" class=\"docClass\">submit</a> and <a href=\"#!/api/Ext.form.Action.Load\" rel=\"Ext.form.Action.Load\" class=\"docClass\">load</a>\nfor a description of what constitutes a successful response).\nThe function is passed the following parameters:<ul>\n<li><tt>form</tt> : <a href=\"#!/api/Ext.form.BasicForm\" rel=\"Ext.form.BasicForm\" class=\"docClass\">Ext.form.BasicForm</a><div class=\"sub-desc\">The form that requested the action</div></li>\n<li><tt>action</tt> : The <a href=\"#!/api/Ext.form.Action\" rel=\"Ext.form.Action\" class=\"docClass\">Action</a> object which performed the operation.</p>\n\n<div class=\"sub-desc\">The action object contains these properties of interest:<ul>\n<li><tt><a href=\"#!/api/Ext.form.Action-property-response\" rel=\"Ext.form.Action-property-response\" class=\"docClass\">response</a></tt></li>\n<li><tt><a href=\"#!/api/Ext.form.Action-property-result\" rel=\"Ext.form.Action-property-result\" class=\"docClass\">result</a></tt> : interrogate for custom postprocessing</li>\n<li><tt><a href=\"#!/api/Ext.form.Action-property-type\" rel=\"Ext.form.Action-property-type\" class=\"docClass\">type</a></tt></li>\n</ul></div>\n\n\n<p></li></ul></div></li></p>\n\n<p><li><b>failure</b> : Function<div class=\"sub-desc\">The callback that will be invoked after a\nfailed transaction attempt. The function is passed the following parameters:<ul>\n<li><tt>form</tt> : The <a href=\"#!/api/Ext.form.BasicForm\" rel=\"Ext.form.BasicForm\" class=\"docClass\">Ext.form.BasicForm</a> that requested the action.</li>\n<li><tt>action</tt> : The <a href=\"#!/api/Ext.form.Action\" rel=\"Ext.form.Action\" class=\"docClass\">Action</a> object which performed the operation.</p>\n\n<div class=\"sub-desc\">The action object contains these properties of interest:<ul>\n<li><tt><a href=\"#!/api/Ext.form.Action-property-failureType\" rel=\"Ext.form.Action-property-failureType\" class=\"docClass\">failureType</a></tt></li>\n<li><tt><a href=\"#!/api/Ext.form.Action-property-response\" rel=\"Ext.form.Action-property-response\" class=\"docClass\">response</a></tt></li>\n<li><tt><a href=\"#!/api/Ext.form.Action-property-result\" rel=\"Ext.form.Action-property-result\" class=\"docClass\">result</a></tt> : interrogate for custom postprocessing</li>\n<li><tt><a href=\"#!/api/Ext.form.Action-property-type\" rel=\"Ext.form.Action-property-type\" class=\"docClass\">type</a></tt></li>\n</ul></div>\n\n\n<p></li></ul></div></li></p>\n\n<p><li><b>scope</b> : Object<div class=\"sub-desc\">The scope in which to call the\ncallback functions (The <tt>this</tt> reference for the callback functions).</div></li></p>\n\n<p><li><b>clientValidation</b> : Boolean<div class=\"sub-desc\">Submit Action only.\nDetermines whether a Form's fields are validated in a final call to\n<a href=\"#!/api/Ext.form.BasicForm-method-isValid\" rel=\"Ext.form.BasicForm-method-isValid\" class=\"docClass\">isValid</a> prior to submission. Set to <tt>false</tt>\nto prevent this. If undefined, pre-submission field validation is performed.</div></li></ul></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>BasicForm</span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-enableBubble' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-enableBubble' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-enableBubble' class='name expandable'>enableBubble</a>( <span class='pre'>events</span> )</div><div class='description'><div class='short'>Enables events fired by this Observable to bubble up an owner hierarchy by calling\nthis.getBubbleTarget() if present. ...</div><div class='long'><p>Enables events fired by this Observable to bubble up an owner hierarchy by calling\n<code>this.getBubbleTarget()</code> if present. There is no implementation in the Observable base class.</p>\n\n\n<p>This is commonly used by Ext.Components to bubble events to owner Containers. See Ext.Component.getBubbleTarget. The default\nimplementation in <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> returns the Component's immediate owner. But if a known target is required, this can be overridden to\naccess the required target more quickly.</p>\n\n\n<p>Example:</p>\n\n\n<pre><code><a href=\"#!/api/Ext-method-override\" rel=\"Ext-method-override\" class=\"docClass\">Ext.override</a>(<a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a>, {\n    //  Add functionality to Field&#39;s initComponent to enable the change event to bubble\n    initComponent : Ext.form.Field.prototype.initComponent.createSequence(function() {\n        this.enableBubble('change');\n    }),\n\n    //  We know that we want Field&#39;s events to bubble directly to the FormPanel.\n    getBubbleTarget : function() {\n        if (!this.formPanel) {\n            this.formPanel = this.findParentByType('form');\n        }\n        return this.formPanel;\n    }\n});\n\nvar myForm = new Ext.formPanel({\n    title: 'User Details',\n    items: [{\n        ...\n    }],\n    listeners: {\n        change: function() {\n            // Title goes red if form has been modified.\n            myForm.header.setStyle('color', 'red');\n        }\n    }\n});\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>events</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The event name to bubble, or an Array of event names.</p>\n</div></li></ul></div></div></div><div id='method-findField' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-findField' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-method-findField' class='name expandable'>findField</a>( <span class='pre'>id</span> ) : Object</div><div class='description'><div class='short'>Find a Ext.form.Field in this form. ...</div><div class='long'><p>Find a <a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a> in this form.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The value to search for (specify either a <a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a>,\n<a href=\"#!/api/Ext.grid.Column-cfg-dataIndex\" rel=\"Ext.grid.Column-cfg-dataIndex\" class=\"docClass\">dataIndex</a>, <a href=\"#!/api/Ext.form.Field-method-getName\" rel=\"Ext.form.Field-method-getName\" class=\"docClass\">name or hiddenName</a>).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Field</p>\n</div></li></ul></div></div></div><div id='method-fireEvent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-fireEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-fireEvent' class='name expandable'>fireEvent</a>( <span class='pre'>eventName, args</span> ) : Boolean</div><div class='description'><div class='short'>Fires the specified event with the passed parameters (minus the event name). ...</div><div class='long'><p>Fires the specified event with the passed parameters (minus the event name).</p>\n\n\n<p>An event may be set to bubble up an Observable parent hierarchy (See <a href=\"#!/api/Ext.Component-method-getBubbleTarget\" rel=\"Ext.Component-method-getBubbleTarget\" class=\"docClass\">Ext.Component.getBubbleTarget</a>)\nby calling <a href=\"#!/api/Ext.util.Observable-method-enableBubble\" rel=\"Ext.util.Observable-method-enableBubble\" class=\"docClass\">enableBubble</a>.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to fire.</p>\n</div></li><li><span class='pre'>args</span> : Object...<div class='sub-desc'><p>Variable number of parameters are passed to handlers.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>returns false if any of the handlers return false otherwise it returns true.</p>\n</div></li></ul></div></div></div><div id='method-getEl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-getEl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-method-getEl' class='name expandable'>getEl</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Get the HTML form Element ...</div><div class='long'><p>Get the HTML form Element</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></p>\n</div></li></ul></div></div></div><div id='method-getFieldValues' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-getFieldValues' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-method-getFieldValues' class='name expandable'>getFieldValues</a>( <span class='pre'>[dirtyOnly]</span> ) : Object</div><div class='description'><div class='short'>Retrieves the fields in the form as a set of key/value pairs, using the getValue() method. ...</div><div class='long'><p>Retrieves the fields in the form as a set of key/value pairs, using the <a href=\"#!/api/Ext.form.Field-method-getValue\" rel=\"Ext.form.Field-method-getValue\" class=\"docClass\">getValue()</a> method.\nIf multiple fields exist with the same name they are returned as an array.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>dirtyOnly</span> : Boolean (optional)<div class='sub-desc'><p>True to return only fields that are dirty.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>The values in the form</p>\n</div></li></ul></div></div></div><div id='method-getValues' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-getValues' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-method-getValues' class='name expandable'>getValues</a>( <span class='pre'>[asString]</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/Object</div><div class='description'><div class='short'>Returns the fields in this form as an object with key/value pairs as they would be submitted using a standard form su...</div><div class='long'><p>Returns the fields in this form as an object with key/value pairs as they would be submitted using a standard form submit.\nIf multiple fields exist with the same name they are returned as an array.</p>\n\n\n<p><b>Note:</b> The values are collected from all enabled HTML input elements within the form, <u>not</u> from\nthe Ext Field objects. This means that all returned values are Strings (or Arrays of Strings) and that the\nvalue can potentially be the emptyText of a field.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>asString</span> : Boolean (optional)<div class='sub-desc'><p>Pass true to return the values as a string. (defaults to false, returning an Object)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-hasListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-hasListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-hasListener' class='name expandable'>hasListener</a>( <span class='pre'>eventName</span> ) : Boolean</div><div class='description'><div class='short'>Checks to see if this object has any listeners for a specified event ...</div><div class='long'><p>Checks to see if this object has any listeners for a specified event</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to check for</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if the event is being listened for, else false</p>\n</div></li></ul></div></div></div><div id='method-initEl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-initEl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-method-initEl' class='name expandable'>initEl</a>( <span class='pre'>el</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isDirty' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-isDirty' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-method-isDirty' class='name expandable'>isDirty</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Returns true if any fields in this form have changed from their original values. ...</div><div class='long'><p>Returns true if any fields in this form have changed from their original values.</p>\n\n\n<p>Note that if this BasicForm was configured with <a href=\"#!/api/Ext.form.BasicForm-cfg-trackResetOnLoad\" rel=\"Ext.form.BasicForm-cfg-trackResetOnLoad\" class=\"docClass\">trackResetOnLoad</a> then the\nFields' <i>original values</i> are updated when the values are loaded by <a href=\"#!/api/Ext.form.BasicForm-method-setValues\" rel=\"Ext.form.BasicForm-method-setValues\" class=\"docClass\">setValues</a>\nor <a href=\"#!/api/Ext.form.BasicForm-method-loadRecord\" rel=\"Ext.form.BasicForm-method-loadRecord\" class=\"docClass\">loadRecord</a>.</p>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Boolean</p>\n</div></li></ul></div></div></div><div id='method-isValid' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-isValid' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-method-isValid' class='name expandable'>isValid</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Returns true if client-side validation on the form is successful. ...</div><div class='long'><p>Returns true if client-side validation on the form is successful.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Boolean</p>\n</div></li></ul></div></div></div><div id='method-load' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-load' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-method-load' class='name expandable'>load</a>( <span class='pre'>options</span> ) : BasicForm<strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Shortcut to do a load action. ...</div><div class='long'><p>Shortcut to <a href=\"#!/api/Ext.form.BasicForm-method-doAction\" rel=\"Ext.form.BasicForm-method-doAction\" class=\"docClass\">do</a> a <a href=\"#!/api/Ext.form.Action.Load\" rel=\"Ext.form.Action.Load\" class=\"docClass\">load action</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>options</span> : Object<div class='sub-desc'><p>The options to pass to the action (see <a href=\"#!/api/Ext.form.BasicForm-method-doAction\" rel=\"Ext.form.BasicForm-method-doAction\" class=\"docClass\">doAction</a> for details)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>BasicForm</span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-loadRecord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-loadRecord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-method-loadRecord' class='name expandable'>loadRecord</a>( <span class='pre'>record</span> ) : BasicForm<strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Loads an Ext.data.Record into this form by calling setValues with the\nrecord data. ...</div><div class='long'><p>Loads an <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a> into this form by calling <a href=\"#!/api/Ext.form.BasicForm-method-setValues\" rel=\"Ext.form.BasicForm-method-setValues\" class=\"docClass\">setValues</a> with the\n<a href=\"#!/api/Ext.data.Record-property-data\" rel=\"Ext.data.Record-property-data\" class=\"docClass\">record data</a>.\nSee also <a href=\"#!/api/Ext.form.BasicForm-cfg-trackResetOnLoad\" rel=\"Ext.form.BasicForm-cfg-trackResetOnLoad\" class=\"docClass\">trackResetOnLoad</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>record</span> : Record<div class='sub-desc'><p>The record to load</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>BasicForm</span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-markInvalid' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-markInvalid' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-method-markInvalid' class='name expandable'>markInvalid</a>( <span class='pre'>errors</span> ) : BasicForm<strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Mark fields in this form invalid in bulk. ...</div><div class='long'><p>Mark fields in this form invalid in bulk.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>errors</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Object<div class='sub-desc'><p>Either an array in the form [{id:'fieldId', msg:'The message'},...] or an object hash of {id: msg, id2: msg2}</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>BasicForm</span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-on' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-on' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-on' class='name expandable'>on</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object (shorthand for addListener.) ...</div><div class='long'><p>Appends an event handler to this object (shorthand for <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event to listen for</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.</p>\n</div></li></ul></div></div></div><div id='method-onSubmit' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-onSubmit' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-method-onSubmit' class='name expandable'>onSubmit</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-purgeListeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-purgeListeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-purgeListeners' class='name expandable'>purgeListeners</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes all listeners for this object ...</div><div class='long'><p>Removes all listeners for this object</p>\n</div></div></div><div id='method-relayEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-relayEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-relayEvents' class='name expandable'>relayEvents</a>( <span class='pre'>o, events</span> )</div><div class='description'><div class='short'>Relays selected events from the specified Observable as if the events were fired by this. ...</div><div class='long'><p>Relays selected events from the specified Observable as if the events were fired by <tt><b>this</b></tt>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The Observable whose events this object is to relay.</p>\n</div></li><li><span class='pre'>events</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>Array of event names to relay.</p>\n</div></li></ul></div></div></div><div id='method-remove' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-remove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-method-remove' class='name expandable'>remove</a>( <span class='pre'>field</span> ) : BasicForm<strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Removes a field from the items collection (does NOT remove its markup). ...</div><div class='long'><p>Removes a field from the items collection (does NOT remove its markup).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>field</span> : Field<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>BasicForm</span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-removeListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-removeListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-removeListener' class='name expandable'>removeListener</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler. ...</div><div class='long'><p>Removes an event handler.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div><div id='method-render' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-render' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-method-render' class='name expandable'>render</a>( <span class='pre'></span> ) : BasicForm<strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Iterates through the Fields which have been added to this BasicForm,\nchecks them for an id attribute, and calls Ext.f...</div><div class='long'><p>Iterates through the <a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Field</a>s which have been <a href=\"#!/api/Ext.form.BasicForm-method-add\" rel=\"Ext.form.BasicForm-method-add\" class=\"docClass\">add</a>ed to this BasicForm,\nchecks them for an id attribute, and calls <a href=\"#!/api/Ext.form.Field-method-applyToMarkup\" rel=\"Ext.form.Field-method-applyToMarkup\" class=\"docClass\">Ext.form.Field.applyToMarkup</a> on the existing dom element with that id.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>BasicForm</span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-reset' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-reset' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-method-reset' class='name expandable'>reset</a>( <span class='pre'></span> ) : BasicForm<strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Resets this form. ...</div><div class='long'><p>Resets this form.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>BasicForm</span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-resumeEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-resumeEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-resumeEvents' class='name expandable'>resumeEvents</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Resume firing events. ...</div><div class='long'><p>Resume firing events. (see <a href=\"#!/api/Ext.util.Observable-method-suspendEvents\" rel=\"Ext.util.Observable-method-suspendEvents\" class=\"docClass\">suspendEvents</a>)\nIf events were suspended using the <tt><b>queueSuspended</b></tt> parameter, then all\nevents fired during event suspension will be sent to any listeners now.</p>\n</div></div></div><div id='method-setValues' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-setValues' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-method-setValues' class='name expandable'>setValues</a>( <span class='pre'>values</span> ) : BasicForm<strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Set values for fields in this form in bulk. ...</div><div class='long'><p>Set values for fields in this form in bulk.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>values</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Object<div class='sub-desc'><p>Either an array in the form:</p>\n\n<pre><code>[{id:'clientName', value:'Fred. Olsen Lines'},\n {id:'portOfLoading', value:'FXT'},\n {id:'portOfDischarge', value:'OSL'} ]</code></pre>\n\n\n<p>or an object hash of the form:</p>\n\n<pre><code>{\n    clientName: 'Fred. Olsen Lines',\n    portOfLoading: 'FXT',\n    portOfDischarge: 'OSL'\n}</code></pre>\n\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>BasicForm</span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-submit' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-submit' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-method-submit' class='name expandable'>submit</a>( <span class='pre'>options</span> ) : BasicForm</div><div class='description'><div class='short'>Shortcut to do a submit action. ...</div><div class='long'><p>Shortcut to <a href=\"#!/api/Ext.form.BasicForm-method-doAction\" rel=\"Ext.form.BasicForm-method-doAction\" class=\"docClass\">do</a> a <a href=\"#!/api/Ext.form.Action.Submit\" rel=\"Ext.form.Action.Submit\" class=\"docClass\">submit action</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>options</span> : Object<div class='sub-desc'><p>The options to pass to the action (see <a href=\"#!/api/Ext.form.BasicForm-method-doAction\" rel=\"Ext.form.BasicForm-method-doAction\" class=\"docClass\">doAction</a> for details).<br></p>\n\n<p><b>Note:</b> this is ignored when using the <a href=\"#!/api/Ext.form.BasicForm-cfg-standardSubmit\" rel=\"Ext.form.BasicForm-cfg-standardSubmit\" class=\"docClass\">standardSubmit</a> option.</p>\n\n\n<p>The following code:</p>\n\n\n<pre><code>myFormPanel.getForm().submit({\n    clientValidation: true,\n    url: 'updateConsignment.php',\n    params: {\n        newStatus: 'delivered'\n    },\n    success: function(form, action) {\n       Ext.Msg.alert('Success', action.result.msg);\n    },\n    failure: function(form, action) {\n        switch (action.failureType) {\n            case <a href=\"#!/api/Ext.form.Action\" rel=\"Ext.form.Action\" class=\"docClass\">Ext.form.Action</a>.CLIENT_INVALID:\n                Ext.Msg.alert('Failure', 'Form fields may not be submitted with invalid values');\n                break;\n            case <a href=\"#!/api/Ext.form.Action\" rel=\"Ext.form.Action\" class=\"docClass\">Ext.form.Action</a>.CONNECT_FAILURE:\n                Ext.Msg.alert('Failure', 'Ajax communication failed');\n                break;\n            case <a href=\"#!/api/Ext.form.Action\" rel=\"Ext.form.Action\" class=\"docClass\">Ext.form.Action</a>.SERVER_INVALID:\n               Ext.Msg.alert('Failure', action.result.msg);\n       }\n    }\n});\n</code></pre>\n\n\n<p>would process the following server response for a successful submission:</p>\n\n<pre><code>{\n    \"success\":true, // note this is Boolean, not string\n    \"msg\":\"Consignment updated\"\n}\n</code></pre>\n\n\n<p>and the following server response for a failed submission:</p>\n\n<pre><code>{\n    \"success\":false, // note this is Boolean, not string\n    \"msg\":\"You do not have permission to perform this operation\"\n}\n</code></pre>\n\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>BasicForm</span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-suspendEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-suspendEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-suspendEvents' class='name expandable'>suspendEvents</a>( <span class='pre'>queueSuspended</span> )</div><div class='description'><div class='short'>Suspend the firing of all events. ...</div><div class='long'><p>Suspend the firing of all events. (see <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a>)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>queueSuspended</span> : Boolean<div class='sub-desc'><p>Pass as true to queue up suspended events to be fired\nafter the <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a> call instead of discarding all suspended events;</p>\n</div></li></ul></div></div></div><div id='method-un' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-un' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-un' class='name expandable'>un</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler (shorthand for removeListener.) ...</div><div class='long'><p>Removes an event handler (shorthand for <a href=\"#!/api/Ext.util.Observable-method-removeListener\" rel=\"Ext.util.Observable-method-removeListener\" class=\"docClass\">removeListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div><div id='method-updateRecord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-method-updateRecord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-method-updateRecord' class='name expandable'>updateRecord</a>( <span class='pre'>record</span> ) : BasicForm<strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Persists the values in this form into the passed Ext.data.Record object in a beginEdit/endEdit block. ...</div><div class='long'><p>Persists the values in this form into the passed <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a> object in a beginEdit/endEdit block.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>record</span> : Record<div class='sub-desc'><p>The record to edit</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>BasicForm</span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-event'>Events</h3><div class='subsection'><div id='event-actioncomplete' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-event-actioncomplete' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-event-actioncomplete' class='name expandable'>actioncomplete</a>( <span class='pre'>this, action</span> )</div><div class='description'><div class='short'>Fires when an action is completed. ...</div><div class='long'><p>Fires when an action is completed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : Form<div class='sub-desc'>\n</div></li><li><span class='pre'>action</span> : Action<div class='sub-desc'><p>The <a href=\"#!/api/Ext.form.Action\" rel=\"Ext.form.Action\" class=\"docClass\">Ext.form.Action</a> that completed</p>\n</div></li></ul></div></div></div><div id='event-actionfailed' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-event-actionfailed' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-event-actionfailed' class='name expandable'>actionfailed</a>( <span class='pre'>this, action</span> )</div><div class='description'><div class='short'>Fires when an action fails. ...</div><div class='long'><p>Fires when an action fails.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : Form<div class='sub-desc'>\n</div></li><li><span class='pre'>action</span> : Action<div class='sub-desc'><p>The <a href=\"#!/api/Ext.form.Action\" rel=\"Ext.form.Action\" class=\"docClass\">Ext.form.Action</a> that failed</p>\n</div></li></ul></div></div></div><div id='event-beforeaction' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.BasicForm'>Ext.form.BasicForm</span><br/><a href='source/BasicForm.html#Ext-form-BasicForm-event-beforeaction' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.BasicForm-event-beforeaction' class='name expandable'>beforeaction</a>( <span class='pre'>this, action</span> )</div><div class='description'><div class='short'>Fires before any action is performed. ...</div><div class='long'><p>Fires before any action is performed. Return false to cancel the action.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : Form<div class='sub-desc'>\n</div></li><li><span class='pre'>action</span> : Action<div class='sub-desc'><p>The <a href=\"#!/api/Ext.form.Action\" rel=\"Ext.form.Action\" class=\"docClass\">Ext.form.Action</a> to be performed</p>\n</div></li></ul></div></div></div></div></div></div></div>","superclasses":["Ext.util.Observable"],"meta":{},"requires":[],"html_meta":{},"statics":{"property":[],"cfg":[],"css_var":[],"method":[],"event":[],"css_mixin":[]},"files":[{"href":"BasicForm.html#Ext-form-BasicForm","filename":"BasicForm.js"}],"linenr":1,"members":{"property":[{"tagname":"property","owner":"Ext.form.BasicForm","meta":{"private":true},"name":"activeAction","id":"property-activeAction"},{"tagname":"property","owner":"Ext.form.BasicForm","meta":{},"name":"items","id":"property-items"},{"tagname":"property","owner":"Ext.form.BasicForm","meta":{},"name":"waitMsgTarget","id":"property-waitMsgTarget"}],"cfg":[{"tagname":"cfg","owner":"Ext.form.BasicForm","meta":{},"name":"api","id":"cfg-api"},{"tagname":"cfg","owner":"Ext.form.BasicForm","meta":{},"name":"baseParams","id":"cfg-baseParams"},{"tagname":"cfg","owner":"Ext.form.BasicForm","meta":{},"name":"errorReader","id":"cfg-errorReader"},{"tagname":"cfg","owner":"Ext.form.BasicForm","meta":{},"name":"fileUpload","id":"cfg-fileUpload"},{"tagname":"cfg","owner":"Ext.util.Observable","meta":{},"name":"listeners","id":"cfg-listeners"},{"tagname":"cfg","owner":"Ext.form.BasicForm","meta":{},"name":"method","id":"cfg-method"},{"tagname":"cfg","owner":"Ext.form.BasicForm","meta":{},"name":"paramOrder","id":"cfg-paramOrder"},{"tagname":"cfg","owner":"Ext.form.BasicForm","meta":{},"name":"paramsAsHash","id":"cfg-paramsAsHash"},{"tagname":"cfg","owner":"Ext.form.BasicForm","meta":{},"name":"reader","id":"cfg-reader"},{"tagname":"cfg","owner":"Ext.form.BasicForm","meta":{},"name":"standardSubmit","id":"cfg-standardSubmit"},{"tagname":"cfg","owner":"Ext.form.BasicForm","meta":{},"name":"timeout","id":"cfg-timeout"},{"tagname":"cfg","owner":"Ext.form.BasicForm","meta":{},"name":"trackResetOnLoad","id":"cfg-trackResetOnLoad"},{"tagname":"cfg","owner":"Ext.form.BasicForm","meta":{},"name":"url","id":"cfg-url"},{"tagname":"cfg","owner":"Ext.form.BasicForm","meta":{},"name":"waitTitle","id":"cfg-waitTitle"}],"css_var":[],"method":[{"tagname":"method","owner":"Ext.form.BasicForm","meta":{},"name":"constructor","id":"method-constructor"},{"tagname":"method","owner":"Ext.form.BasicForm","meta":{"chainable":true},"name":"add","id":"method-add"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addEvents","id":"method-addEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addListener","id":"method-addListener"},{"tagname":"method","owner":"Ext.form.BasicForm","meta":{"private":true},"name":"afterAction","id":"method-afterAction"},{"tagname":"method","owner":"Ext.form.BasicForm","meta":{"chainable":true},"name":"applyIfToFields","id":"method-applyIfToFields"},{"tagname":"method","owner":"Ext.form.BasicForm","meta":{"chainable":true},"name":"applyToFields","id":"method-applyToFields"},{"tagname":"method","owner":"Ext.form.BasicForm","meta":{"private":true},"name":"beforeAction","id":"method-beforeAction"},{"tagname":"method","owner":"Ext.form.BasicForm","meta":{"chainable":true,"private":true},"name":"callFieldMethod","id":"method-callFieldMethod"},{"tagname":"method","owner":"Ext.form.BasicForm","meta":{},"name":"cleanDestroyed","id":"method-cleanDestroyed"},{"tagname":"method","owner":"Ext.form.BasicForm","meta":{"chainable":true},"name":"clearInvalid","id":"method-clearInvalid"},{"tagname":"method","owner":"Ext.form.BasicForm","meta":{"private":true},"name":"destroy","id":"method-destroy"},{"tagname":"method","owner":"Ext.form.BasicForm","meta":{"chainable":true},"name":"doAction","id":"method-doAction"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"enableBubble","id":"method-enableBubble"},{"tagname":"method","owner":"Ext.form.BasicForm","meta":{},"name":"findField","id":"method-findField"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"fireEvent","id":"method-fireEvent"},{"tagname":"method","owner":"Ext.form.BasicForm","meta":{},"name":"getEl","id":"method-getEl"},{"tagname":"method","owner":"Ext.form.BasicForm","meta":{},"name":"getFieldValues","id":"method-getFieldValues"},{"tagname":"method","owner":"Ext.form.BasicForm","meta":{},"name":"getValues","id":"method-getValues"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"hasListener","id":"method-hasListener"},{"tagname":"method","owner":"Ext.form.BasicForm","meta":{"private":true},"name":"initEl","id":"method-initEl"},{"tagname":"method","owner":"Ext.form.BasicForm","meta":{},"name":"isDirty","id":"method-isDirty"},{"tagname":"method","owner":"Ext.form.BasicForm","meta":{},"name":"isValid","id":"method-isValid"},{"tagname":"method","owner":"Ext.form.BasicForm","meta":{"chainable":true},"name":"load","id":"method-load"},{"tagname":"method","owner":"Ext.form.BasicForm","meta":{"chainable":true},"name":"loadRecord","id":"method-loadRecord"},{"tagname":"method","owner":"Ext.form.BasicForm","meta":{"chainable":true},"name":"markInvalid","id":"method-markInvalid"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"on","id":"method-on"},{"tagname":"method","owner":"Ext.form.BasicForm","meta":{"private":true},"name":"onSubmit","id":"method-onSubmit"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"purgeListeners","id":"method-purgeListeners"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"relayEvents","id":"method-relayEvents"},{"tagname":"method","owner":"Ext.form.BasicForm","meta":{"chainable":true},"name":"remove","id":"method-remove"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"removeListener","id":"method-removeListener"},{"tagname":"method","owner":"Ext.form.BasicForm","meta":{"chainable":true},"name":"render","id":"method-render"},{"tagname":"method","owner":"Ext.form.BasicForm","meta":{"chainable":true},"name":"reset","id":"method-reset"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"resumeEvents","id":"method-resumeEvents"},{"tagname":"method","owner":"Ext.form.BasicForm","meta":{"chainable":true},"name":"setValues","id":"method-setValues"},{"tagname":"method","owner":"Ext.form.BasicForm","meta":{},"name":"submit","id":"method-submit"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"suspendEvents","id":"method-suspendEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"un","id":"method-un"},{"tagname":"method","owner":"Ext.form.BasicForm","meta":{"chainable":true},"name":"updateRecord","id":"method-updateRecord"}],"event":[{"tagname":"event","owner":"Ext.form.BasicForm","meta":{},"name":"actioncomplete","id":"event-actioncomplete"},{"tagname":"event","owner":"Ext.form.BasicForm","meta":{},"name":"actionfailed","id":"event-actionfailed"},{"tagname":"event","owner":"Ext.form.BasicForm","meta":{},"name":"beforeaction","id":"event-beforeaction"}],"css_mixin":[]},"inheritable":null,"private":null,"component":false,"name":"Ext.form.BasicForm","singleton":false,"override":null,"inheritdoc":null,"id":"class-Ext.form.BasicForm","mixins":[],"mixedInto":[]});