# NAME

App::Greple::xlate - μονάδα υποστήριξης μετάφρασης για το greple

# SYNOPSIS

    greple -Mxlate -e ENGINE --xlate pattern target-file

    greple -Mxlate::deepl --xlate pattern target-file

# VERSION

Version 0.26

# DESCRIPTION

**Greple** Το μοντούλο **xlate** εντοπίζει τα τμήματα κειμένου και τα αντικαθιστά με το μεταφρασμένο κείμενο. Περιλαμβάνει τα μοντούλα DeepL (`deepl.pm`) και ChatGPT (`gpt3.pm`) για τη μηχανή πίσω από το σύστημα.

Εάν θέλετε να μεταφράσετε ένα κανονικό τμήμα κειμένου σε έγγραφο στυλ [pod](https://metacpan.org/pod/pod), χρησιμοποιήστε την εντολή **greple** με τις μονάδες `xlate::deepl` και `perl` όπως εξής:

    greple -Mxlate::deepl -Mperl --pod --re '^(\w.*\n)+' --all foo.pm

Το πρότυπο `^(\w.*\n)+` σημαίνει συνεχόμενες γραμμές που ξεκινούν με αλφαριθμητικό γράμμα. Αυτή η εντολή εμφανίζει την περιοχή που πρόκειται να μεταφραστεί. Η επιλογή **--all** χρησιμοποιείται για να παράγει ολόκληρο το κείμενο.

<div>
    <p>
    <img width="750" src="https://raw.githubusercontent.com/kaz-utashiro/App-Greple-xlate/main/images/select-area.png">
    </p>
</div>

Στη συνέχεια, προσθέστε την επιλογή `--xlate` για να μεταφράσετε την επιλεγμένη περιοχή. Θα την εντοπίσει και θα την αντικαταστήσει με την έξοδο της εντολής **deepl**.

Από προεπιλογή, το αρχικό και το μεταφρασμένο κείμενο εκτυπώνονται στη μορφή "conflict marker" συμβατή με το [git(1)](http://man.he.net/man1/git). Χρησιμοποιώντας τη μορφή `ifdef`, μπορείτε να λάβετε το επιθυμητό τμήμα με την εντολή [unifdef(1)](http://man.he.net/man1/unifdef) εύκολα. Η μορφή μπορεί να καθοριστεί με την επιλογή **--xlate-format**.

<div>
    <p>
    <img width="750" src="https://raw.githubusercontent.com/kaz-utashiro/App-Greple-xlate/main/images/format-conflict.png">
    </p>
</div>

Εάν θέλετε να μεταφράσετε ολόκληρο το κείμενο, χρησιμοποιήστε την επιλογή **--match-all**. Αυτό είναι ένας συντομευμένος τρόπος για να καθορίσετε ότι το πρότυπο ταιριάζει με ολόκληρο το κείμενο `(?s).+`.

# OPTIONS

- **--xlate**
- **--xlate-color**
- **--xlate-fold**
- **--xlate-fold-width**=_n_ (Default: 70)

    Καλέστε τη διαδικασία μετάφρασης για κάθε ταιριαστή περιοχή.

    Χωρίς αυτήν την επιλογή, το **greple** συμπεριφέρεται ως ένα κανονικό πρόγραμμα αναζήτησης. Έτσι μπορείτε να ελέγξετε ποιο μέρος του αρχείου θα υπόκειται στη μετάφραση πριν καλέσετε την πραγματική εργασία.

    Το αποτέλεσμα της εντολής πηγαίνει στην τυπική έξοδο, οπότε αν χρειάζεται ανακατεύθυνση σε αρχείο, ή σκεφτείτε να χρησιμοποιήσετε το πρόσθετο [App::Greple::update](https://metacpan.org/pod/App%3A%3AGreple%3A%3Aupdate).

    Η επιλογή **--xlate** καλεί την επιλογή **--xlate-color** με την επιλογή **--color=never**.

    Με την επιλογή **--xlate-fold**, το μεταφρασμένο κείμενο διπλώνεται με το καθορισμένο πλάτος. Το προεπιλεγμένο πλάτος είναι 70 και μπορεί να οριστεί με την επιλογή **--xlate-fold-width**. Τέσσερεις στήλες είναι καταλεγμένες για τη λειτουργία run-in, οπότε κάθε γραμμή μπορεί να περιέχει το πολύ 74 χαρακτήρες.

- **--xlate-engine**=_engine_

    Καθορίζει τη μηχανή μετάφρασης που θα χρησιμοποιηθεί. Εάν καθορίσετε απευθείας το μοντούλο της μηχανής, όπως `-Mxlate::deepl`, δεν χρειάζεται να χρησιμοποιήσετε αυτήν την επιλογή.

- **--xlate-labor**
- **--xlabor**

    Αντί να καλέσετε τη μηχανή μετάφρασης, αναμένεται να εργαστείτε για αυτήν. Αφού προετοιμάσετε το κείμενο προς μετάφραση, αντιγράφονται στο πρόχειρο. Αναμένεται να τα επικολλήσετε στη φόρμα, να αντιγράψετε το αποτέλεσμα στο πρόχειρο και να πατήσετε Enter.

- **--xlate-to** (Default: `EN-US`)

    Καθορίστε τη γλώσσα προορισμού. Μπορείτε να λάβετε τις διαθέσιμες γλώσσες με την εντολή `deepl languages` όταν χρησιμοποιείτε τη μηχανή **DeepL**.

- **--xlate-format**=_format_ (Default: `conflict`)

    Καθορίστε τη μορφή εξόδου για το αρχικό και μεταφρασμένο κείμενο.

    - **conflict**, **cm**

        Εκτυπώστε το αρχικό και το μεταφρασμένο κείμενο σε μορφή συγκρουόμενου δείκτη [git(1)](http://man.he.net/man1/git).

            <<<<<<< ORIGINAL
            original text
            =======
            translated Japanese text
            >>>>>>> JA

        Μπορείτε να ανακτήσετε το αρχικό αρχείο με την επόμενη εντολή [sed(1)](http://man.he.net/man1/sed).

            sed -e '/^<<<<<<< /d' -e '/^=======$/,/^>>>>>>> /d'

    - **ifdef**

        Εκτυπώστε το αρχικό και το μεταφρασμένο κείμενο σε μορφή `#ifdef` του [cpp(1)](http://man.he.net/man1/cpp).

            #ifdef ORIGINAL
            original text
            #endif
            #ifdef JA
            translated Japanese text
            #endif

        Μπορείτε να ανακτήσετε μόνο το ιαπωνικό κείμενο με την εντολή **unifdef**:

            unifdef -UORIGINAL -DJA foo.ja.pm

    - **space**

        Εκτυπώστε το αρχικό και το μεταφρασμένο κείμενο χωρισμένα από μία κενή γραμμή.

    - **xtxt**

        Εάν η μορφή είναι `xtxt` (μεταφρασμένο κείμενο) ή άγνωστη, εκτυπώνεται μόνο το μεταφρασμένο κείμενο.

- **--xlate-maxlen**=_chars_ (Default: 0)

    Καθορίστε το μέγιστο μήκος του κειμένου που θα αποσταλεί στο API κάθε φορά. Η προεπιλεγμένη τιμή έχει οριστεί για τη δωρεάν υπηρεσία λογαριασμού: 128Κ για το API (**--xlate**) και 5000 για τη διεπαφή πρόχειρου (**--xlate-labor**). Μπορείτε να αλλάξετε αυτές τις τιμές αν χρησιμοποιείτε την υπηρεσία Pro.

- **--**\[**no-**\]**xlate-progress** (Default: True)

    Δείτε το αποτέλεσμα της μετάφρασης σε πραγματικό χρόνο στην έξοδο STDERR.

- **--match-all**

    Ορίστε ολόκληρο το κείμενο του αρχείου ως περιοχή στόχο.

# CACHE OPTIONS

Το πρόσθετο **xlate** μπορεί να αποθηκεύει το μεταφρασμένο κείμενο για κάθε αρχείο και να το διαβάζει πριν από την εκτέλεση για να εξαλείψει τον χρόνο που απαιτείται για την επικοινωνία με τον διακομιστή. Με την προεπιλεγμένη στρατηγική προσωρινής αποθήκευσης `auto`, διατηρεί τα δεδομένα προσωρινής αποθήκευσης μόνο όταν το αρχείο προσωρινής αποθήκευσης υπάρχει για το συγκεκριμένο αρχείο στόχο.

- --cache-clear

    Η επιλογή **--cache-clear** μπορεί να χρησιμοποιηθεί για την εκκίνηση της διαχείρισης της προσωρινής αποθήκευσης ή για την ανανέωση όλων των υπαρχόντων δεδομένων προσωρινής αποθήκευσης. Μόλις εκτελεστεί με αυτήν την επιλογή, θα δημιουργηθεί ένα νέο αρχείο προσωρινής αποθήκευσης αν δεν υπάρχει και στη συνέχεια θα διατηρείται αυτόματα.

- --xlate-cache=_strategy_
    - `auto` (Default)

        Διατηρήστε το αρχείο προσωρινής αποθήκευσης αν υπάρχει.

    - `create`

        Δημιουργήστε ένα κενό αρχείο προσωρινής αποθήκευσης και τερματίστε.

    - `always`, `yes`, `1`

        Διατηρήστε την προσωρινή μνήμη ούτως ή άλλως, όσο το προορισμένο αρχείο είναι κανονικό αρχείο.

    - `clear`

        Καθαρίστε πρώτα τα δεδομένα της προσωρινής μνήμης.

    - `never`, `no`, `0`

        Ποτέ μην χρησιμοποιείτε το αρχείο της προσωρινής μνήμης, ακόμα κι αν υπάρχει.

    - `accumulate`

        Από προεπιλογή, τα αχρησιμοποίητα δεδομένα αφαιρούνται από το αρχείο της προσωρινής μνήμης. Εάν δεν θέλετε να τα αφαιρέσετε και να τα κρατήσετε στο αρχείο, χρησιμοποιήστε την επιλογή `accumulate`.

# COMMAND LINE INTERFACE

Μπορείτε εύκολα να χρησιμοποιήσετε αυτήν την ενότητα από τη γραμμή εντολών χρησιμοποιώντας την εντολή `xlate` που περιλαμβάνεται στο αποθετήριο. Δείτε τις πληροφορίες βοήθειας της εντολής `xlate` για τη χρήση.

# EMACS

Φορτώστε το αρχείο `xlate.el` που περιλαμβάνεται στο αποθετήριο για να χρησιμοποιήσετε την εντολή `xlate` από τον επεξεργαστή Emacs. Η συνάρτηση `xlate-region` μεταφράζει την δοθείσα περιοχή. Η προεπιλεγμένη γλώσσα είναι η `EN-US` και μπορείτε να καθορίσετε τη γλώσσα καλώντας την με πρόθεμα.

# ENVIRONMENT

- DEEPL\_AUTH\_KEY

    Ορίστε το κλειδί πιστοποίησης σας για την υπηρεσία DeepL.

- OPENAI\_API\_KEY

    Κλειδί επαλήθευσης OpenAI.

# INSTALL

## CPANMINUS

    $ cpanm App::Greple::xlate

## TOOLS

Πρέπει να εγκαταστήσετε τα εργαλεία γραμμής εντολών για το DeepL και το ChatGPT.

[https://github.com/DeepLcom/deepl-python](https://github.com/DeepLcom/deepl-python)

[https://github.com/tecolicom/App-gpty](https://github.com/tecolicom/App-gpty)

# SEE ALSO

[App::Greple::xlate](https://metacpan.org/pod/App%3A%3AGreple%3A%3Axlate)

[App::Greple::xlate::deepl](https://metacpan.org/pod/App%3A%3AGreple%3A%3Axlate%3A%3Adeepl)

[App::Greple::xlate::gpt3](https://metacpan.org/pod/App%3A%3AGreple%3A%3Axlate%3A%3Agpt3)

- [https://github.com/DeepLcom/deepl-python](https://github.com/DeepLcom/deepl-python)

    Βιβλιοθήκη DeepL Python και εντολή CLI.

- [https://github.com/openai/openai-python](https://github.com/openai/openai-python)

    Βιβλιοθήκη Python της OpenAI

- [https://github.com/tecolicom/App-gpty](https://github.com/tecolicom/App-gpty)

    Διεπαφή γραμμής εντολών της OpenAI

- [App::Greple](https://metacpan.org/pod/App%3A%3AGreple)

    Δείτε το εγχειρίδιο **greple** για λεπτομέρειες σχετικά με το πρότυπο κειμένου προορισμού. Χρησιμοποιήστε τις επιλογές **--inside**, **--outside**, **--include**, **--exclude** για να περιορίσετε την περιοχή της αντιστοίχισης.

- [App::Greple::update](https://metacpan.org/pod/App%3A%3AGreple%3A%3Aupdate)

    Μπορείτε να χρησιμοποιήσετε τον μονάδα `-Mupdate` για να τροποποιήσετε αρχεία με βάση το αποτέλεσμα της εντολής **greple**.

- [App::sdif](https://metacpan.org/pod/App%3A%3Asdif)

    Χρησιμοποιήστε το **sdif** για να εμφανίσετε τη μορφή του δείκτη σύγκρουσης δίπλα-δίπλα με την επιλογή **-V**.

# AUTHOR

Kazumasa Utashiro

# LICENSE

Copyright © 2023 Kazumasa Utashiro.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.
