/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.control.handlers;

import com.google.gson.JsonObject;
import java.security.AccessControlException;
import org.couchbase.mock.Bucket;
import org.couchbase.mock.CouchbaseMock;
import org.couchbase.mock.control.CommandStatus;
import org.couchbase.mock.control.MissingRequiredFieldException;
import org.couchbase.mock.control.MockCommand;
import org.couchbase.mock.memcached.KeySpec;
import org.couchbase.mock.memcached.VBucketInfo;
import org.jetbrains.annotations.NotNull;

public abstract class KeyCommandHandler
extends MockCommand {
    KeySpec keySpec;
    Bucket bucket;
    VBucketInfo vbi;

    @Override
    @NotNull
    public CommandStatus execute(@NotNull CouchbaseMock mock, @NotNull MockCommand.Command command, @NotNull JsonObject payload) {
        short vbIndex = -1;
        String bucketString = "default";
        if (payload.has("Bucket")) {
            bucketString = payload.get("Bucket").getAsString();
        }
        this.bucket = mock.getBuckets().get(bucketString);
        if (this.bucket == null) {
            throw new AccessControlException("No such bucket: " + bucketString);
        }
        if (!payload.has("Key")) {
            throw new MissingRequiredFieldException("Key");
        }
        String key = payload.get("Key").getAsString();
        if (!payload.has("vBucket")) {
            vbIndex = this.bucket.getVbIndexForKey(key);
        }
        if (vbIndex < 0 || vbIndex >= this.bucket.getVBucketInfo().length) {
            throw new AccessControlException("Invalid vBucket " + vbIndex);
        }
        this.keySpec = new KeySpec(key, vbIndex);
        this.vbi = this.bucket.getVBucketInfo()[this.keySpec.vbId];
        return new CommandStatus().fail();
    }
}

