/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class CodepointCollatingComparer
implements AtomicComparer {
    private static CodepointCollator collator = CodepointCollator.getInstance();
    private static CodepointCollatingComparer THE_INSTANCE = new CodepointCollatingComparer();

    public static CodepointCollatingComparer getInstance() {
        return THE_INSTANCE;
    }

    private CodepointCollatingComparer() {
    }

    public StringCollator getCollator() {
        return collator;
    }

    public AtomicComparer provideContext(XPathContext context) {
        return this;
    }

    public int compareAtomicValues(AtomicValue a, AtomicValue b) {
        if (a == null) {
            return b == null ? 0 : -1;
        }
        if (b == null) {
            return 1;
        }
        StringValue as = (StringValue)a;
        StringValue bs = (StringValue)b;
        return CodepointCollator.compareCS(as.getStringValueCS(), bs.getStringValueCS());
    }

    public boolean comparesEqual(AtomicValue a, AtomicValue b) {
        return ((StringValue)a).codepointEquals((StringValue)b);
    }

    public String save() {
        return "CCC";
    }
}

