/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.NormalizedNameClass;
import com.thaiopensource.xml.util.Name;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NormalizedAnyNameClass
extends NormalizedNameClass {
    private final Set<String> excludedNamespaces;
    private final Set<Name> excludedNames;

    public NormalizedAnyNameClass(Set<Name> set, Set<String> set2, Set<Name> set3) {
        super(set);
        this.excludedNamespaces = this.immutable(set2);
        this.excludedNames = this.immutable(set3);
    }

    @Override
    public boolean isAnyNameIncluded() {
        return true;
    }

    @Override
    public boolean contains(Name name) {
        if (this.excludedNamespaces.contains(name.getNamespaceUri())) {
            return super.contains(name);
        }
        return !this.excludedNames.contains(name);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Set<String> getExcludedNamespaces() {
        return this.excludedNamespaces;
    }

    @Override
    public Set<Name> getExcludedNames() {
        return this.excludedNames;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.excludedNamespaces.hashCode() ^ this.excludedNames.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof NormalizedAnyNameClass)) {
            return false;
        }
        NormalizedAnyNameClass normalizedAnyNameClass = (NormalizedAnyNameClass)object;
        if (!this.excludedNamespaces.equals(normalizedAnyNameClass.excludedNamespaces)) {
            return false;
        }
        if (!this.excludedNames.equals(normalizedAnyNameClass.excludedNames)) {
            return false;
        }
        return this.equal(this, normalizedAnyNameClass);
    }

    @Override
    boolean includesNamespace(String string) {
        return !this.getExcludedNamespaces().contains(string);
    }
}

