use BigRoot;
use Test;

# All results are checked with Wolfram Mathematica
# https://www.wolfram.com/mathematica/

plan 6;

test-root
        precision => 80,
        root => FatRat.new(2, 3),
        number => 2,
        expected => '2.82842712474619009760337744841939615713934375075389614635335947598146495692421408';

test-root
        precision => 80,
        root => FatRat.new(101, 2),
        number => 2000,
        expected => '1.16243032359535622105669923968936813791614060324601689664852216140243791714966312';

test-root
        precision => 80,
        root => FatRat.new(202, 3),
        number => 1_234_567_890,
        expected => '1.36465383390258849141189616162072833521048201533633207103790279308855008778049205';

test-root
        precision => 500,
        root => FatRat.new(31, 2),
        number => 1_234_567_890,
        expected => '3.8596627043475144497410301884516246732524362950686466841306647967279297350069'
                ~ '14009164660954421089311092858189466737441216525875447122857019233824499879907672'
                ~ '27439764768671313353954494174369323753524857599751674671932541941871104684811265'
                ~ '13934196812628590515580735727766890927642254681061917255671587061655346997643718'
                ~ '32791267378684475240090912115336733143871386441291349705489796856083261948741490'
                ~ '66798826006431298189900097433572916226590506474261267476210518934713384197631643'
                ~ '41074345569013073068852';

test-root
        precision => 999,
        root => FatRat.new(2, 31),
        number => 2,
        expected => '46340.950011841578559133736114903386638571008012351834461853441654480321854246'
                ~ '32344904949872484815905538093371329453414891273702787811695698392257321697069732'
                ~ '37484803171125032634220527780217743625608059325500611495844339559496699744986240'
                ~ '58774024657260037810724224509827950885301117340995682148398137006071919298030200'
                ~ '71172966385632078569128115390874542931842596325212882002024389054806014700448969'
                ~ '02237515579382398649897789208667026330895727926663083765569493919523950792407996'
                ~ '40388010495789268573789725933871590973423541138942637520603336081889115245023841'
                ~ '00925163325708591973571043814751278156612115090137062656319816363404317989751488'
                ~ '14956769146522560112603570060268571283623136292330012776414587853042394015027725'
                ~ '76494016532688862757703245240861475114934928103640686833261872728434635464717167'
                ~ '39438466973933829935834418630818837751554262572639517796049486634818151798906833'
                ~ '81421867154140107590569828333693885760519474570972475263461267304261704422886987'
                ~ '65857855002671250665362496396093782486183025344';

test-root
        precision => 19_996,
        root => FatRat.new(2, 3),
        number => 2,
        expected => '2.8284271247461900976033774484193961571393437507538961463533594759814649569242'
                ~ '14077700775068655283145470027692461824594049849672111701474425288242994199871662'
                ~ '82644533185501118551159990100230556412114294021911994321194054906919372402945703'
                ~ '48372817783972191046584609686174286429016795252072559905028159793745067930926636'
                ~ '17659281241230516704790109491500575519923459671150440675063714022708749206816997'
                ~ '69432077379994139800963006108805558063290849564613698587383724316115692622319333'
                ~ '74260260312371379744744705770185297224989954308436668408571372120293649441542871'
                ~ '70974831131413935530744045297089403171760324151694984531445200417116893304291679'
                ~ '77878887418531836006227764929363141652602011897174080063729606843897945565812820'
                ~ '90145273762627479710512234644080490182455400453882255147254560991476217935008036'
                ~ '73973673690145159872945812152599388276095130964745799436065360494884125853824971'
                ~ '81043620089196843011822404988826834570629562116072067421546183657386294203422233'
                ~ '67833163453778839517433164304256459036976944179389267725783125765531905270281084'
                ~ '53530647938923502258320481743102027030091076257512010526293603425480530793894048'
                ~ '06010349906377258512627703763269560031387383537637047573681045756752587784286013'
                ~ '11739137371929190311003289449019673792073774646228778831153302081767828584676226'
                ~ '41210486725897063409983154351245709948287799837604352486193041312842365463345251'
                ~ '50791894345118692744772645229654852444173423116791998530423525053978350819763186'
                ~ '97280166914170362944463628408140853018113064666796872915731593593038534584799750'
                ~ '73323443196515772052672723565499198843880755550736285243547759838910279446254813'
                ~ '37966599797907734576457127573954993250399331670515523978786456906894713895899259'
                ~ '04337782970985077809511657669052193048193085778789077293251489855112763928820633'
                ~ '95966612370403875876988011431266744109613708115173599934024274447895164285261317'
                ~ '02644348176647658945752347872949356748639200031843776146957152345044237349808499'
                ~ '54733858414622192739443217867417322313469170669666590509351703289421515697204927'
                ~ '20166889822963717531110857291024662843985262266503594121687311940870571282017583'
                ~ '70015207220183189313413537672111434801535138101922734388026498712104803719982101'
                ~ '24216327195452862761210934020587139942084850211563499062114511869968902253845560'
                ~ '68982701327513749552056632565921106484485391506905805767753689285834656554177663'
                ~ '61740506797046762454999816247437850814529507357006096431836037723342179457384584'
                ~ '02395199761407637086665072920422164598558586145743561599776198353483548217966121'
                ~ '60065262363285597646234308727739323405999868323229757372036091011107973826230372'
                ~ '02077275065000911637208960815004823903686113490673672273491947488479771065703586'
                ~ '17920747797830346391748268857635684250043833903751186888774792378629099999812215'
                ~ '17409818052176703527244949951571771673607491586231467960419997324437389984519182'
                ~ '65528472388211842006560522997491331993777481359123347837191457772849469271717737'
                ~ '28993644772013966705285598112566331227827885115298124130372043294526066725950151'
                ~ '39574121321371299632018543741858430626473656271397787419483300894918192107494559'
                ~ '30489541881984824774212289410879734872946769549096382017457724442991790591823757'
                ~ '84298359667962167576556306131124631620721297351746072029004546417658702682774455'
                ~ '36835335687381058857396981676911489158819197252148499909833605706154797876592072'
                ~ '42670797506410183997872150278128889915369139869425527290143265583094031954670972'
                ~ '77878846514555080076520549571348345161902832614319195699636018887120758781971180'
                ~ '33654430806916316304200987332590689765421458479320464327647653322525366100514556'
                ~ '23389020707587431376467318645956463859721293595797281841712191162852287272620092'
                ~ '31188665100948987951867998250839064601864350608953067929413255223323507037509292'
                ~ '41935269117477232976039769699495852809013088979382008158842363385159371512756976'
                ~ '29979728337099898327152289680940420679784306847540744667062312918887794073063334'
                ~ '43898098703765811612614802693725283344940221306926987832814292571135960355867628'
                ~ '84809053827413321955527756973247600678464874094823066374506381203833199291076231'
                ~ '57768276168664642106753492362435602859218566482272550508177474581025881467895886'
                ~ '61238879138734041588590317564566986438633328222603099189396757955348688870786754'
                ~ '19914269976815781701631784732140177316210941899580931445977761784922565632026267'
                ~ '40205816058199949129569916309122929743103278100483971581226218691756661240052441'
                ~ '47449433533709109998099881714216198515198577864732308765439100115632502660763062'
                ~ '93155815853737001613968856958304848550882053611512643130644123771502450226127874'
                ~ '05072585432393650251838405043211740237919346448847853484746898152929345475069592'
                ~ '91976382996158634360048477109077720767366216015583649329255082348885000374555590'
                ~ '36328766902926922598041526686035937108771263335447036778673334084444221878289860'
                ~ '57592762567977862346261686008425110037099701305891127553206292251181820922276953'
                ~ '65647191849544572580852854723265291708867857545277206862996097927947266595097718'
                ~ '51362298593672253451797147666432873326974046954605220212261014597223068259897617'
                ~ '54894622245908530550330733182346028472125305173815439643407419620928872095445347'
                ~ '85659748305186139124127694216548164369813474466117486059418485798963478488157387'
                ~ '50568802088798097041757703828387083025801363470340613877394118009485031531049615'
                ~ '68947242882100324016908882445119124059694518807056038135961361966007929079713718'
                ~ '60917250521275594907119855494598129777490902484992152756021727800382116185749529'
                ~ '44150221847721190039086456320417759243032467704322575045703605058575236651407434'
                ~ '57148135278898196509288443693086176132211604031694568134252605091875978130163371'
                ~ '42743313371882601066394073192806753348292209912753020616732269786218956053625871'
                ~ '14663781103941040369030079938197326305024823222385188110561712997863917966912466'
                ~ '39673669897616123431248782257326255956967439579067380305552010996110332700395711'
                ~ '14220281110595267682550089372092953263665322330364135002409533982197443820889488'
                ~ '06537887283191885584398884710743740859911848062818342569631708773201077142716727'
                ~ '96326189048151140186503364868833648167239585467456504309244939230664340536599019'
                ~ '58178069189717756698879232408716844994794374227917854610184394109834353923200891'
                ~ '16179885575776073833886578919029445344585224970139234632761882164372009057220539'
                ~ '30951526086205120543046279389642710396428194330981946399856698513481949807845942'
                ~ '52697386829149866396083436152223927804557328151844868335524932472477826220540686'
                ~ '60915273628225664265261716447891243919617322587999240246831235263634862484017802'
                ~ '99676971209617597292167871929847330285936251546286458291374336552439922365565390'
                ~ '63149967605249303518108207952362575208432772269004426525455513224882267221550391'
                ~ '11549901731272134757330124637128139824560375148357098932250655199539592119552118'
                ~ '15129782133220316768344056370608642380893155051085550875974521097634723965351633'
                ~ '72566590521579864453367205677027024562118637182057283016314112639434630366272500'
                ~ '48718082926424478435326796537873650630106011978309405819074386532414682246989486'
                ~ '73576938040278099568570432682885842917911657569533878929285356244380995712727105'
                ~ '26736556103720197398497875572004797538339615313243887797088741611892866724667621'
                ~ '17491632470951200273184870485314286166931091536004741629351465050940510149527494'
                ~ '32701357031983473875865020653655212572918292364094429727407415438538536472466694'
                ~ '40758491929383621052278306172560582881930965127746185460853089325858091792127503'
                ~ '83742293869072394664957914541406306186180384239839998723153000700796810813485077'
                ~ '58550558454494671335412156758227689778725227353141205272006302659041907904057097'
                ~ '94768972512269848829417214173205352699957586841751672243894233988447696965191828'
                ~ '60905621412520301793827060603544012543410880418133902983054919543941189539094819'
                ~ '04205757451157137600443874354871162215878617667691172965545820172591091322826134'
                ~ '42461697480454242117372646776474827768857876310889294211511302936871405893270125'
                ~ '78774713973737675296065303905682930703479060547224027484060197347967702864380087'
                ~ '20579653965870587988282584611607691300454144336303238820228996526027298017540967'
                ~ '96976772181306737198109167790406371296082986544284781730329998863318415931907138'
                ~ '86144622582325857359503431337781087864407138258664914041613438888099460988796281'
                ~ '64556592055988490821663333518428496703654476344100820785485776031124467615922950'
                ~ '24867029462042569091889798889992001504875039140233366834894981591764199035673536'
                ~ '04647303534994460297491548545198952192439686542967059722238054574716981043595181'
                ~ '67483949720534121074924630600787504247357355056973843917142751085393696556726357'
                ~ '22219867360287831811949685716109032260460287958114032217797255559221501346665352'
                ~ '09730985850279956278107176455378746440988296788027112071312088428035224121026361'
                ~ '37839799252123696637068036724756434532751609104943925323498508457056091428840971'
                ~ '56684226456017057408410977984682557109624735230754142085089397370439822456708532'
                ~ '69999425496732152492483641472933234256789496946560948860806688214400857454255134'
                ~ '05591351648585254389091610600533297993015913955635724388434401047433073893540839'
                ~ '02238254092496721022605780928755022973897756992302376829438200025117676733213544'
                ~ '16822470307117622535579143117180825152523202135026307160424854663742001271649909'
                ~ '00819915881450959780063365302474623811133658303886107416978615738394856580980772'
                ~ '07446232198566848634244501989094300385733297574215903990360109267767688630963449'
                ~ '27096048903606169054686200124274206925146612002469947488711636193135692928306781'
                ~ '02931383864912470628115583873979768472943670507516105154266224015942081366309853'
                ~ '30804052093613636782875654429538126484939034257273476886279666742352318837399869'
                ~ '32524690746904713588024833618458232721912744334905678341981829329701478410303211'
                ~ '20947574212309404339921493138619588852242938512318685129880382459790294650894303'
                ~ '62526516737794564525666590480719401455726729209189414248349458937551411916314699'
                ~ '92569619913567851094848089798377414213935048501549040245872162114828530646944812'
                ~ '83242820667066811022090425235007180568074909183729009455248684143541859587080204'
                ~ '28192929005673668360815172162002814432384954359619719362230808928874571379185736'
                ~ '63955595573869283196939490267835483075809755761660044116670093493110646057174651'
                ~ '67031417199298137345751934590077450951417583391094733834174024826678442969337034'
                ~ '87413323097639058664545474872082165085193206079738653084470104738217190252601663'
                ~ '69351100691951679101168071340311775955472887609636427741400688047236082400422967'
                ~ '45588454815747578663254162027252996579258545124891610794268284429022199990891642'
                ~ '85847567762052967896467902837534937935663725736357654511165146387903631063390329'
                ~ '00298871452621209138985934197250408678770415644152443820068938539326685181706116'
                ~ '32089956051552650897874160125355746359097059713367897389346713926002805862628380'
                ~ '51561551633891630545058686845181039583663324328897503563393550553541826086314685'
                ~ '12810984587637479022168833366184982231957154665472776828370147587260052784361360'
                ~ '03899647933294246263438050474063981175439548200142648150384083624428264850654589'
                ~ '83720008401683097023094823146119744392425977083327441755044967538971949534586603'
                ~ '73678104500029738076522169649639633518621554540529765241814476955058117530080653'
                ~ '34551696504370324621490899775176549313561899424617532288528296483158071407866245'
                ~ '13037866712563672370811493412761236796978932568491473129128427814432610591058718'
                ~ '56975511048550911902676554300035680331061097088457002397673115136031869290111798'
                ~ '88496992548254237397663160953836283135923706433143392904451891894249386399142328'
                ~ '39723769595578242285362328767544769672637346372151295570739986077410932645939615'
                ~ '13516936424605615452201393834815640495899764219094668602253090884340391704751761'
                ~ '57069600747449423752222001754380710776314638450266768498954900623762389491190730'
                ~ '67321841283858688007015712844686584649859454169449647115343481179000253752720162'
                ~ '49042248975128685618931862672371286482971156158386230253019459178321059860615421'
                ~ '12704909029669144184491039697811778084396130879467075151996497160750927854730752'
                ~ '83934961253936765425840028699133497044944829097272072423169446463473996123439872'
                ~ '84227262916142397679362591411223176249241177159330112443014964179495528354167574'
                ~ '10584840576058008800496137362508441515811884869409289791508804774738720948026172'
                ~ '07215198348775231270593552116036669861759293254142321610147522143600443105038398'
                ~ '75924014183227664545603546266403801195609641592151606499892447707716071469560374'
                ~ '27605680796240093624741581849145457153090209794340620474109735758672875631561480'
                ~ '15354948430560623699631153963312303252231440409080528825986322341546625076922578'
                ~ '73527583677074100188412612182065080516953644407353649855894680012355025905261453'
                ~ '12757061947372840015533331779865691322449301460044191257545452445561607909668076'
                ~ '21925611529857949303687263899680522599523780093563818547419295655744871550441336'
                ~ '93080004936661492175671753117810611388514998197807844092600942914411810742418262'
                ~ '85517730753862960800017435827691381987259975695770843556308147010341250641019028'
                ~ '95644133450521724082159924454069616360276013220143845362805839536709768487983256'
                ~ '19607237195438717784530971745632655381085723493264616272575529980147551986488350'
                ~ '42953552093873924466430351852901112905127681093400809043160150908759362076871170'
                ~ '29588618459270439570456659149091454312958637008377921402561189845918436718987414'
                ~ '91607806428208732032753019109788908380526782392148220133899556049390818731256255'
                ~ '07699264720212516930733410153035405939026079371740473582575082717612880526847647'
                ~ '13612152814903522381766674241828315256113044758025471283870691305352592488053204'
                ~ '56490852392068456704800410065901063817064029936090271286682068626584471793945662'
                ~ '17479138876263618863333826781052978296665759765525705126090241275229800090437285'
                ~ '43422301795256550573429327223477965717485063443319249528664768006980099259757897'
                ~ '40021037689882373208794782149875146990578695414792773318665108771799870759882876'
                ~ '81324844204536657023325022736689465793226421053501787589668926986070557064260255'
                ~ '64230537188596875130349021860798499173292188477369400430710036075600037402222630'
                ~ '38757508021829917781615294669100052819611366428762320150292365576898093624962937'
                ~ '86194860000218039686417332618450276224223198962559273567816244487563820375559880'
                ~ '68153054812076468301065434832557349776171508202428573349326207221760036376870803'
                ~ '64737306443375500823956153051623076834731243671350026068913191873181949380155312'
                ~ '61903127325669727995950987512768105934465671268060631833099177222445991999373654'
                ~ '02856814478292460032347088166287287609178441108220359070271177054269596987575226'
                ~ '75821513119908290578355403151626975153603724858444595533242308449942266834792063'
                ~ '93527818701024641895233285506948776667777399959832927673500648372649725683756939'
                ~ '92192761655025992676347874844190695172326443261040540703407498059713705119162838'
                ~ '59099903531051642469462163953266026835016302473550463032146417636591281452695290'
                ~ '11775152272378723740257808053584529409899357447480516260166952795128926526709935'
                ~ '05714990740302542013889288412492350728857899720984104364642676865255067039765898'
                ~ '41729814192118433091475381919027787579953252575417366470119281961003771396399481'
                ~ '13201088306427681469956308161887081519363122677928641680830630204864864953012711'
                ~ '64819570693623021126477960802760762969947057488858138786887467636021802035771841'
                ~ '12813815394527818678223227369333398636136764693480778447344585103320489371949215'
                ~ '27165807457058994316738127458190067371902364774480773133607688197182719993176601'
                ~ '24559950582736989123410398658319898464868082745450761527368059037473963594707331'
                ~ '41919884409502119288151814156004078724649436476082755985674793471761927790947876'
                ~ '94257901246089689464940887646780502629827718895042558542922134450536711104186202'
                ~ '81965006482082713623777868834126960363775807704874568690082799053501678149858631'
                ~ '18979855994804120333722021211476724068739227984741004118273824495762896439400911'
                ~ '29259212360305914535493308050448064304021253611849385883682930338538859406328949'
                ~ '78451067136389402111721507900625149755854364403961361013102694378525301997408077'
                ~ '44787230525618234300327967836764160742153288944622511885958616831497150994256991'
                ~ '35415378261062783038566321498744520929674824224821054809161538154998064335230639'
                ~ '93132194860178056957584419789110280699133552658736837825856457778758278513158061'
                ~ '23408439034928533435257201475309650978981647340980835796558938962674201087514704'
                ~ '58525187913619074335954355476856332239198639756300748804465058803330271929767978'
                ~ '37542533335289185656144954839610236680715452603883011244541853377630201748162043'
                ~ '26091022387379406797517983268735331049193800459327812364691984488743231363774335'
                ~ '70039104385380954017775257634024871814476843771818864605048017456726822692004949'
                ~ '27010815263486057122065766289279051991155428324995031985772068820209506693549060'
                ~ '87455737715223924537178962779576870245033381352375826468924154485277978223503871'
                ~ '51073510179543472161559709985867497151758815938978023707652102227247183468078279'
                ~ '72180037444908057453025847014502692672079895594422506881593928393168658497167792'
                ~ '30741572508924810546836745923317425619924313502833557777043640356537158950177211'
                ~ '23835228669010614484515888430088023798760656423538855070310010071876805238542496'
                ~ '81470689611528302698418132866521743773863756782274498270858126286554628295130468'
                ~ '85539785282145838592955663045353061926754381577404242034725778560266413310769377'
                ~ '50454196428339894906935679461237686761273771357750186967425625989189428334804212'
                ~ '95889246095019193822426568371474901537604348400183807572229857998642739656510100'
                ~ '87882504685877578305858897613458090674311737178782388117359853593603950385892706'
                ~ '26424092116546027304927098394954356862510294391221788963433747391900195102981811'
                ~ '60847541101531663320910526357638318577160302821980670319985529852041833507593171'
                ~ '30814344298054554414415906609281898535859396029129481517233683503654071083830465'
                ~ '71802639837951288854418391613294757079309498870067321969113884410824644182989539'
                ~ '70453213373862698825692104872012523838401909119198598407153271689450417776877540'
                ~ '21969701922910732501129644466216554975424992918478806882076976091311441830744167'
                ~ '38474084407806163338430688673111059318295475190415891919411829842604876667591418'
                ~ '74943260728189044802396509100750879452160752733174730519790538233599202055671776'
                ~ '22314316823148958948070573780018964826783690275611998450379694718823308438018873'
                ~ '39700583601452305417909664953821581095004791533188395776368821040365774328233410'
                ~ '56528938948929419773761317888340180291403479184759776126240268590166828821934009'
                ~ '20139413260227976761308820719180727708577810679195895227111078618470700020454928'
                ~ '05147993098520637424201087903386302054725029391616873389674982267706306475608524'
                ~ '95899235538591245012265156533233175056341230969376356892098370317000447157015376'
                ~ '88935574802950088452515020347297236652674650670838426192621064426512483892281860'
                ~ '55786716506234710966243723763716165489932851736090915776083208192200076997466215'
                ~ '11267780694488376029409920289043092892705537490600926858740931574922460822857168'
                ~ '27863094139289119772540468271067392293778826115904868965715762768582626680088877'
                ~ '65389125549144089297855007437792005004296204864532464948933518444419151593607975'
                ~ '16660237618824697188211079586230033229964821895468091188954724281459638134684542'
                ~ '44265965640378710362961423225872095078709038328977038395363978864937653316939981'
                ~ '62069748661143085042297965849881282704097398663417048730920581601300484305971962'
                ~ '38502419256665361534505602858485276213241844013432484781070788575515001582717400'
                ~ '75361300813865809247340399612928476332556149116908559456272729922563120126722563'
                ~ '82343615549971442569819308091276120505595858002823343617764334552465391462890599'
                ~ '07581871999271440391382107646366646457592073230986871239112715557744076102814294'
                ~ '05725497333154545699276121364181748674951155786244143323665819959361548139166109'
                ~ '10116338927821076050942596190038328118354584294122410759475166376338080691474617'
                ~ '84574097528597665526862123131208284706204222521543558617466342634267668110798154'
                ~ '29749207975726820036309788612042552829035073711356248209752557836891972977501451'
                ~ '38381414112252378130230830748686634095421470241794993291717424646521224555352976'
                ~ '03483808341065243802258598826848137189559412969090246086540072408889206140038229'
                ~ '00830841625457317065319725193166825838637486749362850819839783816018651430451900'
                ~ '51395152725167570841375215750672847780490704844629562339006148459937653247237887'
                ~ '59509268629738809474109320441047317070448669837868299074637092355127817012602996';

sub test-root(:$precision, :$root, :$number, :$expected) {
    BigRoot.precision = $precision;
    my $result = BigRoot.newton's-root(:$root, :$number);
    my $test-name = "{ $number }^({ $root.numerator }/{ $root.denominator }) - precision { BigRoot.precision }";
    is $result, $expected, $test-name;
}

done-testing;