package Net::Amazon::EMR::DescribeClusterResult;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;
use Net::Amazon::EMR::Cluster;


has 'Cluster' => ( is => 'ro',
                   isa => 'Net::Amazon::EMR::Type::Cluster',
                   coerce => 1 );


__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::DescribeClusterResult

=head1 DESCRIPTION

Implements the DescribeCluster result type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/API/API_DescribeCluster.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
