##-*- Mode: CPerl -*-

## File: DDC::Format::Raw.pm
## Author: Bryan Jurish <moocow@cpan.org>
## Description:
##  + DDC Query utilities: output formatting: Data::Raw
##======================================================================

package DDC::Format::Raw;
use IO::File;
use Carp;
use strict;

##======================================================================
## Globals
our @ISA = qw(DDC::Format);

##======================================================================
## Constructors, etc.

## $fmt = $CLASS_OR_OBJ->new(%args)
##  + %args:
##    (
##     hitSeparator => $sep,    ##-- raw hit separator (default="\n\n")
##    )
sub new {
  my $that = shift;
  my $fmt = bless {
		   hitSeparator => "\n\n",
		   @_
		  }, ref($that)||$that;
  return $fmt;
}

## $fmt = $fmt->reset()
##  + reset counters, etc.
#sub reset {
#  return $_[0]->SUPER::reset();
#}

##======================================================================
## Helper functions

## $hitStr = $fmt->hitString($hit)
##  + increments $fmt->{start}
sub hitString {
  return $_[1]{$_[0]{raw}};
}

##======================================================================
## API

## $str = $fmt->toString(\@hits)
sub toString {
  return join('',map {$_->{raw}.$_[0]{hitSeparator}} @{$_[1]->{hits_}});
}

1; ##-- be happy

__END__

##======================================================================
## Docs
=pod

=head1 NAME

DDC::Format::Raw - raw formatting for DDC hits

=head1 SYNOPSIS

 use DDC::Concordance;

 $hitList = DDC::Client::Distributed->new()->query('foo&&bar'); ##-- get some hits

 $fmt  = DDC::Format::Raw->new();
 $str = $fmt->toString($hitList);        ##-- conversion to string
 $fmt->toFile($hitList,$filename);       ##-- output to file
 $fmt->toFh($hitList,$fh);               ##-- output to filehandle

=cut

##======================================================================
## Description
=pod

=head1 DESCRIPTION

Class for null-formatting L<DDC::Hit|DDC::Hit> objects; just dumps raw hit data from C<$hit-E<gt>{raw}>.

=cut

##----------------------------------------------------------------
## DESCRIPTION: DDC::Format::Raw: Globals
=pod

=head2 Globals

=over 4

=item Variable: @ISA

DDC::Format::Raw inherits from L<DDC::Format|DDC::Format>.

=back

=cut

##----------------------------------------------------------------
## DESCRIPTION: DDC::Format::Raw: Constructors, etc.
=pod

=head2 Constructors, etc.

=over 4

=item new

 $fmt = $CLASS_OR_OBJ->new(%args);

Accepted keywords in %args:

 (
  hitSeparator => $str, ##-- raw hit separator (default="\n\n")
 )

=item reset

 $fmt = $fmt->reset();

Resets the formatting object.

=back

=cut

##----------------------------------------------------------------
## DESCRIPTION: DDC::Format::Raw: Helper functions
=pod

=head2 Helper functions

=over 4

=item hitString

 $hitStr = $fmt->hitString($hit);

Formats a single C<$hit> as a string.

=back

=cut

##----------------------------------------------------------------
## DESCRIPTION: DDC::Format::Raw: API
=pod

=head2 API

=over 4

=item toString

 $str = $fmt->toString($hitList);

Implements L<DDC::Format::toString()|DDC::Format/toString>.

=back

=cut

##========================================================================
## END POD DOCUMENTATION, auto-generated by podextract.perl


##======================================================================
## Footer
##======================================================================

=pod

=head1 AUTHOR

Bryan Jurish E<lt>moocow@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2010-2016 by Bryan Jurish

This package is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.14.2 or,
at your option, any later version of Perl 5 you may have available.

=cut
