#!/usr/bin/env perl 
#
# Before `make install' is performed this script should be runnable with
# `make test'.
# After `make install' it should work as `perl 560_Slurm-SATransaction-parse.t'
use strict;
use warnings;

use Test::More;
use Cwd qw(abs_path);
use File::Basename qw(dirname);

use Slurm::Sacctmgr;
use Slurm::Sacctmgr::Transaction;

my $testDir = dirname(abs_path($0));
my $num_tests_run = 0; 

#Set up expected results
my @fakedata =
(	
	{ testname=>'trans1', 
		action => 'Modify Clusters',
		actor => 'slurm',
		info => "control_host='10.99.1.1', control_port=6817, last_port=6817, rpc_version=7168, dimensions=1, plugin_id_select=101, flags=0",
		timestamp=>'2016-01-01T10:00:00',
		where=>"(name='yottascale')"
	},

	{ testname=>'trans2',
		action=>'Modify Associations',
		actor=>'root',
		info => 'grp_cpu_mins=1000000',
		timestamp=>'2016-01-02T11:30:31',
		where=>"(id_assoc=107)",
	},

	{ testname=>'trans3',
	 	action=>'Add Associations',
		actor=>'root',
		info=>"mod_time=1447858465, acct='physics', user='alavirad', `partition`='standard', shares=1, grp_cpu_mins=NULL, grp_cpu_run_mins=NULL, grp_cpus=NULL, grp_jobs=NULL, grp_mem=NULL, grp_nodes=NULL, grp_submit_jobs=NULL, grp_wall=NULL, is_def=1, max_cpu_mins_pj=NULL, max_cpu_run_mins=NULL, max_cpus_pj=NULL, max_jobs=NULL, max_nodes_pj=NULL, max_submit_jobs=NULL, max_wall_pj=NULL, def_qos_id=NULL, qos=',6,8,7,9,5,4,'",
		timestamp=>'2016-01-08T09:54:25',
		where=>'id_assoc=4741',
	},

);
my @fake_data = ();
foreach my $fakedatum (@fakedata)
{	my $testname = delete $fakedatum->{testname};	
	my $obj = new_ok('Slurm::Sacctmgr::Transaction' => 
		[ %$fakedatum ],
		"$testname" );
	$num_tests_run++;

	push @fake_data, $obj;
}
#Make sure @fake_data is alphabetically by username
#@fake_data = sort { $a->account cmp $b->account } @fake_data;

my $sa = Slurm::Sacctmgr->new(sacctmgr=>"${testDir}/helpers/fake_sacctmgr_transaction");
my $satransaction = 'Slurm::Sacctmgr::Transaction';

my $results;
my $args;
my $temp;
my $val;
my @temp;

#Test various commands with echo sacctmgr
#$sa->verbose(1);

$results = $satransaction->sacctmgr_list($sa);
$temp = [ @fake_data ];
is_deeply($results, $temp, 'list all transactions');
$num_tests_run++;

$val = 'slurm';
@temp = ( actor => $val );
$temp = [ grep { $_->actor eq $val } @fake_data ];
$results = $satransaction->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list transaction by actor (slurm)');
$num_tests_run++;

$val = 'root';
@temp = ( actor => $val );
$temp = [ grep { $_->actor eq $val } @fake_data ];
$results = $satransaction->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list transaction by actor (root)');
$num_tests_run++;

#Test for match failing
$val = 'zzz';
@temp = ( actor => $val );
$temp = [ grep { $_->actor eq $val } @fake_data ];
$results = $satransaction->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list transaction by actor (no match)');
$num_tests_run++;

#Test that still works when in dryrun mode
$sa->dryrun(1);
$results = $satransaction->sacctmgr_list($sa);
$temp = [ @fake_data ];
is_deeply($results, $temp, 'list all transactions (dryrun)');
$num_tests_run++;

done_testing($num_tests_run);

