# Pod::WikiDoc - check module loading and create testing directory

use Test::More;
use IO::String;
use lib "./t";
use Casefiles;

use Pod::WikiDoc;

#--------------------------------------------------------------------------#
# case file runner
#--------------------------------------------------------------------------#

my $cases = Casefiles->new( "t/filter_comments_alt" );

$cases->run_tests( 
    sub { 
        my $input = shift;
        my ( $length, $string ) = $input =~ m{\A (\d+) \n (.+) \z }xms;
        my $parser = Pod::WikiDoc->new( { 
            comment_blocks => 1,
            comment_prefix_length => $length,
        });
        my $got = $parser->convert( $string );
        $got =~ s{\A [^\n]+ \n \n}{}xms; # strip "Generated by" line
        return $got;
    }
);

