# Generated by default/object.tt
package Paws::Rekognition::StartSegmentDetectionFilters;
  use Moose;
  has ShotFilter => (is => 'ro', isa => 'Paws::Rekognition::StartShotDetectionFilter');
  has TechnicalCueFilter => (is => 'ro', isa => 'Paws::Rekognition::StartTechnicalCueDetectionFilter');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Rekognition::StartSegmentDetectionFilters

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Rekognition::StartSegmentDetectionFilters object:

  $service_obj->Method(Att1 => { ShotFilter => $value, ..., TechnicalCueFilter => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Rekognition::StartSegmentDetectionFilters object:

  $result = $service_obj->Method(...);
  $result->Att1->ShotFilter

=head1 DESCRIPTION

Filters applied to the technical cue or shot detection segments. For
more information, see StartSegmentDetection.

=head1 ATTRIBUTES


=head2 ShotFilter => L<Paws::Rekognition::StartShotDetectionFilter>

Filters that are specific to shot detections.


=head2 TechnicalCueFilter => L<Paws::Rekognition::StartTechnicalCueDetectionFilter>

Filters that are specific to technical cues.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Rekognition>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

