# Generated by default/object.tt
package Paws::NimbleStudio::ActiveDirectoryConfiguration;
  use Moose;
  has ComputerAttributes => (is => 'ro', isa => 'ArrayRef[Paws::NimbleStudio::ActiveDirectoryComputerAttribute]', request_name => 'computerAttributes', traits => ['NameInRequest']);
  has DirectoryId => (is => 'ro', isa => 'Str', request_name => 'directoryId', traits => ['NameInRequest']);
  has OrganizationalUnitDistinguishedName => (is => 'ro', isa => 'Str', request_name => 'organizationalUnitDistinguishedName', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::NimbleStudio::ActiveDirectoryConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NimbleStudio::ActiveDirectoryConfiguration object:

  $service_obj->Method(Att1 => { ComputerAttributes => $value, ..., OrganizationalUnitDistinguishedName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NimbleStudio::ActiveDirectoryConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->ComputerAttributes

=head1 DESCRIPTION

The configuration for a Microsoft Active Directory (Microsoft AD)
studio resource.

=head1 ATTRIBUTES


=head2 ComputerAttributes => ArrayRef[L<Paws::NimbleStudio::ActiveDirectoryComputerAttribute>]

A collection of custom attributes for an Active Directory computer.


=head2 DirectoryId => Str

The directory ID of the AWS Directory Service for Microsoft AD to
access using this studio component.


=head2 OrganizationalUnitDistinguishedName => Str

The distinguished name (DN) and organizational unit (OU) of an Active
Directory computer.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NimbleStudio>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

