#
# test the time() function.
#
use strict;
use warnings;
use Test::More;
use MyNote;
use UUID 'generate_v1';

ok 1, 'loaded';

my $sys_time = time;

generate_v1(my $u0);

my $uid_time = UUID::time($u0);
note scalar localtime($uid_time);

note 'uid time ', $uid_time;
note 'sys time ', $sys_time;

TODO: {
    local $TODO = 'some platforms may fail';
    cmp_ok $sys_time, '<=' , $uid_time,    'compare ok';
    cmp_ok $sys_time - $uid_time, '<=', 2, 'interval ok';
    cmp_ok $uid_time - $sys_time, '<=', 2, 'rollover ok';
}

done_testing;
