/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.iptc;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.BufferReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.iptc.IptcDirectory;
import java.util.Date;
import java.util.GregorianCalendar;

public class IptcReader
implements MetadataReader {
    public void extract(@NotNull BufferReader reader, @NotNull Metadata metadata) {
        IptcDirectory directory = metadata.getOrCreateDirectory(IptcDirectory.class);
        int offset = 0;
        while ((long)offset < reader.getLength()) {
            int tagByteCount;
            short tagType;
            short directoryType;
            short startByte;
            try {
                startByte = reader.getUInt8(offset);
            }
            catch (BufferBoundsException e) {
                directory.addError("Unable to read starting byte of IPTC tag");
                break;
            }
            if (startByte != 28) {
                directory.addError("Invalid start to IPTC tag");
                break;
            }
            if ((long)(offset + 5) >= reader.getLength()) {
                directory.addError("Too few bytes remain for a valid IPTC tag");
                break;
            }
            ++offset;
            try {
                directoryType = reader.getUInt8(offset++);
                tagType = reader.getUInt8(offset++);
                tagByteCount = reader.getUInt16(offset);
            }
            catch (BufferBoundsException e) {
                directory.addError("IPTC data segment ended mid-way through tag descriptor");
                return;
            }
            if ((long)((offset += 2) + tagByteCount) > reader.getLength()) {
                directory.addError("Data for tag extends beyond end of IPTC segment");
                break;
            }
            try {
                this.processTag(reader, directory, directoryType, tagType, offset, tagByteCount);
            }
            catch (BufferBoundsException e) {
                directory.addError("Error processing IPTC tag");
                break;
            }
            offset += tagByteCount;
        }
    }

    private void processTag(@NotNull BufferReader reader, @NotNull Directory directory, int directoryType, int tagType, int offset, int tagByteCount) throws BufferBoundsException {
        int tagIdentifier = tagType | directoryType << 8;
        switch (tagIdentifier) {
            case 512: {
                int shortValue = reader.getUInt16(offset);
                directory.setInt(tagIdentifier, shortValue);
                return;
            }
            case 522: {
                directory.setInt(tagIdentifier, reader.getUInt8(offset));
                return;
            }
            case 542: 
            case 567: {
                if (tagByteCount < 8) break;
                String dateStr = reader.getString(offset, tagByteCount);
                try {
                    int year = Integer.parseInt(dateStr.substring(0, 4));
                    int month = Integer.parseInt(dateStr.substring(4, 6)) - 1;
                    int day = Integer.parseInt(dateStr.substring(6, 8));
                    Date date = new GregorianCalendar(year, month, day).getTime();
                    directory.setDate(tagIdentifier, date);
                    return;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        String str = tagByteCount < 1 ? "" : reader.getString(offset, tagByteCount, System.getProperty("file.encoding"));
        if (directory.containsTag(tagIdentifier)) {
            String[] newStrings;
            String[] oldStrings = directory.getStringArray(tagIdentifier);
            if (oldStrings == null) {
                newStrings = new String[1];
            } else {
                newStrings = new String[oldStrings.length + 1];
                System.arraycopy(oldStrings, 0, newStrings, 0, oldStrings.length);
            }
            newStrings[newStrings.length - 1] = str;
            directory.setStringArray(tagIdentifier, newStrings);
        } else {
            directory.setString(tagIdentifier, str);
        }
    }
}

