package WebService::Eulerian::Analytics::TPOrderInject;

# $Id: TPOrderInject.pm,v 1.2 2008-09-03 15:22:48 cvscore Exp $

use strict;

use WebService::Eulerian::Analytics();

our @ISA        = qw/ WebService::Eulerian::Analytics /;

=pod

=head1	NAME 

WebService::Eulerian::Analytics::TPOrderInject - access the TPOrderInject service

=head1 DESCRIPTION

This module allow you to access the TPOrderInject Website service, which gives
the abaility to inject an order generated by an outbound click on a partner
website

=head1 SYNOPSIS

	use WebService::Eulerian::Analytics::Website::TPOrderInject;
	#
	my $api = new WebService::Eulerian::Analytics::Website::TPOrderInject(
	 apikey	=> 'THE KEY PROVIDED BY YOUR ACCOUNT MANAGER FOR API ACCESS',
	 host	=> 'THE HOST ON WHICH THE API IS HOSTED'
	);

=cut

sub new {
 my $proto      = shift;
 my $class      = ref($proto) || $proto;
 return         $class->SUPER::new(@_, service => 'TPOrderInject');
}

=pod

=head1 METHODS

=head2 replay : replay an outbound order at a given time and inject it in Eulerian Analytics, channel affected via clickoutid parameter.

=head3 input

=over 4

=item * nameof the website group, configured and provided by Eulerian Technologies for a group of website

=item * hash reference with the following parameters :

o clickoutid : id of the click generated on outbound click and provided to the partner, mandatory and must exists

o reference : order reference, mandatory and must be unique

o amount : amount of the order, mandatory and must be a number

o tppublisher : name of the partner for which you are importing orders, mandatory and must by identical in all websites if present on multiple websites.

o epoch : date at which the order was made, mandatory and the format muse be epoch time

=back

=head3 output

=over 4

=item * 1 if everything is fine, otherwise undef and check fault method

=back

=head3 sample

	my $ret = $api->replay( $my_websitegroup_name, {
	 clickoutid	=> 'CLICKOUT_ID_AS_PROVIDED_BY_PARTNER',
	 tppublisher	=> 'NAME_OF_PARTNER_AS_DECLARED_IN_EA',
	 reference	=> 'ORDER_REFERENCE_TO_REPLAYED',
	 amount		=> 'ORDER_AMOUNT',
	 epoch		=> 'ORDER_DATE_IN_EPOCH_FORMAT',
	});
	# 
	if ( $api->fault ) {
	 die $api->faultstring();
	}

=cut

sub replay	{ return shift()->call('replay', @_);	}

=pod

=head1 SEE ALSO

L<WebService::Eulerian::Analytics|WebService::Eulerian::Analytics>

=head1 AUTHOR

Mathieu Jondet <mathieu@eulerian.com>

=head1 COPYRIGHT

Copyright (c) 2008 Eulerian Technologies Ltd L<http://www.eulerian.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut

1;
__END__
