#!/usr/bin/perl

package eBay::API::XML::Call::AddOrder::AddOrderRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. AddOrderRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::AddOrder::AddOrderRequestType

=head1 DESCRIPTION

Combines two or more transactions into a single order, enabling a buyer
to pay for all of those transactions with a single payment (and, if
so arranged, ship all of the items together).
<br><br>
Strong recommendation: avoid mixing digital and non-digital listings in the same order.
(In the future, AddOrder may enforce this recommendation.)



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::AddOrder::AddOrderRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::OrderType;


my @gaProperties = ( [ 'Order', 'ns:OrderType', ''
	     ,'eBay::API::XML::DataType::OrderType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setOrder()

The order that is being created.

  RequiredInput: Yes
#    Argument: 'ns:OrderType'

=cut

sub setOrder {
  my $self = shift;
  $self->{'Order'} = shift
}

=head2 getOrder()

#    Returns: 'ns:OrderType'

=cut

sub getOrder {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Order'
		,'eBay::API::XML::DataType::OrderType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
