#!/usr/bin/perl

package eBay::API::XML::DataType::TransactionType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. TransactionType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::TransactionType

=head1 DESCRIPTION

Contains information about a single transaction. A transaction contains information
about the sale one or multiple items from a listing to a single buyer. The eBay
system creates a transaction when a buyer has made a purchase (fixed-price listings)
or is the winning bidder (BIN and competitive-bidding listings). A listing can spawn
one or more transactions in these cases: multi-item fixed-price listings and Dutch
listings. A listing can spawn only a single transaction in these cases: single-item
fixed-price listings and Chinese listings.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::TransactionType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AmountType;
use eBay::API::XML::DataType::ExternalTransactionType;
use eBay::API::XML::DataType::FeedbackInfoType;
use eBay::API::XML::DataType::ItemType;
use eBay::API::XML::DataType::ListingCheckoutRedirectPreferenceType;
use eBay::API::XML::DataType::OrderType;
use eBay::API::XML::DataType::RefundArrayType;
use eBay::API::XML::DataType::SellingManagerProductDetailsType;
use eBay::API::XML::DataType::ShippingDetailsType;
use eBay::API::XML::DataType::ShippingServiceOptionsType;
use eBay::API::XML::DataType::TransactionStatusType;
use eBay::API::XML::DataType::UserType;
use eBay::API::XML::DataType::Enum::DepositTypeCodeType;
use eBay::API::XML::DataType::Enum::PaidStatusCodeType;
use eBay::API::XML::DataType::Enum::SiteCodeType;
use eBay::API::XML::DataType::Enum::TransactionPlatformCodeType;


my @gaProperties = ( [ 'AdjustmentAmount', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'AmountPaid', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'BestOfferSale', 'xs:boolean', '', '', '' ]
	, [ 'Buyer', 'ns:UserType', ''
	     ,'eBay::API::XML::DataType::UserType', '1' ]
	, [ 'BuyerGuaranteePrice', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'BuyerMessage', 'xs:string', '', '', '' ]
	, [ 'BuyerPaidStatus', 'ns:PaidStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::PaidStatusCodeType', '' ]
	, [ 'CartID', 'xs:string', '', '', '' ]
	, [ 'ContainingOrder', 'ns:OrderType', ''
	     ,'eBay::API::XML::DataType::OrderType', '1' ]
	, [ 'ConvertedAdjustmentAmount', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'ConvertedAmountPaid', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'ConvertedTransactionPrice', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'CreatedDate', 'xs:dateTime', '', '', '' ]
	, [ 'DepositType', 'ns:DepositTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::DepositTypeCodeType', '' ]
	, [ 'DutchAuctionBid', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'ExternalTransaction', 'ns:ExternalTransactionType', '1'
	     ,'eBay::API::XML::DataType::ExternalTransactionType', '1' ]
	, [ 'FeedbackLeft', 'ns:FeedbackInfoType', ''
	     ,'eBay::API::XML::DataType::FeedbackInfoType', '1' ]
	, [ 'FeedbackReceived', 'ns:FeedbackInfoType', ''
	     ,'eBay::API::XML::DataType::FeedbackInfoType', '1' ]
	, [ 'FinalValueFee', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'Item', 'ns:ItemType', ''
	     ,'eBay::API::XML::DataType::ItemType', '1' ]
	, [ 'ListingCheckoutRedirectPreference', 'ns:ListingCheckoutRedirectPreferenceType', ''
	     ,'eBay::API::XML::DataType::ListingCheckoutRedirectPreferenceType', '1' ]
	, [ 'PaidTime', 'xs:dateTime', '', '', '' ]
	, [ 'PaisaPayID', 'xs:string', '', '', '' ]
	, [ 'PayPalEmailAddress', 'xs:string', '', '', '' ]
	, [ 'Platform', 'ns:TransactionPlatformCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::TransactionPlatformCodeType', '' ]
	, [ 'QuantityPurchased', 'xs:int', '', '', '' ]
	, [ 'RefundArray', 'ns:RefundArrayType', ''
	     ,'eBay::API::XML::DataType::RefundArrayType', '1' ]
	, [ 'SellerContactBuyerByEmail', 'xs:boolean', '', '', '' ]
	, [ 'SellerPaidStatus', 'ns:PaidStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::PaidStatusCodeType', '' ]
	, [ 'SellingManagerProductDetails', 'ns:SellingManagerProductDetailsType', ''
	     ,'eBay::API::XML::DataType::SellingManagerProductDetailsType', '1' ]
	, [ 'ShippedTime', 'xs:dateTime', '', '', '' ]
	, [ 'ShippingDetails', 'ns:ShippingDetailsType', ''
	     ,'eBay::API::XML::DataType::ShippingDetailsType', '1' ]
	, [ 'ShippingServiceSelected', 'ns:ShippingServiceOptionsType', ''
	     ,'eBay::API::XML::DataType::ShippingServiceOptionsType', '1' ]
	, [ 'Status', 'ns:TransactionStatusType', ''
	     ,'eBay::API::XML::DataType::TransactionStatusType', '1' ]
	, [ 'TotalPrice', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'TransactionID', 'xs:string', '', '', '' ]
	, [ 'TransactionPlatform', 'ns:TransactionPlatformCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::TransactionPlatformCodeType', '' ]
	, [ 'TransactionPrice', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'TransactionSiteID', 'ns:SiteCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::SiteCodeType', '' ]
	, [ 'VATPercent', 'xs:decimal', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAdjustmentAmount()

Adjustment amount entered by the buyer. A positive amount indicates the amount
is an extra charge being paid to the seller by the buyer. A negative value
indicates this amount is a credit given to the buyer by the seller. Not
applicable to Half.com.

#    Argument: 'ns:AmountType'

=cut

sub setAdjustmentAmount {
  my $self = shift;
  $self->{'AdjustmentAmount'} = shift
}

=head2 getAdjustmentAmount()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'ns:AmountType'

=cut

sub getAdjustmentAmount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'AdjustmentAmount'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setAmountPaid()

The amount the buyer paid for the item(s) in the transaction.
If the seller allowed the buyer to change the item total, the buyer
is able to change the total until the time that the transaction's
status moves to Complete. Determine whether the buyer
changed the amount by retrieving the transaction data and comparing
the AmountPaid value to what the seller expected.
For combined payment (the transaction is part of an
order), GetSellerTransactions and GetItemTransactions return the
amount paid for the order to which the transaction belongs.
For Motors items, AmountPaid is the amount paid by the buyer for the deposit.
Not applicable to Half.com.

#    Argument: 'ns:AmountType'

=cut

sub setAmountPaid {
  my $self = shift;
  $self->{'AmountPaid'} = shift
}

=head2 getAmountPaid()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'ns:AmountType'

=cut

sub getAmountPaid {
  my $self = shift;
  return $self->_getDataTypeInstance( 'AmountPaid'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setBestOfferSale()

Whether the transaction was completed with the seller selecting
a best offer.
Not applicable to Half.com.

#    Argument: 'xs:boolean'

=cut

sub setBestOfferSale {
  my $self = shift;
  $self->{'BestOfferSale'} = shift
}

=head2 isBestOfferSale()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isBestOfferSale {
  my $self = shift;
  return $self->{'BestOfferSale'};
}


=head2 setBuyer()

Contains the data for the transaction's buyer. See UserType for its
child elements.
<br><br>
Returned by GetItemsAwaitingFeedback if Seller is making the request.
<br><br>
Not applicable to Half.com except for GetOrders.

#    Argument: 'ns:UserType'

=cut

sub setBuyer {
  my $self = shift;
  $self->{'Buyer'} = shift
}

=head2 getBuyer()

  Calls: GetItemsAwaitingFeedback
  Returned: Conditionally

  Calls: GetOrders
  Returned: Conditionally
  Details: DetailLevel: none

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: SoldList
           DeletedFromSoldList

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:UserType'

=cut

sub getBuyer {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Buyer'
		,'eBay::API::XML::DataType::UserType');
}


=head2 setBuyerGuaranteePrice()

For the Australia site, BuyerGuaranteePrice is the PayPal Buyer Protection coverage,
offered for the item at the time of purchase.
Details of coverage are in the following sections
of the View Item page: the Buy Safely section and the Payment Details section.

#    Argument: 'ns:AmountType'

=cut

sub setBuyerGuaranteePrice {
  my $self = shift;
  $self->{'BuyerGuaranteePrice'} = shift
}

=head2 getBuyerGuaranteePrice()

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'ns:AmountType'

=cut

sub getBuyerGuaranteePrice {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BuyerGuaranteePrice'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setBuyerMessage()

Display message from buyer. This field holds transient
data that is only being returned in the notification flow.
This field is only returned in the Checkout related notifications.
Not applicable to Half.com.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=PlatformNotifications
Title: Working with Platform Notifications

#    Argument: 'xs:string'

=cut

sub setBuyerMessage {
  my $self = shift;
  $self->{'BuyerMessage'} = shift
}

=head2 getBuyerMessage()

#    Returns: 'xs:string'

=cut

sub getBuyerMessage {
  my $self = shift;
  return $self->{'BuyerMessage'};
}


=head2 setBuyerPaidStatus()

Specifies the transaction's paid status, as seen by the buyer. Returned in lists of won items.
Not applicable to Half.com.

#    Argument: 'ns:PaidStatusCodeType'

=cut

sub setBuyerPaidStatus {
  my $self = shift;
  $self->{'BuyerPaidStatus'} = shift
}

=head2 getBuyerPaidStatus()

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: WonList
           DeletedFromWonList

#    Returns: 'ns:PaidStatusCodeType'

=cut

sub getBuyerPaidStatus {
  my $self = shift;
  return $self->{'BuyerPaidStatus'};
}


=head2 setCartID()

Shopping cart identifier. Only returned for transactions made
on Shopping.com using the Shopping.com shopping cart.

MaxLength: 10

#    Argument: 'xs:string'

=cut

sub setCartID {
  my $self = shift;
  $self->{'CartID'} = shift
}

=head2 getCartID()

  Calls: GetItemTransactions
         GetOrderTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:string'

=cut

sub getCartID {
  my $self = shift;
  return $self->{'CartID'};
}


=head2 setContainingOrder()

The order to which the transaction belongs. This is only returned if
IncludeContainingOrder is true and and if this transaction is part of an
active or completed order.
Not applicable to Half.com.

#    Argument: 'ns:OrderType'

=cut

sub setContainingOrder {
  my $self = shift;
  $self->{'ContainingOrder'} = shift
}

=head2 getContainingOrder()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:OrderType'

=cut

sub getContainingOrder {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ContainingOrder'
		,'eBay::API::XML::DataType::OrderType');
}


=head2 setConvertedAdjustmentAmount()

Converted value of AdjustmentAmount in the currency of the site that returned
the response. Refresh this value every 24 hours to pick up the current
conversion rates. Not applicable to Half.com.

#    Argument: 'ns:AmountType'

=cut

sub setConvertedAdjustmentAmount {
  my $self = shift;
  $self->{'ConvertedAdjustmentAmount'} = shift
}

=head2 getConvertedAdjustmentAmount()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'ns:AmountType'

=cut

sub getConvertedAdjustmentAmount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ConvertedAdjustmentAmount'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setConvertedAmountPaid()

Converted value of AmountPaid in the currency of the site that returned the
response. Refresh this value every 24 hours to pick up the current
conversion rates.
Not applicable to Half.com.

#    Argument: 'ns:AmountType'

=cut

sub setConvertedAmountPaid {
  my $self = shift;
  $self->{'ConvertedAmountPaid'} = shift
}

=head2 getConvertedAmountPaid()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'ns:AmountType'

=cut

sub getConvertedAmountPaid {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ConvertedAmountPaid'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setConvertedTransactionPrice()

Converted value of TransactionPrice in the currency of the site that returned the
response. Refresh this value every 24 hours to pick up the current conversion rates.
Not applicable to Half.com.

#    Argument: 'ns:AmountType'

=cut

sub setConvertedTransactionPrice {
  my $self = shift;
  $self->{'ConvertedTransactionPrice'} = shift
}

=head2 getConvertedTransactionPrice()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'ns:AmountType'

=cut

sub getConvertedTransactionPrice {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ConvertedTransactionPrice'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setCreatedDate()

Indicates when the transaction was created. For fixed-price, Stores, and BIN items
this indicates when the purchase (or BIN) occurred. For competitive-bidding listing
types this indicates when listing ended, the winning bidder(s) determined, and the
transaction created.
For GetOrders, only applicable to Half.com.

#    Argument: 'xs:dateTime'

=cut

sub setCreatedDate {
  my $self = shift;
  $self->{'CreatedDate'} = shift
}

=head2 getCreatedDate()

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetOrderTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: WonList
           DeletedFromWonList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: SoldList
           DeletedFromSoldList

#    Returns: 'xs:dateTime'

=cut

sub getCreatedDate {
  my $self = shift;
  return $self->{'CreatedDate'};
}


=head2 setDepositType()

Whether the seller requires a deposit for the vehicle.
Only applicable to US eBay Motors listings. If item is not a Motors
item, then this returns an empty value.
Not applicable to Half.com.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=MotorsDeposit
Title: Specifying a Vehicle Deposit and Deposit Amount

#    Argument: 'ns:DepositTypeCodeType'

=cut

sub setDepositType {
  my $self = shift;
  $self->{'DepositType'} = shift
}

=head2 getDepositType()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
  OnlyTheseValues: None, OtherMethod

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
  OnlyTheseValues: None, OtherMethod

#    Returns: 'ns:DepositTypeCodeType'

=cut

sub getDepositType {
  my $self = shift;
  return $self->{'DepositType'};
}


=head2 setDutchAuctionBid()

This field holds the Dutch Auction Offer Bid by the buyer in this transaction,
if this is a Dutch Auction Item. This field will only be returned if caller has set
IncludeDuctionAuctionBid to true.
Not applicable to Half.com.

#    Argument: 'ns:AmountType'

=cut

sub setDutchAuctionBid {
  my $self = shift;
  $self->{'DutchAuctionBid'} = shift
}

=head2 getDutchAuctionBid()

#    Returns: 'ns:AmountType'

=cut

sub getDutchAuctionBid {
  my $self = shift;
  return $self->_getDataTypeInstance( 'DutchAuctionBid'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setExternalTransaction()

A PayPal transaction that relates to this eBay transaction.
Returned only if there is at least one PayPal transaction related to this
eBay transaction.
Not applicable to Half.com.

#    Argument: reference to an array  
                      of 'ns:ExternalTransactionType'

=cut

sub setExternalTransaction {
  my $self = shift;
  $self->{'ExternalTransaction'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getExternalTransaction()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetOrders
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: reference to an array  
                      of 'ns:ExternalTransactionType'

=cut

sub getExternalTransaction {
  my $self = shift;
  return $self->_getDataTypeArray('ExternalTransaction');
}


=head2 setFeedbackLeft()

A container for feedback information left FOR the user's
transaction partner. Only returned if feedback was left for
a transaction.
<br /><br />
Not applicable to Half.com.

#    Argument: 'ns:FeedbackInfoType'

=cut

sub setFeedbackLeft {
  my $self = shift;
  $self->{'FeedbackLeft'} = shift
}

=head2 getFeedbackLeft()

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: WonList
           DeletedFromWonList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: SoldList
           DeletedFromSoldList

#    Returns: 'ns:FeedbackInfoType'

=cut

sub getFeedbackLeft {
  my $self = shift;
  return $self->_getDataTypeInstance( 'FeedbackLeft'
		,'eBay::API::XML::DataType::FeedbackInfoType');
}


=head2 setFeedbackReceived()

A container for feedback information left BY the user's
transaction partner. Only returned if feedback was left for
a transaction.
<br /><br />
Not applicable to Half.com.

#    Argument: 'ns:FeedbackInfoType'

=cut

sub setFeedbackReceived {
  my $self = shift;
  $self->{'FeedbackReceived'} = shift
}

=head2 getFeedbackReceived()

  Calls: GetItemsAwaitingFeedback
  Returned: Conditionally

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: WonList
           DeletedFromWonList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: SoldList
           DeletedFromSoldList

#    Returns: 'ns:FeedbackInfoType'

=cut

sub getFeedbackReceived {
  my $self = shift;
  return $self->_getDataTypeInstance( 'FeedbackReceived'
		,'eBay::API::XML::DataType::FeedbackInfoType');
}


=head2 setFinalValueFee()

You are charged a Final Value Fee if your item is sold, ends with a winning
bid, or is purchased. This fee applies whether or not you actually complete
the sale with the buyer. If you request a Final Value Fee Credit, the value of
Transaction.FinalValueFee will not change for the item if a credit is issued.
(The credit only appears in the seller's account data.) See the eBay.com Web
site online help for more information about the Final Value Fee. The Final
Value Fee for FixedPriceItem, StoresFixedPrice, and Buy It Now Dutch listing
types is returned by GetSellerTransactions, GetItemTransactions, and GetOrderTransactions
on a transaction-by-transaction basis. For all other listing types, including
Chinese and Dutch (no Buy It Now purchases), the Final Value Fee is returned
when the listing status is Completed. If the item was a Dutch auction that
ended with bids (not Buy It Now purchases), the Final Value Fee is returned in
Item.SellingStatus.FinalValueFee. For all other listing types, including Dutch
auctions that end with Buy It Now purchases, the Final Value Fee is returned
in Transaction.FinalValueFee. Not applicable to Half.com.

#    Argument: 'ns:AmountType'

=cut

sub setFinalValueFee {
  my $self = shift;
  $self->{'FinalValueFee'} = shift
}

=head2 getFinalValueFee()

  Calls: GetOrderTransactions
         GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'ns:AmountType'

=cut

sub getFinalValueFee {
  my $self = shift;
  return $self->_getDataTypeInstance( 'FinalValueFee'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setItem()

Information about the item that spawned the transaction. It is a purchase from
this item's listing that the transaction represents. To remove a property
from an item, specify it in ModifyType as a changed property, but do not give
it a value in Item.
Also applicable to Half.com (for GetOrders).

  Calls: AddOrder
  RequiredInput: Yes

#    Argument: 'ns:ItemType'

=cut

sub setItem {
  my $self = shift;
  $self->{'Item'} = shift
}

=head2 getItem()

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetOrderTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: WonList
           DeletedFromWonList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: SoldList
           DeletedFromSoldList

  Calls: GetItemsAwaitingFeedback
         GetMyeBaySelling
  Returned: Conditionally

  Calls: GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'ns:ItemType'

=cut

sub getItem {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Item'
		,'eBay::API::XML::DataType::ItemType');
}


=head2 setListingCheckoutRedirectPreference()

ProStores listing level preferences regarding the store to which
checkout should be redirected for the listing if ThirdPartyCheckout
is true.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ThirdPartyCheckoutRedirectProStores
Title: Third Party Checkout Redirect to ProStores

#    Argument: 'ns:ListingCheckoutRedirectPreferenceType'

=cut

sub setListingCheckoutRedirectPreference {
  my $self = shift;
  $self->{'ListingCheckoutRedirectPreference'} = shift
}

=head2 getListingCheckoutRedirectPreference()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrders
  Returned: Conditionally
  Details: DetailLevel: none

#    Returns: 'ns:ListingCheckoutRedirectPreferenceType'

=cut

sub getListingCheckoutRedirectPreference {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ListingCheckoutRedirectPreference'
		,'eBay::API::XML::DataType::ListingCheckoutRedirectPreferenceType');
}


=head2 setPaidTime()

Indicates the time when the transaction was marked paid, if known.
The value is set by eBay when payment is made via PayPal or a
third-party checkout flow.
This value is also set when the seller marks the item as
paid by using ReviseCheckoutStatus or CompleteSale.
The seller can also mark the item as paid by using My eBay
or Selling Manager Pro.
Note that this value is only visible if the request user is
the buyer or seller associated with the transaction.
If the item is marked as paid but the seller is not a
Selling Manager Pro user, PaidTime returns the
transaction creation time instead.
Not applicable to Half.com.

#    Argument: 'xs:dateTime'

=cut

sub setPaidTime {
  my $self = shift;
  $self->{'PaidTime'} = shift
}

=head2 getPaidTime()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: WonList
           DeletedFromWonList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: SoldList
           DeletedFromSoldList

#    Returns: 'xs:dateTime'

=cut

sub getPaidTime {
  my $self = shift;
  return $self->{'PaidTime'};
}


=head2 setPaisaPayID()

Specifies the PaisaPayID using which the Item was paid for. Applicable for India site(203) only.

  Calls: GetMyeBayBuying
  RequiredInput: No
  Returned: Conditionally

  Calls: GetMyeBaySelling
  RequiredInput: No
  Returned: Conditionally

#    Argument: 'xs:string'

=cut

sub setPaisaPayID {
  my $self = shift;
  $self->{'PaisaPayID'} = shift
}

=head2 getPaisaPayID()

  Calls: GetMyeBayBuying
  RequiredInput: No
  Returned: Conditionally

  Calls: GetMyeBaySelling
  RequiredInput: No
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getPaisaPayID {
  my $self = shift;
  return $self->{'PaisaPayID'};
}


=head2 setPayPalEmailAddress()

The seller's Paypal email address.

#    Argument: 'xs:string'

=cut

sub setPayPalEmailAddress {
  my $self = shift;
  $self->{'PayPalEmailAddress'} = shift
}

=head2 getPayPalEmailAddress()

  Calls: GetItemTransactions
         GetOrderTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:string'

=cut

sub getPayPalEmailAddress {
  my $self = shift;
  return $self->{'PayPalEmailAddress'};
}


=head2 setPlatform()

Name of the eBay co-branded site upon which the transaction was made.

#    Argument: 'ns:TransactionPlatformCodeType'

=cut

sub setPlatform {
  my $self = shift;
  $self->{'Platform'} = shift
}

=head2 getPlatform()

  Calls: GetItemTransactions
         GetOrderTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

  Calls: GetItemTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:TransactionPlatformCodeType'

=cut

sub getPlatform {
  my $self = shift;
  return $self->{'Platform'};
}


=head2 setQuantityPurchased()

Indicates the number of items the buyer purchased from the listing identified
in ItemID.
Also applicable to Half.com (for GetOrders).

#    Argument: 'xs:int'

=cut

sub setQuantityPurchased {
  my $self = shift;
  $self->{'QuantityPurchased'} = shift
}

=head2 getQuantityPurchased()

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: WonList
           DeletedFromWonList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: SoldList
           DeletedFromSoldList

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:int'

=cut

sub getQuantityPurchased {
  my $self = shift;
  return $self->{'QuantityPurchased'};
}


=head2 setRefundArray()

Contains an array of refunds.
Applicable to Half.com (for GetOrders).

#    Argument: 'ns:RefundArrayType'

=cut

sub setRefundArray {
  my $self = shift;
  $self->{'RefundArray'} = shift
}

=head2 getRefundArray()

  Calls: GetOrders
  Returned: Conditionally
  Details: DetailLevel: none

#    Returns: 'ns:RefundArrayType'

=cut

sub getRefundArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'RefundArray'
		,'eBay::API::XML::DataType::RefundArrayType');
}


=head2 setSellerContactBuyerByEmail()

Indicates whether the buyer has opted to accept emails from all the
seller(s) in the Shopping.com shopping cart. Only returned for transactions
made on Shopping.com using the Shopping.com shopping cart.

#    Argument: 'xs:boolean'

=cut

sub setSellerContactBuyerByEmail {
  my $self = shift;
  $self->{'SellerContactBuyerByEmail'} = shift
}

=head2 isSellerContactBuyerByEmail()

  Calls: GetItemTransactions
         GetOrderTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isSellerContactBuyerByEmail {
  my $self = shift;
  return $self->{'SellerContactBuyerByEmail'};
}


=head2 setSellerPaidStatus()

Specifies the transaction's payment status, as seen by the seller. Returned in lists of sold items.
Not applicable to Half.com.

#    Argument: 'ns:PaidStatusCodeType'

=cut

sub setSellerPaidStatus {
  my $self = shift;
  $self->{'SellerPaidStatus'} = shift
}

=head2 getSellerPaidStatus()

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: SoldList
           DeletedFromSoldList

#    Returns: 'ns:PaidStatusCodeType'

=cut

sub getSellerPaidStatus {
  my $self = shift;
  return $self->{'SellerPaidStatus'};
}


=head2 setSellingManagerProductDetails()

Not applicable to Half.com.

#    Argument: 'ns:SellingManagerProductDetailsType'

=cut

sub setSellingManagerProductDetails {
  my $self = shift;
  $self->{'SellingManagerProductDetails'} = shift
}

=head2 getSellingManagerProductDetails()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'ns:SellingManagerProductDetailsType'

=cut

sub getSellingManagerProductDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SellingManagerProductDetails'
		,'eBay::API::XML::DataType::SellingManagerProductDetailsType');
}


=head2 setShippedTime()

Indicates the time when the item(s) associated with the transaction were
marked as shipped, if known. The value is set when the seller uses shipment
tracking features offered by eBay or an eBay partner. This value is also set
when the seller marks the item as shipped by using CompleteSale. If the seller
is a Selling Manager Pro user, they can also mark the item as shipped by using
My eBay. Note that this value is only visible if the request user is the buyer
or seller associated with the transaction. Applicable to Half.com (for GetOrders).

#    Argument: 'xs:dateTime'

=cut

sub setShippedTime {
  my $self = shift;
  $self->{'ShippedTime'} = shift
}

=head2 getShippedTime()

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: SoldList
           DeletedFromSoldList

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: WonList
           DeletedFromWonList

#    Returns: 'xs:dateTime'

=cut

sub getShippedTime {
  my $self = shift;
  return $self->{'ShippedTime'};
}


=head2 setShippingDetails()

The shipping-related details for an item or transaction, including flat and
calculated shipping costs and shipping insurance costs. For GetOrders, also
applicable to Half.com. For GetOrders, minimal ShippingDetails information is
returned under the Transaction container.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=Shipping
Title: Shipping

#    Argument: 'ns:ShippingDetailsType'

=cut

sub setShippingDetails {
  my $self = shift;
  $self->{'ShippingDetails'} = shift
}

=head2 getShippingDetails()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:ShippingDetailsType'

=cut

sub getShippingDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ShippingDetails'
		,'eBay::API::XML::DataType::ShippingDetailsType');
}


=head2 setShippingServiceSelected()

The shipping service selected by the buyer from the services
offered by the seller.
Not applicable to Half.com.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=Shipping
Title: Shipping

#    Argument: 'ns:ShippingServiceOptionsType'

=cut

sub setShippingServiceSelected {
  my $self = shift;
  $self->{'ShippingServiceSelected'} = shift
}

=head2 getShippingServiceSelected()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'ns:ShippingServiceOptionsType'

=cut

sub getShippingServiceSelected {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ShippingServiceSelected'
		,'eBay::API::XML::DataType::ShippingServiceOptionsType');
}


=head2 setStatus()

Contains the status of the transaction, such as the buyer's online payment and
whether the checkout process for the transaction has been completed. See
TransactionStatusType for its child elements.
Not applicable to Half.com.

#    Argument: 'ns:TransactionStatusType'

=cut

sub setStatus {
  my $self = shift;
  $self->{'Status'} = shift
}

=head2 getStatus()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrders
  Returned: Conditionally
  Details: DetailLevel: none

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: WonList
           DeletedFromWonList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: SoldList
           DeletedFromSoldList

#    Returns: 'ns:TransactionStatusType'

=cut

sub getStatus {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Status'
		,'eBay::API::XML::DataType::TransactionStatusType');
}


=head2 setTotalPrice()

Not applicable to Half.com.

#    Argument: 'ns:AmountType'

=cut

sub setTotalPrice {
  my $self = shift;
  $self->{'TotalPrice'} = shift
}

=head2 getTotalPrice()

#    Returns: 'ns:AmountType'

=cut

sub getTotalPrice {
  my $self = shift;
  return $self->_getDataTypeInstance( 'TotalPrice'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setTransactionID()

Identifier for the transaction.
A value of zero is used for the Chinese auction format.
Thus, a value of zero is a valid transaction ID.
A transaction ID is only unique to the listing
that spawned it, so a transaction is only uniquely identified on a global basis by
a combination of ItemID and TransactionID.
Also applicable to Half.com (for GetOrders).

MaxLength: 19 (Note: The eBay database specifies 38. Currently, transaction IDs are usually 9 to 12 digits.)

  Calls: AddOrder
  RequiredInput: Yes

#    Argument: 'xs:string'

=cut

sub setTransactionID {
  my $self = shift;
  $self->{'TransactionID'} = shift
}

=head2 getTransactionID()

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetOrderTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: WonList
           DeletedFromWonList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: SoldList
           DeletedFromSoldList

  Calls: GetItemsAwaitingFeedback
  Returned: Conditionally

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:string'

=cut

sub getTransactionID {
  my $self = shift;
  return $self->{'TransactionID'};
}


=head2 setTransactionPlatform()

Indicates the platform the item was purchased on (such as eBay or eBay Express).
Not applicable to Half.com, even if the item was purchased on Express.

#    Argument: 'ns:TransactionPlatformCodeType'

=cut

sub setTransactionPlatform {
  my $self = shift;
  $self->{'TransactionPlatform'} = shift
}

=head2 getTransactionPlatform()

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: WonList
           DeletedFromWonList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: SoldList
           DeletedFromSoldList

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Always
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:TransactionPlatformCodeType'

=cut

sub getTransactionPlatform {
  my $self = shift;
  return $self->{'TransactionPlatform'};
}


=head2 setTransactionPrice()

Price of the transaction (before shipping and sales tax) that the buyer needs to pay
to complete the purchase.
Note that for GetItemTransactions and GetSellerTransactions,
TransactionPrice is the per-item price for the transaction;
transactions with TransactionArray.Transaction.QuantityPurchased of more than 1 have the same
value for TransactionPrice as transactions with TransactionArray.Transaction.QuantityPurchased of 1.
For eBay Motors, TransactionPrice is the deposit amount.
Also applicable to Half.com (for GetOrders).

#    Argument: 'ns:AmountType'

=cut

sub setTransactionPrice {
  my $self = shift;
  $self->{'TransactionPrice'} = shift
}

=head2 getTransactionPrice()

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetOrderTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'ns:AmountType'

=cut

sub getTransactionPrice {
  my $self = shift;
  return $self->_getDataTypeInstance( 'TransactionPrice'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setTransactionSiteID()

The site upon which the item transaction was made.

#    Argument: 'ns:SiteCodeType'

=cut

sub setTransactionSiteID {
  my $self = shift;
  $self->{'TransactionSiteID'} = shift
}

=head2 getTransactionSiteID()

  Calls: GetItemTransactions
         GetOrderTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

  Calls: GetItemTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:SiteCodeType'

=cut

sub getTransactionSiteID {
  my $self = shift;
  return $self->{'TransactionSiteID'};
}


=head2 setVATPercent()

VAT rate for the item. When the VATPercent is specified, the item's VAT
information appears on the item's listing page. In addition, the seller
can choose to print an invoice that includes the item's net price, VAT
percent, VAT amount, and total price. Since VAT rates vary depending on the
item and on the user's country of residence, a seller is responsible for
entering the correct VAT rate; it is not calculated by eBay. To specify a
VATPercent, a seller must have a VAT-ID registered with eBay and must be
listing the item on a VAT-enabled site. Max precision 3 decimal places. Max
length 5 characters. Note: The View Item page displays the precision to 2
decimal places with no trailing zeros. However, the full value you send in is
stored. Not applicable to Half.com.

#    Argument: 'xs:decimal'

=cut

sub setVATPercent {
  my $self = shift;
  $self->{'VATPercent'} = shift
}

=head2 getVATPercent()

#    Returns: 'xs:decimal'

=cut

sub getVATPercent {
  my $self = shift;
  return $self->{'VATPercent'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
