[= autogen5 template

# $Id: opthead.tpl,v 2.43 2004/02/02 03:31:50 bkorb Exp $
# Automated Options copyright 1992-2004 Bruce Korb

=]
/*
 *  This file contains the programmatic interface to the Automated
 *  Options generated for the [=prog-name=] program.
 *  These macros are documented in the AutoGen info file in the
 *  "AutoOpts" chapter.  Please refer to that doc for usage help.
 */
[= (make-header-guard "autoopts") =]
[= Option_Copyright =][=
% config-header "\n#include \"%s\""=]
#include <options.h>

/*
 *  Enumeration of each option:
 */
typedef enum {[=
FOR flag    =][=
  IF (not (exist? "documentation")) =]
        [= (sprintf "%-26s =%3d," (index-name "name") (for-index)) =][=
  ENDIF     =][=
ENDFOR flag =][=

(define option-ct (count "flag")) =][=

IF (exist? "version") =]
        [= (. INDEX-pfx) =]VERSION          = [=
                (set! option-ct (+ option-ct 1)) (- option-ct 1)=],[=
ENDIF =]
        [= (. INDEX-pfx) =]HELP             = [=
                (set! option-ct (+ option-ct 1)) (- option-ct 1)=],
        [= (. INDEX-pfx) =]MORE_HELP        = [=
                (set! option-ct (+ option-ct 1)) (- option-ct 1)=][=

IF (exist? "homerc") =],
        [= (. INDEX-pfx) =]SAVE_OPTS        = [=
                (set! option-ct (+ option-ct 1)) (- option-ct 1)=],
        [= (. INDEX-pfx) =]LOAD_OPTS        = [=
                (set! option-ct (+ option-ct 1)) (- option-ct 1)=][=
ENDIF =]
} te[=(. Cap-prefix)=]OptIndex;

#define [=(. UP-prefix)=]OPTION_CT    [= (. option-ct) =][=
IF (exist? "version") =]
#define [=(. pname-up)=]_VERSION       [=(c-string (get "version"))=]
#define [=(. pname-up)=]_FULL_VERSION  [=(c-string (sprintf
"%s - %s - Ver. %s" prog-name (get "prog-title") (get "version"))) =][=
ENDIF (exist? version) =]

/*
 *  Interface defines for all options.  Replace "n" with
 *  the UPPER_CASED option name (as in the te[=(. Cap-prefix)=]OptIndex
 *  enumeration above).  e.g. HAVE_[=(. UP-prefix)=]OPT( [=
    (up-c-name "flag[].name") =] )
 */[=
(sprintf "
#define         %1$sDESC(n) %2$sOptions.pOptDesc[INDEX_%1$sOPT_ ## n]
#define     HAVE_%1$sOPT(n) (! UNUSED_OPT(& %1$sDESC(n)))
#define      %1$sOPT_ARG(n) (%1$sDESC(n).pzLastArg)
#define    STATE_%1$sOPT(n) (%1$sDESC(n).fOptState & OPTST_SET_MASK)
#define    COUNT_%1$sOPT(n) (%1$sDESC(n).optOccCt)
#define    ISSEL_%1$sOPT(n) (SELECTED_OPT(&%1$sDESC(n)))
#define ISUNUSED_%1$sOPT(n) (UNUSED_OPT(& %1$sDESC(n)))
#define  ENABLED_%1$sOPT(n) (! DISABLED_OPT(& %1$sDESC(n)))
#define  STACKCT_%1$sOPT(n) (((tArgList*)(%1$sDESC(n).optCookie))->useCt)
#define STACKLST_%1$sOPT(n) (((tArgList*)(%1$sDESC(n).optCookie))->apzArgs)
#define    CLEAR_%1$sOPT(n) STMTS( \\
                %1$sDESC(n).fOptState &= OPTST_PERSISTENT;   \\
                if ( (%1$sDESC(n).fOptState & OPTST_INITENABLED) == 0) \\
                    %1$sDESC(n).fOptState |= OPTST_DISABLED; \\
                %1$sDESC(n).optCookie = NULL )"

  UP-prefix pname

) =]

/*
 *  Interface defines for specific options.
 */[=

FOR flag              =][=
  (set-flag-names)
  (set! opt-name   (string-append OPT-pfx UP-name))
  (set! descriptor (string-append UP-prefix "DESC(" UP-name ")" )) =][=

 IF (exist? "documentation") =][=
   IF (or (exist? "call-proc") (exist? "flag-code") (exist? "extract-code"))
=]
#define SET_[= (string-append OPT-pfx UP-name) =]   STMTS( \
        (*([=(. descriptor)=].pOptProc))( &[=(. pname)=]Options, \
                [=(. pname)=]Options.pOptDesc + [=(for-index)=] )[=

   ENDIF              =][=
 ELSE                 =][=
   Option_Defines     =][=
 ENDIF                =][=
ENDFOR  flag          =][=#

* * * * * * * * * * * * * * * * * * * * * * * * * * * *

Autoopts maintained option values.

If *any* option flag value is specified,
then we provide flag characters for our options.
Otherwise, we will use the INDEX_* values for the option value.

There are no documentation strings because these defines
are used identically to the user-generated VALUE defines.

:=]
[=
IF (exist? "flag.value") =][=
  IF (exist? "version")  =]
#define [= (. VALUE-pfx) =]VERSION        [=
    IF (not (exist? "version-value")) =]'v'[=
    ELSE      =][=
      CASE (get "version-value")  =][=
      == ""   =][= (if (not (exist? "long-opts"))
                       (error "'version-value' may not be empty")) INDEX-pfx
              =]VERSION[=
      == "'"  =]'\''[=
      ~~ .    =]'[=version-value=]'[=
      *       =][=(error "value (flag) codes must be single characters") =][=
      ESAC    =][=
    ENDIF     =][=
  ENDIF       =][=

  IF (exist? "homerc")=]
#define [= (. VALUE-pfx) =]SAVE_OPTS      [=
    IF (not (exist? "save-opts-value")) =]'>'[=
    ELSE      =][=
      CASE (get "save-opts-value")  =][=
      == ""   =][= (if (not (exist? "long-opts"))
                       (error "'save-opts-value' may not be empty")) INDEX-pfx
              =]SAVE_OPTS[=
      == "'"  =]'\''[=
      ~~ .    =]'[=save-opts-value=]'[=
      *       =][=(error "value (flag) codes must be single characters") =][=
      ESAC    =][=
    ENDIF     =]
#define [= (. VALUE-pfx) =]LOAD_OPTS      [=
    IF (not (exist? "load-opts-value")) =]'<'[=
    ELSE      =][=
      CASE (get "load-opts-value")  =][=
      == ""   =][= (if (not (exist? "long-opts"))
                       (error "'load-opts-value' may not be empty")) INDEX-pfx
              =]LOAD_OPTS[=
      == "'"  =]'\''[=
      ~~ .    =]'[=load-opts-value=]'[=
      *       =][=(error "value (flag) codes must be single characters") =][=
      ESAC    =][=
    ENDIF     =][=
  ENDIF
=]
#define [= (. VALUE-pfx) =]HELP           [=
    IF (not (exist? "help-value")) =]'?'[=
    ELSE      =][=
      CASE (get "help-value")  =][=
      == ""   =][= (if (not (exist? "long-opts"))
                       (error "'help-value' may not be empty")) INDEX-pfx
              =]HELP[=
      == "'"  =]'\''[=
      ~~ .    =]'[=help-value=]'[=
      *       =][=(error "value (flag) codes must be single characters") =][=
      ESAC    =][=
    ENDIF     =]
#define [= (. VALUE-pfx) =]MORE_HELP      [=
    IF (not (exist? "more-help-value")) =]'!'[=
    ELSE      =][=
      CASE (get "more-help-value")  =][=
      == ""   =][= (if (not (exist? "long-opts"))
                       (error "'more-help-value' may not be empty")) INDEX-pfx
              =]MORE_HELP[=
      == "'"  =]'\''[=
      ~~ .    =]'[=more-help-value=]'[=
      *       =][=(error "value (flag) codes must be single characters") =][=
      ESAC    =][=
    ENDIF     =][=

ELSE "flag.value *DOES NOT* exist" =][=

  IF (exist? "version") =]
#define [= (. VALUE-pfx) =]VERSION        [= (. INDEX-pfx) =]VERSION[=
  ENDIF=][=
  IF (exist? "homerc") =]
#define [= (. VALUE-pfx) =]SAVE_OPTS      [= (. INDEX-pfx) =]SAVE_OPTS
#define [= (. VALUE-pfx) =]LOAD_OPTS      [= (. INDEX-pfx) =]LOAD_OPTS[=
  ENDIF=]
#define [= (. VALUE-pfx) =]HELP           [= (. INDEX-pfx) =]HELP
#define [= (. VALUE-pfx) =]MORE_HELP      [= (. INDEX-pfx) =]MORE_HELP[=
ENDIF=][=

IF (exist? "homerc") =]
#define SET_[=(. OPT-pfx)=]SAVE_OPTS(a)   STMTS( \
        [=(. UP-prefix)=]DESC(SAVE_OPTS).fOptState &= OPTST_PERSISTENT; \
        [=(. UP-prefix)=]DESC(SAVE_OPTS).fOptState |= OPTST_SET; \
        [=(. UP-prefix)=]DESC(SAVE_OPTS).pzLastArg  = (tCC*)(a) )[=
ENDIF
=]

/*
 *  Interface defines not associated with particular options
 */
#define  ERRSKIP_[=(. UP-prefix)=]OPTERR STMTS( [=(. pname)
                         =]Options.fOptSet &= ~OPTPROC_ERRSTOP )
#define  ERRSTOP_[=(. UP-prefix)=]OPTERR STMTS( [=(. pname)
                         =]Options.fOptSet |= OPTPROC_ERRSTOP )
#define  RESTART_[=(. UP-prefix)=]OPT(n) STMTS( \
                [=(. pname)=]Options.curOptIdx = (n); \
                [=(. pname)=]Options.pzCurOpt  = NULL )
#define    START_[=(. UP-prefix)=]OPT    RESTART_[=(. UP-prefix)
                =]OPT(1)
#define     [=(. UP-prefix)=]USAGE(c)    (*[=(. pname)
                 =]Options.pUsageProc)( &[=(. pname)=]Options, c )[=#

* * * * * * * * * * * * * * * * * * * * * * * * * * * *
=]

/* * * * * *
 *
 *  Declare the [=prog-name=] option descriptor.
 */
#ifdef  __cplusplus
extern "C" {
#endif

extern tOptions   [=(. pname)=]Options;[=

IF (exist? "export")=]

/* * * * * *
 *
 *  Globals exported from the [=prog_title=] option definitions
 */[=
  FOR export "\n"=]
[= (get "export") =][=
  ENDFOR export=][=
ENDIF=]

#ifndef _
#  if ENABLE_NLS
#    include <stdio.h>
     static inline char* aoGetsText( const char* pz ) {
         if (pz == NULL) return NULL;
         return (char*)gettext( pz );
     }
#    define _(s)  aoGetsText(s)
#  else  /* ENABLE_NLS */
#    define _(s)  s
#  endif /* ENABLE_NLS */
#endif

#ifdef  __cplusplus
}
#endif
#endif /* [=(. header-guard)=] */
