/* Leaving a signal handler executing on the alternate stack.
   Copyright (C) 2002  Bruno Haible <bruno@clisp.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include <stddef.h>
#include <signal.h>

void
sigsegv_reset_onstack_flag (void)
{
  stack_t ss;

  if (sigaltstack (NULL, &ss) >= 0)
    {
      ss.ss_flags &= ~SS_ONSTACK;
      sigaltstack (&ss, NULL);
    }
}
