/**
 * This file has no copyright assigned and is placed in the Public Domain.
 * This file is part of the mingw-w64 runtime package.
 * No warranty is given; refer to the file DISCLAIMER.PD within this package.
 */
#ifndef _INC_VSS
#define _INC_VSS

#ifndef __IVssAdmin_FWD_DEFINED__
#define __IVssAdmin_FWD_DEFINED__
typedef struct IVssAdmin IVssAdmin;
#endif /* __IVssAdmin_FWD_DEFINED__ */

#ifndef __IVssBackupComponents_FWD_DEFINED__
#define __IVssBackupComponents_FWD_DEFINED__
typedef struct IVssBackupComponents IVssBackupComponents;
#endif /* __IVssBackupComponents_FWD_DEFINED__ */

#ifndef __IVssBackupComponentsEx_FWD_DEFINED__
#define __IVssBackupComponentsEx_FWD_DEFINED__
typedef struct IVssBackupComponentsEx IVssBackupComponentsEx;
#endif /* __IVssBackupComponentsEx_FWD_DEFINED__ */

#ifndef __IVssBackupComponentsEx2_FWD_DEFINED__
#define __IVssBackupComponentsEx2_FWD_DEFINED__
typedef struct IVssBackupComponentsEx2 IVssBackupComponentsEx2;
#endif /* __IVssBackupComponentsEx2_FWD_DEFINED__ */

#ifndef __IVssBackupComponentsEx3_FWD_DEFINED__
#define __IVssBackupComponentsEx3_FWD_DEFINED__
typedef struct IVssBackupComponentsEx3 IVssBackupComponentsEx3;
#endif /* __IVssBackupComponentsEx3_FWD_DEFINED__ */

#ifndef __IVssExamineWriterMetadata_FWD_DEFINED__
#define __IVssExamineWriterMetadata_FWD_DEFINED__
typedef struct IVssExamineWriterMetadata IVssExamineWriterMetadata;
#endif /* __IVssExamineWriterMetadata_FWD_DEFINED__ */

#ifndef __IVssExamineWriterMetadataEx_FWD_DEFINED__
#define __IVssExamineWriterMetadataEx_FWD_DEFINED__
typedef struct IVssExamineWriterMetadataEx IVssExamineWriterMetadataEx;
#endif /* __IVssExamineWriterMetadataEx_FWD_DEFINED__ */

#ifndef __IVssExamineWriterMetadataEx2_FWD_DEFINED__
#define __IVssExamineWriterMetadataEx2_FWD_DEFINED__
typedef struct IVssExamineWriterMetadataEx2 IVssExamineWriterMetadataEx2;
#endif /* __IVssExamineWriterMetadataEx2_FWD_DEFINED__ */

#ifndef __IVssWMComponent_FWD_DEFINED__
#define __IVssWMComponent_FWD_DEFINED__
typedef struct IVssWMComponent IVssWMComponent;
#endif /* __IVssWMComponent_FWD_DEFINED__ */

#ifndef __IVssWriterComponentsExt_FWD_DEFINED__
#define __IVssWriterComponentsExt_FWD_DEFINED__
typedef struct IVssWriterComponentsExt IVssWriterComponentsExt;
#endif /* __IVssWriterComponentsExt_FWD_DEFINED__ */

#ifndef __IVssDifferentialSoftwareSnapshotMgmt_FWD_DEFINED__
#define __IVssDifferentialSoftwareSnapshotMgmt_FWD_DEFINED__
typedef struct IVssDifferentialSoftwareSnapshotMgmt IVssDifferentialSoftwareSnapshotMgmt;
#endif /* __IVssDifferentialSoftwareSnapshotMgmt_FWD_DEFINED__ */

#ifndef __IVssDifferentialSoftwareSnapshotMgmt2_FWD_DEFINED__
#define __IVssDifferentialSoftwareSnapshotMgmt2_FWD_DEFINED__
typedef struct IVssDifferentialSoftwareSnapshotMgmt2 IVssDifferentialSoftwareSnapshotMgmt2;
#endif /* __IVssDifferentialSoftwareSnapshotMgmt2_FWD_DEFINED__ */

#ifndef __IVssDifferentialSoftwareSnapshotMgmt3_FWD_DEFINED__
#define __IVssDifferentialSoftwareSnapshotMgmt3_FWD_DEFINED__
typedef struct IVssDifferentialSoftwareSnapshotMgmt3 IVssDifferentialSoftwareSnapshotMgmt3;
#endif /* __IVssDifferentialSoftwareSnapshotMgmt3_FWD_DEFINED__ */

#ifndef __IVssEnumMgmtObject_FWD_DEFINED__
#define __IVssEnumMgmtObject_FWD_DEFINED__
typedef struct IVssEnumMgmtObject IVssEnumMgmtObject;
#endif /* __IVssEnumMgmtObject_FWD_DEFINED__ */

#ifndef __IVssSnapshotMgmt_FWD_DEFINED__
#define __IVssSnapshotMgmt_FWD_DEFINED__
typedef struct IVssSnapshotMgmt IVssSnapshotMgmt;
#endif /* __IVssSnapshotMgmt_FWD_DEFINED__ */

#ifndef __IVssSnapshotMgmt2_FWD_DEFINED__
#define __IVssSnapshotMgmt2_FWD_DEFINED__
typedef struct IVssSnapshotMgmt2 IVssSnapshotMgmt2;
#endif /* __IVssSnapshotMgmt2_FWD_DEFINED__ */

#ifndef __IVssHardwareSnapshotProvider_FWD_DEFINED__
#define __IVssHardwareSnapshotProvider_FWD_DEFINED__
typedef struct IVssHardwareSnapshotProvider IVssHardwareSnapshotProvider;
#endif /* __IVssHardwareSnapshotProvider_FWD_DEFINED__ */

#ifndef __IVssHardwareSnapshotProviderEx_FWD_DEFINED__
#define __IVssHardwareSnapshotProviderEx_FWD_DEFINED__
typedef struct IVssHardwareSnapshotProviderEx IVssHardwareSnapshotProviderEx;
#endif /* __IVssHardwareSnapshotProviderEx_FWD_DEFINED__ */

#ifndef __IVssProviderCreateSnapshotSet_FWD_DEFINED__
#define __IVssProviderCreateSnapshotSet_FWD_DEFINED__
typedef struct IVssProviderCreateSnapshotSet IVssProviderCreateSnapshotSet;
#endif /* __IVssProviderCreateSnapshotSet_FWD_DEFINED__ */

#ifndef __IVssProviderNotifications_FWD_DEFINED__
#define __IVssProviderNotifications_FWD_DEFINED__
typedef struct IVssProviderNotifications IVssProviderNotifications;
#endif /* __IVssProviderNotifications_FWD_DEFINED__ */

#ifndef __IVssSoftwareSnapshotProvider_FWD_DEFINED__
#define __IVssSoftwareSnapshotProvider_FWD_DEFINED__
typedef struct IVssSoftwareSnapshotProvider IVssSoftwareSnapshotProvider;
#endif /* __IVssSoftwareSnapshotProvider_FWD_DEFINED__ */

#ifndef __IVssAsync_FWD_DEFINED__
#define __IVssAsync_FWD_DEFINED__
typedef struct IVssAsync IVssAsync;
#endif /* __IVssAsync_FWD_DEFINED__ */

#ifndef __IVssEnumObject_FWD_DEFINED__
#define __IVssEnumObject_FWD_DEFINED__
typedef struct IVssEnumObject IVssEnumObject;
#endif /* __IVssEnumObject_FWD_DEFINED__ */

#ifndef __IVssCreateExpressWriterMetadata_FWD_DEFINED__
#define __IVssCreateExpressWriterMetadata_FWD_DEFINED__
typedef struct IVssCreateExpressWriterMetadata IVssCreateExpressWriterMetadata;
#endif /* __IVssCreateExpressWriterMetadata_FWD_DEFINED__ */

#ifndef __IVssCreateWriterMetadata_FWD_DEFINED__
#define __IVssCreateWriterMetadata_FWD_DEFINED__
typedef struct IVssCreateWriterMetadata IVssCreateWriterMetadata;
#endif /* __IVssCreateWriterMetadata_FWD_DEFINED__ */

#ifndef __IVssCreateWriterMetadataEx_FWD_DEFINED__
#define __IVssCreateWriterMetadataEx_FWD_DEFINED__
typedef struct IVssCreateWriterMetadataEx IVssCreateWriterMetadataEx;
#endif /* __IVssCreateWriterMetadataEx_FWD_DEFINED__ */

#ifndef __IVssExpressWriter_FWD_DEFINED__
#define __IVssExpressWriter_FWD_DEFINED__
typedef struct IVssExpressWriter IVssExpressWriter;
#endif /* __IVssExpressWriter_FWD_DEFINED__ */

#ifndef __IVssWriterComponents_FWD_DEFINED__
#define __IVssWriterComponents_FWD_DEFINED__
typedef struct IVssWriterComponents IVssWriterComponents;
#endif /* __IVssWriterComponents_FWD_DEFINED__ */

#ifndef __IVssComponent_FWD_DEFINED__
#define __IVssComponent_FWD_DEFINED__
typedef struct IVssComponent IVssComponent;
#endif /* __IVssComponent_FWD_DEFINED__ */

#ifndef __IVssComponentEx_FWD_DEFINED__
#define __IVssComponentEx_FWD_DEFINED__
typedef struct IVssComponentEx IVssComponentEx;
#endif /* __IVssComponentEx_FWD_DEFINED__ */

#ifndef __IVssComponentEx2_FWD_DEFINED__
#define __IVssComponentEx2_FWD_DEFINED__
typedef struct IVssComponentEx2 IVssComponentEx2;
#endif /* __IVssComponentEx2_FWD_DEFINED__ */

#ifndef __IVssWMDependency_FWD_DEFINED__
#define __IVssWMDependency_FWD_DEFINED__
typedef struct IVssWMDependency IVssWMDependency;
#endif /* __IVssWMDependency_FWD_DEFINED__ */

#ifndef __IVssWMFiledesc_FWD_DEFINED__
#define __IVssWMFiledesc_FWD_DEFINED__
typedef struct IVssWMFiledesc IVssWMFiledesc;
#endif /* __IVssWMFiledesc_FWD_DEFINED__ */

/* http://msdn.microsoft.com/en-us/library/aa384641%28VS.85%29.aspx */
typedef WCHAR *VSS_PWSZ;
typedef LONGLONG VSS_TIMESTAMP;
typedef GUID VSS_ID;

#ifndef __cplusplus
typedef char bool;
#endif

typedef enum _VSS_APPLICATION_LEVEL {
  VSS_APP_UNKNOWN     = 0,
  VSS_APP_SYSTEM      = 1,
  VSS_APP_BACK_END    = 2,
  VSS_APP_FRONT_END   = 3,
  VSS_APP_AUTO        = -1 
} VSS_APPLICATION_LEVEL, *PVSS_APPLICATION_LEVEL;

typedef enum _VSS_BACKUP_TYPE {
  VSS_BT_UNDEFINED      = 0,
  VSS_BT_FULL           = 1,
  VSS_BT_INCREMENTAL    = 2,
  VSS_BT_DIFFERENTIAL   = 3,
  VSS_BT_LOG            = 4,
  VSS_BT_COPY           = 5,
  VSS_BT_OTHER          = 6 
} VSS_BACKUP_TYPE, *PVSS_BACKUP_TYPE;

/* Reserved for future use */
/*typedef enum _VSS_FASTRECOVERY_OPTIONS;*/

typedef enum _VSS_PROVIDER_TYPE {
  VSS_PROV_UNKNOWN    = 0,
  VSS_PROV_SYSTEM     = 1,
  VSS_PROV_SOFTWARE   = 2,
  VSS_PROV_HARDWARE   = 3 
} VSS_PROVIDER_TYPE, *PVSS_PROVIDER_TYPE;

typedef enum _VSS_SNAPSHOT_COMPATIBILITY {
  VSS_SC_DISABLE_DEFRAG         = 0x1,
  VSS_SC_DISABLE_CONTENTINDEX   = 0x2 
} VSS_SNAPSHOT_COMPATIBILITY;

typedef enum _VSS_SNAPSHOT_STATE {
  VSS_SS_UNKNOWN                      = 0x00,
  VSS_SS_PREPARING                    = 0x01,
  VSS_SS_PROCESSING_PREPARE           = 0x02,
  VSS_SS_PREPARED                     = 0x03,
  VSS_SS_PROCESSING_PRECOMMIT         = 0x04,
  VSS_SS_PRECOMMITTED                 = 0x05,
  VSS_SS_PROCESSING_COMMIT            = 0x06,
  VSS_SS_COMMITTED                    = 0x07,
  VSS_SS_PROCESSING_POSTCOMMIT        = 0x08,
  VSS_SS_PROCESSING_PREFINALCOMMIT    = 0x09,
  VSS_SS_PREFINALCOMMITTED            = 0x0a,
  VSS_SS_PROCESSING_POSTFINALCOMMIT   = 0x0b,
  VSS_SS_CREATED                      = 0x0c,
  VSS_SS_ABORTED                      = 0x0d,
  VSS_SS_DELETED                      = 0x0e,
  VSS_SS_POSTCOMMITTED                = 0x0f,
  VSS_SS_COUNT                        = 0x10 
} VSS_SNAPSHOT_STATE, *PVSS_SNAPSHOT_STATE;

typedef enum _VSS_VOLUME_SNAPSHOT_ATTRIBUTES {
  VSS_VOLSNAP_ATTR_PERSISTENT             = 0x00000001,
  VSS_VOLSNAP_ATTR_NO_AUTORECOVERY        = 0x00000002,
  VSS_VOLSNAP_ATTR_CLIENT_ACCESSIBLE      = 0x00000004,
  VSS_VOLSNAP_ATTR_NO_AUTO_RELEASE        = 0x00000008,
  VSS_VOLSNAP_ATTR_NO_WRITERS             = 0x00000010,
  VSS_VOLSNAP_ATTR_TRANSPORTABLE          = 0x00000020,
  VSS_VOLSNAP_ATTR_NOT_SURFACED           = 0x00000040,
  VSS_VOLSNAP_ATTR_NOT_TRANSACTED         = 0x00000080,
  VSS_VOLSNAP_ATTR_HARDWARE_ASSISTED      = 0x00010000,
  VSS_VOLSNAP_ATTR_DIFFERENTIAL           = 0x00020000,
  VSS_VOLSNAP_ATTR_PLEX                   = 0x00040000,
  VSS_VOLSNAP_ATTR_IMPORTED               = 0x00080000,
  VSS_VOLSNAP_ATTR_EXPOSED_LOCALLY        = 0x00100000,
  VSS_VOLSNAP_ATTR_EXPOSED_REMOTELY       = 0x00200000,
  VSS_VOLSNAP_ATTR_AUTORECOVER            = 0x00400000,
  VSS_VOLSNAP_ATTR_ROLLBACK_RECOVERY      = 0x00800000,
  VSS_VOLSNAP_ATTR_DELAYED_POSTSNAPSHOT   = 0x01000000,
  VSS_VOLSNAP_ATTR_TXF_RECOVERY           = 0x02000000 
} VSS_VOLUME_SNAPSHOT_ATTRIBUTES, *PVSS_VOLUME_SNAPSHOT_ATTRIBUTES;

typedef enum _VSS_SNAPSHOT_CONTEXT {
  VSS_CTX_BACKUP                      = 0,
  VSS_CTX_FILE_SHARE_BACKUP           = VSS_VOLSNAP_ATTR_NO_WRITERS,
  VSS_CTX_NAS_ROLLBACK                = ( ( VSS_VOLSNAP_ATTR_PERSISTENT | VSS_VOLSNAP_ATTR_NO_AUTO_RELEASE ) | VSS_VOLSNAP_ATTR_NO_WRITERS ),
  VSS_CTX_APP_ROLLBACK                = ( VSS_VOLSNAP_ATTR_PERSISTENT | VSS_VOLSNAP_ATTR_NO_AUTO_RELEASE ),
  VSS_CTX_CLIENT_ACCESSIBLE           = ( ( ( VSS_VOLSNAP_ATTR_PERSISTENT | VSS_VOLSNAP_ATTR_CLIENT_ACCESSIBLE ) | VSS_VOLSNAP_ATTR_NO_AUTO_RELEASE ) | VSS_VOLSNAP_ATTR_NO_WRITERS ),
  VSS_CTX_CLIENT_ACCESSIBLE_WRITERS   = ( ( VSS_VOLSNAP_ATTR_PERSISTENT | VSS_VOLSNAP_ATTR_CLIENT_ACCESSIBLE ) | VSS_VOLSNAP_ATTR_NO_AUTO_RELEASE ),
  VSS_CTX_ALL                         = 0xffffffff
} VSS_SNAPSHOT_CONTEXT, *PVSS_SNAPSHOT_CONTEXT;

typedef enum _VSS_WRITER_STATE {
  VSS_WS_UNKNOWN                       = 0,
  VSS_WS_STABLE                        = 1,
  VSS_WS_WAITING_FOR_FREEZE            = 2,
  VSS_WS_WAITING_FOR_THAW              = 3,
  VSS_WS_WAITING_FOR_POST_SNAPSHOT     = 4,
  VSS_WS_WAITING_FOR_BACKUP_COMPLETE   = 5,
  VSS_WS_FAILED_AT_IDENTIFY            = 6,
  VSS_WS_FAILED_AT_PREPARE_BACKUP      = 7,
  VSS_WS_FAILED_AT_PREPARE_SNAPSHOT    = 8,
  VSS_WS_FAILED_AT_FREEZE              = 9,
  VSS_WS_FAILED_AT_THAW                = 10,
  VSS_WS_FAILED_AT_POST_SNAPSHOT       = 11,
  VSS_WS_FAILED_AT_BACKUP_COMPLETE     = 12,
  VSS_WS_FAILED_AT_PRE_RESTORE         = 13,
  VSS_WS_FAILED_AT_POST_RESTORE        = 14,
  VSS_WS_FAILED_AT_BACKUPSHUTDOWN      = 15,
  VSS_WS_COUNT                         = 16 
} VSS_WRITER_STATE, *PVSS_WRITER_STATE;

typedef enum _VSS_SNAPSHOT_PROPERTY_ID {
  VSS_SPROPID_UNKNOWN               = 0x00000000,
  VSS_SPROPID_SNAPSHOT_ID           = 0x00000001,
  VSS_SPROPID_SNAPSHOT_SET_ID       = 0x00000002,
  VSS_SPROPID_SNAPSHOTS_COUNT       = 0x00000003,
  VSS_SPROPID_SNAPSHOT_DEVICE       = 0x00000004,
  VSS_SPROPID_ORIGINAL_VOLUME       = 0x00000005,
  VSS_SPROPID_ORIGINATING_MACHINE   = 0x00000006,
  VSS_SPROPID_SERVICE_MACHINE       = 0x00000007,
  VSS_SPROPID_EXPOSED_NAME          = 0x00000008,
  VSS_SPROPID_EXPOSED_PATH          = 0x00000009,
  VSS_SPROPID_PROVIDER_ID           = 0x0000000A,
  VSS_SPROPID_SNAPSHOT_ATTRIBUTES   = 0x0000000B,
  VSS_SPROPID_CREATION_TIMESTAMP    = 0x0000000C,
  VSS_SPROPID_STATUS                = 0x0000000D 
} VSS_SNAPSHOT_PROPERTY_ID, *PVSS_SNAPSHOT_PROPERTY_ID;

typedef enum _VSS_OBJECT_TYPE {
  VSS_OBJECT_UNKNOWN        = 0,
  VSS_OBJECT_NONE           = 1,
  VSS_OBJECT_SNAPSHOT_SET   = 2,
  VSS_OBJECT_SNAPSHOT       = 3,
  VSS_OBJECT_PROVIDER       = 4,
  VSS_OBJECT_TYPE_COUNT     = 5 
} VSS_OBJECT_TYPE, *PVSS_OBJECT_TYPE;

#if (_WIN32_WINNT >= 0x0600)

typedef enum VSS_BACKUP_SCHEMA {
  VSS_BS_UNDEFINED                            = 0x00000000,
  VSS_BS_DIFFERENTIAL                         = 0x00000001,
  VSS_BS_INCREMENTAL                          = 0x00000002,
  VSS_BS_EXCLUSIVE_INCREMENTAL_DIFFERENTIAL   = 0x00000004,
  VSS_BS_LOG                                  = 0x00000008,
  VSS_BS_COPY                                 = 0x00000010,
  VSS_BS_TIMESTAMPED                          = 0x00000020,
  VSS_BS_LAST_MODIFY                          = 0x00000040,
  VSS_BS_LSN                                  = 0x00000080,
  VSS_BS_WRITER_SUPPORTS_NEW_TARGET           = 0x00000100,
  VSS_BS_WRITER_SUPPORTS_RESTORE_WITH_MOVE    = 0x00000200,
  VSS_BS_INDEPENDENT_SYSTEM_STATE             = 0x00000400,
  VSS_BS_ROLLFORWARD_RESTORE                  = 0x00001000,
  VSS_BS_RESTORE_RENAME                       = 0x00002000,
  VSS_BS_AUTHORITATIVE_RESTORE                = 0x00004000,
  VSS_BS_WRITER_SUPPORTS_PARALLEL_RESTORES    = 0x00008000 
} VSS_BACKUP_SCHEMA, *PVSS_BACKUP_SCHEMA;

typedef enum _VSS_FILE_SPEC_BACKUP_TYPE {
  VSS_FSBT_FULL_BACKUP_REQUIRED             = 0x00000001,
  VSS_FSBT_DIFFERENTIAL_BACKUP_REQUIRED     = 0x00000002,
  VSS_FSBT_INCREMENTAL_BACKUP_REQUIRED      = 0x00000004,
  VSS_FSBT_LOG_BACKUP_REQUIRED              = 0x00000008,
  VSS_FSBT_FULL_SNAPSHOT_REQUIRED           = 0x00000100,
  VSS_FSBT_DIFFERENTIAL_SNAPSHOT_REQUIRED   = 0x00000200,
  VSS_FSBT_INCREMENTAL_SNAPSHOT_REQUIRED    = 0x00000400,
  VSS_FSBT_LOG_SNAPSHOT_REQUIRED            = 0x00000800,
  VSS_FSBT_ALL_BACKUP_REQUIRED              = 0x0000000F,
  VSS_FSBT_ALL_SNAPSHOT_REQUIRED            = 0x00000F00 
} VSS_FILE_SPEC_BACKUP_TYPE, *PVSS_FILE_SPEC_BACKUP_TYPE;

typedef enum _VSS_HARDWARE_OPTIONS {
  VSS_BREAKEX_FLAG_MASK_LUNS                      = 0x00000001,
  VSS_BREAKEX_FLAG_MAKE_READ_WRITE                = 0x00000002,
  VSS_BREAKEX_FLAG_REVERT_IDENTITY_ALL            = 0x00000004,
  VSS_BREAKEX_FLAG_REVERT_IDENTITY_NONE           = 0x00000008,
  VSS_ONLUNSTATECHANGE_NOTIFY_READ_WRITE          = 0x00000100,
  VSS_ONLUNSTATECHANGE_NOTIFY_LUN_PRE_RECOVERY    = 0x00000200,
  VSS_ONLUNSTATECHANGE_NOTIFY_LUN_POST_RECOVERY   = 0x00000400,
  VSS_ONLUNSTATECHANGE_DO_MASK_LUNS               = 0x00000800 
} VSS_HARDWARE_OPTIONS, *PVSS_HARDWARE_OPTIONS;

typedef enum _VSS_RESTORE_TYPE {
  VSS_RTYPE_UNDEFINED   = 0,
  VSS_RTYPE_BY_COPY     = 1,
  VSS_RTYPE_IMPORT      = 2,
  VSS_RTYPE_OTHER       = 3 
} VSS_RESTORE_TYPE, *PVSS_RESTORE_TYPE;

typedef enum _VSS_ROLLFORWARD_TYPE {
  VSS_RF_UNDEFINED   = 0,
  VSS_RF_NONE        = 1,
  VSS_RF_ALL         = 2,
  VSS_RF_PARTIAL     = 3 
} VSS_ROLLFORWARD_TYPE, *PVSS_ROLLFORWARD_TYPE;

#endif /*(_WIN32_WINNT >= 0x0600)*/

#if (_WIN32_WINNT >= 0x0601)
typedef enum _VSS_RECOVERY_OPTIONS {
  VSS_RECOVERY_REVERT_IDENTITY_ALL   = 0x00000100,
  VSS_RECOVERY_NO_VOLUME_CHECK       = 0x00000200 
} VSS_RECOVERY_OPTIONS;
#endif /*(_WIN32_WINNT >= 0x0601)*/

typedef struct _VSS_SNAPSHOT_PROP {
  VSS_ID             m_SnapshotId;
  VSS_ID             m_SnapshotSetId;
  LONG               m_lSnapshotsCount;
  VSS_PWSZ           m_pwszSnapshotDeviceObject;
  VSS_PWSZ           m_pwszOriginalVolumeName;
  VSS_PWSZ           m_pwszOriginatingMachine;
  VSS_PWSZ           m_pwszServiceMachine;
  VSS_PWSZ           m_pwszExposedName;
  VSS_PWSZ           m_pwszExposedPath;
  VSS_ID             m_ProviderId;
  LONG               m_lSnapshotAttributes;
  VSS_TIMESTAMP      m_tsCreationTimestamp;
  VSS_SNAPSHOT_STATE m_eStatus;
} VSS_SNAPSHOT_PROP, *PVSS_SNAPSHOT_PROP;

typedef struct _VSS_PROVIDER_PROP {
  VSS_ID            m_ProviderId;
  VSS_PWSZ          m_pwszProviderName;
  VSS_PROVIDER_TYPE m_eProviderType;
  VSS_PWSZ          m_pwszProviderVersion;
  VSS_ID            m_ProviderVersionId;
  CLSID             m_ClassId;
} VSS_PROVIDER_PROP, *PVSS_PROVIDER_PROP;

typedef union _VSS_OBJECT_UNION {
  /*[case(VSS_OBJECT_SNAPSHOT)]*/
    VSS_SNAPSHOT_PROP Snap;
  /*[case(VSS_OBJECT_PROVIDER)]*/
    VSS_PROVIDER_PROP Prov;
} VSS_OBJECT_UNION;

typedef struct _VSS_OBJECT_PROP {
  VSS_OBJECT_TYPE  Type;
  VSS_OBJECT_UNION Obj;
} VSS_OBJECT_PROP, *PVSS_OBJECT_PROP;

#undef  INTERFACE
#define INTERFACE IVssAsync
/* IID_IVssAsync is defined as 507C37B4-CF5B-4e95-B0AF-14EB9767467E */
#ifdef __GNUC__
#warning COM interfaces layout in this header has not been verified.
#warning COM interfaces with incorrect layout may not work at all.
__MINGW_BROKEN_INTERFACE(INTERFACE)
#endif
DECLARE_INTERFACE_(IVssAsync,IUnknown)
{
    BEGIN_INTERFACE

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, void **ppvObject) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IVssAsync methods */
    STDMETHOD_(HRESULT,Cancel)(THIS) PURE;
    STDMETHOD_(HRESULT,Wait)(THIS_ DWORD dwMilliseconds) PURE;
    STDMETHOD_(HRESULT,QueryStatus)(THIS_ HRESULT *pHrResult,INT *pReserved) PURE;

    END_INTERFACE
};
#ifdef COBJMACROS
#define IVssAsync_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IVssAsync_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IVssAsync_Release(This) (This)->lpVtbl->Release(This)
#define IVssAsync_Cancel() (This)->lpVtbl->Cancel(This)
#define IVssAsync_Wait(This,dwMilliseconds) (This)->lpVtbl->Wait(This,dwMilliseconds)
#define IVssAsync_QueryStatus(This,pHrResult,pReserved) (This)->lpVtbl->QueryStatus(This,pHrResult,pReserved)
#endif /*COBJMACROS*/

#undef  INTERFACE
#define INTERFACE IVssEnumObject
/* IID_IVssEnumObject is defined as AE1C7110-2F60-11d3-8A39-00C04F72D8E3 */
#ifdef __GNUC__
#warning COM interfaces layout in this header has not been verified.
#warning COM interfaces with incorrect layout may not work at all.
__MINGW_BROKEN_INTERFACE(INTERFACE)
#endif
DECLARE_INTERFACE_(IVssEnumObject,IUnknown)
{
    BEGIN_INTERFACE

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, void **ppvObject) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IVssEnumObject methods */
    STDMETHOD_(HRESULT,Next)(THIS_ ULONG celt,VSS_OBJECT_PROP *rgelt,ULONG *pceltFetched) PURE;
    STDMETHOD_(HRESULT,Skip)(THIS_ ULONG celt) PURE;
    STDMETHOD_(HRESULT,Reset)(THIS) PURE;
    STDMETHOD_(HRESULT,Clone)(THIS_ IVssEnumObject **ppEnum) PURE;

    END_INTERFACE
};
#ifdef COBJMACROS
#define IVssEnumObject_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IVssEnumObject_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IVssEnumObject_Release(This) (This)->lpVtbl->Release(This)
#define IVssEnumObject_Next(This,celt,rgelt,pceltFetched) (This)->lpVtbl->Next(This,celt,rgelt,pceltFetched)
#define IVssEnumObject_Skip(This,celt) (This)->lpVtbl->Skip(This,celt)
#define IVssEnumObject_Reset() (This)->lpVtbl->Reset(This)
#define IVssEnumObject_Clone(This,ppEnum) (This)->lpVtbl->Clone(This,ppEnum)
#endif /*COBJMACROS*/

#include <vswriter.h>
#include <vsbackup.h>

#endif /*_INC_VSS*/
