/*	$NetBSD: imx7_rdcreg.h,v 1.1 2016/10/17 09:21:51 ryo Exp $	*/

/*
 * Copyright (c) 2016 Ryo Shimizu <ryo@nerv.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ARM_IMX_IMX7_RDCREG_H_
#define _ARM_IMX_IMX7_RDCREG_H_

#include <sys/cdefs.h>

/*
 * Resource Domain Controller Module (AIPS1_RDC_BASE:0x303d0000)
 */
#define RDC_VIR					0x00000000
#define RDC_STAT				0x00000024
#define RDC_INTCTRL				0x00000028
#define RDC_INTSTAT				0x0000002c

/* Master Domain Assignment */
#define RDC_MDA0				0x00000200
#define RDC_MDA1				0x00000204
#define RDC_MDA2				0x00000208
#define RDC_MDA3				0x0000020c
#define RDC_MDA4				0x00000210
#define RDC_MDA5				0x00000214
#define RDC_MDA6				0x00000218
#define RDC_MDA7				0x0000021c
#define RDC_MDA8				0x00000220
#define RDC_MDA9				0x00000224
#define RDC_MDA10				0x00000228
#define RDC_MDA11				0x0000022c
#define RDC_MDA12				0x00000230
#define RDC_MDA13				0x00000234
#define RDC_MDA14				0x00000238
#define RDC_MDA15				0x0000023c
#define RDC_MDA16				0x00000240
#define RDC_MDA17				0x00000244
#define RDC_MDA18				0x00000248
#define RDC_MDA19				0x0000024c
#define RDC_MDA20				0x00000250
#define RDC_MDA21				0x00000254
#define RDC_MDA22				0x00000258
#define RDC_MDA23				0x0000025c
#define RDC_MDA24				0x00000260
#define RDC_MDA25				0x00000264
#define RDC_MDA26				0x00000268

#define RDC_MDA_A7_CORE_0			RDC_MDA0
#define RDC_MDA_A7_CORE_1			RDC_MDA0
#define RDC_MDA_M4_CORE				RDC_MDA1
#define RDC_MDA_PCIE_CTRL			RDC_MDA2
#define RDC_MDA_SCI				RDC_MDA3
#define RDC_MDA_EPDC				RDC_MDA4
#define RDC_MDA_LCDIF				RDC_MDA5
#define RDC_MDA_DISPLAY_PORT			RDC_MDA6
#define RDC_MDA_PXP				RDC_MDA7
#define RDC_MDA_CORESIGHT			RDC_MDA8
#define RDC_MDA_DAP				RDC_MDA9
#define RDC_MDA_CAAM				RDC_MDA10
#define RDC_MDA_SDMA_PERIPHERAL_DMA_PORT	RDC_MDA11
#define RDC_MDA_SDMA_BURST_DMA_PORT		RDC_MDA12
#define RDC_MDA_APBHDMA				RDC_MDA13
#define RDC_MDA_RAWNAND				RDC_MDA14
#define RDC_MDA_USDHC1				RDC_MDA15
#define RDC_MDA_USDHC2				RDC_MDA16
#define RDC_MDA_USDHC3				RDC_MDA17
#define RDC_MDA_NC18				RDC_MDA18
#define RDC_MDA_USB				RDC_MDA19
#define RDC_MDA_NC20				RDC_MDA20
#define RDC_MDA_TESTPORT			RDC_MDA21
#define RDC_MDA_ENET1_TX			RDC_MDA22
#define RDC_MDA_ENET1_RX			RDC_MDA23
#define RDC_MDA_ENET2_TX			RDC_MDA24
#define RDC_MDA_ENET2_RX			RDC_MDA25
#define RDC_MDA_SDMA_PORT			RDC_MDA26

/* RDC Peripheral Mapping */
#define RDC_PDAP0				0x00000400
#define RDC_PDAP1				0x00000404
#define RDC_PDAP2				0x00000408
#define RDC_PDAP3				0x0000040c
#define RDC_PDAP4				0x00000410
#define RDC_PDAP5				0x00000414
#define RDC_PDAP6				0x00000418
#define RDC_PDAP7				0x0000041c
#define RDC_PDAP8				0x00000420
#define RDC_PDAP9				0x00000424
#define RDC_PDAP10				0x00000428
#define RDC_PDAP11				0x0000042c
#define RDC_PDAP12				0x00000430
#define RDC_PDAP13				0x00000434
#define RDC_PDAP14				0x00000438
#define RDC_PDAP15				0x0000043c
#define RDC_PDAP16				0x00000440
#define RDC_PDAP17				0x00000444
#define RDC_PDAP18				0x00000448
#define RDC_PDAP19				0x0000044c
#define RDC_PDAP20				0x00000450
#define RDC_PDAP21				0x00000454
#define RDC_PDAP22				0x00000458
#define RDC_PDAP23				0x0000045c
#define RDC_PDAP24				0x00000460
#define RDC_PDAP25				0x00000464
#define RDC_PDAP26				0x00000468
#define RDC_PDAP27				0x0000046c
#define RDC_PDAP28				0x00000470
#define RDC_PDAP29				0x00000474
#define RDC_PDAP30				0x00000478
#define RDC_PDAP31				0x0000047c
#define RDC_PDAP32				0x00000480
#define RDC_PDAP33				0x00000484
#define RDC_PDAP34				0x00000488
#define RDC_PDAP35				0x0000048c
#define RDC_PDAP36				0x00000490
#define RDC_PDAP37				0x00000494
#define RDC_PDAP38				0x00000498
#define RDC_PDAP39				0x0000049c
#define RDC_PDAP40				0x000004a0
#define RDC_PDAP41				0x000004a4
#define RDC_PDAP42				0x000004a8
#define RDC_PDAP43				0x000004ac
#define RDC_PDAP44				0x000004b0
#define RDC_PDAP45				0x000004b4
#define RDC_PDAP46				0x000004b8
#define RDC_PDAP47				0x000004bc
#define RDC_PDAP48				0x000004c0
#define RDC_PDAP49				0x000004c4
#define RDC_PDAP50				0x000004c8
#define RDC_PDAP51				0x000004cc
#define RDC_PDAP52				0x000004d0
#define RDC_PDAP53				0x000004d4
#define RDC_PDAP54				0x000004d8
#define RDC_PDAP55				0x000004dc
#define RDC_PDAP56				0x000004e0
#define RDC_PDAP57				0x000004e4
#define RDC_PDAP58				0x000004e8
#define RDC_PDAP59				0x000004ec
#define RDC_PDAP60				0x000004f0
#define RDC_PDAP61				0x000004f4
#define RDC_PDAP62				0x000004f8
#define RDC_PDAP63				0x000004fc
#define RDC_PDAP64				0x00000500
#define RDC_PDAP65				0x00000504
#define RDC_PDAP66				0x00000508
#define RDC_PDAP67				0x0000050c
#define RDC_PDAP68				0x00000510
#define RDC_PDAP69				0x00000514
#define RDC_PDAP70				0x00000518
#define RDC_PDAP71				0x0000051c
#define RDC_PDAP72				0x00000520
#define RDC_PDAP73				0x00000524
#define RDC_PDAP74				0x00000528
#define RDC_PDAP75				0x0000052c
#define RDC_PDAP76				0x00000530
#define RDC_PDAP77				0x00000534
#define RDC_PDAP78				0x00000538
#define RDC_PDAP79				0x0000053c
#define RDC_PDAP80				0x00000540
#define RDC_PDAP81				0x00000544
#define RDC_PDAP82				0x00000548
#define RDC_PDAP83				0x0000054c
#define RDC_PDAP84				0x00000550
#define RDC_PDAP85				0x00000554
#define RDC_PDAP86				0x00000558
#define RDC_PDAP87				0x0000055c
#define RDC_PDAP88				0x00000560
#define RDC_PDAP89				0x00000564
#define RDC_PDAP90				0x00000568
#define RDC_PDAP91				0x0000056c
#define RDC_PDAP92				0x00000570
#define RDC_PDAP93				0x00000574
#define RDC_PDAP94				0x00000578
#define RDC_PDAP95				0x0000057c
#define RDC_PDAP96				0x00000580
#define RDC_PDAP97				0x00000584
#define RDC_PDAP98				0x00000588
#define RDC_PDAP99				0x0000058c
#define RDC_PDAP100				0x00000590
#define RDC_PDAP101				0x00000594
#define RDC_PDAP102				0x00000598
#define RDC_PDAP103				0x0000059c
#define RDC_PDAP104				0x000005a0
#define RDC_PDAP105				0x000005a4
#define RDC_PDAP106				0x000005a8
#define RDC_PDAP107				0x000005ac
#define RDC_PDAP108				0x000005b0
#define RDC_PDAP109				0x000005b4
#define RDC_PDAP110				0x000005b8
#define RDC_PDAP111				0x000005bc
#define RDC_PDAP112				0x000005c0
#define RDC_PDAP113				0x000005c4
#define RDC_PDAP114				0x000005c8
#define RDC_PDAP115				0x000005cc
#define RDC_PDAP116				0x000005d0
#define RDC_PDAP117				0x000005d4

#define RDC_PDAP_GPIO1				RDC_PDAP0
#define RDC_PDAP_GPIO2				RDC_PDAP1
#define RDC_PDAP_GPIO3				RDC_PDAP2
#define RDC_PDAP_GPIO4				RDC_PDAP3
#define RDC_PDAP_GPIO5				RDC_PDAP4
#define RDC_PDAP_GPIO6				RDC_PDAP5
#define RDC_PDAP_GPIO7				RDC_PDAP6
#define RDC_PDAP_IOMUXC_LPSR_GPR		RDC_PDAP7
#define RDC_PDAP_WDOG1				RDC_PDAP8
#define RDC_PDAP_WDOG2				RDC_PDAP9
#define RDC_PDAP_WDOG3				RDC_PDAP10
#define RDC_PDAP_WDOG4				RDC_PDAP11
#define RDC_PDAP_IOMUXC_LPSR			RDC_PDAP12
#define RDC_PDAP_GPT1				RDC_PDAP13
#define RDC_PDAP_GPT2				RDC_PDAP14
#define RDC_PDAP_GPT3				RDC_PDAP15
#define RDC_PDAP_GPT4				RDC_PDAP16
#define RDC_PDAP_ROMCP				RDC_PDAP17
#define RDC_PDAP_KPP				RDC_PDAP18
#define RDC_PDAP_IOMUXC				RDC_PDAP19
#define RDC_PDAP_IOMUXC_GPR			RDC_PDAP20
#define RDC_PDAP_OCOTP_CTRL			RDC_PDAP21
#define RDC_PDAP_ANATOP_DIG			RDC_PDAP22
#define RDC_PDAP_SNVS_HP			RDC_PDAP23
#define RDC_PDAP_CCM				RDC_PDAP24
#define RDC_PDAP_SRC				RDC_PDAP25
#define RDC_PDAP_GPC				RDC_PDAP26
#define RDC_PDAP_SEMAPHORE1			RDC_PDAP27
#define RDC_PDAP_SEMAPHORE2			RDC_PDAP28
#define RDC_PDAP_RDC				RDC_PDAP29
#define RDC_PDAP_CSU				RDC_PDAP30
#define RDC_PDAP_RESERVED_31			RDC_PDAP31
#define RDC_PDAP_RESERVED_32			RDC_PDAP32
#define RDC_PDAP_ADC1_WRAPPER			RDC_PDAP33
#define RDC_PDAP_ADC2_WRAPPER			RDC_PDAP34
#define RDC_PDAP_ECSPI4				RDC_PDAP35
#define RDC_PDAP_FLEX_TIMER_1			RDC_PDAP36
#define RDC_PDAP_FLEX_TIMER_2			RDC_PDAP37
#define RDC_PDAP_PWM1				RDC_PDAP38
#define RDC_PDAP_PWM2				RDC_PDAP39
#define RDC_PDAP_PWM3				RDC_PDAP40
#define RDC_PDAP_PWM4				RDC_PDAP41
#define RDC_PDAP_SYSTEM_COUNTER_READ		RDC_PDAP42
#define RDC_PDAP_SYSTEM_COUNTER_COMPARE		RDC_PDAP43
#define RDC_PDAP_SYSTEM_COUNTER_CONTROL		RDC_PDAP44
#define RDC_PDAP_PCIE_PHY			RDC_PDAP45
#define RDC_PDAP_RESERVED_46			RDC_PDAP46
#define RDC_PDAP_EPDC				RDC_PDAP47
#define RDC_PDAP_PXP				RDC_PDAP48
#define RDC_PDAP_CSI				RDC_PDAP49
#define RDC_PDAP_RESERVED_50			RDC_PDAP50
#define RDC_PDAP_LCDIF				RDC_PDAP51
#define RDC_PDAP_RESERVED_52			RDC_PDAP52
#define RDC_PDAP_MIPI_CSI			RDC_PDAP53
#define RDC_PDAP_MIPI_DSI			RDC_PDAP54
#define RDC_PDAP_RESERVED_55			RDC_PDAP55
#define RDC_PDAP_TZASC				RDC_PDAP56
#define RDC_PDAP_DDR_PHY			RDC_PDAP57
#define RDC_PDAP_DDRC				RDC_PDAP58
#define RDC_PDAP_RESERVED_59			RDC_PDAP59
#define RDC_PDAP_PERFMON1			RDC_PDAP60
#define RDC_PDAP_PERFMON2			RDC_PDAP61
#define RDC_PDAP_AXI_DEBUG_MON			RDC_PDAP62
#define RDC_PDAP_QOSC				RDC_PDAP63
#define RDC_PDAP_FLEXCAN1			RDC_PDAP64
#define RDC_PDAP_FLEXCAN2			RDC_PDAP65
#define RDC_PDAP_I2C1				RDC_PDAP66
#define RDC_PDAP_I2C2				RDC_PDAP67
#define RDC_PDAP_I2C3				RDC_PDAP68
#define RDC_PDAP_I2C4				RDC_PDAP69
#define RDC_PDAP_UART4				RDC_PDAP70
#define RDC_PDAP_UART5				RDC_PDAP71
#define RDC_PDAP_UART6				RDC_PDAP72
#define RDC_PDAP_UART7				RDC_PDAP73
#define RDC_PDAP_MU_A				RDC_PDAP74
#define RDC_PDAP_MU_B				RDC_PDAP75
#define RDC_PDAP_SEMAPHORE_HS			RDC_PDAP76
#define RDC_PDAP_USB_PL301			RDC_PDAP77
#define RDC_PDAP_RESERVED_78			RDC_PDAP78
#define RDC_PDAP_RESERVED_79			RDC_PDAP79
#define RDC_PDAP_RESERVED_80			RDC_PDAP80
#define RDC_PDAP_USB1_OTG1			RDC_PDAP81
#define RDC_PDAP_USB2_OTG2			RDC_PDAP82
#define RDC_PDAP_USB3_HOST			RDC_PDAP83
#define RDC_PDAP_USDHC1				RDC_PDAP84
#define RDC_PDAP_USDHC2				RDC_PDAP85
#define RDC_PDAP_USDHC3				RDC_PDAP86
#define RDC_PDAP_RESERVED_87			RDC_PDAP87
#define RDC_PDAP_RESERVED_88			RDC_PDAP88
#define RDC_PDAP_SIM1				RDC_PDAP89
#define RDC_PDAP_SIM2				RDC_PDAP90
#define RDC_PDAP_QSPI				RDC_PDAP91
#define RDC_PDAP_WEIM				RDC_PDAP92
#define RDC_PDAP_SDMA				RDC_PDAP93
#define RDC_PDAP_ENET1				RDC_PDAP94
#define RDC_PDAP_ENET2				RDC_PDAP95
#define RDC_PDAP_RESERVED_96_FOR_SDMA		RDC_PDAP96
#define RDC_PDAP_RESERVED_97			RDC_PDAP97
#define RDC_PDAP_ECSPI1				RDC_PDAP98
#define RDC_PDAP_ECSPI2				RDC_PDAP99
#define RDC_PDAP_ECSPI3				RDC_PDAP100
#define RDC_PDAP_RESERVED_101			RDC_PDAP101
#define RDC_PDAP_UART1				RDC_PDAP102
#define RDC_PDAP_UART2				RDC_PDAP103
#define RDC_PDAP_UART3				RDC_PDAP104
#define RDC_PDAP_RESERVED_105_FOR_SDMA		RDC_PDAP105
#define RDC_PDAP_SAI1				RDC_PDAP106
#define RDC_PDAP_SAI2				RDC_PDAP107
#define RDC_PDAP_SAI3				RDC_PDAP108
#define RDC_PDAP_RESERVED_109			RDC_PDAP109
#define RDC_PDAP_RESERVED_110_FOR_SDMA		RDC_PDAP110
#define RDC_PDAP_SPBA				RDC_PDAP111
#define RDC_PDAP_ULT1_DAP			RDC_PDAP112
#define RDC_PDAP_RESERVED_113			RDC_PDAP113
#define RDC_PDAP_RESERVED_114			RDC_PDAP114
#define RDC_PDAP_RESERVED_115			RDC_PDAP115
#define RDC_PDAP_CAAM				RDC_PDAP116
#define RDC_PDAP_RESERVED_117			RDC_PDAP117

/* RDC Memory Region Map */
#define RDC_MRSA0				0x00000800
#define RDC_MREA0				0x00000804
#define RDC_MRC0				0x00000808
#define RDC_MRVS0				0x0000080c
#define RDC_MRSA1				0x00000810
#define RDC_MREA1				0x00000814
#define RDC_MRC1				0x00000818
#define RDC_MRVS1				0x0000081c
/* skip 2..50 */
#define RDC_MRSA51				0x00000b30
#define RDC_MREA51				0x00000b34
#define RDC_MRC51				0x00000b38
#define RDC_MRVS51				0x00000b3c

#define RDC_MRSA(n)				(0x00000800 + ((n) * 0x10))
#define RDC_MREA(n)				(0x00000804 + ((n) * 0x10))
#define RDC_MRC(n)				(0x00000808 + ((n) * 0x10))
#define RDC_MRVS(n)				(0x0000080c + ((n) * 0x10))

#define RDC_MR_MMDC_START		0		/* start of MMDC(n) */
#define RDC_MR_MMDC_N			8		/* number of MMDC */
#define RDC_MR_MMDC_RESSIZE		(1024 * 4)	/* region resolution */
#define RDC_MR_QSPI_START		8		/* start of MMDC(n) */
#define RDC_MR_QSPI_N			8		/* number of MMDC */
#define RDC_MR_QSPI_RESSIZE		(1024 * 4)	/* region resolution */
#define RDC_MR_WEIM_START		16		/* start of MMDC(n) */
#define RDC_MR_WEIM_N			8		/* number of MMDC */
#define RDC_MR_WEIM_RESSIZE		(1024 * 4)	/* region resolution */
#define RDC_MR_PCIE_START		24		/* start of MMDC(n) */
#define RDC_MR_PCIE_N			8		/* number of MMDC */
#define RDC_MR_PCIE_RESSIZE		(1024 * 4)	/* region resolution */
#define RDC_MR_OCRAM_START		32		/* start of MMDC(n) */
#define RDC_MR_OCRAM_N			5		/* number of MMDC */
#define RDC_MR_OCRAM_RESSIZE		(1024 * 128)	/* region resolution */
#define RDC_MR_OCRAM_S_START		37		/* start of MMDC(n) */
#define RDC_MR_OCRAM_S_N		5		/* number of MMDC */
#define RDC_MR_OCRAM_S_RESSIZE		(1024 * 128)	/* region resolution */
#define RDC_MR_OCRAM_EPDC_START		42		/* start of MMDC(n) */
#define RDC_MR_OCRAM_EPDC_N		5		/* number of MMDC */
#define RDC_MR_OCRAM_EPDC_RESSIZE	(1024 * 128)	/* region resolution */
#define RDC_MR_OCRAM_PXP_START		47		/* start of MMDC(n) */
#define RDC_MR_OCRAM_PXP_N		5		/* number of MMDC */
#define RDC_MR_OCRAM_PXP_RESSIZE	(1024 * 128)	/* region resolution */

/*
 * RDC SEMAPHORE1 (AIPS1_SEMAPHORE1_BASE:0x303b0000)
 */
#define RDC_SEMAPHORE1_GATE0			0x00000000
#define RDC_SEMAPHORE1_GATE1			0x00000001
#define RDC_SEMAPHORE1_GATE2			0x00000002
#define RDC_SEMAPHORE1_GATE3			0x00000003
#define RDC_SEMAPHORE1_GATE4			0x00000004
#define RDC_SEMAPHORE1_GATE5			0x00000005
#define RDC_SEMAPHORE1_GATE6			0x00000006
#define RDC_SEMAPHORE1_GATE7			0x00000007
#define RDC_SEMAPHORE1_GATE8			0x00000008
#define RDC_SEMAPHORE1_GATE9			0x00000009
#define RDC_SEMAPHORE1_GATE10			0x0000000a
#define RDC_SEMAPHORE1_GATE11			0x0000000b
#define RDC_SEMAPHORE1_GATE12			0x0000000c
#define RDC_SEMAPHORE1_GATE13			0x0000000d
#define RDC_SEMAPHORE1_GATE14			0x0000000e
#define RDC_SEMAPHORE1_GATE15			0x0000000f
#define RDC_SEMAPHORE1_GATE16			0x00000010
#define RDC_SEMAPHORE1_GATE17			0x00000011
#define RDC_SEMAPHORE1_GATE18			0x00000012
#define RDC_SEMAPHORE1_GATE19			0x00000013
#define RDC_SEMAPHORE1_GATE20			0x00000014
#define RDC_SEMAPHORE1_GATE21			0x00000015
#define RDC_SEMAPHORE1_GATE22			0x00000016
#define RDC_SEMAPHORE1_GATE23			0x00000017
#define RDC_SEMAPHORE1_GATE24			0x00000018
#define RDC_SEMAPHORE1_GATE25			0x00000019
#define RDC_SEMAPHORE1_GATE26			0x0000001a
#define RDC_SEMAPHORE1_GATE27			0x0000001b
#define RDC_SEMAPHORE1_GATE28			0x0000001c
#define RDC_SEMAPHORE1_GATE29			0x0000001d
#define RDC_SEMAPHORE1_GATE30			0x0000001e
#define RDC_SEMAPHORE1_GATE31			0x0000001f
#define RDC_SEMAPHORE1_GATE32			0x00000020
#define RDC_SEMAPHORE1_GATE33			0x00000021
#define RDC_SEMAPHORE1_GATE34			0x00000022
#define RDC_SEMAPHORE1_GATE35			0x00000023
#define RDC_SEMAPHORE1_GATE36			0x00000024
#define RDC_SEMAPHORE1_GATE37			0x00000025
#define RDC_SEMAPHORE1_GATE38			0x00000026
#define RDC_SEMAPHORE1_GATE39			0x00000027
#define RDC_SEMAPHORE1_GATE40			0x00000028
#define RDC_SEMAPHORE1_GATE41			0x00000029
#define RDC_SEMAPHORE1_GATE42			0x0000002a
#define RDC_SEMAPHORE1_GATE43			0x0000002b
#define RDC_SEMAPHORE1_GATE44			0x0000002c
#define RDC_SEMAPHORE1_GATE45			0x0000002d
#define RDC_SEMAPHORE1_GATE46			0x0000002e
#define RDC_SEMAPHORE1_GATE47			0x0000002f
#define RDC_SEMAPHORE1_GATE48			0x00000030
#define RDC_SEMAPHORE1_GATE49			0x00000031
#define RDC_SEMAPHORE1_GATE50			0x00000032
#define RDC_SEMAPHORE1_GATE51			0x00000033
#define RDC_SEMAPHORE1_GATE52			0x00000034
#define RDC_SEMAPHORE1_GATE53			0x00000035
#define RDC_SEMAPHORE1_GATE54			0x00000036
#define RDC_SEMAPHORE1_GATE55			0x00000037
#define RDC_SEMAPHORE1_GATE56			0x00000038
#define RDC_SEMAPHORE1_GATE57			0x00000039
#define RDC_SEMAPHORE1_GATE58			0x0000003a
#define RDC_SEMAPHORE1_GATE59			0x0000003b
#define RDC_SEMAPHORE1_GATE60			0x0000003c
#define RDC_SEMAPHORE1_GATE61			0x0000003d
#define RDC_SEMAPHORE1_GATE62			0x0000003e
#define RDC_SEMAPHORE1_GATE63			0x0000003f
#define RDC_SEMAPHORE1_RSTGT_W			0x00000040
#define RDC_SEMAPHORE1_RSTGT_R			0x00000040

/*
 * RDC SEMAPHORE2 (AIPS1_SEMAPHORE2_BASE:0x303c0000)
 */
#define RDC_SEMAPHORE2_GATE0			0x00000000
#define RDC_SEMAPHORE2_GATE1			0x00000001
#define RDC_SEMAPHORE2_GATE2			0x00000002
#define RDC_SEMAPHORE2_GATE3			0x00000003
#define RDC_SEMAPHORE2_GATE4			0x00000004
#define RDC_SEMAPHORE2_GATE5			0x00000005
#define RDC_SEMAPHORE2_GATE6			0x00000006
#define RDC_SEMAPHORE2_GATE7			0x00000007
#define RDC_SEMAPHORE2_GATE8			0x00000008
#define RDC_SEMAPHORE2_GATE9			0x00000009
#define RDC_SEMAPHORE2_GATE10			0x0000000a
#define RDC_SEMAPHORE2_GATE11			0x0000000b
#define RDC_SEMAPHORE2_GATE12			0x0000000c
#define RDC_SEMAPHORE2_GATE13			0x0000000d
#define RDC_SEMAPHORE2_GATE14			0x0000000e
#define RDC_SEMAPHORE2_GATE15			0x0000000f
#define RDC_SEMAPHORE2_GATE16			0x00000010
#define RDC_SEMAPHORE2_GATE17			0x00000011
#define RDC_SEMAPHORE2_GATE18			0x00000012
#define RDC_SEMAPHORE2_GATE19			0x00000013
#define RDC_SEMAPHORE2_GATE20			0x00000014
#define RDC_SEMAPHORE2_GATE21			0x00000015
#define RDC_SEMAPHORE2_GATE22			0x00000016
#define RDC_SEMAPHORE2_GATE23			0x00000017
#define RDC_SEMAPHORE2_GATE24			0x00000018
#define RDC_SEMAPHORE2_GATE25			0x00000019
#define RDC_SEMAPHORE2_GATE26			0x0000001a
#define RDC_SEMAPHORE2_GATE27			0x0000001b
#define RDC_SEMAPHORE2_GATE28			0x0000001c
#define RDC_SEMAPHORE2_GATE29			0x0000001d
#define RDC_SEMAPHORE2_GATE30			0x0000001e
#define RDC_SEMAPHORE2_GATE31			0x0000001f
#define RDC_SEMAPHORE2_GATE32			0x00000020
#define RDC_SEMAPHORE2_GATE33			0x00000021
#define RDC_SEMAPHORE2_GATE34			0x00000022
#define RDC_SEMAPHORE2_GATE35			0x00000023
#define RDC_SEMAPHORE2_GATE36			0x00000024
#define RDC_SEMAPHORE2_GATE37			0x00000025
#define RDC_SEMAPHORE2_GATE38			0x00000026
#define RDC_SEMAPHORE2_GATE39			0x00000027
#define RDC_SEMAPHORE2_GATE40			0x00000028
#define RDC_SEMAPHORE2_GATE41			0x00000029
#define RDC_SEMAPHORE2_GATE42			0x0000002a
#define RDC_SEMAPHORE2_GATE43			0x0000002b
#define RDC_SEMAPHORE2_GATE44			0x0000002c
#define RDC_SEMAPHORE2_GATE45			0x0000002d
#define RDC_SEMAPHORE2_GATE46			0x0000002e
#define RDC_SEMAPHORE2_GATE47			0x0000002f
#define RDC_SEMAPHORE2_GATE48			0x00000030
#define RDC_SEMAPHORE2_GATE49			0x00000031
#define RDC_SEMAPHORE2_GATE50			0x00000032
#define RDC_SEMAPHORE2_GATE51			0x00000033
#define RDC_SEMAPHORE2_GATE52			0x00000034
#define RDC_SEMAPHORE2_GATE53			0x00000035
#define RDC_SEMAPHORE2_GATE54			0x00000036
#define RDC_SEMAPHORE2_GATE55			0x00000037
#define RDC_SEMAPHORE2_GATE56			0x00000038
#define RDC_SEMAPHORE2_GATE57			0x00000039
#define RDC_SEMAPHORE2_GATE58			0x0000003a
#define RDC_SEMAPHORE2_GATE59			0x0000003b
#define RDC_SEMAPHORE2_GATE60			0x0000003c
#define RDC_SEMAPHORE2_GATE61			0x0000003d
#define RDC_SEMAPHORE2_GATE62			0x0000003e
#define RDC_SEMAPHORE2_GATE63			0x0000003f
#define RDC_SEMAPHORE2_RSTGT_W			0x00000040
#define RDC_SEMAPHORE2_RSTGT_R			0x00000040

#define RDC_SEMAPHORE2_GPIO1			RDC_SEMAPHORE1_GATE0
#define RDC_SEMAPHORE2_GPIO2			RDC_SEMAPHORE1_GATE1
#define RDC_SEMAPHORE2_GPIO3			RDC_SEMAPHORE1_GATE2
#define RDC_SEMAPHORE2_GPIO4			RDC_SEMAPHORE1_GATE3
#define RDC_SEMAPHORE2_GPIO5			RDC_SEMAPHORE1_GATE4
#define RDC_SEMAPHORE2_GPIO6			RDC_SEMAPHORE1_GATE5
#define RDC_SEMAPHORE2_GPIO7			RDC_SEMAPHORE1_GATE6
#define RDC_SEMAPHORE2_IOMUXC_LPSR_GPR		RDC_SEMAPHORE1_GATE7
#define RDC_SEMAPHORE2_WDOG1			RDC_SEMAPHORE1_GATE8
#define RDC_SEMAPHORE2_WDOG2			RDC_SEMAPHORE1_GATE9
#define RDC_SEMAPHORE2_WDOG3			RDC_SEMAPHORE1_GATE10
#define RDC_SEMAPHORE2_WDOG4			RDC_SEMAPHORE1_GATE11
#define RDC_SEMAPHORE2_IOMUXC_LPSR		RDC_SEMAPHORE1_GATE12
#define RDC_SEMAPHORE2_GPT1			RDC_SEMAPHORE1_GATE13
#define RDC_SEMAPHORE2_GPT2			RDC_SEMAPHORE1_GATE14
#define RDC_SEMAPHORE2_GPT3			RDC_SEMAPHORE1_GATE15
#define RDC_SEMAPHORE2_GPT4			RDC_SEMAPHORE1_GATE16
#define RDC_SEMAPHORE2_ROMCP			RDC_SEMAPHORE1_GATE17
#define RDC_SEMAPHORE2_KPP			RDC_SEMAPHORE1_GATE18
#define RDC_SEMAPHORE2_IOMUXC			RDC_SEMAPHORE1_GATE19
#define RDC_SEMAPHORE2_IOMUXC_GPR		RDC_SEMAPHORE1_GATE20
#define RDC_SEMAPHORE2_OCOTP_CTRL		RDC_SEMAPHORE1_GATE21
#define RDC_SEMAPHORE2_ANATOP_DIG		RDC_SEMAPHORE1_GATE22
#define RDC_SEMAPHORE2_SNVS_HP			RDC_SEMAPHORE1_GATE23
#define RDC_SEMAPHORE2_CCM			RDC_SEMAPHORE1_GATE24
#define RDC_SEMAPHORE2_SRC			RDC_SEMAPHORE1_GATE25
#define RDC_SEMAPHORE2_GPC			RDC_SEMAPHORE1_GATE26
#define RDC_SEMAPHORE2_SEMAPHORE1		RDC_SEMAPHORE1_GATE27
#define RDC_SEMAPHORE2_SEMAPHORE2		RDC_SEMAPHORE1_GATE28
#define RDC_SEMAPHORE2_RDC			RDC_SEMAPHORE1_GATE29
#define RDC_SEMAPHORE2_CSU			RDC_SEMAPHORE1_GATE30
#define RDC_SEMAPHORE2_RESERVED_31		RDC_SEMAPHORE1_GATE31
#define RDC_SEMAPHORE2_RESERVED_32		RDC_SEMAPHORE1_GATE32
#define RDC_SEMAPHORE2_ADC1_WRAPPER		RDC_SEMAPHORE1_GATE33
#define RDC_SEMAPHORE2_ADC2_WRAPPER		RDC_SEMAPHORE1_GATE34
#define RDC_SEMAPHORE2_ECSPI4			RDC_SEMAPHORE1_GATE35
#define RDC_SEMAPHORE2_FLEX_TIMER_1		RDC_SEMAPHORE1_GATE36
#define RDC_SEMAPHORE2_FLEX_TIMER_2		RDC_SEMAPHORE1_GATE37
#define RDC_SEMAPHORE2_PWM1			RDC_SEMAPHORE1_GATE38
#define RDC_SEMAPHORE2_PWM2			RDC_SEMAPHORE1_GATE39
#define RDC_SEMAPHORE2_PWM3			RDC_SEMAPHORE1_GATE40
#define RDC_SEMAPHORE2_PWM4			RDC_SEMAPHORE1_GATE41
#define RDC_SEMAPHORE2_SYSTEM_COUNTER_READ	RDC_SEMAPHORE1_GATE42
#define RDC_SEMAPHORE2_SYSTEM_COUNTER_COMPARE	RDC_SEMAPHORE1_GATE43
#define RDC_SEMAPHORE2_SYSTEM_COUNTER_CONTROL	RDC_SEMAPHORE1_GATE44
#define RDC_SEMAPHORE2_PCIE_PHY			RDC_SEMAPHORE1_GATE45
#define RDC_SEMAPHORE2_RESERVED_46		RDC_SEMAPHORE1_GATE46
#define RDC_SEMAPHORE2_EPDC			RDC_SEMAPHORE1_GATE47
#define RDC_SEMAPHORE2_PXP			RDC_SEMAPHORE1_GATE48
#define RDC_SEMAPHORE2_CSI			RDC_SEMAPHORE1_GATE49
#define RDC_SEMAPHORE2_RESERVED_50		RDC_SEMAPHORE1_GATE50
#define RDC_SEMAPHORE2_LCDIF			RDC_SEMAPHORE1_GATE51
#define RDC_SEMAPHORE2_RESERVED_52		RDC_SEMAPHORE1_GATE52
#define RDC_SEMAPHORE2_MIPI_CSI			RDC_SEMAPHORE1_GATE53
#define RDC_SEMAPHORE2_MIPI_DSI			RDC_SEMAPHORE1_GATE54
#define RDC_SEMAPHORE2_RESERVED_55		RDC_SEMAPHORE1_GATE55
#define RDC_SEMAPHORE2_TZASC			RDC_SEMAPHORE1_GATE56
#define RDC_SEMAPHORE2_DDR_PHY			RDC_SEMAPHORE1_GATE57
#define RDC_SEMAPHORE2_DDRC			RDC_SEMAPHORE1_GATE58
#define RDC_SEMAPHORE2_RESERVED_59		RDC_SEMAPHORE1_GATE59
#define RDC_SEMAPHORE2_PERFMON1			RDC_SEMAPHORE1_GATE60
#define RDC_SEMAPHORE2_PERFMON2			RDC_SEMAPHORE1_GATE61
#define RDC_SEMAPHORE2_AXI_DEBUG_MON		RDC_SEMAPHORE1_GATE62
#define RDC_SEMAPHORE2_QOSC			RDC_SEMAPHORE1_GATE63
#define RDC_SEMAPHORE2_FLEXCAN1			RDC_SEMAPHORE2_GATE0
#define RDC_SEMAPHORE2_FLEXCAN2			RDC_SEMAPHORE2_GATE1
#define RDC_SEMAPHORE2_I2C1			RDC_SEMAPHORE2_GATE2
#define RDC_SEMAPHORE2_I2C2			RDC_SEMAPHORE2_GATE3
#define RDC_SEMAPHORE2_I2C3			RDC_SEMAPHORE2_GATE4
#define RDC_SEMAPHORE2_I2C4			RDC_SEMAPHORE2_GATE5
#define RDC_SEMAPHORE2_UART4			RDC_SEMAPHORE2_GATE6
#define RDC_SEMAPHORE2_UART5			RDC_SEMAPHORE2_GATE7
#define RDC_SEMAPHORE2_UART6			RDC_SEMAPHORE2_GATE8
#define RDC_SEMAPHORE2_UART7			RDC_SEMAPHORE2_GATE9
#define RDC_SEMAPHORE2_MU_A			RDC_SEMAPHORE2_GATE10
#define RDC_SEMAPHORE2_MU_B			RDC_SEMAPHORE2_GATE11
#define RDC_SEMAPHORE2_SEMAPHORE_HS		RDC_SEMAPHORE2_GATE12
#define RDC_SEMAPHORE2_USB_PL301		RDC_SEMAPHORE2_GATE13
#define RDC_SEMAPHORE2_RESERVED_78		RDC_SEMAPHORE2_GATE14
#define RDC_SEMAPHORE2_RESERVED_79		RDC_SEMAPHORE2_GATE15
#define RDC_SEMAPHORE2_RESERVED_80		RDC_SEMAPHORE2_GATE16
#define RDC_SEMAPHORE2_USB1_OTG1		RDC_SEMAPHORE2_GATE17
#define RDC_SEMAPHORE2_USB2_OTG2		RDC_SEMAPHORE2_GATE18
#define RDC_SEMAPHORE2_USB3_HOST		RDC_SEMAPHORE2_GATE19
#define RDC_SEMAPHORE2_USDHC1			RDC_SEMAPHORE2_GATE20
#define RDC_SEMAPHORE2_USDHC2			RDC_SEMAPHORE2_GATE21
#define RDC_SEMAPHORE2_USDHC3			RDC_SEMAPHORE2_GATE22
#define RDC_SEMAPHORE2_RESERVED_87		RDC_SEMAPHORE2_GATE23
#define RDC_SEMAPHORE2_RESERVED_88		RDC_SEMAPHORE2_GATE24
#define RDC_SEMAPHORE2_SIM1			RDC_SEMAPHORE2_GATE25
#define RDC_SEMAPHORE2_SIM2			RDC_SEMAPHORE2_GATE26
#define RDC_SEMAPHORE2_QSPI			RDC_SEMAPHORE2_GATE27
#define RDC_SEMAPHORE2_WEIM			RDC_SEMAPHORE2_GATE28
#define RDC_SEMAPHORE2_SDMA			RDC_SEMAPHORE2_GATE29
#define RDC_SEMAPHORE2_ENET1			RDC_SEMAPHORE2_GATE30
#define RDC_SEMAPHORE2_ENET2			RDC_SEMAPHORE2_GATE31
#define RDC_SEMAPHORE2_RESERVED_96_FOR_SDMA	RDC_SEMAPHORE2_GATE32
#define RDC_SEMAPHORE2_RESERVED_97		RDC_SEMAPHORE2_GATE33
#define RDC_SEMAPHORE2_ECSPI1			RDC_SEMAPHORE2_GATE34
#define RDC_SEMAPHORE2_ECSPI2			RDC_SEMAPHORE2_GATE35
#define RDC_SEMAPHORE2_ECSPI3			RDC_SEMAPHORE2_GATE36
#define RDC_SEMAPHORE2_RESERVED_101		RDC_SEMAPHORE2_GATE37
#define RDC_SEMAPHORE2_UART1			RDC_SEMAPHORE2_GATE38
#define RDC_SEMAPHORE2_UART2			RDC_SEMAPHORE2_GATE39
#define RDC_SEMAPHORE2_UART3			RDC_SEMAPHORE2_GATE40
#define RDC_SEMAPHORE2_RESERVED_105_FOR_SDMA	RDC_SEMAPHORE2_GATE41
#define RDC_SEMAPHORE2_SAI1			RDC_SEMAPHORE2_GATE42
#define RDC_SEMAPHORE2_SAI2			RDC_SEMAPHORE2_GATE43
#define RDC_SEMAPHORE2_SAI3			RDC_SEMAPHORE2_GATE44
#define RDC_SEMAPHORE2_RESERVED_109		RDC_SEMAPHORE2_GATE45
#define RDC_SEMAPHORE2_RESERVED_110_FOR_SDMA	RDC_SEMAPHORE2_GATE46
#define RDC_SEMAPHORE2_SPBA			RDC_SEMAPHORE2_GATE47
#define RDC_SEMAPHORE2_ULT1_DAP			RDC_SEMAPHORE2_GATE48
#define RDC_SEMAPHORE2_RESERVED_113		RDC_SEMAPHORE2_GATE49
#define RDC_SEMAPHORE2_RESERVED_114		RDC_SEMAPHORE2_GATE50
#define RDC_SEMAPHORE2_RESERVED_115		RDC_SEMAPHORE2_GATE51
#define RDC_SEMAPHORE2_CAAM			RDC_SEMAPHORE2_GATE52
#define RDC_SEMAPHORE2_RESERVED_117		RDC_SEMAPHORE2_GATE53

#endif /* _ARM_IMX_IMX7_RDCREG_H_ */
