/*	$NetBSD: imx7_ccmreg.h,v 1.2 2016/10/17 09:21:51 ryo Exp $	*/

/*
 * Copyright (c) 2015 Internet Initiative Japan, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ARM_IMX_IMX7_CCMREG_H_
#define _ARM_IMX_IMX7_CCMREG_H_

#include <sys/cdefs.h>

#ifndef IMX7_OSC_FREQ
#define IMX7_OSC_FREQ		(24 * 1000 * 1000)		/* 24MHz */
#endif
#ifndef IMX7_OSC_LOW_FREQ
#define IMX7_OSC_LOW_FREQ	(32 * 1000)			/* 32KHz */
#endif

#define IMX7_ENET_PLL_CLK	(1 * 1000 * 1000 * 1000)	/* 1GHz */
#define IMX7_USB_PLL_CLK	(480 * 1000 * 1000)		/* 480MHz */

/* Clock Control Module (AIPS1_CCM_BASE:0x30380000) */

/* General Purpose Register */
#define CCM_GPR0			0x00000000
#define CCM_GPR0_SET			0x00000004
#define CCM_GPR0_CLR			0x00000008
#define CCM_GPR0_TOG			0x0000000c

/* CCM PLL Control Register */
#define CCM_PLL_CTRL0			0x00000800
#define CCM_PLL_CTRL0_SET		0x00000804
#define CCM_PLL_CTRL0_CLR		0x00000808
#define CCM_PLL_CTRL0_TOG		0x0000080c
#define CCM_PLL_CTRL1			0x00000810
#define CCM_PLL_CTRL1_SET		0x00000814
#define CCM_PLL_CTRL1_CLR		0x00000818
#define CCM_PLL_CTRL1_TOG		0x0000081c
#define CCM_PLL_CTRL2			0x00000820
#define CCM_PLL_CTRL2_SET		0x00000824
#define CCM_PLL_CTRL2_CLR		0x00000828
#define CCM_PLL_CTRL2_TOG		0x0000082c
#define CCM_PLL_CTRL3			0x00000830
#define CCM_PLL_CTRL3_SET		0x00000834
#define CCM_PLL_CTRL3_CLR		0x00000838
#define CCM_PLL_CTRL3_TOG		0x0000083c
#define CCM_PLL_CTRL4			0x00000840
#define CCM_PLL_CTRL4_SET		0x00000844
#define CCM_PLL_CTRL4_CLR		0x00000848
#define CCM_PLL_CTRL4_TOG		0x0000084c
#define CCM_PLL_CTRL5			0x00000850
#define CCM_PLL_CTRL5_SET		0x00000854
#define CCM_PLL_CTRL5_CLR		0x00000858
#define CCM_PLL_CTRL5_TOG		0x0000085c
#define CCM_PLL_CTRL6			0x00000860
#define CCM_PLL_CTRL6_SET		0x00000864
#define CCM_PLL_CTRL6_CLR		0x00000868
#define CCM_PLL_CTRL6_TOG		0x0000086c
#define CCM_PLL_CTRL7			0x00000870
#define CCM_PLL_CTRL7_SET		0x00000874
#define CCM_PLL_CTRL7_CLR		0x00000878
#define CCM_PLL_CTRL7_TOG		0x0000087c
#define CCM_PLL_CTRL8			0x00000880
#define CCM_PLL_CTRL8_SET		0x00000884
#define CCM_PLL_CTRL8_CLR		0x00000888
#define CCM_PLL_CTRL8_TOG		0x0000088c
#define CCM_PLL_CTRL9			0x00000890
#define CCM_PLL_CTRL9_SET		0x00000894
#define CCM_PLL_CTRL9_CLR		0x00000898
#define CCM_PLL_CTRL9_TOG		0x0000089c
#define CCM_PLL_CTRL10			0x000008a0
#define CCM_PLL_CTRL10_SET		0x000008a4
#define CCM_PLL_CTRL10_CLR		0x000008a8
#define CCM_PLL_CTRL10_TOG		0x000008ac
#define CCM_PLL_CTRL11			0x000008b0
#define CCM_PLL_CTRL11_SET		0x000008b4
#define CCM_PLL_CTRL11_CLR		0x000008b8
#define CCM_PLL_CTRL11_TOG		0x000008bc
#define CCM_PLL_CTRL12			0x000008c0
#define CCM_PLL_CTRL12_SET		0x000008c4
#define CCM_PLL_CTRL12_CLR		0x000008c8
#define CCM_PLL_CTRL12_TOG		0x000008cc
#define CCM_PLL_CTRL13			0x000008d0
#define CCM_PLL_CTRL13_SET		0x000008d4
#define CCM_PLL_CTRL13_CLR		0x000008d8
#define CCM_PLL_CTRL13_TOG		0x000008dc
#define CCM_PLL_CTRL14			0x000008e0
#define CCM_PLL_CTRL14_SET		0x000008e4
#define CCM_PLL_CTRL14_CLR		0x000008e8
#define CCM_PLL_CTRL14_TOG		0x000008ec
#define CCM_PLL_CTRL15			0x000008f0
#define CCM_PLL_CTRL15_SET		0x000008f4
#define CCM_PLL_CTRL15_CLR		0x000008f8
#define CCM_PLL_CTRL15_TOG		0x000008fc
#define CCM_PLL_CTRL16			0x00000900
#define CCM_PLL_CTRL16_SET		0x00000904
#define CCM_PLL_CTRL16_CLR		0x00000908
#define CCM_PLL_CTRL16_TOG		0x0000090c
#define CCM_PLL_CTRL17			0x00000910
#define CCM_PLL_CTRL17_SET		0x00000914
#define CCM_PLL_CTRL17_CLR		0x00000918
#define CCM_PLL_CTRL17_TOG		0x0000091c
#define CCM_PLL_CTRL18			0x00000920
#define CCM_PLL_CTRL18_SET		0x00000924
#define CCM_PLL_CTRL18_CLR		0x00000928
#define CCM_PLL_CTRL18_TOG		0x0000092c
#define CCM_PLL_CTRL19			0x00000930
#define CCM_PLL_CTRL19_SET		0x00000934
#define CCM_PLL_CTRL19_CLR		0x00000938
#define CCM_PLL_CTRL19_TOG		0x0000093c
#define CCM_PLL_CTRL20			0x00000940
#define CCM_PLL_CTRL20_SET		0x00000944
#define CCM_PLL_CTRL20_CLR		0x00000948
#define CCM_PLL_CTRL20_TOG		0x0000094c
#define CCM_PLL_CTRL21			0x00000950
#define CCM_PLL_CTRL21_SET		0x00000954
#define CCM_PLL_CTRL21_CLR		0x00000958
#define CCM_PLL_CTRL21_TOG		0x0000095c
#define CCM_PLL_CTRL22			0x00000960
#define CCM_PLL_CTRL22_SET		0x00000964
#define CCM_PLL_CTRL22_CLR		0x00000968
#define CCM_PLL_CTRL22_TOG		0x0000096c
#define CCM_PLL_CTRL23			0x00000970
#define CCM_PLL_CTRL23_SET		0x00000974
#define CCM_PLL_CTRL23_CLR		0x00000978
#define CCM_PLL_CTRL23_TOG		0x0000097c
#define CCM_PLL_CTRL24			0x00000980
#define CCM_PLL_CTRL24_SET		0x00000984
#define CCM_PLL_CTRL24_CLR		0x00000988
#define CCM_PLL_CTRL24_TOG		0x0000098c
#define CCM_PLL_CTRL25			0x00000990
#define CCM_PLL_CTRL25_SET		0x00000994
#define CCM_PLL_CTRL25_CLR		0x00000998
#define CCM_PLL_CTRL25_TOG		0x0000099c
#define CCM_PLL_CTRL26			0x000009a0
#define CCM_PLL_CTRL26_SET		0x000009a4
#define CCM_PLL_CTRL26_CLR		0x000009a8
#define CCM_PLL_CTRL26_TOG		0x000009ac
#define CCM_PLL_CTRL27			0x000009b0
#define CCM_PLL_CTRL27_SET		0x000009b4
#define CCM_PLL_CTRL27_CLR		0x000009b8
#define CCM_PLL_CTRL27_TOG		0x000009bc
#define CCM_PLL_CTRL28			0x000009c0
#define CCM_PLL_CTRL28_SET		0x000009c4
#define CCM_PLL_CTRL28_CLR		0x000009c8
#define CCM_PLL_CTRL28_TOG		0x000009cc
#define CCM_PLL_CTRL29			0x000009d0
#define CCM_PLL_CTRL29_SET		0x000009d4
#define CCM_PLL_CTRL29_CLR		0x000009d8
#define CCM_PLL_CTRL29_TOG		0x000009dc
#define CCM_PLL_CTRL30			0x000009e0
#define CCM_PLL_CTRL30_SET		0x000009e4
#define CCM_PLL_CTRL30_CLR		0x000009e8
#define CCM_PLL_CTRL30_TOG		0x000009ec
#define CCM_PLL_CTRL31			0x000009f0
#define CCM_PLL_CTRL31_SET		0x000009f4
#define CCM_PLL_CTRL31_CLR		0x000009f8
#define CCM_PLL_CTRL31_TOG		0x000009fc
#define CCM_PLL_CTRL32			0x00000a00
#define CCM_PLL_CTRL32_SET		0x00000a04
#define CCM_PLL_CTRL32_CLR		0x00000a08
#define CCM_PLL_CTRL32_TOG		0x00000a0c

/* Clock Control Gating Register */
#define CCM_CCGR0			0x00004000
#define CCM_CCGR0_SET			0x00004004
#define CCM_CCGR0_CLR			0x00004008
#define CCM_CCGR0_TOG			0x0000400c
#define  CCM_CCGR_SETTING0		__BITS(1, 0)
#define  CCM_CCGR_SETTING1		__BITS(5, 4)
#define  CCM_CCGR_SETTING2		__BITS(9, 8)
#define  CCM_CCGR_SETTING3		__BITS(13, 12)
#define  CCM_CCGR_MASK			(CCM_CCGR_SETTING0|	\
					 CCM_CCGR_SETTING1|	\
					 CCM_CCGR_SETTING2|	\
					 CCM_CCGR_SETTING3)
#define  CCM_CCGR_DOMAIN0_ALL		__SHIFTIN(3, CCM_CCGR_SETTING0)
#define  CCM_CCGR_DOMAIN1_ALL		__SHIFTIN(3, CCM_CCGR_SETTING1)
#define  CCM_CCGR_DOMAIN2_ALL		__SHIFTIN(3, CCM_CCGR_SETTING2)
#define  CCM_CCGR_DOMAIN3_ALL		__SHIFTIN(3, CCM_CCGR_SETTING3)
#define  CCM_CCGR_DOMAIN0_RUNWAIT	__SHIFTIN(2, CCM_CCGR_SETTING0)
#define  CCM_CCGR_DOMAIN1_RUNWAIT	__SHIFTIN(2, CCM_CCGR_SETTING1)
#define  CCM_CCGR_DOMAIN2_RUNWAIT	__SHIFTIN(2, CCM_CCGR_SETTING2)
#define  CCM_CCGR_DOMAIN3_RUNWAIT	__SHIFTIN(2, CCM_CCGR_SETTING3)
#define  CCM_CCGR_DOMAIN0_RUN		__SHIFTIN(1, CCM_CCGR_SETTING0)
#define  CCM_CCGR_DOMAIN1_RUN		__SHIFTIN(1, CCM_CCGR_SETTING1)
#define  CCM_CCGR_DOMAIN2_RUN		__SHIFTIN(1, CCM_CCGR_SETTING2)
#define  CCM_CCGR_DOMAIN3_RUN		__SHIFTIN(1, CCM_CCGR_SETTING3)
#define  CCM_CCGR_DOMAIN0_NOTNEED	__SHIFTIN(0, CCM_CCGR_SETTING0)
#define  CCM_CCGR_DOMAIN1_NOTNEED	__SHIFTIN(0, CCM_CCGR_SETTING1)
#define  CCM_CCGR_DOMAIN2_NOTNEED	__SHIFTIN(0, CCM_CCGR_SETTING2)
#define  CCM_CCGR_DOMAIN3_NOTNEED	__SHIFTIN(0, CCM_CCGR_SETTING3)
#define CCM_CCGR1			0x00004010
#define CCM_CCGR1_SET			0x00004014
#define CCM_CCGR1_CLR			0x00004018
#define CCM_CCGR1_TOG			0x0000401c
#define CCM_CCGR2			0x00004020
#define CCM_CCGR2_SET			0x00004024
#define CCM_CCGR2_CLR			0x00004028
#define CCM_CCGR2_TOG			0x0000402c
#define CCM_CCGR3			0x00004030
#define CCM_CCGR3_SET			0x00004034
#define CCM_CCGR3_CLR			0x00004038
#define CCM_CCGR3_TOG			0x0000403c
#define CCM_CCGR4			0x00004040
#define CCM_CCGR4_SET			0x00004044
#define CCM_CCGR4_CLR			0x00004048
#define CCM_CCGR4_TOG			0x0000404c
#define CCM_CCGR5			0x00004050
#define CCM_CCGR5_SET			0x00004054
#define CCM_CCGR5_CLR			0x00004058
#define CCM_CCGR5_TOG			0x0000405c
#define CCM_CCGR6			0x00004060
#define CCM_CCGR6_SET			0x00004064
#define CCM_CCGR6_CLR			0x00004068
#define CCM_CCGR6_TOG			0x0000406c
#define CCM_CCGR7			0x00004070
#define CCM_CCGR7_SET			0x00004074
#define CCM_CCGR7_CLR			0x00004078
#define CCM_CCGR7_TOG			0x0000407c
#define CCM_CCGR8			0x00004080
#define CCM_CCGR8_SET			0x00004084
#define CCM_CCGR8_CLR			0x00004088
#define CCM_CCGR8_TOG			0x0000408c
#define CCM_CCGR9			0x00004090
#define CCM_CCGR9_SET			0x00004094
#define CCM_CCGR9_CLR			0x00004098
#define CCM_CCGR9_TOG			0x0000409c
#define CCM_CCGR10			0x000040a0
#define CCM_CCGR10_SET			0x000040a4
#define CCM_CCGR10_CLR			0x000040a8
#define CCM_CCGR10_TOG			0x000040ac
#define CCM_CCGR11			0x000040b0
#define CCM_CCGR11_SET			0x000040b4
#define CCM_CCGR11_CLR			0x000040b8
#define CCM_CCGR11_TOG			0x000040bc
#define CCM_CCGR12			0x000040c0
#define CCM_CCGR12_SET			0x000040c4
#define CCM_CCGR12_CLR			0x000040c8
#define CCM_CCGR12_TOG			0x000040cc
#define CCM_CCGR13			0x000040d0
#define CCM_CCGR13_SET			0x000040d4
#define CCM_CCGR13_CLR			0x000040d8
#define CCM_CCGR13_TOG			0x000040dc
#define CCM_CCGR14			0x000040e0
#define CCM_CCGR14_SET			0x000040e4
#define CCM_CCGR14_CLR			0x000040e8
#define CCM_CCGR14_TOG			0x000040ec
#define CCM_CCGR15			0x000040f0
#define CCM_CCGR15_SET			0x000040f4
#define CCM_CCGR15_CLR			0x000040f8
#define CCM_CCGR15_TOG			0x000040fc
#define CCM_CCGR16			0x00004100
#define CCM_CCGR16_SET			0x00004104
#define CCM_CCGR16_CLR			0x00004108
#define CCM_CCGR16_TOG			0x0000410c
#define CCM_CCGR17			0x00004110
#define CCM_CCGR17_SET			0x00004114
#define CCM_CCGR17_CLR			0x00004118
#define CCM_CCGR17_TOG			0x0000411c
#define CCM_CCGR18			0x00004120
#define CCM_CCGR18_SET			0x00004124
#define CCM_CCGR18_CLR			0x00004128
#define CCM_CCGR18_TOG			0x0000412c
#define CCM_CCGR19			0x00004130
#define CCM_CCGR19_SET			0x00004134
#define CCM_CCGR19_CLR			0x00004138
#define CCM_CCGR19_TOG			0x0000413c
#define CCM_CCGR20			0x00004140
#define CCM_CCGR20_SET			0x00004144
#define CCM_CCGR20_CLR			0x00004148
#define CCM_CCGR20_TOG			0x0000414c
#define CCM_CCGR21			0x00004150
#define CCM_CCGR21_SET			0x00004154
#define CCM_CCGR21_CLR			0x00004158
#define CCM_CCGR21_TOG			0x0000415c
#define CCM_CCGR22			0x00004160
#define CCM_CCGR22_SET			0x00004164
#define CCM_CCGR22_CLR			0x00004168
#define CCM_CCGR22_TOG			0x0000416c
#define CCM_CCGR23			0x00004170
#define CCM_CCGR23_SET			0x00004174
#define CCM_CCGR23_CLR			0x00004178
#define CCM_CCGR23_TOG			0x0000417c
#define CCM_CCGR24			0x00004180
#define CCM_CCGR24_SET			0x00004184
#define CCM_CCGR24_CLR			0x00004188
#define CCM_CCGR24_TOG			0x0000418c
#define CCM_CCGR25			0x00004190
#define CCM_CCGR25_SET			0x00004194
#define CCM_CCGR25_CLR			0x00004198
#define CCM_CCGR25_TOG			0x0000419c
#define CCM_CCGR26			0x000041a0
#define CCM_CCGR26_SET			0x000041a4
#define CCM_CCGR26_CLR			0x000041a8
#define CCM_CCGR26_TOG			0x000041ac
#define CCM_CCGR27			0x000041b0
#define CCM_CCGR27_SET			0x000041b4
#define CCM_CCGR27_CLR			0x000041b8
#define CCM_CCGR27_TOG			0x000041bc
#define CCM_CCGR28			0x000041c0
#define CCM_CCGR28_SET			0x000041c4
#define CCM_CCGR28_CLR			0x000041c8
#define CCM_CCGR28_TOG			0x000041cc
#define CCM_CCGR29			0x000041d0
#define CCM_CCGR29_SET			0x000041d4
#define CCM_CCGR29_CLR			0x000041d8
#define CCM_CCGR29_TOG			0x000041dc
#define CCM_CCGR30			0x000041e0
#define CCM_CCGR30_SET			0x000041e4
#define CCM_CCGR30_CLR			0x000041e8
#define CCM_CCGR30_TOG			0x000041ec
#define CCM_CCGR31			0x000041f0
#define CCM_CCGR31_SET			0x000041f4
#define CCM_CCGR31_CLR			0x000041f8
#define CCM_CCGR31_TOG			0x000041fc
#define CCM_CCGR32			0x00004200
#define CCM_CCGR32_SET			0x00004204
#define CCM_CCGR32_CLR			0x00004208
#define CCM_CCGR32_TOG			0x0000420c
#define CCM_CCGR33			0x00004210
#define CCM_CCGR33_SET			0x00004214
#define CCM_CCGR33_CLR			0x00004218
#define CCM_CCGR33_TOG			0x0000421c
#define CCM_CCGR34			0x00004220
#define CCM_CCGR34_SET			0x00004224
#define CCM_CCGR34_CLR			0x00004228
#define CCM_CCGR34_TOG			0x0000422c
#define CCM_CCGR35			0x00004230
#define CCM_CCGR35_SET			0x00004234
#define CCM_CCGR35_CLR			0x00004238
#define CCM_CCGR35_TOG			0x0000423c
#define CCM_CCGR36			0x00004240
#define CCM_CCGR36_SET			0x00004244
#define CCM_CCGR36_CLR			0x00004248
#define CCM_CCGR36_TOG			0x0000424c
#define CCM_CCGR37			0x00004250
#define CCM_CCGR37_SET			0x00004254
#define CCM_CCGR37_CLR			0x00004258
#define CCM_CCGR37_TOG			0x0000425c
#define CCM_CCGR38			0x00004260
#define CCM_CCGR38_SET			0x00004264
#define CCM_CCGR38_CLR			0x00004268
#define CCM_CCGR38_TOG			0x0000426c
#define CCM_CCGR39			0x00004270
#define CCM_CCGR39_SET			0x00004274
#define CCM_CCGR39_CLR			0x00004278
#define CCM_CCGR39_TOG			0x0000427c
#define CCM_CCGR40			0x00004280
#define CCM_CCGR40_SET			0x00004284
#define CCM_CCGR40_CLR			0x00004288
#define CCM_CCGR40_TOG			0x0000428c
#define CCM_CCGR41			0x00004290
#define CCM_CCGR41_SET			0x00004294
#define CCM_CCGR41_CLR			0x00004298
#define CCM_CCGR41_TOG			0x0000429c
#define CCM_CCGR42			0x000042a0
#define CCM_CCGR42_SET			0x000042a4
#define CCM_CCGR42_CLR			0x000042a8
#define CCM_CCGR42_TOG			0x000042ac
#define CCM_CCGR43			0x000042b0
#define CCM_CCGR43_SET			0x000042b4
#define CCM_CCGR43_CLR			0x000042b8
#define CCM_CCGR43_TOG			0x000042bc
#define CCM_CCGR44			0x000042c0
#define CCM_CCGR44_SET			0x000042c4
#define CCM_CCGR44_CLR			0x000042c8
#define CCM_CCGR44_TOG			0x000042cc
#define CCM_CCGR45			0x000042d0
#define CCM_CCGR45_SET			0x000042d4
#define CCM_CCGR45_CLR			0x000042d8
#define CCM_CCGR45_TOG			0x000042dc
#define CCM_CCGR46			0x000042e0
#define CCM_CCGR46_SET			0x000042e4
#define CCM_CCGR46_CLR			0x000042e8
#define CCM_CCGR46_TOG			0x000042ec
#define CCM_CCGR47			0x000042f0
#define CCM_CCGR47_SET			0x000042f4
#define CCM_CCGR47_CLR			0x000042f8
#define CCM_CCGR47_TOG			0x000042fc
#define CCM_CCGR48			0x00004300
#define CCM_CCGR48_SET			0x00004304
#define CCM_CCGR48_CLR			0x00004308
#define CCM_CCGR48_TOG			0x0000430c
#define CCM_CCGR49			0x00004310
#define CCM_CCGR49_SET			0x00004314
#define CCM_CCGR49_CLR			0x00004318
#define CCM_CCGR49_TOG			0x0000431c
#define CCM_CCGR50			0x00004320
#define CCM_CCGR50_SET			0x00004324
#define CCM_CCGR50_CLR			0x00004328
#define CCM_CCGR50_TOG			0x0000432c
#define CCM_CCGR51			0x00004330
#define CCM_CCGR51_SET			0x00004334
#define CCM_CCGR51_CLR			0x00004338
#define CCM_CCGR51_TOG			0x0000433c
#define CCM_CCGR52			0x00004340
#define CCM_CCGR52_SET			0x00004344
#define CCM_CCGR52_CLR			0x00004348
#define CCM_CCGR52_TOG			0x0000434c
#define CCM_CCGR53			0x00004350
#define CCM_CCGR53_SET			0x00004354
#define CCM_CCGR53_CLR			0x00004358
#define CCM_CCGR53_TOG			0x0000435c
#define CCM_CCGR54			0x00004360
#define CCM_CCGR54_SET			0x00004364
#define CCM_CCGR54_CLR			0x00004368
#define CCM_CCGR54_TOG			0x0000436c
#define CCM_CCGR55			0x00004370
#define CCM_CCGR55_SET			0x00004374
#define CCM_CCGR55_CLR			0x00004378
#define CCM_CCGR55_TOG			0x0000437c
#define CCM_CCGR56			0x00004380
#define CCM_CCGR56_SET			0x00004384
#define CCM_CCGR56_CLR			0x00004388
#define CCM_CCGR56_TOG			0x0000438c
#define CCM_CCGR57			0x00004390
#define CCM_CCGR57_SET			0x00004394
#define CCM_CCGR57_CLR			0x00004398
#define CCM_CCGR57_TOG			0x0000439c
#define CCM_CCGR58			0x000043a0
#define CCM_CCGR58_SET			0x000043a4
#define CCM_CCGR58_CLR			0x000043a8
#define CCM_CCGR58_TOG			0x000043ac
#define CCM_CCGR59			0x000043b0
#define CCM_CCGR59_SET			0x000043b4
#define CCM_CCGR59_CLR			0x000043b8
#define CCM_CCGR59_TOG			0x000043bc
#define CCM_CCGR60			0x000043c0
#define CCM_CCGR60_SET			0x000043c4
#define CCM_CCGR60_CLR			0x000043c8
#define CCM_CCGR60_TOG			0x000043cc
#define CCM_CCGR61			0x000043d0
#define CCM_CCGR61_SET			0x000043d4
#define CCM_CCGR61_CLR			0x000043d8
#define CCM_CCGR61_TOG			0x000043dc
#define CCM_CCGR62			0x000043e0
#define CCM_CCGR62_SET			0x000043e4
#define CCM_CCGR62_CLR			0x000043e8
#define CCM_CCGR62_TOG			0x000043ec
#define CCM_CCGR63			0x000043f0
#define CCM_CCGR63_SET			0x000043f4
#define CCM_CCGR63_CLR			0x000043f8
#define CCM_CCGR63_TOG			0x000043fc
#define CCM_CCGR64			0x00004400
#define CCM_CCGR64_SET			0x00004404
#define CCM_CCGR64_CLR			0x00004408
#define CCM_CCGR64_TOG			0x0000440c
#define CCM_CCGR65			0x00004410
#define CCM_CCGR65_SET			0x00004414
#define CCM_CCGR65_CLR			0x00004418
#define CCM_CCGR65_TOG			0x0000441c
#define CCM_CCGR66			0x00004420
#define CCM_CCGR66_SET			0x00004424
#define CCM_CCGR66_CLR			0x00004428
#define CCM_CCGR66_TOG			0x0000442c
#define CCM_CCGR67			0x00004430
#define CCM_CCGR67_SET			0x00004434
#define CCM_CCGR67_CLR			0x00004438
#define CCM_CCGR67_TOG			0x0000443c
#define CCM_CCGR68			0x00004440
#define CCM_CCGR68_SET			0x00004444
#define CCM_CCGR68_CLR			0x00004448
#define CCM_CCGR68_TOG			0x0000444c
#define CCM_CCGR69			0x00004450
#define CCM_CCGR69_SET			0x00004454
#define CCM_CCGR69_CLR			0x00004458
#define CCM_CCGR69_TOG			0x0000445c
#define CCM_CCGR70			0x00004460
#define CCM_CCGR70_SET			0x00004464
#define CCM_CCGR70_CLR			0x00004468
#define CCM_CCGR70_TOG			0x0000446c
#define CCM_CCGR71			0x00004470
#define CCM_CCGR71_SET			0x00004474
#define CCM_CCGR71_CLR			0x00004478
#define CCM_CCGR71_TOG			0x0000447c
#define CCM_CCGR72			0x00004480
#define CCM_CCGR72_SET			0x00004484
#define CCM_CCGR72_CLR			0x00004488
#define CCM_CCGR72_TOG			0x0000448c
#define CCM_CCGR73			0x00004490
#define CCM_CCGR73_SET			0x00004494
#define CCM_CCGR73_CLR			0x00004498
#define CCM_CCGR73_TOG			0x0000449c
#define CCM_CCGR74			0x000044a0
#define CCM_CCGR74_SET			0x000044a4
#define CCM_CCGR74_CLR			0x000044a8
#define CCM_CCGR74_TOG			0x000044ac
#define CCM_CCGR75			0x000044b0
#define CCM_CCGR75_SET			0x000044b4
#define CCM_CCGR75_CLR			0x000044b8
#define CCM_CCGR75_TOG			0x000044bc
#define CCM_CCGR76			0x000044c0
#define CCM_CCGR76_SET			0x000044c4
#define CCM_CCGR76_CLR			0x000044c8
#define CCM_CCGR76_TOG			0x000044cc
#define CCM_CCGR77			0x000044d0
#define CCM_CCGR77_SET			0x000044d4
#define CCM_CCGR77_CLR			0x000044d8
#define CCM_CCGR77_TOG			0x000044dc
#define CCM_CCGR78			0x000044e0
#define CCM_CCGR78_SET			0x000044e4
#define CCM_CCGR78_CLR			0x000044e8
#define CCM_CCGR78_TOG			0x000044ec
#define CCM_CCGR79			0x000044f0
#define CCM_CCGR79_SET			0x000044f4
#define CCM_CCGR79_CLR			0x000044f8
#define CCM_CCGR79_TOG			0x000044fc
#define CCM_CCGR80			0x00004500
#define CCM_CCGR80_SET			0x00004504
#define CCM_CCGR80_CLR			0x00004508
#define CCM_CCGR80_TOG			0x0000450c
#define CCM_CCGR81			0x00004510
#define CCM_CCGR81_SET			0x00004514
#define CCM_CCGR81_CLR			0x00004518
#define CCM_CCGR81_TOG			0x0000451c
#define CCM_CCGR82			0x00004520
#define CCM_CCGR82_SET			0x00004524
#define CCM_CCGR82_CLR			0x00004528
#define CCM_CCGR82_TOG			0x0000452c
#define CCM_CCGR83			0x00004530
#define CCM_CCGR83_SET			0x00004534
#define CCM_CCGR83_CLR			0x00004538
#define CCM_CCGR83_TOG			0x0000453c
#define CCM_CCGR84			0x00004540
#define CCM_CCGR84_SET			0x00004544
#define CCM_CCGR84_CLR			0x00004548
#define CCM_CCGR84_TOG			0x0000454c
#define CCM_CCGR85			0x00004550
#define CCM_CCGR85_SET			0x00004554
#define CCM_CCGR85_CLR			0x00004558
#define CCM_CCGR85_TOG			0x0000455c
#define CCM_CCGR86			0x00004560
#define CCM_CCGR86_SET			0x00004564
#define CCM_CCGR86_CLR			0x00004568
#define CCM_CCGR86_TOG			0x0000456c
#define CCM_CCGR87			0x00004570
#define CCM_CCGR87_SET			0x00004574
#define CCM_CCGR87_CLR			0x00004578
#define CCM_CCGR87_TOG			0x0000457c
#define CCM_CCGR88			0x00004580
#define CCM_CCGR88_SET			0x00004584
#define CCM_CCGR88_CLR			0x00004588
#define CCM_CCGR88_TOG			0x0000458c
#define CCM_CCGR89			0x00004590
#define CCM_CCGR89_SET			0x00004594
#define CCM_CCGR89_CLR			0x00004598
#define CCM_CCGR89_TOG			0x0000459c
#define CCM_CCGR90			0x000045a0
#define CCM_CCGR90_SET			0x000045a4
#define CCM_CCGR90_CLR			0x000045a8
#define CCM_CCGR90_TOG			0x000045ac
#define CCM_CCGR91			0x000045b0
#define CCM_CCGR91_SET			0x000045b4
#define CCM_CCGR91_CLR			0x000045b8
#define CCM_CCGR91_TOG			0x000045bc
#define CCM_CCGR92			0x000045c0
#define CCM_CCGR92_SET			0x000045c4
#define CCM_CCGR92_CLR			0x000045c8
#define CCM_CCGR92_TOG			0x000045cc
#define CCM_CCGR93			0x000045d0
#define CCM_CCGR93_SET			0x000045d4
#define CCM_CCGR93_CLR			0x000045d8
#define CCM_CCGR93_TOG			0x000045dc
#define CCM_CCGR94			0x000045e0
#define CCM_CCGR94_SET			0x000045e4
#define CCM_CCGR94_CLR			0x000045e8
#define CCM_CCGR94_TOG			0x000045ec
#define CCM_CCGR95			0x000045f0
#define CCM_CCGR95_SET			0x000045f4
#define CCM_CCGR95_CLR			0x000045f8
#define CCM_CCGR95_TOG			0x000045fc
#define CCM_CCGR96			0x00004600
#define CCM_CCGR96_SET			0x00004604
#define CCM_CCGR96_CLR			0x00004608
#define CCM_CCGR96_TOG			0x0000460c
#define CCM_CCGR97			0x00004610
#define CCM_CCGR97_SET			0x00004614
#define CCM_CCGR97_CLR			0x00004618
#define CCM_CCGR97_TOG			0x0000461c
#define CCM_CCGR98			0x00004620
#define CCM_CCGR98_SET			0x00004624
#define CCM_CCGR98_CLR			0x00004628
#define CCM_CCGR98_TOG			0x0000462c
#define CCM_CCGR99			0x00004630
#define CCM_CCGR99_SET			0x00004634
#define CCM_CCGR99_CLR			0x00004638
#define CCM_CCGR99_TOG			0x0000463c
#define CCM_CCGR100			0x00004640
#define CCM_CCGR100_SET			0x00004644
#define CCM_CCGR100_CLR			0x00004648
#define CCM_CCGR100_TOG			0x0000464c
#define CCM_CCGR101			0x00004650
#define CCM_CCGR101_SET			0x00004654
#define CCM_CCGR101_CLR			0x00004658
#define CCM_CCGR101_TOG			0x0000465c
#define CCM_CCGR102			0x00004660
#define CCM_CCGR102_SET			0x00004664
#define CCM_CCGR102_CLR			0x00004668
#define CCM_CCGR102_TOG			0x0000466c
#define CCM_CCGR103			0x00004670
#define CCM_CCGR103_SET			0x00004674
#define CCM_CCGR103_CLR			0x00004678
#define CCM_CCGR103_TOG			0x0000467c
#define CCM_CCGR104			0x00004680
#define CCM_CCGR104_SET			0x00004684
#define CCM_CCGR104_CLR			0x00004688
#define CCM_CCGR104_TOG			0x0000468c
#define CCM_CCGR105			0x00004690
#define CCM_CCGR105_SET			0x00004694
#define CCM_CCGR105_CLR			0x00004698
#define CCM_CCGR105_TOG			0x0000469c
#define CCM_CCGR106			0x000046a0
#define CCM_CCGR106_SET			0x000046a4
#define CCM_CCGR106_CLR			0x000046a8
#define CCM_CCGR106_TOG			0x000046ac
#define CCM_CCGR107			0x000046b0
#define CCM_CCGR107_SET			0x000046b4
#define CCM_CCGR107_CLR			0x000046b8
#define CCM_CCGR107_TOG			0x000046bc
#define CCM_CCGR108			0x000046c0
#define CCM_CCGR108_SET			0x000046c4
#define CCM_CCGR108_CLR			0x000046c8
#define CCM_CCGR108_TOG			0x000046cc
#define CCM_CCGR109			0x000046d0
#define CCM_CCGR109_SET			0x000046d4
#define CCM_CCGR109_CLR			0x000046d8
#define CCM_CCGR109_TOG			0x000046dc
#define CCM_CCGR110			0x000046e0
#define CCM_CCGR110_SET			0x000046e4
#define CCM_CCGR110_CLR			0x000046e8
#define CCM_CCGR110_TOG			0x000046ec
#define CCM_CCGR111			0x000046f0
#define CCM_CCGR111_SET			0x000046f4
#define CCM_CCGR111_CLR			0x000046f8
#define CCM_CCGR111_TOG			0x000046fc
#define CCM_CCGR112			0x00004700
#define CCM_CCGR112_SET			0x00004704
#define CCM_CCGR112_CLR			0x00004708
#define CCM_CCGR112_TOG			0x0000470c
#define CCM_CCGR113			0x00004710
#define CCM_CCGR113_SET			0x00004714
#define CCM_CCGR113_CLR			0x00004718
#define CCM_CCGR113_TOG			0x0000471c
#define CCM_CCGR114			0x00004720
#define CCM_CCGR114_SET			0x00004724
#define CCM_CCGR114_CLR			0x00004728
#define CCM_CCGR114_TOG			0x0000472c
#define CCM_CCGR115			0x00004730
#define CCM_CCGR115_SET			0x00004734
#define CCM_CCGR115_CLR			0x00004738
#define CCM_CCGR115_TOG			0x0000473c
#define CCM_CCGR116			0x00004740
#define CCM_CCGR116_SET			0x00004744
#define CCM_CCGR116_CLR			0x00004748
#define CCM_CCGR116_TOG			0x0000474c
#define CCM_CCGR117			0x00004750
#define CCM_CCGR117_SET			0x00004754
#define CCM_CCGR117_CLR			0x00004758
#define CCM_CCGR117_TOG			0x0000475c
#define CCM_CCGR118			0x00004760
#define CCM_CCGR118_SET			0x00004764
#define CCM_CCGR118_CLR			0x00004768
#define CCM_CCGR118_TOG			0x0000476c
#define CCM_CCGR119			0x00004770
#define CCM_CCGR119_SET			0x00004774
#define CCM_CCGR119_CLR			0x00004778
#define CCM_CCGR119_TOG			0x0000477c
#define CCM_CCGR120			0x00004780
#define CCM_CCGR120_SET			0x00004784
#define CCM_CCGR120_CLR			0x00004788
#define CCM_CCGR120_TOG			0x0000478c
#define CCM_CCGR121			0x00004790
#define CCM_CCGR121_SET			0x00004794
#define CCM_CCGR121_CLR			0x00004798
#define CCM_CCGR121_TOG			0x0000479c
#define CCM_CCGR122			0x000047a0
#define CCM_CCGR122_SET			0x000047a4
#define CCM_CCGR122_CLR			0x000047a8
#define CCM_CCGR122_TOG			0x000047ac
#define CCM_CCGR123			0x000047b0
#define CCM_CCGR123_SET			0x000047b4
#define CCM_CCGR123_CLR			0x000047b8
#define CCM_CCGR123_TOG			0x000047bc
#define CCM_CCGR124			0x000047c0
#define CCM_CCGR124_SET			0x000047c4
#define CCM_CCGR124_CLR			0x000047c8
#define CCM_CCGR124_TOG			0x000047cc
#define CCM_CCGR125			0x000047d0
#define CCM_CCGR125_SET			0x000047d4
#define CCM_CCGR125_CLR			0x000047d8
#define CCM_CCGR125_TOG			0x000047dc
#define CCM_CCGR126			0x000047e0
#define CCM_CCGR126_SET			0x000047e4
#define CCM_CCGR126_CLR			0x000047e8
#define CCM_CCGR126_TOG			0x000047ec
#define CCM_CCGR127			0x000047f0
#define CCM_CCGR127_SET			0x000047f4
#define CCM_CCGR127_CLR			0x000047f8
#define CCM_CCGR127_TOG			0x000047fc
#define CCM_CCGR128			0x00004800
#define CCM_CCGR128_SET			0x00004804
#define CCM_CCGR128_CLR			0x00004808
#define CCM_CCGR128_TOG			0x0000480c
#define CCM_CCGR129			0x00004810
#define CCM_CCGR129_SET			0x00004814
#define CCM_CCGR129_CLR			0x00004818
#define CCM_CCGR129_TOG			0x0000481c
#define CCM_CCGR130			0x00004820
#define CCM_CCGR130_SET			0x00004824
#define CCM_CCGR130_CLR			0x00004828
#define CCM_CCGR130_TOG			0x0000482c
#define CCM_CCGR131			0x00004830
#define CCM_CCGR131_SET			0x00004834
#define CCM_CCGR131_CLR			0x00004838
#define CCM_CCGR131_TOG			0x0000483c
#define CCM_CCGR132			0x00004840
#define CCM_CCGR132_SET			0x00004844
#define CCM_CCGR132_CLR			0x00004848
#define CCM_CCGR132_TOG			0x0000484c
#define CCM_CCGR133			0x00004850
#define CCM_CCGR133_SET			0x00004854
#define CCM_CCGR133_CLR			0x00004858
#define CCM_CCGR133_TOG			0x0000485c
#define CCM_CCGR134			0x00004860
#define CCM_CCGR134_SET			0x00004864
#define CCM_CCGR134_CLR			0x00004868
#define CCM_CCGR134_TOG			0x0000486c
#define CCM_CCGR135			0x00004870
#define CCM_CCGR135_SET			0x00004874
#define CCM_CCGR135_CLR			0x00004878
#define CCM_CCGR135_TOG			0x0000487c
#define CCM_CCGR136			0x00004880
#define CCM_CCGR136_SET			0x00004884
#define CCM_CCGR136_CLR			0x00004888
#define CCM_CCGR136_TOG			0x0000488c
#define CCM_CCGR137			0x00004890
#define CCM_CCGR137_SET			0x00004894
#define CCM_CCGR137_CLR			0x00004898
#define CCM_CCGR137_TOG			0x0000489c
#define CCM_CCGR138			0x000048a0
#define CCM_CCGR138_SET			0x000048a4
#define CCM_CCGR138_CLR			0x000048a8
#define CCM_CCGR138_TOG			0x000048ac
#define CCM_CCGR139			0x000048b0
#define CCM_CCGR139_SET			0x000048b4
#define CCM_CCGR139_CLR			0x000048b8
#define CCM_CCGR139_TOG			0x000048bc
#define CCM_CCGR140			0x000048c0
#define CCM_CCGR140_SET			0x000048c4
#define CCM_CCGR140_CLR			0x000048c8
#define CCM_CCGR140_TOG			0x000048cc
#define CCM_CCGR141			0x000048d0
#define CCM_CCGR141_SET			0x000048d4
#define CCM_CCGR141_CLR			0x000048d8
#define CCM_CCGR141_TOG			0x000048dc
#define CCM_CCGR142			0x000048e0
#define CCM_CCGR142_SET			0x000048e4
#define CCM_CCGR142_CLR			0x000048e8
#define CCM_CCGR142_TOG			0x000048ec
#define CCM_CCGR143			0x000048f0
#define CCM_CCGR143_SET			0x000048f4
#define CCM_CCGR143_CLR			0x000048f8
#define CCM_CCGR143_TOG			0x000048fc
#define CCM_CCGR144			0x00004900
#define CCM_CCGR144_SET			0x00004904
#define CCM_CCGR144_CLR			0x00004908
#define CCM_CCGR144_TOG			0x0000490c
#define CCM_CCGR145			0x00004910
#define CCM_CCGR145_SET			0x00004914
#define CCM_CCGR145_CLR			0x00004918
#define CCM_CCGR145_TOG			0x0000491c
#define CCM_CCGR146			0x00004920
#define CCM_CCGR146_SET			0x00004924
#define CCM_CCGR146_CLR			0x00004928
#define CCM_CCGR146_TOG			0x0000492c
#define CCM_CCGR147			0x00004930
#define CCM_CCGR147_SET			0x00004934
#define CCM_CCGR147_CLR			0x00004938
#define CCM_CCGR147_TOG			0x0000493c
#define CCM_CCGR148			0x00004940
#define CCM_CCGR148_SET			0x00004944
#define CCM_CCGR148_CLR			0x00004948
#define CCM_CCGR148_TOG			0x0000494c
#define CCM_CCGR149			0x00004950
#define CCM_CCGR149_SET			0x00004954
#define CCM_CCGR149_CLR			0x00004958
#define CCM_CCGR149_TOG			0x0000495c
#define CCM_CCGR150			0x00004960
#define CCM_CCGR150_SET			0x00004964
#define CCM_CCGR150_CLR			0x00004968
#define CCM_CCGR150_TOG			0x0000496c
#define CCM_CCGR151			0x00004970
#define CCM_CCGR151_SET			0x00004974
#define CCM_CCGR151_CLR			0x00004978
#define CCM_CCGR151_TOG			0x0000497c
#define CCM_CCGR152			0x00004980
#define CCM_CCGR152_SET			0x00004984
#define CCM_CCGR152_CLR			0x00004988
#define CCM_CCGR152_TOG			0x0000498c
#define CCM_CCGR153			0x00004990
#define CCM_CCGR153_SET			0x00004994
#define CCM_CCGR153_CLR			0x00004998
#define CCM_CCGR153_TOG			0x0000499c
#define CCM_CCGR154			0x000049a0
#define CCM_CCGR154_SET			0x000049a4
#define CCM_CCGR154_CLR			0x000049a8
#define CCM_CCGR154_TOG			0x000049ac
#define CCM_CCGR155			0x000049b0
#define CCM_CCGR155_SET			0x000049b4
#define CCM_CCGR155_CLR			0x000049b8
#define CCM_CCGR155_TOG			0x000049bc
#define CCM_CCGR156			0x000049c0
#define CCM_CCGR156_SET			0x000049c4
#define CCM_CCGR156_CLR			0x000049c8
#define CCM_CCGR156_TOG			0x000049cc
#define CCM_CCGR157			0x000049d0
#define CCM_CCGR157_SET			0x000049d4
#define CCM_CCGR157_CLR			0x000049d8
#define CCM_CCGR157_TOG			0x000049dc
#define CCM_CCGR158			0x000049e0
#define CCM_CCGR158_SET			0x000049e4
#define CCM_CCGR158_CLR			0x000049e8
#define CCM_CCGR158_TOG			0x000049ec
#define CCM_CCGR159			0x000049f0
#define CCM_CCGR159_SET			0x000049f4
#define CCM_CCGR159_CLR			0x000049f8
#define CCM_CCGR159_TOG			0x000049fc
#define CCM_CCGR160			0x00004a00
#define CCM_CCGR160_SET			0x00004a04
#define CCM_CCGR160_CLR			0x00004a08
#define CCM_CCGR160_TOG			0x00004a0c
#define CCM_CCGR161			0x00004a10
#define CCM_CCGR161_SET			0x00004a14
#define CCM_CCGR161_CLR			0x00004a18
#define CCM_CCGR161_TOG			0x00004a1c
#define CCM_CCGR162			0x00004a20
#define CCM_CCGR162_SET			0x00004a24
#define CCM_CCGR162_CLR			0x00004a28
#define CCM_CCGR162_TOG			0x00004a2c
#define CCM_CCGR163			0x00004a30
#define CCM_CCGR163_SET			0x00004a34
#define CCM_CCGR163_CLR			0x00004a38
#define CCM_CCGR163_TOG			0x00004a3c
#define CCM_CCGR164			0x00004a40
#define CCM_CCGR164_SET			0x00004a44
#define CCM_CCGR164_CLR			0x00004a48
#define CCM_CCGR164_TOG			0x00004a4c
#define CCM_CCGR165			0x00004a50
#define CCM_CCGR165_SET			0x00004a54
#define CCM_CCGR165_CLR			0x00004a58
#define CCM_CCGR165_TOG			0x00004a5c
#define CCM_CCGR166			0x00004a60
#define CCM_CCGR166_SET			0x00004a64
#define CCM_CCGR166_CLR			0x00004a68
#define CCM_CCGR166_TOG			0x00004a6c
#define CCM_CCGR167			0x00004a70
#define CCM_CCGR167_SET			0x00004a74
#define CCM_CCGR167_CLR			0x00004a78
#define CCM_CCGR167_TOG			0x00004a7c
#define CCM_CCGR168			0x00004a80
#define CCM_CCGR168_SET			0x00004a84
#define CCM_CCGR168_CLR			0x00004a88
#define CCM_CCGR168_TOG			0x00004a8c
#define CCM_CCGR169			0x00004a90
#define CCM_CCGR169_SET			0x00004a94
#define CCM_CCGR169_CLR			0x00004a98
#define CCM_CCGR169_TOG			0x00004a9c
#define CCM_CCGR170			0x00004aa0
#define CCM_CCGR170_SET			0x00004aa4
#define CCM_CCGR170_CLR			0x00004aa8
#define CCM_CCGR170_TOG			0x00004aac
#define CCM_CCGR171			0x00004ab0
#define CCM_CCGR171_SET			0x00004ab4
#define CCM_CCGR171_CLR			0x00004ab8
#define CCM_CCGR171_TOG			0x00004abc
#define CCM_CCGR172			0x00004ac0
#define CCM_CCGR172_SET			0x00004ac4
#define CCM_CCGR172_CLR			0x00004ac8
#define CCM_CCGR172_TOG			0x00004acc
#define CCM_CCGR173			0x00004ad0
#define CCM_CCGR173_SET			0x00004ad4
#define CCM_CCGR173_CLR			0x00004ad8
#define CCM_CCGR173_TOG			0x00004adc
#define CCM_CCGR174			0x00004ae0
#define CCM_CCGR174_SET			0x00004ae4
#define CCM_CCGR174_CLR			0x00004ae8
#define CCM_CCGR174_TOG			0x00004aec
#define CCM_CCGR175			0x00004af0
#define CCM_CCGR175_SET			0x00004af4
#define CCM_CCGR175_CLR			0x00004af8
#define CCM_CCGR175_TOG			0x00004afc
#define CCM_CCGR176			0x00004b00
#define CCM_CCGR176_SET			0x00004b04
#define CCM_CCGR176_CLR			0x00004b08
#define CCM_CCGR176_TOG			0x00004b0c
#define CCM_CCGR177			0x00004b10
#define CCM_CCGR177_SET			0x00004b14
#define CCM_CCGR177_CLR			0x00004b18
#define CCM_CCGR177_TOG			0x00004b1c
#define CCM_CCGR178			0x00004b20
#define CCM_CCGR178_SET			0x00004b24
#define CCM_CCGR178_CLR			0x00004b28
#define CCM_CCGR178_TOG			0x00004b2c
#define CCM_CCGR179			0x00004b30
#define CCM_CCGR179_SET			0x00004b34
#define CCM_CCGR179_CLR			0x00004b38
#define CCM_CCGR179_TOG			0x00004b3c
#define CCM_CCGR180			0x00004b40
#define CCM_CCGR180_SET			0x00004b44
#define CCM_CCGR180_CLR			0x00004b48
#define CCM_CCGR180_TOG			0x00004b4c
#define CCM_CCGR181			0x00004b50
#define CCM_CCGR181_SET			0x00004b54
#define CCM_CCGR181_CLR			0x00004b58
#define CCM_CCGR181_TOG			0x00004b5c
#define CCM_CCGR182			0x00004b60
#define CCM_CCGR182_SET			0x00004b64
#define CCM_CCGR182_CLR			0x00004b68
#define CCM_CCGR182_TOG			0x00004b6c
#define CCM_CCGR183			0x00004b70
#define CCM_CCGR183_SET			0x00004b74
#define CCM_CCGR183_CLR			0x00004b78
#define CCM_CCGR183_TOG			0x00004b7c
#define CCM_CCGR184			0x00004b80
#define CCM_CCGR184_SET			0x00004b84
#define CCM_CCGR184_CLR			0x00004b88
#define CCM_CCGR184_TOG			0x00004b8c
#define CCM_CCGR185			0x00004b90
#define CCM_CCGR185_SET			0x00004b94
#define CCM_CCGR185_CLR			0x00004b98
#define CCM_CCGR185_TOG			0x00004b9c
#define CCM_CCGR186			0x00004ba0
#define CCM_CCGR186_SET			0x00004ba4
#define CCM_CCGR186_CLR			0x00004ba8
#define CCM_CCGR186_TOG			0x00004bac
#define CCM_CCGR187			0x00004bb0
#define CCM_CCGR187_SET			0x00004bb4
#define CCM_CCGR187_CLR			0x00004bb8
#define CCM_CCGR187_TOG			0x00004bbc
#define CCM_CCGR188			0x00004bc0
#define CCM_CCGR188_SET			0x00004bc4
#define CCM_CCGR188_CLR			0x00004bc8
#define CCM_CCGR188_TOG			0x00004bcc
#define CCM_CCGR189			0x00004bd0
#define CCM_CCGR189_SET			0x00004bd4
#define CCM_CCGR189_CLR			0x00004bd8
#define CCM_CCGR189_TOG			0x00004bdc
#define CCM_CCGR190			0x00004be0
#define CCM_CCGR190_SET			0x00004be4
#define CCM_CCGR190_CLR			0x00004be8
#define CCM_CCGR190_TOG			0x00004bec

/* CCGR mapping */
#define CCM_CCGR_M4			CCM_CCGR1
#define CCM_CCGR_M4_SET			(CCM_CCGR_M4 + 4)
#define CCM_CCGR_M4_CLR			(CCM_CCGR_M4 + 8)
#define CCM_CCGR_M4_TOG			(CCM_CCGR_M4 + 12)
#define CCM_CCGR_SIM_MAIN		CCM_CCGR4
#define CCM_CCGR_SIM_MAIN_SET		(CCM_CCGR_SIM_MAIN + 4)
#define CCM_CCGR_SIM_MAIN_CLR		(CCM_CCGR_SIM_MAIN + 8)
#define CCM_CCGR_SIM_MAIN_TOG		(CCM_CCGR_SIM_MAIN + 12)
#define CCM_CCGR_SIM_DISPLAY		CCM_CCGR5
#define CCM_CCGR_SIM_DISPLAY_SET	(CCM_CCGR_SIM_DISPLAY + 4)
#define CCM_CCGR_SIM_DISPLAY_CLR	(CCM_CCGR_SIM_DISPLAY + 8)
#define CCM_CCGR_SIM_DISPLAY_TOG	(CCM_CCGR_SIM_DISPLAY + 12)
#define CCM_CCGR_SIM_ENET		CCM_CCGR6
#define CCM_CCGR_SIM_ENET_SET		(CCM_CCGR_SIM_ENET + 4)
#define CCM_CCGR_SIM_ENET_CLR		(CCM_CCGR_SIM_ENET + 8)
#define CCM_CCGR_SIM_ENET_TOG		(CCM_CCGR_SIM_ENET + 12)
#define CCM_CCGR_SIM_M			CCM_CCGR7
#define CCM_CCGR_SIM_M_SET		(CCM_CCGR_SIM_M + 4)
#define CCM_CCGR_SIM_M_CLR		(CCM_CCGR_SIM_M + 8)
#define CCM_CCGR_SIM_M_TOG		(CCM_CCGR_SIM_M + 12)
#define CCM_CCGR_SIM_S			CCM_CCGR8
#define CCM_CCGR_SIM_S_SET		(CCM_CCGR_SIM_S + 4)
#define CCM_CCGR_SIM_S_CLR		(CCM_CCGR_SIM_S + 8)
#define CCM_CCGR_SIM_S_TOG		(CCM_CCGR_SIM_S + 12)
#define CCM_CCGR_SIM_WAKEUP		CCM_CCGR9
#define CCM_CCGR_SIM_WAKEUP_SET		(CCM_CCGR_SIM_WAKEUP + 4)
#define CCM_CCGR_SIM_WAKEUP_CLR		(CCM_CCGR_SIM_WAKEUP + 8)
#define CCM_CCGR_SIM_WAKEUP_TOG		(CCM_CCGR_SIM_WAKEUP + 12)
#define CCM_CCGR_IPMUX1			CCM_CCGR10
#define CCM_CCGR_IPMUX1_SET		(CCM_CCGR_IPMUX1 + 4)
#define CCM_CCGR_IPMUX1_CLR		(CCM_CCGR_IPMUX1 + 8)
#define CCM_CCGR_IPMUX1_TOG		(CCM_CCGR_IPMUX1 + 12)
#define CCM_CCGR_IPMUX2			CCM_CCGR11
#define CCM_CCGR_IPMUX2_SET		(CCM_CCGR_IPMUX2 + 4)
#define CCM_CCGR_IPMUX2_CLR		(CCM_CCGR_IPMUX2 + 8)
#define CCM_CCGR_IPMUX2_TOG		(CCM_CCGR_IPMUX2 + 12)
#define CCM_CCGR_IPMUX3			CCM_CCGR12
#define CCM_CCGR_IPMUX3_SET		(CCM_CCGR_IPMUX3 + 4)
#define CCM_CCGR_IPMUX3_CLR		(CCM_CCGR_IPMUX3 + 8)
#define CCM_CCGR_IPMUX3_TOG		(CCM_CCGR_IPMUX3 + 12)
#define CCM_CCGR_ROM			CCM_CCGR16
#define CCM_CCGR_ROM_SET		(CCM_CCGR_ROM + 4)
#define CCM_CCGR_ROM_CLR		(CCM_CCGR_ROM + 8)
#define CCM_CCGR_ROM_TOG		(CCM_CCGR_ROM + 12)
#define CCM_CCGR_OCRAM			CCM_CCGR17
#define CCM_CCGR_OCRAM_SET		(CCM_CCGR_OCRAM + 4)
#define CCM_CCGR_OCRAM_CLR		(CCM_CCGR_OCRAM + 8)
#define CCM_CCGR_OCRAM_TOG		(CCM_CCGR_OCRAM + 12)
#define CCM_CCGR_OCRAM_S		CCM_CCGR18
#define CCM_CCGR_OCRAM_S_SET		(CCM_CCGR_OCRAM_S + 4)
#define CCM_CCGR_OCRAM_S_CLR		(CCM_CCGR_OCRAM_S + 8)
#define CCM_CCGR_OCRAM_S_TOG		(CCM_CCGR_OCRAM_S + 12)
#define CCM_CCGR_DRAM			CCM_CCGR19
#define CCM_CCGR_DRAM_SET		(CCM_CCGR_DRAM + 4)
#define CCM_CCGR_DRAM_CLR		(CCM_CCGR_DRAM + 8)
#define CCM_CCGR_DRAM_TOG		(CCM_CCGR_DRAM + 12)
#define CCM_CCGR_RAWNAND		CCM_CCGR20
#define CCM_CCGR_RAWNAND_SET		(CCM_CCGR_RAWNAND + 4)
#define CCM_CCGR_RAWNAND_CLR		(CCM_CCGR_RAWNAND + 8)
#define CCM_CCGR_RAWNAND_TOG		(CCM_CCGR_RAWNAND + 12)
#define CCM_CCGR_QSPI			CCM_CCGR21
#define CCM_CCGR_QSPI_SET		(CCM_CCGR_QSPI + 4)
#define CCM_CCGR_QSPI_CLR		(CCM_CCGR_QSPI + 8)
#define CCM_CCGR_QSPI_TOG		(CCM_CCGR_QSPI + 12)
#define CCM_CCGR_EIM			CCM_CCGR22
#define CCM_CCGR_EIM_SET		(CCM_CCGR_EIM + 4)
#define CCM_CCGR_EIM_CLR		(CCM_CCGR_EIM + 8)
#define CCM_CCGR_EIM_TOG		(CCM_CCGR_EIM + 12)
#define CCM_CCGR_ADC			CCM_CCGR32
#define CCM_CCGR_ADC_SET		(CCM_CCGR_ADC + 4)
#define CCM_CCGR_ADC_CLR		(CCM_CCGR_ADC + 8)
#define CCM_CCGR_ADC_TOG		(CCM_CCGR_ADC + 12)
#define CCM_CCGR_MU			CCM_CCGR39
#define CCM_CCGR_MU_SET			(CCM_CCGR_MU + 4)
#define CCM_CCGR_MU_CLR			(CCM_CCGR_MU + 8)
#define CCM_CCGR_MU_TOG			(CCM_CCGR_MU + 12)
#define CCM_CCGR_HS			CCM_CCGR40
#define CCM_CCGR_HS_SET			(CCM_CCGR_HS + 4)
#define CCM_CCGR_HS_CLR			(CCM_CCGR_HS + 8)
#define CCM_CCGR_HS_TOG			(CCM_CCGR_HS + 12)
#define CCM_CCGR_DVFS			CCM_CCGR41
#define CCM_CCGR_DVFS_SET		(CCM_CCGR_DVFS + 4)
#define CCM_CCGR_DVFS_CLR		(CCM_CCGR_DVFS + 8)
#define CCM_CCGR_DVFS_TOG		(CCM_CCGR_DVFS + 12)
#define CCM_CCGR_SEMA1			CCM_CCGR64
#define CCM_CCGR_SEMA1_SET		(CCM_CCGR_SEMA1 + 4)
#define CCM_CCGR_SEMA1_CLR		(CCM_CCGR_SEMA1 + 8)
#define CCM_CCGR_SEMA1_TOG		(CCM_CCGR_SEMA1 + 12)
#define CCM_CCGR_SEMA2			CCM_CCGR65
#define CCM_CCGR_SEMA2_SET		(CCM_CCGR_SEMA2 + 4)
#define CCM_CCGR_SEMA2_CLR		(CCM_CCGR_SEMA2 + 8)
#define CCM_CCGR_SEMA2_TOG		(CCM_CCGR_SEMA2 + 12)
#define CCM_CCGR_PERFMON1		CCM_CCGR68
#define CCM_CCGR_PERFMON1_SET		(CCM_CCGR_PERFMON1 + 4)
#define CCM_CCGR_PERFMON1_CLR		(CCM_CCGR_PERFMON1 + 8)
#define CCM_CCGR_PERFMON1_TOG		(CCM_CCGR_PERFMON1 + 12)
#define CCM_CCGR_PERFMON2		CCM_CCGR69
#define CCM_CCGR_PERFMON2_SET		(CCM_CCGR_PERFMON2 + 4)
#define CCM_CCGR_PERFMON2_CLR		(CCM_CCGR_PERFMON2 + 8)
#define CCM_CCGR_PERFMON2_TOG		(CCM_CCGR_PERFMON2 + 12)
#define CCM_CCGR_SDMA			CCM_CCGR72
#define CCM_CCGR_SDMA_SET		(CCM_CCGR_SDMA + 4)
#define CCM_CCGR_SDMA_CLR		(CCM_CCGR_SDMA + 8)
#define CCM_CCGR_SDMA_TOG		(CCM_CCGR_SDMA + 12)
#define CCM_CCGR_CSI			CCM_CCGR73
#define CCM_CCGR_CSI_SET		(CCM_CCGR_CSI + 4)
#define CCM_CCGR_CSI_CLR		(CCM_CCGR_CSI + 8)
#define CCM_CCGR_CSI_TOG		(CCM_CCGR_CSI + 12)
#define CCM_CCGR_LCDIF			CCM_CCGR75
#define CCM_CCGR_LCDIF_SET		(CCM_CCGR_LCDIF + 4)
#define CCM_CCGR_LCDIF_CLR		(CCM_CCGR_LCDIF + 8)
#define CCM_CCGR_LCDIF_TOG		(CCM_CCGR_LCDIF + 12)
#define CCM_CCGR_PCIE			CCM_CCGR96
#define CCM_CCGR_PCIE_SET		(CCM_CCGR_PCIE + 4)
#define CCM_CCGR_PCIE_CLR		(CCM_CCGR_PCIE + 8)
#define CCM_CCGR_PCIE_TOG		(CCM_CCGR_PCIE + 12)
#define CCM_CCGR_MIPI_CSI		CCM_CCGR100
#define CCM_CCGR_MIPI_CSI_SET		(CCM_CCGR_MIPI_CSI + 4)
#define CCM_CCGR_MIPI_CSI_CLR		(CCM_CCGR_MIPI_CSI + 8)
#define CCM_CCGR_MIPI_CSI_TOG		(CCM_CCGR_MIPI_CSI + 12)
#define CCM_CCGR_MIPI_DSI		CCM_CCGR101
#define CCM_CCGR_MIPI_DSI_SET		(CCM_CCGR_MIPI_DSI + 4)
#define CCM_CCGR_MIPI_DSI_CLR		(CCM_CCGR_MIPI_DSI + 8)
#define CCM_CCGR_MIPI_DSI_TOG		(CCM_CCGR_MIPI_DSI + 12)
#define CCM_CCGR_MIPI_MEM_PHY		CCM_CCGR102
#define CCM_CCGR_MIPI_MEM_PHY_SET	(CCM_CCGR_MIPI_MEM_PHY + 4)
#define CCM_CCGR_MIPI_MEM_PHY_CLR	(CCM_CCGR_MIPI_MEM_PHY + 8)
#define CCM_CCGR_MIPI_MEM_PHY_TOG	(CCM_CCGR_MIPI_MEM_PHY + 12)
#define CCM_CCGR_USB_CTRL		CCM_CCGR104
#define CCM_CCGR_USB_CTRL_SET		(CCM_CCGR_USB_CTRL + 4)
#define CCM_CCGR_USB_CTRL_CLR		(CCM_CCGR_USB_CTRL + 8)
#define CCM_CCGR_USB_CTRL_TOG		(CCM_CCGR_USB_CTRL + 12)
#define CCM_CCGR_USB_HSIC		CCM_CCGR105
#define CCM_CCGR_USB_HSIC_SET		(CCM_CCGR_USB_HSIC + 4)
#define CCM_CCGR_USB_HSIC_CLR		(CCM_CCGR_USB_HSIC + 8)
#define CCM_CCGR_USB_HSIC_TOG		(CCM_CCGR_USB_HSIC + 12)
#define CCM_CCGR_USB_PHY1		CCM_CCGR106
#define CCM_CCGR_USB_PHY1_SET		(CCM_CCGR_USB_PHY1 + 4)
#define CCM_CCGR_USB_PHY1_CLR		(CCM_CCGR_USB_PHY1 + 8)
#define CCM_CCGR_USB_PHY1_TOG		(CCM_CCGR_USB_PHY1 + 12)
#define CCM_CCGR_USB_PHY2		CCM_CCGR107
#define CCM_CCGR_USB_PHY2_SET		(CCM_CCGR_USB_PHY2 + 4)
#define CCM_CCGR_USB_PHY2_CLR		(CCM_CCGR_USB_PHY2 + 8)
#define CCM_CCGR_USB_PHY2_TOG		(CCM_CCGR_USB_PHY2 + 12)
#define CCM_CCGR_USDHC1			CCM_CCGR108
#define CCM_CCGR_USDHC1_SET		(CCM_CCGR_USDHC1 + 4)
#define CCM_CCGR_USDHC1_CLR		(CCM_CCGR_USDHC1 + 8)
#define CCM_CCGR_USDHC1_TOG		(CCM_CCGR_USDHC1 + 12)
#define CCM_CCGR_USDHC2			CCM_CCGR109
#define CCM_CCGR_USDHC2_SET		(CCM_CCGR_USDHC2 + 4)
#define CCM_CCGR_USDHC2_CLR		(CCM_CCGR_USDHC2 + 8)
#define CCM_CCGR_USDHC2_TOG		(CCM_CCGR_USDHC2 + 12)
#define CCM_CCGR_USDHC3			CCM_CCGR110
#define CCM_CCGR_USDHC3_SET		(CCM_CCGR_USDHC3 + 4)
#define CCM_CCGR_USDHC3_CLR		(CCM_CCGR_USDHC3 + 8)
#define CCM_CCGR_USDHC3_TOG		(CCM_CCGR_USDHC3 + 12)
#define CCM_CCGR_ENET1			CCM_CCGR112
#define CCM_CCGR_ENET1_SET		(CCM_CCGR_ENET1 + 4)
#define CCM_CCGR_ENET1_CLR		(CCM_CCGR_ENET1 + 8)
#define CCM_CCGR_ENET1_TOG		(CCM_CCGR_ENET1 + 12)
#define CCM_CCGR_ENET2			CCM_CCGR113
#define CCM_CCGR_ENET2_SET		(CCM_CCGR_ENET2 + 4)
#define CCM_CCGR_ENET2_CLR		(CCM_CCGR_ENET2 + 8)
#define CCM_CCGR_ENET2_TOG		(CCM_CCGR_ENET2 + 12)
#define CCM_CCGR_CAN1			CCM_CCGR116
#define CCM_CCGR_CAN1_SET		(CCM_CCGR_CAN1 + 4)
#define CCM_CCGR_CAN1_CLR		(CCM_CCGR_CAN1 + 8)
#define CCM_CCGR_CAN1_TOG		(CCM_CCGR_CAN1 + 12)
#define CCM_CCGR_CAN2			CCM_CCGR117
#define CCM_CCGR_CAN2_SET		(CCM_CCGR_CAN2 + 4)
#define CCM_CCGR_CAN2_CLR		(CCM_CCGR_CAN2 + 8)
#define CCM_CCGR_CAN2_TOG		(CCM_CCGR_CAN2 + 12)
#define CCM_CCGR_ECSPI1			CCM_CCGR120
#define CCM_CCGR_ECSPI1_SET		(CCM_CCGR_ECSPI1 + 4)
#define CCM_CCGR_ECSPI1_CLR		(CCM_CCGR_ECSPI1 + 8)
#define CCM_CCGR_ECSPI1_TOG		(CCM_CCGR_ECSPI1 + 12)
#define CCM_CCGR_ECSPI2			CCM_CCGR121
#define CCM_CCGR_ECSPI2_SET		(CCM_CCGR_ECSPI2 + 4)
#define CCM_CCGR_ECSPI2_CLR		(CCM_CCGR_ECSPI2 + 8)
#define CCM_CCGR_ECSPI2_TOG		(CCM_CCGR_ECSPI2 + 12)
#define CCM_CCGR_ECSPI3			CCM_CCGR122
#define CCM_CCGR_ECSPI3_SET		(CCM_CCGR_ECSPI3 + 4)
#define CCM_CCGR_ECSPI3_CLR		(CCM_CCGR_ECSPI3 + 8)
#define CCM_CCGR_ECSPI3_TOG		(CCM_CCGR_ECSPI3 + 12)
#define CCM_CCGR_ECSPI4			CCM_CCGR123
#define CCM_CCGR_ECSPI4_SET		(CCM_CCGR_ECSPI4 + 4)
#define CCM_CCGR_ECSPI4_CLR		(CCM_CCGR_ECSPI4 + 8)
#define CCM_CCGR_ECSPI4_TOG		(CCM_CCGR_ECSPI4 + 12)
#define CCM_CCGR_GPT3			CCM_CCGR126
#define CCM_CCGR_GPT3_SET		(CCM_CCGR_GPT3 + 4)
#define CCM_CCGR_GPT3_CLR		(CCM_CCGR_GPT3 + 8)
#define CCM_CCGR_GPT3_TOG		(CCM_CCGR_GPT3 + 12)
#define CCM_CCGR_GPT4			CCM_CCGR127
#define CCM_CCGR_GPT4_SET		(CCM_CCGR_GPT4 + 4)
#define CCM_CCGR_GPT4_CLR		(CCM_CCGR_GPT4 + 8)
#define CCM_CCGR_GPT4_TOG		(CCM_CCGR_GPT4 + 12)
#define CCM_CCGR_FTM1			CCM_CCGR128
#define CCM_CCGR_FTM1_SET		(CCM_CCGR_FTM1 + 4)
#define CCM_CCGR_FTM1_CLR		(CCM_CCGR_FTM1 + 8)
#define CCM_CCGR_FTM1_TOG		(CCM_CCGR_FTM1 + 12)
#define CCM_CCGR_FTM2			CCM_CCGR129
#define CCM_CCGR_FTM2_SET		(CCM_CCGR_FTM2 + 4)
#define CCM_CCGR_FTM2_CLR		(CCM_CCGR_FTM2 + 8)
#define CCM_CCGR_FTM2_TOG		(CCM_CCGR_FTM2 + 12)
#define CCM_CCGR_PWM1			CCM_CCGR132
#define CCM_CCGR_PWM1_SET		(CCM_CCGR_PWM1 + 4)
#define CCM_CCGR_PWM1_CLR		(CCM_CCGR_PWM1 + 8)
#define CCM_CCGR_PWM1_TOG		(CCM_CCGR_PWM1 + 12)
#define CCM_CCGR_PWM2			CCM_CCGR133
#define CCM_CCGR_PWM2_SET		(CCM_CCGR_PWM2 + 4)
#define CCM_CCGR_PWM2_CLR		(CCM_CCGR_PWM2 + 8)
#define CCM_CCGR_PWM2_TOG		(CCM_CCGR_PWM2 + 12)
#define CCM_CCGR_PWM3			CCM_CCGR134
#define CCM_CCGR_PWM3_SET		(CCM_CCGR_PWM3 + 4)
#define CCM_CCGR_PWM3_CLR		(CCM_CCGR_PWM3 + 8)
#define CCM_CCGR_PWM3_TOG		(CCM_CCGR_PWM3 + 12)
#define CCM_CCGR_PWM4			CCM_CCGR135
#define CCM_CCGR_PWM4_SET		(CCM_CCGR_PWM4 + 4)
#define CCM_CCGR_PWM4_CLR		(CCM_CCGR_PWM4 + 8)
#define CCM_CCGR_PWM4_TOG		(CCM_CCGR_PWM4 + 12)
#define CCM_CCGR_I2C1			CCM_CCGR136
#define CCM_CCGR_I2C1_SET		(CCM_CCGR_I2C1 + 4)
#define CCM_CCGR_I2C1_CLR		(CCM_CCGR_I2C1 + 8)
#define CCM_CCGR_I2C1_TOG		(CCM_CCGR_I2C1 + 12)
#define CCM_CCGR_I2C2			CCM_CCGR137
#define CCM_CCGR_I2C2_SET		(CCM_CCGR_I2C2 + 4)
#define CCM_CCGR_I2C2_CLR		(CCM_CCGR_I2C2 + 8)
#define CCM_CCGR_I2C2_TOG		(CCM_CCGR_I2C2 + 12)
#define CCM_CCGR_I2C3			CCM_CCGR138
#define CCM_CCGR_I2C3_SET		(CCM_CCGR_I2C3 + 4)
#define CCM_CCGR_I2C3_CLR		(CCM_CCGR_I2C3 + 8)
#define CCM_CCGR_I2C3_TOG		(CCM_CCGR_I2C3 + 12)
#define CCM_CCGR_I2C4			CCM_CCGR139
#define CCM_CCGR_I2C4_SET		(CCM_CCGR_I2C4 + 4)
#define CCM_CCGR_I2C4_CLR		(CCM_CCGR_I2C4 + 8)
#define CCM_CCGR_I2C4_TOG		(CCM_CCGR_I2C4 + 12)
#define CCM_CCGR_SAI1			CCM_CCGR140
#define CCM_CCGR_SAI1_SET		(CCM_CCGR_SAI1 + 4)
#define CCM_CCGR_SAI1_CLR		(CCM_CCGR_SAI1 + 8)
#define CCM_CCGR_SAI1_TOG		(CCM_CCGR_SAI1 + 12)
#define CCM_CCGR_SAI2			CCM_CCGR141
#define CCM_CCGR_SAI2_SET		(CCM_CCGR_SAI2 + 4)
#define CCM_CCGR_SAI2_CLR		(CCM_CCGR_SAI2 + 8)
#define CCM_CCGR_SAI2_TOG		(CCM_CCGR_SAI2 + 12)
#define CCM_CCGR_SAI3			CCM_CCGR142
#define CCM_CCGR_SAI3_SET		(CCM_CCGR_SAI3 + 4)
#define CCM_CCGR_SAI3_CLR		(CCM_CCGR_SAI3 + 8)
#define CCM_CCGR_SAI3_TOG		(CCM_CCGR_SAI3 + 12)
#define CCM_CCGR_SIM1			CCM_CCGR144
#define CCM_CCGR_SIM1_SET		(CCM_CCGR_SIM1 + 4)
#define CCM_CCGR_SIM1_CLR		(CCM_CCGR_SIM1 + 8)
#define CCM_CCGR_SIM1_TOG		(CCM_CCGR_SIM1 + 12)
#define CCM_CCGR_SIM2			CCM_CCGR145
#define CCM_CCGR_SIM2_SET		(CCM_CCGR_SIM2 + 4)
#define CCM_CCGR_SIM2_CLR		(CCM_CCGR_SIM2 + 8)
#define CCM_CCGR_SIM2_TOG		(CCM_CCGR_SIM2 + 12)
#define CCM_CCGR_UART1			CCM_CCGR148
#define CCM_CCGR_UART1_SET		(CCM_CCGR_UART1 + 4)
#define CCM_CCGR_UART1_CLR		(CCM_CCGR_UART1 + 8)
#define CCM_CCGR_UART1_TOG		(CCM_CCGR_UART1 + 12)
#define CCM_CCGR_UART2			CCM_CCGR149
#define CCM_CCGR_UART2_SET		(CCM_CCGR_UART2 + 4)
#define CCM_CCGR_UART2_CLR		(CCM_CCGR_UART2 + 8)
#define CCM_CCGR_UART2_TOG		(CCM_CCGR_UART2 + 12)
#define CCM_CCGR_UART3			CCM_CCGR150
#define CCM_CCGR_UART3_SET		(CCM_CCGR_UART3 + 4)
#define CCM_CCGR_UART3_CLR		(CCM_CCGR_UART3 + 8)
#define CCM_CCGR_UART3_TOG		(CCM_CCGR_UART3 + 12)
#define CCM_CCGR_UART4			CCM_CCGR151
#define CCM_CCGR_UART4_SET		(CCM_CCGR_UART4 + 4)
#define CCM_CCGR_UART4_CLR		(CCM_CCGR_UART4 + 8)
#define CCM_CCGR_UART4_TOG		(CCM_CCGR_UART4 + 12)
#define CCM_CCGR_UART5			CCM_CCGR152
#define CCM_CCGR_UART5_SET		(CCM_CCGR_UART5 + 4)
#define CCM_CCGR_UART5_CLR		(CCM_CCGR_UART5 + 8)
#define CCM_CCGR_UART5_TOG		(CCM_CCGR_UART5 + 12)
#define CCM_CCGR_UART6			CCM_CCGR153
#define CCM_CCGR_UART6_SET		(CCM_CCGR_UART6 + 4)
#define CCM_CCGR_UART6_CLR		(CCM_CCGR_UART6 + 8)
#define CCM_CCGR_UART6_TOG		(CCM_CCGR_UART6 + 12)
#define CCM_CCGR_UART7			CCM_CCGR154
#define CCM_CCGR_UART7_SET		(CCM_CCGR_UART7 + 4)
#define CCM_CCGR_UART7_CLR		(CCM_CCGR_UART7 + 8)
#define CCM_CCGR_UART7_TOG		(CCM_CCGR_UART7 + 12)
#define CCM_CCGR_WDOG2			CCM_CCGR157
#define CCM_CCGR_WDOG2_SET		(CCM_CCGR_WDOG2 + 4)
#define CCM_CCGR_WDOG2_CLR		(CCM_CCGR_WDOG2 + 8)
#define CCM_CCGR_WDOG2_TOG		(CCM_CCGR_WDOG2 + 12)
#define CCM_CCGR_WDOG3			CCM_CCGR158
#define CCM_CCGR_WDOG3_SET		(CCM_CCGR_WDOG3 + 4)
#define CCM_CCGR_WDOG3_CLR		(CCM_CCGR_WDOG3 + 8)
#define CCM_CCGR_WDOG3_TOG		(CCM_CCGR_WDOG3 + 12)
#define CCM_CCGR_WDOG4			CCM_CCGR159
#define CCM_CCGR_WDOG4_SET		(CCM_CCGR_WDOG4 + 4)
#define CCM_CCGR_WDOG4_CLR		(CCM_CCGR_WDOG4 + 8)
#define CCM_CCGR_WDOG4_TOG		(CCM_CCGR_WDOG4 + 12)
#define CCM_CCGR_KPP			CCM_CCGR170
#define CCM_CCGR_KPP_SET		(CCM_CCGR_KPP + 4)
#define CCM_CCGR_KPP_CLR		(CCM_CCGR_KPP + 8)
#define CCM_CCGR_KPP_TOG		(CCM_CCGR_KPP + 12)

/* Target/Miscellaneous/PostDivider/PreDivider/AccessControl Register */
#define CCM_TARGET_ROOT0		0x00008000
#define CCM_TARGET_ROOT0_SET		0x00008004
#define CCM_TARGET_ROOT0_CLR		0x00008008
#define CCM_TARGET_ROOT0_TOG		0x0000800c
#define  CCM_TARGET_ROOT_ENABLE		__BIT(28)
#define  CCM_TARGET_ROOT_MUX		__BITS(26, 24)
#define  CCM_TARGET_ROOT_PRE_PODF	__BITS(18, 16)
#define  CCM_TARGET_ROOT_POST_PODF	__BITS(5, 0)
#define  CCM_TARGET_ROOT_AUTO_ENABLE	__BIT(12)	/* from uboot */
#define  CCM_TARGET_ROOT_AUTO_PODF	__BITS(10, 8)	/* from uboot */
#define CCM_MISC0			0x00008010
#define CCM_MISC0_SET			0x00008014
#define CCM_MISC0_CLR			0x00008018
#define CCM_MISC0_TOG			0x0000801c
#define CCM_POST0			0x00008020
#define CCM_POST0_SET			0x00008024
#define CCM_POST0_CLR			0x00008028
#define CCM_POST0_TOG			0x0000802c
#define  CCM_POST_SELECT		__BIT(28)
#define  CCM_POST_POST_PODF		__BITS(5, 0)
#define CCM_PRE0			0x00008030
#define CCM_PRE0_SET			0x00008034
#define CCM_PRE0_CLR			0x00008038
#define CCM_PRE0_TOG			0x0000803c
#define  CCM_PRE_EN_A			__BIT(28)
#define  CCM_PRE_MUX_A			__BITS(26, 24)
#define  CCM_PRE_PRE_PODF_A		__BITS(18, 16)
#define  CCM_PRE_EN_B			__BIT(12)
#define  CCM_PRE_MUX_B			__BITS(10, 8)
#define  CCM_PRE_PRE_PODF_B		__BITS(2, 0)
#define CCM_ACCESS_CTRL0		0x00008070
#define CCM_ACCESS_CTRL0_SET		0x00008074
#define CCM_ACCESS_CTRL0_CLR		0x00008078
#define CCM_ACCESS_CTRL0_TOG		0x0000807c
#define CCM_TARGET_ROOT1		0x00008080
#define CCM_TARGET_ROOT1_SET		0x00008084
#define CCM_TARGET_ROOT1_CLR		0x00008088
#define CCM_TARGET_ROOT1_TOG		0x0000808c
#define CCM_MISC1			0x00008090
#define CCM_MISC1_SET			0x00008094
#define CCM_MISC1_CLR			0x00008098
#define CCM_MISC1_TOG			0x0000809c
#define CCM_POST1			0x000080a0
#define CCM_POST1_SET			0x000080a4
#define CCM_POST1_CLR			0x000080a8
#define CCM_POST1_TOG			0x000080ac
#define CCM_PRE1			0x000080b0
#define CCM_PRE1_SET			0x000080b4
#define CCM_PRE1_CLR			0x000080b8
#define CCM_PRE1_TOG			0x000080bc
#define CCM_ACCESS_CTRL1		0x000080f0
#define CCM_ACCESS_CTRL1_SET		0x000080f4
#define CCM_ACCESS_CTRL1_CLR		0x000080f8
#define CCM_ACCESS_CTRL1_TOG		0x000080fc
#define CCM_TARGET_ROOT2		0x00008100
#define CCM_TARGET_ROOT2_SET		0x00008104
#define CCM_TARGET_ROOT2_CLR		0x00008108
#define CCM_TARGET_ROOT2_TOG		0x0000810c
#define CCM_MISC2			0x00008110
#define CCM_MISC2_SET			0x00008114
#define CCM_MISC2_CLR			0x00008118
#define CCM_MISC2_TOG			0x0000811c
#define CCM_POST2			0x00008120
#define CCM_POST2_SET			0x00008124
#define CCM_POST2_CLR			0x00008128
#define CCM_POST2_TOG			0x0000812c
#define CCM_PRE2			0x00008130
#define CCM_PRE2_SET			0x00008134
#define CCM_PRE2_CLR			0x00008138
#define CCM_PRE2_TOG			0x0000813c
#define CCM_ACCESS_CTRL2		0x00008170
#define CCM_ACCESS_CTRL2_SET		0x00008174
#define CCM_ACCESS_CTRL2_CLR		0x00008178
#define CCM_ACCESS_CTRL2_TOG		0x0000817c
#define CCM_TARGET_ROOT3		0x00008180
#define CCM_TARGET_ROOT3_SET		0x00008184
#define CCM_TARGET_ROOT3_CLR		0x00008188
#define CCM_TARGET_ROOT3_TOG		0x0000818c
#define CCM_MISC3			0x00008190
#define CCM_MISC3_SET			0x00008194
#define CCM_MISC3_CLR			0x00008198
#define CCM_MISC3_TOG			0x0000819c
#define CCM_POST3			0x000081a0
#define CCM_POST3_SET			0x000081a4
#define CCM_POST3_CLR			0x000081a8
#define CCM_POST3_TOG			0x000081ac
#define CCM_PRE3			0x000081b0
#define CCM_PRE3_SET			0x000081b4
#define CCM_PRE3_CLR			0x000081b8
#define CCM_PRE3_TOG			0x000081bc
#define CCM_ACCESS_CTRL3		0x000081f0
#define CCM_ACCESS_CTRL3_SET		0x000081f4
#define CCM_ACCESS_CTRL3_CLR		0x000081f8
#define CCM_ACCESS_CTRL3_TOG		0x000081fc
#define CCM_TARGET_ROOT4		0x00008200
#define CCM_TARGET_ROOT4_SET		0x00008204
#define CCM_TARGET_ROOT4_CLR		0x00008208
#define CCM_TARGET_ROOT4_TOG		0x0000820c
#define CCM_MISC4			0x00008210
#define CCM_MISC4_SET			0x00008214
#define CCM_MISC4_CLR			0x00008218
#define CCM_MISC4_TOG			0x0000821c
#define CCM_POST4			0x00008220
#define CCM_POST4_SET			0x00008224
#define CCM_POST4_CLR			0x00008228
#define CCM_POST4_TOG			0x0000822c
#define CCM_PRE4			0x00008230
#define CCM_PRE4_SET			0x00008234
#define CCM_PRE4_CLR			0x00008238
#define CCM_PRE4_TOG			0x0000823c
#define CCM_ACCESS_CTRL4		0x00008270
#define CCM_ACCESS_CTRL4_SET		0x00008274
#define CCM_ACCESS_CTRL4_CLR		0x00008278
#define CCM_ACCESS_CTRL4_TOG		0x0000827c
#define CCM_TARGET_ROOT5		0x00008280
#define CCM_TARGET_ROOT5_SET		0x00008284
#define CCM_TARGET_ROOT5_CLR		0x00008288
#define CCM_TARGET_ROOT5_TOG		0x0000828c
#define CCM_MISC5			0x00008290
#define CCM_MISC5_SET			0x00008294
#define CCM_MISC5_CLR			0x00008298
#define CCM_MISC5_TOG			0x0000829c
#define CCM_POST5			0x000082a0
#define CCM_POST5_SET			0x000082a4
#define CCM_POST5_CLR			0x000082a8
#define CCM_POST5_TOG			0x000082ac
#define CCM_PRE5			0x000082b0
#define CCM_PRE5_SET			0x000082b4
#define CCM_PRE5_CLR			0x000082b8
#define CCM_PRE5_TOG			0x000082bc
#define CCM_ACCESS_CTRL5		0x000082f0
#define CCM_ACCESS_CTRL5_SET		0x000082f4
#define CCM_ACCESS_CTRL5_CLR		0x000082f8
#define CCM_ACCESS_CTRL5_TOG		0x000082fc
#define CCM_TARGET_ROOT6		0x00008300
#define CCM_TARGET_ROOT6_SET		0x00008304
#define CCM_TARGET_ROOT6_CLR		0x00008308
#define CCM_TARGET_ROOT6_TOG		0x0000830c
#define CCM_MISC6			0x00008310
#define CCM_MISC6_SET			0x00008314
#define CCM_MISC6_CLR			0x00008318
#define CCM_MISC6_TOG			0x0000831c
#define CCM_POST6			0x00008320
#define CCM_POST6_SET			0x00008324
#define CCM_POST6_CLR			0x00008328
#define CCM_POST6_TOG			0x0000832c
#define CCM_PRE6			0x00008330
#define CCM_PRE6_SET			0x00008334
#define CCM_PRE6_CLR			0x00008338
#define CCM_PRE6_TOG			0x0000833c
#define CCM_ACCESS_CTRL6		0x00008370
#define CCM_ACCESS_CTRL6_SET		0x00008374
#define CCM_ACCESS_CTRL6_CLR		0x00008378
#define CCM_ACCESS_CTRL6_TOG		0x0000837c
#define CCM_TARGET_ROOT7		0x00008380
#define CCM_TARGET_ROOT7_SET		0x00008384
#define CCM_TARGET_ROOT7_CLR		0x00008388
#define CCM_TARGET_ROOT7_TOG		0x0000838c
#define CCM_MISC7			0x00008390
#define CCM_MISC7_SET			0x00008394
#define CCM_MISC7_CLR			0x00008398
#define CCM_MISC7_TOG			0x0000839c
#define CCM_POST7			0x000083a0
#define CCM_POST7_SET			0x000083a4
#define CCM_POST7_CLR			0x000083a8
#define CCM_POST7_TOG			0x000083ac
#define CCM_PRE7			0x000083b0
#define CCM_PRE7_SET			0x000083b4
#define CCM_PRE7_CLR			0x000083b8
#define CCM_PRE7_TOG			0x000083bc
#define CCM_ACCESS_CTRL7		0x000083f0
#define CCM_ACCESS_CTRL7_SET		0x000083f4
#define CCM_ACCESS_CTRL7_CLR		0x000083f8
#define CCM_ACCESS_CTRL7_TOG		0x000083fc
#define CCM_TARGET_ROOT8		0x00008400
#define CCM_TARGET_ROOT8_SET		0x00008404
#define CCM_TARGET_ROOT8_CLR		0x00008408
#define CCM_TARGET_ROOT8_TOG		0x0000840c
#define CCM_MISC8			0x00008410
#define CCM_MISC8_SET			0x00008414
#define CCM_MISC8_CLR			0x00008418
#define CCM_MISC8_TOG			0x0000841c
#define CCM_POST8			0x00008420
#define CCM_POST8_SET			0x00008424
#define CCM_POST8_CLR			0x00008428
#define CCM_POST8_TOG			0x0000842c
#define CCM_PRE8			0x00008430
#define CCM_PRE8_SET			0x00008434
#define CCM_PRE8_CLR			0x00008438
#define CCM_PRE8_TOG			0x0000843c
#define CCM_ACCESS_CTRL8		0x00008470
#define CCM_ACCESS_CTRL8_SET		0x00008474
#define CCM_ACCESS_CTRL8_CLR		0x00008478
#define CCM_ACCESS_CTRL8_TOG		0x0000847c
#define CCM_TARGET_ROOT9		0x00008480
#define CCM_TARGET_ROOT9_SET		0x00008484
#define CCM_TARGET_ROOT9_CLR		0x00008488
#define CCM_TARGET_ROOT9_TOG		0x0000848c
#define CCM_MISC9			0x00008490
#define CCM_MISC9_SET			0x00008494
#define CCM_MISC9_CLR			0x00008498
#define CCM_MISC9_TOG			0x0000849c
#define CCM_POST9			0x000084a0
#define CCM_POST9_SET			0x000084a4
#define CCM_POST9_CLR			0x000084a8
#define CCM_POST9_TOG			0x000084ac
#define CCM_PRE9			0x000084b0
#define CCM_PRE9_SET			0x000084b4
#define CCM_PRE9_CLR			0x000084b8
#define CCM_PRE9_TOG			0x000084bc
#define CCM_ACCESS_CTRL9		0x000084f0
#define CCM_ACCESS_CTRL9_SET		0x000084f4
#define CCM_ACCESS_CTRL9_CLR		0x000084f8
#define CCM_ACCESS_CTRL9_TOG		0x000084fc
#define CCM_TARGET_ROOT10		0x00008500
#define CCM_TARGET_ROOT10_SET		0x00008504
#define CCM_TARGET_ROOT10_CLR		0x00008508
#define CCM_TARGET_ROOT10_TOG		0x0000850c
#define CCM_MISC10			0x00008510
#define CCM_MISC10_SET			0x00008514
#define CCM_MISC10_CLR			0x00008518
#define CCM_MISC10_TOG			0x0000851c
#define CCM_POST10			0x00008520
#define CCM_POST10_SET			0x00008524
#define CCM_POST10_CLR			0x00008528
#define CCM_POST10_TOG			0x0000852c
#define CCM_PRE10			0x00008530
#define CCM_PRE10_SET			0x00008534
#define CCM_PRE10_CLR			0x00008538
#define CCM_PRE10_TOG			0x0000853c
#define CCM_ACCESS_CTRL10		0x00008570
#define CCM_ACCESS_CTRL10_SET		0x00008574
#define CCM_ACCESS_CTRL10_CLR		0x00008578
#define CCM_ACCESS_CTRL10_TOG		0x0000857c
#define CCM_TARGET_ROOT11		0x00008580
#define CCM_TARGET_ROOT11_SET		0x00008584
#define CCM_TARGET_ROOT11_CLR		0x00008588
#define CCM_TARGET_ROOT11_TOG		0x0000858c
#define CCM_MISC11			0x00008590
#define CCM_MISC11_SET			0x00008594
#define CCM_MISC11_CLR			0x00008598
#define CCM_MISC11_TOG			0x0000859c
#define CCM_POST11			0x000085a0
#define CCM_POST11_SET			0x000085a4
#define CCM_POST11_CLR			0x000085a8
#define CCM_POST11_TOG			0x000085ac
#define CCM_PRE11			0x000085b0
#define CCM_PRE11_SET			0x000085b4
#define CCM_PRE11_CLR			0x000085b8
#define CCM_PRE11_TOG			0x000085bc
#define CCM_ACCESS_CTRL11		0x000085f0
#define CCM_ACCESS_CTRL11_SET		0x000085f4
#define CCM_ACCESS_CTRL11_CLR		0x000085f8
#define CCM_ACCESS_CTRL11_TOG		0x000085fc
#define CCM_TARGET_ROOT12		0x00008600
#define CCM_TARGET_ROOT12_SET		0x00008604
#define CCM_TARGET_ROOT12_CLR		0x00008608
#define CCM_TARGET_ROOT12_TOG		0x0000860c
#define CCM_MISC12			0x00008610
#define CCM_MISC12_SET			0x00008614
#define CCM_MISC12_CLR			0x00008618
#define CCM_MISC12_TOG			0x0000861c
#define CCM_POST12			0x00008620
#define CCM_POST12_SET			0x00008624
#define CCM_POST12_CLR			0x00008628
#define CCM_POST12_TOG			0x0000862c
#define CCM_PRE12			0x00008630
#define CCM_PRE12_SET			0x00008634
#define CCM_PRE12_CLR			0x00008638
#define CCM_PRE12_TOG			0x0000863c
#define CCM_ACCESS_CTRL12		0x00008670
#define CCM_ACCESS_CTRL12_SET		0x00008674
#define CCM_ACCESS_CTRL12_CLR		0x00008678
#define CCM_ACCESS_CTRL12_TOG		0x0000867c
#define CCM_TARGET_ROOT13		0x00008680
#define CCM_TARGET_ROOT13_SET		0x00008684
#define CCM_TARGET_ROOT13_CLR		0x00008688
#define CCM_TARGET_ROOT13_TOG		0x0000868c
#define CCM_MISC13			0x00008690
#define CCM_MISC13_SET			0x00008694
#define CCM_MISC13_CLR			0x00008698
#define CCM_MISC13_TOG			0x0000869c
#define CCM_POST13			0x000086a0
#define CCM_POST13_SET			0x000086a4
#define CCM_POST13_CLR			0x000086a8
#define CCM_POST13_TOG			0x000086ac
#define CCM_PRE13			0x000086b0
#define CCM_PRE13_SET			0x000086b4
#define CCM_PRE13_CLR			0x000086b8
#define CCM_PRE13_TOG			0x000086bc
#define CCM_ACCESS_CTRL13		0x000086f0
#define CCM_ACCESS_CTRL13_SET		0x000086f4
#define CCM_ACCESS_CTRL13_CLR		0x000086f8
#define CCM_ACCESS_CTRL13_TOG		0x000086fc
#define CCM_TARGET_ROOT14		0x00008700
#define CCM_TARGET_ROOT14_SET		0x00008704
#define CCM_TARGET_ROOT14_CLR		0x00008708
#define CCM_TARGET_ROOT14_TOG		0x0000870c
#define CCM_MISC14			0x00008710
#define CCM_MISC14_SET			0x00008714
#define CCM_MISC14_CLR			0x00008718
#define CCM_MISC14_TOG			0x0000871c
#define CCM_POST14			0x00008720
#define CCM_POST14_SET			0x00008724
#define CCM_POST14_CLR			0x00008728
#define CCM_POST14_TOG			0x0000872c
#define CCM_PRE14			0x00008730
#define CCM_PRE14_SET			0x00008734
#define CCM_PRE14_CLR			0x00008738
#define CCM_PRE14_TOG			0x0000873c
#define CCM_ACCESS_CTRL14		0x00008770
#define CCM_ACCESS_CTRL14_SET		0x00008774
#define CCM_ACCESS_CTRL14_CLR		0x00008778
#define CCM_ACCESS_CTRL14_TOG		0x0000877c
#define CCM_TARGET_ROOT15		0x00008780
#define CCM_TARGET_ROOT15_SET		0x00008784
#define CCM_TARGET_ROOT15_CLR		0x00008788
#define CCM_TARGET_ROOT15_TOG		0x0000878c
#define CCM_MISC15			0x00008790
#define CCM_MISC15_SET			0x00008794
#define CCM_MISC15_CLR			0x00008798
#define CCM_MISC15_TOG			0x0000879c
#define CCM_POST15			0x000087a0
#define CCM_POST15_SET			0x000087a4
#define CCM_POST15_CLR			0x000087a8
#define CCM_POST15_TOG			0x000087ac
#define CCM_PRE15			0x000087b0
#define CCM_PRE15_SET			0x000087b4
#define CCM_PRE15_CLR			0x000087b8
#define CCM_PRE15_TOG			0x000087bc
#define CCM_ACCESS_CTRL15		0x000087f0
#define CCM_ACCESS_CTRL15_SET		0x000087f4
#define CCM_ACCESS_CTRL15_CLR		0x000087f8
#define CCM_ACCESS_CTRL15_TOG		0x000087fc
#define CCM_TARGET_ROOT16		0x00008800
#define CCM_TARGET_ROOT16_SET		0x00008804
#define CCM_TARGET_ROOT16_CLR		0x00008808
#define CCM_TARGET_ROOT16_TOG		0x0000880c
#define CCM_MISC16			0x00008810
#define CCM_MISC16_SET			0x00008814
#define CCM_MISC16_CLR			0x00008818
#define CCM_MISC16_TOG			0x0000881c
#define CCM_POST16			0x00008820
#define CCM_POST16_SET			0x00008824
#define CCM_POST16_CLR			0x00008828
#define CCM_POST16_TOG			0x0000882c
#define CCM_PRE16			0x00008830
#define CCM_PRE16_SET			0x00008834
#define CCM_PRE16_CLR			0x00008838
#define CCM_PRE16_TOG			0x0000883c
#define CCM_ACCESS_CTRL16		0x00008870
#define CCM_ACCESS_CTRL16_SET		0x00008874
#define CCM_ACCESS_CTRL16_CLR		0x00008878
#define CCM_ACCESS_CTRL16_TOG		0x0000887c
#define CCM_TARGET_ROOT17		0x00008880
#define CCM_TARGET_ROOT17_SET		0x00008884
#define CCM_TARGET_ROOT17_CLR		0x00008888
#define CCM_TARGET_ROOT17_TOG		0x0000888c
#define CCM_MISC17			0x00008890
#define CCM_MISC17_SET			0x00008894
#define CCM_MISC17_CLR			0x00008898
#define CCM_MISC17_TOG			0x0000889c
#define CCM_POST17			0x000088a0
#define CCM_POST17_SET			0x000088a4
#define CCM_POST17_CLR			0x000088a8
#define CCM_POST17_TOG			0x000088ac
#define CCM_PRE17			0x000088b0
#define CCM_PRE17_SET			0x000088b4
#define CCM_PRE17_CLR			0x000088b8
#define CCM_PRE17_TOG			0x000088bc
#define CCM_ACCESS_CTRL17		0x000088f0
#define CCM_ACCESS_CTRL17_SET		0x000088f4
#define CCM_ACCESS_CTRL17_CLR		0x000088f8
#define CCM_ACCESS_CTRL17_TOG		0x000088fc
#define CCM_TARGET_ROOT18		0x00008900
#define CCM_TARGET_ROOT18_SET		0x00008904
#define CCM_TARGET_ROOT18_CLR		0x00008908
#define CCM_TARGET_ROOT18_TOG		0x0000890c
#define CCM_MISC18			0x00008910
#define CCM_MISC18_SET			0x00008914
#define CCM_MISC18_CLR			0x00008918
#define CCM_MISC18_TOG			0x0000891c
#define CCM_POST18			0x00008920
#define CCM_POST18_SET			0x00008924
#define CCM_POST18_CLR			0x00008928
#define CCM_POST18_TOG			0x0000892c
#define CCM_PRE18			0x00008930
#define CCM_PRE18_SET			0x00008934
#define CCM_PRE18_CLR			0x00008938
#define CCM_PRE18_TOG			0x0000893c
#define CCM_ACCESS_CTRL18		0x00008970
#define CCM_ACCESS_CTRL18_SET		0x00008974
#define CCM_ACCESS_CTRL18_CLR		0x00008978
#define CCM_ACCESS_CTRL18_TOG		0x0000897c
#define CCM_TARGET_ROOT19		0x00008980
#define CCM_TARGET_ROOT19_SET		0x00008984
#define CCM_TARGET_ROOT19_CLR		0x00008988
#define CCM_TARGET_ROOT19_TOG		0x0000898c
#define CCM_MISC19			0x00008990
#define CCM_MISC19_SET			0x00008994
#define CCM_MISC19_CLR			0x00008998
#define CCM_MISC19_TOG			0x0000899c
#define CCM_POST19			0x000089a0
#define CCM_POST19_SET			0x000089a4
#define CCM_POST19_CLR			0x000089a8
#define CCM_POST19_TOG			0x000089ac
#define CCM_PRE19			0x000089b0
#define CCM_PRE19_SET			0x000089b4
#define CCM_PRE19_CLR			0x000089b8
#define CCM_PRE19_TOG			0x000089bc
#define CCM_ACCESS_CTRL19		0x000089f0
#define CCM_ACCESS_CTRL19_SET		0x000089f4
#define CCM_ACCESS_CTRL19_CLR		0x000089f8
#define CCM_ACCESS_CTRL19_TOG		0x000089fc
#define CCM_TARGET_ROOT20		0x00008a00
#define CCM_TARGET_ROOT20_SET		0x00008a04
#define CCM_TARGET_ROOT20_CLR		0x00008a08
#define CCM_TARGET_ROOT20_TOG		0x00008a0c
#define CCM_MISC20			0x00008a10
#define CCM_MISC20_SET			0x00008a14
#define CCM_MISC20_CLR			0x00008a18
#define CCM_MISC20_TOG			0x00008a1c
#define CCM_POST20			0x00008a20
#define CCM_POST20_SET			0x00008a24
#define CCM_POST20_CLR			0x00008a28
#define CCM_POST20_TOG			0x00008a2c
#define CCM_PRE20			0x00008a30
#define CCM_PRE20_SET			0x00008a34
#define CCM_PRE20_CLR			0x00008a38
#define CCM_PRE20_TOG			0x00008a3c
#define CCM_ACCESS_CTRL20		0x00008a70
#define CCM_ACCESS_CTRL20_SET		0x00008a74
#define CCM_ACCESS_CTRL20_CLR		0x00008a78
#define CCM_ACCESS_CTRL20_TOG		0x00008a7c
#define CCM_TARGET_ROOT21		0x00008a80
#define CCM_TARGET_ROOT21_SET		0x00008a84
#define CCM_TARGET_ROOT21_CLR		0x00008a88
#define CCM_TARGET_ROOT21_TOG		0x00008a8c
#define CCM_MISC21			0x00008a90
#define CCM_MISC21_SET			0x00008a94
#define CCM_MISC21_CLR			0x00008a98
#define CCM_MISC21_TOG			0x00008a9c
#define CCM_POST21			0x00008aa0
#define CCM_POST21_SET			0x00008aa4
#define CCM_POST21_CLR			0x00008aa8
#define CCM_POST21_TOG			0x00008aac
#define CCM_PRE21			0x00008ab0
#define CCM_PRE21_SET			0x00008ab4
#define CCM_PRE21_CLR			0x00008ab8
#define CCM_PRE21_TOG			0x00008abc
#define CCM_ACCESS_CTRL21		0x00008af0
#define CCM_ACCESS_CTRL21_SET		0x00008af4
#define CCM_ACCESS_CTRL21_CLR		0x00008af8
#define CCM_ACCESS_CTRL21_TOG		0x00008afc
#define CCM_TARGET_ROOT22		0x00008b00
#define CCM_TARGET_ROOT22_SET		0x00008b04
#define CCM_TARGET_ROOT22_CLR		0x00008b08
#define CCM_TARGET_ROOT22_TOG		0x00008b0c
#define CCM_MISC22			0x00008b10
#define CCM_MISC22_SET			0x00008b14
#define CCM_MISC22_CLR			0x00008b18
#define CCM_MISC22_TOG			0x00008b1c
#define CCM_POST22			0x00008b20
#define CCM_POST22_SET			0x00008b24
#define CCM_POST22_CLR			0x00008b28
#define CCM_POST22_TOG			0x00008b2c
#define CCM_PRE22			0x00008b30
#define CCM_PRE22_SET			0x00008b34
#define CCM_PRE22_CLR			0x00008b38
#define CCM_PRE22_TOG			0x00008b3c
#define CCM_ACCESS_CTRL22		0x00008b70
#define CCM_ACCESS_CTRL22_SET		0x00008b74
#define CCM_ACCESS_CTRL22_CLR		0x00008b78
#define CCM_ACCESS_CTRL22_TOG		0x00008b7c
#define CCM_TARGET_ROOT23		0x00008b80
#define CCM_TARGET_ROOT23_SET		0x00008b84
#define CCM_TARGET_ROOT23_CLR		0x00008b88
#define CCM_TARGET_ROOT23_TOG		0x00008b8c
#define CCM_MISC23			0x00008b90
#define CCM_MISC23_SET			0x00008b94
#define CCM_MISC23_CLR			0x00008b98
#define CCM_MISC23_TOG			0x00008b9c
#define CCM_POST23			0x00008ba0
#define CCM_POST23_SET			0x00008ba4
#define CCM_POST23_CLR			0x00008ba8
#define CCM_POST23_TOG			0x00008bac
#define CCM_PRE23			0x00008bb0
#define CCM_PRE23_SET			0x00008bb4
#define CCM_PRE23_CLR			0x00008bb8
#define CCM_PRE23_TOG			0x00008bbc
#define CCM_ACCESS_CTRL23		0x00008bf0
#define CCM_ACCESS_CTRL23_SET		0x00008bf4
#define CCM_ACCESS_CTRL23_CLR		0x00008bf8
#define CCM_ACCESS_CTRL23_TOG		0x00008bfc
#define CCM_TARGET_ROOT24		0x00008c00
#define CCM_TARGET_ROOT24_SET		0x00008c04
#define CCM_TARGET_ROOT24_CLR		0x00008c08
#define CCM_TARGET_ROOT24_TOG		0x00008c0c
#define CCM_MISC24			0x00008c10
#define CCM_MISC24_SET			0x00008c14
#define CCM_MISC24_CLR			0x00008c18
#define CCM_MISC24_TOG			0x00008c1c
#define CCM_POST24			0x00008c20
#define CCM_POST24_SET			0x00008c24
#define CCM_POST24_CLR			0x00008c28
#define CCM_POST24_TOG			0x00008c2c
#define CCM_PRE24			0x00008c30
#define CCM_PRE24_SET			0x00008c34
#define CCM_PRE24_CLR			0x00008c38
#define CCM_PRE24_TOG			0x00008c3c
#define CCM_ACCESS_CTRL24		0x00008c70
#define CCM_ACCESS_CTRL24_SET		0x00008c74
#define CCM_ACCESS_CTRL24_CLR		0x00008c78
#define CCM_ACCESS_CTRL24_TOG		0x00008c7c
#define CCM_TARGET_ROOT25		0x00008c80
#define CCM_TARGET_ROOT25_SET		0x00008c84
#define CCM_TARGET_ROOT25_CLR		0x00008c88
#define CCM_TARGET_ROOT25_TOG		0x00008c8c
#define CCM_MISC25			0x00008c90
#define CCM_MISC25_SET			0x00008c94
#define CCM_MISC25_CLR			0x00008c98
#define CCM_MISC25_TOG			0x00008c9c
#define CCM_POST25			0x00008ca0
#define CCM_POST25_SET			0x00008ca4
#define CCM_POST25_CLR			0x00008ca8
#define CCM_POST25_TOG			0x00008cac
#define CCM_PRE25			0x00008cb0
#define CCM_PRE25_SET			0x00008cb4
#define CCM_PRE25_CLR			0x00008cb8
#define CCM_PRE25_TOG			0x00008cbc
#define CCM_ACCESS_CTRL25		0x00008cf0
#define CCM_ACCESS_CTRL25_SET		0x00008cf4
#define CCM_ACCESS_CTRL25_CLR		0x00008cf8
#define CCM_ACCESS_CTRL25_TOG		0x00008cfc
#define CCM_TARGET_ROOT26		0x00008d00
#define CCM_TARGET_ROOT26_SET		0x00008d04
#define CCM_TARGET_ROOT26_CLR		0x00008d08
#define CCM_TARGET_ROOT26_TOG		0x00008d0c
#define CCM_MISC26			0x00008d10
#define CCM_MISC26_SET			0x00008d14
#define CCM_MISC26_CLR			0x00008d18
#define CCM_MISC26_TOG			0x00008d1c
#define CCM_POST26			0x00008d20
#define CCM_POST26_SET			0x00008d24
#define CCM_POST26_CLR			0x00008d28
#define CCM_POST26_TOG			0x00008d2c
#define CCM_PRE26			0x00008d30
#define CCM_PRE26_SET			0x00008d34
#define CCM_PRE26_CLR			0x00008d38
#define CCM_PRE26_TOG			0x00008d3c
#define CCM_ACCESS_CTRL26		0x00008d70
#define CCM_ACCESS_CTRL26_SET		0x00008d74
#define CCM_ACCESS_CTRL26_CLR		0x00008d78
#define CCM_ACCESS_CTRL26_TOG		0x00008d7c
#define CCM_TARGET_ROOT27		0x00008d80
#define CCM_TARGET_ROOT27_SET		0x00008d84
#define CCM_TARGET_ROOT27_CLR		0x00008d88
#define CCM_TARGET_ROOT27_TOG		0x00008d8c
#define CCM_MISC27			0x00008d90
#define CCM_MISC27_SET			0x00008d94
#define CCM_MISC27_CLR			0x00008d98
#define CCM_MISC27_TOG			0x00008d9c
#define CCM_POST27			0x00008da0
#define CCM_POST27_SET			0x00008da4
#define CCM_POST27_CLR			0x00008da8
#define CCM_POST27_TOG			0x00008dac
#define CCM_PRE27			0x00008db0
#define CCM_PRE27_SET			0x00008db4
#define CCM_PRE27_CLR			0x00008db8
#define CCM_PRE27_TOG			0x00008dbc
#define CCM_ACCESS_CTRL27		0x00008df0
#define CCM_ACCESS_CTRL27_SET		0x00008df4
#define CCM_ACCESS_CTRL27_CLR		0x00008df8
#define CCM_ACCESS_CTRL27_TOG		0x00008dfc
#define CCM_TARGET_ROOT28		0x00008e00
#define CCM_TARGET_ROOT28_SET		0x00008e04
#define CCM_TARGET_ROOT28_CLR		0x00008e08
#define CCM_TARGET_ROOT28_TOG		0x00008e0c
#define CCM_MISC28			0x00008e10
#define CCM_MISC28_SET			0x00008e14
#define CCM_MISC28_CLR			0x00008e18
#define CCM_MISC28_TOG			0x00008e1c
#define CCM_POST28			0x00008e20
#define CCM_POST28_SET			0x00008e24
#define CCM_POST28_CLR			0x00008e28
#define CCM_POST28_TOG			0x00008e2c
#define CCM_PRE28			0x00008e30
#define CCM_PRE28_SET			0x00008e34
#define CCM_PRE28_CLR			0x00008e38
#define CCM_PRE28_TOG			0x00008e3c
#define CCM_ACCESS_CTRL28		0x00008e70
#define CCM_ACCESS_CTRL28_SET		0x00008e74
#define CCM_ACCESS_CTRL28_CLR		0x00008e78
#define CCM_ACCESS_CTRL28_TOG		0x00008e7c
#define CCM_TARGET_ROOT29		0x00008e80
#define CCM_TARGET_ROOT29_SET		0x00008e84
#define CCM_TARGET_ROOT29_CLR		0x00008e88
#define CCM_TARGET_ROOT29_TOG		0x00008e8c
#define CCM_MISC29			0x00008e90
#define CCM_MISC29_SET			0x00008e94
#define CCM_MISC29_CLR			0x00008e98
#define CCM_MISC29_TOG			0x00008e9c
#define CCM_POST29			0x00008ea0
#define CCM_POST29_SET			0x00008ea4
#define CCM_POST29_CLR			0x00008ea8
#define CCM_POST29_TOG			0x00008eac
#define CCM_PRE29			0x00008eb0
#define CCM_PRE29_SET			0x00008eb4
#define CCM_PRE29_CLR			0x00008eb8
#define CCM_PRE29_TOG			0x00008ebc
#define CCM_ACCESS_CTRL29		0x00008ef0
#define CCM_ACCESS_CTRL29_SET		0x00008ef4
#define CCM_ACCESS_CTRL29_CLR		0x00008ef8
#define CCM_ACCESS_CTRL29_TOG		0x00008efc
#define CCM_TARGET_ROOT30		0x00008f00
#define CCM_TARGET_ROOT30_SET		0x00008f04
#define CCM_TARGET_ROOT30_CLR		0x00008f08
#define CCM_TARGET_ROOT30_TOG		0x00008f0c
#define CCM_MISC30			0x00008f10
#define CCM_MISC30_SET			0x00008f14
#define CCM_MISC30_CLR			0x00008f18
#define CCM_MISC30_TOG			0x00008f1c
#define CCM_POST30			0x00008f20
#define CCM_POST30_SET			0x00008f24
#define CCM_POST30_CLR			0x00008f28
#define CCM_POST30_TOG			0x00008f2c
#define CCM_PRE30			0x00008f30
#define CCM_PRE30_SET			0x00008f34
#define CCM_PRE30_CLR			0x00008f38
#define CCM_PRE30_TOG			0x00008f3c
#define CCM_ACCESS_CTRL30		0x00008f70
#define CCM_ACCESS_CTRL30_SET		0x00008f74
#define CCM_ACCESS_CTRL30_CLR		0x00008f78
#define CCM_ACCESS_CTRL30_TOG		0x00008f7c
#define CCM_TARGET_ROOT31		0x00008f80
#define CCM_TARGET_ROOT31_SET		0x00008f84
#define CCM_TARGET_ROOT31_CLR		0x00008f88
#define CCM_TARGET_ROOT31_TOG		0x00008f8c
#define CCM_MISC31			0x00008f90
#define CCM_MISC31_SET			0x00008f94
#define CCM_MISC31_CLR			0x00008f98
#define CCM_MISC31_TOG			0x00008f9c
#define CCM_POST31			0x00008fa0
#define CCM_POST31_SET			0x00008fa4
#define CCM_POST31_CLR			0x00008fa8
#define CCM_POST31_TOG			0x00008fac
#define CCM_PRE31			0x00008fb0
#define CCM_PRE31_SET			0x00008fb4
#define CCM_PRE31_CLR			0x00008fb8
#define CCM_PRE31_TOG			0x00008fbc
#define CCM_ACCESS_CTRL31		0x00008ff0
#define CCM_ACCESS_CTRL31_SET		0x00008ff4
#define CCM_ACCESS_CTRL31_CLR		0x00008ff8
#define CCM_ACCESS_CTRL31_TOG		0x00008ffc
#define CCM_TARGET_ROOT32		0x00009000
#define CCM_TARGET_ROOT32_SET		0x00009004
#define CCM_TARGET_ROOT32_CLR		0x00009008
#define CCM_TARGET_ROOT32_TOG		0x0000900c
#define CCM_MISC32			0x00009010
#define CCM_MISC32_SET			0x00009014
#define CCM_MISC32_CLR			0x00009018
#define CCM_MISC32_TOG			0x0000901c
#define CCM_POST32			0x00009020
#define CCM_POST32_SET			0x00009024
#define CCM_POST32_CLR			0x00009028
#define CCM_POST32_TOG			0x0000902c
#define CCM_PRE32			0x00009030
#define CCM_PRE32_SET			0x00009034
#define CCM_PRE32_CLR			0x00009038
#define CCM_PRE32_TOG			0x0000903c
#define CCM_ACCESS_CTRL32		0x00009070
#define CCM_ACCESS_CTRL32_SET		0x00009074
#define CCM_ACCESS_CTRL32_CLR		0x00009078
#define CCM_ACCESS_CTRL32_TOG		0x0000907c
#define CCM_TARGET_ROOT33		0x00009080
#define CCM_TARGET_ROOT33_SET		0x00009084
#define CCM_TARGET_ROOT33_CLR		0x00009088
#define CCM_TARGET_ROOT33_TOG		0x0000908c
#define CCM_MISC33			0x00009090
#define CCM_MISC33_SET			0x00009094
#define CCM_MISC33_CLR			0x00009098
#define CCM_MISC33_TOG			0x0000909c
#define CCM_POST33			0x000090a0
#define CCM_POST33_SET			0x000090a4
#define CCM_POST33_CLR			0x000090a8
#define CCM_POST33_TOG			0x000090ac
#define CCM_PRE33			0x000090b0
#define CCM_PRE33_SET			0x000090b4
#define CCM_PRE33_CLR			0x000090b8
#define CCM_PRE33_TOG			0x000090bc
#define CCM_ACCESS_CTRL33		0x000090f0
#define CCM_ACCESS_CTRL33_SET		0x000090f4
#define CCM_ACCESS_CTRL33_CLR		0x000090f8
#define CCM_ACCESS_CTRL33_TOG		0x000090fc
#define CCM_TARGET_ROOT34		0x00009100
#define CCM_TARGET_ROOT34_SET		0x00009104
#define CCM_TARGET_ROOT34_CLR		0x00009108
#define CCM_TARGET_ROOT34_TOG		0x0000910c
#define CCM_MISC34			0x00009110
#define CCM_MISC34_SET			0x00009114
#define CCM_MISC34_CLR			0x00009118
#define CCM_MISC34_TOG			0x0000911c
#define CCM_POST34			0x00009120
#define CCM_POST34_SET			0x00009124
#define CCM_POST34_CLR			0x00009128
#define CCM_POST34_TOG			0x0000912c
#define CCM_PRE34			0x00009130
#define CCM_PRE34_SET			0x00009134
#define CCM_PRE34_CLR			0x00009138
#define CCM_PRE34_TOG			0x0000913c
#define CCM_ACCESS_CTRL34		0x00009170
#define CCM_ACCESS_CTRL34_SET		0x00009174
#define CCM_ACCESS_CTRL34_CLR		0x00009178
#define CCM_ACCESS_CTRL34_TOG		0x0000917c
#define CCM_TARGET_ROOT35		0x00009180
#define CCM_TARGET_ROOT35_SET		0x00009184
#define CCM_TARGET_ROOT35_CLR		0x00009188
#define CCM_TARGET_ROOT35_TOG		0x0000918c
#define CCM_MISC35			0x00009190
#define CCM_MISC35_SET			0x00009194
#define CCM_MISC35_CLR			0x00009198
#define CCM_MISC35_TOG			0x0000919c
#define CCM_POST35			0x000091a0
#define CCM_POST35_SET			0x000091a4
#define CCM_POST35_CLR			0x000091a8
#define CCM_POST35_TOG			0x000091ac
#define CCM_PRE35			0x000091b0
#define CCM_PRE35_SET			0x000091b4
#define CCM_PRE35_CLR			0x000091b8
#define CCM_PRE35_TOG			0x000091bc
#define CCM_ACCESS_CTRL35		0x000091f0
#define CCM_ACCESS_CTRL35_SET		0x000091f4
#define CCM_ACCESS_CTRL35_CLR		0x000091f8
#define CCM_ACCESS_CTRL35_TOG		0x000091fc
#define CCM_TARGET_ROOT36		0x00009200
#define CCM_TARGET_ROOT36_SET		0x00009204
#define CCM_TARGET_ROOT36_CLR		0x00009208
#define CCM_TARGET_ROOT36_TOG		0x0000920c
#define CCM_MISC36			0x00009210
#define CCM_MISC36_SET			0x00009214
#define CCM_MISC36_CLR			0x00009218
#define CCM_MISC36_TOG			0x0000921c
#define CCM_POST36			0x00009220
#define CCM_POST36_SET			0x00009224
#define CCM_POST36_CLR			0x00009228
#define CCM_POST36_TOG			0x0000922c
#define CCM_PRE36			0x00009230
#define CCM_PRE36_SET			0x00009234
#define CCM_PRE36_CLR			0x00009238
#define CCM_PRE36_TOG			0x0000923c
#define CCM_ACCESS_CTRL36		0x00009270
#define CCM_ACCESS_CTRL36_SET		0x00009274
#define CCM_ACCESS_CTRL36_CLR		0x00009278
#define CCM_ACCESS_CTRL36_TOG		0x0000927c
#define CCM_TARGET_ROOT37		0x00009280
#define CCM_TARGET_ROOT37_SET		0x00009284
#define CCM_TARGET_ROOT37_CLR		0x00009288
#define CCM_TARGET_ROOT37_TOG		0x0000928c
#define CCM_MISC37			0x00009290
#define CCM_MISC37_SET			0x00009294
#define CCM_MISC37_CLR			0x00009298
#define CCM_MISC37_TOG			0x0000929c
#define CCM_POST37			0x000092a0
#define CCM_POST37_SET			0x000092a4
#define CCM_POST37_CLR			0x000092a8
#define CCM_POST37_TOG			0x000092ac
#define CCM_PRE37			0x000092b0
#define CCM_PRE37_SET			0x000092b4
#define CCM_PRE37_CLR			0x000092b8
#define CCM_PRE37_TOG			0x000092bc
#define CCM_ACCESS_CTRL37		0x000092f0
#define CCM_ACCESS_CTRL37_SET		0x000092f4
#define CCM_ACCESS_CTRL37_CLR		0x000092f8
#define CCM_ACCESS_CTRL37_TOG		0x000092fc
#define CCM_TARGET_ROOT38		0x00009300
#define CCM_TARGET_ROOT38_SET		0x00009304
#define CCM_TARGET_ROOT38_CLR		0x00009308
#define CCM_TARGET_ROOT38_TOG		0x0000930c
#define CCM_MISC38			0x00009310
#define CCM_MISC38_SET			0x00009314
#define CCM_MISC38_CLR			0x00009318
#define CCM_MISC38_TOG			0x0000931c
#define CCM_POST38			0x00009320
#define CCM_POST38_SET			0x00009324
#define CCM_POST38_CLR			0x00009328
#define CCM_POST38_TOG			0x0000932c
#define CCM_PRE38			0x00009330
#define CCM_PRE38_SET			0x00009334
#define CCM_PRE38_CLR			0x00009338
#define CCM_PRE38_TOG			0x0000933c
#define CCM_ACCESS_CTRL38		0x00009370
#define CCM_ACCESS_CTRL38_SET		0x00009374
#define CCM_ACCESS_CTRL38_CLR		0x00009378
#define CCM_ACCESS_CTRL38_TOG		0x0000937c
#define CCM_TARGET_ROOT39		0x00009380
#define CCM_TARGET_ROOT39_SET		0x00009384
#define CCM_TARGET_ROOT39_CLR		0x00009388
#define CCM_TARGET_ROOT39_TOG		0x0000938c
#define CCM_MISC39			0x00009390
#define CCM_MISC39_SET			0x00009394
#define CCM_MISC39_CLR			0x00009398
#define CCM_MISC39_TOG			0x0000939c
#define CCM_POST39			0x000093a0
#define CCM_POST39_SET			0x000093a4
#define CCM_POST39_CLR			0x000093a8
#define CCM_POST39_TOG			0x000093ac
#define CCM_PRE39			0x000093b0
#define CCM_PRE39_SET			0x000093b4
#define CCM_PRE39_CLR			0x000093b8
#define CCM_PRE39_TOG			0x000093bc
#define CCM_ACCESS_CTRL39		0x000093f0
#define CCM_ACCESS_CTRL39_SET		0x000093f4
#define CCM_ACCESS_CTRL39_CLR		0x000093f8
#define CCM_ACCESS_CTRL39_TOG		0x000093fc
#define CCM_TARGET_ROOT40		0x00009400
#define CCM_TARGET_ROOT40_SET		0x00009404
#define CCM_TARGET_ROOT40_CLR		0x00009408
#define CCM_TARGET_ROOT40_TOG		0x0000940c
#define CCM_MISC40			0x00009410
#define CCM_MISC40_SET			0x00009414
#define CCM_MISC40_CLR			0x00009418
#define CCM_MISC40_TOG			0x0000941c
#define CCM_POST40			0x00009420
#define CCM_POST40_SET			0x00009424
#define CCM_POST40_CLR			0x00009428
#define CCM_POST40_TOG			0x0000942c
#define CCM_PRE40			0x00009430
#define CCM_PRE40_SET			0x00009434
#define CCM_PRE40_CLR			0x00009438
#define CCM_PRE40_TOG			0x0000943c
#define CCM_ACCESS_CTRL40		0x00009470
#define CCM_ACCESS_CTRL40_SET		0x00009474
#define CCM_ACCESS_CTRL40_CLR		0x00009478
#define CCM_ACCESS_CTRL40_TOG		0x0000947c
#define CCM_TARGET_ROOT41		0x00009480
#define CCM_TARGET_ROOT41_SET		0x00009484
#define CCM_TARGET_ROOT41_CLR		0x00009488
#define CCM_TARGET_ROOT41_TOG		0x0000948c
#define CCM_MISC41			0x00009490
#define CCM_MISC41_SET			0x00009494
#define CCM_MISC41_CLR			0x00009498
#define CCM_MISC41_TOG			0x0000949c
#define CCM_POST41			0x000094a0
#define CCM_POST41_SET			0x000094a4
#define CCM_POST41_CLR			0x000094a8
#define CCM_POST41_TOG			0x000094ac
#define CCM_PRE41			0x000094b0
#define CCM_PRE41_SET			0x000094b4
#define CCM_PRE41_CLR			0x000094b8
#define CCM_PRE41_TOG			0x000094bc
#define CCM_ACCESS_CTRL41		0x000094f0
#define CCM_ACCESS_CTRL41_SET		0x000094f4
#define CCM_ACCESS_CTRL41_CLR		0x000094f8
#define CCM_ACCESS_CTRL41_TOG		0x000094fc
#define CCM_TARGET_ROOT42		0x00009500
#define CCM_TARGET_ROOT42_SET		0x00009504
#define CCM_TARGET_ROOT42_CLR		0x00009508
#define CCM_TARGET_ROOT42_TOG		0x0000950c
#define CCM_MISC42			0x00009510
#define CCM_MISC42_SET			0x00009514
#define CCM_MISC42_CLR			0x00009518
#define CCM_MISC42_TOG			0x0000951c
#define CCM_POST42			0x00009520
#define CCM_POST42_SET			0x00009524
#define CCM_POST42_CLR			0x00009528
#define CCM_POST42_TOG			0x0000952c
#define CCM_PRE42			0x00009530
#define CCM_PRE42_SET			0x00009534
#define CCM_PRE42_CLR			0x00009538
#define CCM_PRE42_TOG			0x0000953c
#define CCM_ACCESS_CTRL42		0x00009570
#define CCM_ACCESS_CTRL42_SET		0x00009574
#define CCM_ACCESS_CTRL42_CLR		0x00009578
#define CCM_ACCESS_CTRL42_TOG		0x0000957c
#define CCM_TARGET_ROOT43		0x00009580
#define CCM_TARGET_ROOT43_SET		0x00009584
#define CCM_TARGET_ROOT43_CLR		0x00009588
#define CCM_TARGET_ROOT43_TOG		0x0000958c
#define CCM_MISC43			0x00009590
#define CCM_MISC43_SET			0x00009594
#define CCM_MISC43_CLR			0x00009598
#define CCM_MISC43_TOG			0x0000959c
#define CCM_POST43			0x000095a0
#define CCM_POST43_SET			0x000095a4
#define CCM_POST43_CLR			0x000095a8
#define CCM_POST43_TOG			0x000095ac
#define CCM_PRE43			0x000095b0
#define CCM_PRE43_SET			0x000095b4
#define CCM_PRE43_CLR			0x000095b8
#define CCM_PRE43_TOG			0x000095bc
#define CCM_ACCESS_CTRL43		0x000095f0
#define CCM_ACCESS_CTRL43_SET		0x000095f4
#define CCM_ACCESS_CTRL43_CLR		0x000095f8
#define CCM_ACCESS_CTRL43_TOG		0x000095fc
#define CCM_TARGET_ROOT44		0x00009600
#define CCM_TARGET_ROOT44_SET		0x00009604
#define CCM_TARGET_ROOT44_CLR		0x00009608
#define CCM_TARGET_ROOT44_TOG		0x0000960c
#define CCM_MISC44			0x00009610
#define CCM_MISC44_SET			0x00009614
#define CCM_MISC44_CLR			0x00009618
#define CCM_MISC44_TOG			0x0000961c
#define CCM_POST44			0x00009620
#define CCM_POST44_SET			0x00009624
#define CCM_POST44_CLR			0x00009628
#define CCM_POST44_TOG			0x0000962c
#define CCM_PRE44			0x00009630
#define CCM_PRE44_SET			0x00009634
#define CCM_PRE44_CLR			0x00009638
#define CCM_PRE44_TOG			0x0000963c
#define CCM_ACCESS_CTRL44		0x00009670
#define CCM_ACCESS_CTRL44_SET		0x00009674
#define CCM_ACCESS_CTRL44_CLR		0x00009678
#define CCM_ACCESS_CTRL44_TOG		0x0000967c
#define CCM_TARGET_ROOT45		0x00009680
#define CCM_TARGET_ROOT45_SET		0x00009684
#define CCM_TARGET_ROOT45_CLR		0x00009688
#define CCM_TARGET_ROOT45_TOG		0x0000968c
#define CCM_MISC45			0x00009690
#define CCM_MISC45_SET			0x00009694
#define CCM_MISC45_CLR			0x00009698
#define CCM_MISC45_TOG			0x0000969c
#define CCM_POST45			0x000096a0
#define CCM_POST45_SET			0x000096a4
#define CCM_POST45_CLR			0x000096a8
#define CCM_POST45_TOG			0x000096ac
#define CCM_PRE45			0x000096b0
#define CCM_PRE45_SET			0x000096b4
#define CCM_PRE45_CLR			0x000096b8
#define CCM_PRE45_TOG			0x000096bc
#define CCM_ACCESS_CTRL45		0x000096f0
#define CCM_ACCESS_CTRL45_SET		0x000096f4
#define CCM_ACCESS_CTRL45_CLR		0x000096f8
#define CCM_ACCESS_CTRL45_TOG		0x000096fc
#define CCM_TARGET_ROOT46		0x00009700
#define CCM_TARGET_ROOT46_SET		0x00009704
#define CCM_TARGET_ROOT46_CLR		0x00009708
#define CCM_TARGET_ROOT46_TOG		0x0000970c
#define CCM_MISC46			0x00009710
#define CCM_MISC46_SET			0x00009714
#define CCM_MISC46_CLR			0x00009718
#define CCM_MISC46_TOG			0x0000971c
#define CCM_POST46			0x00009720
#define CCM_POST46_SET			0x00009724
#define CCM_POST46_CLR			0x00009728
#define CCM_POST46_TOG			0x0000972c
#define CCM_PRE46			0x00009730
#define CCM_PRE46_SET			0x00009734
#define CCM_PRE46_CLR			0x00009738
#define CCM_PRE46_TOG			0x0000973c
#define CCM_ACCESS_CTRL46		0x00009770
#define CCM_ACCESS_CTRL46_SET		0x00009774
#define CCM_ACCESS_CTRL46_CLR		0x00009778
#define CCM_ACCESS_CTRL46_TOG		0x0000977c
#define CCM_TARGET_ROOT47		0x00009780
#define CCM_TARGET_ROOT47_SET		0x00009784
#define CCM_TARGET_ROOT47_CLR		0x00009788
#define CCM_TARGET_ROOT47_TOG		0x0000978c
#define CCM_MISC47			0x00009790
#define CCM_MISC47_SET			0x00009794
#define CCM_MISC47_CLR			0x00009798
#define CCM_MISC47_TOG			0x0000979c
#define CCM_POST47			0x000097a0
#define CCM_POST47_SET			0x000097a4
#define CCM_POST47_CLR			0x000097a8
#define CCM_POST47_TOG			0x000097ac
#define CCM_PRE47			0x000097b0
#define CCM_PRE47_SET			0x000097b4
#define CCM_PRE47_CLR			0x000097b8
#define CCM_PRE47_TOG			0x000097bc
#define CCM_ACCESS_CTRL47		0x000097f0
#define CCM_ACCESS_CTRL47_SET		0x000097f4
#define CCM_ACCESS_CTRL47_CLR		0x000097f8
#define CCM_ACCESS_CTRL47_TOG		0x000097fc
#define CCM_TARGET_ROOT48		0x00009800
#define CCM_TARGET_ROOT48_SET		0x00009804
#define CCM_TARGET_ROOT48_CLR		0x00009808
#define CCM_TARGET_ROOT48_TOG		0x0000980c
#define CCM_MISC48			0x00009810
#define CCM_MISC48_SET			0x00009814
#define CCM_MISC48_CLR			0x00009818
#define CCM_MISC48_TOG			0x0000981c
#define CCM_POST48			0x00009820
#define CCM_POST48_SET			0x00009824
#define CCM_POST48_CLR			0x00009828
#define CCM_POST48_TOG			0x0000982c
#define CCM_PRE48			0x00009830
#define CCM_PRE48_SET			0x00009834
#define CCM_PRE48_CLR			0x00009838
#define CCM_PRE48_TOG			0x0000983c
#define CCM_ACCESS_CTRL48		0x00009870
#define CCM_ACCESS_CTRL48_SET		0x00009874
#define CCM_ACCESS_CTRL48_CLR		0x00009878
#define CCM_ACCESS_CTRL48_TOG		0x0000987c
#define CCM_TARGET_ROOT49		0x00009880
#define CCM_TARGET_ROOT49_SET		0x00009884
#define CCM_TARGET_ROOT49_CLR		0x00009888
#define CCM_TARGET_ROOT49_TOG		0x0000988c
#define CCM_MISC49			0x00009890
#define CCM_MISC49_SET			0x00009894
#define CCM_MISC49_CLR			0x00009898
#define CCM_MISC49_TOG			0x0000989c
#define CCM_POST49			0x000098a0
#define CCM_POST49_SET			0x000098a4
#define CCM_POST49_CLR			0x000098a8
#define CCM_POST49_TOG			0x000098ac
#define CCM_PRE49			0x000098b0
#define CCM_PRE49_SET			0x000098b4
#define CCM_PRE49_CLR			0x000098b8
#define CCM_PRE49_TOG			0x000098bc
#define CCM_ACCESS_CTRL49		0x000098f0
#define CCM_ACCESS_CTRL49_SET		0x000098f4
#define CCM_ACCESS_CTRL49_CLR		0x000098f8
#define CCM_ACCESS_CTRL49_TOG		0x000098fc
#define CCM_TARGET_ROOT50		0x00009900
#define CCM_TARGET_ROOT50_SET		0x00009904
#define CCM_TARGET_ROOT50_CLR		0x00009908
#define CCM_TARGET_ROOT50_TOG		0x0000990c
#define CCM_MISC50			0x00009910
#define CCM_MISC50_SET			0x00009914
#define CCM_MISC50_CLR			0x00009918
#define CCM_MISC50_TOG			0x0000991c
#define CCM_POST50			0x00009920
#define CCM_POST50_SET			0x00009924
#define CCM_POST50_CLR			0x00009928
#define CCM_POST50_TOG			0x0000992c
#define CCM_PRE50			0x00009930
#define CCM_PRE50_SET			0x00009934
#define CCM_PRE50_CLR			0x00009938
#define CCM_PRE50_TOG			0x0000993c
#define CCM_ACCESS_CTRL50		0x00009970
#define CCM_ACCESS_CTRL50_SET		0x00009974
#define CCM_ACCESS_CTRL50_CLR		0x00009978
#define CCM_ACCESS_CTRL50_TOG		0x0000997c
#define CCM_TARGET_ROOT51		0x00009980
#define CCM_TARGET_ROOT51_SET		0x00009984
#define CCM_TARGET_ROOT51_CLR		0x00009988
#define CCM_TARGET_ROOT51_TOG		0x0000998c
#define CCM_MISC51			0x00009990
#define CCM_MISC51_SET			0x00009994
#define CCM_MISC51_CLR			0x00009998
#define CCM_MISC51_TOG			0x0000999c
#define CCM_POST51			0x000099a0
#define CCM_POST51_SET			0x000099a4
#define CCM_POST51_CLR			0x000099a8
#define CCM_POST51_TOG			0x000099ac
#define CCM_PRE51			0x000099b0
#define CCM_PRE51_SET			0x000099b4
#define CCM_PRE51_CLR			0x000099b8
#define CCM_PRE51_TOG			0x000099bc
#define CCM_ACCESS_CTRL51		0x000099f0
#define CCM_ACCESS_CTRL51_SET		0x000099f4
#define CCM_ACCESS_CTRL51_CLR		0x000099f8
#define CCM_ACCESS_CTRL51_TOG		0x000099fc
#define CCM_TARGET_ROOT52		0x00009a00
#define CCM_TARGET_ROOT52_SET		0x00009a04
#define CCM_TARGET_ROOT52_CLR		0x00009a08
#define CCM_TARGET_ROOT52_TOG		0x00009a0c
#define CCM_MISC52			0x00009a10
#define CCM_MISC52_SET			0x00009a14
#define CCM_MISC52_CLR			0x00009a18
#define CCM_MISC52_TOG			0x00009a1c
#define CCM_POST52			0x00009a20
#define CCM_POST52_SET			0x00009a24
#define CCM_POST52_CLR			0x00009a28
#define CCM_POST52_TOG			0x00009a2c
#define CCM_PRE52			0x00009a30
#define CCM_PRE52_SET			0x00009a34
#define CCM_PRE52_CLR			0x00009a38
#define CCM_PRE52_TOG			0x00009a3c
#define CCM_ACCESS_CTRL52		0x00009a70
#define CCM_ACCESS_CTRL52_SET		0x00009a74
#define CCM_ACCESS_CTRL52_CLR		0x00009a78
#define CCM_ACCESS_CTRL52_TOG		0x00009a7c
#define CCM_TARGET_ROOT53		0x00009a80
#define CCM_TARGET_ROOT53_SET		0x00009a84
#define CCM_TARGET_ROOT53_CLR		0x00009a88
#define CCM_TARGET_ROOT53_TOG		0x00009a8c
#define CCM_MISC53			0x00009a90
#define CCM_MISC53_SET			0x00009a94
#define CCM_MISC53_CLR			0x00009a98
#define CCM_MISC53_TOG			0x00009a9c
#define CCM_POST53			0x00009aa0
#define CCM_POST53_SET			0x00009aa4
#define CCM_POST53_CLR			0x00009aa8
#define CCM_POST53_TOG			0x00009aac
#define CCM_PRE53			0x00009ab0
#define CCM_PRE53_SET			0x00009ab4
#define CCM_PRE53_CLR			0x00009ab8
#define CCM_PRE53_TOG			0x00009abc
#define CCM_ACCESS_CTRL53		0x00009af0
#define CCM_ACCESS_CTRL53_SET		0x00009af4
#define CCM_ACCESS_CTRL53_CLR		0x00009af8
#define CCM_ACCESS_CTRL53_TOG		0x00009afc
#define CCM_TARGET_ROOT54		0x00009b00
#define CCM_TARGET_ROOT54_SET		0x00009b04
#define CCM_TARGET_ROOT54_CLR		0x00009b08
#define CCM_TARGET_ROOT54_TOG		0x00009b0c
#define CCM_MISC54			0x00009b10
#define CCM_MISC54_SET			0x00009b14
#define CCM_MISC54_CLR			0x00009b18
#define CCM_MISC54_TOG			0x00009b1c
#define CCM_POST54			0x00009b20
#define CCM_POST54_SET			0x00009b24
#define CCM_POST54_CLR			0x00009b28
#define CCM_POST54_TOG			0x00009b2c
#define CCM_PRE54			0x00009b30
#define CCM_PRE54_SET			0x00009b34
#define CCM_PRE54_CLR			0x00009b38
#define CCM_PRE54_TOG			0x00009b3c
#define CCM_ACCESS_CTRL54		0x00009b70
#define CCM_ACCESS_CTRL54_SET		0x00009b74
#define CCM_ACCESS_CTRL54_CLR		0x00009b78
#define CCM_ACCESS_CTRL54_TOG		0x00009b7c
#define CCM_TARGET_ROOT55		0x00009b80
#define CCM_TARGET_ROOT55_SET		0x00009b84
#define CCM_TARGET_ROOT55_CLR		0x00009b88
#define CCM_TARGET_ROOT55_TOG		0x00009b8c
#define CCM_MISC55			0x00009b90
#define CCM_MISC55_SET			0x00009b94
#define CCM_MISC55_CLR			0x00009b98
#define CCM_MISC55_TOG			0x00009b9c
#define CCM_POST55			0x00009ba0
#define CCM_POST55_SET			0x00009ba4
#define CCM_POST55_CLR			0x00009ba8
#define CCM_POST55_TOG			0x00009bac
#define CCM_PRE55			0x00009bb0
#define CCM_PRE55_SET			0x00009bb4
#define CCM_PRE55_CLR			0x00009bb8
#define CCM_PRE55_TOG			0x00009bbc
#define CCM_ACCESS_CTRL55		0x00009bf0
#define CCM_ACCESS_CTRL55_SET		0x00009bf4
#define CCM_ACCESS_CTRL55_CLR		0x00009bf8
#define CCM_ACCESS_CTRL55_TOG		0x00009bfc
#define CCM_TARGET_ROOT56		0x00009c00
#define CCM_TARGET_ROOT56_SET		0x00009c04
#define CCM_TARGET_ROOT56_CLR		0x00009c08
#define CCM_TARGET_ROOT56_TOG		0x00009c0c
#define CCM_MISC56			0x00009c10
#define CCM_MISC56_SET			0x00009c14
#define CCM_MISC56_CLR			0x00009c18
#define CCM_MISC56_TOG			0x00009c1c
#define CCM_POST56			0x00009c20
#define CCM_POST56_SET			0x00009c24
#define CCM_POST56_CLR			0x00009c28
#define CCM_POST56_TOG			0x00009c2c
#define CCM_PRE56			0x00009c30
#define CCM_PRE56_SET			0x00009c34
#define CCM_PRE56_CLR			0x00009c38
#define CCM_PRE56_TOG			0x00009c3c
#define CCM_ACCESS_CTRL56		0x00009c70
#define CCM_ACCESS_CTRL56_SET		0x00009c74
#define CCM_ACCESS_CTRL56_CLR		0x00009c78
#define CCM_ACCESS_CTRL56_TOG		0x00009c7c
#define CCM_TARGET_ROOT57		0x00009c80
#define CCM_TARGET_ROOT57_SET		0x00009c84
#define CCM_TARGET_ROOT57_CLR		0x00009c88
#define CCM_TARGET_ROOT57_TOG		0x00009c8c
#define CCM_MISC57			0x00009c90
#define CCM_MISC57_SET			0x00009c94
#define CCM_MISC57_CLR			0x00009c98
#define CCM_MISC57_TOG			0x00009c9c
#define CCM_POST57			0x00009ca0
#define CCM_POST57_SET			0x00009ca4
#define CCM_POST57_CLR			0x00009ca8
#define CCM_POST57_TOG			0x00009cac
#define CCM_PRE57			0x00009cb0
#define CCM_PRE57_SET			0x00009cb4
#define CCM_PRE57_CLR			0x00009cb8
#define CCM_PRE57_TOG			0x00009cbc
#define CCM_ACCESS_CTRL57		0x00009cf0
#define CCM_ACCESS_CTRL57_SET		0x00009cf4
#define CCM_ACCESS_CTRL57_CLR		0x00009cf8
#define CCM_ACCESS_CTRL57_TOG		0x00009cfc
#define CCM_TARGET_ROOT58		0x00009d00
#define CCM_TARGET_ROOT58_SET		0x00009d04
#define CCM_TARGET_ROOT58_CLR		0x00009d08
#define CCM_TARGET_ROOT58_TOG		0x00009d0c
#define CCM_MISC58			0x00009d10
#define CCM_MISC58_SET			0x00009d14
#define CCM_MISC58_CLR			0x00009d18
#define CCM_MISC58_TOG			0x00009d1c
#define CCM_POST58			0x00009d20
#define CCM_POST58_SET			0x00009d24
#define CCM_POST58_CLR			0x00009d28
#define CCM_POST58_TOG			0x00009d2c
#define CCM_PRE58			0x00009d30
#define CCM_PRE58_SET			0x00009d34
#define CCM_PRE58_CLR			0x00009d38
#define CCM_PRE58_TOG			0x00009d3c
#define CCM_ACCESS_CTRL58		0x00009d70
#define CCM_ACCESS_CTRL58_SET		0x00009d74
#define CCM_ACCESS_CTRL58_CLR		0x00009d78
#define CCM_ACCESS_CTRL58_TOG		0x00009d7c
#define CCM_TARGET_ROOT59		0x00009d80
#define CCM_TARGET_ROOT59_SET		0x00009d84
#define CCM_TARGET_ROOT59_CLR		0x00009d88
#define CCM_TARGET_ROOT59_TOG		0x00009d8c
#define CCM_MISC59			0x00009d90
#define CCM_MISC59_SET			0x00009d94
#define CCM_MISC59_CLR			0x00009d98
#define CCM_MISC59_TOG			0x00009d9c
#define CCM_POST59			0x00009da0
#define CCM_POST59_SET			0x00009da4
#define CCM_POST59_CLR			0x00009da8
#define CCM_POST59_TOG			0x00009dac
#define CCM_PRE59			0x00009db0
#define CCM_PRE59_SET			0x00009db4
#define CCM_PRE59_CLR			0x00009db8
#define CCM_PRE59_TOG			0x00009dbc
#define CCM_ACCESS_CTRL59		0x00009df0
#define CCM_ACCESS_CTRL59_SET		0x00009df4
#define CCM_ACCESS_CTRL59_CLR		0x00009df8
#define CCM_ACCESS_CTRL59_TOG		0x00009dfc
#define CCM_TARGET_ROOT60		0x00009e00
#define CCM_TARGET_ROOT60_SET		0x00009e04
#define CCM_TARGET_ROOT60_CLR		0x00009e08
#define CCM_TARGET_ROOT60_TOG		0x00009e0c
#define CCM_MISC60			0x00009e10
#define CCM_MISC60_SET			0x00009e14
#define CCM_MISC60_CLR			0x00009e18
#define CCM_MISC60_TOG			0x00009e1c
#define CCM_POST60			0x00009e20
#define CCM_POST60_SET			0x00009e24
#define CCM_POST60_CLR			0x00009e28
#define CCM_POST60_TOG			0x00009e2c
#define CCM_PRE60			0x00009e30
#define CCM_PRE60_SET			0x00009e34
#define CCM_PRE60_CLR			0x00009e38
#define CCM_PRE60_TOG			0x00009e3c
#define CCM_ACCESS_CTRL60		0x00009e70
#define CCM_ACCESS_CTRL60_SET		0x00009e74
#define CCM_ACCESS_CTRL60_CLR		0x00009e78
#define CCM_ACCESS_CTRL60_TOG		0x00009e7c
#define CCM_TARGET_ROOT61		0x00009e80
#define CCM_TARGET_ROOT61_SET		0x00009e84
#define CCM_TARGET_ROOT61_CLR		0x00009e88
#define CCM_TARGET_ROOT61_TOG		0x00009e8c
#define CCM_MISC61			0x00009e90
#define CCM_MISC61_SET			0x00009e94
#define CCM_MISC61_CLR			0x00009e98
#define CCM_MISC61_TOG			0x00009e9c
#define CCM_POST61			0x00009ea0
#define CCM_POST61_SET			0x00009ea4
#define CCM_POST61_CLR			0x00009ea8
#define CCM_POST61_TOG			0x00009eac
#define CCM_PRE61			0x00009eb0
#define CCM_PRE61_SET			0x00009eb4
#define CCM_PRE61_CLR			0x00009eb8
#define CCM_PRE61_TOG			0x00009ebc
#define CCM_ACCESS_CTRL61		0x00009ef0
#define CCM_ACCESS_CTRL61_SET		0x00009ef4
#define CCM_ACCESS_CTRL61_CLR		0x00009ef8
#define CCM_ACCESS_CTRL61_TOG		0x00009efc
#define CCM_TARGET_ROOT62		0x00009f00
#define CCM_TARGET_ROOT62_SET		0x00009f04
#define CCM_TARGET_ROOT62_CLR		0x00009f08
#define CCM_TARGET_ROOT62_TOG		0x00009f0c
#define CCM_MISC62			0x00009f10
#define CCM_MISC62_SET			0x00009f14
#define CCM_MISC62_CLR			0x00009f18
#define CCM_MISC62_TOG			0x00009f1c
#define CCM_POST62			0x00009f20
#define CCM_POST62_SET			0x00009f24
#define CCM_POST62_CLR			0x00009f28
#define CCM_POST62_TOG			0x00009f2c
#define CCM_PRE62			0x00009f30
#define CCM_PRE62_SET			0x00009f34
#define CCM_PRE62_CLR			0x00009f38
#define CCM_PRE62_TOG			0x00009f3c
#define CCM_ACCESS_CTRL62		0x00009f70
#define CCM_ACCESS_CTRL62_SET		0x00009f74
#define CCM_ACCESS_CTRL62_CLR		0x00009f78
#define CCM_ACCESS_CTRL62_TOG		0x00009f7c
#define CCM_TARGET_ROOT63		0x00009f80
#define CCM_TARGET_ROOT63_SET		0x00009f84
#define CCM_TARGET_ROOT63_CLR		0x00009f88
#define CCM_TARGET_ROOT63_TOG		0x00009f8c
#define CCM_MISC63			0x00009f90
#define CCM_MISC63_SET			0x00009f94
#define CCM_MISC63_CLR			0x00009f98
#define CCM_MISC63_TOG			0x00009f9c
#define CCM_POST63			0x00009fa0
#define CCM_POST63_SET			0x00009fa4
#define CCM_POST63_CLR			0x00009fa8
#define CCM_POST63_TOG			0x00009fac
#define CCM_PRE63			0x00009fb0
#define CCM_PRE63_SET			0x00009fb4
#define CCM_PRE63_CLR			0x00009fb8
#define CCM_PRE63_TOG			0x00009fbc
#define CCM_ACCESS_CTRL63		0x00009ff0
#define CCM_ACCESS_CTRL63_SET		0x00009ff4
#define CCM_ACCESS_CTRL63_CLR		0x00009ff8
#define CCM_ACCESS_CTRL63_TOG		0x00009ffc
#define CCM_TARGET_ROOT64		0x0000a000
#define CCM_TARGET_ROOT64_SET		0x0000a004
#define CCM_TARGET_ROOT64_CLR		0x0000a008
#define CCM_TARGET_ROOT64_TOG		0x0000a00c
#define CCM_MISC64			0x0000a010
#define CCM_MISC64_SET			0x0000a014
#define CCM_MISC64_CLR			0x0000a018
#define CCM_MISC64_TOG			0x0000a01c
#define CCM_POST64			0x0000a020
#define CCM_POST64_SET			0x0000a024
#define CCM_POST64_CLR			0x0000a028
#define CCM_POST64_TOG			0x0000a02c
#define CCM_PRE64			0x0000a030
#define CCM_PRE64_SET			0x0000a034
#define CCM_PRE64_CLR			0x0000a038
#define CCM_PRE64_TOG			0x0000a03c
#define CCM_ACCESS_CTRL64		0x0000a070
#define CCM_ACCESS_CTRL64_SET		0x0000a074
#define CCM_ACCESS_CTRL64_CLR		0x0000a078
#define CCM_ACCESS_CTRL64_TOG		0x0000a07c
#define CCM_TARGET_ROOT65		0x0000a080
#define CCM_TARGET_ROOT65_SET		0x0000a084
#define CCM_TARGET_ROOT65_CLR		0x0000a088
#define CCM_TARGET_ROOT65_TOG		0x0000a08c
#define CCM_MISC65			0x0000a090
#define CCM_MISC65_SET			0x0000a094
#define CCM_MISC65_CLR			0x0000a098
#define CCM_MISC65_TOG			0x0000a09c
#define CCM_POST65			0x0000a0a0
#define CCM_POST65_SET			0x0000a0a4
#define CCM_POST65_CLR			0x0000a0a8
#define CCM_POST65_TOG			0x0000a0ac
#define CCM_PRE65			0x0000a0b0
#define CCM_PRE65_SET			0x0000a0b4
#define CCM_PRE65_CLR			0x0000a0b8
#define CCM_PRE65_TOG			0x0000a0bc
#define CCM_ACCESS_CTRL65		0x0000a0f0
#define CCM_ACCESS_CTRL65_SET		0x0000a0f4
#define CCM_ACCESS_CTRL65_CLR		0x0000a0f8
#define CCM_ACCESS_CTRL65_TOG		0x0000a0fc
#define CCM_TARGET_ROOT66		0x0000a100
#define CCM_TARGET_ROOT66_SET		0x0000a104
#define CCM_TARGET_ROOT66_CLR		0x0000a108
#define CCM_TARGET_ROOT66_TOG		0x0000a10c
#define CCM_MISC66			0x0000a110
#define CCM_MISC66_SET			0x0000a114
#define CCM_MISC66_CLR			0x0000a118
#define CCM_MISC66_TOG			0x0000a11c
#define CCM_POST66			0x0000a120
#define CCM_POST66_SET			0x0000a124
#define CCM_POST66_CLR			0x0000a128
#define CCM_POST66_TOG			0x0000a12c
#define CCM_PRE66			0x0000a130
#define CCM_PRE66_SET			0x0000a134
#define CCM_PRE66_CLR			0x0000a138
#define CCM_PRE66_TOG			0x0000a13c
#define CCM_ACCESS_CTRL66		0x0000a170
#define CCM_ACCESS_CTRL66_SET		0x0000a174
#define CCM_ACCESS_CTRL66_CLR		0x0000a178
#define CCM_ACCESS_CTRL66_TOG		0x0000a17c
#define CCM_TARGET_ROOT67		0x0000a180
#define CCM_TARGET_ROOT67_SET		0x0000a184
#define CCM_TARGET_ROOT67_CLR		0x0000a188
#define CCM_TARGET_ROOT67_TOG		0x0000a18c
#define CCM_MISC67			0x0000a190
#define CCM_MISC67_SET			0x0000a194
#define CCM_MISC67_CLR			0x0000a198
#define CCM_MISC67_TOG			0x0000a19c
#define CCM_POST67			0x0000a1a0
#define CCM_POST67_SET			0x0000a1a4
#define CCM_POST67_CLR			0x0000a1a8
#define CCM_POST67_TOG			0x0000a1ac
#define CCM_PRE67			0x0000a1b0
#define CCM_PRE67_SET			0x0000a1b4
#define CCM_PRE67_CLR			0x0000a1b8
#define CCM_PRE67_TOG			0x0000a1bc
#define CCM_ACCESS_CTRL67		0x0000a1f0
#define CCM_ACCESS_CTRL67_SET		0x0000a1f4
#define CCM_ACCESS_CTRL67_CLR		0x0000a1f8
#define CCM_ACCESS_CTRL67_TOG		0x0000a1fc
#define CCM_TARGET_ROOT68		0x0000a200
#define CCM_TARGET_ROOT68_SET		0x0000a204
#define CCM_TARGET_ROOT68_CLR		0x0000a208
#define CCM_TARGET_ROOT68_TOG		0x0000a20c
#define CCM_MISC68			0x0000a210
#define CCM_MISC68_SET			0x0000a214
#define CCM_MISC68_CLR			0x0000a218
#define CCM_MISC68_TOG			0x0000a21c
#define CCM_POST68			0x0000a220
#define CCM_POST68_SET			0x0000a224
#define CCM_POST68_CLR			0x0000a228
#define CCM_POST68_TOG			0x0000a22c
#define CCM_PRE68			0x0000a230
#define CCM_PRE68_SET			0x0000a234
#define CCM_PRE68_CLR			0x0000a238
#define CCM_PRE68_TOG			0x0000a23c
#define CCM_ACCESS_CTRL68		0x0000a270
#define CCM_ACCESS_CTRL68_SET		0x0000a274
#define CCM_ACCESS_CTRL68_CLR		0x0000a278
#define CCM_ACCESS_CTRL68_TOG		0x0000a27c
#define CCM_TARGET_ROOT69		0x0000a280
#define CCM_TARGET_ROOT69_SET		0x0000a284
#define CCM_TARGET_ROOT69_CLR		0x0000a288
#define CCM_TARGET_ROOT69_TOG		0x0000a28c
#define CCM_MISC69			0x0000a290
#define CCM_MISC69_SET			0x0000a294
#define CCM_MISC69_CLR			0x0000a298
#define CCM_MISC69_TOG			0x0000a29c
#define CCM_POST69			0x0000a2a0
#define CCM_POST69_SET			0x0000a2a4
#define CCM_POST69_CLR			0x0000a2a8
#define CCM_POST69_TOG			0x0000a2ac
#define CCM_PRE69			0x0000a2b0
#define CCM_PRE69_SET			0x0000a2b4
#define CCM_PRE69_CLR			0x0000a2b8
#define CCM_PRE69_TOG			0x0000a2bc
#define CCM_ACCESS_CTRL69		0x0000a2f0
#define CCM_ACCESS_CTRL69_SET		0x0000a2f4
#define CCM_ACCESS_CTRL69_CLR		0x0000a2f8
#define CCM_ACCESS_CTRL69_TOG		0x0000a2fc
#define CCM_TARGET_ROOT70		0x0000a300
#define CCM_TARGET_ROOT70_SET		0x0000a304
#define CCM_TARGET_ROOT70_CLR		0x0000a308
#define CCM_TARGET_ROOT70_TOG		0x0000a30c
#define CCM_MISC70			0x0000a310
#define CCM_MISC70_SET			0x0000a314
#define CCM_MISC70_CLR			0x0000a318
#define CCM_MISC70_TOG			0x0000a31c
#define CCM_POST70			0x0000a320
#define CCM_POST70_SET			0x0000a324
#define CCM_POST70_CLR			0x0000a328
#define CCM_POST70_TOG			0x0000a32c
#define CCM_PRE70			0x0000a330
#define CCM_PRE70_SET			0x0000a334
#define CCM_PRE70_CLR			0x0000a338
#define CCM_PRE70_TOG			0x0000a33c
#define CCM_ACCESS_CTRL70		0x0000a370
#define CCM_ACCESS_CTRL70_SET		0x0000a374
#define CCM_ACCESS_CTRL70_CLR		0x0000a378
#define CCM_ACCESS_CTRL70_TOG		0x0000a37c
#define CCM_TARGET_ROOT71		0x0000a380
#define CCM_TARGET_ROOT71_SET		0x0000a384
#define CCM_TARGET_ROOT71_CLR		0x0000a388
#define CCM_TARGET_ROOT71_TOG		0x0000a38c
#define CCM_MISC71			0x0000a390
#define CCM_MISC71_SET			0x0000a394
#define CCM_MISC71_CLR			0x0000a398
#define CCM_MISC71_TOG			0x0000a39c
#define CCM_POST71			0x0000a3a0
#define CCM_POST71_SET			0x0000a3a4
#define CCM_POST71_CLR			0x0000a3a8
#define CCM_POST71_TOG			0x0000a3ac
#define CCM_PRE71			0x0000a3b0
#define CCM_PRE71_SET			0x0000a3b4
#define CCM_PRE71_CLR			0x0000a3b8
#define CCM_PRE71_TOG			0x0000a3bc
#define CCM_ACCESS_CTRL71		0x0000a3f0
#define CCM_ACCESS_CTRL71_SET		0x0000a3f4
#define CCM_ACCESS_CTRL71_CLR		0x0000a3f8
#define CCM_ACCESS_CTRL71_TOG		0x0000a3fc
#define CCM_TARGET_ROOT72		0x0000a400
#define CCM_TARGET_ROOT72_SET		0x0000a404
#define CCM_TARGET_ROOT72_CLR		0x0000a408
#define CCM_TARGET_ROOT72_TOG		0x0000a40c
#define CCM_MISC72			0x0000a410
#define CCM_MISC72_SET			0x0000a414
#define CCM_MISC72_CLR			0x0000a418
#define CCM_MISC72_TOG			0x0000a41c
#define CCM_POST72			0x0000a420
#define CCM_POST72_SET			0x0000a424
#define CCM_POST72_CLR			0x0000a428
#define CCM_POST72_TOG			0x0000a42c
#define CCM_PRE72			0x0000a430
#define CCM_PRE72_SET			0x0000a434
#define CCM_PRE72_CLR			0x0000a438
#define CCM_PRE72_TOG			0x0000a43c
#define CCM_ACCESS_CTRL72		0x0000a470
#define CCM_ACCESS_CTRL72_SET		0x0000a474
#define CCM_ACCESS_CTRL72_CLR		0x0000a478
#define CCM_ACCESS_CTRL72_TOG		0x0000a47c
#define CCM_TARGET_ROOT73		0x0000a480
#define CCM_TARGET_ROOT73_SET		0x0000a484
#define CCM_TARGET_ROOT73_CLR		0x0000a488
#define CCM_TARGET_ROOT73_TOG		0x0000a48c
#define CCM_MISC73			0x0000a490
#define CCM_MISC73_SET			0x0000a494
#define CCM_MISC73_CLR			0x0000a498
#define CCM_MISC73_TOG			0x0000a49c
#define CCM_POST73			0x0000a4a0
#define CCM_POST73_SET			0x0000a4a4
#define CCM_POST73_CLR			0x0000a4a8
#define CCM_POST73_TOG			0x0000a4ac
#define CCM_PRE73			0x0000a4b0
#define CCM_PRE73_SET			0x0000a4b4
#define CCM_PRE73_CLR			0x0000a4b8
#define CCM_PRE73_TOG			0x0000a4bc
#define CCM_ACCESS_CTRL73		0x0000a4f0
#define CCM_ACCESS_CTRL73_SET		0x0000a4f4
#define CCM_ACCESS_CTRL73_CLR		0x0000a4f8
#define CCM_ACCESS_CTRL73_TOG		0x0000a4fc
#define CCM_TARGET_ROOT74		0x0000a500
#define CCM_TARGET_ROOT74_SET		0x0000a504
#define CCM_TARGET_ROOT74_CLR		0x0000a508
#define CCM_TARGET_ROOT74_TOG		0x0000a50c
#define CCM_MISC74			0x0000a510
#define CCM_MISC74_SET			0x0000a514
#define CCM_MISC74_CLR			0x0000a518
#define CCM_MISC74_TOG			0x0000a51c
#define CCM_POST74			0x0000a520
#define CCM_POST74_SET			0x0000a524
#define CCM_POST74_CLR			0x0000a528
#define CCM_POST74_TOG			0x0000a52c
#define CCM_PRE74			0x0000a530
#define CCM_PRE74_SET			0x0000a534
#define CCM_PRE74_CLR			0x0000a538
#define CCM_PRE74_TOG			0x0000a53c
#define CCM_ACCESS_CTRL74		0x0000a570
#define CCM_ACCESS_CTRL74_SET		0x0000a574
#define CCM_ACCESS_CTRL74_CLR		0x0000a578
#define CCM_ACCESS_CTRL74_TOG		0x0000a57c
#define CCM_TARGET_ROOT75		0x0000a580
#define CCM_TARGET_ROOT75_SET		0x0000a584
#define CCM_TARGET_ROOT75_CLR		0x0000a588
#define CCM_TARGET_ROOT75_TOG		0x0000a58c
#define CCM_MISC75			0x0000a590
#define CCM_MISC75_SET			0x0000a594
#define CCM_MISC75_CLR			0x0000a598
#define CCM_MISC75_TOG			0x0000a59c
#define CCM_POST75			0x0000a5a0
#define CCM_POST75_SET			0x0000a5a4
#define CCM_POST75_CLR			0x0000a5a8
#define CCM_POST75_TOG			0x0000a5ac
#define CCM_PRE75			0x0000a5b0
#define CCM_PRE75_SET			0x0000a5b4
#define CCM_PRE75_CLR			0x0000a5b8
#define CCM_PRE75_TOG			0x0000a5bc
#define CCM_ACCESS_CTRL75		0x0000a5f0
#define CCM_ACCESS_CTRL75_SET		0x0000a5f4
#define CCM_ACCESS_CTRL75_CLR		0x0000a5f8
#define CCM_ACCESS_CTRL75_TOG		0x0000a5fc
#define CCM_TARGET_ROOT76		0x0000a600
#define CCM_TARGET_ROOT76_SET		0x0000a604
#define CCM_TARGET_ROOT76_CLR		0x0000a608
#define CCM_TARGET_ROOT76_TOG		0x0000a60c
#define CCM_MISC76			0x0000a610
#define CCM_MISC76_SET			0x0000a614
#define CCM_MISC76_CLR			0x0000a618
#define CCM_MISC76_TOG			0x0000a61c
#define CCM_POST76			0x0000a620
#define CCM_POST76_SET			0x0000a624
#define CCM_POST76_CLR			0x0000a628
#define CCM_POST76_TOG			0x0000a62c
#define CCM_PRE76			0x0000a630
#define CCM_PRE76_SET			0x0000a634
#define CCM_PRE76_CLR			0x0000a638
#define CCM_PRE76_TOG			0x0000a63c
#define CCM_ACCESS_CTRL76		0x0000a670
#define CCM_ACCESS_CTRL76_SET		0x0000a674
#define CCM_ACCESS_CTRL76_CLR		0x0000a678
#define CCM_ACCESS_CTRL76_TOG		0x0000a67c
#define CCM_TARGET_ROOT77		0x0000a680
#define CCM_TARGET_ROOT77_SET		0x0000a684
#define CCM_TARGET_ROOT77_CLR		0x0000a688
#define CCM_TARGET_ROOT77_TOG		0x0000a68c
#define CCM_MISC77			0x0000a690
#define CCM_MISC77_SET			0x0000a694
#define CCM_MISC77_CLR			0x0000a698
#define CCM_MISC77_TOG			0x0000a69c
#define CCM_POST77			0x0000a6a0
#define CCM_POST77_SET			0x0000a6a4
#define CCM_POST77_CLR			0x0000a6a8
#define CCM_POST77_TOG			0x0000a6ac
#define CCM_PRE77			0x0000a6b0
#define CCM_PRE77_SET			0x0000a6b4
#define CCM_PRE77_CLR			0x0000a6b8
#define CCM_PRE77_TOG			0x0000a6bc
#define CCM_ACCESS_CTRL77		0x0000a6f0
#define CCM_ACCESS_CTRL77_SET		0x0000a6f4
#define CCM_ACCESS_CTRL77_CLR		0x0000a6f8
#define CCM_ACCESS_CTRL77_TOG		0x0000a6fc
#define CCM_TARGET_ROOT78		0x0000a700
#define CCM_TARGET_ROOT78_SET		0x0000a704
#define CCM_TARGET_ROOT78_CLR		0x0000a708
#define CCM_TARGET_ROOT78_TOG		0x0000a70c
#define CCM_MISC78			0x0000a710
#define CCM_MISC78_SET			0x0000a714
#define CCM_MISC78_CLR			0x0000a718
#define CCM_MISC78_TOG			0x0000a71c
#define CCM_POST78			0x0000a720
#define CCM_POST78_SET			0x0000a724
#define CCM_POST78_CLR			0x0000a728
#define CCM_POST78_TOG			0x0000a72c
#define CCM_PRE78			0x0000a730
#define CCM_PRE78_SET			0x0000a734
#define CCM_PRE78_CLR			0x0000a738
#define CCM_PRE78_TOG			0x0000a73c
#define CCM_ACCESS_CTRL78		0x0000a770
#define CCM_ACCESS_CTRL78_SET		0x0000a774
#define CCM_ACCESS_CTRL78_CLR		0x0000a778
#define CCM_ACCESS_CTRL78_TOG		0x0000a77c
#define CCM_TARGET_ROOT79		0x0000a780
#define CCM_TARGET_ROOT79_SET		0x0000a784
#define CCM_TARGET_ROOT79_CLR		0x0000a788
#define CCM_TARGET_ROOT79_TOG		0x0000a78c
#define CCM_MISC79			0x0000a790
#define CCM_MISC79_SET			0x0000a794
#define CCM_MISC79_CLR			0x0000a798
#define CCM_MISC79_TOG			0x0000a79c
#define CCM_POST79			0x0000a7a0
#define CCM_POST79_SET			0x0000a7a4
#define CCM_POST79_CLR			0x0000a7a8
#define CCM_POST79_TOG			0x0000a7ac
#define CCM_PRE79			0x0000a7b0
#define CCM_PRE79_SET			0x0000a7b4
#define CCM_PRE79_CLR			0x0000a7b8
#define CCM_PRE79_TOG			0x0000a7bc
#define CCM_ACCESS_CTRL79		0x0000a7f0
#define CCM_ACCESS_CTRL79_SET		0x0000a7f4
#define CCM_ACCESS_CTRL79_CLR		0x0000a7f8
#define CCM_ACCESS_CTRL79_TOG		0x0000a7fc
#define CCM_TARGET_ROOT80		0x0000a800
#define CCM_TARGET_ROOT80_SET		0x0000a804
#define CCM_TARGET_ROOT80_CLR		0x0000a808
#define CCM_TARGET_ROOT80_TOG		0x0000a80c
#define CCM_MISC80			0x0000a810
#define CCM_MISC80_SET			0x0000a814
#define CCM_MISC80_CLR			0x0000a818
#define CCM_MISC80_TOG			0x0000a81c
#define CCM_POST80			0x0000a820
#define CCM_POST80_SET			0x0000a824
#define CCM_POST80_CLR			0x0000a828
#define CCM_POST80_TOG			0x0000a82c
#define CCM_PRE80			0x0000a830
#define CCM_PRE80_SET			0x0000a834
#define CCM_PRE80_CLR			0x0000a838
#define CCM_PRE80_TOG			0x0000a83c
#define CCM_ACCESS_CTRL80		0x0000a870
#define CCM_ACCESS_CTRL80_SET		0x0000a874
#define CCM_ACCESS_CTRL80_CLR		0x0000a878
#define CCM_ACCESS_CTRL80_TOG		0x0000a87c
#define CCM_TARGET_ROOT81		0x0000a880
#define CCM_TARGET_ROOT81_SET		0x0000a884
#define CCM_TARGET_ROOT81_CLR		0x0000a888
#define CCM_TARGET_ROOT81_TOG		0x0000a88c
#define CCM_MISC81			0x0000a890
#define CCM_MISC81_SET			0x0000a894
#define CCM_MISC81_CLR			0x0000a898
#define CCM_MISC81_TOG			0x0000a89c
#define CCM_POST81			0x0000a8a0
#define CCM_POST81_SET			0x0000a8a4
#define CCM_POST81_CLR			0x0000a8a8
#define CCM_POST81_TOG			0x0000a8ac
#define CCM_PRE81			0x0000a8b0
#define CCM_PRE81_SET			0x0000a8b4
#define CCM_PRE81_CLR			0x0000a8b8
#define CCM_PRE81_TOG			0x0000a8bc
#define CCM_ACCESS_CTRL81		0x0000a8f0
#define CCM_ACCESS_CTRL81_SET		0x0000a8f4
#define CCM_ACCESS_CTRL81_CLR		0x0000a8f8
#define CCM_ACCESS_CTRL81_TOG		0x0000a8fc
#define CCM_TARGET_ROOT82		0x0000a900
#define CCM_TARGET_ROOT82_SET		0x0000a904
#define CCM_TARGET_ROOT82_CLR		0x0000a908
#define CCM_TARGET_ROOT82_TOG		0x0000a90c
#define CCM_MISC82			0x0000a910
#define CCM_MISC82_SET			0x0000a914
#define CCM_MISC82_CLR			0x0000a918
#define CCM_MISC82_TOG			0x0000a91c
#define CCM_POST82			0x0000a920
#define CCM_POST82_SET			0x0000a924
#define CCM_POST82_CLR			0x0000a928
#define CCM_POST82_TOG			0x0000a92c
#define CCM_PRE82			0x0000a930
#define CCM_PRE82_SET			0x0000a934
#define CCM_PRE82_CLR			0x0000a938
#define CCM_PRE82_TOG			0x0000a93c
#define CCM_ACCESS_CTRL82		0x0000a970
#define CCM_ACCESS_CTRL82_SET		0x0000a974
#define CCM_ACCESS_CTRL82_CLR		0x0000a978
#define CCM_ACCESS_CTRL82_TOG		0x0000a97c
#define CCM_TARGET_ROOT83		0x0000a980
#define CCM_TARGET_ROOT83_SET		0x0000a984
#define CCM_TARGET_ROOT83_CLR		0x0000a988
#define CCM_TARGET_ROOT83_TOG		0x0000a98c
#define CCM_MISC83			0x0000a990
#define CCM_MISC83_SET			0x0000a994
#define CCM_MISC83_CLR			0x0000a998
#define CCM_MISC83_TOG			0x0000a99c
#define CCM_POST83			0x0000a9a0
#define CCM_POST83_SET			0x0000a9a4
#define CCM_POST83_CLR			0x0000a9a8
#define CCM_POST83_TOG			0x0000a9ac
#define CCM_PRE83			0x0000a9b0
#define CCM_PRE83_SET			0x0000a9b4
#define CCM_PRE83_CLR			0x0000a9b8
#define CCM_PRE83_TOG			0x0000a9bc
#define CCM_ACCESS_CTRL83		0x0000a9f0
#define CCM_ACCESS_CTRL83_SET		0x0000a9f4
#define CCM_ACCESS_CTRL83_CLR		0x0000a9f8
#define CCM_ACCESS_CTRL83_TOG		0x0000a9fc
#define CCM_TARGET_ROOT84		0x0000aa00
#define CCM_TARGET_ROOT84_SET		0x0000aa04
#define CCM_TARGET_ROOT84_CLR		0x0000aa08
#define CCM_TARGET_ROOT84_TOG		0x0000aa0c
#define CCM_MISC84			0x0000aa10
#define CCM_MISC84_SET			0x0000aa14
#define CCM_MISC84_CLR			0x0000aa18
#define CCM_MISC84_TOG			0x0000aa1c
#define CCM_POST84			0x0000aa20
#define CCM_POST84_SET			0x0000aa24
#define CCM_POST84_CLR			0x0000aa28
#define CCM_POST84_TOG			0x0000aa2c
#define CCM_PRE84			0x0000aa30
#define CCM_PRE84_SET			0x0000aa34
#define CCM_PRE84_CLR			0x0000aa38
#define CCM_PRE84_TOG			0x0000aa3c
#define CCM_ACCESS_CTRL84		0x0000aa70
#define CCM_ACCESS_CTRL84_SET		0x0000aa74
#define CCM_ACCESS_CTRL84_CLR		0x0000aa78
#define CCM_ACCESS_CTRL84_TOG		0x0000aa7c
#define CCM_TARGET_ROOT85		0x0000aa80
#define CCM_TARGET_ROOT85_SET		0x0000aa84
#define CCM_TARGET_ROOT85_CLR		0x0000aa88
#define CCM_TARGET_ROOT85_TOG		0x0000aa8c
#define CCM_MISC85			0x0000aa90
#define CCM_MISC85_SET			0x0000aa94
#define CCM_MISC85_CLR			0x0000aa98
#define CCM_MISC85_TOG			0x0000aa9c
#define CCM_POST85			0x0000aaa0
#define CCM_POST85_SET			0x0000aaa4
#define CCM_POST85_CLR			0x0000aaa8
#define CCM_POST85_TOG			0x0000aaac
#define CCM_PRE85			0x0000aab0
#define CCM_PRE85_SET			0x0000aab4
#define CCM_PRE85_CLR			0x0000aab8
#define CCM_PRE85_TOG			0x0000aabc
#define CCM_ACCESS_CTRL85		0x0000aaf0
#define CCM_ACCESS_CTRL85_SET		0x0000aaf4
#define CCM_ACCESS_CTRL85_CLR		0x0000aaf8
#define CCM_ACCESS_CTRL85_TOG		0x0000aafc
#define CCM_TARGET_ROOT86		0x0000ab00
#define CCM_TARGET_ROOT86_SET		0x0000ab04
#define CCM_TARGET_ROOT86_CLR		0x0000ab08
#define CCM_TARGET_ROOT86_TOG		0x0000ab0c
#define CCM_MISC86			0x0000ab10
#define CCM_MISC86_SET			0x0000ab14
#define CCM_MISC86_CLR			0x0000ab18
#define CCM_MISC86_TOG			0x0000ab1c
#define CCM_POST86			0x0000ab20
#define CCM_POST86_SET			0x0000ab24
#define CCM_POST86_CLR			0x0000ab28
#define CCM_POST86_TOG			0x0000ab2c
#define CCM_PRE86			0x0000ab30
#define CCM_PRE86_SET			0x0000ab34
#define CCM_PRE86_CLR			0x0000ab38
#define CCM_PRE86_TOG			0x0000ab3c
#define CCM_ACCESS_CTRL86		0x0000ab70
#define CCM_ACCESS_CTRL86_SET		0x0000ab74
#define CCM_ACCESS_CTRL86_CLR		0x0000ab78
#define CCM_ACCESS_CTRL86_TOG		0x0000ab7c
#define CCM_TARGET_ROOT87		0x0000ab80
#define CCM_TARGET_ROOT87_SET		0x0000ab84
#define CCM_TARGET_ROOT87_CLR		0x0000ab88
#define CCM_TARGET_ROOT87_TOG		0x0000ab8c
#define CCM_MISC87			0x0000ab90
#define CCM_MISC87_SET			0x0000ab94
#define CCM_MISC87_CLR			0x0000ab98
#define CCM_MISC87_TOG			0x0000ab9c
#define CCM_POST87			0x0000aba0
#define CCM_POST87_SET			0x0000aba4
#define CCM_POST87_CLR			0x0000aba8
#define CCM_POST87_TOG			0x0000abac
#define CCM_PRE87			0x0000abb0
#define CCM_PRE87_SET			0x0000abb4
#define CCM_PRE87_CLR			0x0000abb8
#define CCM_PRE87_TOG			0x0000abbc
#define CCM_ACCESS_CTRL87		0x0000abf0
#define CCM_ACCESS_CTRL87_SET		0x0000abf4
#define CCM_ACCESS_CTRL87_CLR		0x0000abf8
#define CCM_ACCESS_CTRL87_TOG		0x0000abfc
#define CCM_TARGET_ROOT88		0x0000ac00
#define CCM_TARGET_ROOT88_SET		0x0000ac04
#define CCM_TARGET_ROOT88_CLR		0x0000ac08
#define CCM_TARGET_ROOT88_TOG		0x0000ac0c
#define CCM_MISC88			0x0000ac10
#define CCM_MISC88_SET			0x0000ac14
#define CCM_MISC88_CLR			0x0000ac18
#define CCM_MISC88_TOG			0x0000ac1c
#define CCM_POST88			0x0000ac20
#define CCM_POST88_SET			0x0000ac24
#define CCM_POST88_CLR			0x0000ac28
#define CCM_POST88_TOG			0x0000ac2c
#define CCM_PRE88			0x0000ac30
#define CCM_PRE88_SET			0x0000ac34
#define CCM_PRE88_CLR			0x0000ac38
#define CCM_PRE88_TOG			0x0000ac3c
#define CCM_ACCESS_CTRL88		0x0000ac70
#define CCM_ACCESS_CTRL88_SET		0x0000ac74
#define CCM_ACCESS_CTRL88_CLR		0x0000ac78
#define CCM_ACCESS_CTRL88_TOG		0x0000ac7c
#define CCM_TARGET_ROOT89		0x0000ac80
#define CCM_TARGET_ROOT89_SET		0x0000ac84
#define CCM_TARGET_ROOT89_CLR		0x0000ac88
#define CCM_TARGET_ROOT89_TOG		0x0000ac8c
#define CCM_MISC89			0x0000ac90
#define CCM_MISC89_SET			0x0000ac94
#define CCM_MISC89_CLR			0x0000ac98
#define CCM_MISC89_TOG			0x0000ac9c
#define CCM_POST89			0x0000aca0
#define CCM_POST89_SET			0x0000aca4
#define CCM_POST89_CLR			0x0000aca8
#define CCM_POST89_TOG			0x0000acac
#define CCM_PRE89			0x0000acb0
#define CCM_PRE89_SET			0x0000acb4
#define CCM_PRE89_CLR			0x0000acb8
#define CCM_PRE89_TOG			0x0000acbc
#define CCM_ACCESS_CTRL89		0x0000acf0
#define CCM_ACCESS_CTRL89_SET		0x0000acf4
#define CCM_ACCESS_CTRL89_CLR		0x0000acf8
#define CCM_ACCESS_CTRL89_TOG		0x0000acfc
#define CCM_TARGET_ROOT90		0x0000ad00
#define CCM_TARGET_ROOT90_SET		0x0000ad04
#define CCM_TARGET_ROOT90_CLR		0x0000ad08
#define CCM_TARGET_ROOT90_TOG		0x0000ad0c
#define CCM_MISC90			0x0000ad10
#define CCM_MISC90_SET			0x0000ad14
#define CCM_MISC90_CLR			0x0000ad18
#define CCM_MISC90_TOG			0x0000ad1c
#define CCM_POST90			0x0000ad20
#define CCM_POST90_SET			0x0000ad24
#define CCM_POST90_CLR			0x0000ad28
#define CCM_POST90_TOG			0x0000ad2c
#define CCM_PRE90			0x0000ad30
#define CCM_PRE90_SET			0x0000ad34
#define CCM_PRE90_CLR			0x0000ad38
#define CCM_PRE90_TOG			0x0000ad3c
#define CCM_ACCESS_CTRL90		0x0000ad70
#define CCM_ACCESS_CTRL90_SET		0x0000ad74
#define CCM_ACCESS_CTRL90_CLR		0x0000ad78
#define CCM_ACCESS_CTRL90_TOG		0x0000ad7c
#define CCM_TARGET_ROOT91		0x0000ad80
#define CCM_TARGET_ROOT91_SET		0x0000ad84
#define CCM_TARGET_ROOT91_CLR		0x0000ad88
#define CCM_TARGET_ROOT91_TOG		0x0000ad8c
#define CCM_MISC91			0x0000ad90
#define CCM_MISC91_SET			0x0000ad94
#define CCM_MISC91_CLR			0x0000ad98
#define CCM_MISC91_TOG			0x0000ad9c
#define CCM_POST91			0x0000ada0
#define CCM_POST91_SET			0x0000ada4
#define CCM_POST91_CLR			0x0000ada8
#define CCM_POST91_TOG			0x0000adac
#define CCM_PRE91			0x0000adb0
#define CCM_PRE91_SET			0x0000adb4
#define CCM_PRE91_CLR			0x0000adb8
#define CCM_PRE91_TOG			0x0000adbc
#define CCM_ACCESS_CTRL91		0x0000adf0
#define CCM_ACCESS_CTRL91_SET		0x0000adf4
#define CCM_ACCESS_CTRL91_CLR		0x0000adf8
#define CCM_ACCESS_CTRL91_TOG		0x0000adfc
#define CCM_TARGET_ROOT92		0x0000ae00
#define CCM_TARGET_ROOT92_SET		0x0000ae04
#define CCM_TARGET_ROOT92_CLR		0x0000ae08
#define CCM_TARGET_ROOT92_TOG		0x0000ae0c
#define CCM_MISC92			0x0000ae10
#define CCM_MISC92_SET			0x0000ae14
#define CCM_MISC92_CLR			0x0000ae18
#define CCM_MISC92_TOG			0x0000ae1c
#define CCM_POST92			0x0000ae20
#define CCM_POST92_SET			0x0000ae24
#define CCM_POST92_CLR			0x0000ae28
#define CCM_POST92_TOG			0x0000ae2c
#define CCM_PRE92			0x0000ae30
#define CCM_PRE92_SET			0x0000ae34
#define CCM_PRE92_CLR			0x0000ae38
#define CCM_PRE92_TOG			0x0000ae3c
#define CCM_ACCESS_CTRL92		0x0000ae70
#define CCM_ACCESS_CTRL92_SET		0x0000ae74
#define CCM_ACCESS_CTRL92_CLR		0x0000ae78
#define CCM_ACCESS_CTRL92_TOG		0x0000ae7c
#define CCM_TARGET_ROOT93		0x0000ae80
#define CCM_TARGET_ROOT93_SET		0x0000ae84
#define CCM_TARGET_ROOT93_CLR		0x0000ae88
#define CCM_TARGET_ROOT93_TOG		0x0000ae8c
#define CCM_MISC93			0x0000ae90
#define CCM_MISC93_SET			0x0000ae94
#define CCM_MISC93_CLR			0x0000ae98
#define CCM_MISC93_TOG			0x0000ae9c
#define CCM_POST93			0x0000aea0
#define CCM_POST93_SET			0x0000aea4
#define CCM_POST93_CLR			0x0000aea8
#define CCM_POST93_TOG			0x0000aeac
#define CCM_PRE93			0x0000aeb0
#define CCM_PRE93_SET			0x0000aeb4
#define CCM_PRE93_CLR			0x0000aeb8
#define CCM_PRE93_TOG			0x0000aebc
#define CCM_ACCESS_CTRL93		0x0000aef0
#define CCM_ACCESS_CTRL93_SET		0x0000aef4
#define CCM_ACCESS_CTRL93_CLR		0x0000aef8
#define CCM_ACCESS_CTRL93_TOG		0x0000aefc
#define CCM_TARGET_ROOT94		0x0000af00
#define CCM_TARGET_ROOT94_SET		0x0000af04
#define CCM_TARGET_ROOT94_CLR		0x0000af08
#define CCM_TARGET_ROOT94_TOG		0x0000af0c
#define CCM_MISC94			0x0000af10
#define CCM_MISC94_SET			0x0000af14
#define CCM_MISC94_CLR			0x0000af18
#define CCM_MISC94_TOG			0x0000af1c
#define CCM_POST94			0x0000af20
#define CCM_POST94_SET			0x0000af24
#define CCM_POST94_CLR			0x0000af28
#define CCM_POST94_TOG			0x0000af2c
#define CCM_PRE94			0x0000af30
#define CCM_PRE94_SET			0x0000af34
#define CCM_PRE94_CLR			0x0000af38
#define CCM_PRE94_TOG			0x0000af3c
#define CCM_ACCESS_CTRL94		0x0000af70
#define CCM_ACCESS_CTRL94_SET		0x0000af74
#define CCM_ACCESS_CTRL94_CLR		0x0000af78
#define CCM_ACCESS_CTRL94_TOG		0x0000af7c
#define CCM_TARGET_ROOT95		0x0000af80
#define CCM_TARGET_ROOT95_SET		0x0000af84
#define CCM_TARGET_ROOT95_CLR		0x0000af88
#define CCM_TARGET_ROOT95_TOG		0x0000af8c
#define CCM_MISC95			0x0000af90
#define CCM_MISC95_SET			0x0000af94
#define CCM_MISC95_CLR			0x0000af98
#define CCM_MISC95_TOG			0x0000af9c
#define CCM_POST95			0x0000afa0
#define CCM_POST95_SET			0x0000afa4
#define CCM_POST95_CLR			0x0000afa8
#define CCM_POST95_TOG			0x0000afac
#define CCM_PRE95			0x0000afb0
#define CCM_PRE95_SET			0x0000afb4
#define CCM_PRE95_CLR			0x0000afb8
#define CCM_PRE95_TOG			0x0000afbc
#define CCM_ACCESS_CTRL95		0x0000aff0
#define CCM_ACCESS_CTRL95_SET		0x0000aff4
#define CCM_ACCESS_CTRL95_CLR		0x0000aff8
#define CCM_ACCESS_CTRL95_TOG		0x0000affc
#define CCM_TARGET_ROOT96		0x0000b000
#define CCM_TARGET_ROOT96_SET		0x0000b004
#define CCM_TARGET_ROOT96_CLR		0x0000b008
#define CCM_TARGET_ROOT96_TOG		0x0000b00c
#define CCM_MISC96			0x0000b010
#define CCM_MISC96_SET			0x0000b014
#define CCM_MISC96_CLR			0x0000b018
#define CCM_MISC96_TOG			0x0000b01c
#define CCM_POST96			0x0000b020
#define CCM_POST96_SET			0x0000b024
#define CCM_POST96_CLR			0x0000b028
#define CCM_POST96_TOG			0x0000b02c
#define CCM_PRE96			0x0000b030
#define CCM_PRE96_SET			0x0000b034
#define CCM_PRE96_CLR			0x0000b038
#define CCM_PRE96_TOG			0x0000b03c
#define CCM_ACCESS_CTRL96		0x0000b070
#define CCM_ACCESS_CTRL96_SET		0x0000b074
#define CCM_ACCESS_CTRL96_CLR		0x0000b078
#define CCM_ACCESS_CTRL96_TOG		0x0000b07c
#define CCM_TARGET_ROOT97		0x0000b080
#define CCM_TARGET_ROOT97_SET		0x0000b084
#define CCM_TARGET_ROOT97_CLR		0x0000b088
#define CCM_TARGET_ROOT97_TOG		0x0000b08c
#define CCM_MISC97			0x0000b090
#define CCM_MISC97_SET			0x0000b094
#define CCM_MISC97_CLR			0x0000b098
#define CCM_MISC97_TOG			0x0000b09c
#define CCM_POST97			0x0000b0a0
#define CCM_POST97_SET			0x0000b0a4
#define CCM_POST97_CLR			0x0000b0a8
#define CCM_POST97_TOG			0x0000b0ac
#define CCM_PRE97			0x0000b0b0
#define CCM_PRE97_SET			0x0000b0b4
#define CCM_PRE97_CLR			0x0000b0b8
#define CCM_PRE97_TOG			0x0000b0bc
#define CCM_ACCESS_CTRL97		0x0000b0f0
#define CCM_ACCESS_CTRL97_SET		0x0000b0f4
#define CCM_ACCESS_CTRL97_CLR		0x0000b0f8
#define CCM_ACCESS_CTRL97_TOG		0x0000b0fc
#define CCM_TARGET_ROOT98		0x0000b100
#define CCM_TARGET_ROOT98_SET		0x0000b104
#define CCM_TARGET_ROOT98_CLR		0x0000b108
#define CCM_TARGET_ROOT98_TOG		0x0000b10c
#define CCM_MISC98			0x0000b110
#define CCM_MISC98_SET			0x0000b114
#define CCM_MISC98_CLR			0x0000b118
#define CCM_MISC98_TOG			0x0000b11c
#define CCM_POST98			0x0000b120
#define CCM_POST98_SET			0x0000b124
#define CCM_POST98_CLR			0x0000b128
#define CCM_POST98_TOG			0x0000b12c
#define CCM_PRE98			0x0000b130
#define CCM_PRE98_SET			0x0000b134
#define CCM_PRE98_CLR			0x0000b138
#define CCM_PRE98_TOG			0x0000b13c
#define CCM_ACCESS_CTRL98		0x0000b170
#define CCM_ACCESS_CTRL98_SET		0x0000b174
#define CCM_ACCESS_CTRL98_CLR		0x0000b178
#define CCM_ACCESS_CTRL98_TOG		0x0000b17c
#define CCM_TARGET_ROOT99		0x0000b180
#define CCM_TARGET_ROOT99_SET		0x0000b184
#define CCM_TARGET_ROOT99_CLR		0x0000b188
#define CCM_TARGET_ROOT99_TOG		0x0000b18c
#define CCM_MISC99			0x0000b190
#define CCM_MISC99_SET			0x0000b194
#define CCM_MISC99_CLR			0x0000b198
#define CCM_MISC99_TOG			0x0000b19c
#define CCM_POST99			0x0000b1a0
#define CCM_POST99_SET			0x0000b1a4
#define CCM_POST99_CLR			0x0000b1a8
#define CCM_POST99_TOG			0x0000b1ac
#define CCM_PRE99			0x0000b1b0
#define CCM_PRE99_SET			0x0000b1b4
#define CCM_PRE99_CLR			0x0000b1b8
#define CCM_PRE99_TOG			0x0000b1bc
#define CCM_ACCESS_CTRL99		0x0000b1f0
#define CCM_ACCESS_CTRL99_SET		0x0000b1f4
#define CCM_ACCESS_CTRL99_CLR		0x0000b1f8
#define CCM_ACCESS_CTRL99_TOG		0x0000b1fc
#define CCM_TARGET_ROOT100		0x0000b200
#define CCM_TARGET_ROOT100_SET		0x0000b204
#define CCM_TARGET_ROOT100_CLR		0x0000b208
#define CCM_TARGET_ROOT100_TOG		0x0000b20c
#define CCM_MISC100			0x0000b210
#define CCM_MISC100_SET			0x0000b214
#define CCM_MISC100_CLR			0x0000b218
#define CCM_MISC100_TOG			0x0000b21c
#define CCM_POST100			0x0000b220
#define CCM_POST100_SET			0x0000b224
#define CCM_POST100_CLR			0x0000b228
#define CCM_POST100_TOG			0x0000b22c
#define CCM_PRE100			0x0000b230
#define CCM_PRE100_SET			0x0000b234
#define CCM_PRE100_CLR			0x0000b238
#define CCM_PRE100_TOG			0x0000b23c
#define CCM_ACCESS_CTRL100		0x0000b270
#define CCM_ACCESS_CTRL100_SET		0x0000b274
#define CCM_ACCESS_CTRL100_CLR		0x0000b278
#define CCM_ACCESS_CTRL100_TOG		0x0000b27c
#define CCM_TARGET_ROOT101		0x0000b280
#define CCM_TARGET_ROOT101_SET		0x0000b284
#define CCM_TARGET_ROOT101_CLR		0x0000b288
#define CCM_TARGET_ROOT101_TOG		0x0000b28c
#define CCM_MISC101			0x0000b290
#define CCM_MISC101_SET			0x0000b294
#define CCM_MISC101_CLR			0x0000b298
#define CCM_MISC101_TOG			0x0000b29c
#define CCM_POST101			0x0000b2a0
#define CCM_POST101_SET			0x0000b2a4
#define CCM_POST101_CLR			0x0000b2a8
#define CCM_POST101_TOG			0x0000b2ac
#define CCM_PRE101			0x0000b2b0
#define CCM_PRE101_SET			0x0000b2b4
#define CCM_PRE101_CLR			0x0000b2b8
#define CCM_PRE101_TOG			0x0000b2bc
#define CCM_ACCESS_CTRL101		0x0000b2f0
#define CCM_ACCESS_CTRL101_SET		0x0000b2f4
#define CCM_ACCESS_CTRL101_CLR		0x0000b2f8
#define CCM_ACCESS_CTRL101_TOG		0x0000b2fc
#define CCM_TARGET_ROOT102		0x0000b300
#define CCM_TARGET_ROOT102_SET		0x0000b304
#define CCM_TARGET_ROOT102_CLR		0x0000b308
#define CCM_TARGET_ROOT102_TOG		0x0000b30c
#define CCM_MISC102			0x0000b310
#define CCM_MISC102_SET			0x0000b314
#define CCM_MISC102_CLR			0x0000b318
#define CCM_MISC102_TOG			0x0000b31c
#define CCM_POST102			0x0000b320
#define CCM_POST102_SET			0x0000b324
#define CCM_POST102_CLR			0x0000b328
#define CCM_POST102_TOG			0x0000b32c
#define CCM_PRE102			0x0000b330
#define CCM_PRE102_SET			0x0000b334
#define CCM_PRE102_CLR			0x0000b338
#define CCM_PRE102_TOG			0x0000b33c
#define CCM_ACCESS_CTRL102		0x0000b370
#define CCM_ACCESS_CTRL102_SET		0x0000b374
#define CCM_ACCESS_CTRL102_CLR		0x0000b378
#define CCM_ACCESS_CTRL102_TOG		0x0000b37c
#define CCM_TARGET_ROOT103		0x0000b380
#define CCM_TARGET_ROOT103_SET		0x0000b384
#define CCM_TARGET_ROOT103_CLR		0x0000b388
#define CCM_TARGET_ROOT103_TOG		0x0000b38c
#define CCM_MISC103			0x0000b390
#define CCM_MISC103_SET			0x0000b394
#define CCM_MISC103_CLR			0x0000b398
#define CCM_MISC103_TOG			0x0000b39c
#define CCM_POST103			0x0000b3a0
#define CCM_POST103_SET			0x0000b3a4
#define CCM_POST103_CLR			0x0000b3a8
#define CCM_POST103_TOG			0x0000b3ac
#define CCM_PRE103			0x0000b3b0
#define CCM_PRE103_SET			0x0000b3b4
#define CCM_PRE103_CLR			0x0000b3b8
#define CCM_PRE103_TOG			0x0000b3bc
#define CCM_ACCESS_CTRL103		0x0000b3f0
#define CCM_ACCESS_CTRL103_SET		0x0000b3f4
#define CCM_ACCESS_CTRL103_CLR		0x0000b3f8
#define CCM_ACCESS_CTRL103_TOG		0x0000b3fc
#define CCM_TARGET_ROOT104		0x0000b400
#define CCM_TARGET_ROOT104_SET		0x0000b404
#define CCM_TARGET_ROOT104_CLR		0x0000b408
#define CCM_TARGET_ROOT104_TOG		0x0000b40c
#define CCM_MISC104			0x0000b410
#define CCM_MISC104_SET			0x0000b414
#define CCM_MISC104_CLR			0x0000b418
#define CCM_MISC104_TOG			0x0000b41c
#define CCM_POST104			0x0000b420
#define CCM_POST104_SET			0x0000b424
#define CCM_POST104_CLR			0x0000b428
#define CCM_POST104_TOG			0x0000b42c
#define CCM_PRE104			0x0000b430
#define CCM_PRE104_SET			0x0000b434
#define CCM_PRE104_CLR			0x0000b438
#define CCM_PRE104_TOG			0x0000b43c
#define CCM_ACCESS_CTRL104		0x0000b470
#define CCM_ACCESS_CTRL104_SET		0x0000b474
#define CCM_ACCESS_CTRL104_CLR		0x0000b478
#define CCM_ACCESS_CTRL104_TOG		0x0000b47c
#define CCM_TARGET_ROOT105		0x0000b480
#define CCM_TARGET_ROOT105_SET		0x0000b484
#define CCM_TARGET_ROOT105_CLR		0x0000b488
#define CCM_TARGET_ROOT105_TOG		0x0000b48c
#define CCM_MISC105			0x0000b490
#define CCM_MISC105_SET			0x0000b494
#define CCM_MISC105_CLR			0x0000b498
#define CCM_MISC105_TOG			0x0000b49c
#define CCM_POST105			0x0000b4a0
#define CCM_POST105_SET			0x0000b4a4
#define CCM_POST105_CLR			0x0000b4a8
#define CCM_POST105_TOG			0x0000b4ac
#define CCM_PRE105			0x0000b4b0
#define CCM_PRE105_SET			0x0000b4b4
#define CCM_PRE105_CLR			0x0000b4b8
#define CCM_PRE105_TOG			0x0000b4bc
#define CCM_ACCESS_CTRL105		0x0000b4f0
#define CCM_ACCESS_CTRL105_SET		0x0000b4f4
#define CCM_ACCESS_CTRL105_CLR		0x0000b4f8
#define CCM_ACCESS_CTRL105_TOG		0x0000b4fc
#define CCM_TARGET_ROOT106		0x0000b500
#define CCM_TARGET_ROOT106_SET		0x0000b504
#define CCM_TARGET_ROOT106_CLR		0x0000b508
#define CCM_TARGET_ROOT106_TOG		0x0000b50c
#define CCM_MISC106			0x0000b510
#define CCM_MISC106_SET			0x0000b514
#define CCM_MISC106_CLR			0x0000b518
#define CCM_MISC106_TOG			0x0000b51c
#define CCM_POST106			0x0000b520
#define CCM_POST106_SET			0x0000b524
#define CCM_POST106_CLR			0x0000b528
#define CCM_POST106_TOG			0x0000b52c
#define CCM_PRE106			0x0000b530
#define CCM_PRE106_SET			0x0000b534
#define CCM_PRE106_CLR			0x0000b538
#define CCM_PRE106_TOG			0x0000b53c
#define CCM_ACCESS_CTRL106		0x0000b570
#define CCM_ACCESS_CTRL106_SET		0x0000b574
#define CCM_ACCESS_CTRL106_CLR		0x0000b578
#define CCM_ACCESS_CTRL106_TOG		0x0000b57c
#define CCM_TARGET_ROOT107		0x0000b580
#define CCM_TARGET_ROOT107_SET		0x0000b584
#define CCM_TARGET_ROOT107_CLR		0x0000b588
#define CCM_TARGET_ROOT107_TOG		0x0000b58c
#define CCM_MISC107			0x0000b590
#define CCM_MISC107_SET			0x0000b594
#define CCM_MISC107_CLR			0x0000b598
#define CCM_MISC107_TOG			0x0000b59c
#define CCM_POST107			0x0000b5a0
#define CCM_POST107_SET			0x0000b5a4
#define CCM_POST107_CLR			0x0000b5a8
#define CCM_POST107_TOG			0x0000b5ac
#define CCM_PRE107			0x0000b5b0
#define CCM_PRE107_SET			0x0000b5b4
#define CCM_PRE107_CLR			0x0000b5b8
#define CCM_PRE107_TOG			0x0000b5bc
#define CCM_ACCESS_CTRL107		0x0000b5f0
#define CCM_ACCESS_CTRL107_SET		0x0000b5f4
#define CCM_ACCESS_CTRL107_CLR		0x0000b5f8
#define CCM_ACCESS_CTRL107_TOG		0x0000b5fc
#define CCM_TARGET_ROOT108		0x0000b600
#define CCM_TARGET_ROOT108_SET		0x0000b604
#define CCM_TARGET_ROOT108_CLR		0x0000b608
#define CCM_TARGET_ROOT108_TOG		0x0000b60c
#define CCM_MISC108			0x0000b610
#define CCM_MISC108_SET			0x0000b614
#define CCM_MISC108_CLR			0x0000b618
#define CCM_MISC108_TOG			0x0000b61c
#define CCM_POST108			0x0000b620
#define CCM_POST108_SET			0x0000b624
#define CCM_POST108_CLR			0x0000b628
#define CCM_POST108_TOG			0x0000b62c
#define CCM_PRE108			0x0000b630
#define CCM_PRE108_SET			0x0000b634
#define CCM_PRE108_CLR			0x0000b638
#define CCM_PRE108_TOG			0x0000b63c
#define CCM_ACCESS_CTRL108		0x0000b670
#define CCM_ACCESS_CTRL108_SET		0x0000b674
#define CCM_ACCESS_CTRL108_CLR		0x0000b678
#define CCM_ACCESS_CTRL108_TOG		0x0000b67c
#define CCM_TARGET_ROOT109		0x0000b680
#define CCM_TARGET_ROOT109_SET		0x0000b684
#define CCM_TARGET_ROOT109_CLR		0x0000b688
#define CCM_TARGET_ROOT109_TOG		0x0000b68c
#define CCM_MISC109			0x0000b690
#define CCM_MISC109_SET			0x0000b694
#define CCM_MISC109_CLR			0x0000b698
#define CCM_MISC109_TOG			0x0000b69c
#define CCM_POST109			0x0000b6a0
#define CCM_POST109_SET			0x0000b6a4
#define CCM_POST109_CLR			0x0000b6a8
#define CCM_POST109_TOG			0x0000b6ac
#define CCM_PRE109			0x0000b6b0
#define CCM_PRE109_SET			0x0000b6b4
#define CCM_PRE109_CLR			0x0000b6b8
#define CCM_PRE109_TOG			0x0000b6bc
#define CCM_ACCESS_CTRL109		0x0000b6f0
#define CCM_ACCESS_CTRL109_SET		0x0000b6f4
#define CCM_ACCESS_CTRL109_CLR		0x0000b6f8
#define CCM_ACCESS_CTRL109_TOG		0x0000b6fc
#define CCM_TARGET_ROOT110		0x0000b700
#define CCM_TARGET_ROOT110_SET		0x0000b704
#define CCM_TARGET_ROOT110_CLR		0x0000b708
#define CCM_TARGET_ROOT110_TOG		0x0000b70c
#define CCM_MISC110			0x0000b710
#define CCM_MISC110_SET			0x0000b714
#define CCM_MISC110_CLR			0x0000b718
#define CCM_MISC110_TOG			0x0000b71c
#define CCM_POST110			0x0000b720
#define CCM_POST110_SET			0x0000b724
#define CCM_POST110_CLR			0x0000b728
#define CCM_POST110_TOG			0x0000b72c
#define CCM_PRE110			0x0000b730
#define CCM_PRE110_SET			0x0000b734
#define CCM_PRE110_CLR			0x0000b738
#define CCM_PRE110_TOG			0x0000b73c
#define CCM_ACCESS_CTRL110		0x0000b770
#define CCM_ACCESS_CTRL110_SET		0x0000b774
#define CCM_ACCESS_CTRL110_CLR		0x0000b778
#define CCM_ACCESS_CTRL110_TOG		0x0000b77c
#define CCM_TARGET_ROOT111		0x0000b780
#define CCM_TARGET_ROOT111_SET		0x0000b784
#define CCM_TARGET_ROOT111_CLR		0x0000b788
#define CCM_TARGET_ROOT111_TOG		0x0000b78c
#define CCM_MISC111			0x0000b790
#define CCM_MISC111_SET			0x0000b794
#define CCM_MISC111_CLR			0x0000b798
#define CCM_MISC111_TOG			0x0000b79c
#define CCM_POST111			0x0000b7a0
#define CCM_POST111_SET			0x0000b7a4
#define CCM_POST111_CLR			0x0000b7a8
#define CCM_POST111_TOG			0x0000b7ac
#define CCM_PRE111			0x0000b7b0
#define CCM_PRE111_SET			0x0000b7b4
#define CCM_PRE111_CLR			0x0000b7b8
#define CCM_PRE111_TOG			0x0000b7bc
#define CCM_ACCESS_CTRL111		0x0000b7f0
#define CCM_ACCESS_CTRL111_SET		0x0000b7f4
#define CCM_ACCESS_CTRL111_CLR		0x0000b7f8
#define CCM_ACCESS_CTRL111_TOG		0x0000b7fc
#define CCM_TARGET_ROOT112		0x0000b800
#define CCM_TARGET_ROOT112_SET		0x0000b804
#define CCM_TARGET_ROOT112_CLR		0x0000b808
#define CCM_TARGET_ROOT112_TOG		0x0000b80c
#define CCM_MISC112			0x0000b810
#define CCM_MISC112_SET			0x0000b814
#define CCM_MISC112_CLR			0x0000b818
#define CCM_MISC112_TOG			0x0000b81c
#define CCM_POST112			0x0000b820
#define CCM_POST112_SET			0x0000b824
#define CCM_POST112_CLR			0x0000b828
#define CCM_POST112_TOG			0x0000b82c
#define CCM_PRE112			0x0000b830
#define CCM_PRE112_SET			0x0000b834
#define CCM_PRE112_CLR			0x0000b838
#define CCM_PRE112_TOG			0x0000b83c
#define CCM_ACCESS_CTRL112		0x0000b870
#define CCM_ACCESS_CTRL112_SET		0x0000b874
#define CCM_ACCESS_CTRL112_CLR		0x0000b878
#define CCM_ACCESS_CTRL112_TOG		0x0000b87c
#define CCM_TARGET_ROOT113		0x0000b880
#define CCM_TARGET_ROOT113_SET		0x0000b884
#define CCM_TARGET_ROOT113_CLR		0x0000b888
#define CCM_TARGET_ROOT113_TOG		0x0000b88c
#define CCM_MISC113			0x0000b890
#define CCM_MISC113_SET			0x0000b894
#define CCM_MISC113_CLR			0x0000b898
#define CCM_MISC113_TOG			0x0000b89c
#define CCM_POST113			0x0000b8a0
#define CCM_POST113_SET			0x0000b8a4
#define CCM_POST113_CLR			0x0000b8a8
#define CCM_POST113_TOG			0x0000b8ac
#define CCM_PRE113			0x0000b8b0
#define CCM_PRE113_SET			0x0000b8b4
#define CCM_PRE113_CLR			0x0000b8b8
#define CCM_PRE113_TOG			0x0000b8bc
#define CCM_ACCESS_CTRL113		0x0000b8f0
#define CCM_ACCESS_CTRL113_SET		0x0000b8f4
#define CCM_ACCESS_CTRL113_CLR		0x0000b8f8
#define CCM_ACCESS_CTRL113_TOG		0x0000b8fc
#define CCM_TARGET_ROOT114		0x0000b900
#define CCM_TARGET_ROOT114_SET		0x0000b904
#define CCM_TARGET_ROOT114_CLR		0x0000b908
#define CCM_TARGET_ROOT114_TOG		0x0000b90c
#define CCM_MISC114			0x0000b910
#define CCM_MISC114_SET			0x0000b914
#define CCM_MISC114_CLR			0x0000b918
#define CCM_MISC114_TOG			0x0000b91c
#define CCM_POST114			0x0000b920
#define CCM_POST114_SET			0x0000b924
#define CCM_POST114_CLR			0x0000b928
#define CCM_POST114_TOG			0x0000b92c
#define CCM_PRE114			0x0000b930
#define CCM_PRE114_SET			0x0000b934
#define CCM_PRE114_CLR			0x0000b938
#define CCM_PRE114_TOG			0x0000b93c
#define CCM_ACCESS_CTRL114		0x0000b970
#define CCM_ACCESS_CTRL114_SET		0x0000b974
#define CCM_ACCESS_CTRL114_CLR		0x0000b978
#define CCM_ACCESS_CTRL114_TOG		0x0000b97c
#define CCM_TARGET_ROOT115		0x0000b980
#define CCM_TARGET_ROOT115_SET		0x0000b984
#define CCM_TARGET_ROOT115_CLR		0x0000b988
#define CCM_TARGET_ROOT115_TOG		0x0000b98c
#define CCM_MISC115			0x0000b990
#define CCM_MISC115_SET			0x0000b994
#define CCM_MISC115_CLR			0x0000b998
#define CCM_MISC115_TOG			0x0000b99c
#define CCM_POST115			0x0000b9a0
#define CCM_POST115_SET			0x0000b9a4
#define CCM_POST115_CLR			0x0000b9a8
#define CCM_POST115_TOG			0x0000b9ac
#define CCM_PRE115			0x0000b9b0
#define CCM_PRE115_SET			0x0000b9b4
#define CCM_PRE115_CLR			0x0000b9b8
#define CCM_PRE115_TOG			0x0000b9bc
#define CCM_ACCESS_CTRL115		0x0000b9f0
#define CCM_ACCESS_CTRL115_SET		0x0000b9f4
#define CCM_ACCESS_CTRL115_CLR		0x0000b9f8
#define CCM_ACCESS_CTRL115_TOG		0x0000b9fc
#define CCM_TARGET_ROOT116		0x0000ba00
#define CCM_TARGET_ROOT116_SET		0x0000ba04
#define CCM_TARGET_ROOT116_CLR		0x0000ba08
#define CCM_TARGET_ROOT116_TOG		0x0000ba0c
#define CCM_MISC116			0x0000ba10
#define CCM_MISC116_SET			0x0000ba14
#define CCM_MISC116_CLR			0x0000ba18
#define CCM_MISC116_TOG			0x0000ba1c
#define CCM_POST116			0x0000ba20
#define CCM_POST116_SET			0x0000ba24
#define CCM_POST116_CLR			0x0000ba28
#define CCM_POST116_TOG			0x0000ba2c
#define CCM_PRE116			0x0000ba30
#define CCM_PRE116_SET			0x0000ba34
#define CCM_PRE116_CLR			0x0000ba38
#define CCM_PRE116_TOG			0x0000ba3c
#define CCM_ACCESS_CTRL116		0x0000ba70
#define CCM_ACCESS_CTRL116_SET		0x0000ba74
#define CCM_ACCESS_CTRL116_CLR		0x0000ba78
#define CCM_ACCESS_CTRL116_TOG		0x0000ba7c
#define CCM_TARGET_ROOT117		0x0000ba80
#define CCM_TARGET_ROOT117_SET		0x0000ba84
#define CCM_TARGET_ROOT117_CLR		0x0000ba88
#define CCM_TARGET_ROOT117_TOG		0x0000ba8c
#define CCM_MISC117			0x0000ba90
#define CCM_MISC117_SET			0x0000ba94
#define CCM_MISC117_CLR			0x0000ba98
#define CCM_MISC117_TOG			0x0000ba9c
#define CCM_POST117			0x0000baa0
#define CCM_POST117_SET			0x0000baa4
#define CCM_POST117_CLR			0x0000baa8
#define CCM_POST117_TOG			0x0000baac
#define CCM_PRE117			0x0000bab0
#define CCM_PRE117_SET			0x0000bab4
#define CCM_PRE117_CLR			0x0000bab8
#define CCM_PRE117_TOG			0x0000babc
#define CCM_ACCESS_CTRL117		0x0000baf0
#define CCM_ACCESS_CTRL117_SET		0x0000baf4
#define CCM_ACCESS_CTRL117_CLR		0x0000baf8
#define CCM_ACCESS_CTRL117_TOG		0x0000bafc
#define CCM_TARGET_ROOT118		0x0000bb00
#define CCM_TARGET_ROOT118_SET		0x0000bb04
#define CCM_TARGET_ROOT118_CLR		0x0000bb08
#define CCM_TARGET_ROOT118_TOG		0x0000bb0c
#define CCM_MISC118			0x0000bb10
#define CCM_MISC118_SET			0x0000bb14
#define CCM_MISC118_CLR			0x0000bb18
#define CCM_MISC118_TOG			0x0000bb1c
#define CCM_POST118			0x0000bb20
#define CCM_POST118_SET			0x0000bb24
#define CCM_POST118_CLR			0x0000bb28
#define CCM_POST118_TOG			0x0000bb2c
#define CCM_PRE118			0x0000bb30
#define CCM_PRE118_SET			0x0000bb34
#define CCM_PRE118_CLR			0x0000bb38
#define CCM_PRE118_TOG			0x0000bb3c
#define CCM_ACCESS_CTRL118		0x0000bb70
#define CCM_ACCESS_CTRL118_SET		0x0000bb74
#define CCM_ACCESS_CTRL118_CLR		0x0000bb78
#define CCM_ACCESS_CTRL118_TOG		0x0000bb7c
#define CCM_TARGET_ROOT119		0x0000bb80
#define CCM_TARGET_ROOT119_SET		0x0000bb84
#define CCM_TARGET_ROOT119_CLR		0x0000bb88
#define CCM_TARGET_ROOT119_TOG		0x0000bb8c
#define CCM_MISC119			0x0000bb90
#define CCM_MISC119_SET			0x0000bb94
#define CCM_MISC119_CLR			0x0000bb98
#define CCM_MISC119_TOG			0x0000bb9c
#define CCM_POST119			0x0000bba0
#define CCM_POST119_SET			0x0000bba4
#define CCM_POST119_CLR			0x0000bba8
#define CCM_POST119_TOG			0x0000bbac
#define CCM_PRE119			0x0000bbb0
#define CCM_PRE119_SET			0x0000bbb4
#define CCM_PRE119_CLR			0x0000bbb8
#define CCM_PRE119_TOG			0x0000bbbc
#define CCM_ACCESS_CTRL119		0x0000bbf0
#define CCM_ACCESS_CTRL119_SET		0x0000bbf4
#define CCM_ACCESS_CTRL119_CLR		0x0000bbf8
#define CCM_ACCESS_CTRL119_TOG		0x0000bbfc
#define CCM_TARGET_ROOT120		0x0000bc00
#define CCM_TARGET_ROOT120_SET		0x0000bc04
#define CCM_TARGET_ROOT120_CLR		0x0000bc08
#define CCM_TARGET_ROOT120_TOG		0x0000bc0c
#define CCM_MISC120			0x0000bc10
#define CCM_MISC120_SET			0x0000bc14
#define CCM_MISC120_CLR			0x0000bc18
#define CCM_MISC120_TOG			0x0000bc1c
#define CCM_POST120			0x0000bc20
#define CCM_POST120_SET			0x0000bc24
#define CCM_POST120_CLR			0x0000bc28
#define CCM_POST120_TOG			0x0000bc2c
#define CCM_PRE120			0x0000bc30
#define CCM_PRE120_SET			0x0000bc34
#define CCM_PRE120_CLR			0x0000bc38
#define CCM_PRE120_TOG			0x0000bc3c
#define CCM_ACCESS_CTRL120		0x0000bc70
#define CCM_ACCESS_CTRL120_SET		0x0000bc74
#define CCM_ACCESS_CTRL120_CLR		0x0000bc78
#define CCM_ACCESS_CTRL120_TOG		0x0000bc7c
#define CCM_TARGET_ROOT121		0x0000bc80
#define CCM_TARGET_ROOT121_SET		0x0000bc84
#define CCM_TARGET_ROOT121_CLR		0x0000bc88
#define CCM_TARGET_ROOT121_TOG		0x0000bc8c
#define CCM_MISC121			0x0000bc90
#define CCM_MISC121_SET			0x0000bc94
#define CCM_MISC121_CLR			0x0000bc98
#define CCM_MISC121_TOG			0x0000bc9c
#define CCM_POST121			0x0000bca0
#define CCM_POST121_SET			0x0000bca4
#define CCM_POST121_CLR			0x0000bca8
#define CCM_POST121_TOG			0x0000bcac
#define CCM_PRE121			0x0000bcb0
#define CCM_PRE121_SET			0x0000bcb4
#define CCM_PRE121_CLR			0x0000bcb8
#define CCM_PRE121_TOG			0x0000bcbc
#define CCM_ACCESS_CTRL121		0x0000bcf0
#define CCM_ACCESS_CTRL121_SET		0x0000bcf4
#define CCM_ACCESS_CTRL121_CLR		0x0000bcf8
#define CCM_ACCESS_CTRL121_TOG		0x0000bcfc
#define CCM_TARGET_ROOT122		0x0000bd00
#define CCM_TARGET_ROOT122_SET		0x0000bd04
#define CCM_TARGET_ROOT122_CLR		0x0000bd08
#define CCM_TARGET_ROOT122_TOG		0x0000bd0c
#define CCM_MISC122			0x0000bd10
#define CCM_MISC122_SET			0x0000bd14
#define CCM_MISC122_CLR			0x0000bd18
#define CCM_MISC122_TOG			0x0000bd1c
#define CCM_POST122			0x0000bd20
#define CCM_POST122_SET			0x0000bd24
#define CCM_POST122_CLR			0x0000bd28
#define CCM_POST122_TOG			0x0000bd2c
#define CCM_PRE122			0x0000bd30
#define CCM_PRE122_SET			0x0000bd34
#define CCM_PRE122_CLR			0x0000bd38
#define CCM_PRE122_TOG			0x0000bd3c
#define CCM_ACCESS_CTRL122		0x0000bd70
#define CCM_ACCESS_CTRL122_SET		0x0000bd74
#define CCM_ACCESS_CTRL122_CLR		0x0000bd78
#define CCM_ACCESS_CTRL122_TOG		0x0000bd7c
#define CCM_TARGET_ROOT123		0x0000bd80
#define CCM_TARGET_ROOT123_SET		0x0000bd84
#define CCM_TARGET_ROOT123_CLR		0x0000bd88
#define CCM_TARGET_ROOT123_TOG		0x0000bd8c
#define CCM_MISC123			0x0000bd90
#define CCM_MISC123_SET			0x0000bd94
#define CCM_MISC123_CLR			0x0000bd98
#define CCM_MISC123_TOG			0x0000bd9c
#define CCM_POST123			0x0000bda0
#define CCM_POST123_SET			0x0000bda4
#define CCM_POST123_CLR			0x0000bda8
#define CCM_POST123_TOG			0x0000bdac
#define CCM_PRE123			0x0000bdb0
#define CCM_PRE123_SET			0x0000bdb4
#define CCM_PRE123_CLR			0x0000bdb8
#define CCM_PRE123_TOG			0x0000bdbc
#define CCM_ACCESS_CTRL123		0x0000bdf0
#define CCM_ACCESS_CTRL123_SET		0x0000bdf4
#define CCM_ACCESS_CTRL123_CLR		0x0000bdf8
#define CCM_ACCESS_CTRL123_TOG		0x0000bdfc
#define CCM_TARGET_ROOT124		0x0000be00
#define CCM_TARGET_ROOT124_SET		0x0000be04
#define CCM_TARGET_ROOT124_CLR		0x0000be08
#define CCM_TARGET_ROOT124_TOG		0x0000be0c
#define CCM_MISC124			0x0000be10
#define CCM_MISC124_SET			0x0000be14
#define CCM_MISC124_CLR			0x0000be18
#define CCM_MISC124_TOG			0x0000be1c
#define CCM_POST124			0x0000be20
#define CCM_POST124_SET			0x0000be24
#define CCM_POST124_CLR			0x0000be28
#define CCM_POST124_TOG			0x0000be2c
#define CCM_PRE124			0x0000be30
#define CCM_PRE124_SET			0x0000be34
#define CCM_PRE124_CLR			0x0000be38
#define CCM_PRE124_TOG			0x0000be3c
#define CCM_ACCESS_CTRL124		0x0000be70
#define CCM_ACCESS_CTRL124_SET		0x0000be74
#define CCM_ACCESS_CTRL124_CLR		0x0000be78
#define CCM_ACCESS_CTRL124_TOG		0x0000be7c

/* Target/Miscellaneous/PostDivider/PreDivider/AccessControl Register Mapping */
#define CCM_CLKROOT_ARM_A7_CLK_ROOT			CCM_TARGET_ROOT0
#define CCM_CLKROOT_ARM_A7_CLK_ROOT_SET			CCM_TARGET_ROOT0_SET
#define CCM_CLKROOT_ARM_A7_CLK_ROOT_CLR			CCM_TARGET_ROOT0_CLR
#define CCM_CLKROOT_ARM_A7_CLK_ROOT_TOG			CCM_TARGET_ROOT0_TOG
#define CCM_CLKROOT_ARM_A7_CLK_ROOT_MISC		CCM_MISC0
#define CCM_CLKROOT_ARM_A7_CLK_ROOT_MISC_SET		CCM_MISC0_SET
#define CCM_CLKROOT_ARM_A7_CLK_ROOT_MISC_CLR		CCM_MISC0_CLR
#define CCM_CLKROOT_ARM_A7_CLK_ROOT_MISC_TOG		CCM_MISC0_TOG
#define CCM_CLKROOT_ARM_A7_CLK_ROOT_POST		CCM_POST0
#define CCM_CLKROOT_ARM_A7_CLK_ROOT_POST_SET		CCM_POST0_SET
#define CCM_CLKROOT_ARM_A7_CLK_ROOT_POST_CLR		CCM_POST0_CLR
#define CCM_CLKROOT_ARM_A7_CLK_ROOT_POST_TOG		CCM_POST0_TOG
#define CCM_CLKROOT_ARM_A7_CLK_ROOT_PRE			CCM_PRE0
#define CCM_CLKROOT_ARM_A7_CLK_ROOT_PRE_SET		CCM_PRE0_SET
#define CCM_CLKROOT_ARM_A7_CLK_ROOT_PRE_CLR		CCM_PRE0_CLR
#define CCM_CLKROOT_ARM_A7_CLK_ROOT_PRE_TOG		CCM_PRE0_TOG
#define CCM_CLKROOT_ARM_A7_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL0
#define CCM_CLKROOT_ARM_A7_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL0_SET
#define CCM_CLKROOT_ARM_A7_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL0_CLR
#define CCM_CLKROOT_ARM_A7_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL0_TOG
#define CCM_CLKROOT_ARM_M4_CLK_ROOT			CCM_TARGET_ROOT1
#define CCM_CLKROOT_ARM_M4_CLK_ROOT_SET			CCM_TARGET_ROOT1_SET
#define CCM_CLKROOT_ARM_M4_CLK_ROOT_CLR			CCM_TARGET_ROOT1_CLR
#define CCM_CLKROOT_ARM_M4_CLK_ROOT_TOG			CCM_TARGET_ROOT1_TOG
#define CCM_CLKROOT_ARM_M4_CLK_ROOT_MISC		CCM_MISC1
#define CCM_CLKROOT_ARM_M4_CLK_ROOT_MISC_SET		CCM_MISC1_SET
#define CCM_CLKROOT_ARM_M4_CLK_ROOT_MISC_CLR		CCM_MISC1_CLR
#define CCM_CLKROOT_ARM_M4_CLK_ROOT_MISC_TOG		CCM_MISC1_TOG
#define CCM_CLKROOT_ARM_M4_CLK_ROOT_POST		CCM_POST1
#define CCM_CLKROOT_ARM_M4_CLK_ROOT_POST_SET		CCM_POST1_SET
#define CCM_CLKROOT_ARM_M4_CLK_ROOT_POST_CLR		CCM_POST1_CLR
#define CCM_CLKROOT_ARM_M4_CLK_ROOT_POST_TOG		CCM_POST1_TOG
#define CCM_CLKROOT_ARM_M4_CLK_ROOT_PRE			CCM_PRE1
#define CCM_CLKROOT_ARM_M4_CLK_ROOT_PRE_SET		CCM_PRE1_SET
#define CCM_CLKROOT_ARM_M4_CLK_ROOT_PRE_CLR		CCM_PRE1_CLR
#define CCM_CLKROOT_ARM_M4_CLK_ROOT_PRE_TOG		CCM_PRE1_TOG
#define CCM_CLKROOT_ARM_M4_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL1
#define CCM_CLKROOT_ARM_M4_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL1_SET
#define CCM_CLKROOT_ARM_M4_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL1_CLR
#define CCM_CLKROOT_ARM_M4_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL1_TOG
#define CCM_CLKROOT_MAIN_AXI_CLK_ROOT			CCM_TARGET_ROOT16
#define CCM_CLKROOT_MAIN_AXI_CLK_ROOT_SET		CCM_TARGET_ROOT16_SET
#define CCM_CLKROOT_MAIN_AXI_CLK_ROOT_CLR		CCM_TARGET_ROOT16_CLR
#define CCM_CLKROOT_MAIN_AXI_CLK_ROOT_TOG		CCM_TARGET_ROOT16_TOG
#define CCM_CLKROOT_MAIN_AXI_CLK_ROOT_MISC		CCM_MISC16
#define CCM_CLKROOT_MAIN_AXI_CLK_ROOT_MISC_SET		CCM_MISC16_SET
#define CCM_CLKROOT_MAIN_AXI_CLK_ROOT_MISC_CLR		CCM_MISC16_CLR
#define CCM_CLKROOT_MAIN_AXI_CLK_ROOT_MISC_TOG		CCM_MISC16_TOG
#define CCM_CLKROOT_MAIN_AXI_CLK_ROOT_POST		CCM_POST16
#define CCM_CLKROOT_MAIN_AXI_CLK_ROOT_POST_SET		CCM_POST16_SET
#define CCM_CLKROOT_MAIN_AXI_CLK_ROOT_POST_CLR		CCM_POST16_CLR
#define CCM_CLKROOT_MAIN_AXI_CLK_ROOT_POST_TOG		CCM_POST16_TOG
#define CCM_CLKROOT_MAIN_AXI_CLK_ROOT_PRE		CCM_PRE16
#define CCM_CLKROOT_MAIN_AXI_CLK_ROOT_PRE_SET		CCM_PRE16_SET
#define CCM_CLKROOT_MAIN_AXI_CLK_ROOT_PRE_CLR		CCM_PRE16_CLR
#define CCM_CLKROOT_MAIN_AXI_CLK_ROOT_PRE_TOG		CCM_PRE16_TOG
#define CCM_CLKROOT_MAIN_AXI_CLK_ROOT_ACCESS_CTRL	CCM_ACCESS_CTRL16
#define CCM_CLKROOT_MAIN_AXI_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL16_SET
#define CCM_CLKROOT_MAIN_AXI_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL16_CLR
#define CCM_CLKROOT_MAIN_AXI_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL16_TOG
#define CCM_CLKROOT_DISP_AXI_CLK_ROOT			CCM_TARGET_ROOT17
#define CCM_CLKROOT_DISP_AXI_CLK_ROOT_SET		CCM_TARGET_ROOT17_SET
#define CCM_CLKROOT_DISP_AXI_CLK_ROOT_CLR		CCM_TARGET_ROOT17_CLR
#define CCM_CLKROOT_DISP_AXI_CLK_ROOT_TOG		CCM_TARGET_ROOT17_TOG
#define CCM_CLKROOT_DISP_AXI_CLK_ROOT_MISC		CCM_MISC17
#define CCM_CLKROOT_DISP_AXI_CLK_ROOT_MISC_SET		CCM_MISC17_SET
#define CCM_CLKROOT_DISP_AXI_CLK_ROOT_MISC_CLR		CCM_MISC17_CLR
#define CCM_CLKROOT_DISP_AXI_CLK_ROOT_MISC_TOG		CCM_MISC17_TOG
#define CCM_CLKROOT_DISP_AXI_CLK_ROOT_POST		CCM_POST17
#define CCM_CLKROOT_DISP_AXI_CLK_ROOT_POST_SET		CCM_POST17_SET
#define CCM_CLKROOT_DISP_AXI_CLK_ROOT_POST_CLR		CCM_POST17_CLR
#define CCM_CLKROOT_DISP_AXI_CLK_ROOT_POST_TOG		CCM_POST17_TOG
#define CCM_CLKROOT_DISP_AXI_CLK_ROOT_PRE		CCM_PRE17
#define CCM_CLKROOT_DISP_AXI_CLK_ROOT_PRE_SET		CCM_PRE17_SET
#define CCM_CLKROOT_DISP_AXI_CLK_ROOT_PRE_CLR		CCM_PRE17_CLR
#define CCM_CLKROOT_DISP_AXI_CLK_ROOT_PRE_TOG		CCM_PRE17_TOG
#define CCM_CLKROOT_DISP_AXI_CLK_ROOT_ACCESS_CTRL	CCM_ACCESS_CTRL17
#define CCM_CLKROOT_DISP_AXI_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL17_SET
#define CCM_CLKROOT_DISP_AXI_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL17_CLR
#define CCM_CLKROOT_DISP_AXI_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL17_TOG
#define CCM_CLKROOT_ENET_AXI_CLK_ROOT			CCM_TARGET_ROOT18
#define CCM_CLKROOT_ENET_AXI_CLK_ROOT_SET		CCM_TARGET_ROOT18_SET
#define CCM_CLKROOT_ENET_AXI_CLK_ROOT_CLR		CCM_TARGET_ROOT18_CLR
#define CCM_CLKROOT_ENET_AXI_CLK_ROOT_TOG		CCM_TARGET_ROOT18_TOG
#define CCM_CLKROOT_ENET_AXI_CLK_ROOT_MISC		CCM_MISC18
#define CCM_CLKROOT_ENET_AXI_CLK_ROOT_MISC_SET		CCM_MISC18_SET
#define CCM_CLKROOT_ENET_AXI_CLK_ROOT_MISC_CLR		CCM_MISC18_CLR
#define CCM_CLKROOT_ENET_AXI_CLK_ROOT_MISC_TOG		CCM_MISC18_TOG
#define CCM_CLKROOT_ENET_AXI_CLK_ROOT_POST		CCM_POST18
#define CCM_CLKROOT_ENET_AXI_CLK_ROOT_POST_SET		CCM_POST18_SET
#define CCM_CLKROOT_ENET_AXI_CLK_ROOT_POST_CLR		CCM_POST18_CLR
#define CCM_CLKROOT_ENET_AXI_CLK_ROOT_POST_TOG		CCM_POST18_TOG
#define CCM_CLKROOT_ENET_AXI_CLK_ROOT_PRE		CCM_PRE18
#define CCM_CLKROOT_ENET_AXI_CLK_ROOT_PRE_SET		CCM_PRE18_SET
#define CCM_CLKROOT_ENET_AXI_CLK_ROOT_PRE_CLR		CCM_PRE18_CLR
#define CCM_CLKROOT_ENET_AXI_CLK_ROOT_PRE_TOG		CCM_PRE18_TOG
#define CCM_CLKROOT_ENET_AXI_CLK_ROOT_ACCESS_CTRL	CCM_ACCESS_CTRL18
#define CCM_CLKROOT_ENET_AXI_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL18_SET
#define CCM_CLKROOT_ENET_AXI_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL18_CLR
#define CCM_CLKROOT_ENET_AXI_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL18_TOG
#define CCM_CLKROOT_NAND_USDHC_BUS_CLK_ROOT		CCM_TARGET_ROOT19
#define CCM_CLKROOT_NAND_USDHC_BUS_CLK_ROOT_SET		CCM_TARGET_ROOT19_SET
#define CCM_CLKROOT_NAND_USDHC_BUS_CLK_ROOT_CLR		CCM_TARGET_ROOT19_CLR
#define CCM_CLKROOT_NAND_USDHC_BUS_CLK_ROOT_TOG		CCM_TARGET_ROOT19_TOG
#define CCM_CLKROOT_NAND_USDHC_BUS_CLK_ROOT_MISC	CCM_MISC19
#define CCM_CLKROOT_NAND_USDHC_BUS_CLK_ROOT_MISC_SET	CCM_MISC19_SET
#define CCM_CLKROOT_NAND_USDHC_BUS_CLK_ROOT_MISC_CLR	CCM_MISC19_CLR
#define CCM_CLKROOT_NAND_USDHC_BUS_CLK_ROOT_MISC_TOG	CCM_MISC19_TOG
#define CCM_CLKROOT_NAND_USDHC_BUS_CLK_ROOT_POST	CCM_POST19
#define CCM_CLKROOT_NAND_USDHC_BUS_CLK_ROOT_POST_SET	CCM_POST19_SET
#define CCM_CLKROOT_NAND_USDHC_BUS_CLK_ROOT_POST_CLR	CCM_POST19_CLR
#define CCM_CLKROOT_NAND_USDHC_BUS_CLK_ROOT_POST_TOG	CCM_POST19_TOG
#define CCM_CLKROOT_NAND_USDHC_BUS_CLK_ROOT_PRE		CCM_PRE19
#define CCM_CLKROOT_NAND_USDHC_BUS_CLK_ROOT_PRE_SET	CCM_PRE19_SET
#define CCM_CLKROOT_NAND_USDHC_BUS_CLK_ROOT_PRE_CLR	CCM_PRE19_CLR
#define CCM_CLKROOT_NAND_USDHC_BUS_CLK_ROOT_PRE_TOG	CCM_PRE19_TOG
#define CCM_CLKROOT_NAND_USDHC_BUS_CLK_ROOT_ACCESS_CTRL	CCM_ACCESS_CTRL19
#define CCM_CLKROOT_NAND_USDHC_BUS_CLK_ROOT_ACCESS_CTRL_SETCCM_ACCESS_CTRL19_SET
#define CCM_CLKROOT_NAND_USDHC_BUS_CLK_ROOT_ACCESS_CTRL_CLRCCM_ACCESS_CTRL19_CLR
#define CCM_CLKROOT_NAND_USDHC_BUS_CLK_ROOT_ACCESS_CTRL_TOGCCM_ACCESS_CTRL19_TOG
#define CCM_CLKROOT_AHB_CLK_ROOT			CCM_TARGET_ROOT32
#define CCM_CLKROOT_AHB_CLK_ROOT_SET			CCM_TARGET_ROOT32_SET
#define CCM_CLKROOT_AHB_CLK_ROOT_CLR			CCM_TARGET_ROOT32_CLR
#define CCM_CLKROOT_AHB_CLK_ROOT_TOG			CCM_TARGET_ROOT32_TOG
#define CCM_CLKROOT_AHB_CLK_ROOT_MISC			CCM_MISC32
#define CCM_CLKROOT_AHB_CLK_ROOT_MISC_SET		CCM_MISC32_SET
#define CCM_CLKROOT_AHB_CLK_ROOT_MISC_CLR		CCM_MISC32_CLR
#define CCM_CLKROOT_AHB_CLK_ROOT_MISC_TOG		CCM_MISC32_TOG
#define CCM_CLKROOT_AHB_CLK_ROOT_POST			CCM_POST32
#define CCM_CLKROOT_AHB_CLK_ROOT_POST_SET		CCM_POST32_SET
#define CCM_CLKROOT_AHB_CLK_ROOT_POST_CLR		CCM_POST32_CLR
#define CCM_CLKROOT_AHB_CLK_ROOT_POST_TOG		CCM_POST32_TOG
#define CCM_CLKROOT_AHB_CLK_ROOT_PRE			CCM_PRE32
#define CCM_CLKROOT_AHB_CLK_ROOT_PRE_SET		CCM_PRE32_SET
#define CCM_CLKROOT_AHB_CLK_ROOT_PRE_CLR		CCM_PRE32_CLR
#define CCM_CLKROOT_AHB_CLK_ROOT_PRE_TOG		CCM_PRE32_TOG
#define CCM_CLKROOT_AHB_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL32
#define CCM_CLKROOT_AHB_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL32_SET
#define CCM_CLKROOT_AHB_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL32_CLR
#define CCM_CLKROOT_AHB_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL32_TOG
#define CCM_CLKROOT_IPG_CLK_ROOT			CCM_TARGET_ROOT33
#define CCM_CLKROOT_IPG_CLK_ROOT_SET			CCM_TARGET_ROOT33_SET
#define CCM_CLKROOT_IPG_CLK_ROOT_CLR			CCM_TARGET_ROOT33_CLR
#define CCM_CLKROOT_IPG_CLK_ROOT_TOG			CCM_TARGET_ROOT33_TOG
#define CCM_CLKROOT_IPG_CLK_ROOT_MISC			CCM_MISC33
#define CCM_CLKROOT_IPG_CLK_ROOT_MISC_SET		CCM_MISC33_SET
#define CCM_CLKROOT_IPG_CLK_ROOT_MISC_CLR		CCM_MISC33_CLR
#define CCM_CLKROOT_IPG_CLK_ROOT_MISC_TOG		CCM_MISC33_TOG
#define CCM_CLKROOT_IPG_CLK_ROOT_POST			CCM_POST33
#define CCM_CLKROOT_IPG_CLK_ROOT_POST_SET		CCM_POST33_SET
#define CCM_CLKROOT_IPG_CLK_ROOT_POST_CLR		CCM_POST33_CLR
#define CCM_CLKROOT_IPG_CLK_ROOT_POST_TOG		CCM_POST33_TOG
#define CCM_CLKROOT_IPG_CLK_ROOT_PRE			CCM_PRE33
#define CCM_CLKROOT_IPG_CLK_ROOT_PRE_SET		CCM_PRE33_SET
#define CCM_CLKROOT_IPG_CLK_ROOT_PRE_CLR		CCM_PRE33_CLR
#define CCM_CLKROOT_IPG_CLK_ROOT_PRE_TOG		CCM_PRE33_TOG
#define CCM_CLKROOT_IPG_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL33
#define CCM_CLKROOT_IPG_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL33_SET
#define CCM_CLKROOT_IPG_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL33_CLR
#define CCM_CLKROOT_IPG_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL33_TOG
#define CCM_CLKROOT_DRAM_PHYM_CLK_ROOT			CCM_TARGET_ROOT48
#define CCM_CLKROOT_DRAM_PHYM_CLK_ROOT_SET		CCM_TARGET_ROOT48_SET
#define CCM_CLKROOT_DRAM_PHYM_CLK_ROOT_CLR		CCM_TARGET_ROOT48_CLR
#define CCM_CLKROOT_DRAM_PHYM_CLK_ROOT_TOG		CCM_TARGET_ROOT48_TOG
#define CCM_CLKROOT_DRAM_PHYM_CLK_ROOT_MISC		CCM_MISC48
#define CCM_CLKROOT_DRAM_PHYM_CLK_ROOT_MISC_SET		CCM_MISC48_SET
#define CCM_CLKROOT_DRAM_PHYM_CLK_ROOT_MISC_CLR		CCM_MISC48_CLR
#define CCM_CLKROOT_DRAM_PHYM_CLK_ROOT_MISC_TOG		CCM_MISC48_TOG
#define CCM_CLKROOT_DRAM_PHYM_CLK_ROOT_POST		CCM_POST48
#define CCM_CLKROOT_DRAM_PHYM_CLK_ROOT_POST_SET		CCM_POST48_SET
#define CCM_CLKROOT_DRAM_PHYM_CLK_ROOT_POST_CLR		CCM_POST48_CLR
#define CCM_CLKROOT_DRAM_PHYM_CLK_ROOT_POST_TOG		CCM_POST48_TOG
#define CCM_CLKROOT_DRAM_PHYM_CLK_ROOT_PRE		CCM_PRE48
#define CCM_CLKROOT_DRAM_PHYM_CLK_ROOT_PRE_SET		CCM_PRE48_SET
#define CCM_CLKROOT_DRAM_PHYM_CLK_ROOT_PRE_CLR		CCM_PRE48_CLR
#define CCM_CLKROOT_DRAM_PHYM_CLK_ROOT_PRE_TOG		CCM_PRE48_TOG
#define CCM_CLKROOT_DRAM_PHYM_CLK_ROOT_ACCESS_CTRL	CCM_ACCESS_CTRL48
#define CCM_CLKROOT_DRAM_PHYM_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL48_SET
#define CCM_CLKROOT_DRAM_PHYM_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL48_CLR
#define CCM_CLKROOT_DRAM_PHYM_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL48_TOG
#define CCM_CLKROOT_DRAM_CLK_ROOT			CCM_TARGET_ROOT49
#define CCM_CLKROOT_DRAM_CLK_ROOT_SET			CCM_TARGET_ROOT49_SET
#define CCM_CLKROOT_DRAM_CLK_ROOT_CLR			CCM_TARGET_ROOT49_CLR
#define CCM_CLKROOT_DRAM_CLK_ROOT_TOG			CCM_TARGET_ROOT49_TOG
#define CCM_CLKROOT_DRAM_CLK_ROOT_MISC			CCM_MISC49
#define CCM_CLKROOT_DRAM_CLK_ROOT_MISC_SET		CCM_MISC49_SET
#define CCM_CLKROOT_DRAM_CLK_ROOT_MISC_CLR		CCM_MISC49_CLR
#define CCM_CLKROOT_DRAM_CLK_ROOT_MISC_TOG		CCM_MISC49_TOG
#define CCM_CLKROOT_DRAM_CLK_ROOT_POST			CCM_POST49
#define CCM_CLKROOT_DRAM_CLK_ROOT_POST_SET		CCM_POST49_SET
#define CCM_CLKROOT_DRAM_CLK_ROOT_POST_CLR		CCM_POST49_CLR
#define CCM_CLKROOT_DRAM_CLK_ROOT_POST_TOG		CCM_POST49_TOG
#define CCM_CLKROOT_DRAM_CLK_ROOT_PRE			CCM_PRE49
#define CCM_CLKROOT_DRAM_CLK_ROOT_PRE_SET		CCM_PRE49_SET
#define CCM_CLKROOT_DRAM_CLK_ROOT_PRE_CLR		CCM_PRE49_CLR
#define CCM_CLKROOT_DRAM_CLK_ROOT_PRE_TOG		CCM_PRE49_TOG
#define CCM_CLKROOT_DRAM_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL49
#define CCM_CLKROOT_DRAM_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL49_SET
#define CCM_CLKROOT_DRAM_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL49_CLR
#define CCM_CLKROOT_DRAM_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL49_TOG
#define CCM_CLKROOT_DRAM_PHYM_ALT_CLK_ROOT		CCM_TARGET_ROOT64
#define CCM_CLKROOT_DRAM_PHYM_ALT_CLK_ROOT_SET		CCM_TARGET_ROOT64_SET
#define CCM_CLKROOT_DRAM_PHYM_ALT_CLK_ROOT_CLR		CCM_TARGET_ROOT64_CLR
#define CCM_CLKROOT_DRAM_PHYM_ALT_CLK_ROOT_TOG		CCM_TARGET_ROOT64_TOG
#define CCM_CLKROOT_DRAM_PHYM_ALT_CLK_ROOT_MISC		CCM_MISC64
#define CCM_CLKROOT_DRAM_PHYM_ALT_CLK_ROOT_MISC_SET	CCM_MISC64_SET
#define CCM_CLKROOT_DRAM_PHYM_ALT_CLK_ROOT_MISC_CLR	CCM_MISC64_CLR
#define CCM_CLKROOT_DRAM_PHYM_ALT_CLK_ROOT_MISC_TOG	CCM_MISC64_TOG
#define CCM_CLKROOT_DRAM_PHYM_ALT_CLK_ROOT_POST		CCM_POST64
#define CCM_CLKROOT_DRAM_PHYM_ALT_CLK_ROOT_POST_SET	CCM_POST64_SET
#define CCM_CLKROOT_DRAM_PHYM_ALT_CLK_ROOT_POST_CLR	CCM_POST64_CLR
#define CCM_CLKROOT_DRAM_PHYM_ALT_CLK_ROOT_POST_TOG	CCM_POST64_TOG
#define CCM_CLKROOT_DRAM_PHYM_ALT_CLK_ROOT_PRE		CCM_PRE64
#define CCM_CLKROOT_DRAM_PHYM_ALT_CLK_ROOT_PRE_SET	CCM_PRE64_SET
#define CCM_CLKROOT_DRAM_PHYM_ALT_CLK_ROOT_PRE_CLR	CCM_PRE64_CLR
#define CCM_CLKROOT_DRAM_PHYM_ALT_CLK_ROOT_PRE_TOG	CCM_PRE64_TOG
#define CCM_CLKROOT_DRAM_PHYM_ALT_CLK_ROOT_ACCESS_CTRL	CCM_ACCESS_CTRL64
#define CCM_CLKROOT_DRAM_PHYM_ALT_CLK_ROOT_ACCESS_CTRL_SETCCM_ACCESS_CTRL64_SET
#define CCM_CLKROOT_DRAM_PHYM_ALT_CLK_ROOT_ACCESS_CTRL_CLRCCM_ACCESS_CTRL64_CLR
#define CCM_CLKROOT_DRAM_PHYM_ALT_CLK_ROOT_ACCESS_CTRL_TOGCCM_ACCESS_CTRL64_TOG
#define CCM_CLKROOT_DRAM_ALT_CLK_ROOT			CCM_TARGET_ROOT65
#define CCM_CLKROOT_DRAM_ALT_CLK_ROOT_SET		CCM_TARGET_ROOT65_SET
#define CCM_CLKROOT_DRAM_ALT_CLK_ROOT_CLR		CCM_TARGET_ROOT65_CLR
#define CCM_CLKROOT_DRAM_ALT_CLK_ROOT_TOG		CCM_TARGET_ROOT65_TOG
#define CCM_CLKROOT_DRAM_ALT_CLK_ROOT_MISC		CCM_MISC65
#define CCM_CLKROOT_DRAM_ALT_CLK_ROOT_MISC_SET		CCM_MISC65_SET
#define CCM_CLKROOT_DRAM_ALT_CLK_ROOT_MISC_CLR		CCM_MISC65_CLR
#define CCM_CLKROOT_DRAM_ALT_CLK_ROOT_MISC_TOG		CCM_MISC65_TOG
#define CCM_CLKROOT_DRAM_ALT_CLK_ROOT_POST		CCM_POST65
#define CCM_CLKROOT_DRAM_ALT_CLK_ROOT_POST_SET		CCM_POST65_SET
#define CCM_CLKROOT_DRAM_ALT_CLK_ROOT_POST_CLR		CCM_POST65_CLR
#define CCM_CLKROOT_DRAM_ALT_CLK_ROOT_POST_TOG		CCM_POST65_TOG
#define CCM_CLKROOT_DRAM_ALT_CLK_ROOT_PRE		CCM_PRE65
#define CCM_CLKROOT_DRAM_ALT_CLK_ROOT_PRE_SET		CCM_PRE65_SET
#define CCM_CLKROOT_DRAM_ALT_CLK_ROOT_PRE_CLR		CCM_PRE65_CLR
#define CCM_CLKROOT_DRAM_ALT_CLK_ROOT_PRE_TOG		CCM_PRE65_TOG
#define CCM_CLKROOT_DRAM_ALT_CLK_ROOT_ACCESS_CTRL	CCM_ACCESS_CTRL65
#define CCM_CLKROOT_DRAM_ALT_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL65_SET
#define CCM_CLKROOT_DRAM_ALT_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL65_CLR
#define CCM_CLKROOT_DRAM_ALT_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL65_TOG
#define CCM_CLKROOT_USB_HSIC_CLK_ROOT			CCM_TARGET_ROOT66
#define CCM_CLKROOT_USB_HSIC_CLK_ROOT_SET		CCM_TARGET_ROOT66_SET
#define CCM_CLKROOT_USB_HSIC_CLK_ROOT_CLR		CCM_TARGET_ROOT66_CLR
#define CCM_CLKROOT_USB_HSIC_CLK_ROOT_TOG		CCM_TARGET_ROOT66_TOG
#define CCM_CLKROOT_USB_HSIC_CLK_ROOT_MISC		CCM_MISC66
#define CCM_CLKROOT_USB_HSIC_CLK_ROOT_MISC_SET		CCM_MISC66_SET
#define CCM_CLKROOT_USB_HSIC_CLK_ROOT_MISC_CLR		CCM_MISC66_CLR
#define CCM_CLKROOT_USB_HSIC_CLK_ROOT_MISC_TOG		CCM_MISC66_TOG
#define CCM_CLKROOT_USB_HSIC_CLK_ROOT_POST		CCM_POST66
#define CCM_CLKROOT_USB_HSIC_CLK_ROOT_POST_SET		CCM_POST66_SET
#define CCM_CLKROOT_USB_HSIC_CLK_ROOT_POST_CLR		CCM_POST66_CLR
#define CCM_CLKROOT_USB_HSIC_CLK_ROOT_POST_TOG		CCM_POST66_TOG
#define CCM_CLKROOT_USB_HSIC_CLK_ROOT_PRE		CCM_PRE66
#define CCM_CLKROOT_USB_HSIC_CLK_ROOT_PRE_SET		CCM_PRE66_SET
#define CCM_CLKROOT_USB_HSIC_CLK_ROOT_PRE_CLR		CCM_PRE66_CLR
#define CCM_CLKROOT_USB_HSIC_CLK_ROOT_PRE_TOG		CCM_PRE66_TOG
#define CCM_CLKROOT_USB_HSIC_CLK_ROOT_ACCESS_CTRL	CCM_ACCESS_CTRL66
#define CCM_CLKROOT_USB_HSIC_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL66_SET
#define CCM_CLKROOT_USB_HSIC_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL66_CLR
#define CCM_CLKROOT_USB_HSIC_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL66_TOG
#define CCM_CLKROOT_PCIE_CTRL_CLK_ROOT			CCM_TARGET_ROOT67
#define CCM_CLKROOT_PCIE_CTRL_CLK_ROOT_SET		CCM_TARGET_ROOT67_SET
#define CCM_CLKROOT_PCIE_CTRL_CLK_ROOT_CLR		CCM_TARGET_ROOT67_CLR
#define CCM_CLKROOT_PCIE_CTRL_CLK_ROOT_TOG		CCM_TARGET_ROOT67_TOG
#define CCM_CLKROOT_PCIE_CTRL_CLK_ROOT_MISC		CCM_MISC67
#define CCM_CLKROOT_PCIE_CTRL_CLK_ROOT_MISC_SET		CCM_MISC67_SET
#define CCM_CLKROOT_PCIE_CTRL_CLK_ROOT_MISC_CLR		CCM_MISC67_CLR
#define CCM_CLKROOT_PCIE_CTRL_CLK_ROOT_MISC_TOG		CCM_MISC67_TOG
#define CCM_CLKROOT_PCIE_CTRL_CLK_ROOT_POST		CCM_POST67
#define CCM_CLKROOT_PCIE_CTRL_CLK_ROOT_POST_SET		CCM_POST67_SET
#define CCM_CLKROOT_PCIE_CTRL_CLK_ROOT_POST_CLR		CCM_POST67_CLR
#define CCM_CLKROOT_PCIE_CTRL_CLK_ROOT_POST_TOG		CCM_POST67_TOG
#define CCM_CLKROOT_PCIE_CTRL_CLK_ROOT_PRE		CCM_PRE67
#define CCM_CLKROOT_PCIE_CTRL_CLK_ROOT_PRE_SET		CCM_PRE67_SET
#define CCM_CLKROOT_PCIE_CTRL_CLK_ROOT_PRE_CLR		CCM_PRE67_CLR
#define CCM_CLKROOT_PCIE_CTRL_CLK_ROOT_PRE_TOG		CCM_PRE67_TOG
#define CCM_CLKROOT_PCIE_CTRL_CLK_ROOT_ACCESS_CTRL	CCM_ACCESS_CTRL67
#define CCM_CLKROOT_PCIE_CTRL_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL67_SET
#define CCM_CLKROOT_PCIE_CTRL_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL67_CLR
#define CCM_CLKROOT_PCIE_CTRL_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL67_TOG
#define CCM_CLKROOT_PCIE_PHY_CLK_ROOT			CCM_TARGET_ROOT68
#define CCM_CLKROOT_PCIE_PHY_CLK_ROOT_SET		CCM_TARGET_ROOT68_SET
#define CCM_CLKROOT_PCIE_PHY_CLK_ROOT_CLR		CCM_TARGET_ROOT68_CLR
#define CCM_CLKROOT_PCIE_PHY_CLK_ROOT_TOG		CCM_TARGET_ROOT68_TOG
#define CCM_CLKROOT_PCIE_PHY_CLK_ROOT_MISC		CCM_MISC68
#define CCM_CLKROOT_PCIE_PHY_CLK_ROOT_MISC_SET		CCM_MISC68_SET
#define CCM_CLKROOT_PCIE_PHY_CLK_ROOT_MISC_CLR		CCM_MISC68_CLR
#define CCM_CLKROOT_PCIE_PHY_CLK_ROOT_MISC_TOG		CCM_MISC68_TOG
#define CCM_CLKROOT_PCIE_PHY_CLK_ROOT_POST		CCM_POST68
#define CCM_CLKROOT_PCIE_PHY_CLK_ROOT_POST_SET		CCM_POST68_SET
#define CCM_CLKROOT_PCIE_PHY_CLK_ROOT_POST_CLR		CCM_POST68_CLR
#define CCM_CLKROOT_PCIE_PHY_CLK_ROOT_POST_TOG		CCM_POST68_TOG
#define CCM_CLKROOT_PCIE_PHY_CLK_ROOT_PRE		CCM_PRE68
#define CCM_CLKROOT_PCIE_PHY_CLK_ROOT_PRE_SET		CCM_PRE68_SET
#define CCM_CLKROOT_PCIE_PHY_CLK_ROOT_PRE_CLR		CCM_PRE68_CLR
#define CCM_CLKROOT_PCIE_PHY_CLK_ROOT_PRE_TOG		CCM_PRE68_TOG
#define CCM_CLKROOT_PCIE_PHY_CLK_ROOT_ACCESS_CTRL	CCM_ACCESS_CTRL68
#define CCM_CLKROOT_PCIE_PHY_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL68_SET
#define CCM_CLKROOT_PCIE_PHY_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL68_CLR
#define CCM_CLKROOT_PCIE_PHY_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL68_TOG
#define CCM_CLKROOT_EPDC_PIXEL_CLK_ROOT			CCM_TARGET_ROOT69
#define CCM_CLKROOT_EPDC_PIXEL_CLK_ROOT_SET		CCM_TARGET_ROOT69_SET
#define CCM_CLKROOT_EPDC_PIXEL_CLK_ROOT_CLR		CCM_TARGET_ROOT69_CLR
#define CCM_CLKROOT_EPDC_PIXEL_CLK_ROOT_TOG		CCM_TARGET_ROOT69_TOG
#define CCM_CLKROOT_EPDC_PIXEL_CLK_ROOT_MISC		CCM_MISC69
#define CCM_CLKROOT_EPDC_PIXEL_CLK_ROOT_MISC_SET	CCM_MISC69_SET
#define CCM_CLKROOT_EPDC_PIXEL_CLK_ROOT_MISC_CLR	CCM_MISC69_CLR
#define CCM_CLKROOT_EPDC_PIXEL_CLK_ROOT_MISC_TOG	CCM_MISC69_TOG
#define CCM_CLKROOT_EPDC_PIXEL_CLK_ROOT_POST		CCM_POST69
#define CCM_CLKROOT_EPDC_PIXEL_CLK_ROOT_POST_SET	CCM_POST69_SET
#define CCM_CLKROOT_EPDC_PIXEL_CLK_ROOT_POST_CLR	CCM_POST69_CLR
#define CCM_CLKROOT_EPDC_PIXEL_CLK_ROOT_POST_TOG	CCM_POST69_TOG
#define CCM_CLKROOT_EPDC_PIXEL_CLK_ROOT_PRE		CCM_PRE69
#define CCM_CLKROOT_EPDC_PIXEL_CLK_ROOT_PRE_SET		CCM_PRE69_SET
#define CCM_CLKROOT_EPDC_PIXEL_CLK_ROOT_PRE_CLR		CCM_PRE69_CLR
#define CCM_CLKROOT_EPDC_PIXEL_CLK_ROOT_PRE_TOG		CCM_PRE69_TOG
#define CCM_CLKROOT_EPDC_PIXEL_CLK_ROOT_ACCESS_CTRL	CCM_ACCESS_CTRL69
#define CCM_CLKROOT_EPDC_PIXEL_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL69_SET
#define CCM_CLKROOT_EPDC_PIXEL_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL69_CLR
#define CCM_CLKROOT_EPDC_PIXEL_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL69_TOG
#define CCM_CLKROOT_LCDIF_PIXEL_CLK_ROOT		CCM_TARGET_ROOT70
#define CCM_CLKROOT_LCDIF_PIXEL_CLK_ROOT_SET		CCM_TARGET_ROOT70_SET
#define CCM_CLKROOT_LCDIF_PIXEL_CLK_ROOT_CLR		CCM_TARGET_ROOT70_CLR
#define CCM_CLKROOT_LCDIF_PIXEL_CLK_ROOT_TOG		CCM_TARGET_ROOT70_TOG
#define CCM_CLKROOT_LCDIF_PIXEL_CLK_ROOT_MISC		CCM_MISC70
#define CCM_CLKROOT_LCDIF_PIXEL_CLK_ROOT_MISC_SET	CCM_MISC70_SET
#define CCM_CLKROOT_LCDIF_PIXEL_CLK_ROOT_MISC_CLR	CCM_MISC70_CLR
#define CCM_CLKROOT_LCDIF_PIXEL_CLK_ROOT_MISC_TOG	CCM_MISC70_TOG
#define CCM_CLKROOT_LCDIF_PIXEL_CLK_ROOT_POST		CCM_POST70
#define CCM_CLKROOT_LCDIF_PIXEL_CLK_ROOT_POST_SET	CCM_POST70_SET
#define CCM_CLKROOT_LCDIF_PIXEL_CLK_ROOT_POST_CLR	CCM_POST70_CLR
#define CCM_CLKROOT_LCDIF_PIXEL_CLK_ROOT_POST_TOG	CCM_POST70_TOG
#define CCM_CLKROOT_LCDIF_PIXEL_CLK_ROOT_PRE		CCM_PRE70
#define CCM_CLKROOT_LCDIF_PIXEL_CLK_ROOT_PRE_SET	CCM_PRE70_SET
#define CCM_CLKROOT_LCDIF_PIXEL_CLK_ROOT_PRE_CLR	CCM_PRE70_CLR
#define CCM_CLKROOT_LCDIF_PIXEL_CLK_ROOT_PRE_TOG	CCM_PRE70_TOG
#define CCM_CLKROOT_LCDIF_PIXEL_CLK_ROOT_ACCESS_CTRL	CCM_ACCESS_CTRL70
#define CCM_CLKROOT_LCDIF_PIXEL_CLK_ROOT_ACCESS_CTRL_SETCCM_ACCESS_CTRL70_SET
#define CCM_CLKROOT_LCDIF_PIXEL_CLK_ROOT_ACCESS_CTRL_CLRCCM_ACCESS_CTRL70_CLR
#define CCM_CLKROOT_LCDIF_PIXEL_CLK_ROOT_ACCESS_CTRL_TOGCCM_ACCESS_CTRL70_TOG
#define CCM_CLKROOT_MIPI_DSI_CLK_ROOT			CCM_TARGET_ROOT71
#define CCM_CLKROOT_MIPI_DSI_CLK_ROOT_SET		CCM_TARGET_ROOT71_SET
#define CCM_CLKROOT_MIPI_DSI_CLK_ROOT_CLR		CCM_TARGET_ROOT71_CLR
#define CCM_CLKROOT_MIPI_DSI_CLK_ROOT_TOG		CCM_TARGET_ROOT71_TOG
#define CCM_CLKROOT_MIPI_DSI_CLK_ROOT_MISC		CCM_MISC71
#define CCM_CLKROOT_MIPI_DSI_CLK_ROOT_MISC_SET		CCM_MISC71_SET
#define CCM_CLKROOT_MIPI_DSI_CLK_ROOT_MISC_CLR		CCM_MISC71_CLR
#define CCM_CLKROOT_MIPI_DSI_CLK_ROOT_MISC_TOG		CCM_MISC71_TOG
#define CCM_CLKROOT_MIPI_DSI_CLK_ROOT_POST		CCM_POST71
#define CCM_CLKROOT_MIPI_DSI_CLK_ROOT_POST_SET		CCM_POST71_SET
#define CCM_CLKROOT_MIPI_DSI_CLK_ROOT_POST_CLR		CCM_POST71_CLR
#define CCM_CLKROOT_MIPI_DSI_CLK_ROOT_POST_TOG		CCM_POST71_TOG
#define CCM_CLKROOT_MIPI_DSI_CLK_ROOT_PRE		CCM_PRE71
#define CCM_CLKROOT_MIPI_DSI_CLK_ROOT_PRE_SET		CCM_PRE71_SET
#define CCM_CLKROOT_MIPI_DSI_CLK_ROOT_PRE_CLR		CCM_PRE71_CLR
#define CCM_CLKROOT_MIPI_DSI_CLK_ROOT_PRE_TOG		CCM_PRE71_TOG
#define CCM_CLKROOT_MIPI_DSI_CLK_ROOT_ACCESS_CTRL	CCM_ACCESS_CTRL71
#define CCM_CLKROOT_MIPI_DSI_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL71_SET
#define CCM_CLKROOT_MIPI_DSI_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL71_CLR
#define CCM_CLKROOT_MIPI_DSI_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL71_TOG
#define CCM_CLKROOT_MIPI_CSI_CLK_ROOT			CCM_TARGET_ROOT72
#define CCM_CLKROOT_MIPI_CSI_CLK_ROOT_SET		CCM_TARGET_ROOT72_SET
#define CCM_CLKROOT_MIPI_CSI_CLK_ROOT_CLR		CCM_TARGET_ROOT72_CLR
#define CCM_CLKROOT_MIPI_CSI_CLK_ROOT_TOG		CCM_TARGET_ROOT72_TOG
#define CCM_CLKROOT_MIPI_CSI_CLK_ROOT_MISC		CCM_MISC72
#define CCM_CLKROOT_MIPI_CSI_CLK_ROOT_MISC_SET		CCM_MISC72_SET
#define CCM_CLKROOT_MIPI_CSI_CLK_ROOT_MISC_CLR		CCM_MISC72_CLR
#define CCM_CLKROOT_MIPI_CSI_CLK_ROOT_MISC_TOG		CCM_MISC72_TOG
#define CCM_CLKROOT_MIPI_CSI_CLK_ROOT_POST		CCM_POST72
#define CCM_CLKROOT_MIPI_CSI_CLK_ROOT_POST_SET		CCM_POST72_SET
#define CCM_CLKROOT_MIPI_CSI_CLK_ROOT_POST_CLR		CCM_POST72_CLR
#define CCM_CLKROOT_MIPI_CSI_CLK_ROOT_POST_TOG		CCM_POST72_TOG
#define CCM_CLKROOT_MIPI_CSI_CLK_ROOT_PRE		CCM_PRE72
#define CCM_CLKROOT_MIPI_CSI_CLK_ROOT_PRE_SET		CCM_PRE72_SET
#define CCM_CLKROOT_MIPI_CSI_CLK_ROOT_PRE_CLR		CCM_PRE72_CLR
#define CCM_CLKROOT_MIPI_CSI_CLK_ROOT_PRE_TOG		CCM_PRE72_TOG
#define CCM_CLKROOT_MIPI_CSI_CLK_ROOT_ACCESS_CTRL	CCM_ACCESS_CTRL72
#define CCM_CLKROOT_MIPI_CSI_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL72_SET
#define CCM_CLKROOT_MIPI_CSI_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL72_CLR
#define CCM_CLKROOT_MIPI_CSI_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL72_TOG
#define CCM_CLKROOT_MIPI_DPHY_REF_CLK_ROOT		CCM_TARGET_ROOT73
#define CCM_CLKROOT_MIPI_DPHY_REF_CLK_ROOT_SET		CCM_TARGET_ROOT73_SET
#define CCM_CLKROOT_MIPI_DPHY_REF_CLK_ROOT_CLR		CCM_TARGET_ROOT73_CLR
#define CCM_CLKROOT_MIPI_DPHY_REF_CLK_ROOT_TOG		CCM_TARGET_ROOT73_TOG
#define CCM_CLKROOT_MIPI_DPHY_REF_CLK_ROOT_MISC		CCM_MISC73
#define CCM_CLKROOT_MIPI_DPHY_REF_CLK_ROOT_MISC_SET	CCM_MISC73_SET
#define CCM_CLKROOT_MIPI_DPHY_REF_CLK_ROOT_MISC_CLR	CCM_MISC73_CLR
#define CCM_CLKROOT_MIPI_DPHY_REF_CLK_ROOT_MISC_TOG	CCM_MISC73_TOG
#define CCM_CLKROOT_MIPI_DPHY_REF_CLK_ROOT_POST		CCM_POST73
#define CCM_CLKROOT_MIPI_DPHY_REF_CLK_ROOT_POST_SET	CCM_POST73_SET
#define CCM_CLKROOT_MIPI_DPHY_REF_CLK_ROOT_POST_CLR	CCM_POST73_CLR
#define CCM_CLKROOT_MIPI_DPHY_REF_CLK_ROOT_POST_TOG	CCM_POST73_TOG
#define CCM_CLKROOT_MIPI_DPHY_REF_CLK_ROOT_PRE		CCM_PRE73
#define CCM_CLKROOT_MIPI_DPHY_REF_CLK_ROOT_PRE_SET	CCM_PRE73_SET
#define CCM_CLKROOT_MIPI_DPHY_REF_CLK_ROOT_PRE_CLR	CCM_PRE73_CLR
#define CCM_CLKROOT_MIPI_DPHY_REF_CLK_ROOT_PRE_TOG	CCM_PRE73_TOG
#define CCM_CLKROOT_MIPI_DPHY_REF_CLK_ROOT_ACCESS_CTRL	CCM_ACCESS_CTRL73
#define CCM_CLKROOT_MIPI_DPHY_REF_CLK_ROOT_ACCESS_CTRL_SETCCM_ACCESS_CTRL73_SET
#define CCM_CLKROOT_MIPI_DPHY_REF_CLK_ROOT_ACCESS_CTRL_CLRCCM_ACCESS_CTRL73_CLR
#define CCM_CLKROOT_MIPI_DPHY_REF_CLK_ROOT_ACCESS_CTRL_TOGCCM_ACCESS_CTRL73_TOG
#define CCM_CLKROOT_SAI1_CLK_ROOT			CCM_TARGET_ROOT74
#define CCM_CLKROOT_SAI1_CLK_ROOT_SET			CCM_TARGET_ROOT74_SET
#define CCM_CLKROOT_SAI1_CLK_ROOT_CLR			CCM_TARGET_ROOT74_CLR
#define CCM_CLKROOT_SAI1_CLK_ROOT_TOG			CCM_TARGET_ROOT74_TOG
#define CCM_CLKROOT_SAI1_CLK_ROOT_MISC			CCM_MISC74
#define CCM_CLKROOT_SAI1_CLK_ROOT_MISC_SET		CCM_MISC74_SET
#define CCM_CLKROOT_SAI1_CLK_ROOT_MISC_CLR		CCM_MISC74_CLR
#define CCM_CLKROOT_SAI1_CLK_ROOT_MISC_TOG		CCM_MISC74_TOG
#define CCM_CLKROOT_SAI1_CLK_ROOT_POST			CCM_POST74
#define CCM_CLKROOT_SAI1_CLK_ROOT_POST_SET		CCM_POST74_SET
#define CCM_CLKROOT_SAI1_CLK_ROOT_POST_CLR		CCM_POST74_CLR
#define CCM_CLKROOT_SAI1_CLK_ROOT_POST_TOG		CCM_POST74_TOG
#define CCM_CLKROOT_SAI1_CLK_ROOT_PRE			CCM_PRE74
#define CCM_CLKROOT_SAI1_CLK_ROOT_PRE_SET		CCM_PRE74_SET
#define CCM_CLKROOT_SAI1_CLK_ROOT_PRE_CLR		CCM_PRE74_CLR
#define CCM_CLKROOT_SAI1_CLK_ROOT_PRE_TOG		CCM_PRE74_TOG
#define CCM_CLKROOT_SAI1_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL74
#define CCM_CLKROOT_SAI1_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL74_SET
#define CCM_CLKROOT_SAI1_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL74_CLR
#define CCM_CLKROOT_SAI1_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL74_TOG
#define CCM_CLKROOT_SAI2_CLK_ROOT			CCM_TARGET_ROOT75
#define CCM_CLKROOT_SAI2_CLK_ROOT_SET			CCM_TARGET_ROOT75_SET
#define CCM_CLKROOT_SAI2_CLK_ROOT_CLR			CCM_TARGET_ROOT75_CLR
#define CCM_CLKROOT_SAI2_CLK_ROOT_TOG			CCM_TARGET_ROOT75_TOG
#define CCM_CLKROOT_SAI2_CLK_ROOT_MISC			CCM_MISC75
#define CCM_CLKROOT_SAI2_CLK_ROOT_MISC_SET		CCM_MISC75_SET
#define CCM_CLKROOT_SAI2_CLK_ROOT_MISC_CLR		CCM_MISC75_CLR
#define CCM_CLKROOT_SAI2_CLK_ROOT_MISC_TOG		CCM_MISC75_TOG
#define CCM_CLKROOT_SAI2_CLK_ROOT_POST			CCM_POST75
#define CCM_CLKROOT_SAI2_CLK_ROOT_POST_SET		CCM_POST75_SET
#define CCM_CLKROOT_SAI2_CLK_ROOT_POST_CLR		CCM_POST75_CLR
#define CCM_CLKROOT_SAI2_CLK_ROOT_POST_TOG		CCM_POST75_TOG
#define CCM_CLKROOT_SAI2_CLK_ROOT_PRE			CCM_PRE75
#define CCM_CLKROOT_SAI2_CLK_ROOT_PRE_SET		CCM_PRE75_SET
#define CCM_CLKROOT_SAI2_CLK_ROOT_PRE_CLR		CCM_PRE75_CLR
#define CCM_CLKROOT_SAI2_CLK_ROOT_PRE_TOG		CCM_PRE75_TOG
#define CCM_CLKROOT_SAI2_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL75
#define CCM_CLKROOT_SAI2_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL75_SET
#define CCM_CLKROOT_SAI2_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL75_CLR
#define CCM_CLKROOT_SAI2_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL75_TOG
#define CCM_CLKROOT_SAI3_CLK_ROOT			CCM_TARGET_ROOT76
#define CCM_CLKROOT_SAI3_CLK_ROOT_SET			CCM_TARGET_ROOT76_SET
#define CCM_CLKROOT_SAI3_CLK_ROOT_CLR			CCM_TARGET_ROOT76_CLR
#define CCM_CLKROOT_SAI3_CLK_ROOT_TOG			CCM_TARGET_ROOT76_TOG
#define CCM_CLKROOT_SAI3_CLK_ROOT_MISC			CCM_MISC76
#define CCM_CLKROOT_SAI3_CLK_ROOT_MISC_SET		CCM_MISC76_SET
#define CCM_CLKROOT_SAI3_CLK_ROOT_MISC_CLR		CCM_MISC76_CLR
#define CCM_CLKROOT_SAI3_CLK_ROOT_MISC_TOG		CCM_MISC76_TOG
#define CCM_CLKROOT_SAI3_CLK_ROOT_POST			CCM_POST76
#define CCM_CLKROOT_SAI3_CLK_ROOT_POST_SET		CCM_POST76_SET
#define CCM_CLKROOT_SAI3_CLK_ROOT_POST_CLR		CCM_POST76_CLR
#define CCM_CLKROOT_SAI3_CLK_ROOT_POST_TOG		CCM_POST76_TOG
#define CCM_CLKROOT_SAI3_CLK_ROOT_PRE			CCM_PRE76
#define CCM_CLKROOT_SAI3_CLK_ROOT_PRE_SET		CCM_PRE76_SET
#define CCM_CLKROOT_SAI3_CLK_ROOT_PRE_CLR		CCM_PRE76_CLR
#define CCM_CLKROOT_SAI3_CLK_ROOT_PRE_TOG		CCM_PRE76_TOG
#define CCM_CLKROOT_SAI3_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL76
#define CCM_CLKROOT_SAI3_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL76_SET
#define CCM_CLKROOT_SAI3_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL76_CLR
#define CCM_CLKROOT_SAI3_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL76_TOG
#define CCM_CLKROOT_ENET1_REF_CLK_ROOT			CCM_TARGET_ROOT78
#define CCM_CLKROOT_ENET1_REF_CLK_ROOT_SET		CCM_TARGET_ROOT78_SET
#define CCM_CLKROOT_ENET1_REF_CLK_ROOT_CLR		CCM_TARGET_ROOT78_CLR
#define CCM_CLKROOT_ENET1_REF_CLK_ROOT_TOG		CCM_TARGET_ROOT78_TOG
#define CCM_CLKROOT_ENET1_REF_CLK_ROOT_MISC		CCM_MISC78
#define CCM_CLKROOT_ENET1_REF_CLK_ROOT_MISC_SET		CCM_MISC78_SET
#define CCM_CLKROOT_ENET1_REF_CLK_ROOT_MISC_CLR		CCM_MISC78_CLR
#define CCM_CLKROOT_ENET1_REF_CLK_ROOT_MISC_TOG		CCM_MISC78_TOG
#define CCM_CLKROOT_ENET1_REF_CLK_ROOT_POST		CCM_POST78
#define CCM_CLKROOT_ENET1_REF_CLK_ROOT_POST_SET		CCM_POST78_SET
#define CCM_CLKROOT_ENET1_REF_CLK_ROOT_POST_CLR		CCM_POST78_CLR
#define CCM_CLKROOT_ENET1_REF_CLK_ROOT_POST_TOG		CCM_POST78_TOG
#define CCM_CLKROOT_ENET1_REF_CLK_ROOT_PRE		CCM_PRE78
#define CCM_CLKROOT_ENET1_REF_CLK_ROOT_PRE_SET		CCM_PRE78_SET
#define CCM_CLKROOT_ENET1_REF_CLK_ROOT_PRE_CLR		CCM_PRE78_CLR
#define CCM_CLKROOT_ENET1_REF_CLK_ROOT_PRE_TOG		CCM_PRE78_TOG
#define CCM_CLKROOT_ENET1_REF_CLK_ROOT_ACCESS_CTRL	CCM_ACCESS_CTRL78
#define CCM_CLKROOT_ENET1_REF_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL78_SET
#define CCM_CLKROOT_ENET1_REF_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL78_CLR
#define CCM_CLKROOT_ENET1_REF_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL78_TOG
#define CCM_CLKROOT_ENET1_TIME_CLK_ROOT			CCM_TARGET_ROOT79
#define CCM_CLKROOT_ENET1_TIME_CLK_ROOT_SET		CCM_TARGET_ROOT79_SET
#define CCM_CLKROOT_ENET1_TIME_CLK_ROOT_CLR		CCM_TARGET_ROOT79_CLR
#define CCM_CLKROOT_ENET1_TIME_CLK_ROOT_TOG		CCM_TARGET_ROOT79_TOG
#define CCM_CLKROOT_ENET1_TIME_CLK_ROOT_MISC		CCM_MISC79
#define CCM_CLKROOT_ENET1_TIME_CLK_ROOT_MISC_SET	CCM_MISC79_SET
#define CCM_CLKROOT_ENET1_TIME_CLK_ROOT_MISC_CLR	CCM_MISC79_CLR
#define CCM_CLKROOT_ENET1_TIME_CLK_ROOT_MISC_TOG	CCM_MISC79_TOG
#define CCM_CLKROOT_ENET1_TIME_CLK_ROOT_POST		CCM_POST79
#define CCM_CLKROOT_ENET1_TIME_CLK_ROOT_POST_SET	CCM_POST79_SET
#define CCM_CLKROOT_ENET1_TIME_CLK_ROOT_POST_CLR	CCM_POST79_CLR
#define CCM_CLKROOT_ENET1_TIME_CLK_ROOT_POST_TOG	CCM_POST79_TOG
#define CCM_CLKROOT_ENET1_TIME_CLK_ROOT_PRE		CCM_PRE79
#define CCM_CLKROOT_ENET1_TIME_CLK_ROOT_PRE_SET		CCM_PRE79_SET
#define CCM_CLKROOT_ENET1_TIME_CLK_ROOT_PRE_CLR		CCM_PRE79_CLR
#define CCM_CLKROOT_ENET1_TIME_CLK_ROOT_PRE_TOG		CCM_PRE79_TOG
#define CCM_CLKROOT_ENET1_TIME_CLK_ROOT_ACCESS_CTRL	CCM_ACCESS_CTRL79
#define CCM_CLKROOT_ENET1_TIME_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL79_SET
#define CCM_CLKROOT_ENET1_TIME_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL79_CLR
#define CCM_CLKROOT_ENET1_TIME_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL79_TOG
#define CCM_CLKROOT_ENET2_REF_CLK_ROOT			CCM_TARGET_ROOT80
#define CCM_CLKROOT_ENET2_REF_CLK_ROOT_SET		CCM_TARGET_ROOT80_SET
#define CCM_CLKROOT_ENET2_REF_CLK_ROOT_CLR		CCM_TARGET_ROOT80_CLR
#define CCM_CLKROOT_ENET2_REF_CLK_ROOT_TOG		CCM_TARGET_ROOT80_TOG
#define CCM_CLKROOT_ENET2_REF_CLK_ROOT_MISC		CCM_MISC80
#define CCM_CLKROOT_ENET2_REF_CLK_ROOT_MISC_SET		CCM_MISC80_SET
#define CCM_CLKROOT_ENET2_REF_CLK_ROOT_MISC_CLR		CCM_MISC80_CLR
#define CCM_CLKROOT_ENET2_REF_CLK_ROOT_MISC_TOG		CCM_MISC80_TOG
#define CCM_CLKROOT_ENET2_REF_CLK_ROOT_POST		CCM_POST80
#define CCM_CLKROOT_ENET2_REF_CLK_ROOT_POST_SET		CCM_POST80_SET
#define CCM_CLKROOT_ENET2_REF_CLK_ROOT_POST_CLR		CCM_POST80_CLR
#define CCM_CLKROOT_ENET2_REF_CLK_ROOT_POST_TOG		CCM_POST80_TOG
#define CCM_CLKROOT_ENET2_REF_CLK_ROOT_PRE		CCM_PRE80
#define CCM_CLKROOT_ENET2_REF_CLK_ROOT_PRE_SET		CCM_PRE80_SET
#define CCM_CLKROOT_ENET2_REF_CLK_ROOT_PRE_CLR		CCM_PRE80_CLR
#define CCM_CLKROOT_ENET2_REF_CLK_ROOT_PRE_TOG		CCM_PRE80_TOG
#define CCM_CLKROOT_ENET2_REF_CLK_ROOT_ACCESS_CTRL	CCM_ACCESS_CTRL80
#define CCM_CLKROOT_ENET2_REF_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL80_SET
#define CCM_CLKROOT_ENET2_REF_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL80_CLR
#define CCM_CLKROOT_ENET2_REF_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL80_TOG
#define CCM_CLKROOT_ENET2_TIME_CLK_ROOT			CCM_TARGET_ROOT81
#define CCM_CLKROOT_ENET2_TIME_CLK_ROOT_SET		CCM_TARGET_ROOT81_SET
#define CCM_CLKROOT_ENET2_TIME_CLK_ROOT_CLR		CCM_TARGET_ROOT81_CLR
#define CCM_CLKROOT_ENET2_TIME_CLK_ROOT_TOG		CCM_TARGET_ROOT81_TOG
#define CCM_CLKROOT_ENET2_TIME_CLK_ROOT_MISC		CCM_MISC81
#define CCM_CLKROOT_ENET2_TIME_CLK_ROOT_MISC_SET	CCM_MISC81_SET
#define CCM_CLKROOT_ENET2_TIME_CLK_ROOT_MISC_CLR	CCM_MISC81_CLR
#define CCM_CLKROOT_ENET2_TIME_CLK_ROOT_MISC_TOG	CCM_MISC81_TOG
#define CCM_CLKROOT_ENET2_TIME_CLK_ROOT_POST		CCM_POST81
#define CCM_CLKROOT_ENET2_TIME_CLK_ROOT_POST_SET	CCM_POST81_SET
#define CCM_CLKROOT_ENET2_TIME_CLK_ROOT_POST_CLR	CCM_POST81_CLR
#define CCM_CLKROOT_ENET2_TIME_CLK_ROOT_POST_TOG	CCM_POST81_TOG
#define CCM_CLKROOT_ENET2_TIME_CLK_ROOT_PRE		CCM_PRE81
#define CCM_CLKROOT_ENET2_TIME_CLK_ROOT_PRE_SET		CCM_PRE81_SET
#define CCM_CLKROOT_ENET2_TIME_CLK_ROOT_PRE_CLR		CCM_PRE81_CLR
#define CCM_CLKROOT_ENET2_TIME_CLK_ROOT_PRE_TOG		CCM_PRE81_TOG
#define CCM_CLKROOT_ENET2_TIME_CLK_ROOT_ACCESS_CTRL	CCM_ACCESS_CTRL81
#define CCM_CLKROOT_ENET2_TIME_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL81_SET
#define CCM_CLKROOT_ENET2_TIME_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL81_CLR
#define CCM_CLKROOT_ENET2_TIME_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL81_TOG
#define CCM_CLKROOT_ENET_PHY_REF_CLK_ROOT		CCM_TARGET_ROOT82
#define CCM_CLKROOT_ENET_PHY_REF_CLK_ROOT_SET		CCM_TARGET_ROOT82_SET
#define CCM_CLKROOT_ENET_PHY_REF_CLK_ROOT_CLR		CCM_TARGET_ROOT82_CLR
#define CCM_CLKROOT_ENET_PHY_REF_CLK_ROOT_TOG		CCM_TARGET_ROOT82_TOG
#define CCM_CLKROOT_ENET_PHY_REF_CLK_ROOT_MISC		CCM_MISC82
#define CCM_CLKROOT_ENET_PHY_REF_CLK_ROOT_MISC_SET	CCM_MISC82_SET
#define CCM_CLKROOT_ENET_PHY_REF_CLK_ROOT_MISC_CLR	CCM_MISC82_CLR
#define CCM_CLKROOT_ENET_PHY_REF_CLK_ROOT_MISC_TOG	CCM_MISC82_TOG
#define CCM_CLKROOT_ENET_PHY_REF_CLK_ROOT_POST		CCM_POST82
#define CCM_CLKROOT_ENET_PHY_REF_CLK_ROOT_POST_SET	CCM_POST82_SET
#define CCM_CLKROOT_ENET_PHY_REF_CLK_ROOT_POST_CLR	CCM_POST82_CLR
#define CCM_CLKROOT_ENET_PHY_REF_CLK_ROOT_POST_TOG	CCM_POST82_TOG
#define CCM_CLKROOT_ENET_PHY_REF_CLK_ROOT_PRE		CCM_PRE82
#define CCM_CLKROOT_ENET_PHY_REF_CLK_ROOT_PRE_SET	CCM_PRE82_SET
#define CCM_CLKROOT_ENET_PHY_REF_CLK_ROOT_PRE_CLR	CCM_PRE82_CLR
#define CCM_CLKROOT_ENET_PHY_REF_CLK_ROOT_PRE_TOG	CCM_PRE82_TOG
#define CCM_CLKROOT_ENET_PHY_REF_CLK_ROOT_ACCESS_CTRL	CCM_ACCESS_CTRL82
#define CCM_CLKROOT_ENET_PHY_REF_CLK_ROOT_ACCESS_CTRL_SETCCM_ACCESS_CTRL82_SET
#define CCM_CLKROOT_ENET_PHY_REF_CLK_ROOT_ACCESS_CTRL_CLRCCM_ACCESS_CTRL82_CLR
#define CCM_CLKROOT_ENET_PHY_REF_CLK_ROOT_ACCESS_CTRL_TOGCCM_ACCESS_CTRL82_TOG
#define CCM_CLKROOT_EIM_CLK_ROOT			CCM_TARGET_ROOT83
#define CCM_CLKROOT_EIM_CLK_ROOT_SET			CCM_TARGET_ROOT83_SET
#define CCM_CLKROOT_EIM_CLK_ROOT_CLR			CCM_TARGET_ROOT83_CLR
#define CCM_CLKROOT_EIM_CLK_ROOT_TOG			CCM_TARGET_ROOT83_TOG
#define CCM_CLKROOT_EIM_CLK_ROOT_MISC			CCM_MISC83
#define CCM_CLKROOT_EIM_CLK_ROOT_MISC_SET		CCM_MISC83_SET
#define CCM_CLKROOT_EIM_CLK_ROOT_MISC_CLR		CCM_MISC83_CLR
#define CCM_CLKROOT_EIM_CLK_ROOT_MISC_TOG		CCM_MISC83_TOG
#define CCM_CLKROOT_EIM_CLK_ROOT_POST			CCM_POST83
#define CCM_CLKROOT_EIM_CLK_ROOT_POST_SET		CCM_POST83_SET
#define CCM_CLKROOT_EIM_CLK_ROOT_POST_CLR		CCM_POST83_CLR
#define CCM_CLKROOT_EIM_CLK_ROOT_POST_TOG		CCM_POST83_TOG
#define CCM_CLKROOT_EIM_CLK_ROOT_PRE			CCM_PRE83
#define CCM_CLKROOT_EIM_CLK_ROOT_PRE_SET		CCM_PRE83_SET
#define CCM_CLKROOT_EIM_CLK_ROOT_PRE_CLR		CCM_PRE83_CLR
#define CCM_CLKROOT_EIM_CLK_ROOT_PRE_TOG		CCM_PRE83_TOG
#define CCM_CLKROOT_EIM_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL83
#define CCM_CLKROOT_EIM_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL83_SET
#define CCM_CLKROOT_EIM_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL83_CLR
#define CCM_CLKROOT_EIM_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL83_TOG
#define CCM_CLKROOT_NAND_CLK_ROOT			CCM_TARGET_ROOT84
#define CCM_CLKROOT_NAND_CLK_ROOT_SET			CCM_TARGET_ROOT84_SET
#define CCM_CLKROOT_NAND_CLK_ROOT_CLR			CCM_TARGET_ROOT84_CLR
#define CCM_CLKROOT_NAND_CLK_ROOT_TOG			CCM_TARGET_ROOT84_TOG
#define CCM_CLKROOT_NAND_CLK_ROOT_MISC			CCM_MISC84
#define CCM_CLKROOT_NAND_CLK_ROOT_MISC_SET		CCM_MISC84_SET
#define CCM_CLKROOT_NAND_CLK_ROOT_MISC_CLR		CCM_MISC84_CLR
#define CCM_CLKROOT_NAND_CLK_ROOT_MISC_TOG		CCM_MISC84_TOG
#define CCM_CLKROOT_NAND_CLK_ROOT_POST			CCM_POST84
#define CCM_CLKROOT_NAND_CLK_ROOT_POST_SET		CCM_POST84_SET
#define CCM_CLKROOT_NAND_CLK_ROOT_POST_CLR		CCM_POST84_CLR
#define CCM_CLKROOT_NAND_CLK_ROOT_POST_TOG		CCM_POST84_TOG
#define CCM_CLKROOT_NAND_CLK_ROOT_PRE			CCM_PRE84
#define CCM_CLKROOT_NAND_CLK_ROOT_PRE_SET		CCM_PRE84_SET
#define CCM_CLKROOT_NAND_CLK_ROOT_PRE_CLR		CCM_PRE84_CLR
#define CCM_CLKROOT_NAND_CLK_ROOT_PRE_TOG		CCM_PRE84_TOG
#define CCM_CLKROOT_NAND_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL84
#define CCM_CLKROOT_NAND_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL84_SET
#define CCM_CLKROOT_NAND_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL84_CLR
#define CCM_CLKROOT_NAND_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL84_TOG
#define CCM_CLKROOT_QSPI_CLK_ROOT			CCM_TARGET_ROOT85
#define CCM_CLKROOT_QSPI_CLK_ROOT_SET			CCM_TARGET_ROOT85_SET
#define CCM_CLKROOT_QSPI_CLK_ROOT_CLR			CCM_TARGET_ROOT85_CLR
#define CCM_CLKROOT_QSPI_CLK_ROOT_TOG			CCM_TARGET_ROOT85_TOG
#define CCM_CLKROOT_QSPI_CLK_ROOT_MISC			CCM_MISC85
#define CCM_CLKROOT_QSPI_CLK_ROOT_MISC_SET		CCM_MISC85_SET
#define CCM_CLKROOT_QSPI_CLK_ROOT_MISC_CLR		CCM_MISC85_CLR
#define CCM_CLKROOT_QSPI_CLK_ROOT_MISC_TOG		CCM_MISC85_TOG
#define CCM_CLKROOT_QSPI_CLK_ROOT_POST			CCM_POST85
#define CCM_CLKROOT_QSPI_CLK_ROOT_POST_SET		CCM_POST85_SET
#define CCM_CLKROOT_QSPI_CLK_ROOT_POST_CLR		CCM_POST85_CLR
#define CCM_CLKROOT_QSPI_CLK_ROOT_POST_TOG		CCM_POST85_TOG
#define CCM_CLKROOT_QSPI_CLK_ROOT_PRE			CCM_PRE85
#define CCM_CLKROOT_QSPI_CLK_ROOT_PRE_SET		CCM_PRE85_SET
#define CCM_CLKROOT_QSPI_CLK_ROOT_PRE_CLR		CCM_PRE85_CLR
#define CCM_CLKROOT_QSPI_CLK_ROOT_PRE_TOG		CCM_PRE85_TOG
#define CCM_CLKROOT_QSPI_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL85
#define CCM_CLKROOT_QSPI_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL85_SET
#define CCM_CLKROOT_QSPI_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL85_CLR
#define CCM_CLKROOT_QSPI_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL85_TOG
#define CCM_CLKROOT_USDHC1_CLK_ROOT			CCM_TARGET_ROOT86
#define CCM_CLKROOT_USDHC1_CLK_ROOT_SET			CCM_TARGET_ROOT86_SET
#define CCM_CLKROOT_USDHC1_CLK_ROOT_CLR			CCM_TARGET_ROOT86_CLR
#define CCM_CLKROOT_USDHC1_CLK_ROOT_TOG			CCM_TARGET_ROOT86_TOG
#define CCM_CLKROOT_USDHC1_CLK_ROOT_MISC		CCM_MISC86
#define CCM_CLKROOT_USDHC1_CLK_ROOT_MISC_SET		CCM_MISC86_SET
#define CCM_CLKROOT_USDHC1_CLK_ROOT_MISC_CLR		CCM_MISC86_CLR
#define CCM_CLKROOT_USDHC1_CLK_ROOT_MISC_TOG		CCM_MISC86_TOG
#define CCM_CLKROOT_USDHC1_CLK_ROOT_POST		CCM_POST86
#define CCM_CLKROOT_USDHC1_CLK_ROOT_POST_SET		CCM_POST86_SET
#define CCM_CLKROOT_USDHC1_CLK_ROOT_POST_CLR		CCM_POST86_CLR
#define CCM_CLKROOT_USDHC1_CLK_ROOT_POST_TOG		CCM_POST86_TOG
#define CCM_CLKROOT_USDHC1_CLK_ROOT_PRE			CCM_PRE86
#define CCM_CLKROOT_USDHC1_CLK_ROOT_PRE_SET		CCM_PRE86_SET
#define CCM_CLKROOT_USDHC1_CLK_ROOT_PRE_CLR		CCM_PRE86_CLR
#define CCM_CLKROOT_USDHC1_CLK_ROOT_PRE_TOG		CCM_PRE86_TOG
#define CCM_CLKROOT_USDHC1_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL86
#define CCM_CLKROOT_USDHC1_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL86_SET
#define CCM_CLKROOT_USDHC1_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL86_CLR
#define CCM_CLKROOT_USDHC1_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL86_TOG
#define CCM_CLKROOT_USDHC2_CLK_ROOT			CCM_TARGET_ROOT87
#define CCM_CLKROOT_USDHC2_CLK_ROOT_SET			CCM_TARGET_ROOT87_SET
#define CCM_CLKROOT_USDHC2_CLK_ROOT_CLR			CCM_TARGET_ROOT87_CLR
#define CCM_CLKROOT_USDHC2_CLK_ROOT_TOG			CCM_TARGET_ROOT87_TOG
#define CCM_CLKROOT_USDHC2_CLK_ROOT_MISC		CCM_MISC87
#define CCM_CLKROOT_USDHC2_CLK_ROOT_MISC_SET		CCM_MISC87_SET
#define CCM_CLKROOT_USDHC2_CLK_ROOT_MISC_CLR		CCM_MISC87_CLR
#define CCM_CLKROOT_USDHC2_CLK_ROOT_MISC_TOG		CCM_MISC87_TOG
#define CCM_CLKROOT_USDHC2_CLK_ROOT_POST		CCM_POST87
#define CCM_CLKROOT_USDHC2_CLK_ROOT_POST_SET		CCM_POST87_SET
#define CCM_CLKROOT_USDHC2_CLK_ROOT_POST_CLR		CCM_POST87_CLR
#define CCM_CLKROOT_USDHC2_CLK_ROOT_POST_TOG		CCM_POST87_TOG
#define CCM_CLKROOT_USDHC2_CLK_ROOT_PRE			CCM_PRE87
#define CCM_CLKROOT_USDHC2_CLK_ROOT_PRE_SET		CCM_PRE87_SET
#define CCM_CLKROOT_USDHC2_CLK_ROOT_PRE_CLR		CCM_PRE87_CLR
#define CCM_CLKROOT_USDHC2_CLK_ROOT_PRE_TOG		CCM_PRE87_TOG
#define CCM_CLKROOT_USDHC2_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL87
#define CCM_CLKROOT_USDHC2_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL87_SET
#define CCM_CLKROOT_USDHC2_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL87_CLR
#define CCM_CLKROOT_USDHC2_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL87_TOG
#define CCM_CLKROOT_USDHC3_CLK_ROOT			CCM_TARGET_ROOT88
#define CCM_CLKROOT_USDHC3_CLK_ROOT_SET			CCM_TARGET_ROOT88_SET
#define CCM_CLKROOT_USDHC3_CLK_ROOT_CLR			CCM_TARGET_ROOT88_CLR
#define CCM_CLKROOT_USDHC3_CLK_ROOT_TOG			CCM_TARGET_ROOT88_TOG
#define CCM_CLKROOT_USDHC3_CLK_ROOT_MISC		CCM_MISC88
#define CCM_CLKROOT_USDHC3_CLK_ROOT_MISC_SET		CCM_MISC88_SET
#define CCM_CLKROOT_USDHC3_CLK_ROOT_MISC_CLR		CCM_MISC88_CLR
#define CCM_CLKROOT_USDHC3_CLK_ROOT_MISC_TOG		CCM_MISC88_TOG
#define CCM_CLKROOT_USDHC3_CLK_ROOT_POST		CCM_POST88
#define CCM_CLKROOT_USDHC3_CLK_ROOT_POST_SET		CCM_POST88_SET
#define CCM_CLKROOT_USDHC3_CLK_ROOT_POST_CLR		CCM_POST88_CLR
#define CCM_CLKROOT_USDHC3_CLK_ROOT_POST_TOG		CCM_POST88_TOG
#define CCM_CLKROOT_USDHC3_CLK_ROOT_PRE			CCM_PRE88
#define CCM_CLKROOT_USDHC3_CLK_ROOT_PRE_SET		CCM_PRE88_SET
#define CCM_CLKROOT_USDHC3_CLK_ROOT_PRE_CLR		CCM_PRE88_CLR
#define CCM_CLKROOT_USDHC3_CLK_ROOT_PRE_TOG		CCM_PRE88_TOG
#define CCM_CLKROOT_USDHC3_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL88
#define CCM_CLKROOT_USDHC3_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL88_SET
#define CCM_CLKROOT_USDHC3_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL88_CLR
#define CCM_CLKROOT_USDHC3_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL88_TOG
#define CCM_CLKROOT_CAN1_CLK_ROOT			CCM_TARGET_ROOT89
#define CCM_CLKROOT_CAN1_CLK_ROOT_SET			CCM_TARGET_ROOT89_SET
#define CCM_CLKROOT_CAN1_CLK_ROOT_CLR			CCM_TARGET_ROOT89_CLR
#define CCM_CLKROOT_CAN1_CLK_ROOT_TOG			CCM_TARGET_ROOT89_TOG
#define CCM_CLKROOT_CAN1_CLK_ROOT_MISC			CCM_MISC89
#define CCM_CLKROOT_CAN1_CLK_ROOT_MISC_SET		CCM_MISC89_SET
#define CCM_CLKROOT_CAN1_CLK_ROOT_MISC_CLR		CCM_MISC89_CLR
#define CCM_CLKROOT_CAN1_CLK_ROOT_MISC_TOG		CCM_MISC89_TOG
#define CCM_CLKROOT_CAN1_CLK_ROOT_POST			CCM_POST89
#define CCM_CLKROOT_CAN1_CLK_ROOT_POST_SET		CCM_POST89_SET
#define CCM_CLKROOT_CAN1_CLK_ROOT_POST_CLR		CCM_POST89_CLR
#define CCM_CLKROOT_CAN1_CLK_ROOT_POST_TOG		CCM_POST89_TOG
#define CCM_CLKROOT_CAN1_CLK_ROOT_PRE			CCM_PRE89
#define CCM_CLKROOT_CAN1_CLK_ROOT_PRE_SET		CCM_PRE89_SET
#define CCM_CLKROOT_CAN1_CLK_ROOT_PRE_CLR		CCM_PRE89_CLR
#define CCM_CLKROOT_CAN1_CLK_ROOT_PRE_TOG		CCM_PRE89_TOG
#define CCM_CLKROOT_CAN1_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL89
#define CCM_CLKROOT_CAN1_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL89_SET
#define CCM_CLKROOT_CAN1_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL89_CLR
#define CCM_CLKROOT_CAN1_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL89_TOG
#define CCM_CLKROOT_CAN2_CLK_ROOT			CCM_TARGET_ROOT90
#define CCM_CLKROOT_CAN2_CLK_ROOT_SET			CCM_TARGET_ROOT90_SET
#define CCM_CLKROOT_CAN2_CLK_ROOT_CLR			CCM_TARGET_ROOT90_CLR
#define CCM_CLKROOT_CAN2_CLK_ROOT_TOG			CCM_TARGET_ROOT90_TOG
#define CCM_CLKROOT_CAN2_CLK_ROOT_MISC			CCM_MISC90
#define CCM_CLKROOT_CAN2_CLK_ROOT_MISC_SET		CCM_MISC90_SET
#define CCM_CLKROOT_CAN2_CLK_ROOT_MISC_CLR		CCM_MISC90_CLR
#define CCM_CLKROOT_CAN2_CLK_ROOT_MISC_TOG		CCM_MISC90_TOG
#define CCM_CLKROOT_CAN2_CLK_ROOT_POST			CCM_POST90
#define CCM_CLKROOT_CAN2_CLK_ROOT_POST_SET		CCM_POST90_SET
#define CCM_CLKROOT_CAN2_CLK_ROOT_POST_CLR		CCM_POST90_CLR
#define CCM_CLKROOT_CAN2_CLK_ROOT_POST_TOG		CCM_POST90_TOG
#define CCM_CLKROOT_CAN2_CLK_ROOT_PRE			CCM_PRE90
#define CCM_CLKROOT_CAN2_CLK_ROOT_PRE_SET		CCM_PRE90_SET
#define CCM_CLKROOT_CAN2_CLK_ROOT_PRE_CLR		CCM_PRE90_CLR
#define CCM_CLKROOT_CAN2_CLK_ROOT_PRE_TOG		CCM_PRE90_TOG
#define CCM_CLKROOT_CAN2_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL90
#define CCM_CLKROOT_CAN2_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL90_SET
#define CCM_CLKROOT_CAN2_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL90_CLR
#define CCM_CLKROOT_CAN2_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL90_TOG
#define CCM_CLKROOT_I2C1_CLK_ROOT			CCM_TARGET_ROOT91
#define CCM_CLKROOT_I2C1_CLK_ROOT_SET			CCM_TARGET_ROOT91_SET
#define CCM_CLKROOT_I2C1_CLK_ROOT_CLR			CCM_TARGET_ROOT91_CLR
#define CCM_CLKROOT_I2C1_CLK_ROOT_TOG			CCM_TARGET_ROOT91_TOG
#define CCM_CLKROOT_I2C1_CLK_ROOT_MISC			CCM_MISC91
#define CCM_CLKROOT_I2C1_CLK_ROOT_MISC_SET		CCM_MISC91_SET
#define CCM_CLKROOT_I2C1_CLK_ROOT_MISC_CLR		CCM_MISC91_CLR
#define CCM_CLKROOT_I2C1_CLK_ROOT_MISC_TOG		CCM_MISC91_TOG
#define CCM_CLKROOT_I2C1_CLK_ROOT_POST			CCM_POST91
#define CCM_CLKROOT_I2C1_CLK_ROOT_POST_SET		CCM_POST91_SET
#define CCM_CLKROOT_I2C1_CLK_ROOT_POST_CLR		CCM_POST91_CLR
#define CCM_CLKROOT_I2C1_CLK_ROOT_POST_TOG		CCM_POST91_TOG
#define CCM_CLKROOT_I2C1_CLK_ROOT_PRE			CCM_PRE91
#define CCM_CLKROOT_I2C1_CLK_ROOT_PRE_SET		CCM_PRE91_SET
#define CCM_CLKROOT_I2C1_CLK_ROOT_PRE_CLR		CCM_PRE91_CLR
#define CCM_CLKROOT_I2C1_CLK_ROOT_PRE_TOG		CCM_PRE91_TOG
#define CCM_CLKROOT_I2C1_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL91
#define CCM_CLKROOT_I2C1_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL91_SET
#define CCM_CLKROOT_I2C1_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL91_CLR
#define CCM_CLKROOT_I2C1_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL91_TOG
#define CCM_CLKROOT_I2C2_CLK_ROOT			CCM_TARGET_ROOT92
#define CCM_CLKROOT_I2C2_CLK_ROOT_SET			CCM_TARGET_ROOT92_SET
#define CCM_CLKROOT_I2C2_CLK_ROOT_CLR			CCM_TARGET_ROOT92_CLR
#define CCM_CLKROOT_I2C2_CLK_ROOT_TOG			CCM_TARGET_ROOT92_TOG
#define CCM_CLKROOT_I2C2_CLK_ROOT_MISC			CCM_MISC92
#define CCM_CLKROOT_I2C2_CLK_ROOT_MISC_SET		CCM_MISC92_SET
#define CCM_CLKROOT_I2C2_CLK_ROOT_MISC_CLR		CCM_MISC92_CLR
#define CCM_CLKROOT_I2C2_CLK_ROOT_MISC_TOG		CCM_MISC92_TOG
#define CCM_CLKROOT_I2C2_CLK_ROOT_POST			CCM_POST92
#define CCM_CLKROOT_I2C2_CLK_ROOT_POST_SET		CCM_POST92_SET
#define CCM_CLKROOT_I2C2_CLK_ROOT_POST_CLR		CCM_POST92_CLR
#define CCM_CLKROOT_I2C2_CLK_ROOT_POST_TOG		CCM_POST92_TOG
#define CCM_CLKROOT_I2C2_CLK_ROOT_PRE			CCM_PRE92
#define CCM_CLKROOT_I2C2_CLK_ROOT_PRE_SET		CCM_PRE92_SET
#define CCM_CLKROOT_I2C2_CLK_ROOT_PRE_CLR		CCM_PRE92_CLR
#define CCM_CLKROOT_I2C2_CLK_ROOT_PRE_TOG		CCM_PRE92_TOG
#define CCM_CLKROOT_I2C2_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL92
#define CCM_CLKROOT_I2C2_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL92_SET
#define CCM_CLKROOT_I2C2_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL92_CLR
#define CCM_CLKROOT_I2C2_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL92_TOG
#define CCM_CLKROOT_I2C3_CLK_ROOT			CCM_TARGET_ROOT93
#define CCM_CLKROOT_I2C3_CLK_ROOT_SET			CCM_TARGET_ROOT93_SET
#define CCM_CLKROOT_I2C3_CLK_ROOT_CLR			CCM_TARGET_ROOT93_CLR
#define CCM_CLKROOT_I2C3_CLK_ROOT_TOG			CCM_TARGET_ROOT93_TOG
#define CCM_CLKROOT_I2C3_CLK_ROOT_MISC			CCM_MISC93
#define CCM_CLKROOT_I2C3_CLK_ROOT_MISC_SET		CCM_MISC93_SET
#define CCM_CLKROOT_I2C3_CLK_ROOT_MISC_CLR		CCM_MISC93_CLR
#define CCM_CLKROOT_I2C3_CLK_ROOT_MISC_TOG		CCM_MISC93_TOG
#define CCM_CLKROOT_I2C3_CLK_ROOT_POST			CCM_POST93
#define CCM_CLKROOT_I2C3_CLK_ROOT_POST_SET		CCM_POST93_SET
#define CCM_CLKROOT_I2C3_CLK_ROOT_POST_CLR		CCM_POST93_CLR
#define CCM_CLKROOT_I2C3_CLK_ROOT_POST_TOG		CCM_POST93_TOG
#define CCM_CLKROOT_I2C3_CLK_ROOT_PRE			CCM_PRE93
#define CCM_CLKROOT_I2C3_CLK_ROOT_PRE_SET		CCM_PRE93_SET
#define CCM_CLKROOT_I2C3_CLK_ROOT_PRE_CLR		CCM_PRE93_CLR
#define CCM_CLKROOT_I2C3_CLK_ROOT_PRE_TOG		CCM_PRE93_TOG
#define CCM_CLKROOT_I2C3_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL93
#define CCM_CLKROOT_I2C3_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL93_SET
#define CCM_CLKROOT_I2C3_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL93_CLR
#define CCM_CLKROOT_I2C3_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL93_TOG
#define CCM_CLKROOT_I2C4_CLK_ROOT			CCM_TARGET_ROOT94
#define CCM_CLKROOT_I2C4_CLK_ROOT_SET			CCM_TARGET_ROOT94_SET
#define CCM_CLKROOT_I2C4_CLK_ROOT_CLR			CCM_TARGET_ROOT94_CLR
#define CCM_CLKROOT_I2C4_CLK_ROOT_TOG			CCM_TARGET_ROOT94_TOG
#define CCM_CLKROOT_I2C4_CLK_ROOT_MISC			CCM_MISC94
#define CCM_CLKROOT_I2C4_CLK_ROOT_MISC_SET		CCM_MISC94_SET
#define CCM_CLKROOT_I2C4_CLK_ROOT_MISC_CLR		CCM_MISC94_CLR
#define CCM_CLKROOT_I2C4_CLK_ROOT_MISC_TOG		CCM_MISC94_TOG
#define CCM_CLKROOT_I2C4_CLK_ROOT_POST			CCM_POST94
#define CCM_CLKROOT_I2C4_CLK_ROOT_POST_SET		CCM_POST94_SET
#define CCM_CLKROOT_I2C4_CLK_ROOT_POST_CLR		CCM_POST94_CLR
#define CCM_CLKROOT_I2C4_CLK_ROOT_POST_TOG		CCM_POST94_TOG
#define CCM_CLKROOT_I2C4_CLK_ROOT_PRE			CCM_PRE94
#define CCM_CLKROOT_I2C4_CLK_ROOT_PRE_SET		CCM_PRE94_SET
#define CCM_CLKROOT_I2C4_CLK_ROOT_PRE_CLR		CCM_PRE94_CLR
#define CCM_CLKROOT_I2C4_CLK_ROOT_PRE_TOG		CCM_PRE94_TOG
#define CCM_CLKROOT_I2C4_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL94
#define CCM_CLKROOT_I2C4_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL94_SET
#define CCM_CLKROOT_I2C4_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL94_CLR
#define CCM_CLKROOT_I2C4_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL94_TOG
#define CCM_CLKROOT_UART1_CLK_ROOT			CCM_TARGET_ROOT95
#define CCM_CLKROOT_UART1_CLK_ROOT_SET			CCM_TARGET_ROOT95_SET
#define CCM_CLKROOT_UART1_CLK_ROOT_CLR			CCM_TARGET_ROOT95_CLR
#define CCM_CLKROOT_UART1_CLK_ROOT_TOG			CCM_TARGET_ROOT95_TOG
#define CCM_CLKROOT_UART1_CLK_ROOT_MISC			CCM_MISC95
#define CCM_CLKROOT_UART1_CLK_ROOT_MISC_SET		CCM_MISC95_SET
#define CCM_CLKROOT_UART1_CLK_ROOT_MISC_CLR		CCM_MISC95_CLR
#define CCM_CLKROOT_UART1_CLK_ROOT_MISC_TOG		CCM_MISC95_TOG
#define CCM_CLKROOT_UART1_CLK_ROOT_POST			CCM_POST95
#define CCM_CLKROOT_UART1_CLK_ROOT_POST_SET		CCM_POST95_SET
#define CCM_CLKROOT_UART1_CLK_ROOT_POST_CLR		CCM_POST95_CLR
#define CCM_CLKROOT_UART1_CLK_ROOT_POST_TOG		CCM_POST95_TOG
#define CCM_CLKROOT_UART1_CLK_ROOT_PRE			CCM_PRE95
#define CCM_CLKROOT_UART1_CLK_ROOT_PRE_SET		CCM_PRE95_SET
#define CCM_CLKROOT_UART1_CLK_ROOT_PRE_CLR		CCM_PRE95_CLR
#define CCM_CLKROOT_UART1_CLK_ROOT_PRE_TOG		CCM_PRE95_TOG
#define CCM_CLKROOT_UART1_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL95
#define CCM_CLKROOT_UART1_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL95_SET
#define CCM_CLKROOT_UART1_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL95_CLR
#define CCM_CLKROOT_UART1_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL95_TOG
#define CCM_CLKROOT_UART2_CLK_ROOT			CCM_TARGET_ROOT96
#define CCM_CLKROOT_UART2_CLK_ROOT_SET			CCM_TARGET_ROOT96_SET
#define CCM_CLKROOT_UART2_CLK_ROOT_CLR			CCM_TARGET_ROOT96_CLR
#define CCM_CLKROOT_UART2_CLK_ROOT_TOG			CCM_TARGET_ROOT96_TOG
#define CCM_CLKROOT_UART2_CLK_ROOT_MISC			CCM_MISC96
#define CCM_CLKROOT_UART2_CLK_ROOT_MISC_SET		CCM_MISC96_SET
#define CCM_CLKROOT_UART2_CLK_ROOT_MISC_CLR		CCM_MISC96_CLR
#define CCM_CLKROOT_UART2_CLK_ROOT_MISC_TOG		CCM_MISC96_TOG
#define CCM_CLKROOT_UART2_CLK_ROOT_POST			CCM_POST96
#define CCM_CLKROOT_UART2_CLK_ROOT_POST_SET		CCM_POST96_SET
#define CCM_CLKROOT_UART2_CLK_ROOT_POST_CLR		CCM_POST96_CLR
#define CCM_CLKROOT_UART2_CLK_ROOT_POST_TOG		CCM_POST96_TOG
#define CCM_CLKROOT_UART2_CLK_ROOT_PRE			CCM_PRE96
#define CCM_CLKROOT_UART2_CLK_ROOT_PRE_SET		CCM_PRE96_SET
#define CCM_CLKROOT_UART2_CLK_ROOT_PRE_CLR		CCM_PRE96_CLR
#define CCM_CLKROOT_UART2_CLK_ROOT_PRE_TOG		CCM_PRE96_TOG
#define CCM_CLKROOT_UART2_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL96
#define CCM_CLKROOT_UART2_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL96_SET
#define CCM_CLKROOT_UART2_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL96_CLR
#define CCM_CLKROOT_UART2_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL96_TOG
#define CCM_CLKROOT_UART3_CLK_ROOT			CCM_TARGET_ROOT97
#define CCM_CLKROOT_UART3_CLK_ROOT_SET			CCM_TARGET_ROOT97_SET
#define CCM_CLKROOT_UART3_CLK_ROOT_CLR			CCM_TARGET_ROOT97_CLR
#define CCM_CLKROOT_UART3_CLK_ROOT_TOG			CCM_TARGET_ROOT97_TOG
#define CCM_CLKROOT_UART3_CLK_ROOT_MISC			CCM_MISC97
#define CCM_CLKROOT_UART3_CLK_ROOT_MISC_SET		CCM_MISC97_SET
#define CCM_CLKROOT_UART3_CLK_ROOT_MISC_CLR		CCM_MISC97_CLR
#define CCM_CLKROOT_UART3_CLK_ROOT_MISC_TOG		CCM_MISC97_TOG
#define CCM_CLKROOT_UART3_CLK_ROOT_POST			CCM_POST97
#define CCM_CLKROOT_UART3_CLK_ROOT_POST_SET		CCM_POST97_SET
#define CCM_CLKROOT_UART3_CLK_ROOT_POST_CLR		CCM_POST97_CLR
#define CCM_CLKROOT_UART3_CLK_ROOT_POST_TOG		CCM_POST97_TOG
#define CCM_CLKROOT_UART3_CLK_ROOT_PRE			CCM_PRE97
#define CCM_CLKROOT_UART3_CLK_ROOT_PRE_SET		CCM_PRE97_SET
#define CCM_CLKROOT_UART3_CLK_ROOT_PRE_CLR		CCM_PRE97_CLR
#define CCM_CLKROOT_UART3_CLK_ROOT_PRE_TOG		CCM_PRE97_TOG
#define CCM_CLKROOT_UART3_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL97
#define CCM_CLKROOT_UART3_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL97_SET
#define CCM_CLKROOT_UART3_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL97_CLR
#define CCM_CLKROOT_UART3_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL97_TOG
#define CCM_CLKROOT_UART4_CLK_ROOT			CCM_TARGET_ROOT98
#define CCM_CLKROOT_UART4_CLK_ROOT_SET			CCM_TARGET_ROOT98_SET
#define CCM_CLKROOT_UART4_CLK_ROOT_CLR			CCM_TARGET_ROOT98_CLR
#define CCM_CLKROOT_UART4_CLK_ROOT_TOG			CCM_TARGET_ROOT98_TOG
#define CCM_CLKROOT_UART4_CLK_ROOT_MISC			CCM_MISC98
#define CCM_CLKROOT_UART4_CLK_ROOT_MISC_SET		CCM_MISC98_SET
#define CCM_CLKROOT_UART4_CLK_ROOT_MISC_CLR		CCM_MISC98_CLR
#define CCM_CLKROOT_UART4_CLK_ROOT_MISC_TOG		CCM_MISC98_TOG
#define CCM_CLKROOT_UART4_CLK_ROOT_POST			CCM_POST98
#define CCM_CLKROOT_UART4_CLK_ROOT_POST_SET		CCM_POST98_SET
#define CCM_CLKROOT_UART4_CLK_ROOT_POST_CLR		CCM_POST98_CLR
#define CCM_CLKROOT_UART4_CLK_ROOT_POST_TOG		CCM_POST98_TOG
#define CCM_CLKROOT_UART4_CLK_ROOT_PRE			CCM_PRE98
#define CCM_CLKROOT_UART4_CLK_ROOT_PRE_SET		CCM_PRE98_SET
#define CCM_CLKROOT_UART4_CLK_ROOT_PRE_CLR		CCM_PRE98_CLR
#define CCM_CLKROOT_UART4_CLK_ROOT_PRE_TOG		CCM_PRE98_TOG
#define CCM_CLKROOT_UART4_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL98
#define CCM_CLKROOT_UART4_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL98_SET
#define CCM_CLKROOT_UART4_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL98_CLR
#define CCM_CLKROOT_UART4_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL98_TOG
#define CCM_CLKROOT_UART5_CLK_ROOT			CCM_TARGET_ROOT99
#define CCM_CLKROOT_UART5_CLK_ROOT_SET			CCM_TARGET_ROOT99_SET
#define CCM_CLKROOT_UART5_CLK_ROOT_CLR			CCM_TARGET_ROOT99_CLR
#define CCM_CLKROOT_UART5_CLK_ROOT_TOG			CCM_TARGET_ROOT99_TOG
#define CCM_CLKROOT_UART5_CLK_ROOT_MISC			CCM_MISC99
#define CCM_CLKROOT_UART5_CLK_ROOT_MISC_SET		CCM_MISC99_SET
#define CCM_CLKROOT_UART5_CLK_ROOT_MISC_CLR		CCM_MISC99_CLR
#define CCM_CLKROOT_UART5_CLK_ROOT_MISC_TOG		CCM_MISC99_TOG
#define CCM_CLKROOT_UART5_CLK_ROOT_POST			CCM_POST99
#define CCM_CLKROOT_UART5_CLK_ROOT_POST_SET		CCM_POST99_SET
#define CCM_CLKROOT_UART5_CLK_ROOT_POST_CLR		CCM_POST99_CLR
#define CCM_CLKROOT_UART5_CLK_ROOT_POST_TOG		CCM_POST99_TOG
#define CCM_CLKROOT_UART5_CLK_ROOT_PRE			CCM_PRE99
#define CCM_CLKROOT_UART5_CLK_ROOT_PRE_SET		CCM_PRE99_SET
#define CCM_CLKROOT_UART5_CLK_ROOT_PRE_CLR		CCM_PRE99_CLR
#define CCM_CLKROOT_UART5_CLK_ROOT_PRE_TOG		CCM_PRE99_TOG
#define CCM_CLKROOT_UART5_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL99
#define CCM_CLKROOT_UART5_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL99_SET
#define CCM_CLKROOT_UART5_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL99_CLR
#define CCM_CLKROOT_UART5_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL99_TOG
#define CCM_CLKROOT_UART6_CLK_ROOT			CCM_TARGET_ROOT100
#define CCM_CLKROOT_UART6_CLK_ROOT_SET			CCM_TARGET_ROOT100_SET
#define CCM_CLKROOT_UART6_CLK_ROOT_CLR			CCM_TARGET_ROOT100_CLR
#define CCM_CLKROOT_UART6_CLK_ROOT_TOG			CCM_TARGET_ROOT100_TOG
#define CCM_CLKROOT_UART6_CLK_ROOT_MISC			CCM_MISC100
#define CCM_CLKROOT_UART6_CLK_ROOT_MISC_SET		CCM_MISC100_SET
#define CCM_CLKROOT_UART6_CLK_ROOT_MISC_CLR		CCM_MISC100_CLR
#define CCM_CLKROOT_UART6_CLK_ROOT_MISC_TOG		CCM_MISC100_TOG
#define CCM_CLKROOT_UART6_CLK_ROOT_POST			CCM_POST100
#define CCM_CLKROOT_UART6_CLK_ROOT_POST_SET		CCM_POST100_SET
#define CCM_CLKROOT_UART6_CLK_ROOT_POST_CLR		CCM_POST100_CLR
#define CCM_CLKROOT_UART6_CLK_ROOT_POST_TOG		CCM_POST100_TOG
#define CCM_CLKROOT_UART6_CLK_ROOT_PRE			CCM_PRE100
#define CCM_CLKROOT_UART6_CLK_ROOT_PRE_SET		CCM_PRE100_SET
#define CCM_CLKROOT_UART6_CLK_ROOT_PRE_CLR		CCM_PRE100_CLR
#define CCM_CLKROOT_UART6_CLK_ROOT_PRE_TOG		CCM_PRE100_TOG
#define CCM_CLKROOT_UART6_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL100
#define CCM_CLKROOT_UART6_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL100_SET
#define CCM_CLKROOT_UART6_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL100_CLR
#define CCM_CLKROOT_UART6_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL100_TOG
#define CCM_CLKROOT_UART7_CLK_ROOT			CCM_TARGET_ROOT101
#define CCM_CLKROOT_UART7_CLK_ROOT_SET			CCM_TARGET_ROOT101_SET
#define CCM_CLKROOT_UART7_CLK_ROOT_CLR			CCM_TARGET_ROOT101_CLR
#define CCM_CLKROOT_UART7_CLK_ROOT_TOG			CCM_TARGET_ROOT101_TOG
#define CCM_CLKROOT_UART7_CLK_ROOT_MISC			CCM_MISC101
#define CCM_CLKROOT_UART7_CLK_ROOT_MISC_SET		CCM_MISC101_SET
#define CCM_CLKROOT_UART7_CLK_ROOT_MISC_CLR		CCM_MISC101_CLR
#define CCM_CLKROOT_UART7_CLK_ROOT_MISC_TOG		CCM_MISC101_TOG
#define CCM_CLKROOT_UART7_CLK_ROOT_POST			CCM_POST101
#define CCM_CLKROOT_UART7_CLK_ROOT_POST_SET		CCM_POST101_SET
#define CCM_CLKROOT_UART7_CLK_ROOT_POST_CLR		CCM_POST101_CLR
#define CCM_CLKROOT_UART7_CLK_ROOT_POST_TOG		CCM_POST101_TOG
#define CCM_CLKROOT_UART7_CLK_ROOT_PRE			CCM_PRE101
#define CCM_CLKROOT_UART7_CLK_ROOT_PRE_SET		CCM_PRE101_SET
#define CCM_CLKROOT_UART7_CLK_ROOT_PRE_CLR		CCM_PRE101_CLR
#define CCM_CLKROOT_UART7_CLK_ROOT_PRE_TOG		CCM_PRE101_TOG
#define CCM_CLKROOT_UART7_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL101
#define CCM_CLKROOT_UART7_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL101_SET
#define CCM_CLKROOT_UART7_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL101_CLR
#define CCM_CLKROOT_UART7_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL101_TOG
#define CCM_CLKROOT_ECSPI1_CLK_ROOT			CCM_TARGET_ROOT102
#define CCM_CLKROOT_ECSPI1_CLK_ROOT_SET			CCM_TARGET_ROOT102_SET
#define CCM_CLKROOT_ECSPI1_CLK_ROOT_CLR			CCM_TARGET_ROOT102_CLR
#define CCM_CLKROOT_ECSPI1_CLK_ROOT_TOG			CCM_TARGET_ROOT102_TOG
#define CCM_CLKROOT_ECSPI1_CLK_ROOT_MISC		CCM_MISC102
#define CCM_CLKROOT_ECSPI1_CLK_ROOT_MISC_SET		CCM_MISC102_SET
#define CCM_CLKROOT_ECSPI1_CLK_ROOT_MISC_CLR		CCM_MISC102_CLR
#define CCM_CLKROOT_ECSPI1_CLK_ROOT_MISC_TOG		CCM_MISC102_TOG
#define CCM_CLKROOT_ECSPI1_CLK_ROOT_POST		CCM_POST102
#define CCM_CLKROOT_ECSPI1_CLK_ROOT_POST_SET		CCM_POST102_SET
#define CCM_CLKROOT_ECSPI1_CLK_ROOT_POST_CLR		CCM_POST102_CLR
#define CCM_CLKROOT_ECSPI1_CLK_ROOT_POST_TOG		CCM_POST102_TOG
#define CCM_CLKROOT_ECSPI1_CLK_ROOT_PRE			CCM_PRE102
#define CCM_CLKROOT_ECSPI1_CLK_ROOT_PRE_SET		CCM_PRE102_SET
#define CCM_CLKROOT_ECSPI1_CLK_ROOT_PRE_CLR		CCM_PRE102_CLR
#define CCM_CLKROOT_ECSPI1_CLK_ROOT_PRE_TOG		CCM_PRE102_TOG
#define CCM_CLKROOT_ECSPI1_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL102
#define CCM_CLKROOT_ECSPI1_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL102_SET
#define CCM_CLKROOT_ECSPI1_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL102_CLR
#define CCM_CLKROOT_ECSPI1_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL102_TOG
#define CCM_CLKROOT_ECSPI2_CLK_ROOT			CCM_TARGET_ROOT103
#define CCM_CLKROOT_ECSPI2_CLK_ROOT_SET			CCM_TARGET_ROOT103_SET
#define CCM_CLKROOT_ECSPI2_CLK_ROOT_CLR			CCM_TARGET_ROOT103_CLR
#define CCM_CLKROOT_ECSPI2_CLK_ROOT_TOG			CCM_TARGET_ROOT103_TOG
#define CCM_CLKROOT_ECSPI2_CLK_ROOT_MISC		CCM_MISC103
#define CCM_CLKROOT_ECSPI2_CLK_ROOT_MISC_SET		CCM_MISC103_SET
#define CCM_CLKROOT_ECSPI2_CLK_ROOT_MISC_CLR		CCM_MISC103_CLR
#define CCM_CLKROOT_ECSPI2_CLK_ROOT_MISC_TOG		CCM_MISC103_TOG
#define CCM_CLKROOT_ECSPI2_CLK_ROOT_POST		CCM_POST103
#define CCM_CLKROOT_ECSPI2_CLK_ROOT_POST_SET		CCM_POST103_SET
#define CCM_CLKROOT_ECSPI2_CLK_ROOT_POST_CLR		CCM_POST103_CLR
#define CCM_CLKROOT_ECSPI2_CLK_ROOT_POST_TOG		CCM_POST103_TOG
#define CCM_CLKROOT_ECSPI2_CLK_ROOT_PRE			CCM_PRE103
#define CCM_CLKROOT_ECSPI2_CLK_ROOT_PRE_SET		CCM_PRE103_SET
#define CCM_CLKROOT_ECSPI2_CLK_ROOT_PRE_CLR		CCM_PRE103_CLR
#define CCM_CLKROOT_ECSPI2_CLK_ROOT_PRE_TOG		CCM_PRE103_TOG
#define CCM_CLKROOT_ECSPI2_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL103
#define CCM_CLKROOT_ECSPI2_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL103_SET
#define CCM_CLKROOT_ECSPI2_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL103_CLR
#define CCM_CLKROOT_ECSPI2_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL103_TOG
#define CCM_CLKROOT_ECSPI3_CLK_ROOT			CCM_TARGET_ROOT104
#define CCM_CLKROOT_ECSPI3_CLK_ROOT_SET			CCM_TARGET_ROOT104_SET
#define CCM_CLKROOT_ECSPI3_CLK_ROOT_CLR			CCM_TARGET_ROOT104_CLR
#define CCM_CLKROOT_ECSPI3_CLK_ROOT_TOG			CCM_TARGET_ROOT104_TOG
#define CCM_CLKROOT_ECSPI3_CLK_ROOT_MISC		CCM_MISC104
#define CCM_CLKROOT_ECSPI3_CLK_ROOT_MISC_SET		CCM_MISC104_SET
#define CCM_CLKROOT_ECSPI3_CLK_ROOT_MISC_CLR		CCM_MISC104_CLR
#define CCM_CLKROOT_ECSPI3_CLK_ROOT_MISC_TOG		CCM_MISC104_TOG
#define CCM_CLKROOT_ECSPI3_CLK_ROOT_POST		CCM_POST104
#define CCM_CLKROOT_ECSPI3_CLK_ROOT_POST_SET		CCM_POST104_SET
#define CCM_CLKROOT_ECSPI3_CLK_ROOT_POST_CLR		CCM_POST104_CLR
#define CCM_CLKROOT_ECSPI3_CLK_ROOT_POST_TOG		CCM_POST104_TOG
#define CCM_CLKROOT_ECSPI3_CLK_ROOT_PRE			CCM_PRE104
#define CCM_CLKROOT_ECSPI3_CLK_ROOT_PRE_SET		CCM_PRE104_SET
#define CCM_CLKROOT_ECSPI3_CLK_ROOT_PRE_CLR		CCM_PRE104_CLR
#define CCM_CLKROOT_ECSPI3_CLK_ROOT_PRE_TOG		CCM_PRE104_TOG
#define CCM_CLKROOT_ECSPI3_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL104
#define CCM_CLKROOT_ECSPI3_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL104_SET
#define CCM_CLKROOT_ECSPI3_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL104_CLR
#define CCM_CLKROOT_ECSPI3_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL104_TOG
#define CCM_CLKROOT_ECSPI4_CLK_ROOT			CCM_TARGET_ROOT105
#define CCM_CLKROOT_ECSPI4_CLK_ROOT_SET			CCM_TARGET_ROOT105_SET
#define CCM_CLKROOT_ECSPI4_CLK_ROOT_CLR			CCM_TARGET_ROOT105_CLR
#define CCM_CLKROOT_ECSPI4_CLK_ROOT_TOG			CCM_TARGET_ROOT105_TOG
#define CCM_CLKROOT_ECSPI4_CLK_ROOT_MISC		CCM_MISC105
#define CCM_CLKROOT_ECSPI4_CLK_ROOT_MISC_SET		CCM_MISC105_SET
#define CCM_CLKROOT_ECSPI4_CLK_ROOT_MISC_CLR		CCM_MISC105_CLR
#define CCM_CLKROOT_ECSPI4_CLK_ROOT_MISC_TOG		CCM_MISC105_TOG
#define CCM_CLKROOT_ECSPI4_CLK_ROOT_POST		CCM_POST105
#define CCM_CLKROOT_ECSPI4_CLK_ROOT_POST_SET		CCM_POST105_SET
#define CCM_CLKROOT_ECSPI4_CLK_ROOT_POST_CLR		CCM_POST105_CLR
#define CCM_CLKROOT_ECSPI4_CLK_ROOT_POST_TOG		CCM_POST105_TOG
#define CCM_CLKROOT_ECSPI4_CLK_ROOT_PRE			CCM_PRE105
#define CCM_CLKROOT_ECSPI4_CLK_ROOT_PRE_SET		CCM_PRE105_SET
#define CCM_CLKROOT_ECSPI4_CLK_ROOT_PRE_CLR		CCM_PRE105_CLR
#define CCM_CLKROOT_ECSPI4_CLK_ROOT_PRE_TOG		CCM_PRE105_TOG
#define CCM_CLKROOT_ECSPI4_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL105
#define CCM_CLKROOT_ECSPI4_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL105_SET
#define CCM_CLKROOT_ECSPI4_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL105_CLR
#define CCM_CLKROOT_ECSPI4_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL105_TOG
#define CCM_CLKROOT_PWM1_CLK_ROOT			CCM_TARGET_ROOT106
#define CCM_CLKROOT_PWM1_CLK_ROOT_SET			CCM_TARGET_ROOT106_SET
#define CCM_CLKROOT_PWM1_CLK_ROOT_CLR			CCM_TARGET_ROOT106_CLR
#define CCM_CLKROOT_PWM1_CLK_ROOT_TOG			CCM_TARGET_ROOT106_TOG
#define CCM_CLKROOT_PWM1_CLK_ROOT_MISC			CCM_MISC106
#define CCM_CLKROOT_PWM1_CLK_ROOT_MISC_SET		CCM_MISC106_SET
#define CCM_CLKROOT_PWM1_CLK_ROOT_MISC_CLR		CCM_MISC106_CLR
#define CCM_CLKROOT_PWM1_CLK_ROOT_MISC_TOG		CCM_MISC106_TOG
#define CCM_CLKROOT_PWM1_CLK_ROOT_POST			CCM_POST106
#define CCM_CLKROOT_PWM1_CLK_ROOT_POST_SET		CCM_POST106_SET
#define CCM_CLKROOT_PWM1_CLK_ROOT_POST_CLR		CCM_POST106_CLR
#define CCM_CLKROOT_PWM1_CLK_ROOT_POST_TOG		CCM_POST106_TOG
#define CCM_CLKROOT_PWM1_CLK_ROOT_PRE			CCM_PRE106
#define CCM_CLKROOT_PWM1_CLK_ROOT_PRE_SET		CCM_PRE106_SET
#define CCM_CLKROOT_PWM1_CLK_ROOT_PRE_CLR		CCM_PRE106_CLR
#define CCM_CLKROOT_PWM1_CLK_ROOT_PRE_TOG		CCM_PRE106_TOG
#define CCM_CLKROOT_PWM1_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL106
#define CCM_CLKROOT_PWM1_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL106_SET
#define CCM_CLKROOT_PWM1_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL106_CLR
#define CCM_CLKROOT_PWM1_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL106_TOG
#define CCM_CLKROOT_PWM2_CLK_ROOT			CCM_TARGET_ROOT107
#define CCM_CLKROOT_PWM2_CLK_ROOT_SET			CCM_TARGET_ROOT107_SET
#define CCM_CLKROOT_PWM2_CLK_ROOT_CLR			CCM_TARGET_ROOT107_CLR
#define CCM_CLKROOT_PWM2_CLK_ROOT_TOG			CCM_TARGET_ROOT107_TOG
#define CCM_CLKROOT_PWM2_CLK_ROOT_MISC			CCM_MISC107
#define CCM_CLKROOT_PWM2_CLK_ROOT_MISC_SET		CCM_MISC107_SET
#define CCM_CLKROOT_PWM2_CLK_ROOT_MISC_CLR		CCM_MISC107_CLR
#define CCM_CLKROOT_PWM2_CLK_ROOT_MISC_TOG		CCM_MISC107_TOG
#define CCM_CLKROOT_PWM2_CLK_ROOT_POST			CCM_POST107
#define CCM_CLKROOT_PWM2_CLK_ROOT_POST_SET		CCM_POST107_SET
#define CCM_CLKROOT_PWM2_CLK_ROOT_POST_CLR		CCM_POST107_CLR
#define CCM_CLKROOT_PWM2_CLK_ROOT_POST_TOG		CCM_POST107_TOG
#define CCM_CLKROOT_PWM2_CLK_ROOT_PRE			CCM_PRE107
#define CCM_CLKROOT_PWM2_CLK_ROOT_PRE_SET		CCM_PRE107_SET
#define CCM_CLKROOT_PWM2_CLK_ROOT_PRE_CLR		CCM_PRE107_CLR
#define CCM_CLKROOT_PWM2_CLK_ROOT_PRE_TOG		CCM_PRE107_TOG
#define CCM_CLKROOT_PWM2_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL107
#define CCM_CLKROOT_PWM2_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL107_SET
#define CCM_CLKROOT_PWM2_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL107_CLR
#define CCM_CLKROOT_PWM2_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL107_TOG
#define CCM_CLKROOT_PWM3_CLK_ROOT			CCM_TARGET_ROOT108
#define CCM_CLKROOT_PWM3_CLK_ROOT_SET			CCM_TARGET_ROOT108_SET
#define CCM_CLKROOT_PWM3_CLK_ROOT_CLR			CCM_TARGET_ROOT108_CLR
#define CCM_CLKROOT_PWM3_CLK_ROOT_TOG			CCM_TARGET_ROOT108_TOG
#define CCM_CLKROOT_PWM3_CLK_ROOT_MISC			CCM_MISC108
#define CCM_CLKROOT_PWM3_CLK_ROOT_MISC_SET		CCM_MISC108_SET
#define CCM_CLKROOT_PWM3_CLK_ROOT_MISC_CLR		CCM_MISC108_CLR
#define CCM_CLKROOT_PWM3_CLK_ROOT_MISC_TOG		CCM_MISC108_TOG
#define CCM_CLKROOT_PWM3_CLK_ROOT_POST			CCM_POST108
#define CCM_CLKROOT_PWM3_CLK_ROOT_POST_SET		CCM_POST108_SET
#define CCM_CLKROOT_PWM3_CLK_ROOT_POST_CLR		CCM_POST108_CLR
#define CCM_CLKROOT_PWM3_CLK_ROOT_POST_TOG		CCM_POST108_TOG
#define CCM_CLKROOT_PWM3_CLK_ROOT_PRE			CCM_PRE108
#define CCM_CLKROOT_PWM3_CLK_ROOT_PRE_SET		CCM_PRE108_SET
#define CCM_CLKROOT_PWM3_CLK_ROOT_PRE_CLR		CCM_PRE108_CLR
#define CCM_CLKROOT_PWM3_CLK_ROOT_PRE_TOG		CCM_PRE108_TOG
#define CCM_CLKROOT_PWM3_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL108
#define CCM_CLKROOT_PWM3_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL108_SET
#define CCM_CLKROOT_PWM3_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL108_CLR
#define CCM_CLKROOT_PWM3_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL108_TOG
#define CCM_CLKROOT_PWM4_CLK_ROOT			CCM_TARGET_ROOT109
#define CCM_CLKROOT_PWM4_CLK_ROOT_SET			CCM_TARGET_ROOT109_SET
#define CCM_CLKROOT_PWM4_CLK_ROOT_CLR			CCM_TARGET_ROOT109_CLR
#define CCM_CLKROOT_PWM4_CLK_ROOT_TOG			CCM_TARGET_ROOT109_TOG
#define CCM_CLKROOT_PWM4_CLK_ROOT_MISC			CCM_MISC109
#define CCM_CLKROOT_PWM4_CLK_ROOT_MISC_SET		CCM_MISC109_SET
#define CCM_CLKROOT_PWM4_CLK_ROOT_MISC_CLR		CCM_MISC109_CLR
#define CCM_CLKROOT_PWM4_CLK_ROOT_MISC_TOG		CCM_MISC109_TOG
#define CCM_CLKROOT_PWM4_CLK_ROOT_POST			CCM_POST109
#define CCM_CLKROOT_PWM4_CLK_ROOT_POST_SET		CCM_POST109_SET
#define CCM_CLKROOT_PWM4_CLK_ROOT_POST_CLR		CCM_POST109_CLR
#define CCM_CLKROOT_PWM4_CLK_ROOT_POST_TOG		CCM_POST109_TOG
#define CCM_CLKROOT_PWM4_CLK_ROOT_PRE			CCM_PRE109
#define CCM_CLKROOT_PWM4_CLK_ROOT_PRE_SET		CCM_PRE109_SET
#define CCM_CLKROOT_PWM4_CLK_ROOT_PRE_CLR		CCM_PRE109_CLR
#define CCM_CLKROOT_PWM4_CLK_ROOT_PRE_TOG		CCM_PRE109_TOG
#define CCM_CLKROOT_PWM4_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL109
#define CCM_CLKROOT_PWM4_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL109_SET
#define CCM_CLKROOT_PWM4_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL109_CLR
#define CCM_CLKROOT_PWM4_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL109_TOG
#define CCM_CLKROOT_FLEXTIMER1_CLK_ROOT			CCM_TARGET_ROOT110
#define CCM_CLKROOT_FLEXTIMER1_CLK_ROOT_SET		CCM_TARGET_ROOT110_SET
#define CCM_CLKROOT_FLEXTIMER1_CLK_ROOT_CLR		CCM_TARGET_ROOT110_CLR
#define CCM_CLKROOT_FLEXTIMER1_CLK_ROOT_TOG		CCM_TARGET_ROOT110_TOG
#define CCM_CLKROOT_FLEXTIMER1_CLK_ROOT_MISC		CCM_MISC110
#define CCM_CLKROOT_FLEXTIMER1_CLK_ROOT_MISC_SET	CCM_MISC110_SET
#define CCM_CLKROOT_FLEXTIMER1_CLK_ROOT_MISC_CLR	CCM_MISC110_CLR
#define CCM_CLKROOT_FLEXTIMER1_CLK_ROOT_MISC_TOG	CCM_MISC110_TOG
#define CCM_CLKROOT_FLEXTIMER1_CLK_ROOT_POST		CCM_POST110
#define CCM_CLKROOT_FLEXTIMER1_CLK_ROOT_POST_SET	CCM_POST110_SET
#define CCM_CLKROOT_FLEXTIMER1_CLK_ROOT_POST_CLR	CCM_POST110_CLR
#define CCM_CLKROOT_FLEXTIMER1_CLK_ROOT_POST_TOG	CCM_POST110_TOG
#define CCM_CLKROOT_FLEXTIMER1_CLK_ROOT_PRE		CCM_PRE110
#define CCM_CLKROOT_FLEXTIMER1_CLK_ROOT_PRE_SET		CCM_PRE110_SET
#define CCM_CLKROOT_FLEXTIMER1_CLK_ROOT_PRE_CLR		CCM_PRE110_CLR
#define CCM_CLKROOT_FLEXTIMER1_CLK_ROOT_PRE_TOG		CCM_PRE110_TOG
#define CCM_CLKROOT_FLEXTIMER1_CLK_ROOT_ACCESS_CTRL	CCM_ACCESS_CTRL110
#define CCM_CLKROOT_FLEXTIMER1_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL110_SET
#define CCM_CLKROOT_FLEXTIMER1_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL110_CLR
#define CCM_CLKROOT_FLEXTIMER1_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL110_TOG
#define CCM_CLKROOT_FLEXTIMER2_CLK_ROOT			CCM_TARGET_ROOT111
#define CCM_CLKROOT_FLEXTIMER2_CLK_ROOT_SET		CCM_TARGET_ROOT111_SET
#define CCM_CLKROOT_FLEXTIMER2_CLK_ROOT_CLR		CCM_TARGET_ROOT111_CLR
#define CCM_CLKROOT_FLEXTIMER2_CLK_ROOT_TOG		CCM_TARGET_ROOT111_TOG
#define CCM_CLKROOT_FLEXTIMER2_CLK_ROOT_MISC		CCM_MISC111
#define CCM_CLKROOT_FLEXTIMER2_CLK_ROOT_MISC_SET	CCM_MISC111_SET
#define CCM_CLKROOT_FLEXTIMER2_CLK_ROOT_MISC_CLR	CCM_MISC111_CLR
#define CCM_CLKROOT_FLEXTIMER2_CLK_ROOT_MISC_TOG	CCM_MISC111_TOG
#define CCM_CLKROOT_FLEXTIMER2_CLK_ROOT_POST		CCM_POST111
#define CCM_CLKROOT_FLEXTIMER2_CLK_ROOT_POST_SET	CCM_POST111_SET
#define CCM_CLKROOT_FLEXTIMER2_CLK_ROOT_POST_CLR	CCM_POST111_CLR
#define CCM_CLKROOT_FLEXTIMER2_CLK_ROOT_POST_TOG	CCM_POST111_TOG
#define CCM_CLKROOT_FLEXTIMER2_CLK_ROOT_PRE		CCM_PRE111
#define CCM_CLKROOT_FLEXTIMER2_CLK_ROOT_PRE_SET		CCM_PRE111_SET
#define CCM_CLKROOT_FLEXTIMER2_CLK_ROOT_PRE_CLR		CCM_PRE111_CLR
#define CCM_CLKROOT_FLEXTIMER2_CLK_ROOT_PRE_TOG		CCM_PRE111_TOG
#define CCM_CLKROOT_FLEXTIMER2_CLK_ROOT_ACCESS_CTRL	CCM_ACCESS_CTRL111
#define CCM_CLKROOT_FLEXTIMER2_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL111_SET
#define CCM_CLKROOT_FLEXTIMER2_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL111_CLR
#define CCM_CLKROOT_FLEXTIMER2_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL111_TOG
#define CCM_CLKROOT_SIM1_CLK_ROOT			CCM_TARGET_ROOT112
#define CCM_CLKROOT_SIM1_CLK_ROOT_SET			CCM_TARGET_ROOT112_SET
#define CCM_CLKROOT_SIM1_CLK_ROOT_CLR			CCM_TARGET_ROOT112_CLR
#define CCM_CLKROOT_SIM1_CLK_ROOT_TOG			CCM_TARGET_ROOT112_TOG
#define CCM_CLKROOT_SIM1_CLK_ROOT_MISC			CCM_MISC112
#define CCM_CLKROOT_SIM1_CLK_ROOT_MISC_SET		CCM_MISC112_SET
#define CCM_CLKROOT_SIM1_CLK_ROOT_MISC_CLR		CCM_MISC112_CLR
#define CCM_CLKROOT_SIM1_CLK_ROOT_MISC_TOG		CCM_MISC112_TOG
#define CCM_CLKROOT_SIM1_CLK_ROOT_POST			CCM_POST112
#define CCM_CLKROOT_SIM1_CLK_ROOT_POST_SET		CCM_POST112_SET
#define CCM_CLKROOT_SIM1_CLK_ROOT_POST_CLR		CCM_POST112_CLR
#define CCM_CLKROOT_SIM1_CLK_ROOT_POST_TOG		CCM_POST112_TOG
#define CCM_CLKROOT_SIM1_CLK_ROOT_PRE			CCM_PRE112
#define CCM_CLKROOT_SIM1_CLK_ROOT_PRE_SET		CCM_PRE112_SET
#define CCM_CLKROOT_SIM1_CLK_ROOT_PRE_CLR		CCM_PRE112_CLR
#define CCM_CLKROOT_SIM1_CLK_ROOT_PRE_TOG		CCM_PRE112_TOG
#define CCM_CLKROOT_SIM1_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL112
#define CCM_CLKROOT_SIM1_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL112_SET
#define CCM_CLKROOT_SIM1_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL112_CLR
#define CCM_CLKROOT_SIM1_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL112_TOG
#define CCM_CLKROOT_SIM2_CLK_ROOT			CCM_TARGET_ROOT113
#define CCM_CLKROOT_SIM2_CLK_ROOT_SET			CCM_TARGET_ROOT113_SET
#define CCM_CLKROOT_SIM2_CLK_ROOT_CLR			CCM_TARGET_ROOT113_CLR
#define CCM_CLKROOT_SIM2_CLK_ROOT_TOG			CCM_TARGET_ROOT113_TOG
#define CCM_CLKROOT_SIM2_CLK_ROOT_MISC			CCM_MISC113
#define CCM_CLKROOT_SIM2_CLK_ROOT_MISC_SET		CCM_MISC113_SET
#define CCM_CLKROOT_SIM2_CLK_ROOT_MISC_CLR		CCM_MISC113_CLR
#define CCM_CLKROOT_SIM2_CLK_ROOT_MISC_TOG		CCM_MISC113_TOG
#define CCM_CLKROOT_SIM2_CLK_ROOT_POST			CCM_POST113
#define CCM_CLKROOT_SIM2_CLK_ROOT_POST_SET		CCM_POST113_SET
#define CCM_CLKROOT_SIM2_CLK_ROOT_POST_CLR		CCM_POST113_CLR
#define CCM_CLKROOT_SIM2_CLK_ROOT_POST_TOG		CCM_POST113_TOG
#define CCM_CLKROOT_SIM2_CLK_ROOT_PRE			CCM_PRE113
#define CCM_CLKROOT_SIM2_CLK_ROOT_PRE_SET		CCM_PRE113_SET
#define CCM_CLKROOT_SIM2_CLK_ROOT_PRE_CLR		CCM_PRE113_CLR
#define CCM_CLKROOT_SIM2_CLK_ROOT_PRE_TOG		CCM_PRE113_TOG
#define CCM_CLKROOT_SIM2_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL113
#define CCM_CLKROOT_SIM2_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL113_SET
#define CCM_CLKROOT_SIM2_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL113_CLR
#define CCM_CLKROOT_SIM2_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL113_TOG
#define CCM_CLKROOT_GPT1_CLK_ROOT			CCM_TARGET_ROOT114
#define CCM_CLKROOT_GPT1_CLK_ROOT_SET			CCM_TARGET_ROOT114_SET
#define CCM_CLKROOT_GPT1_CLK_ROOT_CLR			CCM_TARGET_ROOT114_CLR
#define CCM_CLKROOT_GPT1_CLK_ROOT_TOG			CCM_TARGET_ROOT114_TOG
#define CCM_CLKROOT_GPT1_CLK_ROOT_MISC			CCM_MISC114
#define CCM_CLKROOT_GPT1_CLK_ROOT_MISC_SET		CCM_MISC114_SET
#define CCM_CLKROOT_GPT1_CLK_ROOT_MISC_CLR		CCM_MISC114_CLR
#define CCM_CLKROOT_GPT1_CLK_ROOT_MISC_TOG		CCM_MISC114_TOG
#define CCM_CLKROOT_GPT1_CLK_ROOT_POST			CCM_POST114
#define CCM_CLKROOT_GPT1_CLK_ROOT_POST_SET		CCM_POST114_SET
#define CCM_CLKROOT_GPT1_CLK_ROOT_POST_CLR		CCM_POST114_CLR
#define CCM_CLKROOT_GPT1_CLK_ROOT_POST_TOG		CCM_POST114_TOG
#define CCM_CLKROOT_GPT1_CLK_ROOT_PRE			CCM_PRE114
#define CCM_CLKROOT_GPT1_CLK_ROOT_PRE_SET		CCM_PRE114_SET
#define CCM_CLKROOT_GPT1_CLK_ROOT_PRE_CLR		CCM_PRE114_CLR
#define CCM_CLKROOT_GPT1_CLK_ROOT_PRE_TOG		CCM_PRE114_TOG
#define CCM_CLKROOT_GPT1_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL114
#define CCM_CLKROOT_GPT1_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL114_SET
#define CCM_CLKROOT_GPT1_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL114_CLR
#define CCM_CLKROOT_GPT1_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL114_TOG
#define CCM_CLKROOT_GPT2_CLK_ROOT			CCM_TARGET_ROOT115
#define CCM_CLKROOT_GPT2_CLK_ROOT_SET			CCM_TARGET_ROOT115_SET
#define CCM_CLKROOT_GPT2_CLK_ROOT_CLR			CCM_TARGET_ROOT115_CLR
#define CCM_CLKROOT_GPT2_CLK_ROOT_TOG			CCM_TARGET_ROOT115_TOG
#define CCM_CLKROOT_GPT2_CLK_ROOT_MISC			CCM_MISC115
#define CCM_CLKROOT_GPT2_CLK_ROOT_MISC_SET		CCM_MISC115_SET
#define CCM_CLKROOT_GPT2_CLK_ROOT_MISC_CLR		CCM_MISC115_CLR
#define CCM_CLKROOT_GPT2_CLK_ROOT_MISC_TOG		CCM_MISC115_TOG
#define CCM_CLKROOT_GPT2_CLK_ROOT_POST			CCM_POST115
#define CCM_CLKROOT_GPT2_CLK_ROOT_POST_SET		CCM_POST115_SET
#define CCM_CLKROOT_GPT2_CLK_ROOT_POST_CLR		CCM_POST115_CLR
#define CCM_CLKROOT_GPT2_CLK_ROOT_POST_TOG		CCM_POST115_TOG
#define CCM_CLKROOT_GPT2_CLK_ROOT_PRE			CCM_PRE115
#define CCM_CLKROOT_GPT2_CLK_ROOT_PRE_SET		CCM_PRE115_SET
#define CCM_CLKROOT_GPT2_CLK_ROOT_PRE_CLR		CCM_PRE115_CLR
#define CCM_CLKROOT_GPT2_CLK_ROOT_PRE_TOG		CCM_PRE115_TOG
#define CCM_CLKROOT_GPT2_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL115
#define CCM_CLKROOT_GPT2_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL115_SET
#define CCM_CLKROOT_GPT2_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL115_CLR
#define CCM_CLKROOT_GPT2_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL115_TOG
#define CCM_CLKROOT_GPT3_CLK_ROOT			CCM_TARGET_ROOT116
#define CCM_CLKROOT_GPT3_CLK_ROOT_SET			CCM_TARGET_ROOT116_SET
#define CCM_CLKROOT_GPT3_CLK_ROOT_CLR			CCM_TARGET_ROOT116_CLR
#define CCM_CLKROOT_GPT3_CLK_ROOT_TOG			CCM_TARGET_ROOT116_TOG
#define CCM_CLKROOT_GPT3_CLK_ROOT_MISC			CCM_MISC116
#define CCM_CLKROOT_GPT3_CLK_ROOT_MISC_SET		CCM_MISC116_SET
#define CCM_CLKROOT_GPT3_CLK_ROOT_MISC_CLR		CCM_MISC116_CLR
#define CCM_CLKROOT_GPT3_CLK_ROOT_MISC_TOG		CCM_MISC116_TOG
#define CCM_CLKROOT_GPT3_CLK_ROOT_POST			CCM_POST116
#define CCM_CLKROOT_GPT3_CLK_ROOT_POST_SET		CCM_POST116_SET
#define CCM_CLKROOT_GPT3_CLK_ROOT_POST_CLR		CCM_POST116_CLR
#define CCM_CLKROOT_GPT3_CLK_ROOT_POST_TOG		CCM_POST116_TOG
#define CCM_CLKROOT_GPT3_CLK_ROOT_PRE			CCM_PRE116
#define CCM_CLKROOT_GPT3_CLK_ROOT_PRE_SET		CCM_PRE116_SET
#define CCM_CLKROOT_GPT3_CLK_ROOT_PRE_CLR		CCM_PRE116_CLR
#define CCM_CLKROOT_GPT3_CLK_ROOT_PRE_TOG		CCM_PRE116_TOG
#define CCM_CLKROOT_GPT3_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL116
#define CCM_CLKROOT_GPT3_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL116_SET
#define CCM_CLKROOT_GPT3_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL116_CLR
#define CCM_CLKROOT_GPT3_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL116_TOG
#define CCM_CLKROOT_GPT4_CLK_ROOT			CCM_TARGET_ROOT117
#define CCM_CLKROOT_GPT4_CLK_ROOT_SET			CCM_TARGET_ROOT117_SET
#define CCM_CLKROOT_GPT4_CLK_ROOT_CLR			CCM_TARGET_ROOT117_CLR
#define CCM_CLKROOT_GPT4_CLK_ROOT_TOG			CCM_TARGET_ROOT117_TOG
#define CCM_CLKROOT_GPT4_CLK_ROOT_MISC			CCM_MISC117
#define CCM_CLKROOT_GPT4_CLK_ROOT_MISC_SET		CCM_MISC117_SET
#define CCM_CLKROOT_GPT4_CLK_ROOT_MISC_CLR		CCM_MISC117_CLR
#define CCM_CLKROOT_GPT4_CLK_ROOT_MISC_TOG		CCM_MISC117_TOG
#define CCM_CLKROOT_GPT4_CLK_ROOT_POST			CCM_POST117
#define CCM_CLKROOT_GPT4_CLK_ROOT_POST_SET		CCM_POST117_SET
#define CCM_CLKROOT_GPT4_CLK_ROOT_POST_CLR		CCM_POST117_CLR
#define CCM_CLKROOT_GPT4_CLK_ROOT_POST_TOG		CCM_POST117_TOG
#define CCM_CLKROOT_GPT4_CLK_ROOT_PRE			CCM_PRE117
#define CCM_CLKROOT_GPT4_CLK_ROOT_PRE_SET		CCM_PRE117_SET
#define CCM_CLKROOT_GPT4_CLK_ROOT_PRE_CLR		CCM_PRE117_CLR
#define CCM_CLKROOT_GPT4_CLK_ROOT_PRE_TOG		CCM_PRE117_TOG
#define CCM_CLKROOT_GPT4_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL117
#define CCM_CLKROOT_GPT4_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL117_SET
#define CCM_CLKROOT_GPT4_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL117_CLR
#define CCM_CLKROOT_GPT4_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL117_TOG
#define CCM_CLKROOT_TRACE_CLK_ROOT			CCM_TARGET_ROOT118
#define CCM_CLKROOT_TRACE_CLK_ROOT_SET			CCM_TARGET_ROOT118_SET
#define CCM_CLKROOT_TRACE_CLK_ROOT_CLR			CCM_TARGET_ROOT118_CLR
#define CCM_CLKROOT_TRACE_CLK_ROOT_TOG			CCM_TARGET_ROOT118_TOG
#define CCM_CLKROOT_TRACE_CLK_ROOT_MISC			CCM_MISC118
#define CCM_CLKROOT_TRACE_CLK_ROOT_MISC_SET		CCM_MISC118_SET
#define CCM_CLKROOT_TRACE_CLK_ROOT_MISC_CLR		CCM_MISC118_CLR
#define CCM_CLKROOT_TRACE_CLK_ROOT_MISC_TOG		CCM_MISC118_TOG
#define CCM_CLKROOT_TRACE_CLK_ROOT_POST			CCM_POST118
#define CCM_CLKROOT_TRACE_CLK_ROOT_POST_SET		CCM_POST118_SET
#define CCM_CLKROOT_TRACE_CLK_ROOT_POST_CLR		CCM_POST118_CLR
#define CCM_CLKROOT_TRACE_CLK_ROOT_POST_TOG		CCM_POST118_TOG
#define CCM_CLKROOT_TRACE_CLK_ROOT_PRE			CCM_PRE118
#define CCM_CLKROOT_TRACE_CLK_ROOT_PRE_SET		CCM_PRE118_SET
#define CCM_CLKROOT_TRACE_CLK_ROOT_PRE_CLR		CCM_PRE118_CLR
#define CCM_CLKROOT_TRACE_CLK_ROOT_PRE_TOG		CCM_PRE118_TOG
#define CCM_CLKROOT_TRACE_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL118
#define CCM_CLKROOT_TRACE_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL118_SET
#define CCM_CLKROOT_TRACE_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL118_CLR
#define CCM_CLKROOT_TRACE_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL118_TOG
#define CCM_CLKROOT_WDOG_CLK_ROOT			CCM_TARGET_ROOT119
#define CCM_CLKROOT_WDOG_CLK_ROOT_SET			CCM_TARGET_ROOT119_SET
#define CCM_CLKROOT_WDOG_CLK_ROOT_CLR			CCM_TARGET_ROOT119_CLR
#define CCM_CLKROOT_WDOG_CLK_ROOT_TOG			CCM_TARGET_ROOT119_TOG
#define CCM_CLKROOT_WDOG_CLK_ROOT_MISC			CCM_MISC119
#define CCM_CLKROOT_WDOG_CLK_ROOT_MISC_SET		CCM_MISC119_SET
#define CCM_CLKROOT_WDOG_CLK_ROOT_MISC_CLR		CCM_MISC119_CLR
#define CCM_CLKROOT_WDOG_CLK_ROOT_MISC_TOG		CCM_MISC119_TOG
#define CCM_CLKROOT_WDOG_CLK_ROOT_POST			CCM_POST119
#define CCM_CLKROOT_WDOG_CLK_ROOT_POST_SET		CCM_POST119_SET
#define CCM_CLKROOT_WDOG_CLK_ROOT_POST_CLR		CCM_POST119_CLR
#define CCM_CLKROOT_WDOG_CLK_ROOT_POST_TOG		CCM_POST119_TOG
#define CCM_CLKROOT_WDOG_CLK_ROOT_PRE			CCM_PRE119
#define CCM_CLKROOT_WDOG_CLK_ROOT_PRE_SET		CCM_PRE119_SET
#define CCM_CLKROOT_WDOG_CLK_ROOT_PRE_CLR		CCM_PRE119_CLR
#define CCM_CLKROOT_WDOG_CLK_ROOT_PRE_TOG		CCM_PRE119_TOG
#define CCM_CLKROOT_WDOG_CLK_ROOT_ACCESS_CTRL		CCM_ACCESS_CTRL119
#define CCM_CLKROOT_WDOG_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL119_SET
#define CCM_CLKROOT_WDOG_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL119_CLR
#define CCM_CLKROOT_WDOG_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL119_TOG
#define CCM_CLKROOT_CSI_MCLK_CLK_ROOT			CCM_TARGET_ROOT120
#define CCM_CLKROOT_CSI_MCLK_CLK_ROOT_SET		CCM_TARGET_ROOT120_SET
#define CCM_CLKROOT_CSI_MCLK_CLK_ROOT_CLR		CCM_TARGET_ROOT120_CLR
#define CCM_CLKROOT_CSI_MCLK_CLK_ROOT_TOG		CCM_TARGET_ROOT120_TOG
#define CCM_CLKROOT_CSI_MCLK_CLK_ROOT_MISC		CCM_MISC120
#define CCM_CLKROOT_CSI_MCLK_CLK_ROOT_MISC_SET		CCM_MISC120_SET
#define CCM_CLKROOT_CSI_MCLK_CLK_ROOT_MISC_CLR		CCM_MISC120_CLR
#define CCM_CLKROOT_CSI_MCLK_CLK_ROOT_MISC_TOG		CCM_MISC120_TOG
#define CCM_CLKROOT_CSI_MCLK_CLK_ROOT_POST		CCM_POST120
#define CCM_CLKROOT_CSI_MCLK_CLK_ROOT_POST_SET		CCM_POST120_SET
#define CCM_CLKROOT_CSI_MCLK_CLK_ROOT_POST_CLR		CCM_POST120_CLR
#define CCM_CLKROOT_CSI_MCLK_CLK_ROOT_POST_TOG		CCM_POST120_TOG
#define CCM_CLKROOT_CSI_MCLK_CLK_ROOT_PRE		CCM_PRE120
#define CCM_CLKROOT_CSI_MCLK_CLK_ROOT_PRE_SET		CCM_PRE120_SET
#define CCM_CLKROOT_CSI_MCLK_CLK_ROOT_PRE_CLR		CCM_PRE120_CLR
#define CCM_CLKROOT_CSI_MCLK_CLK_ROOT_PRE_TOG		CCM_PRE120_TOG
#define CCM_CLKROOT_CSI_MCLK_CLK_ROOT_ACCESS_CTRL	CCM_ACCESS_CTRL120
#define CCM_CLKROOT_CSI_MCLK_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL120_SET
#define CCM_CLKROOT_CSI_MCLK_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL120_CLR
#define CCM_CLKROOT_CSI_MCLK_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL120_TOG
#define CCM_CLKROOT_AUDIO_MCLK_CLK_ROOT			CCM_TARGET_ROOT121
#define CCM_CLKROOT_AUDIO_MCLK_CLK_ROOT_SET		CCM_TARGET_ROOT121_SET
#define CCM_CLKROOT_AUDIO_MCLK_CLK_ROOT_CLR		CCM_TARGET_ROOT121_CLR
#define CCM_CLKROOT_AUDIO_MCLK_CLK_ROOT_TOG		CCM_TARGET_ROOT121_TOG
#define CCM_CLKROOT_AUDIO_MCLK_CLK_ROOT_MISC		CCM_MISC121
#define CCM_CLKROOT_AUDIO_MCLK_CLK_ROOT_MISC_SET	CCM_MISC121_SET
#define CCM_CLKROOT_AUDIO_MCLK_CLK_ROOT_MISC_CLR	CCM_MISC121_CLR
#define CCM_CLKROOT_AUDIO_MCLK_CLK_ROOT_MISC_TOG	CCM_MISC121_TOG
#define CCM_CLKROOT_AUDIO_MCLK_CLK_ROOT_POST		CCM_POST121
#define CCM_CLKROOT_AUDIO_MCLK_CLK_ROOT_POST_SET	CCM_POST121_SET
#define CCM_CLKROOT_AUDIO_MCLK_CLK_ROOT_POST_CLR	CCM_POST121_CLR
#define CCM_CLKROOT_AUDIO_MCLK_CLK_ROOT_POST_TOG	CCM_POST121_TOG
#define CCM_CLKROOT_AUDIO_MCLK_CLK_ROOT_PRE		CCM_PRE121
#define CCM_CLKROOT_AUDIO_MCLK_CLK_ROOT_PRE_SET		CCM_PRE121_SET
#define CCM_CLKROOT_AUDIO_MCLK_CLK_ROOT_PRE_CLR		CCM_PRE121_CLR
#define CCM_CLKROOT_AUDIO_MCLK_CLK_ROOT_PRE_TOG		CCM_PRE121_TOG
#define CCM_CLKROOT_AUDIO_MCLK_CLK_ROOT_ACCESS_CTRL	CCM_ACCESS_CTRL121
#define CCM_CLKROOT_AUDIO_MCLK_CLK_ROOT_ACCESS_CTRL_SET	CCM_ACCESS_CTRL121_SET
#define CCM_CLKROOT_AUDIO_MCLK_CLK_ROOT_ACCESS_CTRL_CLR	CCM_ACCESS_CTRL121_CLR
#define CCM_CLKROOT_AUDIO_MCLK_CLK_ROOT_ACCESS_CTRL_TOG	CCM_ACCESS_CTRL121_TOG
#define CCM_CLKROOT_CCM_CLKO1				CCM_TARGET_ROOT123
#define CCM_CLKROOT_CCM_CLKO1_SET			CCM_TARGET_ROOT123_SET
#define CCM_CLKROOT_CCM_CLKO1_CLR			CCM_TARGET_ROOT123_CLR
#define CCM_CLKROOT_CCM_CLKO1_TOG			CCM_TARGET_ROOT123_TOG
#define CCM_CLKROOT_CCM_CLKO1_MISC			CCM_MISC123
#define CCM_CLKROOT_CCM_CLKO1_MISC_SET			CCM_MISC123_SET
#define CCM_CLKROOT_CCM_CLKO1_MISC_CLR			CCM_MISC123_CLR
#define CCM_CLKROOT_CCM_CLKO1_MISC_TOG			CCM_MISC123_TOG
#define CCM_CLKROOT_CCM_CLKO1_POST			CCM_POST123
#define CCM_CLKROOT_CCM_CLKO1_POST_SET			CCM_POST123_SET
#define CCM_CLKROOT_CCM_CLKO1_POST_CLR			CCM_POST123_CLR
#define CCM_CLKROOT_CCM_CLKO1_POST_TOG			CCM_POST123_TOG
#define CCM_CLKROOT_CCM_CLKO1_PRE			CCM_PRE123
#define CCM_CLKROOT_CCM_CLKO1_PRE_SET			CCM_PRE123_SET
#define CCM_CLKROOT_CCM_CLKO1_PRE_CLR			CCM_PRE123_CLR
#define CCM_CLKROOT_CCM_CLKO1_PRE_TOG			CCM_PRE123_TOG
#define CCM_CLKROOT_CCM_CLKO1_ACCESS_CTRL		CCM_ACCESS_CTRL123
#define CCM_CLKROOT_CCM_CLKO1_ACCESS_CTRL_SET		CCM_ACCESS_CTRL123_SET
#define CCM_CLKROOT_CCM_CLKO1_ACCESS_CTRL_CLR		CCM_ACCESS_CTRL123_CLR
#define CCM_CLKROOT_CCM_CLKO1_ACCESS_CTRL_TOG		CCM_ACCESS_CTRL123_TOG
#define CCM_CLKROOT_CCM_CLKO2				CCM_TARGET_ROOT124
#define CCM_CLKROOT_CCM_CLKO2_SET			CCM_TARGET_ROOT124_SET
#define CCM_CLKROOT_CCM_CLKO2_CLR			CCM_TARGET_ROOT124_CLR
#define CCM_CLKROOT_CCM_CLKO2_TOG			CCM_TARGET_ROOT124_TOG
#define CCM_CLKROOT_CCM_CLKO2_MISC			CCM_MISC124
#define CCM_CLKROOT_CCM_CLKO2_MISC_SET			CCM_MISC124_SET
#define CCM_CLKROOT_CCM_CLKO2_MISC_CLR			CCM_MISC124_CLR
#define CCM_CLKROOT_CCM_CLKO2_MISC_TOG			CCM_MISC124_TOG
#define CCM_CLKROOT_CCM_CLKO2_POST			CCM_POST124
#define CCM_CLKROOT_CCM_CLKO2_POST_SET			CCM_POST124_SET
#define CCM_CLKROOT_CCM_CLKO2_POST_CLR			CCM_POST124_CLR
#define CCM_CLKROOT_CCM_CLKO2_POST_TOG			CCM_POST124_TOG
#define CCM_CLKROOT_CCM_CLKO2_PRE			CCM_PRE124
#define CCM_CLKROOT_CCM_CLKO2_PRE_SET			CCM_PRE124_SET
#define CCM_CLKROOT_CCM_CLKO2_PRE_CLR			CCM_PRE124_CLR
#define CCM_CLKROOT_CCM_CLKO2_PRE_TOG			CCM_PRE124_TOG
#define CCM_CLKROOT_CCM_CLKO2_ACCESS_CTRL		CCM_ACCESS_CTRL124
#define CCM_CLKROOT_CCM_CLKO2_ACCESS_CTRL_SET		CCM_ACCESS_CTRL124_SET
#define CCM_CLKROOT_CCM_CLKO2_ACCESS_CTRL_CLR		CCM_ACCESS_CTRL124_CLR
#define CCM_CLKROOT_CCM_CLKO2_ACCESS_CTRL_TOG		CCM_ACCESS_CTRL124_TOG

#define AIPS1_CCM_SIZE			0x0000c000


/* Clock Control Module Analog (AIPS1_CCM_ANALOG_BASE:0x30360000) */
#define CCM_ANALOG_PLL_ARM		0x00000060
#define CCM_ANALOG_PLL_ARM_SET		0x00000064
#define CCM_ANALOG_PLL_ARM_CLR		0x00000068
#define CCM_ANALOG_PLL_ARM_TOG		0x0000006c
#define  CCM_ANALOG_PLL_ARM_DIV_SELECT		__BITS(6, 0)
#define CCM_ANALOG_PLL_DDR		0x00000070
#define CCM_ANALOG_PLL_DDR_SET		0x00000074
#define CCM_ANALOG_PLL_DDR_CLR		0x00000078
#define  CCM_ANALOG_PLL_DDR_ENABLE_CLK		__BIT(13)
#define  CCM_ANALOG_PLL_DDR_DIV2_ENABLE_CLK	__BIT(12)
#define  CCM_ANALOG_PLL_DDR_TEST_DIV_SELECT	__BITS(22, 21)
#define  CCM_ANALOG_PLL_DDR_DIV_SELECT		__BITS(6, 0)
#define CCM_ANALOG_PLL_DDR_TOG		0x0000007c
#define CCM_ANALOG_PLL_DDR_SS		0x00000080
#define CCM_ANALOG_PLL_DDR_NUM		0x00000090
#define CCM_ANALOG_PLL_DDR_DENOM	0x000000a0
#define CCM_ANALOG_PLL_480		0x000000b0
#define  CCM_ANALOG_PLL_480_DIV_SELECT		__BIT(0)
#define CCM_ANALOG_PLL_480_SET		0x000000b4
#define CCM_ANALOG_PLL_480_CLR		0x000000b8
#define CCM_ANALOG_PLL_480_TOG		0x000000bc
#define CCM_ANALOG_PFD_480A		0x000000c0
#define  CCM_ANALOG_PFD_480A_PDF3_FRAC		__BITS(29, 24)
#define  CCM_ANALOG_PFD_480A_PDF2_FRAC		__BITS(21, 16)
#define  CCM_ANALOG_PFD_480A_PDF1_FRAC		__BITS(13, 8)
#define  CCM_ANALOG_PFD_480A_PDF0_FRAC		__BITS(5, 0)
#define CCM_ANALOG_PFD_480A_SET		0x000000c4
#define CCM_ANALOG_PFD_480A_CLR		0x000000c8
#define CCM_ANALOG_PFD_480A_TOG		0x000000cc
#define CCM_ANALOG_PFD_480B		0x000000d0
#define  CCM_ANALOG_PFD_480B_PDF7_FRAC		__BITS(29, 24)
#define  CCM_ANALOG_PFD_480B_PDF6_FRAC		__BITS(21, 16)
#define  CCM_ANALOG_PFD_480B_PDF5_FRAC		__BITS(13, 8)
#define  CCM_ANALOG_PFD_480B_PDF4_FRAC		__BITS(5, 0)
#define CCM_ANALOG_PFD_480B_SET		0x000000d4
#define CCM_ANALOG_PFD_480B_CLR		0x000000d8
#define CCM_ANALOG_PFD_480B_TOG		0x000000dc
#define CCM_ANALOG_PLL_ENET		0x000000e0
#define  CCM_ANALOG_PLL_ENET_LOCK		__BIT(31)
#define  CCM_ANALOG_PLL_ENET_DITHER_ENABLE	__BIT(17)
#define  CCM_ANALOG_PLL_ENET_BYPASS		__BIT(16)
#define  CCM_ANALOG_PLL_ENET_ENABLE_CLK_500MHZ	__BIT(12)
#define  CCM_ANALOG_PLL_ENET_ENABLE_CLK_250MHZ	__BIT(11)
#define  CCM_ANALOG_PLL_ENET_ENABLE_CLK_125MHZ	__BIT(10)
#define  CCM_ANALOG_PLL_ENET_ENABLE_CLK_100MHZ	__BIT(9)
#define  CCM_ANALOG_PLL_ENET_ENABLE_CLK_50MHZ	__BIT(8)
#define  CCM_ANALOG_PLL_ENET_ENABLE_CLK_40MHZ	__BIT(7)
#define  CCM_ANALOG_PLL_ENET_ENABLE_CLK_25MHZ	__BIT(6)
#define  CCM_ANALOG_PLL_ENET_POWERDOWN		__BIT(5)

#define CCM_ANALOG_PLL_ENET_SET		0x000000e4
#define CCM_ANALOG_PLL_ENET_CLR		0x000000e8
#define CCM_ANALOG_PLL_ENET_TOG		0x000000ec
#define CCM_ANALOG_PLL_AUDIO		0x000000f0
#define  CCM_ANALOG_PLL_AUDIO_DIV_SELECT	__BITS(6, 0)
#define  CCM_ANALOG_PLL_AUDIO_POST_DIV_SELECT	__BITS(23, 22)
#define  CCM_ANALOG_PLL_AUDIO_TEST_DIV_SELECT	__BITS(20, 19)
#define CCM_ANALOG_PLL_AUDIO_SET	0x000000f4
#define CCM_ANALOG_PLL_AUDIO_CLR	0x000000f8
#define CCM_ANALOG_PLL_AUDIO_TOG	0x000000fc
#define CCM_ANALOG_PLL_AUDIO_SS		0x00000100
#define CCM_ANALOG_PLL_AUDIO_NUM	0x00000110
#define CCM_ANALOG_PLL_AUDIO_DENOM	0x00000120
#define CCM_ANALOG_PLL_VIDEO		0x00000130
#define  CCM_ANALOG_PLL_VIDEO_DIV_SELECT	__BITS(6, 0)
#define  CCM_ANALOG_PLL_VIDEO_POST_DIV_SELECT	__BITS(23, 22)
#define  CCM_ANALOG_PLL_VIDEO_TEST_DIV_SELECT	__BITS(20, 19)
#define CCM_ANALOG_PLL_VIDEO_SET	0x00000134
#define CCM_ANALOG_PLL_VIDEO_CLR	0x00000138
#define CCM_ANALOG_PLL_VIDEO_TOG	0x0000013c
#define CCM_ANALOG_PLL_VIDEO_SS		0x00000140
#define CCM_ANALOG_PLL_VIDEO_NUM	0x00000150
#define CCM_ANALOG_PLL_VIDEO_DENOM	0x00000160
#define CCM_ANALOG_CLK_MISC0		0x00000170
#define CCM_ANALOG_CLK_MISC0_SET	0x00000174
#define CCM_ANALOG_CLK_MISC0_CLR	0x00000178
#define CCM_ANALOG_CLK_MISC0_TOG	0x0000017c
#define CCM_ANALOG_DIGPROG		0x00000800

#define AIPS1_CCM_ANALOG_SIZE		0x0000c000

#endif /* _ARM_IMX_IMX7_CCMREG_H_ */
