/* $NetBSD: netbsd32_systrace_args.c,v 1.32.2.2 2020/03/08 10:38:10 martin Exp $ */

/*
 * System call argument to DTrace register array converstion.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * This file is part of the DTrace syscall provider.
 */

static void
systrace_args(register_t sysnum, const void *params, uintptr_t *uarg, size_t *n_args)
{
	intptr_t *iarg  = (intptr_t *)uarg;
	switch (sysnum) {
	/* netbsd32_syscall */
	case 0: {
		const struct netbsd32_syscall_args *p = params;
		iarg[0] = SCARG(p, code); /* int */
		iarg[1] = SCARG(p, args[NETBSD32_SYS_MAXSYSARGS]); /* register32_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_exit */
	case 1: {
		const struct netbsd32_exit_args *p = params;
		iarg[0] = SCARG(p, rval); /* int */
		*n_args = 1;
		break;
	}
	/* sys_fork */
	case 2: {
		*n_args = 0;
		break;
	}
	/* netbsd32_read */
	case 3: {
		const struct netbsd32_read_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_voidp */
		iarg[2] = SCARG(p, nbyte); /* netbsd32_size_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_write */
	case 4: {
		const struct netbsd32_write_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_voidp */
		iarg[2] = SCARG(p, nbyte); /* netbsd32_size_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_open */
	case 5: {
		const struct netbsd32_open_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, flags); /* int */
		iarg[2] = SCARG(p, mode); /* mode_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_close */
	case 6: {
		const struct netbsd32_close_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* netbsd32_wait4 */
	case 7: {
		const struct compat_50_netbsd32_wait4_args *p = params;
		iarg[0] = SCARG(p, pid); /* int */
		uarg[1] = (intptr_t) SCARG(p, status).i32; /* netbsd32_intp */
		iarg[2] = SCARG(p, options); /* int */
		uarg[3] = (intptr_t) SCARG(p, rusage).i32; /* netbsd32_rusage50p_t */
		*n_args = 4;
		break;
	}
	/* netbsd32_ocreat */
	case 8: {
		const struct compat_43_netbsd32_ocreat_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, mode); /* mode_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_link */
	case 9: {
		const struct netbsd32_link_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, link).i32; /* netbsd32_charp */
		*n_args = 2;
		break;
	}
	/* netbsd32_unlink */
	case 10: {
		const struct netbsd32_unlink_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		*n_args = 1;
		break;
	}
	/* netbsd32_chdir */
	case 12: {
		const struct netbsd32_chdir_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		*n_args = 1;
		break;
	}
	/* netbsd32_fchdir */
	case 13: {
		const struct netbsd32_fchdir_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* netbsd32_mknod */
	case 14: {
		const struct compat_50_netbsd32_mknod_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, mode); /* mode_t */
		uarg[2] = SCARG(p, dev); /* uint32_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_chmod */
	case 15: {
		const struct netbsd32_chmod_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, mode); /* mode_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_chown */
	case 16: {
		const struct netbsd32_chown_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = SCARG(p, uid); /* uid_t */
		iarg[2] = SCARG(p, gid); /* gid_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_break */
	case 17: {
		const struct netbsd32_break_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, nsize).i32; /* netbsd32_charp */
		*n_args = 1;
		break;
	}
	/* netbsd32_getfsstat */
	case 18: {
		const struct compat_20_netbsd32_getfsstat_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_statfsp_t */
		iarg[1] = SCARG(p, bufsize); /* netbsd32_long */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_olseek */
	case 19: {
		const struct compat_43_netbsd32_olseek_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, offset); /* netbsd32_long */
		iarg[2] = SCARG(p, whence); /* int */
		*n_args = 3;
		break;
	}
	/* sys_getpid */
	case 20: {
		*n_args = 0;
		break;
	}
	/* netbsd32_mount */
	case 21: {
		const struct compat_40_netbsd32_mount_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, type).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[2] = SCARG(p, flags); /* int */
		uarg[3] = (intptr_t) SCARG(p, data).i32; /* netbsd32_voidp */
		*n_args = 4;
		break;
	}
	/* netbsd32_unmount */
	case 22: {
		const struct netbsd32_unmount_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, flags); /* int */
		*n_args = 2;
		break;
	}
	/* netbsd32_setuid */
	case 23: {
		const struct netbsd32_setuid_args *p = params;
		uarg[0] = SCARG(p, uid); /* uid_t */
		*n_args = 1;
		break;
	}
	/* sys_getuid */
	case 24: {
		*n_args = 0;
		break;
	}
	/* sys_geteuid */
	case 25: {
		*n_args = 0;
		break;
	}
	/* netbsd32_ptrace */
	case 26: {
		const struct netbsd32_ptrace_args *p = params;
		iarg[0] = SCARG(p, req); /* int */
		iarg[1] = SCARG(p, pid); /* pid_t */
		uarg[2] = (intptr_t) SCARG(p, addr).i32; /* netbsd32_voidp */
		iarg[3] = SCARG(p, data); /* int */
		*n_args = 4;
		break;
	}
	/* netbsd32_recvmsg */
	case 27: {
		const struct netbsd32_recvmsg_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, msg).i32; /* netbsd32_msghdrp_t */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_sendmsg */
	case 28: {
		const struct netbsd32_sendmsg_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, msg).i32; /* netbsd32_msghdrp_t */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_recvfrom */
	case 29: {
		const struct netbsd32_recvfrom_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_voidp */
		iarg[2] = SCARG(p, len); /* netbsd32_size_t */
		iarg[3] = SCARG(p, flags); /* int */
		uarg[4] = (intptr_t) SCARG(p, from).i32; /* netbsd32_sockaddrp_t */
		uarg[5] = (intptr_t) SCARG(p, fromlenaddr).i32; /* netbsd32_intp */
		*n_args = 6;
		break;
	}
	/* netbsd32_accept */
	case 30: {
		const struct netbsd32_accept_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, name).i32; /* netbsd32_sockaddrp_t */
		uarg[2] = (intptr_t) SCARG(p, anamelen).i32; /* netbsd32_intp */
		*n_args = 3;
		break;
	}
	/* netbsd32_getpeername */
	case 31: {
		const struct netbsd32_getpeername_args *p = params;
		iarg[0] = SCARG(p, fdes); /* int */
		uarg[1] = (intptr_t) SCARG(p, asa).i32; /* netbsd32_sockaddrp_t */
		uarg[2] = (intptr_t) SCARG(p, alen).i32; /* netbsd32_intp */
		*n_args = 3;
		break;
	}
	/* netbsd32_getsockname */
	case 32: {
		const struct netbsd32_getsockname_args *p = params;
		iarg[0] = SCARG(p, fdes); /* int */
		uarg[1] = (intptr_t) SCARG(p, asa).i32; /* netbsd32_sockaddrp_t */
		uarg[2] = (intptr_t) SCARG(p, alen).i32; /* netbsd32_intp */
		*n_args = 3;
		break;
	}
	/* netbsd32_access */
	case 33: {
		const struct netbsd32_access_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, flags); /* int */
		*n_args = 2;
		break;
	}
	/* netbsd32_chflags */
	case 34: {
		const struct netbsd32_chflags_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, flags); /* netbsd32_u_long */
		*n_args = 2;
		break;
	}
	/* netbsd32_fchflags */
	case 35: {
		const struct netbsd32_fchflags_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, flags); /* netbsd32_u_long */
		*n_args = 2;
		break;
	}
	/* sys_sync */
	case 36: {
		*n_args = 0;
		break;
	}
	/* netbsd32_kill */
	case 37: {
		const struct netbsd32_kill_args *p = params;
		iarg[0] = SCARG(p, pid); /* int */
		iarg[1] = SCARG(p, signum); /* int */
		*n_args = 2;
		break;
	}
	/* netbsd32_stat43 */
	case 38: {
		const struct compat_43_netbsd32_stat43_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, ub).i32; /* netbsd32_stat43p_t */
		*n_args = 2;
		break;
	}
	/* sys_getppid */
	case 39: {
		*n_args = 0;
		break;
	}
	/* netbsd32_lstat43 */
	case 40: {
		const struct compat_43_netbsd32_lstat43_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, ub).i32; /* netbsd32_stat43p_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_dup */
	case 41: {
		const struct netbsd32_dup_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* sys_pipe */
	case 42: {
		*n_args = 0;
		break;
	}
	/* sys_getegid */
	case 43: {
		*n_args = 0;
		break;
	}
	/* netbsd32_profil */
	case 44: {
		const struct netbsd32_profil_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, samples).i32; /* netbsd32_voidp */
		iarg[1] = SCARG(p, size); /* netbsd32_size_t */
		iarg[2] = SCARG(p, offset); /* netbsd32_u_long */
		uarg[3] = SCARG(p, scale); /* u_int */
		*n_args = 4;
		break;
	}
	/* netbsd32_ktrace */
	case 45: {
		const struct netbsd32_ktrace_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fname).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, ops); /* int */
		iarg[2] = SCARG(p, facs); /* int */
		iarg[3] = SCARG(p, pid); /* int */
		*n_args = 4;
		break;
	}
	/* netbsd32_sigaction */
	case 46: {
		const struct netbsd32_sigaction_args *p = params;
		iarg[0] = SCARG(p, signum); /* int */
		uarg[1] = (intptr_t) SCARG(p, nsa).i32; /* netbsd32_sigactionp_t */
		uarg[2] = (intptr_t) SCARG(p, osa).i32; /* netbsd32_sigactionp_t */
		*n_args = 3;
		break;
	}
	/* sys_getgid */
	case 47: {
		*n_args = 0;
		break;
	}
	/* netbsd32_sigprocmask */
	case 48: {
		const struct compat_13_netbsd32_sigprocmask_args *p = params;
		iarg[0] = SCARG(p, how); /* int */
		iarg[1] = SCARG(p, mask); /* int */
		*n_args = 2;
		break;
	}
	/* netbsd32___getlogin */
	case 49: {
		const struct netbsd32___getlogin_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, namebuf).i32; /* netbsd32_charp */
		uarg[1] = SCARG(p, namelen); /* u_int */
		*n_args = 2;
		break;
	}
	/* netbsd32_setlogin */
	case 50: {
		const struct netbsd32_setlogin_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, namebuf).i32; /* netbsd32_charp */
		*n_args = 1;
		break;
	}
	/* netbsd32_acct */
	case 51: {
		const struct netbsd32_acct_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		*n_args = 1;
		break;
	}
	/* sys_sigpending */
	case 52: {
		*n_args = 0;
		break;
	}
	/* netbsd32_sigaltstack13 */
	case 53: {
		const struct compat_13_netbsd32_sigaltstack13_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, nss).i32; /* netbsd32_sigaltstack13p_t */
		uarg[1] = (intptr_t) SCARG(p, oss).i32; /* netbsd32_sigaltstack13p_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_ioctl */
	case 54: {
		const struct netbsd32_ioctl_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, com); /* netbsd32_u_long */
		uarg[2] = (intptr_t) SCARG(p, data).i32; /* netbsd32_voidp */
		*n_args = 3;
		break;
	}
	/* netbsd32_reboot */
	case 55: {
		const struct compat_12_netbsd32_reboot_args *p = params;
		iarg[0] = SCARG(p, opt); /* int */
		*n_args = 1;
		break;
	}
	/* netbsd32_revoke */
	case 56: {
		const struct netbsd32_revoke_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		*n_args = 1;
		break;
	}
	/* netbsd32_symlink */
	case 57: {
		const struct netbsd32_symlink_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, link).i32; /* netbsd32_charp */
		*n_args = 2;
		break;
	}
	/* netbsd32_readlink */
	case 58: {
		const struct netbsd32_readlink_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_charp */
		iarg[2] = SCARG(p, count); /* netbsd32_size_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_execve */
	case 59: {
		const struct netbsd32_execve_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, argp).i32; /* netbsd32_charpp */
		uarg[2] = (intptr_t) SCARG(p, envp).i32; /* netbsd32_charpp */
		*n_args = 3;
		break;
	}
	/* netbsd32_umask */
	case 60: {
		const struct netbsd32_umask_args *p = params;
		iarg[0] = SCARG(p, newmask); /* mode_t */
		*n_args = 1;
		break;
	}
	/* netbsd32_chroot */
	case 61: {
		const struct netbsd32_chroot_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		*n_args = 1;
		break;
	}
	/* netbsd32_fstat43 */
	case 62: {
		const struct compat_43_netbsd32_fstat43_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, sb).i32; /* netbsd32_stat43p_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_ogetkerninfo */
	case 63: {
		const struct compat_43_netbsd32_ogetkerninfo_args *p = params;
		iarg[0] = SCARG(p, op); /* int */
		uarg[1] = (intptr_t) SCARG(p, where).i32; /* netbsd32_charp */
		uarg[2] = (intptr_t) SCARG(p, size).i32; /* netbsd32_intp */
		iarg[3] = SCARG(p, arg); /* int */
		*n_args = 4;
		break;
	}
	/* sys_getpagesize */
	case 64: {
		*n_args = 0;
		break;
	}
	/* netbsd32_msync */
	case 65: {
		const struct compat_12_netbsd32_msync_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr).i32; /* netbsd32_voidp */
		iarg[1] = SCARG(p, len); /* netbsd32_size_t */
		*n_args = 2;
		break;
	}
	/* sys_vfork */
	case 66: {
		*n_args = 0;
		break;
	}
	/* netbsd32_ommap */
	case 71: {
		const struct compat_43_netbsd32_ommap_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr).i32; /* netbsd32_voidp */
		iarg[1] = SCARG(p, len); /* netbsd32_size_t */
		iarg[2] = SCARG(p, prot); /* int */
		iarg[3] = SCARG(p, flags); /* int */
		iarg[4] = SCARG(p, fd); /* int */
		iarg[5] = SCARG(p, pos); /* netbsd32_long */
		*n_args = 6;
		break;
	}
	/* netbsd32_ovadvise */
	case 72: {
		const struct netbsd32_ovadvise_args *p = params;
		iarg[0] = SCARG(p, anom); /* int */
		*n_args = 1;
		break;
	}
	/* netbsd32_munmap */
	case 73: {
		const struct netbsd32_munmap_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr).i32; /* netbsd32_voidp */
		iarg[1] = SCARG(p, len); /* netbsd32_size_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_mprotect */
	case 74: {
		const struct netbsd32_mprotect_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr).i32; /* netbsd32_voidp */
		iarg[1] = SCARG(p, len); /* netbsd32_size_t */
		iarg[2] = SCARG(p, prot); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_madvise */
	case 75: {
		const struct netbsd32_madvise_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr).i32; /* netbsd32_voidp */
		iarg[1] = SCARG(p, len); /* netbsd32_size_t */
		iarg[2] = SCARG(p, behav); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_mincore */
	case 78: {
		const struct netbsd32_mincore_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr).i32; /* netbsd32_voidp */
		iarg[1] = SCARG(p, len); /* netbsd32_size_t */
		uarg[2] = (intptr_t) SCARG(p, vec).i32; /* netbsd32_charp */
		*n_args = 3;
		break;
	}
	/* netbsd32_getgroups */
	case 79: {
		const struct netbsd32_getgroups_args *p = params;
		iarg[0] = SCARG(p, gidsetsize); /* int */
		uarg[1] = (intptr_t) SCARG(p, gidset).i32; /* netbsd32_gid_tp */
		*n_args = 2;
		break;
	}
	/* netbsd32_setgroups */
	case 80: {
		const struct netbsd32_setgroups_args *p = params;
		iarg[0] = SCARG(p, gidsetsize); /* int */
		uarg[1] = (intptr_t) SCARG(p, gidset).i32; /* netbsd32_gid_tp */
		*n_args = 2;
		break;
	}
	/* sys_getpgrp */
	case 81: {
		*n_args = 0;
		break;
	}
	/* netbsd32_setpgid */
	case 82: {
		const struct netbsd32_setpgid_args *p = params;
		iarg[0] = SCARG(p, pid); /* int */
		iarg[1] = SCARG(p, pgid); /* int */
		*n_args = 2;
		break;
	}
	/* netbsd32_setitimer */
	case 83: {
		const struct compat_50_netbsd32_setitimer_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		uarg[1] = (intptr_t) SCARG(p, itv).i32; /* netbsd32_itimerval50p_t */
		uarg[2] = (intptr_t) SCARG(p, oitv).i32; /* netbsd32_itimerval50p_t */
		*n_args = 3;
		break;
	}
	/* sys_wait */
	case 84: {
		*n_args = 0;
		break;
	}
	/* netbsd32_oswapon */
	case 85: {
		const struct compat_12_netbsd32_oswapon_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, name).i32; /* netbsd32_charp */
		*n_args = 1;
		break;
	}
	/* netbsd32_getitimer */
	case 86: {
		const struct compat_50_netbsd32_getitimer_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		uarg[1] = (intptr_t) SCARG(p, itv).i32; /* netbsd32_itimerval50p_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_ogethostname */
	case 87: {
		const struct compat_43_netbsd32_ogethostname_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, hostname).i32; /* netbsd32_charp */
		uarg[1] = SCARG(p, len); /* u_int */
		*n_args = 2;
		break;
	}
	/* netbsd32_osethostname */
	case 88: {
		const struct compat_43_netbsd32_osethostname_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, hostname).i32; /* netbsd32_charp */
		uarg[1] = SCARG(p, len); /* u_int */
		*n_args = 2;
		break;
	}
	/* sys_getdtablesize */
	case 89: {
		*n_args = 0;
		break;
	}
	/* netbsd32_dup2 */
	case 90: {
		const struct netbsd32_dup2_args *p = params;
		iarg[0] = SCARG(p, from); /* int */
		iarg[1] = SCARG(p, to); /* int */
		*n_args = 2;
		break;
	}
	/* netbsd32_fcntl */
	case 92: {
		const struct netbsd32_fcntl_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, cmd); /* int */
		uarg[2] = (intptr_t) SCARG(p, arg).i32; /* netbsd32_voidp */
		*n_args = 3;
		break;
	}
	/* netbsd32_select */
	case 93: {
		const struct compat_50_netbsd32_select_args *p = params;
		iarg[0] = SCARG(p, nd); /* int */
		uarg[1] = (intptr_t) SCARG(p, in).i32; /* netbsd32_fd_setp_t */
		uarg[2] = (intptr_t) SCARG(p, ou).i32; /* netbsd32_fd_setp_t */
		uarg[3] = (intptr_t) SCARG(p, ex).i32; /* netbsd32_fd_setp_t */
		uarg[4] = (intptr_t) SCARG(p, tv).i32; /* netbsd32_timeval50p_t */
		*n_args = 5;
		break;
	}
	/* netbsd32_fsync */
	case 95: {
		const struct netbsd32_fsync_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* netbsd32_setpriority */
	case 96: {
		const struct netbsd32_setpriority_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		iarg[1] = SCARG(p, who); /* int */
		iarg[2] = SCARG(p, prio); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_socket */
	case 97: {
		const struct compat_30_netbsd32_socket_args *p = params;
		iarg[0] = SCARG(p, domain); /* int */
		iarg[1] = SCARG(p, type); /* int */
		iarg[2] = SCARG(p, protocol); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_connect */
	case 98: {
		const struct netbsd32_connect_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, name).i32; /* netbsd32_sockaddrp_t */
		iarg[2] = SCARG(p, namelen); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_oaccept */
	case 99: {
		const struct compat_43_netbsd32_oaccept_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, name).i32; /* netbsd32_voidp */
		uarg[2] = (intptr_t) SCARG(p, anamelen).i32; /* netbsd32_intp */
		*n_args = 3;
		break;
	}
	/* netbsd32_getpriority */
	case 100: {
		const struct netbsd32_getpriority_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		iarg[1] = SCARG(p, who); /* int */
		*n_args = 2;
		break;
	}
	/* netbsd32_osend */
	case 101: {
		const struct compat_43_netbsd32_osend_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_voidp */
		iarg[2] = SCARG(p, len); /* int */
		iarg[3] = SCARG(p, flags); /* int */
		*n_args = 4;
		break;
	}
	/* netbsd32_orecv */
	case 102: {
		const struct compat_43_netbsd32_orecv_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_voidp */
		iarg[2] = SCARG(p, len); /* int */
		iarg[3] = SCARG(p, flags); /* int */
		*n_args = 4;
		break;
	}
	/* netbsd32_sigreturn */
	case 103: {
		const struct compat_13_netbsd32_sigreturn_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, sigcntxp).i32; /* netbsd32_sigcontextp_t */
		*n_args = 1;
		break;
	}
	/* netbsd32_bind */
	case 104: {
		const struct netbsd32_bind_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, name).i32; /* netbsd32_sockaddrp_t */
		iarg[2] = SCARG(p, namelen); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_setsockopt */
	case 105: {
		const struct netbsd32_setsockopt_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		iarg[1] = SCARG(p, level); /* int */
		iarg[2] = SCARG(p, name); /* int */
		uarg[3] = (intptr_t) SCARG(p, val).i32; /* netbsd32_voidp */
		iarg[4] = SCARG(p, valsize); /* int */
		*n_args = 5;
		break;
	}
	/* netbsd32_listen */
	case 106: {
		const struct netbsd32_listen_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		iarg[1] = SCARG(p, backlog); /* int */
		*n_args = 2;
		break;
	}
	/* netbsd32_osigvec */
	case 108: {
		const struct compat_43_netbsd32_osigvec_args *p = params;
		iarg[0] = SCARG(p, signum); /* int */
		uarg[1] = (intptr_t) SCARG(p, nsv).i32; /* netbsd32_sigvecp_t */
		uarg[2] = (intptr_t) SCARG(p, osv).i32; /* netbsd32_sigvecp_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_sigblock */
	case 109: {
		const struct compat_43_netbsd32_sigblock_args *p = params;
		iarg[0] = SCARG(p, mask); /* int */
		*n_args = 1;
		break;
	}
	/* netbsd32_sigsetmask */
	case 110: {
		const struct compat_43_netbsd32_sigsetmask_args *p = params;
		iarg[0] = SCARG(p, mask); /* int */
		*n_args = 1;
		break;
	}
	/* netbsd32_sigsuspend */
	case 111: {
		const struct compat_13_netbsd32_sigsuspend_args *p = params;
		iarg[0] = SCARG(p, mask); /* int */
		*n_args = 1;
		break;
	}
	/* netbsd32_osigstack */
	case 112: {
		const struct compat_43_netbsd32_osigstack_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, nss).i32; /* netbsd32_sigstackp_t */
		uarg[1] = (intptr_t) SCARG(p, oss).i32; /* netbsd32_sigstackp_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_orecvmsg */
	case 113: {
		const struct compat_43_netbsd32_orecvmsg_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, msg).i32; /* netbsd32_omsghdrp_t */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_osendmsg */
	case 114: {
		const struct compat_43_netbsd32_osendmsg_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, msg).i32; /* netbsd32_voidp */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_gettimeofday */
	case 116: {
		const struct compat_50_netbsd32_gettimeofday_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, tp).i32; /* netbsd32_timeval50p_t */
		uarg[1] = (intptr_t) SCARG(p, tzp).i32; /* netbsd32_timezonep_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_getrusage */
	case 117: {
		const struct compat_50_netbsd32_getrusage_args *p = params;
		iarg[0] = SCARG(p, who); /* int */
		uarg[1] = (intptr_t) SCARG(p, rusage).i32; /* netbsd32_rusage50p_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_getsockopt */
	case 118: {
		const struct netbsd32_getsockopt_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		iarg[1] = SCARG(p, level); /* int */
		iarg[2] = SCARG(p, name); /* int */
		uarg[3] = (intptr_t) SCARG(p, val).i32; /* netbsd32_voidp */
		uarg[4] = (intptr_t) SCARG(p, avalsize).i32; /* netbsd32_intp */
		*n_args = 5;
		break;
	}
	/* netbsd32_readv */
	case 120: {
		const struct netbsd32_readv_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, iovp).i32; /* netbsd32_iovecp_t */
		iarg[2] = SCARG(p, iovcnt); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_writev */
	case 121: {
		const struct netbsd32_writev_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, iovp).i32; /* netbsd32_iovecp_t */
		iarg[2] = SCARG(p, iovcnt); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_settimeofday */
	case 122: {
		const struct compat_50_netbsd32_settimeofday_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, tv).i32; /* netbsd32_timeval50p_t */
		uarg[1] = (intptr_t) SCARG(p, tzp).i32; /* netbsd32_timezonep_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_fchown */
	case 123: {
		const struct netbsd32_fchown_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = SCARG(p, uid); /* uid_t */
		iarg[2] = SCARG(p, gid); /* gid_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_fchmod */
	case 124: {
		const struct netbsd32_fchmod_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, mode); /* mode_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_orecvfrom */
	case 125: {
		const struct compat_43_netbsd32_orecvfrom_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_voidp */
		iarg[2] = SCARG(p, len); /* netbsd32_size_t */
		iarg[3] = SCARG(p, flags); /* int */
		uarg[4] = (intptr_t) SCARG(p, from).i32; /* netbsd32_voidp */
		uarg[5] = (intptr_t) SCARG(p, fromlenaddr).i32; /* netbsd32_intp */
		*n_args = 6;
		break;
	}
	/* netbsd32_setreuid */
	case 126: {
		const struct netbsd32_setreuid_args *p = params;
		uarg[0] = SCARG(p, ruid); /* uid_t */
		uarg[1] = SCARG(p, euid); /* uid_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_setregid */
	case 127: {
		const struct netbsd32_setregid_args *p = params;
		iarg[0] = SCARG(p, rgid); /* gid_t */
		iarg[1] = SCARG(p, egid); /* gid_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_rename */
	case 128: {
		const struct netbsd32_rename_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, from).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, to).i32; /* netbsd32_charp */
		*n_args = 2;
		break;
	}
	/* netbsd32_otruncate */
	case 129: {
		const struct compat_43_netbsd32_otruncate_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, length); /* netbsd32_long */
		*n_args = 2;
		break;
	}
	/* netbsd32_oftruncate */
	case 130: {
		const struct compat_43_netbsd32_oftruncate_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, length); /* netbsd32_long */
		*n_args = 2;
		break;
	}
	/* netbsd32_flock */
	case 131: {
		const struct netbsd32_flock_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, how); /* int */
		*n_args = 2;
		break;
	}
	/* netbsd32_mkfifo */
	case 132: {
		const struct netbsd32_mkfifo_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, mode); /* mode_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_sendto */
	case 133: {
		const struct netbsd32_sendto_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_voidp */
		iarg[2] = SCARG(p, len); /* netbsd32_size_t */
		iarg[3] = SCARG(p, flags); /* int */
		uarg[4] = (intptr_t) SCARG(p, to).i32; /* netbsd32_sockaddrp_t */
		iarg[5] = SCARG(p, tolen); /* int */
		*n_args = 6;
		break;
	}
	/* netbsd32_shutdown */
	case 134: {
		const struct netbsd32_shutdown_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		iarg[1] = SCARG(p, how); /* int */
		*n_args = 2;
		break;
	}
	/* netbsd32_socketpair */
	case 135: {
		const struct netbsd32_socketpair_args *p = params;
		iarg[0] = SCARG(p, domain); /* int */
		iarg[1] = SCARG(p, type); /* int */
		iarg[2] = SCARG(p, protocol); /* int */
		uarg[3] = (intptr_t) SCARG(p, rsv).i32; /* netbsd32_intp */
		*n_args = 4;
		break;
	}
	/* netbsd32_mkdir */
	case 136: {
		const struct netbsd32_mkdir_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, mode); /* mode_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_rmdir */
	case 137: {
		const struct netbsd32_rmdir_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		*n_args = 1;
		break;
	}
	/* netbsd32_utimes */
	case 138: {
		const struct compat_50_netbsd32_utimes_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, tptr).i32; /* netbsd32_timeval50p_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_adjtime */
	case 140: {
		const struct compat_50_netbsd32_adjtime_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, delta).i32; /* netbsd32_timeval50p_t */
		uarg[1] = (intptr_t) SCARG(p, olddelta).i32; /* netbsd32_timeval50p_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_ogetpeername */
	case 141: {
		const struct compat_43_netbsd32_ogetpeername_args *p = params;
		iarg[0] = SCARG(p, fdes); /* int */
		uarg[1] = (intptr_t) SCARG(p, asa).i32; /* netbsd32_voidp */
		uarg[2] = (intptr_t) SCARG(p, alen).i32; /* netbsd32_intp */
		*n_args = 3;
		break;
	}
	/* sys_gethostid */
	case 142: {
		*n_args = 0;
		break;
	}
	/* netbsd32_sethostid */
	case 143: {
		const struct compat_43_netbsd32_sethostid_args *p = params;
		iarg[0] = SCARG(p, hostid); /* int32_t */
		*n_args = 1;
		break;
	}
	/* netbsd32_ogetrlimit */
	case 144: {
		const struct compat_43_netbsd32_ogetrlimit_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		uarg[1] = (intptr_t) SCARG(p, rlp).i32; /* netbsd32_orlimitp_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_osetrlimit */
	case 145: {
		const struct compat_43_netbsd32_osetrlimit_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		uarg[1] = (intptr_t) SCARG(p, rlp).i32; /* netbsd32_orlimitp_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_killpg */
	case 146: {
		const struct compat_43_netbsd32_killpg_args *p = params;
		iarg[0] = SCARG(p, pgid); /* int */
		iarg[1] = SCARG(p, signum); /* int */
		*n_args = 2;
		break;
	}
	/* sys_setsid */
	case 147: {
		*n_args = 0;
		break;
	}
#if defined(QUOTA) || !defined(_KERNEL_OPT)
	/* netbsd32_quotactl */
	case 148: {
		const struct compat_50_netbsd32_quotactl_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, cmd); /* int */
		iarg[2] = SCARG(p, uid); /* int */
		uarg[3] = (intptr_t) SCARG(p, arg).i32; /* netbsd32_voidp */
		*n_args = 4;
		break;
	}
#else
#endif
	/* netbsd32_ogetsockname */
	case 150: {
		const struct compat_43_netbsd32_ogetsockname_args *p = params;
		iarg[0] = SCARG(p, fdec); /* int */
		uarg[1] = (intptr_t) SCARG(p, asa).i32; /* netbsd32_voidp */
		uarg[2] = (intptr_t) SCARG(p, alen).i32; /* netbsd32_intp */
		*n_args = 3;
		break;
	}
	/* netbsd32_nfssvc */
	case 155: {
		const struct netbsd32_nfssvc_args *p = params;
		iarg[0] = SCARG(p, flag); /* int */
		uarg[1] = (intptr_t) SCARG(p, argp).i32; /* netbsd32_voidp */
		*n_args = 2;
		break;
	}
	/* netbsd32_ogetdirentries */
	case 156: {
		const struct compat_43_netbsd32_ogetdirentries_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_charp */
		uarg[2] = SCARG(p, count); /* u_int */
		uarg[3] = (intptr_t) SCARG(p, basep).i32; /* netbsd32_longp */
		*n_args = 4;
		break;
	}
	/* netbsd32_statfs */
	case 157: {
		const struct compat_20_netbsd32_statfs_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_statfsp_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_fstatfs */
	case 158: {
		const struct compat_20_netbsd32_fstatfs_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_statfsp_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_getfh */
	case 161: {
		const struct compat_30_netbsd32_getfh_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fname).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, fhp).i32; /* netbsd32_compat_30_fhandlep_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_ogetdomainname */
	case 162: {
		const struct compat_09_netbsd32_ogetdomainname_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, domainname).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, len); /* int */
		*n_args = 2;
		break;
	}
	/* netbsd32_osetdomainname */
	case 163: {
		const struct compat_09_netbsd32_osetdomainname_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, domainname).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, len); /* int */
		*n_args = 2;
		break;
	}
	/* netbsd32_uname */
	case 164: {
		const struct compat_09_netbsd32_uname_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, name).i32; /* netbsd32_outsnamep_t */
		*n_args = 1;
		break;
	}
	/* netbsd32_sysarch */
	case 165: {
		const struct netbsd32_sysarch_args *p = params;
		iarg[0] = SCARG(p, op); /* int */
		uarg[1] = (intptr_t) SCARG(p, parms).i32; /* netbsd32_voidp */
		*n_args = 2;
		break;
	}
	/* netbsd32_semsys */
	case 169: {
		const struct compat_10_netbsd32_semsys_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		iarg[1] = SCARG(p, a2); /* int */
		iarg[2] = SCARG(p, a3); /* int */
		iarg[3] = SCARG(p, a4); /* int */
		iarg[4] = SCARG(p, a5); /* int */
		*n_args = 5;
		break;
	}
	/* netbsd32_msgsys */
	case 170: {
		const struct compat_10_netbsd32_msgsys_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		iarg[1] = SCARG(p, a2); /* int */
		iarg[2] = SCARG(p, a3); /* int */
		iarg[3] = SCARG(p, a4); /* int */
		iarg[4] = SCARG(p, a5); /* int */
		iarg[5] = SCARG(p, a6); /* int */
		*n_args = 6;
		break;
	}
	/* netbsd32_shmsys */
	case 171: {
		const struct compat_10_netbsd32_shmsys_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		iarg[1] = SCARG(p, a2); /* int */
		iarg[2] = SCARG(p, a3); /* int */
		iarg[3] = SCARG(p, a4); /* int */
		*n_args = 4;
		break;
	}
	/* netbsd32_pread */
	case 173: {
		const struct netbsd32_pread_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_voidp */
		iarg[2] = SCARG(p, nbyte); /* netbsd32_size_t */
		iarg[3] = SCARG(p, PAD); /* int */
		iarg[4] = SCARG(p, offset); /* netbsd32_off_t */
		*n_args = 5;
		break;
	}
	/* netbsd32_pwrite */
	case 174: {
		const struct netbsd32_pwrite_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_voidp */
		iarg[2] = SCARG(p, nbyte); /* netbsd32_size_t */
		iarg[3] = SCARG(p, PAD); /* int */
		iarg[4] = SCARG(p, offset); /* netbsd32_off_t */
		*n_args = 5;
		break;
	}
	/* netbsd32_ntp_gettime */
	case 175: {
		const struct compat_30_netbsd32_ntp_gettime_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, ntvp).i32; /* netbsd32_ntptimeval50p_t */
		*n_args = 1;
		break;
	}
#if defined(NTP) || !defined(_KERNEL_OPT)
	/* netbsd32_ntp_adjtime */
	case 176: {
		const struct netbsd32_ntp_adjtime_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, tp).i32; /* netbsd32_timexp_t */
		*n_args = 1;
		break;
	}
#else
#endif
	/* netbsd32_setgid */
	case 181: {
		const struct netbsd32_setgid_args *p = params;
		iarg[0] = SCARG(p, gid); /* gid_t */
		*n_args = 1;
		break;
	}
	/* netbsd32_setegid */
	case 182: {
		const struct netbsd32_setegid_args *p = params;
		iarg[0] = SCARG(p, egid); /* gid_t */
		*n_args = 1;
		break;
	}
	/* netbsd32_seteuid */
	case 183: {
		const struct netbsd32_seteuid_args *p = params;
		uarg[0] = SCARG(p, euid); /* uid_t */
		*n_args = 1;
		break;
	}
	/* netbsd32_stat12 */
	case 188: {
		const struct compat_12_netbsd32_stat12_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, ub).i32; /* netbsd32_stat12p_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_fstat12 */
	case 189: {
		const struct compat_12_netbsd32_fstat12_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, sb).i32; /* netbsd32_stat12p_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_lstat12 */
	case 190: {
		const struct compat_12_netbsd32_lstat12_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, ub).i32; /* netbsd32_stat12p_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_pathconf */
	case 191: {
		const struct netbsd32_pathconf_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, name); /* int */
		*n_args = 2;
		break;
	}
	/* netbsd32_fpathconf */
	case 192: {
		const struct netbsd32_fpathconf_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, name); /* int */
		*n_args = 2;
		break;
	}
	/* netbsd32_getsockopt2 */
	case 193: {
		const struct netbsd32_getsockopt2_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		iarg[1] = SCARG(p, level); /* int */
		iarg[2] = SCARG(p, name); /* int */
		uarg[3] = (intptr_t) SCARG(p, val).i32; /* netbsd32_voidp */
		uarg[4] = (intptr_t) SCARG(p, avalsize).i32; /* netbsd32_intp */
		*n_args = 5;
		break;
	}
	/* netbsd32_getrlimit */
	case 194: {
		const struct netbsd32_getrlimit_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		uarg[1] = (intptr_t) SCARG(p, rlp).i32; /* netbsd32_rlimitp_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_setrlimit */
	case 195: {
		const struct netbsd32_setrlimit_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		uarg[1] = (intptr_t) SCARG(p, rlp).i32; /* netbsd32_rlimitp_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_getdirentries */
	case 196: {
		const struct compat_12_netbsd32_getdirentries_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_charp */
		uarg[2] = SCARG(p, count); /* u_int */
		uarg[3] = (intptr_t) SCARG(p, basep).i32; /* netbsd32_longp */
		*n_args = 4;
		break;
	}
	/* netbsd32_mmap */
	case 197: {
		const struct netbsd32_mmap_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr).i32; /* netbsd32_voidp */
		iarg[1] = SCARG(p, len); /* netbsd32_size_t */
		iarg[2] = SCARG(p, prot); /* int */
		iarg[3] = SCARG(p, flags); /* int */
		iarg[4] = SCARG(p, fd); /* int */
		iarg[5] = SCARG(p, PAD); /* netbsd32_long */
		iarg[6] = SCARG(p, pos); /* netbsd32_off_t */
		*n_args = 7;
		break;
	}
	/* netbsd32____syscall */
	case 198: {
		const struct netbsd32____syscall_args *p = params;
		iarg[0] = SCARG(p, code); /* quad_t */
		iarg[1] = SCARG(p, args[NETBSD32_SYS_MAXSYSARGS]); /* register32_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_lseek */
	case 199: {
		const struct netbsd32_lseek_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, PAD); /* int */
		iarg[2] = SCARG(p, offset); /* netbsd32_off_t */
		iarg[3] = SCARG(p, whence); /* int */
		*n_args = 4;
		break;
	}
	/* netbsd32_truncate */
	case 200: {
		const struct netbsd32_truncate_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, PAD); /* int */
		iarg[2] = SCARG(p, length); /* netbsd32_off_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_ftruncate */
	case 201: {
		const struct netbsd32_ftruncate_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, PAD); /* int */
		iarg[2] = SCARG(p, length); /* netbsd32_off_t */
		*n_args = 3;
		break;
	}
	/* netbsd32___sysctl */
	case 202: {
		const struct netbsd32___sysctl_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, name).i32; /* netbsd32_intp */
		uarg[1] = SCARG(p, namelen); /* u_int */
		uarg[2] = (intptr_t) SCARG(p, oldv).i32; /* netbsd32_voidp */
		uarg[3] = (intptr_t) SCARG(p, oldlenp).i32; /* netbsd32_size_tp */
		uarg[4] = (intptr_t) SCARG(p, newv).i32; /* netbsd32_voidp */
		iarg[5] = SCARG(p, newlen); /* netbsd32_size_t */
		*n_args = 6;
		break;
	}
	/* netbsd32_mlock */
	case 203: {
		const struct netbsd32_mlock_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr).i32; /* netbsd32_voidp */
		iarg[1] = SCARG(p, len); /* netbsd32_size_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_munlock */
	case 204: {
		const struct netbsd32_munlock_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr).i32; /* netbsd32_voidp */
		iarg[1] = SCARG(p, len); /* netbsd32_size_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_undelete */
	case 205: {
		const struct netbsd32_undelete_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		*n_args = 1;
		break;
	}
	/* netbsd32_futimes */
	case 206: {
		const struct compat_50_netbsd32_futimes_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, tptr).i32; /* netbsd32_timeval50p_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_getpgid */
	case 207: {
		const struct netbsd32_getpgid_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		*n_args = 1;
		break;
	}
	/* netbsd32_reboot */
	case 208: {
		const struct netbsd32_reboot_args *p = params;
		iarg[0] = SCARG(p, opt); /* int */
		uarg[1] = (intptr_t) SCARG(p, bootstr).i32; /* netbsd32_charp */
		*n_args = 2;
		break;
	}
	/* netbsd32_poll */
	case 209: {
		const struct netbsd32_poll_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fds).i32; /* netbsd32_pollfdp_t */
		uarg[1] = SCARG(p, nfds); /* u_int */
		iarg[2] = SCARG(p, timeout); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32___semctl */
	case 220: {
		const struct compat_14_netbsd32___semctl_args *p = params;
		iarg[0] = SCARG(p, semid); /* int */
		iarg[1] = SCARG(p, semnum); /* int */
		iarg[2] = SCARG(p, cmd); /* int */
		iarg[3] = SCARG(p, arg); /* netbsd32_semunu_t */
		*n_args = 4;
		break;
	}
	/* netbsd32_semget */
	case 221: {
		const struct netbsd32_semget_args *p = params;
		iarg[0] = SCARG(p, key); /* netbsd32_key_t */
		iarg[1] = SCARG(p, nsems); /* int */
		iarg[2] = SCARG(p, semflg); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_semop */
	case 222: {
		const struct netbsd32_semop_args *p = params;
		iarg[0] = SCARG(p, semid); /* int */
		uarg[1] = (intptr_t) SCARG(p, sops).i32; /* netbsd32_sembufp_t */
		iarg[2] = SCARG(p, nsops); /* netbsd32_size_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_semconfig */
	case 223: {
		const struct netbsd32_semconfig_args *p = params;
		iarg[0] = SCARG(p, flag); /* int */
		*n_args = 1;
		break;
	}
	/* netbsd32_msgctl */
	case 224: {
		const struct compat_14_netbsd32_msgctl_args *p = params;
		iarg[0] = SCARG(p, msqid); /* int */
		iarg[1] = SCARG(p, cmd); /* int */
		uarg[2] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_msqid_ds14p_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_msgget */
	case 225: {
		const struct netbsd32_msgget_args *p = params;
		iarg[0] = SCARG(p, key); /* netbsd32_key_t */
		iarg[1] = SCARG(p, msgflg); /* int */
		*n_args = 2;
		break;
	}
	/* netbsd32_msgsnd */
	case 226: {
		const struct netbsd32_msgsnd_args *p = params;
		iarg[0] = SCARG(p, msqid); /* int */
		uarg[1] = (intptr_t) SCARG(p, msgp).i32; /* netbsd32_voidp */
		iarg[2] = SCARG(p, msgsz); /* netbsd32_size_t */
		iarg[3] = SCARG(p, msgflg); /* int */
		*n_args = 4;
		break;
	}
	/* netbsd32_msgrcv */
	case 227: {
		const struct netbsd32_msgrcv_args *p = params;
		iarg[0] = SCARG(p, msqid); /* int */
		uarg[1] = (intptr_t) SCARG(p, msgp).i32; /* netbsd32_voidp */
		iarg[2] = SCARG(p, msgsz); /* netbsd32_size_t */
		iarg[3] = SCARG(p, msgtyp); /* netbsd32_long */
		iarg[4] = SCARG(p, msgflg); /* int */
		*n_args = 5;
		break;
	}
	/* netbsd32_shmat */
	case 228: {
		const struct netbsd32_shmat_args *p = params;
		iarg[0] = SCARG(p, shmid); /* int */
		uarg[1] = (intptr_t) SCARG(p, shmaddr).i32; /* netbsd32_voidp */
		iarg[2] = SCARG(p, shmflg); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_shmctl */
	case 229: {
		const struct compat_14_netbsd32_shmctl_args *p = params;
		iarg[0] = SCARG(p, shmid); /* int */
		iarg[1] = SCARG(p, cmd); /* int */
		uarg[2] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_shmid_dsp_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_shmdt */
	case 230: {
		const struct netbsd32_shmdt_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, shmaddr).i32; /* netbsd32_voidp */
		*n_args = 1;
		break;
	}
	/* netbsd32_shmget */
	case 231: {
		const struct netbsd32_shmget_args *p = params;
		iarg[0] = SCARG(p, key); /* netbsd32_key_t */
		iarg[1] = SCARG(p, size); /* netbsd32_size_t */
		iarg[2] = SCARG(p, shmflg); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_clock_gettime */
	case 232: {
		const struct compat_50_netbsd32_clock_gettime_args *p = params;
		iarg[0] = SCARG(p, clock_id); /* netbsd32_clockid_t */
		uarg[1] = (intptr_t) SCARG(p, tp).i32; /* netbsd32_timespec50p_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_clock_settime */
	case 233: {
		const struct compat_50_netbsd32_clock_settime_args *p = params;
		iarg[0] = SCARG(p, clock_id); /* netbsd32_clockid_t */
		uarg[1] = (intptr_t) SCARG(p, tp).i32; /* netbsd32_timespec50p_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_clock_getres */
	case 234: {
		const struct compat_50_netbsd32_clock_getres_args *p = params;
		iarg[0] = SCARG(p, clock_id); /* netbsd32_clockid_t */
		uarg[1] = (intptr_t) SCARG(p, tp).i32; /* netbsd32_timespec50p_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_timer_create */
	case 235: {
		const struct netbsd32_timer_create_args *p = params;
		iarg[0] = SCARG(p, clock_id); /* netbsd32_clockid_t */
		uarg[1] = (intptr_t) SCARG(p, evp).i32; /* netbsd32_sigeventp_t */
		uarg[2] = (intptr_t) SCARG(p, timerid).i32; /* netbsd32_timerp_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_timer_delete */
	case 236: {
		const struct netbsd32_timer_delete_args *p = params;
		iarg[0] = SCARG(p, timerid); /* netbsd32_timer_t */
		*n_args = 1;
		break;
	}
	/* netbsd32_timer_settime */
	case 237: {
		const struct compat_50_netbsd32_timer_settime_args *p = params;
		iarg[0] = SCARG(p, timerid); /* netbsd32_timer_t */
		iarg[1] = SCARG(p, flags); /* int */
		uarg[2] = (intptr_t) SCARG(p, value).i32; /* netbsd32_itimerspec50p_t */
		uarg[3] = (intptr_t) SCARG(p, ovalue).i32; /* netbsd32_itimerspec50p_t */
		*n_args = 4;
		break;
	}
	/* netbsd32_timer_gettime */
	case 238: {
		const struct compat_50_netbsd32_timer_gettime_args *p = params;
		iarg[0] = SCARG(p, timerid); /* netbsd32_timer_t */
		uarg[1] = (intptr_t) SCARG(p, value).i32; /* netbsd32_itimerspec50p_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_timer_getoverrun */
	case 239: {
		const struct netbsd32_timer_getoverrun_args *p = params;
		iarg[0] = SCARG(p, timerid); /* netbsd32_timer_t */
		*n_args = 1;
		break;
	}
	/* netbsd32_nanosleep */
	case 240: {
		const struct compat_50_netbsd32_nanosleep_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, rqtp).i32; /* netbsd32_timespec50p_t */
		uarg[1] = (intptr_t) SCARG(p, rmtp).i32; /* netbsd32_timespec50p_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_fdatasync */
	case 241: {
		const struct netbsd32_fdatasync_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* netbsd32_mlockall */
	case 242: {
		const struct netbsd32_mlockall_args *p = params;
		iarg[0] = SCARG(p, flags); /* int */
		*n_args = 1;
		break;
	}
	/* sys_munlockall */
	case 243: {
		*n_args = 0;
		break;
	}
	/* netbsd32___sigtimedwait */
	case 244: {
		const struct compat_50_netbsd32___sigtimedwait_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, set).i32; /* netbsd32_sigsetp_t */
		uarg[1] = (intptr_t) SCARG(p, info).i32; /* netbsd32_siginfop_t */
		uarg[2] = (intptr_t) SCARG(p, timeout).i32; /* netbsd32_timespec50p_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_sigqueueinfo */
	case 245: {
		const struct netbsd32_sigqueueinfo_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		uarg[1] = (intptr_t) SCARG(p, info).i32; /* const netbsd32_siginfop_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_modctl */
	case 246: {
		const struct netbsd32_modctl_args *p = params;
		iarg[0] = SCARG(p, cmd); /* int */
		uarg[1] = (intptr_t) SCARG(p, arg).i32; /* netbsd32_voidp */
		*n_args = 2;
		break;
	}
	/* netbsd32__ksem_init */
	case 247: {
		const struct netbsd32__ksem_init_args *p = params;
		uarg[0] = SCARG(p, value); /* unsigned int */
		uarg[1] = (intptr_t) SCARG(p, idp).i32; /* netbsd32_semidp_t */
		*n_args = 2;
		break;
	}
	/* netbsd32__ksem_open */
	case 248: {
		const struct netbsd32__ksem_open_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, name).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, oflag); /* int */
		iarg[2] = SCARG(p, mode); /* mode_t */
		uarg[3] = SCARG(p, value); /* unsigned int */
		uarg[4] = (intptr_t) SCARG(p, idp).i32; /* netbsd32_semidp_t */
		*n_args = 5;
		break;
	}
	/* netbsd32__ksem_unlink */
	case 249: {
		const struct netbsd32__ksem_unlink_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, name).i32; /* netbsd32_charp */
		*n_args = 1;
		break;
	}
	/* netbsd32__ksem_close */
	case 250: {
		const struct netbsd32__ksem_close_args *p = params;
		iarg[0] = SCARG(p, id); /* netbsd32_intptr_t */
		*n_args = 1;
		break;
	}
	/* netbsd32__ksem_post */
	case 251: {
		const struct netbsd32__ksem_post_args *p = params;
		iarg[0] = SCARG(p, id); /* netbsd32_intptr_t */
		*n_args = 1;
		break;
	}
	/* netbsd32__ksem_wait */
	case 252: {
		const struct netbsd32__ksem_wait_args *p = params;
		iarg[0] = SCARG(p, id); /* netbsd32_intptr_t */
		*n_args = 1;
		break;
	}
	/* netbsd32__ksem_trywait */
	case 253: {
		const struct netbsd32__ksem_trywait_args *p = params;
		iarg[0] = SCARG(p, id); /* netbsd32_intptr_t */
		*n_args = 1;
		break;
	}
	/* netbsd32__ksem_getvalue */
	case 254: {
		const struct netbsd32__ksem_getvalue_args *p = params;
		iarg[0] = SCARG(p, id); /* netbsd32_intptr_t */
		uarg[1] = (intptr_t) SCARG(p, value).i32; /* netbsd32_intp */
		*n_args = 2;
		break;
	}
	/* netbsd32__ksem_destroy */
	case 255: {
		const struct netbsd32__ksem_destroy_args *p = params;
		iarg[0] = SCARG(p, id); /* netbsd32_intptr_t */
		*n_args = 1;
		break;
	}
	/* netbsd32__ksem_timedwait */
	case 256: {
		const struct netbsd32__ksem_timedwait_args *p = params;
		iarg[0] = SCARG(p, id); /* intptr_t */
		uarg[1] = (intptr_t) SCARG(p, abstime).i32; /* const netbsd32_timespecp_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_mq_open */
	case 257: {
		const struct netbsd32_mq_open_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, name).i32; /* const netbsd32_charp */
		iarg[1] = SCARG(p, oflag); /* int */
		iarg[2] = SCARG(p, mode); /* mode_t */
		uarg[3] = (intptr_t) SCARG(p, attr).i32; /* netbsd32_mq_attrp_t */
		*n_args = 4;
		break;
	}
	/* netbsd32_mq_close */
	case 258: {
		const struct netbsd32_mq_close_args *p = params;
		iarg[0] = SCARG(p, mqdes); /* mqd_t */
		*n_args = 1;
		break;
	}
	/* netbsd32_mq_unlink */
	case 259: {
		const struct netbsd32_mq_unlink_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, name).i32; /* const netbsd32_charp */
		*n_args = 1;
		break;
	}
	/* netbsd32_mq_getattr */
	case 260: {
		const struct netbsd32_mq_getattr_args *p = params;
		iarg[0] = SCARG(p, mqdes); /* mqd_t */
		uarg[1] = (intptr_t) SCARG(p, mqstat).i32; /* netbsd32_mq_attrp_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_mq_setattr */
	case 261: {
		const struct netbsd32_mq_setattr_args *p = params;
		iarg[0] = SCARG(p, mqdes); /* mqd_t */
		uarg[1] = (intptr_t) SCARG(p, mqstat).i32; /* const netbsd32_mq_attrp_t */
		uarg[2] = (intptr_t) SCARG(p, omqstat).i32; /* netbsd32_mq_attrp_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_mq_notify */
	case 262: {
		const struct netbsd32_mq_notify_args *p = params;
		iarg[0] = SCARG(p, mqdes); /* mqd_t */
		uarg[1] = (intptr_t) SCARG(p, notification).i32; /* const netbsd32_sigeventp_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_mq_send */
	case 263: {
		const struct netbsd32_mq_send_args *p = params;
		iarg[0] = SCARG(p, mqdes); /* mqd_t */
		uarg[1] = (intptr_t) SCARG(p, msg_ptr).i32; /* const netbsd32_charp */
		iarg[2] = SCARG(p, msg_len); /* netbsd32_size_t */
		uarg[3] = SCARG(p, msg_prio); /* unsigned */
		*n_args = 4;
		break;
	}
	/* netbsd32_mq_receive */
	case 264: {
		const struct netbsd32_mq_receive_args *p = params;
		iarg[0] = SCARG(p, mqdes); /* mqd_t */
		uarg[1] = (intptr_t) SCARG(p, msg_ptr).i32; /* netbsd32_charp */
		iarg[2] = SCARG(p, msg_len); /* netbsd32_size_t */
		uarg[3] = (intptr_t) SCARG(p, msg_prio).i32; /* netbsd32_uintp */
		*n_args = 4;
		break;
	}
	/* netbsd32_mq_timedsend */
	case 265: {
		const struct compat_50_netbsd32_mq_timedsend_args *p = params;
		iarg[0] = SCARG(p, mqdes); /* mqd_t */
		uarg[1] = (intptr_t) SCARG(p, msg_ptr).i32; /* const netbsd32_charp */
		iarg[2] = SCARG(p, msg_len); /* netbsd32_size_t */
		uarg[3] = SCARG(p, msg_prio); /* unsigned */
		uarg[4] = (intptr_t) SCARG(p, abs_timeout).i32; /* const netbsd32_timespec50p_t */
		*n_args = 5;
		break;
	}
	/* netbsd32_mq_timedreceive */
	case 266: {
		const struct compat_50_netbsd32_mq_timedreceive_args *p = params;
		iarg[0] = SCARG(p, mqdes); /* mqd_t */
		uarg[1] = (intptr_t) SCARG(p, msg_ptr).i32; /* netbsd32_charp */
		iarg[2] = SCARG(p, msg_len); /* netbsd32_size_t */
		uarg[3] = (intptr_t) SCARG(p, msg_prio).i32; /* netbsd32_uintp */
		uarg[4] = (intptr_t) SCARG(p, abs_timeout).i32; /* const netbsd32_timespec50p_t */
		*n_args = 5;
		break;
	}
	/* netbsd32___posix_rename */
	case 270: {
		const struct netbsd32___posix_rename_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, from).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, to).i32; /* netbsd32_charp */
		*n_args = 2;
		break;
	}
	/* netbsd32_swapctl */
	case 271: {
		const struct netbsd32_swapctl_args *p = params;
		iarg[0] = SCARG(p, cmd); /* int */
		uarg[1] = (intptr_t) SCARG(p, arg).i32; /* netbsd32_voidp */
		iarg[2] = SCARG(p, misc); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_getdents */
	case 272: {
		const struct compat_30_netbsd32_getdents_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_charp */
		iarg[2] = SCARG(p, count); /* netbsd32_size_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_minherit */
	case 273: {
		const struct netbsd32_minherit_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr).i32; /* netbsd32_voidp */
		iarg[1] = SCARG(p, len); /* netbsd32_size_t */
		iarg[2] = SCARG(p, inherit); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_lchmod */
	case 274: {
		const struct netbsd32_lchmod_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, mode); /* mode_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_lchown */
	case 275: {
		const struct netbsd32_lchown_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = SCARG(p, uid); /* uid_t */
		iarg[2] = SCARG(p, gid); /* gid_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_lutimes */
	case 276: {
		const struct compat_50_netbsd32_lutimes_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, tptr).i32; /* netbsd32_timeval50p_t */
		*n_args = 2;
		break;
	}
	/* netbsd32___msync13 */
	case 277: {
		const struct netbsd32___msync13_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr).i32; /* netbsd32_voidp */
		iarg[1] = SCARG(p, len); /* netbsd32_size_t */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32___stat13 */
	case 278: {
		const struct compat_30_netbsd32___stat13_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, ub).i32; /* netbsd32_stat13p_t */
		*n_args = 2;
		break;
	}
	/* netbsd32___fstat13 */
	case 279: {
		const struct compat_30_netbsd32___fstat13_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, sb).i32; /* netbsd32_stat13p_t */
		*n_args = 2;
		break;
	}
	/* netbsd32___lstat13 */
	case 280: {
		const struct compat_30_netbsd32___lstat13_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, ub).i32; /* netbsd32_stat13p_t */
		*n_args = 2;
		break;
	}
	/* netbsd32___sigaltstack14 */
	case 281: {
		const struct netbsd32___sigaltstack14_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, nss).i32; /* netbsd32_sigaltstackp_t */
		uarg[1] = (intptr_t) SCARG(p, oss).i32; /* netbsd32_sigaltstackp_t */
		*n_args = 2;
		break;
	}
	/* sys___vfork14 */
	case 282: {
		*n_args = 0;
		break;
	}
	/* netbsd32___posix_chown */
	case 283: {
		const struct netbsd32___posix_chown_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = SCARG(p, uid); /* uid_t */
		iarg[2] = SCARG(p, gid); /* gid_t */
		*n_args = 3;
		break;
	}
	/* netbsd32___posix_fchown */
	case 284: {
		const struct netbsd32___posix_fchown_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = SCARG(p, uid); /* uid_t */
		iarg[2] = SCARG(p, gid); /* gid_t */
		*n_args = 3;
		break;
	}
	/* netbsd32___posix_lchown */
	case 285: {
		const struct netbsd32___posix_lchown_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = SCARG(p, uid); /* uid_t */
		iarg[2] = SCARG(p, gid); /* gid_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_getsid */
	case 286: {
		const struct netbsd32_getsid_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		*n_args = 1;
		break;
	}
	/* netbsd32___clone */
	case 287: {
		const struct netbsd32___clone_args *p = params;
		iarg[0] = SCARG(p, flags); /* int */
		uarg[1] = (intptr_t) SCARG(p, stack).i32; /* netbsd32_voidp */
		*n_args = 2;
		break;
	}
	/* netbsd32_fktrace */
	case 288: {
		const struct netbsd32_fktrace_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, ops); /* int */
		iarg[2] = SCARG(p, facs); /* int */
		iarg[3] = SCARG(p, pid); /* int */
		*n_args = 4;
		break;
	}
	/* netbsd32_preadv */
	case 289: {
		const struct netbsd32_preadv_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, iovp).i32; /* netbsd32_iovecp_t */
		iarg[2] = SCARG(p, iovcnt); /* int */
		iarg[3] = SCARG(p, PAD); /* int */
		iarg[4] = SCARG(p, offset); /* netbsd32_off_t */
		*n_args = 5;
		break;
	}
	/* netbsd32_pwritev */
	case 290: {
		const struct netbsd32_pwritev_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, iovp).i32; /* netbsd32_iovecp_t */
		iarg[2] = SCARG(p, iovcnt); /* int */
		iarg[3] = SCARG(p, PAD); /* int */
		iarg[4] = SCARG(p, offset); /* netbsd32_off_t */
		*n_args = 5;
		break;
	}
	/* netbsd32___sigaction14 */
	case 291: {
		const struct netbsd32___sigaction14_args *p = params;
		iarg[0] = SCARG(p, signum); /* int */
		uarg[1] = (intptr_t) SCARG(p, nsa).i32; /* netbsd32_sigactionp_t */
		uarg[2] = (intptr_t) SCARG(p, osa).i32; /* netbsd32_sigactionp_t */
		*n_args = 3;
		break;
	}
	/* netbsd32___sigpending14 */
	case 292: {
		const struct netbsd32___sigpending14_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, set).i32; /* netbsd32_sigsetp_t */
		*n_args = 1;
		break;
	}
	/* netbsd32___sigprocmask14 */
	case 293: {
		const struct netbsd32___sigprocmask14_args *p = params;
		iarg[0] = SCARG(p, how); /* int */
		uarg[1] = (intptr_t) SCARG(p, set).i32; /* netbsd32_sigsetp_t */
		uarg[2] = (intptr_t) SCARG(p, oset).i32; /* netbsd32_sigsetp_t */
		*n_args = 3;
		break;
	}
	/* netbsd32___sigsuspend14 */
	case 294: {
		const struct netbsd32___sigsuspend14_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, set).i32; /* netbsd32_sigsetp_t */
		*n_args = 1;
		break;
	}
	/* netbsd32___sigreturn14 */
	case 295: {
		const struct compat_16_netbsd32___sigreturn14_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, sigcntxp).i32; /* netbsd32_sigcontextp_t */
		*n_args = 1;
		break;
	}
	/* netbsd32___getcwd */
	case 296: {
		const struct netbsd32___getcwd_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, bufp).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, length); /* netbsd32_size_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_fchroot */
	case 297: {
		const struct netbsd32_fchroot_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* netbsd32_fhopen */
	case 298: {
		const struct compat_30_netbsd32_fhopen_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fhp).i32; /* netbsd32_fhandlep_t */
		iarg[1] = SCARG(p, flags); /* int */
		*n_args = 2;
		break;
	}
	/* netbsd32_fhstat */
	case 299: {
		const struct compat_30_netbsd32_fhstat_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fhp).i32; /* netbsd32_fhandlep_t */
		uarg[1] = (intptr_t) SCARG(p, sb).i32; /* netbsd32_stat13p_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_fhstatfs */
	case 300: {
		const struct compat_20_netbsd32_fhstatfs_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fhp).i32; /* netbsd32_fhandlep_t */
		uarg[1] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_stat50p_t */
		*n_args = 2;
		break;
	}
	/* netbsd32___semctl14 */
	case 301: {
		const struct compat_50_netbsd32___semctl14_args *p = params;
		iarg[0] = SCARG(p, semid); /* int */
		iarg[1] = SCARG(p, semnum); /* int */
		iarg[2] = SCARG(p, cmd); /* int */
		uarg[3] = (intptr_t) SCARG(p, arg).i32; /* netbsd32_semun50p_t */
		*n_args = 4;
		break;
	}
	/* netbsd32___msgctl13 */
	case 302: {
		const struct compat_50_netbsd32___msgctl13_args *p = params;
		iarg[0] = SCARG(p, msqid); /* int */
		iarg[1] = SCARG(p, cmd); /* int */
		uarg[2] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_msqid_ds50p_t */
		*n_args = 3;
		break;
	}
	/* netbsd32___shmctl13 */
	case 303: {
		const struct compat_50_netbsd32___shmctl13_args *p = params;
		iarg[0] = SCARG(p, shmid); /* int */
		iarg[1] = SCARG(p, cmd); /* int */
		uarg[2] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_shmid_ds50p_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_lchflags */
	case 304: {
		const struct netbsd32_lchflags_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, flags); /* netbsd32_u_long */
		*n_args = 2;
		break;
	}
	/* sys_issetugid */
	case 305: {
		*n_args = 0;
		break;
	}
	/* netbsd32_utrace */
	case 306: {
		const struct netbsd32_utrace_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, label).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, addr).i32; /* netbsd32_voidp */
		iarg[2] = SCARG(p, len); /* netbsd32_size_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_getcontext */
	case 307: {
		const struct netbsd32_getcontext_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, ucp).i32; /* netbsd32_ucontextp */
		*n_args = 1;
		break;
	}
	/* netbsd32_setcontext */
	case 308: {
		const struct netbsd32_setcontext_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, ucp).i32; /* netbsd32_ucontextp */
		*n_args = 1;
		break;
	}
	/* netbsd32__lwp_create */
	case 309: {
		const struct netbsd32__lwp_create_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, ucp).i32; /* netbsd32_ucontextp */
		iarg[1] = SCARG(p, flags); /* netbsd32_u_long */
		uarg[2] = (intptr_t) SCARG(p, new_lwp).i32; /* netbsd32_lwpidp */
		*n_args = 3;
		break;
	}
	/* sys__lwp_exit */
	case 310: {
		*n_args = 0;
		break;
	}
	/* sys__lwp_self */
	case 311: {
		*n_args = 0;
		break;
	}
	/* netbsd32__lwp_wait */
	case 312: {
		const struct netbsd32__lwp_wait_args *p = params;
		iarg[0] = SCARG(p, wait_for); /* lwpid_t */
		uarg[1] = (intptr_t) SCARG(p, departed).i32; /* netbsd32_lwpidp */
		*n_args = 2;
		break;
	}
	/* netbsd32__lwp_suspend */
	case 313: {
		const struct netbsd32__lwp_suspend_args *p = params;
		iarg[0] = SCARG(p, target); /* lwpid_t */
		*n_args = 1;
		break;
	}
	/* netbsd32__lwp_continue */
	case 314: {
		const struct netbsd32__lwp_continue_args *p = params;
		iarg[0] = SCARG(p, target); /* lwpid_t */
		*n_args = 1;
		break;
	}
	/* netbsd32__lwp_wakeup */
	case 315: {
		const struct netbsd32__lwp_wakeup_args *p = params;
		iarg[0] = SCARG(p, target); /* lwpid_t */
		*n_args = 1;
		break;
	}
	/* sys__lwp_getprivate */
	case 316: {
		*n_args = 0;
		break;
	}
	/* netbsd32__lwp_setprivate */
	case 317: {
		const struct netbsd32__lwp_setprivate_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, ptr).i32; /* netbsd32_voidp */
		*n_args = 1;
		break;
	}
	/* netbsd32__lwp_kill */
	case 318: {
		const struct netbsd32__lwp_kill_args *p = params;
		iarg[0] = SCARG(p, target); /* lwpid_t */
		iarg[1] = SCARG(p, signo); /* int */
		*n_args = 2;
		break;
	}
	/* netbsd32__lwp_detach */
	case 319: {
		const struct netbsd32__lwp_detach_args *p = params;
		iarg[0] = SCARG(p, target); /* lwpid_t */
		*n_args = 1;
		break;
	}
	/* netbsd32__lwp_park */
	case 320: {
		const struct compat_50_netbsd32__lwp_park_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, ts).i32; /* netbsd32_timespec50p_t */
		iarg[1] = SCARG(p, unpark); /* lwpid_t */
		uarg[2] = (intptr_t) SCARG(p, hint).i32; /* netbsd32_voidp */
		uarg[3] = (intptr_t) SCARG(p, unparkhint).i32; /* netbsd32_voidp */
		*n_args = 4;
		break;
	}
	/* netbsd32__lwp_unpark */
	case 321: {
		const struct netbsd32__lwp_unpark_args *p = params;
		iarg[0] = SCARG(p, target); /* lwpid_t */
		uarg[1] = (intptr_t) SCARG(p, hint).i32; /* netbsd32_voidp */
		*n_args = 2;
		break;
	}
	/* netbsd32__lwp_unpark_all */
	case 322: {
		const struct netbsd32__lwp_unpark_all_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, targets).i32; /* netbsd32_lwpidp */
		iarg[1] = SCARG(p, ntargets); /* netbsd32_size_t */
		uarg[2] = (intptr_t) SCARG(p, hint).i32; /* netbsd32_voidp */
		*n_args = 3;
		break;
	}
	/* netbsd32__lwp_setname */
	case 323: {
		const struct netbsd32__lwp_setname_args *p = params;
		iarg[0] = SCARG(p, target); /* lwpid_t */
		uarg[1] = (intptr_t) SCARG(p, name).i32; /* netbsd32_charp */
		*n_args = 2;
		break;
	}
	/* netbsd32__lwp_getname */
	case 324: {
		const struct netbsd32__lwp_getname_args *p = params;
		iarg[0] = SCARG(p, target); /* lwpid_t */
		uarg[1] = (intptr_t) SCARG(p, name).i32; /* netbsd32_charp */
		iarg[2] = SCARG(p, len); /* netbsd32_size_t */
		*n_args = 3;
		break;
	}
	/* netbsd32__lwp_ctl */
	case 325: {
		const struct netbsd32__lwp_ctl_args *p = params;
		iarg[0] = SCARG(p, features); /* int */
		uarg[1] = (intptr_t) SCARG(p, address).i32; /* netbsd32_pointer_t */
		*n_args = 2;
		break;
	}
	/* netbsd32___sigaction_sigtramp */
	case 340: {
		const struct netbsd32___sigaction_sigtramp_args *p = params;
		iarg[0] = SCARG(p, signum); /* int */
		uarg[1] = (intptr_t) SCARG(p, nsa).i32; /* netbsd32_sigactionp_t */
		uarg[2] = (intptr_t) SCARG(p, osa).i32; /* netbsd32_sigactionp_t */
		uarg[3] = (intptr_t) SCARG(p, tramp).i32; /* netbsd32_voidp */
		iarg[4] = SCARG(p, vers); /* int */
		*n_args = 5;
		break;
	}
	/* netbsd32_rasctl */
	case 343: {
		const struct netbsd32_rasctl_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr).i32; /* netbsd32_voidp */
		iarg[1] = SCARG(p, len); /* netbsd32_size_t */
		iarg[2] = SCARG(p, op); /* int */
		*n_args = 3;
		break;
	}
	/* sys_kqueue */
	case 344: {
		*n_args = 0;
		break;
	}
	/* netbsd32_kevent */
	case 345: {
		const struct compat_50_netbsd32_kevent_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, changelist).i32; /* netbsd32_keventp_t */
		iarg[2] = SCARG(p, nchanges); /* netbsd32_size_t */
		uarg[3] = (intptr_t) SCARG(p, eventlist).i32; /* netbsd32_keventp_t */
		iarg[4] = SCARG(p, nevents); /* netbsd32_size_t */
		uarg[5] = (intptr_t) SCARG(p, timeout).i32; /* netbsd32_timespec50p_t */
		*n_args = 6;
		break;
	}
	/* netbsd32__sched_setparam */
	case 346: {
		const struct netbsd32__sched_setparam_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		iarg[1] = SCARG(p, lid); /* lwpid_t */
		iarg[2] = SCARG(p, policy); /* int */
		uarg[3] = (intptr_t) SCARG(p, params).i32; /* const netbsd32_sched_paramp_t */
		*n_args = 4;
		break;
	}
	/* netbsd32__sched_getparam */
	case 347: {
		const struct netbsd32__sched_getparam_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		iarg[1] = SCARG(p, lid); /* lwpid_t */
		uarg[2] = (intptr_t) SCARG(p, policy).i32; /* netbsd32_intp */
		uarg[3] = (intptr_t) SCARG(p, params).i32; /* netbsd32_sched_paramp_t */
		*n_args = 4;
		break;
	}
	/* netbsd32__sched_setaffinity */
	case 348: {
		const struct netbsd32__sched_setaffinity_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		iarg[1] = SCARG(p, lid); /* lwpid_t */
		iarg[2] = SCARG(p, size); /* netbsd32_size_t */
		uarg[3] = (intptr_t) SCARG(p, cpuset).i32; /* const netbsd32_cpusetp_t */
		*n_args = 4;
		break;
	}
	/* netbsd32__sched_getaffinity */
	case 349: {
		const struct netbsd32__sched_getaffinity_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		iarg[1] = SCARG(p, lid); /* lwpid_t */
		iarg[2] = SCARG(p, size); /* netbsd32_size_t */
		uarg[3] = (intptr_t) SCARG(p, cpuset).i32; /* netbsd32_cpusetp_t */
		*n_args = 4;
		break;
	}
	/* sys_sched_yield */
	case 350: {
		*n_args = 0;
		break;
	}
	/* netbsd32__sched_protect */
	case 351: {
		const struct netbsd32__sched_protect_args *p = params;
		iarg[0] = SCARG(p, priority); /* int */
		*n_args = 1;
		break;
	}
	/* netbsd32_fsync_range */
	case 354: {
		const struct netbsd32_fsync_range_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, flags); /* int */
		iarg[2] = SCARG(p, start); /* netbsd32_off_t */
		iarg[3] = SCARG(p, length); /* netbsd32_off_t */
		*n_args = 4;
		break;
	}
	/* netbsd32_uuidgen */
	case 355: {
		const struct netbsd32_uuidgen_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, store).i32; /* netbsd32_uuidp_t */
		iarg[1] = SCARG(p, count); /* int */
		*n_args = 2;
		break;
	}
	/* netbsd32_getvfsstat */
	case 356: {
		const struct netbsd32_getvfsstat_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_statvfsp_t */
		iarg[1] = SCARG(p, bufsize); /* netbsd32_size_t */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_statvfs1 */
	case 357: {
		const struct netbsd32_statvfs1_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_statvfsp_t */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_fstatvfs1 */
	case 358: {
		const struct netbsd32_fstatvfs1_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_statvfsp_t */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_fhstatvfs1 */
	case 359: {
		const struct compat_30_netbsd32_fhstatvfs1_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fhp).i32; /* netbsd32_fhandlep_t */
		uarg[1] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_statvfsp_t */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_extattrctl */
	case 360: {
		const struct netbsd32_extattrctl_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, cmd); /* int */
		uarg[2] = (intptr_t) SCARG(p, filename).i32; /* netbsd32_charp */
		iarg[3] = SCARG(p, attrnamespace); /* int */
		uarg[4] = (intptr_t) SCARG(p, attrname).i32; /* netbsd32_charp */
		*n_args = 5;
		break;
	}
	/* netbsd32_extattr_set_file */
	case 361: {
		const struct netbsd32_extattr_set_file_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, attrnamespace); /* int */
		uarg[2] = (intptr_t) SCARG(p, attrname).i32; /* netbsd32_charp */
		uarg[3] = (intptr_t) SCARG(p, data).i32; /* netbsd32_voidp */
		iarg[4] = SCARG(p, nbytes); /* netbsd32_size_t */
		*n_args = 5;
		break;
	}
	/* netbsd32_extattr_get_file */
	case 362: {
		const struct netbsd32_extattr_get_file_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, attrnamespace); /* int */
		uarg[2] = (intptr_t) SCARG(p, attrname).i32; /* netbsd32_charp */
		uarg[3] = (intptr_t) SCARG(p, data).i32; /* netbsd32_voidp */
		iarg[4] = SCARG(p, nbytes); /* netbsd32_size_t */
		*n_args = 5;
		break;
	}
	/* netbsd32_extattr_delete_file */
	case 363: {
		const struct netbsd32_extattr_delete_file_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, attrnamespace); /* int */
		uarg[2] = (intptr_t) SCARG(p, attrname).i32; /* netbsd32_charp */
		*n_args = 3;
		break;
	}
	/* netbsd32_extattr_set_fd */
	case 364: {
		const struct netbsd32_extattr_set_fd_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, attrnamespace); /* int */
		uarg[2] = (intptr_t) SCARG(p, attrname).i32; /* netbsd32_charp */
		uarg[3] = (intptr_t) SCARG(p, data).i32; /* netbsd32_voidp */
		iarg[4] = SCARG(p, nbytes); /* netbsd32_size_t */
		*n_args = 5;
		break;
	}
	/* netbsd32_extattr_get_fd */
	case 365: {
		const struct netbsd32_extattr_get_fd_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, attrnamespace); /* int */
		uarg[2] = (intptr_t) SCARG(p, attrname).i32; /* netbsd32_charp */
		uarg[3] = (intptr_t) SCARG(p, data).i32; /* netbsd32_voidp */
		iarg[4] = SCARG(p, nbytes); /* netbsd32_size_t */
		*n_args = 5;
		break;
	}
	/* netbsd32_extattr_delete_fd */
	case 366: {
		const struct netbsd32_extattr_delete_fd_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, attrnamespace); /* int */
		uarg[2] = (intptr_t) SCARG(p, attrname).i32; /* netbsd32_charp */
		*n_args = 3;
		break;
	}
	/* netbsd32_extattr_set_link */
	case 367: {
		const struct netbsd32_extattr_set_link_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, attrnamespace); /* int */
		uarg[2] = (intptr_t) SCARG(p, attrname).i32; /* netbsd32_charp */
		uarg[3] = (intptr_t) SCARG(p, data).i32; /* netbsd32_voidp */
		iarg[4] = SCARG(p, nbytes); /* netbsd32_size_t */
		*n_args = 5;
		break;
	}
	/* netbsd32_extattr_get_link */
	case 368: {
		const struct netbsd32_extattr_get_link_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, attrnamespace); /* int */
		uarg[2] = (intptr_t) SCARG(p, attrname).i32; /* netbsd32_charp */
		uarg[3] = (intptr_t) SCARG(p, data).i32; /* netbsd32_voidp */
		iarg[4] = SCARG(p, nbytes); /* netbsd32_size_t */
		*n_args = 5;
		break;
	}
	/* netbsd32_extattr_delete_link */
	case 369: {
		const struct netbsd32_extattr_delete_link_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, attrnamespace); /* int */
		uarg[2] = (intptr_t) SCARG(p, attrname).i32; /* netbsd32_charp */
		*n_args = 3;
		break;
	}
	/* netbsd32_extattr_list_fd */
	case 370: {
		const struct netbsd32_extattr_list_fd_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, attrnamespace); /* int */
		uarg[2] = (intptr_t) SCARG(p, data).i32; /* netbsd32_voidp */
		iarg[3] = SCARG(p, nbytes); /* netbsd32_size_t */
		*n_args = 4;
		break;
	}
	/* netbsd32_extattr_list_file */
	case 371: {
		const struct netbsd32_extattr_list_file_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, attrnamespace); /* int */
		uarg[2] = (intptr_t) SCARG(p, data).i32; /* netbsd32_voidp */
		iarg[3] = SCARG(p, nbytes); /* netbsd32_size_t */
		*n_args = 4;
		break;
	}
	/* netbsd32_extattr_list_link */
	case 372: {
		const struct netbsd32_extattr_list_link_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, attrnamespace); /* int */
		uarg[2] = (intptr_t) SCARG(p, data).i32; /* netbsd32_voidp */
		iarg[3] = SCARG(p, nbytes); /* netbsd32_size_t */
		*n_args = 4;
		break;
	}
	/* netbsd32_pselect */
	case 373: {
		const struct compat_50_netbsd32_pselect_args *p = params;
		iarg[0] = SCARG(p, nd); /* int */
		uarg[1] = (intptr_t) SCARG(p, in).i32; /* netbsd32_fd_setp_t */
		uarg[2] = (intptr_t) SCARG(p, ou).i32; /* netbsd32_fd_setp_t */
		uarg[3] = (intptr_t) SCARG(p, ex).i32; /* netbsd32_fd_setp_t */
		uarg[4] = (intptr_t) SCARG(p, ts).i32; /* netbsd32_timespec50p_t */
		uarg[5] = (intptr_t) SCARG(p, mask).i32; /* netbsd32_sigsetp_t */
		*n_args = 6;
		break;
	}
	/* netbsd32_pollts */
	case 374: {
		const struct compat_50_netbsd32_pollts_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fds).i32; /* netbsd32_pollfdp_t */
		uarg[1] = SCARG(p, nfds); /* u_int */
		uarg[2] = (intptr_t) SCARG(p, ts).i32; /* netbsd32_timespec50p_t */
		uarg[3] = (intptr_t) SCARG(p, mask).i32; /* netbsd32_sigsetp_t */
		*n_args = 4;
		break;
	}
	/* netbsd32_setxattr */
	case 375: {
		const struct netbsd32_setxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, name).i32; /* netbsd32_charp */
		uarg[2] = (intptr_t) SCARG(p, value).i32; /* netbsd32_voidp */
		iarg[3] = SCARG(p, size); /* netbsd32_size_t */
		iarg[4] = SCARG(p, flags); /* int */
		*n_args = 5;
		break;
	}
	/* netbsd32_lsetxattr */
	case 376: {
		const struct netbsd32_lsetxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, name).i32; /* netbsd32_charp */
		uarg[2] = (intptr_t) SCARG(p, value).i32; /* netbsd32_voidp */
		iarg[3] = SCARG(p, size); /* netbsd32_size_t */
		iarg[4] = SCARG(p, flags); /* int */
		*n_args = 5;
		break;
	}
	/* netbsd32_fsetxattr */
	case 377: {
		const struct netbsd32_fsetxattr_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, name).i32; /* netbsd32_charp */
		uarg[2] = (intptr_t) SCARG(p, value).i32; /* netbsd32_voidp */
		iarg[3] = SCARG(p, size); /* netbsd32_size_t */
		iarg[4] = SCARG(p, flags); /* int */
		*n_args = 5;
		break;
	}
	/* netbsd32_getxattr */
	case 378: {
		const struct netbsd32_getxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, name).i32; /* netbsd32_charp */
		uarg[2] = (intptr_t) SCARG(p, value).i32; /* netbsd32_voidp */
		iarg[3] = SCARG(p, size); /* netbsd32_size_t */
		*n_args = 4;
		break;
	}
	/* netbsd32_lgetxattr */
	case 379: {
		const struct netbsd32_lgetxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, name).i32; /* netbsd32_charp */
		uarg[2] = (intptr_t) SCARG(p, value).i32; /* netbsd32_voidp */
		iarg[3] = SCARG(p, size); /* netbsd32_size_t */
		*n_args = 4;
		break;
	}
	/* netbsd32_fgetxattr */
	case 380: {
		const struct netbsd32_fgetxattr_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, name).i32; /* netbsd32_charp */
		uarg[2] = (intptr_t) SCARG(p, value).i32; /* netbsd32_voidp */
		iarg[3] = SCARG(p, size); /* netbsd32_size_t */
		*n_args = 4;
		break;
	}
	/* netbsd32_listxattr */
	case 381: {
		const struct netbsd32_listxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, list).i32; /* netbsd32_charp */
		iarg[2] = SCARG(p, size); /* netbsd32_size_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_llistxattr */
	case 382: {
		const struct netbsd32_llistxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, list).i32; /* netbsd32_charp */
		iarg[2] = SCARG(p, size); /* netbsd32_size_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_flistxattr */
	case 383: {
		const struct netbsd32_flistxattr_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, list).i32; /* netbsd32_charp */
		iarg[2] = SCARG(p, size); /* netbsd32_size_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_removexattr */
	case 384: {
		const struct netbsd32_removexattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, name).i32; /* netbsd32_charp */
		*n_args = 2;
		break;
	}
	/* netbsd32_lremovexattr */
	case 385: {
		const struct netbsd32_lremovexattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, name).i32; /* netbsd32_charp */
		*n_args = 2;
		break;
	}
	/* netbsd32_fremovexattr */
	case 386: {
		const struct netbsd32_fremovexattr_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, name).i32; /* netbsd32_charp */
		*n_args = 2;
		break;
	}
	/* netbsd32___stat30 */
	case 387: {
		const struct compat_50_netbsd32___stat30_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, ub).i32; /* netbsd32_stat50p_t */
		*n_args = 2;
		break;
	}
	/* netbsd32___fstat30 */
	case 388: {
		const struct compat_50_netbsd32___fstat30_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, sb).i32; /* netbsd32_stat50p_t */
		*n_args = 2;
		break;
	}
	/* netbsd32___lstat30 */
	case 389: {
		const struct compat_50_netbsd32___lstat30_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, ub).i32; /* netbsd32_stat50p_t */
		*n_args = 2;
		break;
	}
	/* netbsd32___getdents30 */
	case 390: {
		const struct netbsd32___getdents30_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_charp */
		iarg[2] = SCARG(p, count); /* netbsd32_size_t */
		*n_args = 3;
		break;
	}
	/* netbsd32___fhstat30 */
	case 392: {
		const struct compat_30_netbsd32___fhstat30_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fhp).i32; /* netbsd32_fhandlep_t */
		uarg[1] = (intptr_t) SCARG(p, sb).i32; /* netbsd32_stat50p_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_ntp_gettime */
	case 393: {
		const struct compat_50_netbsd32_ntp_gettime_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, ntvp).i32; /* netbsd32_ntptimeval50p_t */
		*n_args = 1;
		break;
	}
	/* netbsd32___socket30 */
	case 394: {
		const struct netbsd32___socket30_args *p = params;
		iarg[0] = SCARG(p, domain); /* int */
		iarg[1] = SCARG(p, type); /* int */
		iarg[2] = SCARG(p, protocol); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32___getfh30 */
	case 395: {
		const struct netbsd32___getfh30_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fname).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, fhp).i32; /* netbsd32_pointer_t */
		uarg[2] = (intptr_t) SCARG(p, fh_size).i32; /* netbsd32_size_tp */
		*n_args = 3;
		break;
	}
	/* netbsd32___fhopen40 */
	case 396: {
		const struct netbsd32___fhopen40_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fhp).i32; /* netbsd32_pointer_t */
		iarg[1] = SCARG(p, fh_size); /* netbsd32_size_t */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32___fhstatvfs140 */
	case 397: {
		const struct netbsd32___fhstatvfs140_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fhp).i32; /* netbsd32_pointer_t */
		iarg[1] = SCARG(p, fh_size); /* netbsd32_size_t */
		uarg[2] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_statvfsp_t */
		iarg[3] = SCARG(p, flags); /* int */
		*n_args = 4;
		break;
	}
	/* netbsd32___fhstat40 */
	case 398: {
		const struct compat_50_netbsd32___fhstat40_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fhp).i32; /* netbsd32_pointer_t */
		iarg[1] = SCARG(p, fh_size); /* netbsd32_size_t */
		uarg[2] = (intptr_t) SCARG(p, sb).i32; /* netbsd32_stat50p_t */
		*n_args = 3;
		break;
	}
	/* netbsd32___mount50 */
	case 410: {
		const struct netbsd32___mount50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, type).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[2] = SCARG(p, flags); /* int */
		uarg[3] = (intptr_t) SCARG(p, data).i32; /* netbsd32_voidp */
		iarg[4] = SCARG(p, data_len); /* netbsd32_size_t */
		*n_args = 5;
		break;
	}
	/* netbsd32_mremap */
	case 411: {
		const struct netbsd32_mremap_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, old_address).i32; /* netbsd32_voidp */
		iarg[1] = SCARG(p, old_size); /* netbsd32_size_t */
		uarg[2] = (intptr_t) SCARG(p, new_address).i32; /* netbsd32_voidp */
		iarg[3] = SCARG(p, new_size); /* netbsd32_size_t */
		iarg[4] = SCARG(p, flags); /* int */
		*n_args = 5;
		break;
	}
	/* netbsd32_pset_create */
	case 412: {
		const struct netbsd32_pset_create_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, psid).i32; /* netbsd32_psetidp_t */
		*n_args = 1;
		break;
	}
	/* netbsd32_pset_destroy */
	case 413: {
		const struct netbsd32_pset_destroy_args *p = params;
		iarg[0] = SCARG(p, psid); /* psetid_t */
		*n_args = 1;
		break;
	}
	/* netbsd32_pset_assign */
	case 414: {
		const struct netbsd32_pset_assign_args *p = params;
		iarg[0] = SCARG(p, psid); /* psetid_t */
		iarg[1] = SCARG(p, cpuid); /* cpuid_t */
		uarg[2] = (intptr_t) SCARG(p, opsid).i32; /* netbsd32_psetidp_t */
		*n_args = 3;
		break;
	}
	/* netbsd32__pset_bind */
	case 415: {
		const struct netbsd32__pset_bind_args *p = params;
		iarg[0] = SCARG(p, idtype); /* idtype_t */
		iarg[1] = SCARG(p, first_id); /* id_t */
		iarg[2] = SCARG(p, second_id); /* id_t */
		iarg[3] = SCARG(p, psid); /* psetid_t */
		uarg[4] = (intptr_t) SCARG(p, opsid).i32; /* netbsd32_psetidp_t */
		*n_args = 5;
		break;
	}
	/* netbsd32___posix_fadvise50 */
	case 416: {
		const struct netbsd32___posix_fadvise50_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, PAD); /* int */
		iarg[2] = SCARG(p, offset); /* netbsd32_off_t */
		iarg[3] = SCARG(p, len); /* netbsd32_off_t */
		iarg[4] = SCARG(p, advice); /* int */
		*n_args = 5;
		break;
	}
	/* netbsd32___select50 */
	case 417: {
		const struct netbsd32___select50_args *p = params;
		iarg[0] = SCARG(p, nd); /* int */
		uarg[1] = (intptr_t) SCARG(p, in).i32; /* netbsd32_fd_setp_t */
		uarg[2] = (intptr_t) SCARG(p, ou).i32; /* netbsd32_fd_setp_t */
		uarg[3] = (intptr_t) SCARG(p, ex).i32; /* netbsd32_fd_setp_t */
		uarg[4] = (intptr_t) SCARG(p, tv).i32; /* netbsd32_timevalp_t */
		*n_args = 5;
		break;
	}
	/* netbsd32___gettimeofday50 */
	case 418: {
		const struct netbsd32___gettimeofday50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, tp).i32; /* netbsd32_timevalp_t */
		uarg[1] = (intptr_t) SCARG(p, tzp).i32; /* netbsd32_voidp */
		*n_args = 2;
		break;
	}
	/* netbsd32___settimeofday50 */
	case 419: {
		const struct netbsd32___settimeofday50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, tv).i32; /* const netbsd32_timevalp_t */
		uarg[1] = (intptr_t) SCARG(p, tzp).i32; /* const netbsd32_voidp */
		*n_args = 2;
		break;
	}
	/* netbsd32___utimes50 */
	case 420: {
		const struct netbsd32___utimes50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* const netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, tptr).i32; /* const netbsd32_timevalp_t */
		*n_args = 2;
		break;
	}
	/* netbsd32___adjtime50 */
	case 421: {
		const struct netbsd32___adjtime50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, delta).i32; /* const netbsd32_timevalp_t */
		uarg[1] = (intptr_t) SCARG(p, olddelta).i32; /* netbsd32_timevalp_t */
		*n_args = 2;
		break;
	}
	/* netbsd32___futimes50 */
	case 423: {
		const struct netbsd32___futimes50_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, tptr).i32; /* const netbsd32_timevalp_t */
		*n_args = 2;
		break;
	}
	/* netbsd32___lutimes50 */
	case 424: {
		const struct netbsd32___lutimes50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* const netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, tptr).i32; /* const netbsd32_timevalp_t */
		*n_args = 2;
		break;
	}
	/* netbsd32___setitimer50 */
	case 425: {
		const struct netbsd32___setitimer50_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		uarg[1] = (intptr_t) SCARG(p, itv).i32; /* const netbsd32_itimervalp_t */
		uarg[2] = (intptr_t) SCARG(p, oitv).i32; /* netbsd32_itimervalp_t */
		*n_args = 3;
		break;
	}
	/* netbsd32___getitimer50 */
	case 426: {
		const struct netbsd32___getitimer50_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		uarg[1] = (intptr_t) SCARG(p, itv).i32; /* netbsd32_itimervalp_t */
		*n_args = 2;
		break;
	}
	/* netbsd32___clock_gettime50 */
	case 427: {
		const struct netbsd32___clock_gettime50_args *p = params;
		iarg[0] = SCARG(p, clock_id); /* clockid_t */
		uarg[1] = (intptr_t) SCARG(p, tp).i32; /* netbsd32_timespecp_t */
		*n_args = 2;
		break;
	}
	/* netbsd32___clock_settime50 */
	case 428: {
		const struct netbsd32___clock_settime50_args *p = params;
		iarg[0] = SCARG(p, clock_id); /* clockid_t */
		uarg[1] = (intptr_t) SCARG(p, tp).i32; /* const netbsd32_timespecp_t */
		*n_args = 2;
		break;
	}
	/* netbsd32___clock_getres50 */
	case 429: {
		const struct netbsd32___clock_getres50_args *p = params;
		iarg[0] = SCARG(p, clock_id); /* clockid_t */
		uarg[1] = (intptr_t) SCARG(p, tp).i32; /* netbsd32_timespecp_t */
		*n_args = 2;
		break;
	}
	/* netbsd32___nanosleep50 */
	case 430: {
		const struct netbsd32___nanosleep50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, rqtp).i32; /* const netbsd32_timespecp_t */
		uarg[1] = (intptr_t) SCARG(p, rmtp).i32; /* netbsd32_timespecp_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_____sigtimedwait50 */
	case 431: {
		const struct netbsd32_____sigtimedwait50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, set).i32; /* const netbsd32_sigsetp_t */
		uarg[1] = (intptr_t) SCARG(p, info).i32; /* netbsd32_siginfop_t */
		uarg[2] = (intptr_t) SCARG(p, timeout).i32; /* netbsd32_timespecp_t */
		*n_args = 3;
		break;
	}
	/* netbsd32___mq_timedsend50 */
	case 432: {
		const struct netbsd32___mq_timedsend50_args *p = params;
		iarg[0] = SCARG(p, mqdes); /* mqd_t */
		uarg[1] = (intptr_t) SCARG(p, msg_ptr).i32; /* const netbsd32_charp */
		iarg[2] = SCARG(p, msg_len); /* netbsd32_size_t */
		uarg[3] = SCARG(p, msg_prio); /* unsigned */
		uarg[4] = (intptr_t) SCARG(p, abs_timeout).i32; /* const netbsd32_timespecp_t */
		*n_args = 5;
		break;
	}
	/* netbsd32___mq_timedreceive50 */
	case 433: {
		const struct netbsd32___mq_timedreceive50_args *p = params;
		iarg[0] = SCARG(p, mqdes); /* mqd_t */
		uarg[1] = (intptr_t) SCARG(p, msg_ptr).i32; /* netbsd32_charp */
		iarg[2] = SCARG(p, msg_len); /* netbsd32_size_t */
		uarg[3] = (intptr_t) SCARG(p, msg_prio).i32; /* netbsd32_uintp */
		uarg[4] = (intptr_t) SCARG(p, abs_timeout).i32; /* const netbsd32_timespecp_t */
		*n_args = 5;
		break;
	}
	/* netbsd32__lwp_park */
	case 434: {
		const struct compat_60_netbsd32__lwp_park_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, ts).i32; /* const netbsd32_timespecp_t */
		iarg[1] = SCARG(p, unpark); /* lwpid_t */
		uarg[2] = (intptr_t) SCARG(p, hint).i32; /* const netbsd32_voidp */
		uarg[3] = (intptr_t) SCARG(p, unparkhint).i32; /* const netbsd32_voidp */
		*n_args = 4;
		break;
	}
	/* netbsd32___kevent50 */
	case 435: {
		const struct netbsd32___kevent50_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, changelist).i32; /* const netbsd32_keventp_t */
		iarg[2] = SCARG(p, nchanges); /* netbsd32_size_t */
		uarg[3] = (intptr_t) SCARG(p, eventlist).i32; /* netbsd32_keventp_t */
		iarg[4] = SCARG(p, nevents); /* netbsd32_size_t */
		uarg[5] = (intptr_t) SCARG(p, timeout).i32; /* const netbsd32_timespecp_t */
		*n_args = 6;
		break;
	}
	/* netbsd32___pselect50 */
	case 436: {
		const struct netbsd32___pselect50_args *p = params;
		iarg[0] = SCARG(p, nd); /* int */
		uarg[1] = (intptr_t) SCARG(p, in).i32; /* netbsd32_fd_setp_t */
		uarg[2] = (intptr_t) SCARG(p, ou).i32; /* netbsd32_fd_setp_t */
		uarg[3] = (intptr_t) SCARG(p, ex).i32; /* netbsd32_fd_setp_t */
		uarg[4] = (intptr_t) SCARG(p, ts).i32; /* const netbsd32_timespecp_t */
		uarg[5] = (intptr_t) SCARG(p, mask).i32; /* const netbsd32_sigsetp_t */
		*n_args = 6;
		break;
	}
	/* netbsd32___pollts50 */
	case 437: {
		const struct netbsd32___pollts50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fds).i32; /* netbsd32_pollfdp_t */
		uarg[1] = SCARG(p, nfds); /* u_int */
		uarg[2] = (intptr_t) SCARG(p, ts).i32; /* const netbsd32_timespecp_t */
		uarg[3] = (intptr_t) SCARG(p, mask).i32; /* const netbsd32_sigsetp_t */
		*n_args = 4;
		break;
	}
	/* netbsd32___stat50 */
	case 439: {
		const struct netbsd32___stat50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* const netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, ub).i32; /* netbsd32_statp_t */
		*n_args = 2;
		break;
	}
	/* netbsd32___fstat50 */
	case 440: {
		const struct netbsd32___fstat50_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, sb).i32; /* netbsd32_statp_t */
		*n_args = 2;
		break;
	}
	/* netbsd32___lstat50 */
	case 441: {
		const struct netbsd32___lstat50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* const netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, ub).i32; /* netbsd32_statp_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_____semctl50 */
	case 442: {
		const struct netbsd32_____semctl50_args *p = params;
		iarg[0] = SCARG(p, semid); /* int */
		iarg[1] = SCARG(p, semnum); /* int */
		iarg[2] = SCARG(p, cmd); /* int */
		uarg[3] = (intptr_t) SCARG(p, arg).i32; /* netbsd32_semunp_t */
		*n_args = 4;
		break;
	}
	/* netbsd32___shmctl50 */
	case 443: {
		const struct netbsd32___shmctl50_args *p = params;
		iarg[0] = SCARG(p, shmid); /* int */
		iarg[1] = SCARG(p, cmd); /* int */
		uarg[2] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_shmid_dsp_t */
		*n_args = 3;
		break;
	}
	/* netbsd32___msgctl50 */
	case 444: {
		const struct netbsd32___msgctl50_args *p = params;
		iarg[0] = SCARG(p, msqid); /* int */
		iarg[1] = SCARG(p, cmd); /* int */
		uarg[2] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_msqid_dsp_t */
		*n_args = 3;
		break;
	}
	/* netbsd32___getrusage50 */
	case 445: {
		const struct netbsd32___getrusage50_args *p = params;
		iarg[0] = SCARG(p, who); /* int */
		uarg[1] = (intptr_t) SCARG(p, rusage).i32; /* netbsd32_rusagep_t */
		*n_args = 2;
		break;
	}
	/* netbsd32___timer_settime50 */
	case 446: {
		const struct netbsd32___timer_settime50_args *p = params;
		iarg[0] = SCARG(p, timerid); /* timer_t */
		iarg[1] = SCARG(p, flags); /* int */
		uarg[2] = (intptr_t) SCARG(p, value).i32; /* const netbsd32_itimerspecp_t */
		uarg[3] = (intptr_t) SCARG(p, ovalue).i32; /* netbsd32_itimerspecp_t */
		*n_args = 4;
		break;
	}
	/* netbsd32___timer_gettime50 */
	case 447: {
		const struct netbsd32___timer_gettime50_args *p = params;
		iarg[0] = SCARG(p, timerid); /* timer_t */
		uarg[1] = (intptr_t) SCARG(p, value).i32; /* netbsd32_itimerspecp_t */
		*n_args = 2;
		break;
	}
#if defined(NTP) || !defined(_KERNEL_OPT)
	/* netbsd32___ntp_gettime50 */
	case 448: {
		const struct netbsd32___ntp_gettime50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, ntvp).i32; /* netbsd32_ntptimevalp_t */
		*n_args = 1;
		break;
	}
#else
#endif
	/* netbsd32___wait450 */
	case 449: {
		const struct netbsd32___wait450_args *p = params;
		iarg[0] = SCARG(p, pid); /* int */
		uarg[1] = (intptr_t) SCARG(p, status).i32; /* netbsd32_intp */
		iarg[2] = SCARG(p, options); /* int */
		uarg[3] = (intptr_t) SCARG(p, rusage).i32; /* netbsd32_rusagep_t */
		*n_args = 4;
		break;
	}
	/* netbsd32___mknod50 */
	case 450: {
		const struct netbsd32___mknod50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* const netbsd32_charp */
		iarg[1] = SCARG(p, mode); /* mode_t */
		iarg[2] = SCARG(p, dev); /* netbsd32_dev_t */
		*n_args = 3;
		break;
	}
	/* netbsd32___fhstat50 */
	case 451: {
		const struct netbsd32___fhstat50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fhp).i32; /* const netbsd32_voidp */
		iarg[1] = SCARG(p, fh_size); /* netbsd32_size_t */
		uarg[2] = (intptr_t) SCARG(p, sb).i32; /* netbsd32_statp_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_pipe2 */
	case 453: {
		const struct netbsd32_pipe2_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fildes).i32; /* netbsd32_intp */
		iarg[1] = SCARG(p, flags); /* int */
		*n_args = 2;
		break;
	}
	/* netbsd32_dup3 */
	case 454: {
		const struct netbsd32_dup3_args *p = params;
		iarg[0] = SCARG(p, from); /* int */
		iarg[1] = SCARG(p, to); /* int */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_kqueue1 */
	case 455: {
		const struct netbsd32_kqueue1_args *p = params;
		iarg[0] = SCARG(p, flags); /* int */
		*n_args = 1;
		break;
	}
	/* netbsd32_paccept */
	case 456: {
		const struct netbsd32_paccept_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, name).i32; /* netbsd32_sockaddrp_t */
		uarg[2] = (intptr_t) SCARG(p, anamelen).i32; /* netbsd32_socklenp_t */
		uarg[3] = (intptr_t) SCARG(p, mask).i32; /* const netbsd32_sigsetp_t */
		iarg[4] = SCARG(p, flags); /* int */
		*n_args = 5;
		break;
	}
	/* netbsd32_linkat */
	case 457: {
		const struct netbsd32_linkat_args *p = params;
		iarg[0] = SCARG(p, fd1); /* int */
		uarg[1] = (intptr_t) SCARG(p, name1).i32; /* const netbsd32_charp */
		iarg[2] = SCARG(p, fd2); /* int */
		uarg[3] = (intptr_t) SCARG(p, name2).i32; /* const netbsd32_charp */
		iarg[4] = SCARG(p, flags); /* int */
		*n_args = 5;
		break;
	}
	/* netbsd32_renameat */
	case 458: {
		const struct netbsd32_renameat_args *p = params;
		iarg[0] = SCARG(p, fromfd); /* int */
		uarg[1] = (intptr_t) SCARG(p, from).i32; /* const netbsd32_charp */
		iarg[2] = SCARG(p, tofd); /* int */
		uarg[3] = (intptr_t) SCARG(p, to).i32; /* const netbsd32_charp */
		*n_args = 4;
		break;
	}
	/* netbsd32_mkfifoat */
	case 459: {
		const struct netbsd32_mkfifoat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path).i32; /* const netbsd32_charp */
		iarg[2] = SCARG(p, mode); /* mode_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_mknodat */
	case 460: {
		const struct netbsd32_mknodat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path).i32; /* const netbsd32_charp */
		iarg[2] = SCARG(p, mode); /* mode_t */
		iarg[3] = SCARG(p, PAD); /* int */
		iarg[4] = SCARG(p, dev); /* netbsd32_dev_t */
		*n_args = 5;
		break;
	}
	/* netbsd32_mkdirat */
	case 461: {
		const struct netbsd32_mkdirat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path).i32; /* const netbsd32_charp */
		iarg[2] = SCARG(p, mode); /* mode_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_faccessat */
	case 462: {
		const struct netbsd32_faccessat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path).i32; /* const netbsd32_charp */
		iarg[2] = SCARG(p, amode); /* int */
		iarg[3] = SCARG(p, flag); /* int */
		*n_args = 4;
		break;
	}
	/* netbsd32_fchmodat */
	case 463: {
		const struct netbsd32_fchmodat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path).i32; /* const netbsd32_charp */
		iarg[2] = SCARG(p, mode); /* mode_t */
		iarg[3] = SCARG(p, flag); /* int */
		*n_args = 4;
		break;
	}
	/* netbsd32_fchownat */
	case 464: {
		const struct netbsd32_fchownat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path).i32; /* const netbsd32_charp */
		uarg[2] = SCARG(p, owner); /* uid_t */
		iarg[3] = SCARG(p, group); /* gid_t */
		iarg[4] = SCARG(p, flag); /* int */
		*n_args = 5;
		break;
	}
	/* netbsd32_fexecve */
	case 465: {
		const struct netbsd32_fexecve_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, argp).i32; /* netbsd32_charpp */
		uarg[2] = (intptr_t) SCARG(p, envp).i32; /* netbsd32_charpp */
		*n_args = 3;
		break;
	}
	/* netbsd32_fstatat */
	case 466: {
		const struct netbsd32_fstatat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path).i32; /* const netbsd32_charp */
		uarg[2] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_statp_t */
		iarg[3] = SCARG(p, flag); /* int */
		*n_args = 4;
		break;
	}
	/* netbsd32_utimensat */
	case 467: {
		const struct netbsd32_utimensat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path).i32; /* const netbsd32_charp */
		uarg[2] = (intptr_t) SCARG(p, tptr).i32; /* const netbsd32_timespecp_t */
		iarg[3] = SCARG(p, flag); /* int */
		*n_args = 4;
		break;
	}
	/* netbsd32_openat */
	case 468: {
		const struct netbsd32_openat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path).i32; /* const netbsd32_charp */
		iarg[2] = SCARG(p, oflags); /* int */
		iarg[3] = SCARG(p, mode); /* mode_t */
		*n_args = 4;
		break;
	}
	/* netbsd32_readlinkat */
	case 469: {
		const struct netbsd32_readlinkat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path).i32; /* const netbsd32_charp */
		uarg[2] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_charp */
		iarg[3] = SCARG(p, bufsize); /* netbsd32_size_t */
		*n_args = 4;
		break;
	}
	/* netbsd32_symlinkat */
	case 470: {
		const struct netbsd32_symlinkat_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path1).i32; /* const netbsd32_charp */
		iarg[1] = SCARG(p, fd); /* int */
		uarg[2] = (intptr_t) SCARG(p, path2).i32; /* const netbsd32_charp */
		*n_args = 3;
		break;
	}
	/* netbsd32_unlinkat */
	case 471: {
		const struct netbsd32_unlinkat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path).i32; /* const netbsd32_charp */
		iarg[2] = SCARG(p, flag); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_futimens */
	case 472: {
		const struct netbsd32_futimens_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, tptr).i32; /* const netbsd32_timespecp_t */
		*n_args = 2;
		break;
	}
#if defined(QUOTA) || !defined(_KERNEL_OPT)
	/* netbsd32___quotactl */
	case 473: {
		const struct netbsd32___quotactl_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* const netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, args).i32; /* netbsd32_voidp */
		*n_args = 2;
		break;
	}
#else
#endif
	/* netbsd32_posix_spawn */
	case 474: {
		const struct netbsd32_posix_spawn_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, pid).i32; /* netbsd32_pid_tp */
		uarg[1] = (intptr_t) SCARG(p, path).i32; /* const netbsd32_charp */
		uarg[2] = (intptr_t) SCARG(p, file_actions).i32; /* const netbsd32_posix_spawn_file_actionsp */
		uarg[3] = (intptr_t) SCARG(p, attrp).i32; /* const netbsd32_posix_spawnattrp */
		uarg[4] = (intptr_t) SCARG(p, argv).i32; /* netbsd32_charpp */
		uarg[5] = (intptr_t) SCARG(p, envp).i32; /* netbsd32_charpp */
		*n_args = 6;
		break;
	}
	/* netbsd32_recvmmsg */
	case 475: {
		const struct netbsd32_recvmmsg_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, mmsg).i32; /* netbsd32_mmsghdrp_t */
		uarg[2] = SCARG(p, vlen); /* unsigned int */
		uarg[3] = SCARG(p, flags); /* unsigned int */
		uarg[4] = (intptr_t) SCARG(p, timeout).i32; /* netbsd32_timespecp_t */
		*n_args = 5;
		break;
	}
	/* netbsd32_sendmmsg */
	case 476: {
		const struct netbsd32_sendmmsg_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, mmsg).i32; /* netbsd32_mmsghdrp_t */
		uarg[2] = SCARG(p, vlen); /* unsigned int */
		uarg[3] = SCARG(p, flags); /* unsigned int */
		*n_args = 4;
		break;
	}
	/* netbsd32_clock_nanosleep */
	case 477: {
		const struct netbsd32_clock_nanosleep_args *p = params;
		iarg[0] = SCARG(p, clock_id); /* netbsd32_clockid_t */
		iarg[1] = SCARG(p, flags); /* int */
		uarg[2] = (intptr_t) SCARG(p, rqtp).i32; /* const netbsd32_timespecp_t */
		uarg[3] = (intptr_t) SCARG(p, rmtp).i32; /* netbsd32_timespecp_t */
		*n_args = 4;
		break;
	}
	/* netbsd32____lwp_park60 */
	case 478: {
		const struct netbsd32____lwp_park60_args *p = params;
		iarg[0] = SCARG(p, clock_id); /* netbsd32_clockid_t */
		iarg[1] = SCARG(p, flags); /* int */
		uarg[2] = (intptr_t) SCARG(p, ts).i32; /* netbsd32_timespecp_t */
		iarg[3] = SCARG(p, unpark); /* lwpid_t */
		uarg[4] = (intptr_t) SCARG(p, hint).i32; /* netbsd32_voidp */
		uarg[5] = (intptr_t) SCARG(p, unparkhint).i32; /* netbsd32_voidp */
		*n_args = 6;
		break;
	}
	/* netbsd32_posix_fallocate */
	case 479: {
		const struct netbsd32_posix_fallocate_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, PAD); /* int */
		iarg[2] = SCARG(p, pos); /* netbsd32_off_t */
		iarg[3] = SCARG(p, len); /* netbsd32_off_t */
		*n_args = 4;
		break;
	}
	/* netbsd32_fdiscard */
	case 480: {
		const struct netbsd32_fdiscard_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, PAD); /* int */
		iarg[2] = SCARG(p, pos); /* netbsd32_off_t */
		iarg[3] = SCARG(p, len); /* netbsd32_off_t */
		*n_args = 4;
		break;
	}
	/* netbsd32_wait6 */
	case 481: {
		const struct netbsd32_wait6_args *p = params;
		iarg[0] = SCARG(p, idtype); /* idtype_t */
		iarg[1] = SCARG(p, id); /* id_t */
		uarg[2] = (intptr_t) SCARG(p, status).i32; /* netbsd32_intp */
		iarg[3] = SCARG(p, options); /* int */
		uarg[4] = (intptr_t) SCARG(p, wru).i32; /* netbsd32_wrusagep_t */
		uarg[5] = (intptr_t) SCARG(p, info).i32; /* netbsd32_siginfop_t */
		*n_args = 6;
		break;
	}
	/* netbsd32_clock_getcpuclockid2 */
	case 482: {
		const struct netbsd32_clock_getcpuclockid2_args *p = params;
		iarg[0] = SCARG(p, idtype); /* idtype_t */
		iarg[1] = SCARG(p, id); /* id_t */
		uarg[2] = (intptr_t) SCARG(p, clock_id).i32; /* netbsd32_clockidp_t */
		*n_args = 3;
		break;
	}
	default:
		*n_args = 0;
		break;
	};
}
static void
systrace_entry_setargdesc(int sysnum, int ndx, char *desc, size_t descsz)
{
	const char *p = NULL;
	switch (sysnum) {
	/* netbsd32_syscall */
	case 0:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "register32_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_exit */
	case 1:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_fork */
	case 2:
		break;
	/* netbsd32_read */
	case 3:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_write */
	case 4:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_open */
	case 5:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "mode_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_close */
	case 6:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_wait4 */
	case 7:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_intp";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "netbsd32_rusage50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_ocreat */
	case 8:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "mode_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_link */
	case 9:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_unlink */
	case 10:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_chdir */
	case 12:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fchdir */
	case 13:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_mknod */
	case 14:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "mode_t";
			break;
		case 2:
			p = "uint32_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_chmod */
	case 15:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "mode_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_chown */
	case 16:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "uid_t";
			break;
		case 2:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_break */
	case 17:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_getfsstat */
	case 18:
		switch(ndx) {
		case 0:
			p = "netbsd32_statfsp_t";
			break;
		case 1:
			p = "netbsd32_long";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_olseek */
	case 19:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_long";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_getpid */
	case 20:
		break;
	/* netbsd32_mount */
	case 21:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "netbsd32_voidp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_unmount */
	case 22:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_setuid */
	case 23:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_getuid */
	case 24:
		break;
	/* sys_geteuid */
	case 25:
		break;
	/* netbsd32_ptrace */
	case 26:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "pid_t";
			break;
		case 2:
			p = "netbsd32_voidp";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_recvmsg */
	case 27:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_msghdrp_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_sendmsg */
	case 28:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_msghdrp_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_recvfrom */
	case 29:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "netbsd32_sockaddrp_t";
			break;
		case 5:
			p = "netbsd32_intp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_accept */
	case 30:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_sockaddrp_t";
			break;
		case 2:
			p = "netbsd32_intp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_getpeername */
	case 31:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_sockaddrp_t";
			break;
		case 2:
			p = "netbsd32_intp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_getsockname */
	case 32:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_sockaddrp_t";
			break;
		case 2:
			p = "netbsd32_intp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_access */
	case 33:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_chflags */
	case 34:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_u_long";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fchflags */
	case 35:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_u_long";
			break;
		default:
			break;
		};
		break;
	/* sys_sync */
	case 36:
		break;
	/* netbsd32_kill */
	case 37:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_stat43 */
	case 38:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_stat43p_t";
			break;
		default:
			break;
		};
		break;
	/* sys_getppid */
	case 39:
		break;
	/* netbsd32_lstat43 */
	case 40:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_stat43p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_dup */
	case 41:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_pipe */
	case 42:
		break;
	/* sys_getegid */
	case 43:
		break;
	/* netbsd32_profil */
	case 44:
		switch(ndx) {
		case 0:
			p = "netbsd32_voidp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		case 2:
			p = "netbsd32_u_long";
			break;
		case 3:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_ktrace */
	case 45:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_sigaction */
	case 46:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_sigactionp_t";
			break;
		case 2:
			p = "netbsd32_sigactionp_t";
			break;
		default:
			break;
		};
		break;
	/* sys_getgid */
	case 47:
		break;
	/* netbsd32_sigprocmask */
	case 48:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___getlogin */
	case 49:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_setlogin */
	case 50:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_acct */
	case 51:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* sys_sigpending */
	case 52:
		break;
	/* netbsd32_sigaltstack13 */
	case 53:
		switch(ndx) {
		case 0:
			p = "netbsd32_sigaltstack13p_t";
			break;
		case 1:
			p = "netbsd32_sigaltstack13p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_ioctl */
	case 54:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_u_long";
			break;
		case 2:
			p = "netbsd32_voidp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_reboot */
	case 55:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_revoke */
	case 56:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_symlink */
	case 57:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_readlink */
	case 58:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_execve */
	case 59:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charpp";
			break;
		case 2:
			p = "netbsd32_charpp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_umask */
	case 60:
		switch(ndx) {
		case 0:
			p = "mode_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_chroot */
	case 61:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fstat43 */
	case 62:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_stat43p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_ogetkerninfo */
	case 63:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_intp";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_getpagesize */
	case 64:
		break;
	/* netbsd32_msync */
	case 65:
		switch(ndx) {
		case 0:
			p = "netbsd32_voidp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_vfork */
	case 66:
		break;
	/* netbsd32_ommap */
	case 71:
		switch(ndx) {
		case 0:
			p = "netbsd32_voidp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "int";
			break;
		case 5:
			p = "netbsd32_long";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_ovadvise */
	case 72:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_munmap */
	case 73:
		switch(ndx) {
		case 0:
			p = "netbsd32_voidp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_mprotect */
	case 74:
		switch(ndx) {
		case 0:
			p = "netbsd32_voidp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_madvise */
	case 75:
		switch(ndx) {
		case 0:
			p = "netbsd32_voidp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_mincore */
	case 78:
		switch(ndx) {
		case 0:
			p = "netbsd32_voidp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		case 2:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_getgroups */
	case 79:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_gid_tp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_setgroups */
	case 80:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_gid_tp";
			break;
		default:
			break;
		};
		break;
	/* sys_getpgrp */
	case 81:
		break;
	/* netbsd32_setpgid */
	case 82:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_setitimer */
	case 83:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_itimerval50p_t";
			break;
		case 2:
			p = "netbsd32_itimerval50p_t";
			break;
		default:
			break;
		};
		break;
	/* sys_wait */
	case 84:
		break;
	/* netbsd32_oswapon */
	case 85:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_getitimer */
	case 86:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_itimerval50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_ogethostname */
	case 87:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_osethostname */
	case 88:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* sys_getdtablesize */
	case 89:
		break;
	/* netbsd32_dup2 */
	case 90:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fcntl */
	case 92:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_voidp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_select */
	case 93:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_fd_setp_t";
			break;
		case 2:
			p = "netbsd32_fd_setp_t";
			break;
		case 3:
			p = "netbsd32_fd_setp_t";
			break;
		case 4:
			p = "netbsd32_timeval50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fsync */
	case 95:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_setpriority */
	case 96:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_socket */
	case 97:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_connect */
	case 98:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_sockaddrp_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_oaccept */
	case 99:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		case 2:
			p = "netbsd32_intp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_getpriority */
	case 100:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_osend */
	case 101:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_orecv */
	case 102:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_sigreturn */
	case 103:
		switch(ndx) {
		case 0:
			p = "netbsd32_sigcontextp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_bind */
	case 104:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_sockaddrp_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_setsockopt */
	case 105:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "netbsd32_voidp";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_listen */
	case 106:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_osigvec */
	case 108:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_sigvecp_t";
			break;
		case 2:
			p = "netbsd32_sigvecp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_sigblock */
	case 109:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_sigsetmask */
	case 110:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_sigsuspend */
	case 111:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_osigstack */
	case 112:
		switch(ndx) {
		case 0:
			p = "netbsd32_sigstackp_t";
			break;
		case 1:
			p = "netbsd32_sigstackp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_orecvmsg */
	case 113:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_omsghdrp_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_osendmsg */
	case 114:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_gettimeofday */
	case 116:
		switch(ndx) {
		case 0:
			p = "netbsd32_timeval50p_t";
			break;
		case 1:
			p = "netbsd32_timezonep_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_getrusage */
	case 117:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_rusage50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_getsockopt */
	case 118:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "netbsd32_voidp";
			break;
		case 4:
			p = "netbsd32_intp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_readv */
	case 120:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_iovecp_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_writev */
	case 121:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_iovecp_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_settimeofday */
	case 122:
		switch(ndx) {
		case 0:
			p = "netbsd32_timeval50p_t";
			break;
		case 1:
			p = "netbsd32_timezonep_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fchown */
	case 123:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "uid_t";
			break;
		case 2:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fchmod */
	case 124:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "mode_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_orecvfrom */
	case 125:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "netbsd32_voidp";
			break;
		case 5:
			p = "netbsd32_intp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_setreuid */
	case 126:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		case 1:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_setregid */
	case 127:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		case 1:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_rename */
	case 128:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_otruncate */
	case 129:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_long";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_oftruncate */
	case 130:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_long";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_flock */
	case 131:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_mkfifo */
	case 132:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "mode_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_sendto */
	case 133:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "netbsd32_sockaddrp_t";
			break;
		case 5:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_shutdown */
	case 134:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_socketpair */
	case 135:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "netbsd32_intp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_mkdir */
	case 136:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "mode_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_rmdir */
	case 137:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_utimes */
	case 138:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_timeval50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_adjtime */
	case 140:
		switch(ndx) {
		case 0:
			p = "netbsd32_timeval50p_t";
			break;
		case 1:
			p = "netbsd32_timeval50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_ogetpeername */
	case 141:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		case 2:
			p = "netbsd32_intp";
			break;
		default:
			break;
		};
		break;
	/* sys_gethostid */
	case 142:
		break;
	/* netbsd32_sethostid */
	case 143:
		switch(ndx) {
		case 0:
			p = "int32_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_ogetrlimit */
	case 144:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_orlimitp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_osetrlimit */
	case 145:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_orlimitp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_killpg */
	case 146:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_setsid */
	case 147:
		break;
#if defined(QUOTA) || !defined(_KERNEL_OPT)
	/* netbsd32_quotactl */
	case 148:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "netbsd32_voidp";
			break;
		default:
			break;
		};
		break;
#else
#endif
	/* netbsd32_ogetsockname */
	case 150:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		case 2:
			p = "netbsd32_intp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_nfssvc */
	case 155:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_ogetdirentries */
	case 156:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "u_int";
			break;
		case 3:
			p = "netbsd32_longp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_statfs */
	case 157:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_statfsp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fstatfs */
	case 158:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_statfsp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_getfh */
	case 161:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_compat_30_fhandlep_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_ogetdomainname */
	case 162:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_osetdomainname */
	case 163:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_uname */
	case 164:
		switch(ndx) {
		case 0:
			p = "netbsd32_outsnamep_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_sysarch */
	case 165:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_semsys */
	case 169:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_msgsys */
	case 170:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "int";
			break;
		case 5:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_shmsys */
	case 171:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_pread */
	case 173:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "netbsd32_off_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_pwrite */
	case 174:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "netbsd32_off_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_ntp_gettime */
	case 175:
		switch(ndx) {
		case 0:
			p = "netbsd32_ntptimeval50p_t";
			break;
		default:
			break;
		};
		break;
#if defined(NTP) || !defined(_KERNEL_OPT)
	/* netbsd32_ntp_adjtime */
	case 176:
		switch(ndx) {
		case 0:
			p = "netbsd32_timexp_t";
			break;
		default:
			break;
		};
		break;
#else
#endif
	/* netbsd32_setgid */
	case 181:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_setegid */
	case 182:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_seteuid */
	case 183:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_stat12 */
	case 188:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_stat12p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fstat12 */
	case 189:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_stat12p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_lstat12 */
	case 190:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_stat12p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_pathconf */
	case 191:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fpathconf */
	case 192:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_getsockopt2 */
	case 193:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "netbsd32_voidp";
			break;
		case 4:
			p = "netbsd32_intp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_getrlimit */
	case 194:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_rlimitp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_setrlimit */
	case 195:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_rlimitp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_getdirentries */
	case 196:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "u_int";
			break;
		case 3:
			p = "netbsd32_longp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_mmap */
	case 197:
		switch(ndx) {
		case 0:
			p = "netbsd32_voidp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "int";
			break;
		case 5:
			p = "netbsd32_long";
			break;
		case 6:
			p = "netbsd32_off_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32____syscall */
	case 198:
		switch(ndx) {
		case 0:
			p = "quad_t";
			break;
		case 1:
			p = "register32_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_lseek */
	case 199:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_off_t";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_truncate */
	case 200:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_off_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_ftruncate */
	case 201:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_off_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___sysctl */
	case 202:
		switch(ndx) {
		case 0:
			p = "netbsd32_intp";
			break;
		case 1:
			p = "u_int";
			break;
		case 2:
			p = "netbsd32_voidp";
			break;
		case 3:
			p = "netbsd32_size_tp";
			break;
		case 4:
			p = "netbsd32_voidp";
			break;
		case 5:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_mlock */
	case 203:
		switch(ndx) {
		case 0:
			p = "netbsd32_voidp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_munlock */
	case 204:
		switch(ndx) {
		case 0:
			p = "netbsd32_voidp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_undelete */
	case 205:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_futimes */
	case 206:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_timeval50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_getpgid */
	case 207:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_reboot */
	case 208:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_poll */
	case 209:
		switch(ndx) {
		case 0:
			p = "netbsd32_pollfdp_t";
			break;
		case 1:
			p = "u_int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___semctl */
	case 220:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "netbsd32_semunu_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_semget */
	case 221:
		switch(ndx) {
		case 0:
			p = "netbsd32_key_t";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_semop */
	case 222:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_sembufp_t";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_semconfig */
	case 223:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_msgctl */
	case 224:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_msqid_ds14p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_msgget */
	case 225:
		switch(ndx) {
		case 0:
			p = "netbsd32_key_t";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_msgsnd */
	case 226:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_msgrcv */
	case 227:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		case 3:
			p = "netbsd32_long";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_shmat */
	case 228:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_shmctl */
	case 229:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_shmid_dsp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_shmdt */
	case 230:
		switch(ndx) {
		case 0:
			p = "netbsd32_voidp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_shmget */
	case 231:
		switch(ndx) {
		case 0:
			p = "netbsd32_key_t";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_clock_gettime */
	case 232:
		switch(ndx) {
		case 0:
			p = "netbsd32_clockid_t";
			break;
		case 1:
			p = "netbsd32_timespec50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_clock_settime */
	case 233:
		switch(ndx) {
		case 0:
			p = "netbsd32_clockid_t";
			break;
		case 1:
			p = "netbsd32_timespec50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_clock_getres */
	case 234:
		switch(ndx) {
		case 0:
			p = "netbsd32_clockid_t";
			break;
		case 1:
			p = "netbsd32_timespec50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_timer_create */
	case 235:
		switch(ndx) {
		case 0:
			p = "netbsd32_clockid_t";
			break;
		case 1:
			p = "netbsd32_sigeventp_t";
			break;
		case 2:
			p = "netbsd32_timerp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_timer_delete */
	case 236:
		switch(ndx) {
		case 0:
			p = "netbsd32_timer_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_timer_settime */
	case 237:
		switch(ndx) {
		case 0:
			p = "netbsd32_timer_t";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_itimerspec50p_t";
			break;
		case 3:
			p = "netbsd32_itimerspec50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_timer_gettime */
	case 238:
		switch(ndx) {
		case 0:
			p = "netbsd32_timer_t";
			break;
		case 1:
			p = "netbsd32_itimerspec50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_timer_getoverrun */
	case 239:
		switch(ndx) {
		case 0:
			p = "netbsd32_timer_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_nanosleep */
	case 240:
		switch(ndx) {
		case 0:
			p = "netbsd32_timespec50p_t";
			break;
		case 1:
			p = "netbsd32_timespec50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fdatasync */
	case 241:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_mlockall */
	case 242:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_munlockall */
	case 243:
		break;
	/* netbsd32___sigtimedwait */
	case 244:
		switch(ndx) {
		case 0:
			p = "netbsd32_sigsetp_t";
			break;
		case 1:
			p = "netbsd32_siginfop_t";
			break;
		case 2:
			p = "netbsd32_timespec50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_sigqueueinfo */
	case 245:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "const netbsd32_siginfop_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_modctl */
	case 246:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__ksem_init */
	case 247:
		switch(ndx) {
		case 0:
			p = "unsigned int";
			break;
		case 1:
			p = "netbsd32_semidp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__ksem_open */
	case 248:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "mode_t";
			break;
		case 3:
			p = "unsigned int";
			break;
		case 4:
			p = "netbsd32_semidp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__ksem_unlink */
	case 249:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__ksem_close */
	case 250:
		switch(ndx) {
		case 0:
			p = "netbsd32_intptr_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__ksem_post */
	case 251:
		switch(ndx) {
		case 0:
			p = "netbsd32_intptr_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__ksem_wait */
	case 252:
		switch(ndx) {
		case 0:
			p = "netbsd32_intptr_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__ksem_trywait */
	case 253:
		switch(ndx) {
		case 0:
			p = "netbsd32_intptr_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__ksem_getvalue */
	case 254:
		switch(ndx) {
		case 0:
			p = "netbsd32_intptr_t";
			break;
		case 1:
			p = "netbsd32_intp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__ksem_destroy */
	case 255:
		switch(ndx) {
		case 0:
			p = "netbsd32_intptr_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__ksem_timedwait */
	case 256:
		switch(ndx) {
		case 0:
			p = "intptr_t";
			break;
		case 1:
			p = "const netbsd32_timespecp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_mq_open */
	case 257:
		switch(ndx) {
		case 0:
			p = "const netbsd32_charp";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "mode_t";
			break;
		case 3:
			p = "netbsd32_mq_attrp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_mq_close */
	case 258:
		switch(ndx) {
		case 0:
			p = "mqd_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_mq_unlink */
	case 259:
		switch(ndx) {
		case 0:
			p = "const netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_mq_getattr */
	case 260:
		switch(ndx) {
		case 0:
			p = "mqd_t";
			break;
		case 1:
			p = "netbsd32_mq_attrp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_mq_setattr */
	case 261:
		switch(ndx) {
		case 0:
			p = "mqd_t";
			break;
		case 1:
			p = "const netbsd32_mq_attrp_t";
			break;
		case 2:
			p = "netbsd32_mq_attrp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_mq_notify */
	case 262:
		switch(ndx) {
		case 0:
			p = "mqd_t";
			break;
		case 1:
			p = "const netbsd32_sigeventp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_mq_send */
	case 263:
		switch(ndx) {
		case 0:
			p = "mqd_t";
			break;
		case 1:
			p = "const netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		case 3:
			p = "unsigned";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_mq_receive */
	case 264:
		switch(ndx) {
		case 0:
			p = "mqd_t";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		case 3:
			p = "netbsd32_uintp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_mq_timedsend */
	case 265:
		switch(ndx) {
		case 0:
			p = "mqd_t";
			break;
		case 1:
			p = "const netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		case 3:
			p = "unsigned";
			break;
		case 4:
			p = "const netbsd32_timespec50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_mq_timedreceive */
	case 266:
		switch(ndx) {
		case 0:
			p = "mqd_t";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		case 3:
			p = "netbsd32_uintp";
			break;
		case 4:
			p = "const netbsd32_timespec50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___posix_rename */
	case 270:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_swapctl */
	case 271:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_getdents */
	case 272:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_minherit */
	case 273:
		switch(ndx) {
		case 0:
			p = "netbsd32_voidp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_lchmod */
	case 274:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "mode_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_lchown */
	case 275:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "uid_t";
			break;
		case 2:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_lutimes */
	case 276:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_timeval50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___msync13 */
	case 277:
		switch(ndx) {
		case 0:
			p = "netbsd32_voidp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___stat13 */
	case 278:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_stat13p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___fstat13 */
	case 279:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_stat13p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___lstat13 */
	case 280:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_stat13p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___sigaltstack14 */
	case 281:
		switch(ndx) {
		case 0:
			p = "netbsd32_sigaltstackp_t";
			break;
		case 1:
			p = "netbsd32_sigaltstackp_t";
			break;
		default:
			break;
		};
		break;
	/* sys___vfork14 */
	case 282:
		break;
	/* netbsd32___posix_chown */
	case 283:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "uid_t";
			break;
		case 2:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___posix_fchown */
	case 284:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "uid_t";
			break;
		case 2:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___posix_lchown */
	case 285:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "uid_t";
			break;
		case 2:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_getsid */
	case 286:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___clone */
	case 287:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fktrace */
	case 288:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_preadv */
	case 289:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_iovecp_t";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "netbsd32_off_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_pwritev */
	case 290:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_iovecp_t";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "netbsd32_off_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___sigaction14 */
	case 291:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_sigactionp_t";
			break;
		case 2:
			p = "netbsd32_sigactionp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___sigpending14 */
	case 292:
		switch(ndx) {
		case 0:
			p = "netbsd32_sigsetp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___sigprocmask14 */
	case 293:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_sigsetp_t";
			break;
		case 2:
			p = "netbsd32_sigsetp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___sigsuspend14 */
	case 294:
		switch(ndx) {
		case 0:
			p = "netbsd32_sigsetp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___sigreturn14 */
	case 295:
		switch(ndx) {
		case 0:
			p = "netbsd32_sigcontextp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___getcwd */
	case 296:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fchroot */
	case 297:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fhopen */
	case 298:
		switch(ndx) {
		case 0:
			p = "netbsd32_fhandlep_t";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fhstat */
	case 299:
		switch(ndx) {
		case 0:
			p = "netbsd32_fhandlep_t";
			break;
		case 1:
			p = "netbsd32_stat13p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fhstatfs */
	case 300:
		switch(ndx) {
		case 0:
			p = "netbsd32_fhandlep_t";
			break;
		case 1:
			p = "netbsd32_stat50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___semctl14 */
	case 301:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "netbsd32_semun50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___msgctl13 */
	case 302:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_msqid_ds50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___shmctl13 */
	case 303:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_shmid_ds50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_lchflags */
	case 304:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_u_long";
			break;
		default:
			break;
		};
		break;
	/* sys_issetugid */
	case 305:
		break;
	/* netbsd32_utrace */
	case 306:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_getcontext */
	case 307:
		switch(ndx) {
		case 0:
			p = "netbsd32_ucontextp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_setcontext */
	case 308:
		switch(ndx) {
		case 0:
			p = "netbsd32_ucontextp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__lwp_create */
	case 309:
		switch(ndx) {
		case 0:
			p = "netbsd32_ucontextp";
			break;
		case 1:
			p = "netbsd32_u_long";
			break;
		case 2:
			p = "netbsd32_lwpidp";
			break;
		default:
			break;
		};
		break;
	/* sys__lwp_exit */
	case 310:
		break;
	/* sys__lwp_self */
	case 311:
		break;
	/* netbsd32__lwp_wait */
	case 312:
		switch(ndx) {
		case 0:
			p = "lwpid_t";
			break;
		case 1:
			p = "netbsd32_lwpidp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__lwp_suspend */
	case 313:
		switch(ndx) {
		case 0:
			p = "lwpid_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__lwp_continue */
	case 314:
		switch(ndx) {
		case 0:
			p = "lwpid_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__lwp_wakeup */
	case 315:
		switch(ndx) {
		case 0:
			p = "lwpid_t";
			break;
		default:
			break;
		};
		break;
	/* sys__lwp_getprivate */
	case 316:
		break;
	/* netbsd32__lwp_setprivate */
	case 317:
		switch(ndx) {
		case 0:
			p = "netbsd32_voidp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__lwp_kill */
	case 318:
		switch(ndx) {
		case 0:
			p = "lwpid_t";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__lwp_detach */
	case 319:
		switch(ndx) {
		case 0:
			p = "lwpid_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__lwp_park */
	case 320:
		switch(ndx) {
		case 0:
			p = "netbsd32_timespec50p_t";
			break;
		case 1:
			p = "lwpid_t";
			break;
		case 2:
			p = "netbsd32_voidp";
			break;
		case 3:
			p = "netbsd32_voidp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__lwp_unpark */
	case 321:
		switch(ndx) {
		case 0:
			p = "lwpid_t";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__lwp_unpark_all */
	case 322:
		switch(ndx) {
		case 0:
			p = "netbsd32_lwpidp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		case 2:
			p = "netbsd32_voidp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__lwp_setname */
	case 323:
		switch(ndx) {
		case 0:
			p = "lwpid_t";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__lwp_getname */
	case 324:
		switch(ndx) {
		case 0:
			p = "lwpid_t";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__lwp_ctl */
	case 325:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_pointer_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___sigaction_sigtramp */
	case 340:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_sigactionp_t";
			break;
		case 2:
			p = "netbsd32_sigactionp_t";
			break;
		case 3:
			p = "netbsd32_voidp";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_rasctl */
	case 343:
		switch(ndx) {
		case 0:
			p = "netbsd32_voidp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_kqueue */
	case 344:
		break;
	/* netbsd32_kevent */
	case 345:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_keventp_t";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		case 3:
			p = "netbsd32_keventp_t";
			break;
		case 4:
			p = "netbsd32_size_t";
			break;
		case 5:
			p = "netbsd32_timespec50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__sched_setparam */
	case 346:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "lwpid_t";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "const netbsd32_sched_paramp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__sched_getparam */
	case 347:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "lwpid_t";
			break;
		case 2:
			p = "netbsd32_intp";
			break;
		case 3:
			p = "netbsd32_sched_paramp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__sched_setaffinity */
	case 348:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "lwpid_t";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		case 3:
			p = "const netbsd32_cpusetp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__sched_getaffinity */
	case 349:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "lwpid_t";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		case 3:
			p = "netbsd32_cpusetp_t";
			break;
		default:
			break;
		};
		break;
	/* sys_sched_yield */
	case 350:
		break;
	/* netbsd32__sched_protect */
	case 351:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fsync_range */
	case 354:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_off_t";
			break;
		case 3:
			p = "netbsd32_off_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_uuidgen */
	case 355:
		switch(ndx) {
		case 0:
			p = "netbsd32_uuidp_t";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_getvfsstat */
	case 356:
		switch(ndx) {
		case 0:
			p = "netbsd32_statvfsp_t";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_statvfs1 */
	case 357:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_statvfsp_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fstatvfs1 */
	case 358:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_statvfsp_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fhstatvfs1 */
	case 359:
		switch(ndx) {
		case 0:
			p = "netbsd32_fhandlep_t";
			break;
		case 1:
			p = "netbsd32_statvfsp_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_extattrctl */
	case 360:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_charp";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_extattr_set_file */
	case 361:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_charp";
			break;
		case 3:
			p = "netbsd32_voidp";
			break;
		case 4:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_extattr_get_file */
	case 362:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_charp";
			break;
		case 3:
			p = "netbsd32_voidp";
			break;
		case 4:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_extattr_delete_file */
	case 363:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_extattr_set_fd */
	case 364:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_charp";
			break;
		case 3:
			p = "netbsd32_voidp";
			break;
		case 4:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_extattr_get_fd */
	case 365:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_charp";
			break;
		case 3:
			p = "netbsd32_voidp";
			break;
		case 4:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_extattr_delete_fd */
	case 366:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_extattr_set_link */
	case 367:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_charp";
			break;
		case 3:
			p = "netbsd32_voidp";
			break;
		case 4:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_extattr_get_link */
	case 368:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_charp";
			break;
		case 3:
			p = "netbsd32_voidp";
			break;
		case 4:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_extattr_delete_link */
	case 369:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_extattr_list_fd */
	case 370:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_voidp";
			break;
		case 3:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_extattr_list_file */
	case 371:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_voidp";
			break;
		case 3:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_extattr_list_link */
	case 372:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_voidp";
			break;
		case 3:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_pselect */
	case 373:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_fd_setp_t";
			break;
		case 2:
			p = "netbsd32_fd_setp_t";
			break;
		case 3:
			p = "netbsd32_fd_setp_t";
			break;
		case 4:
			p = "netbsd32_timespec50p_t";
			break;
		case 5:
			p = "netbsd32_sigsetp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_pollts */
	case 374:
		switch(ndx) {
		case 0:
			p = "netbsd32_pollfdp_t";
			break;
		case 1:
			p = "u_int";
			break;
		case 2:
			p = "netbsd32_timespec50p_t";
			break;
		case 3:
			p = "netbsd32_sigsetp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_setxattr */
	case 375:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_voidp";
			break;
		case 3:
			p = "netbsd32_size_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_lsetxattr */
	case 376:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_voidp";
			break;
		case 3:
			p = "netbsd32_size_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fsetxattr */
	case 377:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_voidp";
			break;
		case 3:
			p = "netbsd32_size_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_getxattr */
	case 378:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_voidp";
			break;
		case 3:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_lgetxattr */
	case 379:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_voidp";
			break;
		case 3:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fgetxattr */
	case 380:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_voidp";
			break;
		case 3:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_listxattr */
	case 381:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_llistxattr */
	case 382:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_flistxattr */
	case 383:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_removexattr */
	case 384:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_lremovexattr */
	case 385:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fremovexattr */
	case 386:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___stat30 */
	case 387:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_stat50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___fstat30 */
	case 388:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_stat50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___lstat30 */
	case 389:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_stat50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___getdents30 */
	case 390:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___fhstat30 */
	case 392:
		switch(ndx) {
		case 0:
			p = "netbsd32_fhandlep_t";
			break;
		case 1:
			p = "netbsd32_stat50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_ntp_gettime */
	case 393:
		switch(ndx) {
		case 0:
			p = "netbsd32_ntptimeval50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___socket30 */
	case 394:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___getfh30 */
	case 395:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_pointer_t";
			break;
		case 2:
			p = "netbsd32_size_tp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___fhopen40 */
	case 396:
		switch(ndx) {
		case 0:
			p = "netbsd32_pointer_t";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___fhstatvfs140 */
	case 397:
		switch(ndx) {
		case 0:
			p = "netbsd32_pointer_t";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		case 2:
			p = "netbsd32_statvfsp_t";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___fhstat40 */
	case 398:
		switch(ndx) {
		case 0:
			p = "netbsd32_pointer_t";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		case 2:
			p = "netbsd32_stat50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___mount50 */
	case 410:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "netbsd32_voidp";
			break;
		case 4:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_mremap */
	case 411:
		switch(ndx) {
		case 0:
			p = "netbsd32_voidp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		case 2:
			p = "netbsd32_voidp";
			break;
		case 3:
			p = "netbsd32_size_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_pset_create */
	case 412:
		switch(ndx) {
		case 0:
			p = "netbsd32_psetidp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_pset_destroy */
	case 413:
		switch(ndx) {
		case 0:
			p = "psetid_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_pset_assign */
	case 414:
		switch(ndx) {
		case 0:
			p = "psetid_t";
			break;
		case 1:
			p = "cpuid_t";
			break;
		case 2:
			p = "netbsd32_psetidp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__pset_bind */
	case 415:
		switch(ndx) {
		case 0:
			p = "idtype_t";
			break;
		case 1:
			p = "id_t";
			break;
		case 2:
			p = "id_t";
			break;
		case 3:
			p = "psetid_t";
			break;
		case 4:
			p = "netbsd32_psetidp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___posix_fadvise50 */
	case 416:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_off_t";
			break;
		case 3:
			p = "netbsd32_off_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___select50 */
	case 417:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_fd_setp_t";
			break;
		case 2:
			p = "netbsd32_fd_setp_t";
			break;
		case 3:
			p = "netbsd32_fd_setp_t";
			break;
		case 4:
			p = "netbsd32_timevalp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___gettimeofday50 */
	case 418:
		switch(ndx) {
		case 0:
			p = "netbsd32_timevalp_t";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___settimeofday50 */
	case 419:
		switch(ndx) {
		case 0:
			p = "const netbsd32_timevalp_t";
			break;
		case 1:
			p = "const netbsd32_voidp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___utimes50 */
	case 420:
		switch(ndx) {
		case 0:
			p = "const netbsd32_charp";
			break;
		case 1:
			p = "const netbsd32_timevalp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___adjtime50 */
	case 421:
		switch(ndx) {
		case 0:
			p = "const netbsd32_timevalp_t";
			break;
		case 1:
			p = "netbsd32_timevalp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___futimes50 */
	case 423:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const netbsd32_timevalp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___lutimes50 */
	case 424:
		switch(ndx) {
		case 0:
			p = "const netbsd32_charp";
			break;
		case 1:
			p = "const netbsd32_timevalp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___setitimer50 */
	case 425:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const netbsd32_itimervalp_t";
			break;
		case 2:
			p = "netbsd32_itimervalp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___getitimer50 */
	case 426:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_itimervalp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___clock_gettime50 */
	case 427:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "netbsd32_timespecp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___clock_settime50 */
	case 428:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "const netbsd32_timespecp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___clock_getres50 */
	case 429:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "netbsd32_timespecp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___nanosleep50 */
	case 430:
		switch(ndx) {
		case 0:
			p = "const netbsd32_timespecp_t";
			break;
		case 1:
			p = "netbsd32_timespecp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_____sigtimedwait50 */
	case 431:
		switch(ndx) {
		case 0:
			p = "const netbsd32_sigsetp_t";
			break;
		case 1:
			p = "netbsd32_siginfop_t";
			break;
		case 2:
			p = "netbsd32_timespecp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___mq_timedsend50 */
	case 432:
		switch(ndx) {
		case 0:
			p = "mqd_t";
			break;
		case 1:
			p = "const netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		case 3:
			p = "unsigned";
			break;
		case 4:
			p = "const netbsd32_timespecp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___mq_timedreceive50 */
	case 433:
		switch(ndx) {
		case 0:
			p = "mqd_t";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		case 3:
			p = "netbsd32_uintp";
			break;
		case 4:
			p = "const netbsd32_timespecp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32__lwp_park */
	case 434:
		switch(ndx) {
		case 0:
			p = "const netbsd32_timespecp_t";
			break;
		case 1:
			p = "lwpid_t";
			break;
		case 2:
			p = "const netbsd32_voidp";
			break;
		case 3:
			p = "const netbsd32_voidp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___kevent50 */
	case 435:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const netbsd32_keventp_t";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		case 3:
			p = "netbsd32_keventp_t";
			break;
		case 4:
			p = "netbsd32_size_t";
			break;
		case 5:
			p = "const netbsd32_timespecp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___pselect50 */
	case 436:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_fd_setp_t";
			break;
		case 2:
			p = "netbsd32_fd_setp_t";
			break;
		case 3:
			p = "netbsd32_fd_setp_t";
			break;
		case 4:
			p = "const netbsd32_timespecp_t";
			break;
		case 5:
			p = "const netbsd32_sigsetp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___pollts50 */
	case 437:
		switch(ndx) {
		case 0:
			p = "netbsd32_pollfdp_t";
			break;
		case 1:
			p = "u_int";
			break;
		case 2:
			p = "const netbsd32_timespecp_t";
			break;
		case 3:
			p = "const netbsd32_sigsetp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___stat50 */
	case 439:
		switch(ndx) {
		case 0:
			p = "const netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_statp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___fstat50 */
	case 440:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_statp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___lstat50 */
	case 441:
		switch(ndx) {
		case 0:
			p = "const netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_statp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_____semctl50 */
	case 442:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "netbsd32_semunp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___shmctl50 */
	case 443:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_shmid_dsp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___msgctl50 */
	case 444:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_msqid_dsp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___getrusage50 */
	case 445:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_rusagep_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___timer_settime50 */
	case 446:
		switch(ndx) {
		case 0:
			p = "timer_t";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const netbsd32_itimerspecp_t";
			break;
		case 3:
			p = "netbsd32_itimerspecp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___timer_gettime50 */
	case 447:
		switch(ndx) {
		case 0:
			p = "timer_t";
			break;
		case 1:
			p = "netbsd32_itimerspecp_t";
			break;
		default:
			break;
		};
		break;
#if defined(NTP) || !defined(_KERNEL_OPT)
	/* netbsd32___ntp_gettime50 */
	case 448:
		switch(ndx) {
		case 0:
			p = "netbsd32_ntptimevalp_t";
			break;
		default:
			break;
		};
		break;
#else
#endif
	/* netbsd32___wait450 */
	case 449:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_intp";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "netbsd32_rusagep_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___mknod50 */
	case 450:
		switch(ndx) {
		case 0:
			p = "const netbsd32_charp";
			break;
		case 1:
			p = "mode_t";
			break;
		case 2:
			p = "netbsd32_dev_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___fhstat50 */
	case 451:
		switch(ndx) {
		case 0:
			p = "const netbsd32_voidp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		case 2:
			p = "netbsd32_statp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_pipe2 */
	case 453:
		switch(ndx) {
		case 0:
			p = "netbsd32_intp";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_dup3 */
	case 454:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_kqueue1 */
	case 455:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_paccept */
	case 456:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_sockaddrp_t";
			break;
		case 2:
			p = "netbsd32_socklenp_t";
			break;
		case 3:
			p = "const netbsd32_sigsetp_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_linkat */
	case 457:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const netbsd32_charp";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "const netbsd32_charp";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_renameat */
	case 458:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const netbsd32_charp";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "const netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_mkfifoat */
	case 459:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const netbsd32_charp";
			break;
		case 2:
			p = "mode_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_mknodat */
	case 460:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const netbsd32_charp";
			break;
		case 2:
			p = "mode_t";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "netbsd32_dev_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_mkdirat */
	case 461:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const netbsd32_charp";
			break;
		case 2:
			p = "mode_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_faccessat */
	case 462:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const netbsd32_charp";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fchmodat */
	case 463:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const netbsd32_charp";
			break;
		case 2:
			p = "mode_t";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fchownat */
	case 464:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const netbsd32_charp";
			break;
		case 2:
			p = "uid_t";
			break;
		case 3:
			p = "gid_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fexecve */
	case 465:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charpp";
			break;
		case 2:
			p = "netbsd32_charpp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fstatat */
	case 466:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_statp_t";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_utimensat */
	case 467:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const netbsd32_charp";
			break;
		case 2:
			p = "const netbsd32_timespecp_t";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_openat */
	case 468:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const netbsd32_charp";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "mode_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_readlinkat */
	case 469:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_charp";
			break;
		case 3:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_symlinkat */
	case 470:
		switch(ndx) {
		case 0:
			p = "const netbsd32_charp";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_unlinkat */
	case 471:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const netbsd32_charp";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_futimens */
	case 472:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const netbsd32_timespecp_t";
			break;
		default:
			break;
		};
		break;
#if defined(QUOTA) || !defined(_KERNEL_OPT)
	/* netbsd32___quotactl */
	case 473:
		switch(ndx) {
		case 0:
			p = "const netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		default:
			break;
		};
		break;
#else
#endif
	/* netbsd32_posix_spawn */
	case 474:
		switch(ndx) {
		case 0:
			p = "netbsd32_pid_tp";
			break;
		case 1:
			p = "const netbsd32_charp";
			break;
		case 2:
			p = "const netbsd32_posix_spawn_file_actionsp";
			break;
		case 3:
			p = "const netbsd32_posix_spawnattrp";
			break;
		case 4:
			p = "netbsd32_charpp";
			break;
		case 5:
			p = "netbsd32_charpp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_recvmmsg */
	case 475:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_mmsghdrp_t";
			break;
		case 2:
			p = "unsigned int";
			break;
		case 3:
			p = "unsigned int";
			break;
		case 4:
			p = "netbsd32_timespecp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_sendmmsg */
	case 476:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_mmsghdrp_t";
			break;
		case 2:
			p = "unsigned int";
			break;
		case 3:
			p = "unsigned int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_clock_nanosleep */
	case 477:
		switch(ndx) {
		case 0:
			p = "netbsd32_clockid_t";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const netbsd32_timespecp_t";
			break;
		case 3:
			p = "netbsd32_timespecp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32____lwp_park60 */
	case 478:
		switch(ndx) {
		case 0:
			p = "netbsd32_clockid_t";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_timespecp_t";
			break;
		case 3:
			p = "lwpid_t";
			break;
		case 4:
			p = "netbsd32_voidp";
			break;
		case 5:
			p = "netbsd32_voidp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_posix_fallocate */
	case 479:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_off_t";
			break;
		case 3:
			p = "netbsd32_off_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fdiscard */
	case 480:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_off_t";
			break;
		case 3:
			p = "netbsd32_off_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_wait6 */
	case 481:
		switch(ndx) {
		case 0:
			p = "idtype_t";
			break;
		case 1:
			p = "id_t";
			break;
		case 2:
			p = "netbsd32_intp";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "netbsd32_wrusagep_t";
			break;
		case 5:
			p = "netbsd32_siginfop_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_clock_getcpuclockid2 */
	case 482:
		switch(ndx) {
		case 0:
			p = "idtype_t";
			break;
		case 1:
			p = "id_t";
			break;
		case 2:
			p = "netbsd32_clockidp_t";
			break;
		default:
			break;
		};
		break;
	default:
		break;
	};
	if (p != NULL)
		strlcpy(desc, p, descsz);
}
static void
systrace_return_setargdesc(int sysnum, int ndx, char *desc, size_t descsz)
{
	const char *p = NULL;
	switch (sysnum) {
	/* netbsd32_syscall */
	case 0:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_exit */
	case 1:
		if (ndx == 0 || ndx == 1)
			p = "void";
		break;
	/* sys_fork */
	case 2:
	/* netbsd32_read */
	case 3:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_ssize_t";
		break;
	/* netbsd32_write */
	case 4:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_ssize_t";
		break;
	/* netbsd32_open */
	case 5:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_close */
	case 6:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_wait4 */
	case 7:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_ocreat */
	case 8:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_link */
	case 9:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_unlink */
	case 10:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_chdir */
	case 12:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fchdir */
	case 13:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_mknod */
	case 14:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_chmod */
	case 15:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_chown */
	case 16:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_break */
	case 17:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_getfsstat */
	case 18:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_olseek */
	case 19:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_long";
		break;
	/* sys_getpid */
	case 20:
	/* netbsd32_mount */
	case 21:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_unmount */
	case 22:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_setuid */
	case 23:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getuid */
	case 24:
	/* sys_geteuid */
	case 25:
	/* netbsd32_ptrace */
	case 26:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_recvmsg */
	case 27:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_ssize_t";
		break;
	/* netbsd32_sendmsg */
	case 28:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_ssize_t";
		break;
	/* netbsd32_recvfrom */
	case 29:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_ssize_t";
		break;
	/* netbsd32_accept */
	case 30:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_getpeername */
	case 31:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_getsockname */
	case 32:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_access */
	case 33:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_chflags */
	case 34:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fchflags */
	case 35:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_sync */
	case 36:
	/* netbsd32_kill */
	case 37:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_stat43 */
	case 38:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getppid */
	case 39:
	/* netbsd32_lstat43 */
	case 40:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_dup */
	case 41:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_pipe */
	case 42:
	/* sys_getegid */
	case 43:
	/* netbsd32_profil */
	case 44:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_ktrace */
	case 45:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_sigaction */
	case 46:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getgid */
	case 47:
	/* netbsd32_sigprocmask */
	case 48:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___getlogin */
	case 49:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_setlogin */
	case 50:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_acct */
	case 51:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_sigpending */
	case 52:
	/* netbsd32_sigaltstack13 */
	case 53:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_ioctl */
	case 54:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_reboot */
	case 55:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_revoke */
	case 56:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_symlink */
	case 57:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_readlink */
	case 58:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_execve */
	case 59:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_umask */
	case 60:
		if (ndx == 0 || ndx == 1)
			p = "mode_t";
		break;
	/* netbsd32_chroot */
	case 61:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fstat43 */
	case 62:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_ogetkerninfo */
	case 63:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getpagesize */
	case 64:
	/* netbsd32_msync */
	case 65:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_vfork */
	case 66:
	/* netbsd32_ommap */
	case 71:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_ovadvise */
	case 72:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_munmap */
	case 73:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_mprotect */
	case 74:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_madvise */
	case 75:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_mincore */
	case 78:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_getgroups */
	case 79:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_setgroups */
	case 80:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getpgrp */
	case 81:
	/* netbsd32_setpgid */
	case 82:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_setitimer */
	case 83:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_wait */
	case 84:
	/* netbsd32_oswapon */
	case 85:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_getitimer */
	case 86:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_ogethostname */
	case 87:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_osethostname */
	case 88:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getdtablesize */
	case 89:
	/* netbsd32_dup2 */
	case 90:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fcntl */
	case 92:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_select */
	case 93:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fsync */
	case 95:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_setpriority */
	case 96:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_socket */
	case 97:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_connect */
	case 98:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_oaccept */
	case 99:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_getpriority */
	case 100:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_osend */
	case 101:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_orecv */
	case 102:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_sigreturn */
	case 103:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_bind */
	case 104:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_setsockopt */
	case 105:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_listen */
	case 106:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_osigvec */
	case 108:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_sigblock */
	case 109:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_sigsetmask */
	case 110:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_sigsuspend */
	case 111:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_osigstack */
	case 112:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_orecvmsg */
	case 113:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_osendmsg */
	case 114:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_gettimeofday */
	case 116:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_getrusage */
	case 117:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_getsockopt */
	case 118:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_readv */
	case 120:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_ssize_t";
		break;
	/* netbsd32_writev */
	case 121:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_ssize_t";
		break;
	/* netbsd32_settimeofday */
	case 122:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fchown */
	case 123:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fchmod */
	case 124:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_orecvfrom */
	case 125:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_setreuid */
	case 126:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_setregid */
	case 127:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_rename */
	case 128:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_otruncate */
	case 129:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_oftruncate */
	case 130:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_flock */
	case 131:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_mkfifo */
	case 132:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_sendto */
	case 133:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_ssize_t";
		break;
	/* netbsd32_shutdown */
	case 134:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_socketpair */
	case 135:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_mkdir */
	case 136:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_rmdir */
	case 137:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_utimes */
	case 138:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_adjtime */
	case 140:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_ogetpeername */
	case 141:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_gethostid */
	case 142:
	/* netbsd32_sethostid */
	case 143:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_ogetrlimit */
	case 144:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_osetrlimit */
	case 145:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_killpg */
	case 146:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_setsid */
	case 147:
#if defined(QUOTA) || !defined(_KERNEL_OPT)
	/* netbsd32_quotactl */
	case 148:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#else
#endif
	/* netbsd32_ogetsockname */
	case 150:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_nfssvc */
	case 155:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_ogetdirentries */
	case 156:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_statfs */
	case 157:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fstatfs */
	case 158:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_getfh */
	case 161:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_ogetdomainname */
	case 162:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_osetdomainname */
	case 163:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_uname */
	case 164:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_sysarch */
	case 165:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_semsys */
	case 169:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_msgsys */
	case 170:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_shmsys */
	case 171:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_pread */
	case 173:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_ssize_t";
		break;
	/* netbsd32_pwrite */
	case 174:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_ssize_t";
		break;
	/* netbsd32_ntp_gettime */
	case 175:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#if defined(NTP) || !defined(_KERNEL_OPT)
	/* netbsd32_ntp_adjtime */
	case 176:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#else
#endif
	/* netbsd32_setgid */
	case 181:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_setegid */
	case 182:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_seteuid */
	case 183:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_stat12 */
	case 188:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fstat12 */
	case 189:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_lstat12 */
	case 190:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_pathconf */
	case 191:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_long";
		break;
	/* netbsd32_fpathconf */
	case 192:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_long";
		break;
	/* netbsd32_getsockopt2 */
	case 193:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_getrlimit */
	case 194:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_setrlimit */
	case 195:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_getdirentries */
	case 196:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_mmap */
	case 197:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_voidp";
		break;
	/* netbsd32____syscall */
	case 198:
		if (ndx == 0 || ndx == 1)
			p = "quad_t";
		break;
	/* netbsd32_lseek */
	case 199:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_off_t";
		break;
	/* netbsd32_truncate */
	case 200:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_ftruncate */
	case 201:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___sysctl */
	case 202:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_mlock */
	case 203:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_munlock */
	case 204:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_undelete */
	case 205:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_futimes */
	case 206:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_getpgid */
	case 207:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_reboot */
	case 208:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_poll */
	case 209:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___semctl */
	case 220:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_semget */
	case 221:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_semop */
	case 222:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_semconfig */
	case 223:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_msgctl */
	case 224:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_msgget */
	case 225:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_msgsnd */
	case 226:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_msgrcv */
	case 227:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_ssize_t";
		break;
	/* netbsd32_shmat */
	case 228:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_voidp";
		break;
	/* netbsd32_shmctl */
	case 229:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_shmdt */
	case 230:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_shmget */
	case 231:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_clock_gettime */
	case 232:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_clock_settime */
	case 233:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_clock_getres */
	case 234:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_timer_create */
	case 235:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_timer_delete */
	case 236:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_timer_settime */
	case 237:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_timer_gettime */
	case 238:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_timer_getoverrun */
	case 239:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_nanosleep */
	case 240:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fdatasync */
	case 241:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_mlockall */
	case 242:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_munlockall */
	case 243:
	/* netbsd32___sigtimedwait */
	case 244:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_sigqueueinfo */
	case 245:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_modctl */
	case 246:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32__ksem_init */
	case 247:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32__ksem_open */
	case 248:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32__ksem_unlink */
	case 249:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32__ksem_close */
	case 250:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32__ksem_post */
	case 251:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32__ksem_wait */
	case 252:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32__ksem_trywait */
	case 253:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32__ksem_getvalue */
	case 254:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32__ksem_destroy */
	case 255:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32__ksem_timedwait */
	case 256:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_mq_open */
	case 257:
		if (ndx == 0 || ndx == 1)
			p = "mqd_t";
		break;
	/* netbsd32_mq_close */
	case 258:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_mq_unlink */
	case 259:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_mq_getattr */
	case 260:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_mq_setattr */
	case 261:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_mq_notify */
	case 262:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_mq_send */
	case 263:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_mq_receive */
	case 264:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_ssize_t";
		break;
	/* netbsd32_mq_timedsend */
	case 265:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_mq_timedreceive */
	case 266:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_ssize_t";
		break;
	/* netbsd32___posix_rename */
	case 270:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_swapctl */
	case 271:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_getdents */
	case 272:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_minherit */
	case 273:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_lchmod */
	case 274:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_lchown */
	case 275:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_lutimes */
	case 276:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___msync13 */
	case 277:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___stat13 */
	case 278:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___fstat13 */
	case 279:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___lstat13 */
	case 280:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___sigaltstack14 */
	case 281:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___vfork14 */
	case 282:
	/* netbsd32___posix_chown */
	case 283:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___posix_fchown */
	case 284:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___posix_lchown */
	case 285:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_getsid */
	case 286:
		if (ndx == 0 || ndx == 1)
			p = "pid_t";
		break;
	/* netbsd32___clone */
	case 287:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fktrace */
	case 288:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_preadv */
	case 289:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_ssize_t";
		break;
	/* netbsd32_pwritev */
	case 290:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_ssize_t";
		break;
	/* netbsd32___sigaction14 */
	case 291:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___sigpending14 */
	case 292:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___sigprocmask14 */
	case 293:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___sigsuspend14 */
	case 294:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___sigreturn14 */
	case 295:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___getcwd */
	case 296:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fchroot */
	case 297:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fhopen */
	case 298:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fhstat */
	case 299:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fhstatfs */
	case 300:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___semctl14 */
	case 301:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___msgctl13 */
	case 302:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___shmctl13 */
	case 303:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_lchflags */
	case 304:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_issetugid */
	case 305:
	/* netbsd32_utrace */
	case 306:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_getcontext */
	case 307:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_setcontext */
	case 308:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32__lwp_create */
	case 309:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__lwp_exit */
	case 310:
	/* sys__lwp_self */
	case 311:
	/* netbsd32__lwp_wait */
	case 312:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32__lwp_suspend */
	case 313:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32__lwp_continue */
	case 314:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32__lwp_wakeup */
	case 315:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__lwp_getprivate */
	case 316:
	/* netbsd32__lwp_setprivate */
	case 317:
		if (ndx == 0 || ndx == 1)
			p = "void";
		break;
	/* netbsd32__lwp_kill */
	case 318:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32__lwp_detach */
	case 319:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32__lwp_park */
	case 320:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32__lwp_unpark */
	case 321:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32__lwp_unpark_all */
	case 322:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_size_t";
		break;
	/* netbsd32__lwp_setname */
	case 323:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32__lwp_getname */
	case 324:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32__lwp_ctl */
	case 325:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___sigaction_sigtramp */
	case 340:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_rasctl */
	case 343:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_kqueue */
	case 344:
	/* netbsd32_kevent */
	case 345:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32__sched_setparam */
	case 346:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32__sched_getparam */
	case 347:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32__sched_setaffinity */
	case 348:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32__sched_getaffinity */
	case 349:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_sched_yield */
	case 350:
	/* netbsd32__sched_protect */
	case 351:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fsync_range */
	case 354:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_uuidgen */
	case 355:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_getvfsstat */
	case 356:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_statvfs1 */
	case 357:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fstatvfs1 */
	case 358:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fhstatvfs1 */
	case 359:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_extattrctl */
	case 360:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_extattr_set_file */
	case 361:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_extattr_get_file */
	case 362:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_extattr_delete_file */
	case 363:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_extattr_set_fd */
	case 364:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_extattr_get_fd */
	case 365:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_extattr_delete_fd */
	case 366:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_extattr_set_link */
	case 367:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_extattr_get_link */
	case 368:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_extattr_delete_link */
	case 369:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_extattr_list_fd */
	case 370:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_extattr_list_file */
	case 371:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_extattr_list_link */
	case 372:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_pselect */
	case 373:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_pollts */
	case 374:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_setxattr */
	case 375:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_lsetxattr */
	case 376:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fsetxattr */
	case 377:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_getxattr */
	case 378:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_lgetxattr */
	case 379:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fgetxattr */
	case 380:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_listxattr */
	case 381:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_llistxattr */
	case 382:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_flistxattr */
	case 383:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_removexattr */
	case 384:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_lremovexattr */
	case 385:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fremovexattr */
	case 386:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___stat30 */
	case 387:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___fstat30 */
	case 388:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___lstat30 */
	case 389:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___getdents30 */
	case 390:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___fhstat30 */
	case 392:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_ntp_gettime */
	case 393:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___socket30 */
	case 394:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___getfh30 */
	case 395:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___fhopen40 */
	case 396:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___fhstatvfs140 */
	case 397:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___fhstat40 */
	case 398:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___mount50 */
	case 410:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_mremap */
	case 411:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_voidp";
		break;
	/* netbsd32_pset_create */
	case 412:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_pset_destroy */
	case 413:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_pset_assign */
	case 414:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32__pset_bind */
	case 415:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___posix_fadvise50 */
	case 416:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___select50 */
	case 417:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___gettimeofday50 */
	case 418:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___settimeofday50 */
	case 419:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___utimes50 */
	case 420:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___adjtime50 */
	case 421:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___futimes50 */
	case 423:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___lutimes50 */
	case 424:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___setitimer50 */
	case 425:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___getitimer50 */
	case 426:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___clock_gettime50 */
	case 427:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___clock_settime50 */
	case 428:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___clock_getres50 */
	case 429:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___nanosleep50 */
	case 430:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_____sigtimedwait50 */
	case 431:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___mq_timedsend50 */
	case 432:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___mq_timedreceive50 */
	case 433:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_ssize_t";
		break;
	/* netbsd32__lwp_park */
	case 434:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___kevent50 */
	case 435:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___pselect50 */
	case 436:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___pollts50 */
	case 437:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___stat50 */
	case 439:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___fstat50 */
	case 440:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___lstat50 */
	case 441:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_____semctl50 */
	case 442:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___shmctl50 */
	case 443:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___msgctl50 */
	case 444:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___getrusage50 */
	case 445:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___timer_settime50 */
	case 446:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___timer_gettime50 */
	case 447:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#if defined(NTP) || !defined(_KERNEL_OPT)
	/* netbsd32___ntp_gettime50 */
	case 448:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#else
#endif
	/* netbsd32___wait450 */
	case 449:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___mknod50 */
	case 450:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___fhstat50 */
	case 451:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_pipe2 */
	case 453:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_dup3 */
	case 454:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_kqueue1 */
	case 455:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_paccept */
	case 456:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_linkat */
	case 457:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_renameat */
	case 458:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_mkfifoat */
	case 459:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_mknodat */
	case 460:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_mkdirat */
	case 461:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_faccessat */
	case 462:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fchmodat */
	case 463:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fchownat */
	case 464:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fexecve */
	case 465:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fstatat */
	case 466:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_utimensat */
	case 467:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_openat */
	case 468:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_readlinkat */
	case 469:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_ssize_t";
		break;
	/* netbsd32_symlinkat */
	case 470:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_unlinkat */
	case 471:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_futimens */
	case 472:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#if defined(QUOTA) || !defined(_KERNEL_OPT)
	/* netbsd32___quotactl */
	case 473:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#else
#endif
	/* netbsd32_posix_spawn */
	case 474:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_recvmmsg */
	case 475:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_sendmmsg */
	case 476:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_clock_nanosleep */
	case 477:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32____lwp_park60 */
	case 478:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_posix_fallocate */
	case 479:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fdiscard */
	case 480:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_wait6 */
	case 481:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_clock_getcpuclockid2 */
	case 482:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	default:
		break;
	};
	if (p != NULL)
		strlcpy(desc, p, descsz);
}
