/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.profile;

import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.DDLUtils;
import ca.sqlpower.architect.profile.AbstractProfileResult;
import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.architect.profile.ProfileSettings;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.NonBound;
import ca.sqlpower.object.annotation.NonProperty;
import ca.sqlpower.object.annotation.Transient;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.util.Monitorable;
import ca.sqlpower.util.MonitorableImpl;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class TableProfileResult
extends AbstractProfileResult<SQLTable> {
    public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.singletonList(ColumnProfileResult.class);
    private static final Logger logger = Logger.getLogger(TableProfileResult.class);
    private int rowCount;
    private List<ColumnProfileResult> columnProfileResults = new ArrayList<ColumnProfileResult>();
    private Monitorable progressMonitor = new MonitorableImpl();
    public static final String TOSTRING_FORMAT = "Rows: %d   %s   Time:  %s   Cols: %d/%d";

    @Constructor
    public TableProfileResult(@ConstructorParameter(propertyName="profiledObject") SQLTable profiledObject, @ConstructorParameter(propertyName="settings") ProfileSettings settings) {
        super(profiledObject);
        this.setName("New Table Profile");
        this.setSettings(settings);
    }

    public TableProfileResult(TableProfileResult tprToCopy, SQLTable table) throws SQLObjectException {
        super(tprToCopy, table);
        this.setName("New Table Profile");
        this.rowCount = tprToCopy.rowCount;
        this.progressMonitor = tprToCopy.progressMonitor;
        block0: for (SQLColumn col : table.getColumns()) {
            for (ColumnProfileResult cpr : tprToCopy.getColumnProfileResults()) {
                if (!((SQLColumn)cpr.getProfiledObject()).getUUID().equals(col.getUUID())) continue;
                this.addColumnProfileResult(new ColumnProfileResult(cpr, col));
                continue block0;
            }
        }
    }

    @Transient
    @Accessor
    public Monitorable getProgressMonitor() {
        return this.progressMonitor;
    }

    @Accessor
    public int getRowCount() {
        return this.rowCount;
    }

    @Mutator
    public void setRowCount(int rowCount) {
        int oldCount = this.rowCount;
        this.rowCount = rowCount;
        this.firePropertyChange("rowCount", oldCount, rowCount);
    }

    public String toString() {
        DateFormat df = DateFormat.getDateTimeInstance();
        Date date = new Date(this.getCreateStartTime());
        int successfulColCount = 0;
        for (ColumnProfileResult cpr : this.columnProfileResults) {
            if (cpr.getException() != null) continue;
            ++successfulColCount;
        }
        return String.format(TOSTRING_FORMAT, this.rowCount, df.format(date), this.formatCreateTime(), successfulColCount, this.columnProfileResults.size());
    }

    private String formatCreateTime() {
        long time = this.getTimeToCreate();
        if (time == 0L) {
            return "0 ms";
        }
        int[] timeValues = new int[6];
        int i = 5;
        timeValues[i--] = (int)time % 1000;
        timeValues[i--] = (int)(time /= 1000L) % 60;
        timeValues[i--] = (int)(time /= 60L) % 60;
        timeValues[i--] = (int)(time /= 60L) % 24;
        timeValues[i--] = (int)(time /= 24L) % 365;
        timeValues[i--] = (int)(time /= 365L);
        StringBuilder s = new StringBuilder();
        String[] timeUnits = new String[]{"yr", "day", "hr", "min", "sec", "ms"};
        for (int j = 0; j < 6; ++j) {
            if (timeValues[j] <= 0) continue;
            s.append(timeValues[j] + " " + timeUnits[j] + " ");
        }
        return s.toString();
    }

    @NonProperty
    public List<ColumnProfileResult> getColumnProfileResults() {
        return Collections.unmodifiableList(this.columnProfileResults);
    }

    @NonProperty
    public Collection<ColumnProfileResult> getColumnProfileResult(SQLColumn c) {
        ArrayList<ColumnProfileResult> retCollection = new ArrayList<ColumnProfileResult>();
        for (ColumnProfileResult result : this.columnProfileResults) {
            if (c != result.getProfiledObject()) continue;
            retCollection.add(result);
        }
        return retCollection;
    }

    @Transient
    @Accessor
    public DDLGenerator getDDLGenerator() throws SQLObjectException {
        JDBCDataSource ds = ((SQLTable)this.getProfiledObject()).getParentDatabase().getDataSource();
        try {
            return DDLUtils.createDDLGenerator(ds);
        }
        catch (InstantiationException ex) {
            throw new SQLObjectException("Couldn't create DDL Generator for data source " + ds, (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new SQLObjectException("Couldn't create DDL Generator for data source " + ds, (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            throw new SQLObjectException("Couldn't create DDL Generator for data source " + ds, (Throwable)ex);
        }
    }

    public void addColumnProfileResult(ColumnProfileResult profileResult) {
        this.addColumnProfileResult(profileResult, this.columnProfileResults.size());
    }

    protected void addChildImpl(SPObject child, int index) {
        if (!(child instanceof ColumnProfileResult)) {
            throw new IllegalArgumentException("Cannot handle children of type " + child.getClass() + " for object " + child);
        }
        this.addColumnProfileResult((ColumnProfileResult)child, index);
    }

    private void addColumnProfileResult(ColumnProfileResult child, int index) {
        this.columnProfileResults.add(child);
        child.setParent(this);
        this.fireChildAdded(ColumnProfileResult.class, child, index);
    }

    protected boolean removeChildImpl(SPObject child) {
        if (child instanceof ColumnProfileResult) {
            int index = this.columnProfileResults.indexOf(child);
            if (this.columnProfileResults.remove(child)) {
                this.fireChildRemoved(ColumnProfileResult.class, child, index);
                child.setParent(null);
            }
        }
        return false;
    }

    @NonBound
    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        return allowedChildTypes;
    }

    @NonProperty
    public List<? extends SPObject> getChildren() {
        ArrayList<ColumnProfileResult> children = new ArrayList<ColumnProfileResult>();
        children.addAll(this.columnProfileResults);
        return children;
    }
}

