/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.ruby;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.xml.Xpp3Dom;

class ConfigVisitor {
    final Config config = new Config();

    ConfigVisitor() {
    }

    void visit(Node node) {
        String[] stringArray = node.base.getAttributeNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            new Leaf("@" + name, node.base.getAttribute(name).replaceAll("'", "\\\\'")).accept(this);
            ++n2;
        }
        stringArray = node.base.getChildren();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String child = stringArray[n2];
            if (child.getChildCount() == 0 && child.getAttributeNames().length == 0) {
                new Leaf(child.getName(), child.getValue()).accept(this);
            } else if (child.getChildCount() > 1 && child.getChild(0).getName().equals(child.getChild(1).getName()) || child.getChildCount() == 1 && child.getName().equals(String.valueOf(child.getChild(0).getName()) + "s")) {
                new ListNode((Xpp3Dom)child).accept(this);
            } else {
                new Node((Xpp3Dom)child).accept(this);
            }
            ++n2;
        }
    }

    static class Config {
        Type type;
        String value;
        List<String> stringList;
        List<ListItem> list;
        List<Map<String, Config>> mapList;
        Map<String, Config> map;

        Config() {
        }

        void add(String value) {
            if (this.stringList != null) {
                this.stringList.add(value);
            } else if (this.value == null) {
                this.type = Type.SINGLE;
                this.value = value;
            } else {
                this.type = Type.MULTI;
                this.stringList = new LinkedList<String>();
                this.stringList.add(this.value);
                this.stringList.add(value);
                this.value = null;
            }
        }

        void add(Xpp3Dom item) {
            if (this.list == null) {
                this.type = Type.MIXED;
                this.list = new LinkedList<ListItem>();
            }
            if (item.getValue() == null) {
                this.list.add(new ListItem(item));
            } else {
                this.list.add(new ListItem(item.getValue()));
            }
        }

        void add(Map<String, Config> map) {
            if (this.mapList == null) {
                this.type = Type.MAPS;
                this.mapList = new LinkedList<Map<String, Config>>();
            }
            this.mapList.add(map);
        }

        void put(String name, Config config) {
            if (this.map == null) {
                this.type = Type.MAP;
                this.map = new LinkedHashMap<String, Config>();
            }
            this.map.put(name, config);
        }

        Config get(String name) {
            if (this.map == null) {
                this.type = Type.MAP;
                this.map = new LinkedHashMap<String, Config>();
            }
            if (this.map.containsKey(name)) {
                return this.map.get(name);
            }
            Config config = new Config();
            this.map.put(name, config);
            return config;
        }

        static enum Type {
            SINGLE,
            MULTI,
            MIXED,
            MAPS,
            MAP;

        }
    }

    static class Leaf {
        private String value;
        private String name;

        Leaf(String name, String value) {
            this.name = name;
            this.value = value;
        }

        void accept(ConfigVisitor visitor) {
            visitor.config.get(this.name).add(this.value);
        }
    }

    static class ListItem {
        final String xml;
        final String value;

        ListItem(String value) {
            this.value = value;
            this.xml = null;
        }

        ListItem(Xpp3Dom xml) {
            this.value = null;
            this.xml = xml.toString().replaceFirst("<?.*?>\\s*", "");
        }

        boolean isXml() {
            return this.xml != null;
        }

        public String toString() {
            return this.xml == null ? this.value : this.xml;
        }
    }

    static class ListNode
    extends Node {
        ListNode(Xpp3Dom base) {
            super(base);
        }

        @Override
        void accept(ConfigVisitor visitor) {
            if (this.base.getChild(0).getChildCount() == 0) {
                Config list = new Config();
                Xpp3Dom[] xpp3DomArray = this.base.getChildren();
                int n = xpp3DomArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Xpp3Dom child = xpp3DomArray[n2];
                    list.add(child);
                    ++n2;
                }
                visitor.config.put(this.base.getName(), list);
            } else {
                Config list = new Config();
                Xpp3Dom[] xpp3DomArray = this.base.getChildren();
                int n = xpp3DomArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Xpp3Dom child = xpp3DomArray[n3];
                    ConfigVisitor nextVisitor = new ConfigVisitor();
                    nextVisitor.visit(new Node(child));
                    list.add(nextVisitor.config.map);
                    ++n3;
                }
                visitor.config.put(this.base.getName(), list);
            }
        }
    }

    static class Node {
        Xpp3Dom base;

        Node(Xpp3Dom base) {
            this.base = base;
        }

        void accept(ConfigVisitor visitor) {
            ConfigVisitor nextVisitor = new ConfigVisitor();
            nextVisitor.visit(this);
            visitor.config.put(this.base.getName(), nextVisitor.config);
        }
    }
}

