/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.util;

import co.elastic.logstash.api.Password;
import org.logstash.RubyUtil;

public class CloudSettingAuth {
    private String original;
    private String username;
    private Password password;

    public CloudSettingAuth(String value) {
        if (value == null) {
            return;
        }
        this.original = value;
        String[] parts = this.original.split(":");
        if (parts.length != 2 || parts[0].isEmpty() || parts[1].isEmpty()) {
            throw RubyUtil.RUBY.newArgumentError("Cloud Auth username and password format should be \"<username>:<password>\".");
        }
        this.username = parts[0];
        this.password = new Password(parts[1]);
    }

    public String getOriginal() {
        return this.original;
    }

    public String getUsername() {
        return this.username;
    }

    public Password getPassword() {
        return this.password;
    }

    public String toString() {
        return String.join((CharSequence)":", this.username, this.password.toString());
    }
}

