/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkBufferImageCopy2;

public class VkCopyImageToBufferInfo2
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRCIMAGE;
    public static final int SRCIMAGELAYOUT;
    public static final int DSTBUFFER;
    public static final int REGIONCOUNT;
    public static final int PREGIONS;

    public VkCopyImageToBufferInfo2(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkCopyImageToBufferInfo2.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCopyImageToBufferInfo2.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCopyImageToBufferInfo2.npNext(this.address());
    }

    @NativeType(value="VkImage")
    public long srcImage() {
        return VkCopyImageToBufferInfo2.nsrcImage(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int srcImageLayout() {
        return VkCopyImageToBufferInfo2.nsrcImageLayout(this.address());
    }

    @NativeType(value="VkBuffer")
    public long dstBuffer() {
        return VkCopyImageToBufferInfo2.ndstBuffer(this.address());
    }

    @NativeType(value="uint32_t")
    public int regionCount() {
        return VkCopyImageToBufferInfo2.nregionCount(this.address());
    }

    @NativeType(value="VkBufferImageCopy2 const *")
    public VkBufferImageCopy2.Buffer pRegions() {
        return VkCopyImageToBufferInfo2.npRegions(this.address());
    }

    public VkCopyImageToBufferInfo2 sType(@NativeType(value="VkStructureType") int value) {
        VkCopyImageToBufferInfo2.nsType(this.address(), value);
        return this;
    }

    public VkCopyImageToBufferInfo2 sType$Default() {
        return this.sType(1000337003);
    }

    public VkCopyImageToBufferInfo2 pNext(@NativeType(value="void const *") long value) {
        VkCopyImageToBufferInfo2.npNext(this.address(), value);
        return this;
    }

    public VkCopyImageToBufferInfo2 srcImage(@NativeType(value="VkImage") long value) {
        VkCopyImageToBufferInfo2.nsrcImage(this.address(), value);
        return this;
    }

    public VkCopyImageToBufferInfo2 srcImageLayout(@NativeType(value="VkImageLayout") int value) {
        VkCopyImageToBufferInfo2.nsrcImageLayout(this.address(), value);
        return this;
    }

    public VkCopyImageToBufferInfo2 dstBuffer(@NativeType(value="VkBuffer") long value) {
        VkCopyImageToBufferInfo2.ndstBuffer(this.address(), value);
        return this;
    }

    public VkCopyImageToBufferInfo2 pRegions(@NativeType(value="VkBufferImageCopy2 const *") VkBufferImageCopy2.Buffer value) {
        VkCopyImageToBufferInfo2.npRegions(this.address(), value);
        return this;
    }

    public VkCopyImageToBufferInfo2 set(int sType, long pNext, long srcImage, int srcImageLayout, long dstBuffer, VkBufferImageCopy2.Buffer pRegions) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcImage(srcImage);
        this.srcImageLayout(srcImageLayout);
        this.dstBuffer(dstBuffer);
        this.pRegions(pRegions);
        return this;
    }

    public VkCopyImageToBufferInfo2 set(VkCopyImageToBufferInfo2 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkCopyImageToBufferInfo2 malloc() {
        return (VkCopyImageToBufferInfo2)VkCopyImageToBufferInfo2.wrap(VkCopyImageToBufferInfo2.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkCopyImageToBufferInfo2 calloc() {
        return (VkCopyImageToBufferInfo2)VkCopyImageToBufferInfo2.wrap(VkCopyImageToBufferInfo2.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkCopyImageToBufferInfo2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkCopyImageToBufferInfo2)VkCopyImageToBufferInfo2.wrap(VkCopyImageToBufferInfo2.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkCopyImageToBufferInfo2 create(long address) {
        return (VkCopyImageToBufferInfo2)VkCopyImageToBufferInfo2.wrap(VkCopyImageToBufferInfo2.class, (long)address);
    }

    @Nullable
    public static VkCopyImageToBufferInfo2 createSafe(long address) {
        return address == 0L ? null : (VkCopyImageToBufferInfo2)VkCopyImageToBufferInfo2.wrap(VkCopyImageToBufferInfo2.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkCopyImageToBufferInfo2.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkCopyImageToBufferInfo2.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkCopyImageToBufferInfo2.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCopyImageToBufferInfo2.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkCopyImageToBufferInfo2.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkCopyImageToBufferInfo2.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkCopyImageToBufferInfo2.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkCopyImageToBufferInfo2 malloc(MemoryStack stack) {
        return (VkCopyImageToBufferInfo2)VkCopyImageToBufferInfo2.wrap(VkCopyImageToBufferInfo2.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkCopyImageToBufferInfo2 calloc(MemoryStack stack) {
        return (VkCopyImageToBufferInfo2)VkCopyImageToBufferInfo2.wrap(VkCopyImageToBufferInfo2.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkCopyImageToBufferInfo2.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkCopyImageToBufferInfo2.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nsrcImage(long struct) {
        return UNSAFE.getLong(null, struct + (long)SRCIMAGE);
    }

    public static int nsrcImageLayout(long struct) {
        return UNSAFE.getInt(null, struct + (long)SRCIMAGELAYOUT);
    }

    public static long ndstBuffer(long struct) {
        return UNSAFE.getLong(null, struct + (long)DSTBUFFER);
    }

    public static int nregionCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)REGIONCOUNT);
    }

    public static VkBufferImageCopy2.Buffer npRegions(long struct) {
        return VkBufferImageCopy2.create(MemoryUtil.memGetAddress((long)(struct + (long)PREGIONS)), VkCopyImageToBufferInfo2.nregionCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nsrcImage(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SRCIMAGE, value);
    }

    public static void nsrcImageLayout(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SRCIMAGELAYOUT, value);
    }

    public static void ndstBuffer(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DSTBUFFER, value);
    }

    public static void nregionCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)REGIONCOUNT, value);
    }

    public static void npRegions(long struct, VkBufferImageCopy2.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PREGIONS), (long)value.address());
        VkCopyImageToBufferInfo2.nregionCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PREGIONS)));
    }

    static {
        Struct.Layout layout = VkCopyImageToBufferInfo2.__struct((Struct.Member[])new Struct.Member[]{VkCopyImageToBufferInfo2.__member((int)4), VkCopyImageToBufferInfo2.__member((int)POINTER_SIZE), VkCopyImageToBufferInfo2.__member((int)8), VkCopyImageToBufferInfo2.__member((int)4), VkCopyImageToBufferInfo2.__member((int)8), VkCopyImageToBufferInfo2.__member((int)4), VkCopyImageToBufferInfo2.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRCIMAGE = layout.offsetof(2);
        SRCIMAGELAYOUT = layout.offsetof(3);
        DSTBUFFER = layout.offsetof(4);
        REGIONCOUNT = layout.offsetof(5);
        PREGIONS = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkCopyImageToBufferInfo2, Buffer>
    implements NativeResource {
        private static final VkCopyImageToBufferInfo2 ELEMENT_FACTORY = VkCopyImageToBufferInfo2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkCopyImageToBufferInfo2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCopyImageToBufferInfo2.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCopyImageToBufferInfo2.npNext(this.address());
        }

        @NativeType(value="VkImage")
        public long srcImage() {
            return VkCopyImageToBufferInfo2.nsrcImage(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int srcImageLayout() {
            return VkCopyImageToBufferInfo2.nsrcImageLayout(this.address());
        }

        @NativeType(value="VkBuffer")
        public long dstBuffer() {
            return VkCopyImageToBufferInfo2.ndstBuffer(this.address());
        }

        @NativeType(value="uint32_t")
        public int regionCount() {
            return VkCopyImageToBufferInfo2.nregionCount(this.address());
        }

        @NativeType(value="VkBufferImageCopy2 const *")
        public VkBufferImageCopy2.Buffer pRegions() {
            return VkCopyImageToBufferInfo2.npRegions(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCopyImageToBufferInfo2.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000337003);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCopyImageToBufferInfo2.npNext(this.address(), value);
            return this;
        }

        public Buffer srcImage(@NativeType(value="VkImage") long value) {
            VkCopyImageToBufferInfo2.nsrcImage(this.address(), value);
            return this;
        }

        public Buffer srcImageLayout(@NativeType(value="VkImageLayout") int value) {
            VkCopyImageToBufferInfo2.nsrcImageLayout(this.address(), value);
            return this;
        }

        public Buffer dstBuffer(@NativeType(value="VkBuffer") long value) {
            VkCopyImageToBufferInfo2.ndstBuffer(this.address(), value);
            return this;
        }

        public Buffer pRegions(@NativeType(value="VkBufferImageCopy2 const *") VkBufferImageCopy2.Buffer value) {
            VkCopyImageToBufferInfo2.npRegions(this.address(), value);
            return this;
        }
    }
}

