/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.audio.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.OpenHAB;
import org.openhab.core.audio.AudioException;
import org.openhab.core.audio.AudioFormat;
import org.openhab.core.audio.AudioManager;
import org.openhab.core.audio.AudioSink;
import org.openhab.core.audio.AudioSource;
import org.openhab.core.audio.AudioStream;
import org.openhab.core.audio.FileAudioStream;
import org.openhab.core.audio.URLAudioStream;
import org.openhab.core.audio.utils.AudioWaveUtils;
import org.openhab.core.audio.utils.ToneSynthesizer;
import org.openhab.core.config.core.ConfigOptionProvider;
import org.openhab.core.config.core.ConfigurableService;
import org.openhab.core.config.core.ParameterOption;
import org.openhab.core.library.types.PercentType;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, configurationPid={"org.openhab.audio"}, property={"service.pid=org.openhab.audio"})
@ConfigurableService(category="system", label="Audio", description_uri="system:audio")
public class AudioManagerImpl
implements AudioManager,
ConfigOptionProvider {
    static final String CONFIG_URI = "system:audio";
    static final String CONFIG_DEFAULT_SINK = "defaultSink";
    static final String CONFIG_DEFAULT_SOURCE = "defaultSource";
    private final Logger logger = LoggerFactory.getLogger(AudioManagerImpl.class);
    private final Map<String, AudioSource> audioSources = new ConcurrentHashMap<String, AudioSource>();
    private final Map<String, AudioSink> audioSinks = new ConcurrentHashMap<String, AudioSink>();
    private @Nullable String defaultSource;
    private @Nullable String defaultSink;

    @Activate
    protected void activate(Map<String, Object> config) {
        this.modified(config);
    }

    @Deactivate
    protected void deactivate() {
    }

    @Modified
    void modified(@Nullable Map<String, Object> config) {
        if (config != null) {
            this.defaultSource = config.containsKey(CONFIG_DEFAULT_SOURCE) ? config.get(CONFIG_DEFAULT_SOURCE).toString() : null;
            this.defaultSink = config.containsKey(CONFIG_DEFAULT_SINK) ? config.get(CONFIG_DEFAULT_SINK).toString() : null;
        }
    }

    @Override
    public void play(@Nullable AudioStream audioStream) {
        this.play(audioStream, null);
    }

    @Override
    public void play(@Nullable AudioStream audioStream, @Nullable String sinkId) {
        this.play(audioStream, sinkId, null);
    }

    @Override
    public void play(@Nullable AudioStream audioStream, @Nullable String sinkId, @Nullable PercentType volume) {
        AudioSink sink = this.getSink(sinkId);
        if (sink != null) {
            Runnable restoreVolume = this.handleVolumeCommand(volume, sink);
            ((CompletableFuture)sink.processAndComplete(audioStream).exceptionally(exception -> {
                this.logger.warn("Error playing '{}': {}", new Object[]{audioStream, exception.getMessage(), exception});
                return null;
            })).thenRun(restoreVolume);
        } else {
            this.logger.warn("Failed playing audio stream '{}' as no audio sink was found.", (Object)audioStream);
        }
    }

    @Override
    public void playFile(String fileName) throws AudioException {
        this.playFile(fileName, null, null);
    }

    @Override
    public void playFile(String fileName, @Nullable PercentType volume) throws AudioException {
        this.playFile(fileName, null, volume);
    }

    @Override
    public void playFile(String fileName, @Nullable String sinkId) throws AudioException {
        this.playFile(fileName, sinkId, null);
    }

    @Override
    public void playFile(String fileName, @Nullable String sinkId, @Nullable PercentType volume) throws AudioException {
        Objects.requireNonNull(fileName, "File cannot be played as fileName is null.");
        File file = Path.of(OpenHAB.getConfigFolder(), "sounds", fileName).toFile();
        FileAudioStream is = new FileAudioStream(file);
        this.play(is, sinkId, volume);
    }

    @Override
    public void stream(@Nullable String url) throws AudioException {
        this.stream(url, null);
    }

    @Override
    public void stream(@Nullable String url, @Nullable String sinkId) throws AudioException {
        URLAudioStream audioStream = url != null ? new URLAudioStream(url) : null;
        this.play(audioStream, sinkId, null);
    }

    @Override
    public void playMelody(String melody) {
        this.playMelody(melody, null);
    }

    @Override
    public void playMelody(String melody, @Nullable String sinkId) {
        this.playMelody(melody, sinkId, null);
    }

    @Override
    public void playMelody(String melody, @Nullable String sinkId, @Nullable PercentType volume) {
        AudioSink sink = this.getSink(sinkId);
        if (sink == null) {
            this.logger.warn("Failed playing melody as no audio sink {} was found.", (Object)sinkId);
            return;
        }
        AudioFormat synthesizerFormat = AudioFormat.getBestMatch(ToneSynthesizer.getSupportedFormats(), sink.getSupportedFormats());
        if (synthesizerFormat == null) {
            this.logger.warn("Failed playing melody as sink {} does not support wav.", (Object)sinkId);
            return;
        }
        try {
            AudioStream audioStream = new ToneSynthesizer(synthesizerFormat).getStream(ToneSynthesizer.parseMelody(melody));
            this.play(audioStream, sinkId, volume);
        }
        catch (IOException | ParseException e) {
            this.logger.warn("Failed playing melody: {}", (Object)e.getMessage());
        }
    }

    @Override
    public void record(int seconds, String filename, @Nullable String sourceId) throws AudioException {
        ByteBuffer recordBuffer;
        javax.sound.sampled.AudioFormat jAudioFormat;
        block31: {
            AudioSource audioSource;
            AudioSource audioSource2 = audioSource = sourceId != null ? this.getSource(sourceId) : this.getSource();
            if (audioSource == null) {
                throw new AudioException("Audio source '" + (sourceId != null ? sourceId : "default") + "' not available");
            }
            AudioFormat audioFormat = AudioFormat.getBestMatch(audioSource.getSupportedFormats(), Set.of(AudioFormat.PCM_SIGNED, AudioFormat.WAV));
            if (audioFormat == null) {
                throw new AudioException("Unable to find valid audio format");
            }
            jAudioFormat = new javax.sound.sampled.AudioFormat(Objects.requireNonNull(audioFormat.getFrequency()).longValue(), Objects.requireNonNull(audioFormat.getBitDepth()), Objects.requireNonNull(audioFormat.getChannels()), true, false);
            int secondByteLength = (int)jAudioFormat.getSampleRate() * jAudioFormat.getFrameSize();
            int targetByteLength = secondByteLength * seconds;
            recordBuffer = ByteBuffer.allocate(targetByteLength);
            try {
                Throwable throwable = null;
                Object var11_13 = null;
                try (AudioStream audioStream = audioSource.getInputStream(audioFormat);){
                    if (audioFormat.isCompatible(AudioFormat.WAV)) {
                        AudioWaveUtils.removeFMT(audioStream);
                    }
                    while (true) {
                        try {
                            while (true) {
                                byte[] bytes;
                                if ((bytes = audioStream.readNBytes(secondByteLength)).length == 0) {
                                    this.logger.debug("End of input audio stream reached");
                                    break block31;
                                }
                                if (recordBuffer.position() + bytes.length > recordBuffer.limit()) {
                                    this.logger.debug("Recording limit reached");
                                    break block31;
                                }
                                recordBuffer.put(bytes);
                            }
                        }
                        catch (IOException e) {
                            this.logger.warn("Reading audio data failed");
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.logger.warn("IOException while reading audioStream: {}", (Object)e.getMessage());
            }
        }
        Object recordFilename = filename.endsWith(".wav") ? filename : filename + ".wav";
        this.logger.info("Saving record file: {}", recordFilename);
        byte[] audioBytes = new byte[recordBuffer.position()];
        this.logger.info("Saving bytes: {}", (Object)audioBytes.length);
        recordBuffer.rewind();
        recordBuffer.get(audioBytes);
        File recordFile = new File(OpenHAB.getConfigFolder() + File.separator + "sounds" + File.separator + (String)recordFilename);
        try {
            Throwable e = null;
            Object var14_20 = null;
            try (FileOutputStream fileOutputStream = new FileOutputStream(recordFile);){
                AudioSystem.write(new AudioInputStream(new ByteArrayInputStream(audioBytes), jAudioFormat, (long)Math.ceil((double)audioBytes.length / (double)jAudioFormat.getFrameSize())), AudioFileFormat.Type.WAVE, fileOutputStream);
                fileOutputStream.flush();
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            this.logger.warn("IOException while saving record file: {}", (Object)e.getMessage());
        }
    }

    @Override
    public PercentType getVolume(@Nullable String sinkId) throws IOException {
        AudioSink sink = this.getSink(sinkId);
        if (sink != null) {
            return sink.getVolume();
        }
        return PercentType.ZERO;
    }

    @Override
    public void setVolume(PercentType volume, @Nullable String sinkId) throws IOException {
        AudioSink sink = this.getSink(sinkId);
        if (sink != null) {
            sink.setVolume(volume);
        }
    }

    @Override
    public @Nullable String getSourceId() {
        return this.defaultSource;
    }

    @Override
    public @Nullable AudioSource getSource() {
        AudioSource source = null;
        if (this.defaultSource != null) {
            source = this.audioSources.get(this.defaultSource);
            if (source == null) {
                this.logger.warn("Default AudioSource service '{}' not available!", (Object)this.defaultSource);
            }
        } else if (!this.audioSources.isEmpty()) {
            source = this.audioSources.values().iterator().next();
        } else {
            this.logger.debug("No AudioSource service available!");
        }
        return source;
    }

    @Override
    public Set<AudioSource> getAllSources() {
        return new HashSet<AudioSource>(this.audioSources.values());
    }

    @Override
    public @Nullable AudioSource getSource(@Nullable String sourceId) {
        return sourceId == null ? this.getSource() : this.audioSources.get(sourceId);
    }

    @Override
    public Set<String> getSourceIds(String pattern) {
        String regex = pattern.replace("?", ".?").replace("*", ".*?");
        HashSet<String> matchedSources = new HashSet<String>();
        for (String aSource : this.audioSources.keySet()) {
            if (!aSource.matches(regex)) continue;
            matchedSources.add(aSource);
        }
        return matchedSources;
    }

    @Override
    public @Nullable String getSinkId() {
        return this.defaultSink;
    }

    @Override
    public @Nullable AudioSink getSink() {
        AudioSink sink = null;
        if (this.defaultSink != null) {
            sink = this.audioSinks.get(this.defaultSink);
            if (sink == null) {
                this.logger.warn("Default AudioSink service '{}' not available!", (Object)this.defaultSink);
            }
        } else if (!this.audioSinks.isEmpty()) {
            sink = this.audioSinks.values().iterator().next();
        } else {
            this.logger.debug("No AudioSink service available!");
        }
        return sink;
    }

    @Override
    public Set<AudioSink> getAllSinks() {
        return new HashSet<AudioSink>(this.audioSinks.values());
    }

    @Override
    public @Nullable AudioSink getSink(@Nullable String sinkId) {
        return sinkId == null ? this.getSink() : this.audioSinks.get(sinkId);
    }

    @Override
    public Set<String> getSinkIds(String pattern) {
        String regex = pattern.replace("?", ".?").replace("*", ".*?");
        HashSet<String> matchedSinkIds = new HashSet<String>();
        for (String sinkId : this.audioSinks.keySet()) {
            if (!sinkId.matches(regex)) continue;
            matchedSinkIds.add(sinkId);
        }
        return matchedSinkIds;
    }

    public @Nullable Collection<ParameterOption> getParameterOptions(URI uri, String param, @Nullable String context, @Nullable Locale locale) {
        if (CONFIG_URI.equals(uri.toString())) {
            Locale safeLocale;
            Locale locale2 = safeLocale = locale != null ? locale : Locale.getDefault();
            if (CONFIG_DEFAULT_SOURCE.equals(param)) {
                return this.audioSources.values().stream().sorted(Comparator.comparing(s -> s.getLabel(safeLocale))).map(s -> new ParameterOption(s.getId(), s.getLabel(safeLocale))).toList();
            }
            if (CONFIG_DEFAULT_SINK.equals(param)) {
                return this.audioSinks.values().stream().sorted(Comparator.comparing(s -> s.getLabel(safeLocale))).map(s -> new ParameterOption(s.getId(), s.getLabel(safeLocale))).toList();
            }
        }
        return null;
    }

    @Override
    public Runnable handleVolumeCommand(@Nullable PercentType volume, AudioSink sink) {
        boolean volumeChanged = false;
        PercentType oldVolume = null;
        Runnable toRunWhenProcessFinished = () -> {};
        if (volume == null) {
            return toRunWhenProcessFinished;
        }
        try {
            oldVolume = sink.getVolume();
        }
        catch (IOException | UnsupportedOperationException e) {
            this.logger.debug("An exception occurred while getting the volume of sink '{}' : {}", new Object[]{sink.getId(), e.getMessage(), e});
        }
        if (!volume.equals((Object)oldVolume) || oldVolume == null) {
            try {
                sink.setVolume(volume);
                volumeChanged = true;
            }
            catch (IOException | UnsupportedOperationException e) {
                this.logger.debug("An exception occurred while setting the volume of sink '{}' : {}", new Object[]{sink.getId(), e.getMessage(), e});
            }
        }
        PercentType oldVolumeFinal = oldVolume;
        if (volumeChanged && oldVolumeFinal != null) {
            toRunWhenProcessFinished = () -> {
                try {
                    sink.setVolume(oldVolumeFinal);
                }
                catch (IOException | UnsupportedOperationException e) {
                    this.logger.debug("An exception occurred while setting the volume of sink '{}' : {}", new Object[]{sink.getId(), e.getMessage(), e});
                }
            };
        }
        return toRunWhenProcessFinished;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addAudioSource(AudioSource audioSource) {
        this.audioSources.put(audioSource.getId(), audioSource);
    }

    protected void removeAudioSource(AudioSource audioSource) {
        this.audioSources.remove(audioSource.getId());
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addAudioSink(AudioSink audioSink) {
        this.audioSinks.put(audioSink.getId(), audioSink);
    }

    protected void removeAudioSink(AudioSink audioSink) {
        this.audioSinks.remove(audioSink.getId());
    }
}

