/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.reporting;

import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.interfaces.DiagnosticRelatedInformation;
import dotty.tools.dotc.interfaces.SourcePosition;
import dotty.tools.dotc.reporting.Diagnostic$;
import dotty.tools.dotc.reporting.Message;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import scala.Function0;
import scala.Function1;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.util.ChainingOps$;
import scala.util.package;

public class Diagnostic
implements dotty.tools.dotc.interfaces.Diagnostic {
    private final Message msg;
    private final dotty.tools.dotc.util.SourcePosition pos;
    private final int level;
    private boolean verbose;

    public static boolean shouldExplain(Diagnostic diagnostic, Contexts.Context context) {
        return Diagnostic$.MODULE$.shouldExplain(diagnostic, context);
    }

    public Diagnostic(Message msg, dotty.tools.dotc.util.SourcePosition pos, int level) {
        this.msg = msg;
        this.pos = pos;
        this.level = level;
        this.verbose = false;
    }

    public Message msg() {
        return this.msg;
    }

    public dotty.tools.dotc.util.SourcePosition pos() {
        return this.pos;
    }

    public int level() {
        return this.level;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public Diagnostic setVerbose() {
        this.verbose = true;
        return this;
    }

    public Optional<SourcePosition> position() {
        if (this.pos().exists() && this.pos().source().exists()) {
            return Optional.of(this.pos());
        }
        return Optional.empty();
    }

    public String message() {
        return this.msg().message().replaceAll("\u001b\\[[;\\d]*m", "");
    }

    public List<DiagnosticRelatedInformation> diagnosticRelatedInformation() {
        return Collections.emptyList();
    }

    public String toString() {
        return new StringBuilder(6).append(this.getClass()).append(" at ").append(this.pos()).append(": ").append(this.message()).toString();
    }

    public static abstract class ConditionalWarning
    extends Warning {
        public ConditionalWarning(Message msg, dotty.tools.dotc.util.SourcePosition pos) {
            super(msg, pos);
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }

        public abstract Settings.Setting<Object> enablingOption(Contexts.Context var1);

        @Override
        public boolean isSummarizedConditional(Contexts.Context x$1) {
            return !BoxesRunTime.unboxToBoolean((Object)Settings$Setting$.MODULE$.value(this.enablingOption(x$1), x$1));
        }
    }

    public static class DeprecationWarning
    extends ConditionalWarning {
        private final String origin;

        public DeprecationWarning(Message msg, dotty.tools.dotc.util.SourcePosition pos, String origin) {
            this.origin = origin;
            super(msg, pos);
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }

        public String origin() {
            return this.origin;
        }

        @Override
        public Settings.Setting<Object> enablingOption(Contexts.Context x$1) {
            return x$1.settings().deprecation();
        }
    }

    public static class Error
    extends Diagnostic {
        public Error(Message msg, dotty.tools.dotc.util.SourcePosition pos) {
            super(msg, pos, 2);
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }

        public Error(Function0<String> str, dotty.tools.dotc.util.SourcePosition pos) {
            this(Decorators$.MODULE$.toMessage(str), pos);
        }
    }

    public static class FeatureWarning
    extends ConditionalWarning {
        public FeatureWarning(Message msg, dotty.tools.dotc.util.SourcePosition pos) {
            super(msg, pos);
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }

        @Override
        public Settings.Setting<Object> enablingOption(Contexts.Context x$1) {
            return x$1.settings().feature();
        }
    }

    public static class Info
    extends Diagnostic {
        public Info(Message msg, dotty.tools.dotc.util.SourcePosition pos) {
            super(msg, pos, 0);
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }

        public Info(Function0<String> str, dotty.tools.dotc.util.SourcePosition pos) {
            this(Decorators$.MODULE$.toMessage(str), pos);
        }
    }

    public static class MigrationWarning
    extends Warning {
        public MigrationWarning(Message msg, dotty.tools.dotc.util.SourcePosition pos) {
            super(msg, pos);
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }
    }

    public static class StickyError
    extends Error {
        public StickyError(Message msg, dotty.tools.dotc.util.SourcePosition pos) {
            super(msg, pos);
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }
    }

    public static class UncheckedWarning
    extends ConditionalWarning {
        public UncheckedWarning(Message msg, dotty.tools.dotc.util.SourcePosition pos) {
            super(msg, pos);
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }

        @Override
        public Settings.Setting<Object> enablingOption(Contexts.Context x$1) {
            return x$1.settings().unchecked();
        }
    }

    public static class Warning
    extends Diagnostic {
        public Warning(Message msg, dotty.tools.dotc.util.SourcePosition pos) {
            super(msg, pos, 1);
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }

        public Error toError() {
            Error error = (Error)package.chaining$.MODULE$.scalaUtilChainingOps((Object)new Error(this.msg$accessor(), this.pos$accessor()));
            return (Error)ChainingOps$.MODULE$.tap$extension((Object)error, (Function1)(JProcedure1 & Serializable)e -> {
                if (this.isVerbose()) {
                    e.setVerbose();
                    return;
                }
            });
        }

        public Info toInfo() {
            Info info = (Info)package.chaining$.MODULE$.scalaUtilChainingOps((Object)new Info(this.msg$accessor(), this.pos$accessor()));
            return (Info)ChainingOps$.MODULE$.tap$extension((Object)info, (Function1)(JProcedure1 & Serializable)e -> {
                if (this.isVerbose()) {
                    e.setVerbose();
                    return;
                }
            });
        }

        public boolean isSummarizedConditional(Contexts.Context x$1) {
            return false;
        }
    }
}

