/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.interpolation;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Notifier;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryBase;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.Resource;
import org.apache.maven.model.Scm;
import org.apache.maven.model.Site;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.interpolation.AbstractStringBasedModelInterpolator;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Named
@Singleton
public class StringVisitorModelInterpolator
extends AbstractStringBasedModelInterpolator {
    @Override
    public Model interpolateModel(Model model, File projectDir, ModelBuildingRequest config2, ModelProblemCollector problems) {
        List<ValueSource> valueSources = this.createValueSources(model, projectDir, config2, problems);
        List<? extends InterpolationPostProcessor> postProcessors = this.createPostProcessors(model, projectDir, config2);
        InnerInterpolator innerInterpolator = this.createInterpolator(valueSources, postProcessors, problems);
        new ModelVisitor(innerInterpolator).visit(model);
        return model;
    }

    private InnerInterpolator createInterpolator(List<? extends ValueSource> valueSources, List<? extends InterpolationPostProcessor> postProcessors, final ModelProblemCollector problems) {
        final HashMap cache2 = new HashMap();
        final StringSearchInterpolator interpolator = new StringSearchInterpolator();
        interpolator.setCacheAnswers(true);
        for (ValueSource valueSource : valueSources) {
            interpolator.addValueSource(valueSource);
        }
        for (InterpolationPostProcessor interpolationPostProcessor : postProcessors) {
            interpolator.addPostProcessor(interpolationPostProcessor);
        }
        final RecursionInterceptor recursionInterceptor = this.createRecursionInterceptor();
        return new InnerInterpolator(){

            @Override
            public String interpolate(String value) {
                if (value != null && value.contains("${")) {
                    String c = (String)cache2.get(value);
                    if (c == null) {
                        try {
                            c = interpolator.interpolate(value, recursionInterceptor);
                        }
                        catch (InterpolationException e2) {
                            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage(e2.getMessage()).setException(e2));
                        }
                        cache2.put(value, c);
                    }
                    return c;
                }
                return value;
            }
        };
    }

    private static final class ModelVisitor {
        private final InnerInterpolator interpolator;

        ModelVisitor(InnerInterpolator interpolator) {
            this.interpolator = interpolator;
        }

        void visit(Model model) {
            if (model != null) {
                String intInceptionYear;
                String orgInceptionYear;
                String intChildProjectUrlInheritAppendPath;
                String orgChildProjectUrlInheritAppendPath;
                String intUrl;
                String orgUrl;
                String intDescription;
                String orgDescription;
                String intName;
                String orgName;
                String intPackaging;
                String orgPackaging;
                String intVersion;
                String orgVersion;
                String intArtifactId;
                String orgArtifactId;
                this.visit((ModelBase)model);
                String orgModelVersion = model.getModelVersion();
                String intModelVersion = this.interpolate(orgModelVersion);
                if (orgModelVersion != intModelVersion) {
                    model.setModelVersion(intModelVersion);
                }
                this.visit(model.getParent());
                String orgGroupId = model.getGroupId();
                String intGroupId = this.interpolate(orgGroupId);
                if (orgGroupId != intGroupId) {
                    model.setGroupId(intGroupId);
                }
                if ((orgArtifactId = model.getArtifactId()) != (intArtifactId = this.interpolate(orgArtifactId))) {
                    model.setArtifactId(intArtifactId);
                }
                if ((orgVersion = model.getVersion()) != (intVersion = this.interpolate(orgVersion))) {
                    model.setVersion(intVersion);
                }
                if ((orgPackaging = model.getPackaging()) != (intPackaging = this.interpolate(orgPackaging))) {
                    model.setPackaging(intPackaging);
                }
                if ((orgName = model.getName()) != (intName = this.interpolate(orgName))) {
                    model.setName(intName);
                }
                if ((orgDescription = model.getDescription()) != (intDescription = this.interpolate(orgDescription))) {
                    model.setDescription(intDescription);
                }
                if ((orgUrl = model.getUrl()) != (intUrl = this.interpolate(orgUrl))) {
                    model.setUrl(intUrl);
                }
                if ((orgChildProjectUrlInheritAppendPath = model.getChildProjectUrlInheritAppendPath()) != (intChildProjectUrlInheritAppendPath = this.interpolate(orgChildProjectUrlInheritAppendPath))) {
                    model.setChildProjectUrlInheritAppendPath(intChildProjectUrlInheritAppendPath);
                }
                if ((orgInceptionYear = model.getInceptionYear()) != (intInceptionYear = this.interpolate(orgInceptionYear))) {
                    model.setInceptionYear(intInceptionYear);
                }
                this.visit(model.getOrganization());
                for (License license : model.getLicenses()) {
                    this.visit(license);
                }
                for (Developer developer : model.getDevelopers()) {
                    this.visit(developer);
                }
                for (Contributor contributor : model.getContributors()) {
                    this.visit(contributor);
                }
                for (MailingList mailingList : model.getMailingLists()) {
                    this.visit(mailingList);
                }
                this.visit(model.getPrerequisites());
                this.visit(model.getScm());
                this.visit(model.getIssueManagement());
                this.visit(model.getCiManagement());
                this.visit(model.getBuild());
                for (Profile profile : model.getProfiles()) {
                    this.visit(profile);
                }
            }
        }

        private void visit(Parent parent) {
            if (parent != null) {
                String val2;
                String org = parent.getGroupId();
                if (org != (val2 = this.interpolate(org))) {
                    parent.setGroupId(val2);
                }
                if ((org = parent.getArtifactId()) != (val2 = this.interpolate(org))) {
                    parent.setArtifactId(val2);
                }
                if ((org = parent.getVersion()) != (val2 = this.interpolate(org))) {
                    parent.setVersion(val2);
                }
                if ((org = parent.getRelativePath()) != (val2 = this.interpolate(org))) {
                    parent.setRelativePath(val2);
                }
            }
        }

        private void visit(Organization organization) {
            if (organization != null) {
                String val2;
                String org = organization.getName();
                if (org != (val2 = this.interpolate(org))) {
                    organization.setName(val2);
                }
                if ((org = organization.getUrl()) != (val2 = this.interpolate(org))) {
                    organization.setUrl(val2);
                }
            }
        }

        private void visit(License license) {
            if (license != null) {
                String val2;
                String org = license.getName();
                if (org != (val2 = this.interpolate(org))) {
                    license.setName(val2);
                }
                if ((org = license.getUrl()) != (val2 = this.interpolate(org))) {
                    license.setUrl(val2);
                }
                if ((org = license.getDistribution()) != (val2 = this.interpolate(org))) {
                    license.setDistribution(val2);
                }
                if ((org = license.getComments()) != (val2 = this.interpolate(org))) {
                    license.setComments(val2);
                }
            }
        }

        private void visit(Developer developer) {
            if (developer != null) {
                this.visit((Contributor)developer);
                String org = developer.getId();
                String val2 = this.interpolate(org);
                if (org != val2) {
                    developer.setId(val2);
                }
            }
        }

        private void visit(Contributor contributor) {
            if (contributor != null) {
                String val2;
                String org = contributor.getName();
                if (org != (val2 = this.interpolate(org))) {
                    contributor.setName(val2);
                }
                if ((org = contributor.getEmail()) != (val2 = this.interpolate(org))) {
                    contributor.setEmail(val2);
                }
                if ((org = contributor.getUrl()) != (val2 = this.interpolate(org))) {
                    contributor.setUrl(val2);
                }
                if ((org = contributor.getOrganization()) != (val2 = this.interpolate(org))) {
                    contributor.setOrganization(val2);
                }
                if ((org = contributor.getOrganizationUrl()) != (val2 = this.interpolate(org))) {
                    contributor.setOrganizationUrl(val2);
                }
                this.visit(contributor.getRoles());
            }
        }

        private void visit(MailingList mailingList) {
            if (mailingList != null) {
                String val2;
                String org = mailingList.getName();
                if (org != (val2 = this.interpolate(org))) {
                    mailingList.setName(val2);
                }
                if ((org = mailingList.getSubscribe()) != (val2 = this.interpolate(org))) {
                    mailingList.setSubscribe(val2);
                }
                if ((org = mailingList.getUnsubscribe()) != (val2 = this.interpolate(org))) {
                    mailingList.setUnsubscribe(val2);
                }
                if ((org = mailingList.getPost()) != (val2 = this.interpolate(org))) {
                    mailingList.setPost(val2);
                }
                if ((org = mailingList.getArchive()) != (val2 = this.interpolate(org))) {
                    mailingList.setArchive(val2);
                }
            }
        }

        private void visit(Prerequisites prerequisites) {
            String val2;
            String org;
            if (prerequisites != null && (org = prerequisites.getMaven()) != (val2 = this.interpolate(org))) {
                prerequisites.setMaven(val2);
            }
        }

        private void visit(Scm scm) {
            if (scm != null) {
                String val2;
                String org = scm.getConnection();
                if (org != (val2 = this.interpolate(org))) {
                    scm.setConnection(val2);
                }
                if ((org = scm.getDeveloperConnection()) != (val2 = this.interpolate(org))) {
                    scm.setDeveloperConnection(val2);
                }
                if ((org = scm.getTag()) != (val2 = this.interpolate(org))) {
                    scm.setTag(val2);
                }
                if ((org = scm.getUrl()) != (val2 = this.interpolate(org))) {
                    scm.setUrl(val2);
                }
                if ((org = scm.getChildScmConnectionInheritAppendPath()) != (val2 = this.interpolate(org))) {
                    scm.setChildScmConnectionInheritAppendPath(val2);
                }
                if ((org = scm.getChildScmDeveloperConnectionInheritAppendPath()) != (val2 = this.interpolate(org))) {
                    scm.setChildScmDeveloperConnectionInheritAppendPath(val2);
                }
                if ((org = scm.getChildScmUrlInheritAppendPath()) != (val2 = this.interpolate(org))) {
                    scm.setChildScmUrlInheritAppendPath(val2);
                }
            }
        }

        private void visit(IssueManagement issueManagement) {
            if (issueManagement != null) {
                String val2;
                String org = issueManagement.getSystem();
                if (org != (val2 = this.interpolate(org))) {
                    issueManagement.setSystem(val2);
                }
                if ((org = issueManagement.getUrl()) != (val2 = this.interpolate(org))) {
                    issueManagement.setUrl(val2);
                }
            }
        }

        private void visit(CiManagement ciManagement) {
            if (ciManagement != null) {
                String val2;
                String org = ciManagement.getSystem();
                if (org != (val2 = this.interpolate(org))) {
                    ciManagement.setSystem(val2);
                }
                if ((org = ciManagement.getUrl()) != (val2 = this.interpolate(org))) {
                    ciManagement.setUrl(val2);
                }
                for (Notifier notifier : ciManagement.getNotifiers()) {
                    this.visit(notifier);
                }
            }
        }

        private void visit(Notifier notifier) {
            if (notifier != null) {
                String val2;
                String org = notifier.getType();
                if (org != (val2 = this.interpolate(org))) {
                    notifier.setType(val2);
                }
                this.visit(notifier.getConfiguration());
            }
        }

        private void visit(BuildBase build) {
            if (build != null) {
                for (Plugin plugin : build.getPlugins()) {
                    this.visit(plugin);
                }
                this.visit(build.getPluginManagement());
                String org = build.getDefaultGoal();
                String val2 = this.interpolate(org);
                if (org != val2) {
                    build.setDefaultGoal(val2);
                }
                for (Resource resource2 : build.getResources()) {
                    this.visit(resource2);
                }
                for (Resource resource2 : build.getTestResources()) {
                    this.visit(resource2);
                }
                org = build.getDirectory();
                if (org != (val2 = this.interpolate(org))) {
                    build.setDirectory(val2);
                }
                if ((org = build.getFinalName()) != (val2 = this.interpolate(org))) {
                    build.setFinalName(val2);
                }
                this.visit(build.getFilters());
            }
        }

        private void visit(PluginManagement pluginManagement) {
            if (pluginManagement != null) {
                for (Plugin plugin : pluginManagement.getPlugins()) {
                    this.visit(plugin);
                }
            }
        }

        private void visit(Build build) {
            if (build != null) {
                this.visit((BuildBase)build);
                String org = build.getSourceDirectory();
                String val2 = this.interpolate(org);
                if (org != val2) {
                    build.setSourceDirectory(val2);
                }
                if ((org = build.getScriptSourceDirectory()) != (val2 = this.interpolate(org))) {
                    build.setScriptSourceDirectory(val2);
                }
                if ((org = build.getTestSourceDirectory()) != (val2 = this.interpolate(org))) {
                    build.setTestSourceDirectory(val2);
                }
                if ((org = build.getOutputDirectory()) != (val2 = this.interpolate(org))) {
                    build.setOutputDirectory(val2);
                }
                if ((org = build.getTestOutputDirectory()) != (val2 = this.interpolate(org))) {
                    build.setTestOutputDirectory(val2);
                }
                for (Extension extension : build.getExtensions()) {
                    this.visit(extension);
                }
            }
        }

        private void visit(Resource resource2) {
            if (resource2 != null) {
                this.visit(resource2.getIncludes());
                this.visit(resource2.getExcludes());
                String org = resource2.getDirectory();
                String val2 = this.interpolate(org);
                if (org != val2) {
                    resource2.setDirectory(val2);
                }
                if ((org = resource2.getTargetPath()) != (val2 = this.interpolate(org))) {
                    resource2.setTargetPath(val2);
                }
                if ((org = resource2.getFiltering()) != (val2 = this.interpolate(org))) {
                    resource2.setFiltering(val2);
                }
            }
        }

        private void visit(Plugin plugin) {
            if (plugin != null) {
                String val2;
                String org = plugin.getInherited();
                if (org != (val2 = this.interpolate(org))) {
                    plugin.setInherited(val2);
                }
                this.visit((Xpp3Dom)plugin.getConfiguration());
                org = plugin.getGroupId();
                val2 = this.interpolate(org);
                if (org != val2) {
                    plugin.setGroupId(val2);
                }
                if ((org = plugin.getArtifactId()) != (val2 = this.interpolate(org))) {
                    plugin.setArtifactId(val2);
                }
                if ((org = plugin.getVersion()) != (val2 = this.interpolate(org))) {
                    plugin.setVersion(val2);
                }
                if ((org = plugin.getExtensions()) != (val2 = this.interpolate(org))) {
                    plugin.setExtensions(val2);
                }
                for (PluginExecution execution : plugin.getExecutions()) {
                    this.visit(execution);
                }
                for (Dependency dependency : plugin.getDependencies()) {
                    this.visit(dependency);
                }
            }
        }

        private void visit(PluginExecution execution) {
            if (execution != null) {
                String val2;
                String org = execution.getInherited();
                if (org != (val2 = this.interpolate(org))) {
                    execution.setInherited(val2);
                }
                this.visit((Xpp3Dom)execution.getConfiguration());
                org = execution.getId();
                val2 = this.interpolate(org);
                if (org != val2) {
                    execution.setId(val2);
                }
                if ((org = execution.getPhase()) != (val2 = this.interpolate(org))) {
                    execution.setPhase(val2);
                }
                this.visit(execution.getGoals());
            }
        }

        private void visit(Xpp3Dom dom) {
            if (dom != null) {
                String val2;
                String org = dom.getValue();
                if (org != (val2 = this.interpolate(org))) {
                    dom.setValue(val2);
                }
                for (String attr : dom.getAttributeNames()) {
                    org = dom.getAttribute(attr);
                    if (org == (val2 = this.interpolate(org))) continue;
                    dom.setAttribute(attr, val2);
                }
                int l = dom.getChildCount();
                for (int i = 0; i < l; ++i) {
                    this.visit(dom.getChild(i));
                }
            }
        }

        private void visit(Extension extension) {
            if (extension != null) {
                String val2;
                String org = extension.getGroupId();
                if (org != (val2 = this.interpolate(org))) {
                    extension.setGroupId(val2);
                }
                if ((org = extension.getArtifactId()) != (val2 = this.interpolate(org))) {
                    extension.setArtifactId(val2);
                }
                if ((org = extension.getVersion()) != (val2 = this.interpolate(org))) {
                    extension.setVersion(val2);
                }
            }
        }

        private void visit(Profile profile) {
            if (profile != null) {
                this.visit((ModelBase)profile);
                String org = profile.getId();
                String val2 = this.interpolate(org);
                if (org != val2) {
                    profile.setId(val2);
                }
                this.visit(profile.getActivation());
                this.visit(profile.getBuild());
            }
        }

        private void visit(Activation activation) {
            if (activation != null) {
                String val2;
                String org = activation.getJdk();
                if (org != (val2 = this.interpolate(org))) {
                    activation.setJdk(val2);
                }
                this.visit(activation.getOs());
                this.visit(activation.getProperty());
                this.visit(activation.getFile());
            }
        }

        private void visit(ActivationOS activationOS) {
            if (activationOS != null) {
                String val2;
                String org = activationOS.getName();
                if (org != (val2 = this.interpolate(org))) {
                    activationOS.setName(val2);
                }
                if ((org = activationOS.getFamily()) != (val2 = this.interpolate(org))) {
                    activationOS.setFamily(val2);
                }
                if ((org = activationOS.getArch()) != (val2 = this.interpolate(org))) {
                    activationOS.setArch(val2);
                }
                if ((org = activationOS.getVersion()) != (val2 = this.interpolate(org))) {
                    activationOS.setVersion(val2);
                }
            }
        }

        private void visit(ActivationProperty activationProperty) {
            if (activationProperty != null) {
                String val2;
                String org = activationProperty.getName();
                if (org != (val2 = this.interpolate(org))) {
                    activationProperty.setName(val2);
                }
                if ((org = activationProperty.getValue()) != (val2 = this.interpolate(org))) {
                    activationProperty.setValue(val2);
                }
            }
        }

        private void visit(ActivationFile activationFile) {
            if (activationFile != null) {
                String val2;
                String org = activationFile.getMissing();
                if (org != (val2 = this.interpolate(org))) {
                    activationFile.setMissing(val2);
                }
                if ((org = activationFile.getExists()) != (val2 = this.interpolate(org))) {
                    activationFile.setExists(val2);
                }
            }
        }

        private void visit(ModelBase modelBase) {
            if (modelBase != null) {
                this.visit(modelBase.getModules());
                this.visit(modelBase.getDistributionManagement());
                this.visit(modelBase.getProperties());
                this.visit(modelBase.getDependencyManagement());
                for (Dependency dependency : modelBase.getDependencies()) {
                    this.visit(dependency);
                }
                for (Repository repository : modelBase.getRepositories()) {
                    this.visit(repository);
                }
                for (Repository repository : modelBase.getPluginRepositories()) {
                    this.visit(repository);
                }
                this.visit(modelBase.getReporting());
            }
        }

        private void visit(DistributionManagement distributionManagement) {
            if (distributionManagement != null) {
                this.visit(distributionManagement.getRepository());
                this.visit(distributionManagement.getSnapshotRepository());
                this.visit(distributionManagement.getSite());
                String org = distributionManagement.getDownloadUrl();
                String val2 = this.interpolate(org);
                if (org != val2) {
                    distributionManagement.setDownloadUrl(val2);
                }
                this.visit(distributionManagement.getRelocation());
            }
        }

        private void visit(Site site) {
            if (site != null) {
                String val2;
                String org = site.getId();
                if (org != (val2 = this.interpolate(org))) {
                    site.setId(val2);
                }
                if ((org = site.getName()) != (val2 = this.interpolate(org))) {
                    site.setName(val2);
                }
                if ((org = site.getUrl()) != (val2 = this.interpolate(org))) {
                    site.setUrl(val2);
                }
                if ((org = site.getChildSiteUrlInheritAppendPath()) != (val2 = this.interpolate(org))) {
                    site.setChildSiteUrlInheritAppendPath(val2);
                }
            }
        }

        private void visit(Relocation relocation) {
            if (relocation != null) {
                String val2;
                String org = relocation.getGroupId();
                if (org != (val2 = this.interpolate(org))) {
                    relocation.setGroupId(val2);
                }
                if ((org = relocation.getArtifactId()) != (val2 = this.interpolate(org))) {
                    relocation.setArtifactId(val2);
                }
                if ((org = relocation.getVersion()) != (val2 = this.interpolate(org))) {
                    relocation.setVersion(val2);
                }
                if ((org = relocation.getMessage()) != (val2 = this.interpolate(org))) {
                    relocation.setMessage(val2);
                }
            }
        }

        private void visit(DependencyManagement dependencyManagement) {
            if (dependencyManagement != null) {
                for (Dependency dependency : dependencyManagement.getDependencies()) {
                    this.visit(dependency);
                }
            }
        }

        private void visit(Repository repository) {
            if (repository != null) {
                this.visit((RepositoryBase)repository);
                this.visit(repository.getReleases());
                this.visit(repository.getSnapshots());
            }
        }

        private void visit(RepositoryBase repositoryBase) {
            if (repositoryBase != null) {
                String intLayout;
                String orgLayout;
                String intUrl;
                String orgUrl;
                String intName;
                String orgName;
                String intId;
                String orgId = repositoryBase.getId();
                if (orgId != (intId = this.interpolate(orgId))) {
                    repositoryBase.setId(intId);
                }
                if ((orgName = repositoryBase.getName()) != (intName = this.interpolate(orgName))) {
                    repositoryBase.setName(intName);
                }
                if ((orgUrl = repositoryBase.getUrl()) != (intUrl = this.interpolate(orgUrl))) {
                    repositoryBase.setUrl(intUrl);
                }
                if ((orgLayout = repositoryBase.getLayout()) != (intLayout = this.interpolate(orgLayout))) {
                    repositoryBase.setLayout(intLayout);
                }
            }
        }

        private void visit(RepositoryPolicy repositoryPolicy) {
            if (repositoryPolicy != null) {
                String intChecksumPolicy;
                String orgChecksumPolicy;
                String intUpdatePolicy;
                String orgUpdatePolicy;
                String intEnabled;
                String orgEnabled = repositoryPolicy.getEnabled();
                if (orgEnabled != (intEnabled = this.interpolate(orgEnabled))) {
                    repositoryPolicy.setEnabled(intEnabled);
                }
                if ((orgUpdatePolicy = repositoryPolicy.getUpdatePolicy()) != (intUpdatePolicy = this.interpolate(orgUpdatePolicy))) {
                    repositoryPolicy.setUpdatePolicy(intUpdatePolicy);
                }
                if ((orgChecksumPolicy = repositoryPolicy.getChecksumPolicy()) != (intChecksumPolicy = this.interpolate(orgChecksumPolicy))) {
                    repositoryPolicy.setChecksumPolicy(intChecksumPolicy);
                }
            }
        }

        private void visit(Dependency dependency) {
            if (dependency != null) {
                String val2;
                String org = dependency.getGroupId();
                if (org != (val2 = this.interpolate(org))) {
                    dependency.setGroupId(val2);
                    dependency.clearManagementKey();
                }
                if ((org = dependency.getArtifactId()) != (val2 = this.interpolate(org))) {
                    dependency.setArtifactId(val2);
                    dependency.clearManagementKey();
                }
                if ((org = dependency.getVersion()) != (val2 = this.interpolate(org))) {
                    dependency.setVersion(val2);
                }
                if ((org = dependency.getType()) != (val2 = this.interpolate(org))) {
                    dependency.setType(val2);
                    dependency.clearManagementKey();
                }
                if ((org = dependency.getClassifier()) != (val2 = this.interpolate(org))) {
                    dependency.setClassifier(val2);
                    dependency.clearManagementKey();
                }
                if ((org = dependency.getScope()) != (val2 = this.interpolate(org))) {
                    dependency.setScope(val2);
                }
                if ((org = dependency.getSystemPath()) != (val2 = this.interpolate(org))) {
                    dependency.setSystemPath(val2);
                }
                for (Exclusion exclusion : dependency.getExclusions()) {
                    this.visit(exclusion);
                }
                org = dependency.getOptional();
                if (org != (val2 = this.interpolate(org))) {
                    dependency.setOptional(val2);
                }
            }
        }

        private void visit(Exclusion exclusion) {
            if (exclusion != null) {
                String val2;
                String org = exclusion.getGroupId();
                if (org != (val2 = this.interpolate(org))) {
                    exclusion.setGroupId(val2);
                }
                if ((org = exclusion.getArtifactId()) != (val2 = this.interpolate(org))) {
                    exclusion.setArtifactId(val2);
                }
            }
        }

        private void visit(Reporting reporting) {
            if (reporting != null) {
                String val2;
                String org = reporting.getExcludeDefaults();
                if (org != (val2 = this.interpolate(org))) {
                    reporting.setExcludeDefaults(val2);
                }
                if ((org = reporting.getOutputDirectory()) != (val2 = this.interpolate(org))) {
                    reporting.setOutputDirectory(val2);
                }
                for (ReportPlugin plugin : reporting.getPlugins()) {
                    this.visit(plugin);
                }
            }
        }

        private void visit(ReportPlugin plugin) {
            if (plugin != null) {
                String val2;
                String org = plugin.getInherited();
                if (org != (val2 = this.interpolate(org))) {
                    plugin.setInherited(val2);
                }
                this.visit((Xpp3Dom)plugin.getConfiguration());
                org = plugin.getGroupId();
                val2 = this.interpolate(org);
                if (org != val2) {
                    plugin.setGroupId(val2);
                }
                if ((org = plugin.getArtifactId()) != (val2 = this.interpolate(org))) {
                    plugin.setArtifactId(val2);
                }
                if ((org = plugin.getVersion()) != (val2 = this.interpolate(org))) {
                    plugin.setVersion(val2);
                }
                for (ReportSet reportSet : plugin.getReportSets()) {
                    this.visit(reportSet);
                }
            }
        }

        private void visit(ReportSet reportSet) {
            if (reportSet != null) {
                String val2;
                String org = reportSet.getInherited();
                if (org != (val2 = this.interpolate(org))) {
                    reportSet.setInherited(val2);
                }
                this.visit((Xpp3Dom)reportSet.getConfiguration());
                org = reportSet.getId();
                val2 = this.interpolate(org);
                if (org != val2) {
                    reportSet.setId(val2);
                }
                this.visit(reportSet.getReports());
            }
        }

        private void visit(Properties properties) {
            if (properties != null) {
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String inter;
                    String value;
                    Object v = entry.getValue();
                    if (!(v instanceof String) || (value = (String)v) == (inter = this.interpolate(value)) || inter == null) continue;
                    entry.setValue(inter);
                }
            }
        }

        private void visit(List<String> list) {
            if (list != null) {
                ListIterator<String> it = list.listIterator();
                while (it.hasNext()) {
                    String inter;
                    String value = it.next();
                    if (value == (inter = this.interpolate(value))) continue;
                    it.set(inter);
                }
            }
        }

        private String interpolate(String value) {
            return this.interpolator.interpolate(value);
        }
    }

    static interface InnerInterpolator {
        public String interpolate(String var1);
    }
}

