/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.io;

import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.io.OutputColorAccessorImpl;
import org.netbeans.modules.io.OutputColorAccessor;
import org.netbeans.spi.io.support.OutputColorType;

public abstract class OutputColor {
    private final OutputColorType type;
    private static final OutputColor CLR_WARNING = new TypeColor(OutputColorType.WARNING);
    private static final OutputColor CLR_FAILURE = new TypeColor(OutputColorType.FAILURE);
    private static final OutputColor CLR_DEBUG = new TypeColor(OutputColorType.DEBUG);
    private static final OutputColor CLR_SUCCESS = new TypeColor(OutputColorType.SUCCESS);

    private OutputColor(OutputColorType outputColorType) {
        this.type = outputColorType;
    }

    OutputColorType getType() {
        return this.type;
    }

    @NonNull
    public static OutputColor warning() {
        return CLR_WARNING;
    }

    @NonNull
    public static OutputColor failure() {
        return CLR_FAILURE;
    }

    @NonNull
    public static OutputColor debug() {
        return CLR_DEBUG;
    }

    @NonNull
    public static OutputColor success() {
        return CLR_SUCCESS;
    }

    @NonNull
    public static OutputColor rgb(int n, int n2, int n3) {
        OutputColor.checkColorComponentRange("r", n);
        OutputColor.checkColorComponentRange("g", n2);
        OutputColor.checkColorComponentRange("b", n3);
        int n4 = (n & 0xFF) << 16 | (n2 & 0xFF) << 8 | n3 & 0xFF;
        return OutputColor.rgb(n4);
    }

    @NonNull
    public static OutputColor rgb(int n) {
        return new RgbColor(n);
    }

    private static void checkColorComponentRange(String string, int n) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("Color component " + string + " is out of range (0 - 255): " + n);
        }
    }

    static {
        OutputColorAccessor.setDefault(new OutputColorAccessorImpl());
    }

    static class RgbColor
    extends OutputColor {
        private final int value;

        public RgbColor(int n) {
            super(OutputColorType.RGB);
            this.value = n;
        }

        public int getRGB() {
            return this.value;
        }
    }

    private static class TypeColor
    extends OutputColor {
        public TypeColor(OutputColorType outputColorType) {
            super(outputColorType);
        }
    }
}

