/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.diff;

import ca.sqlpower.diff.DiffChunk;
import ca.sqlpower.diff.DiffInfo;
import ca.sqlpower.sqlobject.SQLObjectException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DiffChunkTreeNode {
    private String uuid;
    private DiffChunk<DiffInfo> chunk;
    private HashMap<String, DiffChunkTreeNode> children;

    public DiffChunkTreeNode(String uuid, DiffChunk<DiffInfo> chunk) {
        this.uuid = uuid;
        this.chunk = chunk;
        this.children = new HashMap();
    }

    public void addChild(String uuid, DiffChunk<DiffInfo> chunk) {
        this.children.put(uuid, new DiffChunkTreeNode(uuid, chunk));
    }

    public boolean addChildToNode(String childUUID, DiffChunk<DiffInfo> chunk, String nodeUUID) {
        if (this.uuid.equals(nodeUUID)) {
            this.addChild(childUUID, chunk);
            return true;
        }
        Iterator<String> keys = this.children.keySet().iterator();
        while (keys.hasNext()) {
            if (!this.children.get(keys.next()).addChildToNode(childUUID, chunk, nodeUUID)) continue;
            return true;
        }
        return false;
    }

    public List<DiffChunk<DiffInfo>> buildOrderedList() {
        ArrayList<DiffChunk<DiffInfo>> diffChunks = new ArrayList<DiffChunk<DiffInfo>>();
        this.buildOrderedList(diffChunks, -1);
        return diffChunks;
    }

    private void buildOrderedList(List<DiffChunk<DiffInfo>> diffChunks, int depth) {
        if (this.chunk != null) {
            this.chunk.getData().setDepth(depth);
            diffChunks.add(this.chunk);
        }
        Iterator<String> keys = this.children.keySet().iterator();
        while (keys.hasNext()) {
            this.children.get(keys.next()).buildOrderedList(diffChunks, depth + 1);
        }
    }

    public void constructTree(Map<String, DiffChunk<DiffInfo>> diffChunks, Map<String, String> parentMap) throws SQLObjectException {
        HashSet<String> uuidsInTree = new HashSet<String>();
        uuidsInTree.add(this.uuid);
        for (String uuid : parentMap.keySet()) {
            ArrayList<String> addToTree = new ArrayList<String>();
            String nextUUID = uuid;
            while (!nextUUID.equals(this.uuid) && !uuidsInTree.contains(nextUUID)) {
                addToTree.add(nextUUID);
                nextUUID = parentMap.get(nextUUID);
            }
            for (int i = addToTree.size() - 1; i >= 0; --i) {
                String u = (String)addToTree.get(i);
                if (!this.addChildToNode(u, diffChunks.get(u), parentMap.get(u))) {
                    throw new SQLObjectException("Error adding DiffChunks to tree");
                }
                uuidsInTree.add(u);
            }
        }
    }
}

