/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import ca.sqlpower.swingui.Messages;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.util.UserPrompter;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class DialogUserPrompter
implements UserPrompter {
    private static Logger logger = Logger.getLogger(DialogUserPrompter.class);
    private JDialog confirmDialog;
    private JFrame owner;
    private final JTextComponent questionField;
    private final MessageFormat questionFormat;
    private UserPrompter.UserPromptResponse response;
    private final JCheckBox applyToAll;
    private boolean firstPrompt = true;
    private final UserPrompter.UserPromptResponse defaultResponseType;

    public DialogUserPrompter(UserPrompter.UserPromptOptions optionType, UserPrompter.UserPromptResponse defaultResponseType, JFrame owner, String questionMessage, String ... buttonNames) {
        this(optionType, defaultResponseType, owner, questionMessage, true, buttonNames);
    }

    public DialogUserPrompter(UserPrompter.UserPromptOptions optionType, UserPrompter.UserPromptResponse defaultResponseType, JFrame owner, String questionMessage, boolean modal, String ... buttonNames) {
        if (optionType.getButtonCount() != buttonNames.length) {
            throw new IllegalStateException("Expecting " + optionType.getButtonCount() + " arguments for the optionType " + (Object)((Object)optionType) + "Recieved only " + buttonNames.length + "arguments\n" + Arrays.toString(buttonNames));
        }
        this.defaultResponseType = defaultResponseType;
        this.owner = owner;
        this.applyToAll = new JCheckBox(Messages.getString("ModalDialogUserPrompter.applyToAllOption"));
        this.confirmDialog = new JDialog(owner);
        this.confirmDialog.setTitle("");
        if (questionMessage.startsWith("<html>")) {
            this.questionField = new JEditorPane();
            this.questionField.setText(questionMessage);
            ((JEditorPane)this.questionField).setContentType("text/html");
            this.questionField.setFont(new JTextArea().getFont());
        } else {
            this.questionField = new JTextArea(questionMessage);
        }
        this.questionField.setEditable(false);
        this.questionField.setBackground(null);
        this.questionFormat = new MessageFormat(questionMessage);
        JPanel confirmPanel = new JPanel();
        FormLayout formLayout = new FormLayout("10dlu, 2dlu, pref:grow, 2dlu, 10dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(formLayout, confirmPanel);
        builder.setDefaultDialogBorder();
        builder.nextColumn(2);
        builder.append((Component)this.questionField);
        builder.nextLine();
        builder.appendParagraphGapRow();
        builder.nextLine();
        ButtonBarBuilder buttonBar = new ButtonBarBuilder();
        buttonBar.addGlue();
        JButton okButton = new JButton();
        if (optionType == UserPrompter.UserPromptOptions.OK_NEW_NOTOK_CANCEL || optionType == UserPrompter.UserPromptOptions.OK_NOTOK_CANCEL || optionType == UserPrompter.UserPromptOptions.OK_NEW_CANCEL || optionType == UserPrompter.UserPromptOptions.OK_CANCEL || optionType == UserPrompter.UserPromptOptions.OK) {
            okButton.setText(buttonNames[0]);
            buttonBar.addGridded((JComponent)okButton);
        }
        JButton notOkButton = new JButton();
        if (optionType == UserPrompter.UserPromptOptions.OK_NEW_NOTOK_CANCEL || optionType == UserPrompter.UserPromptOptions.OK_NOTOK_CANCEL) {
            buttonBar.addRelatedGap();
            notOkButton.setText(optionType == UserPrompter.UserPromptOptions.OK_NOTOK_CANCEL ? buttonNames[1] : buttonNames[2]);
            buttonBar.addGridded((JComponent)notOkButton);
        }
        JButton cancelButton = new JButton();
        if (optionType == UserPrompter.UserPromptOptions.OK_NEW_NOTOK_CANCEL || optionType == UserPrompter.UserPromptOptions.OK_NOTOK_CANCEL || optionType == UserPrompter.UserPromptOptions.OK_NEW_CANCEL || optionType == UserPrompter.UserPromptOptions.OK_CANCEL) {
            buttonBar.addRelatedGap();
            cancelButton.setText(buttonNames[buttonNames.length - 1]);
            buttonBar.addGridded((JComponent)cancelButton);
        }
        buttonBar.addGlue();
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogUserPrompter.this.response = UserPrompter.UserPromptResponse.OK;
                DialogUserPrompter.this.confirmDialog.dispose();
            }
        });
        notOkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogUserPrompter.this.response = UserPrompter.UserPromptResponse.NOT_OK;
                DialogUserPrompter.this.confirmDialog.dispose();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogUserPrompter.this.response = UserPrompter.UserPromptResponse.CANCEL;
                DialogUserPrompter.this.confirmDialog.dispose();
            }
        });
        builder.append("");
        builder.append((Component)buttonBar.getPanel());
        builder.nextLine();
        builder.append("");
        builder.append((Component)this.applyToAll);
        switch (defaultResponseType) {
            case OK: {
                okButton.requestFocusInWindow();
                break;
            }
            case NOT_OK: {
                notOkButton.requestFocusInWindow();
                break;
            }
            case CANCEL: {
                cancelButton.requestFocusInWindow();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Default response type : " + (Object)((Object)defaultResponseType) + " is not known");
            }
        }
        this.confirmDialog.setModal(modal);
        this.confirmDialog.add(builder.getPanel());
    }

    @Override
    public UserPrompter.UserPromptResponse promptUser(final Object ... formatArgs) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Prompting user. Format Args: " + Arrays.asList(formatArgs)));
        }
        if (this.applyToAll.isSelected()) {
            return this.response;
        }
        this.response = this.defaultResponseType;
        Runnable promptUser = new Runnable(){

            @Override
            public void run() {
                DialogUserPrompter.this.questionField.setText(DialogUserPrompter.this.questionFormat.format(formatArgs));
                if (DialogUserPrompter.this.firstPrompt) {
                    DialogUserPrompter.this.confirmDialog.pack();
                    DialogUserPrompter.this.confirmDialog.setLocationRelativeTo(DialogUserPrompter.this.owner);
                    DialogUserPrompter.this.firstPrompt = false;
                }
                DialogUserPrompter.this.confirmDialog.setVisible(true);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            promptUser.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(promptUser);
            }
            catch (InterruptedException e) {
                SPSUtils.showExceptionDialogNoReport(this.owner, Messages.getString("ModalDialogUserPrompter.showPromptDialogFailed"), e);
            }
            catch (InvocationTargetException e) {
                SPSUtils.showExceptionDialogNoReport(this.owner, Messages.getString("ModalDialogUserPrompter.showPromptDialogFailed"), e);
            }
        }
        return this.response;
    }

    @Override
    public Object getUserSelectedResponse() {
        if (this.response == UserPrompter.UserPromptResponse.OK) {
            return true;
        }
        return false;
    }
}

