/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.tableexists;

import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.tableexists.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryTableExists
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String tablename;
    private String schemaname;
    private DatabaseMeta connection;

    public JobEntryTableExists(String n) {
        super(n, "");
        this.schemaname = null;
        this.tablename = null;
        this.connection = null;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.TABLE_EXISTS);
    }

    public JobEntryTableExists() {
        this("");
    }

    public JobEntryTableExists(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryTableExists je = (JobEntryTableExists)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"tablename", (String)this.tablename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"schemaname", (String)this.schemaname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"connection", this.connection == null ? null : this.connection.getName()));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.tablename = XMLHandler.getTagValue((Node)entrynode, (String)"tablename");
            this.schemaname = XMLHandler.getTagValue((Node)entrynode, (String)"schemaname");
            String dbname = XMLHandler.getTagValue((Node)entrynode, (String)"connection");
            this.connection = DatabaseMeta.findDatabase(databases, (String)dbname);
        }
        catch (KettleException e) {
            throw new KettleXMLException(Messages.getString("TableExists.Meta.UnableLoadXml"), (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.tablename = rep.getJobEntryAttributeString(id_jobentry, "tablename");
            this.schemaname = rep.getJobEntryAttributeString(id_jobentry, "schemaname");
            long id_db = rep.getJobEntryAttributeInteger(id_jobentry, "id_database");
            this.connection = id_db > 0L ? DatabaseMeta.findDatabase(databases, (long)id_db) : DatabaseMeta.findDatabase(databases, (String)rep.getJobEntryAttributeString(id_jobentry, "connection"));
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("TableExists.Meta.UnableLoadRep", "" + id_jobentry), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "tablename", this.tablename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "schemaname", this.schemaname);
            if (this.connection != null) {
                rep.saveJobEntryAttribute(id_job, this.getID(), "connection", this.connection.getName());
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("TableExists.Meta.UnableSaveRep", "" + id_job), (Throwable)dbe);
        }
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public String getTablename() {
        return this.tablename;
    }

    public String getSchemaname() {
        return this.schemaname;
    }

    public void setSchemaname(String schemaname) {
        this.schemaname = schemaname;
    }

    public void setDatabase(DatabaseMeta database) {
        this.connection = database;
    }

    public DatabaseMeta getDatabase() {
        return this.connection;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        LogWriter log = LogWriter.getInstance();
        Result result = previousResult;
        result.setResult(false);
        if (this.connection != null) {
            Database db;
            block14: {
                db = new Database(this.connection);
                db.shareVariablesWith((VariableSpace)this);
                db.connect();
                String realTablename = this.environmentSubstitute(this.tablename);
                String realSchemaname = this.environmentSubstitute(this.schemaname);
                if (!Const.isEmpty((String)realSchemaname)) {
                    realTablename = db.getDatabaseMeta().getQuotedSchemaTableCombination(realSchemaname, realTablename);
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("TableExists.Log.SchemaTable", realTablename), new Object[0]);
                    }
                } else {
                    realTablename = db.getDatabaseMeta().quoteField(realTablename);
                }
                if (db.checkTableExists(realTablename)) {
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("TableExists.Log.TableExists", realTablename), new Object[0]);
                    }
                    result.setResult(true);
                    break block14;
                }
                if (!log.isDetailed()) break block14;
                log.logDetailed(this.toString(), Messages.getString("TableExists.Log.TableNotExists", realTablename), new Object[0]);
            }
            Object var11_11 = null;
            if (db == null) return result;
            try {
                db.disconnect();
                return result;
            }
            catch (Exception e) {}
            return result;
            {
                catch (KettleDatabaseException dbe) {
                    result.setNrErrors(1L);
                    log.logError(this.toString(), Messages.getString("TableExists.Error.RunningJobEntry", dbe.getMessage()), new Object[0]);
                    Object var11_12 = null;
                    if (db == null) return result;
                    try {
                        db.disconnect();
                        return result;
                    }
                    catch (Exception e) {}
                    return result;
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (db == null) throw throwable;
                try {
                    db.disconnect();
                    throw throwable;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        result.setNrErrors(1L);
        log.logError(this.toString(), Messages.getString("TableExists.Error.NoConnectionDefined"), new Object[0]);
        return result;
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[]{this.connection};
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (this.connection != null) {
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(this.connection.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(this.connection.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "tablename", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }
}

