/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl;

import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.GenericDDLGenerator;
import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.JDBCDataSourceType;
import ca.sqlpower.sqlobject.SQLTable;
import java.lang.reflect.Modifier;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DDLUtils {
    private static final Logger logger = Logger.getLogger(DDLUtils.class);
    private static final Class<? extends DDLGenerator> DEFAULT_DDL_GENERATOR_CLASS = GenericDDLGenerator.class;

    private DDLUtils() {
    }

    public static String toQualifiedName(SQLTable table) {
        return DDLUtils.toQualifiedName(table.getCatalogName(), table.getSchemaName(), table.getName());
    }

    public static String toQualifiedName(String catalog, String schema, String name) {
        StringBuffer qualName = new StringBuffer();
        if (catalog != null && catalog.length() > 0) {
            qualName.append(catalog);
            qualName.append(".");
        }
        if (schema != null && schema.length() > 0) {
            qualName.append(schema);
            qualName.append(".");
        }
        qualName.append(name);
        logger.debug((Object)String.format("%s.%s.%s -> %s", catalog, schema, name, qualName));
        return qualName.toString();
    }

    public static String toQualifiedName(String catalog, String schema, String name, String openQuote, String closeQuote) {
        String newCatalog = null;
        String newSchema = null;
        String newName = null;
        if (catalog != null && catalog.length() > 0) {
            newCatalog = openQuote != null && openQuote.length() > 0 && closeQuote != null && closeQuote.length() > 0 ? openQuote + catalog + closeQuote : (openQuote != null && openQuote.length() > 0 ? openQuote + catalog : catalog);
        }
        if (schema != null && schema.length() > 0) {
            newSchema = openQuote != null && openQuote.length() > 0 && closeQuote != null && closeQuote.length() > 0 ? openQuote + schema + closeQuote : (openQuote != null && openQuote.length() > 0 ? openQuote + schema : schema);
        }
        newName = openQuote != null && openQuote.length() > 0 && closeQuote != null && closeQuote.length() > 0 ? openQuote + name + closeQuote : (openQuote != null && openQuote.length() > 0 ? openQuote + name : name);
        return DDLUtils.toQualifiedName(newCatalog, newSchema, newName);
    }

    public static Vector<Class<? extends DDLGenerator>> getDDLTypes(DataSourceCollection<JDBCDataSource> dsc) {
        Vector<Class<? extends DDLGenerator>> dbTypeList = new Vector<Class<? extends DDLGenerator>>();
        for (JDBCDataSourceType dst : dsc.getDataSourceTypes()) {
            if (dst.getDDLGeneratorClass() == null) continue;
            try {
                Class<?> loadedClass = Class.forName(dst.getDDLGeneratorClass(), true, DDLUtils.class.getClassLoader());
                Class<DDLGenerator> ddlgClass = loadedClass.asSubclass(DDLGenerator.class);
                if (dbTypeList.contains(ddlgClass) || Modifier.isAbstract(ddlgClass.getModifiers())) continue;
                dbTypeList.add(ddlgClass);
            }
            catch (Exception e) {
                logger.warn((Object)("Couldn't initialize DDL Generator class " + dst.getDDLGeneratorClass() + " specified in database type " + dst.getName() + ". Skipping it."));
            }
        }
        return dbTypeList;
    }

    public static DDLGenerator createDDLGenerator(JDBCDataSource ads) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String className = ads.getParentType().getDDLGeneratorClass();
        Class<DDLGenerator> generatorClass = className != null ? Class.forName(className, true, DDLUtils.class.getClassLoader()) : DEFAULT_DDL_GENERATOR_CLASS;
        return generatorClass.newInstance();
    }
}

